//! Command line app generated by clap.
use clap::{Arg, App, AppSettings};
use crate::version::VERSION;
use regex::Regex;

/// Create and return the Wright command line app via [clap.rs](https://clap.rs)
pub fn get_wright_app<'a, 'b>() -> App<'a, 'b> {
    App::new("Wright")
        .setting(AppSettings::ColorAlways)
        .version(VERSION)
        .author("Antonia Calia-Bogan (github.com/Alfriadox)")
        .about("The Wright programming language interpreter and compiler.")
        .arg(Arg::with_name("INPUT")
            .help("Input wright file(s).")
            .required(true)
            .multiple(true)
            .validator(is_valid_wright_file_name)
        )
        .arg(Arg::with_name("RUN")
            .help("Runs input wright file rather than compiling it.")
            .case_insensitive(true)
            .short("r")
            .long("run")
        )
        .arg(Arg::with_name("EMIT")
            .short("e")
            .long("emit")
            .help("Prints intermediate representation(s).")
            .takes_value(true)
            .possible_values(&["tokens", "ast"])
            .use_delimiter(true)
            .multiple(true)
        )
        .arg(Arg::with_name("VERBOSE")
            .short("v")
            .long("verbose")
            .help("Prints additional information about program execution.")
        )
}


fn is_valid_wright_file_name(s: String) -> Result<(), String> {
    let re: Regex = Regex::new(r"[[:word:]]+.wr$|[[:word:]]+.wright$").unwrap(); 
    match re.is_match(s.as_str()) {
        true => Ok(()),
        false => Err(format!("Wright file names can only contain alphanumerics and underscores and \
        must end with .wr or .wright. ({} does not.)", s)),
    }
}
