use clap::ArgMatches;
use std::io::{self, prelude::*, BufRead};
use windsh_core::history::History;

pub(crate) fn setup(args: &ArgMatches) {
    loop {
        let mut line = String::new();
        let stdin = io::stdin();

        print!("-| ");
        io::stdout().flush().unwrap();

        match stdin.lock().read_line(&mut line) {
            Ok(_) => println!("{}", line),
            Err(err) => println!("{}", err),
        }

        if !args.is_present("private")
            && args.value_of("history file").unwrap() != ""
        {
            History::from(line.as_str()).save(args.value_of("history file"));
        } else if !args.is_present("private") {
            History::from(line.as_str()).save(None);
        }
    }
}
