mod commands;

use clap::{App, Arg, SubCommand};
use std::env;
use windsh_core::dirs::WindshDirs;

fn main() {
    WindshDirs::load().verify();

    const APP_VERSION: &'static str = env!("CARGO_PKG_VERSION");
    const APP_DESCRIPTION: &'static str = env!("CARGO_PKG_DESCRIPTION");

    let global_and_start_args = vec![
        Arg::with_name("Settings file")
            .help("Sets a custom config file")
            .short("c")
            .long("config")
            .value_name("FILE")
            .takes_value(true),
        Arg::with_name("Private session")
            .help("Create a new private windsh session")
            .long("private")
            .required(false)
            .takes_value(false),
        Arg::with_name("history file")
            .help("Set a custom history file")
            .long("history-file")
            .value_name("FILE")
            .takes_value(true),
    ];

    let matches = App::new("windsh")
        .version(APP_VERSION)
        .about(APP_DESCRIPTION)
        .args(&global_and_start_args)
        .subcommand(
            SubCommand::with_name("start")
                .about("Create a new windsh session")
                .version(APP_VERSION)
                .args(&global_and_start_args),
        )
        .get_matches();

    match matches.subcommand() {
        ("start", Some(args)) => commands::start::setup(args),
        _ => commands::start::setup(&matches),
    }
}
