mod commands;

use clap::{App, Arg, SubCommand};
use std::env;
use windsh_core::{
    dirs::WindshDirs,
    logs::{Log, LogLevel},
};

fn main() {
    WindshDirs::load().verify();

    let crate_version: String =
        env::var("CARGO_PKG_VERSION").unwrap_or(String::from("1.0.0"));
    let crate_authors: String =
        env::var("CARGO_PKG_AUTHORS").unwrap_or(String::from("Authors"));
    let crate_name: String =
        env::var("CARGO_PKG_NAME").unwrap_or(String::from("Shell"));
    let crate_description: String = env::var("CARGO_PKG_DESCRIPTION")
        .unwrap_or(String::from("A cross-platform shell."));

    let matches = App::new(crate_name.as_str())
        .version(crate_version.as_str())
        .author(crate_authors.replace(":", "\n").as_str())
        .about(crate_description.as_str())
        .arg(
            Arg::with_name("config")
                .short("c")
                .long("config")
                .value_name("FILE")
                .help("Sets a custom config file")
                .takes_value(true),
        )
        .subcommand(
            SubCommand::with_name("start")
                .about("Create a new windsh session")
                .version(crate_version.as_str())
                .arg(
                    Arg::with_name("private")
                        .help("Create a new private windsh session")
                        .long("private")
                        .required(false)
                        .takes_value(false),
                ),
        )
        .get_matches();

    match matches.subcommand() {
        ("start", Some(args)) => commands::start::setup(args),
        _ => Log::new(LogLevel::Warning, 0, "Subcommand not found").show(),
    }
}
