use clap::ArgMatches;
use std::io::{self, BufRead};
use windsh_core::history::History;

pub(crate) fn setup(args: &ArgMatches) {
    loop {
        let mut line = String::new();
        let stdin = io::stdin();
        stdin.read_line(&mut line).unwrap();
        println!("{}", line);

        if !args.is_present("private") {
            History::new(line.as_str()).save(None);
        }
    }
}
