# waitcache
The `waitcache` crate provides the type `WaitCache<K, V>`, an ever-growing concurrent hash map with
key-level locking granularity. A hash map of this kind is useful for memoizing highly expensive
functions, such as those requiring disk or network accesses. Unlike other cache implementations,
`WaitCache` only ever resolves a value once, preventing expensive computations from duplicating
work.

# Documentation
Inline rustdoc documentation is available. A mirror of this documentation is available at
<https://docs.rs/waitcache>.

# Contributing
`waitcache` is developed at [GitLab].

Reasonable performance, correctness, documentation, and ease-of-use contributions are always
welcome. [Bug reports][Issues] and feature suggestions are accepted through GitLab.

## Pull Requests
Please ensure pull requests match the existing coding style and are formatted with rustfmt.

Spelling and grammatical errors are considered bugs, so please use spell-checking facilities prior
to submitting a contribution.

## Contribution Agreement
By contributing, you grant all contributors a perpetual, worldwide, non-exclusive, no-charge,
royalty-free, irrevocable copyright license to reproduce, prepare derivative works of, publicly
display, publicly perform, relicense, sublicense, and distribute your contributions.

Additionally, you affirm that you are legally entitled to grant such license and that your
contributions are not and will not become patent-encumbered. In the event that you discover that
such affirmation was made in error, you agree to post notice of such error in a conspicuous place
(such as a [GitLab Issue][Issues]) within three days.

# License
`waitcache` is licensed under the terms of the [Mozilla Public License, v. 2.0][MPL]. All Source Code
Forms are "Incompatible With Secondary Licenses", as described in *§3.3* of the license.

The corresponding SPDX license identifier is [`MPL-2.0-no-copyleft-exception`][SPDX].

# Copyright
This document is Copyright (C) 2020 Nathan Sharp.

Permission is granted to reproduce this document, in any form, free of charge. The source code form
of this document is subject to the terms of the Mozilla Public License, v. 2.0.

[GitLab]: https://gitlab.com/nwsharp/waitcache
[Issues]: https://gitlab.com/nwsharp/waitcache/-/issues
[MPL]: https://mozilla.org/MPL/2.0
[SPDX]: https://spdx.org/licenses/MPL-2.0-no-copyleft-exception.html
