# Changelog

## v0.4.0

### Added

- `Vector` struct `enumerate` method for enumeration over (index, value) tuples
- `Vector` struct `product` method for element-wise products (supports int, float, and complex number types)
- `Vector` struct `sum` method for element-wise sums (supports int, float, and complex number types)
- `Vector::product` Criterion benchmark tests

### Changed

- None

## v0.3.1

### Added

- None

### Changed

- docs: Getting Started guide: updated integer overflow / underflow text
- docs: Getting Started guide: typo fix

## v0.3.0

### Added

- `Vector` struct complex number support with the `num::Complex` data type
- PartialEq trait implementation for `Vector` of `num::Complex` types with integer real and imaginary parts
- PartialEq trait implementation for `Vector` of `num::Complex` types with floating point real and imaginary parts
- AbsDiffEq trait implementation for `Vector` of `num::Complex` types with floating point real and imaginary parts
- RelativeEq trait implementation for `Vector` of `num::Complex` types with floating point real and imaginary parts
- UlpsEq trait implementation for `Vector` of `num::Complex` types with floating point real and imaginary parts
- Mul trait implementation to support `Vector` of `num::Complex` types scalar multiplication with integer scalar values
- Mul trait implementation to support `Vector` of `num::Complex` types scalar multiplication with floating point scalar values
- Lossless `Vector` of `num::Complex` types unsigned integer to signed integer real and imaginary part cast support
- Lossless `Vector` of `num::Complex` types signed integer to signed integer real and imaginary part cast support
- Lossless `Vector` of `num::Complex` types unsigned integer to unsigned integer real and imaginary part cast support
- Lossless `Vector` of `num::Complex` types unsigned integer to signed integer real and imaginary part cast support
- Lossless `Vector` of `num::Complex` types unsigned integer to float real and imaginary part cast support
- Lossless `Vector` of `num::Complex` types signed integer to float real and imaginary part cast support
- Lossless `Vector` `f32` to `f64` floating point type cast support

### Changed

- refactor Neg trait implementation to support `Vector` of `num::Complex` types
- docs: Getting Started guide: major revision to document the new support for `Vector` of complex numbers
- docs: Getting Started guide: added new`Vector` unary negation operator documentation
- docs: API: major revision to document the new support for `Vector` of complex numbers
- docs: API: updated Vector `dot` method documentation to indicate that the method is not intended for complex number types
- docs: API: updated Vector `Float` trait bound methods documentation to indicate that these methods are intended for real, floating point types
- docs: README: minor revisions to document the new support for `Vector` of complex numbers

## v0.2.1

### Added

- integer and float Vector PartialEq testing with `==` operator benchmarks
- rustc nightly toolchain CI testing on Ubuntu Linux, macOS, and Windows
- scheduled nightly CI testing with rustc stable, beta, and nightly toolchains on Ubuntu Linux, macOS, and Windows

### Changed

- minor documentation updates

## v0.2.0

### Added

- customizable f32 and f64 `Vector` absolute epsilon difference partial equivalence relation support (#11)
- customizable f32 and f64 `Vector` relative epsilon difference partial equivalence relation support (#11)
- customizable f32 and f64 `Vector` units in last place (ULPs) difference partial equivalence relation support (#11)
- `Vector` initialization Criterion benchmarks (#6, #9)

### Changed

- `Vector` initialization with std lib `Vec` reference types execution time improvement (#7)

## v0.1.3

### Added

- Minimum Rust version compatibility policy added to the `lib.rs` (docs.rs/vectora) and source repository README documentation

### Changed

- None

## v0.1.2

### Added

- None

### Changed

- typo fixes in the source documentation

## v0.1.1

### Added

- how to add vectora package to Cargo.toml dependencies documentation
- maintainer documentation

### Changed

- source cleanup: removed unused, commented out imports
- src/lib.rs documentation revisions
- README.md documentation revisions and formatting

## v0.1.0

- initial release
