#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 12
#define STATE_COUNT 1104
#define LARGE_STATE_COUNT 96
#define SYMBOL_COUNT 227
#define ALIAS_COUNT 0
#define TOKEN_COUNT 101
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 25
#define MAX_ALIAS_SEQUENCE_LENGTH 9

enum {
  sym_identifier = 1,
  anon_sym_import = 2,
  anon_sym_DOT = 3,
  anon_sym_from = 4,
  anon_sym___future__ = 5,
  anon_sym_LPAREN = 6,
  anon_sym_RPAREN = 7,
  anon_sym_COMMA = 8,
  anon_sym_as = 9,
  anon_sym_STAR = 10,
  anon_sym_print = 11,
  anon_sym_GT_GT = 12,
  anon_sym_assert = 13,
  anon_sym_COLON_EQ = 14,
  anon_sym_return = 15,
  anon_sym_del = 16,
  anon_sym_raise = 17,
  anon_sym_pass = 18,
  anon_sym_break = 19,
  anon_sym_continue = 20,
  anon_sym_if = 21,
  anon_sym_COLON = 22,
  anon_sym_elif = 23,
  anon_sym_else = 24,
  anon_sym_async = 25,
  anon_sym_for = 26,
  anon_sym_in = 27,
  anon_sym_while = 28,
  anon_sym_try = 29,
  anon_sym_except = 30,
  anon_sym_finally = 31,
  anon_sym_with = 32,
  anon_sym_def = 33,
  anon_sym_DASH_GT = 34,
  anon_sym_LBRACK = 35,
  anon_sym_RBRACK = 36,
  anon_sym_EQ = 37,
  anon_sym_STAR_STAR = 38,
  anon_sym_global = 39,
  anon_sym_nonlocal = 40,
  anon_sym_exec = 41,
  anon_sym_class = 42,
  anon_sym_AT = 43,
  anon_sym_not = 44,
  anon_sym_and = 45,
  anon_sym_or = 46,
  anon_sym_PLUS = 47,
  anon_sym_DASH = 48,
  anon_sym_SLASH = 49,
  anon_sym_PERCENT = 50,
  anon_sym_SLASH_SLASH = 51,
  anon_sym_PIPE = 52,
  anon_sym_AMP = 53,
  anon_sym_CARET = 54,
  anon_sym_LT_LT = 55,
  anon_sym_TILDE = 56,
  anon_sym_LT = 57,
  anon_sym_LT_EQ = 58,
  anon_sym_EQ_EQ = 59,
  anon_sym_BANG_EQ = 60,
  anon_sym_GT_EQ = 61,
  anon_sym_GT = 62,
  anon_sym_LT_GT = 63,
  anon_sym_is = 64,
  anon_sym_lambda = 65,
  anon_sym_PLUS_EQ = 66,
  anon_sym_DASH_EQ = 67,
  anon_sym_STAR_EQ = 68,
  anon_sym_SLASH_EQ = 69,
  anon_sym_AT_EQ = 70,
  anon_sym_SLASH_SLASH_EQ = 71,
  anon_sym_PERCENT_EQ = 72,
  anon_sym_STAR_STAR_EQ = 73,
  anon_sym_GT_GT_EQ = 74,
  anon_sym_LT_LT_EQ = 75,
  anon_sym_AMP_EQ = 76,
  anon_sym_CARET_EQ = 77,
  anon_sym_PIPE_EQ = 78,
  anon_sym_yield = 79,
  sym_ellipsis = 80,
  anon_sym_LBRACE = 81,
  anon_sym_RBRACE = 82,
  sym_escape_sequence = 83,
  sym__not_escape_sequence = 84,
  aux_sym_format_specifier_token1 = 85,
  sym_type_conversion = 86,
  sym_integer = 87,
  sym_float = 88,
  sym_true = 89,
  sym_false = 90,
  sym_none = 91,
  anon_sym_await = 92,
  sym_comment = 93,
  sym__semicolon = 94,
  sym__newline = 95,
  sym__indent = 96,
  sym__dedent = 97,
  sym__string_start = 98,
  sym__string_content = 99,
  sym__string_end = 100,
  sym_module = 101,
  sym__statement = 102,
  sym__simple_statements = 103,
  sym_import_statement = 104,
  sym_import_prefix = 105,
  sym_relative_import = 106,
  sym_future_import_statement = 107,
  sym_import_from_statement = 108,
  sym__import_list = 109,
  sym_aliased_import = 110,
  sym_wildcard_import = 111,
  sym_print_statement = 112,
  sym_chevron = 113,
  sym_assert_statement = 114,
  sym_expression_statement = 115,
  sym_named_expression = 116,
  sym_return_statement = 117,
  sym_delete_statement = 118,
  sym_raise_statement = 119,
  sym_pass_statement = 120,
  sym_break_statement = 121,
  sym_continue_statement = 122,
  sym_if_statement = 123,
  sym_elif_clause = 124,
  sym_else_clause = 125,
  sym_for_statement = 126,
  sym_while_statement = 127,
  sym_try_statement = 128,
  sym_except_clause = 129,
  sym_finally_clause = 130,
  sym_with_statement = 131,
  sym_with_item = 132,
  sym_function_definition = 133,
  sym_parameters = 134,
  sym_lambda_parameters = 135,
  sym__parameters = 136,
  sym__patterns = 137,
  sym_parameter = 138,
  sym_pattern = 139,
  sym_tuple_pattern = 140,
  sym_list_pattern = 141,
  sym_default_parameter = 142,
  sym_typed_default_parameter = 143,
  sym_list_splat_pattern = 144,
  sym_dictionary_splat_pattern = 145,
  sym_list_splat = 146,
  sym_dictionary_splat = 147,
  sym_global_statement = 148,
  sym_nonlocal_statement = 149,
  sym_exec_statement = 150,
  sym_class_definition = 151,
  sym_parenthesized_list_splat = 152,
  sym_argument_list = 153,
  sym_decorated_definition = 154,
  sym_decorator = 155,
  sym_block = 156,
  sym_expression_list = 157,
  sym_dotted_name = 158,
  sym__expression_within_for_in_clause = 159,
  sym_expression = 160,
  sym_primary_expression = 161,
  sym_not_operator = 162,
  sym_boolean_operator = 163,
  sym_binary_operator = 164,
  sym_unary_operator = 165,
  sym_comparison_operator = 166,
  sym_lambda = 167,
  sym_lambda_within_for_in_clause = 168,
  sym_assignment = 169,
  sym_augmented_assignment = 170,
  sym_left_hand_side = 171,
  sym__right_hand_side = 172,
  sym_yield = 173,
  sym_attribute = 174,
  sym_subscript = 175,
  sym_slice = 176,
  sym_call = 177,
  sym_typed_parameter = 178,
  sym_type = 179,
  sym_keyword_argument = 180,
  sym_list = 181,
  sym__comprehension_clauses = 182,
  sym_list_comprehension = 183,
  sym_dictionary = 184,
  sym_dictionary_comprehension = 185,
  sym_pair = 186,
  sym_set = 187,
  sym_set_comprehension = 188,
  sym_parenthesized_expression = 189,
  sym__collection_elements = 190,
  sym_tuple = 191,
  sym_generator_expression = 192,
  sym_for_in_clause = 193,
  sym_if_clause = 194,
  sym_conditional_expression = 195,
  sym_concatenated_string = 196,
  sym_string = 197,
  sym_interpolation = 198,
  sym_format_specifier = 199,
  sym_format_expression = 200,
  sym_await = 201,
  aux_sym_module_repeat1 = 202,
  aux_sym__simple_statements_repeat1 = 203,
  aux_sym_import_prefix_repeat1 = 204,
  aux_sym__import_list_repeat1 = 205,
  aux_sym_print_statement_repeat1 = 206,
  aux_sym_assert_statement_repeat1 = 207,
  aux_sym_if_statement_repeat1 = 208,
  aux_sym_try_statement_repeat1 = 209,
  aux_sym_with_statement_repeat1 = 210,
  aux_sym__parameters_repeat1 = 211,
  aux_sym__patterns_repeat1 = 212,
  aux_sym_global_statement_repeat1 = 213,
  aux_sym_argument_list_repeat1 = 214,
  aux_sym_decorated_definition_repeat1 = 215,
  aux_sym_dotted_name_repeat1 = 216,
  aux_sym_comparison_operator_repeat1 = 217,
  aux_sym_subscript_repeat1 = 218,
  aux_sym__comprehension_clauses_repeat1 = 219,
  aux_sym_dictionary_repeat1 = 220,
  aux_sym_set_repeat1 = 221,
  aux_sym__collection_elements_repeat1 = 222,
  aux_sym_for_in_clause_repeat1 = 223,
  aux_sym_concatenated_string_repeat1 = 224,
  aux_sym_string_repeat1 = 225,
  aux_sym_format_specifier_repeat1 = 226,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_class] = "class",
  [anon_sym_AT] = "@",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_is] = "is",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_escape_sequence] = "escape_sequence",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [anon_sym_await] = "await",
  [sym_comment] = "comment",
  [sym__semicolon] = "_semicolon",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym__string_start] = "\"",
  [sym__string_content] = "_string_content",
  [sym__string_end] = "\"",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_class_definition] = "class_definition",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_left_hand_side] = "left_hand_side",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary] = "dictionary",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_pair] = "pair",
  [sym_set] = "set",
  [sym_set_comprehension] = "set_comprehension",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_tuple] = "tuple",
  [sym_generator_expression] = "generator_expression",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_interpolation] = "interpolation",
  [sym_format_specifier] = "format_specifier",
  [sym_format_expression] = "format_expression",
  [sym_await] = "await",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_with_statement_repeat1] = "with_statement_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym_set_repeat1] = "set_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [anon_sym_await] = anon_sym_await,
  [sym_comment] = sym_comment,
  [sym__semicolon] = sym__semicolon,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_start,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_left_hand_side] = sym_left_hand_side,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary] = sym_dictionary,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_pair] = sym_pair,
  [sym_set] = sym_set,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_tuple] = sym_tuple,
  [sym_generator_expression] = sym_generator_expression,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_interpolation] = sym_interpolation,
  [sym_format_specifier] = sym_format_specifier,
  [sym_format_expression] = sym_format_expression,
  [sym_await] = sym_await,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_with_statement_repeat1] = aux_sym_with_statement_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym_set_repeat1] = aux_sym_set_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_left_hand_side] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_function = 12,
  field_key = 13,
  field_left = 14,
  field_module_name = 15,
  field_name = 16,
  field_object = 17,
  field_operator = 18,
  field_parameters = 19,
  field_return_type = 20,
  field_right = 21,
  field_subscript = 22,
  field_superclasses = 23,
  field_type = 24,
  field_value = 25,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_function] = "function",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[93] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 2},
  [13] = {.index = 12, .length = 1},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 15, .length = 1},
  [16] = {.index = 16, .length = 1},
  [17] = {.index = 17, .length = 2},
  [18] = {.index = 19, .length = 3},
  [19] = {.index = 22, .length = 2},
  [20] = {.index = 24, .length = 2},
  [21] = {.index = 26, .length = 2},
  [22] = {.index = 28, .length = 1},
  [23] = {.index = 29, .length = 2},
  [24] = {.index = 31, .length = 2},
  [25] = {.index = 33, .length = 1},
  [26] = {.index = 34, .length = 2},
  [28] = {.index = 36, .length = 1},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 1},
  [31] = {.index = 40, .length = 2},
  [32] = {.index = 42, .length = 2},
  [33] = {.index = 16, .length = 1},
  [34] = {.index = 44, .length = 1},
  [35] = {.index = 45, .length = 2},
  [36] = {.index = 47, .length = 2},
  [37] = {.index = 49, .length = 1},
  [38] = {.index = 17, .length = 2},
  [39] = {.index = 50, .length = 1},
  [40] = {.index = 51, .length = 2},
  [41] = {.index = 53, .length = 2},
  [42] = {.index = 55, .length = 2},
  [43] = {.index = 57, .length = 1},
  [44] = {.index = 58, .length = 3},
  [45] = {.index = 61, .length = 3},
  [46] = {.index = 64, .length = 3},
  [47] = {.index = 67, .length = 1},
  [48] = {.index = 68, .length = 3},
  [49] = {.index = 71, .length = 3},
  [50] = {.index = 74, .length = 2},
  [51] = {.index = 76, .length = 2},
  [52] = {.index = 78, .length = 3},
  [53] = {.index = 81, .length = 3},
  [54] = {.index = 84, .length = 3},
  [55] = {.index = 87, .length = 3},
  [56] = {.index = 90, .length = 3},
  [57] = {.index = 93, .length = 1},
  [58] = {.index = 94, .length = 2},
  [59] = {.index = 96, .length = 2},
  [60] = {.index = 98, .length = 4},
  [61] = {.index = 102, .length = 2},
  [62] = {.index = 104, .length = 4},
  [63] = {.index = 108, .length = 4},
  [64] = {.index = 112, .length = 2},
  [65] = {.index = 114, .length = 1},
  [66] = {.index = 115, .length = 3},
  [67] = {.index = 118, .length = 3},
  [68] = {.index = 121, .length = 4},
  [70] = {.index = 125, .length = 4},
  [71] = {.index = 129, .length = 4},
  [72] = {.index = 133, .length = 3},
  [73] = {.index = 133, .length = 3},
  [74] = {.index = 136, .length = 2},
  [75] = {.index = 138, .length = 3},
  [76] = {.index = 141, .length = 5},
  [77] = {.index = 146, .length = 3},
  [78] = {.index = 149, .length = 2},
  [79] = {.index = 151, .length = 4},
  [80] = {.index = 155, .length = 4},
  [81] = {.index = 159, .length = 4},
  [83] = {.index = 163, .length = 4},
  [84] = {.index = 167, .length = 3},
  [85] = {.index = 170, .length = 4},
  [86] = {.index = 174, .length = 4},
  [87] = {.index = 178, .length = 4},
  [88] = {.index = 182, .length = 5},
  [89] = {.index = 187, .length = 5},
  [90] = {.index = 192, .length = 5},
  [91] = {.index = 197, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_definition, 1},
  [10] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [12] =
    {field_argument, 2, .inherited = true},
  [13] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [15] =
    {field_cause, 2},
  [16] =
    {field_body, 2},
  [17] =
    {field_name, 0},
    {field_value, 2},
  [19] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [22] =
    {field_attribute, 2},
    {field_object, 0},
  [24] =
    {field_left, 0},
    {field_type, 2},
  [26] =
    {field_left, 0},
    {field_right, 2},
  [28] =
    {field_name, 1},
  [29] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [31] =
    {field_alias, 2},
    {field_name, 0},
  [33] =
    {field_name, 3, .inherited = true},
  [34] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [36] =
    {field_body, 1},
  [37] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [39] =
    {field_cause, 3},
  [40] =
    {field_condition, 1},
    {field_consequence, 3},
  [42] =
    {field_body, 3},
    {field_condition, 1},
  [44] =
    {field_body, 3},
  [45] =
    {field_alias, 2},
    {field_value, 0},
  [47] =
    {field_body, 3},
    {field_name, 1},
  [49] =
    {field_arguments, 2},
  [50] =
    {field_type, 2},
  [51] =
    {field_body, 3},
    {field_parameters, 1},
  [53] =
    {field_key, 0},
    {field_value, 2},
  [55] =
    {field_subscript, 2},
    {field_value, 0},
  [57] =
    {field_alternative, 0},
  [58] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [61] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [64] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [67] =
    {field_body, 4},
  [68] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [71] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [74] =
    {field_body, 2},
    {field_body, 3},
  [76] =
    {field_body, 3},
    {field_body, 4},
  [78] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [81] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [84] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [87] =
    {field_subscript, 2},
    {field_subscript, 3},
    {field_value, 0},
  [90] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [93] =
    {field_name, 4, .inherited = true},
  [94] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [96] =
    {field_left, 1},
    {field_right, 3},
  [98] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [102] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [104] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [108] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [112] =
    {field_body, 4},
    {field_body, 5},
  [114] =
    {field_body, 5},
  [115] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [118] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [121] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [125] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [129] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [133] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [136] =
    {field_left, 2},
    {field_right, 4},
  [138] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [141] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [146] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [149] =
    {field_body, 5},
    {field_body, 6},
  [151] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [155] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [159] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [163] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [167] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [170] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [174] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [178] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [182] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [187] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [192] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [197] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
};

static TSSymbol ts_alias_sequences[93][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [1] = sym_identifier,
  },
  [9] = {
    [0] = sym_list_splat_pattern,
  },
  [27] = {
    [1] = sym_parenthesized_expression,
  },
  [31] = {
    [3] = sym_block,
  },
  [32] = {
    [3] = sym_block,
  },
  [33] = {
    [2] = sym_block,
  },
  [34] = {
    [3] = sym_block,
  },
  [36] = {
    [3] = sym_block,
  },
  [38] = {
    [0] = sym_identifier,
  },
  [44] = {
    [3] = sym_block,
  },
  [45] = {
    [3] = sym_block,
  },
  [47] = {
    [4] = sym_block,
  },
  [48] = {
    [3] = sym_block,
  },
  [52] = {
    [4] = sym_block,
  },
  [54] = {
    [4] = sym_block,
  },
  [60] = {
    [3] = sym_block,
  },
  [65] = {
    [5] = sym_block,
  },
  [66] = {
    [5] = sym_block,
  },
  [67] = {
    [5] = sym_block,
  },
  [69] = {
    [2] = sym_block,
  },
  [72] = {
    [0] = sym_identifier,
  },
  [77] = {
    [6] = sym_block,
  },
  [80] = {
    [5] = sym_block,
  },
  [82] = {
    [3] = sym_block,
  },
  [83] = {
    [6] = sym_block,
  },
  [85] = {
    [6] = sym_block,
  },
  [87] = {
    [7] = sym_block,
  },
  [92] = {
    [5] = sym_block,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '%') ADVANCE(60);
      if (lookahead == '&') ADVANCE(63);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '0') ADVANCE(100);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(112);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '@') ADVANCE(55);
      if (lookahead == '[') ADVANCE(51);
      if (lookahead == '\\') SKIP(35)
      if (lookahead == ']') ADVANCE(52);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(10)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(10)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(91);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(4)
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(93);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(94);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(11)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(11)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(9)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(9)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '%') ADVANCE(60);
      if (lookahead == '&') ADVANCE(63);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '.') ADVANCE(40);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == ':') ADVANCE(49);
      if (lookahead == ';') ADVANCE(112);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '@') ADVANCE(55);
      if (lookahead == '[') ADVANCE(51);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == ']') ADVANCE(52);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '%') ADVANCE(60);
      if (lookahead == '&') ADVANCE(63);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '.') ADVANCE(40);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == ';') ADVANCE(112);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '@') ADVANCE(55);
      if (lookahead == '[') ADVANCE(51);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(52);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 11:
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '-') ADVANCE(15);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(92);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(87);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(70);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(97);
      END_STATE();
    case 15:
      if (lookahead == '>') ADVANCE(50);
      END_STATE();
    case 16:
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 18:
      if (lookahead == '_') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 19:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 20:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(90);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(23);
      END_STATE();
    case 25:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 26:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 27:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(26);
      END_STATE();
    case 28:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(27);
      END_STATE();
    case 29:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(28);
      END_STATE();
    case 30:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 34:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 35:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(34)
      END_STATE();
    case 36:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(38)
      END_STATE();
    case 37:
      if (eof) ADVANCE(39);
      if (lookahead == '\n') SKIP(38)
      if (lookahead == '\r') SKIP(36)
      END_STATE();
    case 38:
      if (eof) ADVANCE(39);
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '#') ADVANCE(111);
      if (lookahead == '%') ADVANCE(60);
      if (lookahead == '&') ADVANCE(63);
      if (lookahead == '(') ADVANCE(42);
      if (lookahead == ')') ADVANCE(43);
      if (lookahead == '*') ADVANCE(45);
      if (lookahead == '+') ADVANCE(56);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '0') ADVANCE(100);
      if (lookahead == ':') ADVANCE(48);
      if (lookahead == ';') ADVANCE(112);
      if (lookahead == '<') ADVANCE(67);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(72);
      if (lookahead == '@') ADVANCE(55);
      if (lookahead == '[') ADVANCE(51);
      if (lookahead == '\\') SKIP(37)
      if (lookahead == ']') ADVANCE(52);
      if (lookahead == '^') ADVANCE(64);
      if (lookahead == '{') ADVANCE(88);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(89);
      if (lookahead == '~') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(38)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(54);
      if (lookahead == '=') ADVANCE(76);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(82);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(69);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(78);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(74);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(75);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(50);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(61);
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(86);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(83);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(65);
      if (lookahead == '=') ADVANCE(68);
      if (lookahead == '>') ADVANCE(73);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(46);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym__not_escape_sequence);
      if (lookahead == '\n') ADVANCE(91);
      if (lookahead == '\r') ADVANCE(3);
      if (lookahead == 'U') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(29);
      if (lookahead == 'x') ADVANCE(27);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '\r') ADVANCE(96);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(93);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(94);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '{' ||
          lookahead == '}') ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == '_') ADVANCE(101);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(16);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(17);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(18);
      if (lookahead == '_') ADVANCE(101);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(108);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(20);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(102);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(21);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(103);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(25);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(104);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(108);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(109);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(19);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(106);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym__semicolon);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'p') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 't') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(25)
      END_STATE();
    case 5:
      if (lookahead == '_') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'n') ADVANCE(27);
      if (lookahead == 's') ADVANCE(28);
      if (lookahead == 'w') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 8:
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 11:
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 12:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'm') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(45);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(51);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(52);
      if (lookahead == 'i') ADVANCE(53);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(55);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(56);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 26:
      if (lookahead == 'f') ADVANCE(58);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(59);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 'y') ADVANCE(61);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 33:
      if (lookahead == 'f') ADVANCE(66);
      if (lookahead == 'l') ADVANCE(67);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(68);
      if (lookahead == 's') ADVANCE(69);
      END_STATE();
    case 35:
      if (lookahead == 'c') ADVANCE(70);
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(73);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(77);
      END_STATE();
    case 45:
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 47:
      if (lookahead == 's') ADVANCE(80);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(81);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 51:
      if (lookahead == 'y') ADVANCE(84);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 55:
      if (lookahead == 's') ADVANCE(88);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 58:
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(95);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(96);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 68:
      if (lookahead == 'f') ADVANCE(98);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 71:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 74:
      if (lookahead == 'm') ADVANCE(103);
      END_STATE();
    case 75:
      if (lookahead == 'b') ADVANCE(104);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(105);
      END_STATE();
    case 77:
      if (lookahead == 'b') ADVANCE(106);
      END_STATE();
    case 78:
      if (lookahead == 'l') ADVANCE(107);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 80:
      if (lookahead == 's') ADVANCE(108);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(110);
      END_STATE();
    case 83:
      if (lookahead == 'u') ADVANCE(111);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 85:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 86:
      if (lookahead == 'h') ADVANCE(113);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(114);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 91:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 92:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 93:
      if (lookahead == 'c') ADVANCE(118);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 95:
      if (lookahead == 'k') ADVANCE(120);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 100:
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 102:
      if (lookahead == 'l') ADVANCE(124);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 104:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 106:
      if (lookahead == 'd') ADVANCE(127);
      END_STATE();
    case 107:
      if (lookahead == 'o') ADVANCE(128);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 114:
      if (lookahead == 'd') ADVANCE(133);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 116:
      if (lookahead == 'u') ADVANCE(134);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(135);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(138);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(141);
      END_STATE();
    case 128:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 131:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 134:
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 136:
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_except);
      END_STATE();
    case 138:
      if (lookahead == 'y') ADVANCE(146);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(147);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 147:
      if (lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 148:
      if (lookahead == '_') ADVANCE(151);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 151:
      if (lookahead == '_') ADVANCE(152);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 38, .external_lex_state = 2},
  [2] = {.lex_state = 38, .external_lex_state = 3},
  [3] = {.lex_state = 38, .external_lex_state = 3},
  [4] = {.lex_state = 38, .external_lex_state = 3},
  [5] = {.lex_state = 38, .external_lex_state = 3},
  [6] = {.lex_state = 38, .external_lex_state = 3},
  [7] = {.lex_state = 38, .external_lex_state = 3},
  [8] = {.lex_state = 38, .external_lex_state = 3},
  [9] = {.lex_state = 38, .external_lex_state = 3},
  [10] = {.lex_state = 38, .external_lex_state = 3},
  [11] = {.lex_state = 38, .external_lex_state = 3},
  [12] = {.lex_state = 38, .external_lex_state = 3},
  [13] = {.lex_state = 38, .external_lex_state = 3},
  [14] = {.lex_state = 38, .external_lex_state = 3},
  [15] = {.lex_state = 38, .external_lex_state = 3},
  [16] = {.lex_state = 38, .external_lex_state = 3},
  [17] = {.lex_state = 38, .external_lex_state = 3},
  [18] = {.lex_state = 38, .external_lex_state = 3},
  [19] = {.lex_state = 38, .external_lex_state = 3},
  [20] = {.lex_state = 38, .external_lex_state = 3},
  [21] = {.lex_state = 38, .external_lex_state = 3},
  [22] = {.lex_state = 38, .external_lex_state = 3},
  [23] = {.lex_state = 38, .external_lex_state = 3},
  [24] = {.lex_state = 38, .external_lex_state = 3},
  [25] = {.lex_state = 38, .external_lex_state = 3},
  [26] = {.lex_state = 38, .external_lex_state = 3},
  [27] = {.lex_state = 38, .external_lex_state = 3},
  [28] = {.lex_state = 38, .external_lex_state = 3},
  [29] = {.lex_state = 38, .external_lex_state = 3},
  [30] = {.lex_state = 38, .external_lex_state = 3},
  [31] = {.lex_state = 38, .external_lex_state = 3},
  [32] = {.lex_state = 38, .external_lex_state = 3},
  [33] = {.lex_state = 38, .external_lex_state = 3},
  [34] = {.lex_state = 38, .external_lex_state = 3},
  [35] = {.lex_state = 38, .external_lex_state = 3},
  [36] = {.lex_state = 38, .external_lex_state = 3},
  [37] = {.lex_state = 38, .external_lex_state = 3},
  [38] = {.lex_state = 38, .external_lex_state = 3},
  [39] = {.lex_state = 38, .external_lex_state = 3},
  [40] = {.lex_state = 38, .external_lex_state = 3},
  [41] = {.lex_state = 38, .external_lex_state = 3},
  [42] = {.lex_state = 38, .external_lex_state = 3},
  [43] = {.lex_state = 38, .external_lex_state = 2},
  [44] = {.lex_state = 38, .external_lex_state = 3},
  [45] = {.lex_state = 38, .external_lex_state = 3},
  [46] = {.lex_state = 38, .external_lex_state = 3},
  [47] = {.lex_state = 38, .external_lex_state = 2},
  [48] = {.lex_state = 38, .external_lex_state = 4},
  [49] = {.lex_state = 38, .external_lex_state = 5},
  [50] = {.lex_state = 38, .external_lex_state = 5},
  [51] = {.lex_state = 38, .external_lex_state = 5},
  [52] = {.lex_state = 38, .external_lex_state = 5},
  [53] = {.lex_state = 38, .external_lex_state = 5},
  [54] = {.lex_state = 38, .external_lex_state = 5},
  [55] = {.lex_state = 38, .external_lex_state = 5},
  [56] = {.lex_state = 38, .external_lex_state = 5},
  [57] = {.lex_state = 38, .external_lex_state = 5},
  [58] = {.lex_state = 38, .external_lex_state = 5},
  [59] = {.lex_state = 38, .external_lex_state = 5},
  [60] = {.lex_state = 38, .external_lex_state = 5},
  [61] = {.lex_state = 38, .external_lex_state = 5},
  [62] = {.lex_state = 38, .external_lex_state = 5},
  [63] = {.lex_state = 38, .external_lex_state = 5},
  [64] = {.lex_state = 38, .external_lex_state = 5},
  [65] = {.lex_state = 38, .external_lex_state = 5},
  [66] = {.lex_state = 38, .external_lex_state = 5},
  [67] = {.lex_state = 38, .external_lex_state = 5},
  [68] = {.lex_state = 38, .external_lex_state = 5},
  [69] = {.lex_state = 38, .external_lex_state = 5},
  [70] = {.lex_state = 38, .external_lex_state = 5},
  [71] = {.lex_state = 38, .external_lex_state = 5},
  [72] = {.lex_state = 38, .external_lex_state = 5},
  [73] = {.lex_state = 38, .external_lex_state = 5},
  [74] = {.lex_state = 38, .external_lex_state = 5},
  [75] = {.lex_state = 38, .external_lex_state = 5},
  [76] = {.lex_state = 38, .external_lex_state = 5},
  [77] = {.lex_state = 38, .external_lex_state = 5},
  [78] = {.lex_state = 38, .external_lex_state = 5},
  [79] = {.lex_state = 38, .external_lex_state = 5},
  [80] = {.lex_state = 38, .external_lex_state = 5},
  [81] = {.lex_state = 38, .external_lex_state = 5},
  [82] = {.lex_state = 38, .external_lex_state = 5},
  [83] = {.lex_state = 38, .external_lex_state = 5},
  [84] = {.lex_state = 38, .external_lex_state = 5},
  [85] = {.lex_state = 38, .external_lex_state = 5},
  [86] = {.lex_state = 38, .external_lex_state = 5},
  [87] = {.lex_state = 38, .external_lex_state = 5},
  [88] = {.lex_state = 38, .external_lex_state = 5},
  [89] = {.lex_state = 38, .external_lex_state = 4},
  [90] = {.lex_state = 38, .external_lex_state = 4},
  [91] = {.lex_state = 38, .external_lex_state = 4},
  [92] = {.lex_state = 38, .external_lex_state = 4},
  [93] = {.lex_state = 38, .external_lex_state = 4},
  [94] = {.lex_state = 38, .external_lex_state = 4},
  [95] = {.lex_state = 38, .external_lex_state = 2},
  [96] = {.lex_state = 38, .external_lex_state = 2},
  [97] = {.lex_state = 38, .external_lex_state = 2},
  [98] = {.lex_state = 38, .external_lex_state = 2},
  [99] = {.lex_state = 38, .external_lex_state = 2},
  [100] = {.lex_state = 38, .external_lex_state = 2},
  [101] = {.lex_state = 38, .external_lex_state = 2},
  [102] = {.lex_state = 38, .external_lex_state = 2},
  [103] = {.lex_state = 38, .external_lex_state = 2},
  [104] = {.lex_state = 38, .external_lex_state = 2},
  [105] = {.lex_state = 38, .external_lex_state = 2},
  [106] = {.lex_state = 38, .external_lex_state = 2},
  [107] = {.lex_state = 38, .external_lex_state = 2},
  [108] = {.lex_state = 38, .external_lex_state = 2},
  [109] = {.lex_state = 38, .external_lex_state = 2},
  [110] = {.lex_state = 38, .external_lex_state = 2},
  [111] = {.lex_state = 10},
  [112] = {.lex_state = 10},
  [113] = {.lex_state = 38, .external_lex_state = 2},
  [114] = {.lex_state = 10},
  [115] = {.lex_state = 38, .external_lex_state = 2},
  [116] = {.lex_state = 10},
  [117] = {.lex_state = 38, .external_lex_state = 2},
  [118] = {.lex_state = 10},
  [119] = {.lex_state = 38, .external_lex_state = 2},
  [120] = {.lex_state = 38, .external_lex_state = 2},
  [121] = {.lex_state = 38, .external_lex_state = 2},
  [122] = {.lex_state = 38, .external_lex_state = 2},
  [123] = {.lex_state = 38, .external_lex_state = 2},
  [124] = {.lex_state = 38, .external_lex_state = 2},
  [125] = {.lex_state = 38, .external_lex_state = 2},
  [126] = {.lex_state = 38, .external_lex_state = 2},
  [127] = {.lex_state = 38, .external_lex_state = 2},
  [128] = {.lex_state = 38, .external_lex_state = 2},
  [129] = {.lex_state = 38, .external_lex_state = 2},
  [130] = {.lex_state = 38, .external_lex_state = 2},
  [131] = {.lex_state = 38, .external_lex_state = 2},
  [132] = {.lex_state = 38, .external_lex_state = 2},
  [133] = {.lex_state = 38, .external_lex_state = 2},
  [134] = {.lex_state = 38, .external_lex_state = 2},
  [135] = {.lex_state = 38, .external_lex_state = 2},
  [136] = {.lex_state = 38, .external_lex_state = 2},
  [137] = {.lex_state = 38, .external_lex_state = 2},
  [138] = {.lex_state = 38, .external_lex_state = 2},
  [139] = {.lex_state = 38, .external_lex_state = 2},
  [140] = {.lex_state = 38, .external_lex_state = 2},
  [141] = {.lex_state = 38, .external_lex_state = 2},
  [142] = {.lex_state = 38, .external_lex_state = 2},
  [143] = {.lex_state = 38, .external_lex_state = 2},
  [144] = {.lex_state = 38, .external_lex_state = 2},
  [145] = {.lex_state = 38, .external_lex_state = 2},
  [146] = {.lex_state = 38, .external_lex_state = 2},
  [147] = {.lex_state = 38, .external_lex_state = 2},
  [148] = {.lex_state = 38, .external_lex_state = 2},
  [149] = {.lex_state = 38, .external_lex_state = 3},
  [150] = {.lex_state = 38, .external_lex_state = 2},
  [151] = {.lex_state = 10, .external_lex_state = 4},
  [152] = {.lex_state = 38, .external_lex_state = 3},
  [153] = {.lex_state = 38, .external_lex_state = 2},
  [154] = {.lex_state = 38, .external_lex_state = 2},
  [155] = {.lex_state = 38, .external_lex_state = 2},
  [156] = {.lex_state = 38, .external_lex_state = 2},
  [157] = {.lex_state = 38, .external_lex_state = 2},
  [158] = {.lex_state = 38, .external_lex_state = 4},
  [159] = {.lex_state = 10, .external_lex_state = 6},
  [160] = {.lex_state = 10, .external_lex_state = 6},
  [161] = {.lex_state = 9, .external_lex_state = 6},
  [162] = {.lex_state = 38, .external_lex_state = 2},
  [163] = {.lex_state = 38, .external_lex_state = 4},
  [164] = {.lex_state = 38, .external_lex_state = 2},
  [165] = {.lex_state = 10, .external_lex_state = 6},
  [166] = {.lex_state = 38, .external_lex_state = 2},
  [167] = {.lex_state = 38, .external_lex_state = 2},
  [168] = {.lex_state = 38, .external_lex_state = 2},
  [169] = {.lex_state = 10, .external_lex_state = 6},
  [170] = {.lex_state = 38, .external_lex_state = 2},
  [171] = {.lex_state = 10, .external_lex_state = 6},
  [172] = {.lex_state = 38, .external_lex_state = 2},
  [173] = {.lex_state = 38, .external_lex_state = 4},
  [174] = {.lex_state = 38, .external_lex_state = 2},
  [175] = {.lex_state = 38, .external_lex_state = 2},
  [176] = {.lex_state = 38, .external_lex_state = 2},
  [177] = {.lex_state = 38, .external_lex_state = 2},
  [178] = {.lex_state = 38, .external_lex_state = 2},
  [179] = {.lex_state = 10, .external_lex_state = 6},
  [180] = {.lex_state = 38, .external_lex_state = 2},
  [181] = {.lex_state = 38, .external_lex_state = 4},
  [182] = {.lex_state = 38, .external_lex_state = 3},
  [183] = {.lex_state = 38, .external_lex_state = 2},
  [184] = {.lex_state = 38, .external_lex_state = 2},
  [185] = {.lex_state = 38, .external_lex_state = 3},
  [186] = {.lex_state = 38, .external_lex_state = 2},
  [187] = {.lex_state = 38, .external_lex_state = 2},
  [188] = {.lex_state = 38, .external_lex_state = 2},
  [189] = {.lex_state = 38, .external_lex_state = 2},
  [190] = {.lex_state = 38, .external_lex_state = 2},
  [191] = {.lex_state = 10, .external_lex_state = 6},
  [192] = {.lex_state = 38, .external_lex_state = 2},
  [193] = {.lex_state = 38, .external_lex_state = 3},
  [194] = {.lex_state = 10, .external_lex_state = 6},
  [195] = {.lex_state = 38, .external_lex_state = 4},
  [196] = {.lex_state = 38, .external_lex_state = 2},
  [197] = {.lex_state = 38, .external_lex_state = 2},
  [198] = {.lex_state = 38, .external_lex_state = 3},
  [199] = {.lex_state = 38, .external_lex_state = 2},
  [200] = {.lex_state = 10, .external_lex_state = 6},
  [201] = {.lex_state = 38, .external_lex_state = 2},
  [202] = {.lex_state = 38, .external_lex_state = 2},
  [203] = {.lex_state = 38, .external_lex_state = 3},
  [204] = {.lex_state = 38, .external_lex_state = 2},
  [205] = {.lex_state = 38, .external_lex_state = 4},
  [206] = {.lex_state = 38, .external_lex_state = 2},
  [207] = {.lex_state = 38, .external_lex_state = 4},
  [208] = {.lex_state = 38, .external_lex_state = 4},
  [209] = {.lex_state = 38, .external_lex_state = 2},
  [210] = {.lex_state = 38, .external_lex_state = 3},
  [211] = {.lex_state = 38, .external_lex_state = 2},
  [212] = {.lex_state = 38, .external_lex_state = 2},
  [213] = {.lex_state = 38, .external_lex_state = 2},
  [214] = {.lex_state = 38, .external_lex_state = 2},
  [215] = {.lex_state = 38, .external_lex_state = 3},
  [216] = {.lex_state = 38, .external_lex_state = 2},
  [217] = {.lex_state = 38, .external_lex_state = 2},
  [218] = {.lex_state = 38, .external_lex_state = 3},
  [219] = {.lex_state = 38, .external_lex_state = 2},
  [220] = {.lex_state = 38, .external_lex_state = 2},
  [221] = {.lex_state = 38, .external_lex_state = 2},
  [222] = {.lex_state = 38, .external_lex_state = 3},
  [223] = {.lex_state = 38, .external_lex_state = 4},
  [224] = {.lex_state = 38, .external_lex_state = 4},
  [225] = {.lex_state = 38, .external_lex_state = 3},
  [226] = {.lex_state = 38, .external_lex_state = 4},
  [227] = {.lex_state = 38, .external_lex_state = 3},
  [228] = {.lex_state = 38, .external_lex_state = 2},
  [229] = {.lex_state = 38, .external_lex_state = 2},
  [230] = {.lex_state = 38, .external_lex_state = 2},
  [231] = {.lex_state = 38, .external_lex_state = 2},
  [232] = {.lex_state = 38, .external_lex_state = 2},
  [233] = {.lex_state = 38, .external_lex_state = 2},
  [234] = {.lex_state = 38, .external_lex_state = 2},
  [235] = {.lex_state = 38, .external_lex_state = 2},
  [236] = {.lex_state = 38, .external_lex_state = 2},
  [237] = {.lex_state = 38, .external_lex_state = 3},
  [238] = {.lex_state = 38, .external_lex_state = 2},
  [239] = {.lex_state = 38, .external_lex_state = 2},
  [240] = {.lex_state = 38, .external_lex_state = 2},
  [241] = {.lex_state = 38, .external_lex_state = 2},
  [242] = {.lex_state = 38, .external_lex_state = 2},
  [243] = {.lex_state = 38, .external_lex_state = 2},
  [244] = {.lex_state = 38, .external_lex_state = 2},
  [245] = {.lex_state = 38, .external_lex_state = 3},
  [246] = {.lex_state = 38, .external_lex_state = 3},
  [247] = {.lex_state = 38, .external_lex_state = 2},
  [248] = {.lex_state = 38, .external_lex_state = 2},
  [249] = {.lex_state = 38, .external_lex_state = 2},
  [250] = {.lex_state = 38, .external_lex_state = 2},
  [251] = {.lex_state = 38, .external_lex_state = 2},
  [252] = {.lex_state = 38, .external_lex_state = 2},
  [253] = {.lex_state = 38, .external_lex_state = 2},
  [254] = {.lex_state = 38, .external_lex_state = 2},
  [255] = {.lex_state = 38, .external_lex_state = 2},
  [256] = {.lex_state = 38, .external_lex_state = 3},
  [257] = {.lex_state = 38, .external_lex_state = 2},
  [258] = {.lex_state = 38, .external_lex_state = 3},
  [259] = {.lex_state = 38, .external_lex_state = 3},
  [260] = {.lex_state = 38, .external_lex_state = 2},
  [261] = {.lex_state = 38, .external_lex_state = 2},
  [262] = {.lex_state = 38, .external_lex_state = 2},
  [263] = {.lex_state = 38, .external_lex_state = 2},
  [264] = {.lex_state = 38, .external_lex_state = 2},
  [265] = {.lex_state = 38, .external_lex_state = 2},
  [266] = {.lex_state = 38, .external_lex_state = 2},
  [267] = {.lex_state = 38, .external_lex_state = 2},
  [268] = {.lex_state = 38, .external_lex_state = 2},
  [269] = {.lex_state = 38, .external_lex_state = 2},
  [270] = {.lex_state = 38, .external_lex_state = 2},
  [271] = {.lex_state = 38, .external_lex_state = 2},
  [272] = {.lex_state = 38, .external_lex_state = 2},
  [273] = {.lex_state = 38, .external_lex_state = 2},
  [274] = {.lex_state = 38, .external_lex_state = 2},
  [275] = {.lex_state = 38, .external_lex_state = 3},
  [276] = {.lex_state = 38, .external_lex_state = 2},
  [277] = {.lex_state = 38, .external_lex_state = 2},
  [278] = {.lex_state = 38, .external_lex_state = 2},
  [279] = {.lex_state = 38, .external_lex_state = 2},
  [280] = {.lex_state = 38, .external_lex_state = 2},
  [281] = {.lex_state = 38, .external_lex_state = 2},
  [282] = {.lex_state = 38, .external_lex_state = 2},
  [283] = {.lex_state = 38, .external_lex_state = 2},
  [284] = {.lex_state = 38, .external_lex_state = 2},
  [285] = {.lex_state = 38, .external_lex_state = 2},
  [286] = {.lex_state = 38, .external_lex_state = 3},
  [287] = {.lex_state = 38, .external_lex_state = 3},
  [288] = {.lex_state = 38, .external_lex_state = 2},
  [289] = {.lex_state = 38, .external_lex_state = 2},
  [290] = {.lex_state = 38, .external_lex_state = 2},
  [291] = {.lex_state = 38, .external_lex_state = 2},
  [292] = {.lex_state = 38, .external_lex_state = 2},
  [293] = {.lex_state = 38, .external_lex_state = 2},
  [294] = {.lex_state = 38, .external_lex_state = 3},
  [295] = {.lex_state = 38, .external_lex_state = 2},
  [296] = {.lex_state = 38, .external_lex_state = 3},
  [297] = {.lex_state = 38, .external_lex_state = 2},
  [298] = {.lex_state = 38, .external_lex_state = 2},
  [299] = {.lex_state = 38, .external_lex_state = 2},
  [300] = {.lex_state = 38, .external_lex_state = 2},
  [301] = {.lex_state = 38, .external_lex_state = 2},
  [302] = {.lex_state = 38, .external_lex_state = 2},
  [303] = {.lex_state = 38, .external_lex_state = 2},
  [304] = {.lex_state = 38, .external_lex_state = 2},
  [305] = {.lex_state = 38, .external_lex_state = 2},
  [306] = {.lex_state = 38, .external_lex_state = 2},
  [307] = {.lex_state = 38, .external_lex_state = 2},
  [308] = {.lex_state = 38, .external_lex_state = 2},
  [309] = {.lex_state = 38, .external_lex_state = 2},
  [310] = {.lex_state = 38, .external_lex_state = 3},
  [311] = {.lex_state = 38, .external_lex_state = 2},
  [312] = {.lex_state = 38, .external_lex_state = 2},
  [313] = {.lex_state = 38, .external_lex_state = 2},
  [314] = {.lex_state = 38, .external_lex_state = 2},
  [315] = {.lex_state = 38, .external_lex_state = 2},
  [316] = {.lex_state = 38, .external_lex_state = 2},
  [317] = {.lex_state = 38, .external_lex_state = 2},
  [318] = {.lex_state = 38, .external_lex_state = 2},
  [319] = {.lex_state = 38, .external_lex_state = 2},
  [320] = {.lex_state = 38, .external_lex_state = 2},
  [321] = {.lex_state = 38, .external_lex_state = 2},
  [322] = {.lex_state = 38, .external_lex_state = 2},
  [323] = {.lex_state = 38, .external_lex_state = 2},
  [324] = {.lex_state = 38, .external_lex_state = 3},
  [325] = {.lex_state = 38, .external_lex_state = 2},
  [326] = {.lex_state = 38, .external_lex_state = 2},
  [327] = {.lex_state = 38, .external_lex_state = 2},
  [328] = {.lex_state = 38, .external_lex_state = 2},
  [329] = {.lex_state = 38, .external_lex_state = 2},
  [330] = {.lex_state = 38, .external_lex_state = 2},
  [331] = {.lex_state = 38, .external_lex_state = 2},
  [332] = {.lex_state = 38, .external_lex_state = 2},
  [333] = {.lex_state = 38, .external_lex_state = 2},
  [334] = {.lex_state = 38, .external_lex_state = 2},
  [335] = {.lex_state = 38, .external_lex_state = 2},
  [336] = {.lex_state = 38, .external_lex_state = 3},
  [337] = {.lex_state = 38, .external_lex_state = 2},
  [338] = {.lex_state = 38, .external_lex_state = 2},
  [339] = {.lex_state = 38, .external_lex_state = 2},
  [340] = {.lex_state = 38, .external_lex_state = 2},
  [341] = {.lex_state = 38, .external_lex_state = 2},
  [342] = {.lex_state = 38, .external_lex_state = 2},
  [343] = {.lex_state = 38, .external_lex_state = 2},
  [344] = {.lex_state = 38, .external_lex_state = 2},
  [345] = {.lex_state = 38, .external_lex_state = 2},
  [346] = {.lex_state = 38, .external_lex_state = 3},
  [347] = {.lex_state = 38, .external_lex_state = 2},
  [348] = {.lex_state = 38, .external_lex_state = 2},
  [349] = {.lex_state = 38, .external_lex_state = 3},
  [350] = {.lex_state = 38, .external_lex_state = 2},
  [351] = {.lex_state = 38, .external_lex_state = 2},
  [352] = {.lex_state = 38, .external_lex_state = 2},
  [353] = {.lex_state = 38, .external_lex_state = 2},
  [354] = {.lex_state = 38, .external_lex_state = 2},
  [355] = {.lex_state = 38, .external_lex_state = 2},
  [356] = {.lex_state = 38, .external_lex_state = 3},
  [357] = {.lex_state = 38, .external_lex_state = 3},
  [358] = {.lex_state = 38, .external_lex_state = 3},
  [359] = {.lex_state = 38, .external_lex_state = 2},
  [360] = {.lex_state = 38, .external_lex_state = 2},
  [361] = {.lex_state = 38, .external_lex_state = 2},
  [362] = {.lex_state = 38, .external_lex_state = 2},
  [363] = {.lex_state = 38, .external_lex_state = 2},
  [364] = {.lex_state = 38, .external_lex_state = 3},
  [365] = {.lex_state = 38, .external_lex_state = 3},
  [366] = {.lex_state = 38, .external_lex_state = 2},
  [367] = {.lex_state = 38, .external_lex_state = 3},
  [368] = {.lex_state = 38, .external_lex_state = 2},
  [369] = {.lex_state = 38, .external_lex_state = 2},
  [370] = {.lex_state = 38, .external_lex_state = 3},
  [371] = {.lex_state = 38, .external_lex_state = 2},
  [372] = {.lex_state = 10, .external_lex_state = 2},
  [373] = {.lex_state = 38, .external_lex_state = 2},
  [374] = {.lex_state = 38, .external_lex_state = 3},
  [375] = {.lex_state = 38, .external_lex_state = 3},
  [376] = {.lex_state = 38, .external_lex_state = 2},
  [377] = {.lex_state = 38, .external_lex_state = 3},
  [378] = {.lex_state = 38, .external_lex_state = 3},
  [379] = {.lex_state = 38, .external_lex_state = 3},
  [380] = {.lex_state = 38, .external_lex_state = 3},
  [381] = {.lex_state = 38, .external_lex_state = 2},
  [382] = {.lex_state = 38, .external_lex_state = 3},
  [383] = {.lex_state = 38, .external_lex_state = 3},
  [384] = {.lex_state = 38, .external_lex_state = 3},
  [385] = {.lex_state = 38, .external_lex_state = 3},
  [386] = {.lex_state = 38, .external_lex_state = 2},
  [387] = {.lex_state = 38, .external_lex_state = 2},
  [388] = {.lex_state = 38, .external_lex_state = 2},
  [389] = {.lex_state = 38, .external_lex_state = 2},
  [390] = {.lex_state = 38, .external_lex_state = 3},
  [391] = {.lex_state = 38, .external_lex_state = 3},
  [392] = {.lex_state = 38, .external_lex_state = 2},
  [393] = {.lex_state = 38, .external_lex_state = 2},
  [394] = {.lex_state = 38, .external_lex_state = 3},
  [395] = {.lex_state = 38, .external_lex_state = 3},
  [396] = {.lex_state = 38, .external_lex_state = 3},
  [397] = {.lex_state = 38, .external_lex_state = 3},
  [398] = {.lex_state = 38, .external_lex_state = 2},
  [399] = {.lex_state = 38, .external_lex_state = 2},
  [400] = {.lex_state = 38, .external_lex_state = 3},
  [401] = {.lex_state = 38, .external_lex_state = 2},
  [402] = {.lex_state = 38, .external_lex_state = 3},
  [403] = {.lex_state = 38, .external_lex_state = 3},
  [404] = {.lex_state = 38, .external_lex_state = 2},
  [405] = {.lex_state = 38, .external_lex_state = 3},
  [406] = {.lex_state = 38, .external_lex_state = 2},
  [407] = {.lex_state = 38, .external_lex_state = 2},
  [408] = {.lex_state = 38, .external_lex_state = 2},
  [409] = {.lex_state = 38, .external_lex_state = 3},
  [410] = {.lex_state = 38, .external_lex_state = 3},
  [411] = {.lex_state = 38, .external_lex_state = 2},
  [412] = {.lex_state = 38, .external_lex_state = 3},
  [413] = {.lex_state = 38, .external_lex_state = 3},
  [414] = {.lex_state = 38, .external_lex_state = 2},
  [415] = {.lex_state = 38, .external_lex_state = 3},
  [416] = {.lex_state = 38, .external_lex_state = 2},
  [417] = {.lex_state = 38, .external_lex_state = 3},
  [418] = {.lex_state = 38, .external_lex_state = 3},
  [419] = {.lex_state = 38, .external_lex_state = 3},
  [420] = {.lex_state = 38, .external_lex_state = 2},
  [421] = {.lex_state = 10, .external_lex_state = 2},
  [422] = {.lex_state = 38, .external_lex_state = 2},
  [423] = {.lex_state = 38, .external_lex_state = 2},
  [424] = {.lex_state = 38, .external_lex_state = 3},
  [425] = {.lex_state = 38, .external_lex_state = 2},
  [426] = {.lex_state = 38, .external_lex_state = 2},
  [427] = {.lex_state = 10, .external_lex_state = 2},
  [428] = {.lex_state = 38, .external_lex_state = 3},
  [429] = {.lex_state = 38, .external_lex_state = 2},
  [430] = {.lex_state = 38, .external_lex_state = 2},
  [431] = {.lex_state = 38, .external_lex_state = 3},
  [432] = {.lex_state = 38, .external_lex_state = 2},
  [433] = {.lex_state = 38, .external_lex_state = 2},
  [434] = {.lex_state = 38, .external_lex_state = 2},
  [435] = {.lex_state = 38, .external_lex_state = 3},
  [436] = {.lex_state = 38, .external_lex_state = 2},
  [437] = {.lex_state = 38, .external_lex_state = 3},
  [438] = {.lex_state = 38, .external_lex_state = 2},
  [439] = {.lex_state = 38, .external_lex_state = 2},
  [440] = {.lex_state = 38, .external_lex_state = 2},
  [441] = {.lex_state = 10},
  [442] = {.lex_state = 38, .external_lex_state = 2},
  [443] = {.lex_state = 10, .external_lex_state = 2},
  [444] = {.lex_state = 38, .external_lex_state = 2},
  [445] = {.lex_state = 38, .external_lex_state = 2},
  [446] = {.lex_state = 10, .external_lex_state = 2},
  [447] = {.lex_state = 38, .external_lex_state = 2},
  [448] = {.lex_state = 10},
  [449] = {.lex_state = 10},
  [450] = {.lex_state = 10},
  [451] = {.lex_state = 10},
  [452] = {.lex_state = 10},
  [453] = {.lex_state = 10},
  [454] = {.lex_state = 10},
  [455] = {.lex_state = 10},
  [456] = {.lex_state = 10},
  [457] = {.lex_state = 10},
  [458] = {.lex_state = 10},
  [459] = {.lex_state = 10},
  [460] = {.lex_state = 10},
  [461] = {.lex_state = 10},
  [462] = {.lex_state = 10},
  [463] = {.lex_state = 10},
  [464] = {.lex_state = 10},
  [465] = {.lex_state = 10},
  [466] = {.lex_state = 10},
  [467] = {.lex_state = 10},
  [468] = {.lex_state = 10},
  [469] = {.lex_state = 10},
  [470] = {.lex_state = 10},
  [471] = {.lex_state = 10},
  [472] = {.lex_state = 10},
  [473] = {.lex_state = 10},
  [474] = {.lex_state = 10},
  [475] = {.lex_state = 10},
  [476] = {.lex_state = 10},
  [477] = {.lex_state = 10},
  [478] = {.lex_state = 10},
  [479] = {.lex_state = 10},
  [480] = {.lex_state = 10},
  [481] = {.lex_state = 10},
  [482] = {.lex_state = 10},
  [483] = {.lex_state = 10},
  [484] = {.lex_state = 10},
  [485] = {.lex_state = 10},
  [486] = {.lex_state = 38, .external_lex_state = 2},
  [487] = {.lex_state = 10},
  [488] = {.lex_state = 10},
  [489] = {.lex_state = 10},
  [490] = {.lex_state = 38, .external_lex_state = 2},
  [491] = {.lex_state = 10},
  [492] = {.lex_state = 10},
  [493] = {.lex_state = 9},
  [494] = {.lex_state = 10},
  [495] = {.lex_state = 10},
  [496] = {.lex_state = 10},
  [497] = {.lex_state = 10},
  [498] = {.lex_state = 9},
  [499] = {.lex_state = 10, .external_lex_state = 6},
  [500] = {.lex_state = 10, .external_lex_state = 4},
  [501] = {.lex_state = 10, .external_lex_state = 4},
  [502] = {.lex_state = 10, .external_lex_state = 4},
  [503] = {.lex_state = 10, .external_lex_state = 6},
  [504] = {.lex_state = 10, .external_lex_state = 6},
  [505] = {.lex_state = 10, .external_lex_state = 6},
  [506] = {.lex_state = 38, .external_lex_state = 2},
  [507] = {.lex_state = 10},
  [508] = {.lex_state = 10, .external_lex_state = 6},
  [509] = {.lex_state = 10, .external_lex_state = 6},
  [510] = {.lex_state = 10, .external_lex_state = 6},
  [511] = {.lex_state = 10, .external_lex_state = 6},
  [512] = {.lex_state = 10},
  [513] = {.lex_state = 10, .external_lex_state = 6},
  [514] = {.lex_state = 10},
  [515] = {.lex_state = 10, .external_lex_state = 6},
  [516] = {.lex_state = 10, .external_lex_state = 6},
  [517] = {.lex_state = 10, .external_lex_state = 2},
  [518] = {.lex_state = 10},
  [519] = {.lex_state = 10, .external_lex_state = 2},
  [520] = {.lex_state = 10},
  [521] = {.lex_state = 10},
  [522] = {.lex_state = 9},
  [523] = {.lex_state = 10},
  [524] = {.lex_state = 10, .external_lex_state = 2},
  [525] = {.lex_state = 10},
  [526] = {.lex_state = 10},
  [527] = {.lex_state = 10, .external_lex_state = 4},
  [528] = {.lex_state = 10},
  [529] = {.lex_state = 9, .external_lex_state = 6},
  [530] = {.lex_state = 9},
  [531] = {.lex_state = 10, .external_lex_state = 4},
  [532] = {.lex_state = 10},
  [533] = {.lex_state = 10, .external_lex_state = 6},
  [534] = {.lex_state = 10, .external_lex_state = 6},
  [535] = {.lex_state = 10, .external_lex_state = 6},
  [536] = {.lex_state = 38, .external_lex_state = 2},
  [537] = {.lex_state = 10, .external_lex_state = 6},
  [538] = {.lex_state = 10, .external_lex_state = 6},
  [539] = {.lex_state = 10, .external_lex_state = 6},
  [540] = {.lex_state = 10, .external_lex_state = 6},
  [541] = {.lex_state = 10, .external_lex_state = 6},
  [542] = {.lex_state = 10},
  [543] = {.lex_state = 10, .external_lex_state = 6},
  [544] = {.lex_state = 38, .external_lex_state = 2},
  [545] = {.lex_state = 10},
  [546] = {.lex_state = 10, .external_lex_state = 6},
  [547] = {.lex_state = 10},
  [548] = {.lex_state = 38, .external_lex_state = 2},
  [549] = {.lex_state = 10, .external_lex_state = 6},
  [550] = {.lex_state = 10},
  [551] = {.lex_state = 10},
  [552] = {.lex_state = 10, .external_lex_state = 6},
  [553] = {.lex_state = 10},
  [554] = {.lex_state = 10, .external_lex_state = 6},
  [555] = {.lex_state = 10, .external_lex_state = 6},
  [556] = {.lex_state = 10, .external_lex_state = 6},
  [557] = {.lex_state = 10},
  [558] = {.lex_state = 10, .external_lex_state = 6},
  [559] = {.lex_state = 10, .external_lex_state = 6},
  [560] = {.lex_state = 38, .external_lex_state = 2},
  [561] = {.lex_state = 10},
  [562] = {.lex_state = 10, .external_lex_state = 6},
  [563] = {.lex_state = 10, .external_lex_state = 6},
  [564] = {.lex_state = 10},
  [565] = {.lex_state = 10},
  [566] = {.lex_state = 10},
  [567] = {.lex_state = 10, .external_lex_state = 6},
  [568] = {.lex_state = 10, .external_lex_state = 6},
  [569] = {.lex_state = 10},
  [570] = {.lex_state = 10},
  [571] = {.lex_state = 10, .external_lex_state = 6},
  [572] = {.lex_state = 10},
  [573] = {.lex_state = 10, .external_lex_state = 6},
  [574] = {.lex_state = 10, .external_lex_state = 6},
  [575] = {.lex_state = 10, .external_lex_state = 6},
  [576] = {.lex_state = 10, .external_lex_state = 6},
  [577] = {.lex_state = 9},
  [578] = {.lex_state = 38, .external_lex_state = 2},
  [579] = {.lex_state = 38, .external_lex_state = 2},
  [580] = {.lex_state = 38, .external_lex_state = 2},
  [581] = {.lex_state = 38, .external_lex_state = 2},
  [582] = {.lex_state = 38, .external_lex_state = 2},
  [583] = {.lex_state = 38, .external_lex_state = 2},
  [584] = {.lex_state = 38, .external_lex_state = 2},
  [585] = {.lex_state = 38, .external_lex_state = 2},
  [586] = {.lex_state = 38, .external_lex_state = 2},
  [587] = {.lex_state = 38, .external_lex_state = 2},
  [588] = {.lex_state = 38, .external_lex_state = 2},
  [589] = {.lex_state = 38, .external_lex_state = 2},
  [590] = {.lex_state = 38, .external_lex_state = 2},
  [591] = {.lex_state = 38, .external_lex_state = 2},
  [592] = {.lex_state = 9},
  [593] = {.lex_state = 10, .external_lex_state = 2},
  [594] = {.lex_state = 38, .external_lex_state = 2},
  [595] = {.lex_state = 38, .external_lex_state = 2},
  [596] = {.lex_state = 10, .external_lex_state = 2},
  [597] = {.lex_state = 38, .external_lex_state = 2},
  [598] = {.lex_state = 9},
  [599] = {.lex_state = 38, .external_lex_state = 2},
  [600] = {.lex_state = 38, .external_lex_state = 2},
  [601] = {.lex_state = 38, .external_lex_state = 2},
  [602] = {.lex_state = 38, .external_lex_state = 2},
  [603] = {.lex_state = 38, .external_lex_state = 2},
  [604] = {.lex_state = 38, .external_lex_state = 2},
  [605] = {.lex_state = 38, .external_lex_state = 2},
  [606] = {.lex_state = 38, .external_lex_state = 2},
  [607] = {.lex_state = 38, .external_lex_state = 2},
  [608] = {.lex_state = 38, .external_lex_state = 2},
  [609] = {.lex_state = 38, .external_lex_state = 2},
  [610] = {.lex_state = 38, .external_lex_state = 2},
  [611] = {.lex_state = 38, .external_lex_state = 2},
  [612] = {.lex_state = 38, .external_lex_state = 2},
  [613] = {.lex_state = 38, .external_lex_state = 2},
  [614] = {.lex_state = 38, .external_lex_state = 2},
  [615] = {.lex_state = 38, .external_lex_state = 2},
  [616] = {.lex_state = 38, .external_lex_state = 2},
  [617] = {.lex_state = 38, .external_lex_state = 2},
  [618] = {.lex_state = 38, .external_lex_state = 2},
  [619] = {.lex_state = 38, .external_lex_state = 2},
  [620] = {.lex_state = 38, .external_lex_state = 2},
  [621] = {.lex_state = 38, .external_lex_state = 2},
  [622] = {.lex_state = 38, .external_lex_state = 2},
  [623] = {.lex_state = 38, .external_lex_state = 2},
  [624] = {.lex_state = 10},
  [625] = {.lex_state = 10},
  [626] = {.lex_state = 10},
  [627] = {.lex_state = 10},
  [628] = {.lex_state = 10},
  [629] = {.lex_state = 10},
  [630] = {.lex_state = 10},
  [631] = {.lex_state = 10},
  [632] = {.lex_state = 10},
  [633] = {.lex_state = 10},
  [634] = {.lex_state = 10},
  [635] = {.lex_state = 10},
  [636] = {.lex_state = 10},
  [637] = {.lex_state = 10},
  [638] = {.lex_state = 10},
  [639] = {.lex_state = 10},
  [640] = {.lex_state = 10},
  [641] = {.lex_state = 10},
  [642] = {.lex_state = 10},
  [643] = {.lex_state = 10},
  [644] = {.lex_state = 10},
  [645] = {.lex_state = 10},
  [646] = {.lex_state = 10},
  [647] = {.lex_state = 10},
  [648] = {.lex_state = 10},
  [649] = {.lex_state = 10},
  [650] = {.lex_state = 10},
  [651] = {.lex_state = 10},
  [652] = {.lex_state = 10},
  [653] = {.lex_state = 10},
  [654] = {.lex_state = 38},
  [655] = {.lex_state = 38},
  [656] = {.lex_state = 38},
  [657] = {.lex_state = 38},
  [658] = {.lex_state = 38},
  [659] = {.lex_state = 38},
  [660] = {.lex_state = 38},
  [661] = {.lex_state = 0, .external_lex_state = 6},
  [662] = {.lex_state = 38},
  [663] = {.lex_state = 38},
  [664] = {.lex_state = 38},
  [665] = {.lex_state = 38},
  [666] = {.lex_state = 0, .external_lex_state = 6},
  [667] = {.lex_state = 10},
  [668] = {.lex_state = 10},
  [669] = {.lex_state = 10},
  [670] = {.lex_state = 38},
  [671] = {.lex_state = 38},
  [672] = {.lex_state = 38},
  [673] = {.lex_state = 38},
  [674] = {.lex_state = 38},
  [675] = {.lex_state = 38},
  [676] = {.lex_state = 38},
  [677] = {.lex_state = 38},
  [678] = {.lex_state = 38},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 38},
  [683] = {.lex_state = 38},
  [684] = {.lex_state = 38},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 38},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 38},
  [689] = {.lex_state = 38},
  [690] = {.lex_state = 38},
  [691] = {.lex_state = 38},
  [692] = {.lex_state = 38},
  [693] = {.lex_state = 38},
  [694] = {.lex_state = 38},
  [695] = {.lex_state = 38},
  [696] = {.lex_state = 38},
  [697] = {.lex_state = 38},
  [698] = {.lex_state = 38},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 38},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 38},
  [703] = {.lex_state = 38},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 38},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 38},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 38},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0, .external_lex_state = 6},
  [722] = {.lex_state = 0, .external_lex_state = 6},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0, .external_lex_state = 6},
  [725] = {.lex_state = 0, .external_lex_state = 6},
  [726] = {.lex_state = 0, .external_lex_state = 6},
  [727] = {.lex_state = 0, .external_lex_state = 6},
  [728] = {.lex_state = 0, .external_lex_state = 6},
  [729] = {.lex_state = 0, .external_lex_state = 6},
  [730] = {.lex_state = 0},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0, .external_lex_state = 6},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0, .external_lex_state = 6},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 10, .external_lex_state = 6},
  [739] = {.lex_state = 12, .external_lex_state = 7},
  [740] = {.lex_state = 38},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 12, .external_lex_state = 7},
  [743] = {.lex_state = 12, .external_lex_state = 7},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0, .external_lex_state = 6},
  [746] = {.lex_state = 12, .external_lex_state = 7},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 38},
  [749] = {.lex_state = 12, .external_lex_state = 7},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 38},
  [753] = {.lex_state = 38},
  [754] = {.lex_state = 12, .external_lex_state = 7},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 12, .external_lex_state = 7},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0, .external_lex_state = 6},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 12, .external_lex_state = 7},
  [762] = {.lex_state = 38},
  [763] = {.lex_state = 10, .external_lex_state = 6},
  [764] = {.lex_state = 10, .external_lex_state = 6},
  [765] = {.lex_state = 12, .external_lex_state = 7},
  [766] = {.lex_state = 10},
  [767] = {.lex_state = 38},
  [768] = {.lex_state = 0, .external_lex_state = 6},
  [769] = {.lex_state = 0, .external_lex_state = 6},
  [770] = {.lex_state = 0, .external_lex_state = 6},
  [771] = {.lex_state = 10, .external_lex_state = 6},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 38},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 38},
  [776] = {.lex_state = 38},
  [777] = {.lex_state = 38},
  [778] = {.lex_state = 38},
  [779] = {.lex_state = 38},
  [780] = {.lex_state = 0, .external_lex_state = 6},
  [781] = {.lex_state = 38},
  [782] = {.lex_state = 38},
  [783] = {.lex_state = 38},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 38},
  [786] = {.lex_state = 38},
  [787] = {.lex_state = 38},
  [788] = {.lex_state = 38},
  [789] = {.lex_state = 10},
  [790] = {.lex_state = 38},
  [791] = {.lex_state = 0, .external_lex_state = 6},
  [792] = {.lex_state = 10},
  [793] = {.lex_state = 38},
  [794] = {.lex_state = 0, .external_lex_state = 6},
  [795] = {.lex_state = 38},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 38},
  [798] = {.lex_state = 10},
  [799] = {.lex_state = 38},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 38},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 12, .external_lex_state = 7},
  [805] = {.lex_state = 0, .external_lex_state = 6},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 4},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 12, .external_lex_state = 7},
  [812] = {.lex_state = 38},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0, .external_lex_state = 6},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0, .external_lex_state = 6},
  [817] = {.lex_state = 0, .external_lex_state = 6},
  [818] = {.lex_state = 0, .external_lex_state = 6},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 38},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 4},
  [824] = {.lex_state = 0, .external_lex_state = 6},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 10},
  [827] = {.lex_state = 4},
  [828] = {.lex_state = 12, .external_lex_state = 7},
  [829] = {.lex_state = 0, .external_lex_state = 6},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0, .external_lex_state = 6},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0, .external_lex_state = 6},
  [835] = {.lex_state = 0, .external_lex_state = 6},
  [836] = {.lex_state = 38},
  [837] = {.lex_state = 38},
  [838] = {.lex_state = 10},
  [839] = {.lex_state = 10},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 38},
  [844] = {.lex_state = 38},
  [845] = {.lex_state = 38},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 38},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0, .external_lex_state = 6},
  [852] = {.lex_state = 0, .external_lex_state = 6},
  [853] = {.lex_state = 38},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0, .external_lex_state = 6},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 38},
  [859] = {.lex_state = 0, .external_lex_state = 6},
  [860] = {.lex_state = 38},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 38},
  [863] = {.lex_state = 38},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0, .external_lex_state = 6},
  [866] = {.lex_state = 38},
  [867] = {.lex_state = 0, .external_lex_state = 6},
  [868] = {.lex_state = 0, .external_lex_state = 6},
  [869] = {.lex_state = 0, .external_lex_state = 6},
  [870] = {.lex_state = 0, .external_lex_state = 6},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0, .external_lex_state = 6},
  [873] = {.lex_state = 0, .external_lex_state = 6},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0, .external_lex_state = 6},
  [876] = {.lex_state = 0, .external_lex_state = 6},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0, .external_lex_state = 6},
  [879] = {.lex_state = 38},
  [880] = {.lex_state = 0, .external_lex_state = 6},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0, .external_lex_state = 6},
  [883] = {.lex_state = 38},
  [884] = {.lex_state = 0, .external_lex_state = 6},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0, .external_lex_state = 6},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 38},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0, .external_lex_state = 6},
  [901] = {.lex_state = 38},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0, .external_lex_state = 6},
  [904] = {.lex_state = 4},
  [905] = {.lex_state = 38},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0, .external_lex_state = 6},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 38},
  [914] = {.lex_state = 0, .external_lex_state = 6},
  [915] = {.lex_state = 38},
  [916] = {.lex_state = 38},
  [917] = {.lex_state = 38},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0, .external_lex_state = 6},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 38},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 38},
  [925] = {.lex_state = 38},
  [926] = {.lex_state = 0, .external_lex_state = 6},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 38},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 38},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0, .external_lex_state = 6},
  [936] = {.lex_state = 0, .external_lex_state = 6},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 38},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 38},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 38},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 38},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 38},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 38},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0, .external_lex_state = 6},
  [962] = {.lex_state = 38},
  [963] = {.lex_state = 0, .external_lex_state = 6},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0, .external_lex_state = 6},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0, .external_lex_state = 6},
  [971] = {.lex_state = 38},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0, .external_lex_state = 6},
  [976] = {.lex_state = 0, .external_lex_state = 6},
  [977] = {.lex_state = 0, .external_lex_state = 6},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0, .external_lex_state = 6},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0, .external_lex_state = 6},
  [982] = {.lex_state = 0, .external_lex_state = 6},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0, .external_lex_state = 6},
  [985] = {.lex_state = 38},
  [986] = {.lex_state = 11},
  [987] = {.lex_state = 0, .external_lex_state = 6},
  [988] = {.lex_state = 11},
  [989] = {.lex_state = 0, .external_lex_state = 6},
  [990] = {.lex_state = 0, .external_lex_state = 6},
  [991] = {.lex_state = 0, .external_lex_state = 6},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 38},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 11},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 38},
  [999] = {.lex_state = 11},
  [1000] = {.lex_state = 11},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 11},
  [1003] = {.lex_state = 0, .external_lex_state = 6},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0, .external_lex_state = 6},
  [1010] = {.lex_state = 0, .external_lex_state = 6},
  [1011] = {.lex_state = 0, .external_lex_state = 6},
  [1012] = {.lex_state = 0, .external_lex_state = 6},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0, .external_lex_state = 6},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 38},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 38},
  [1035] = {.lex_state = 38},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 38},
  [1044] = {.lex_state = 38},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 38},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 38},
  [1054] = {.lex_state = 38},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 38},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0, .external_lex_state = 6},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 38},
  [1066] = {.lex_state = 38},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 38},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 38},
  [1071] = {.lex_state = 38},
  [1072] = {.lex_state = 38},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 38},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 38},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 38},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 38},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 38},
  [1091] = {.lex_state = 38},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 38},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
};

enum {
  ts_external_token__newline = 0,
  ts_external_token__indent = 1,
  ts_external_token__dedent = 2,
  ts_external_token__string_start = 3,
  ts_external_token__string_content = 4,
  ts_external_token__string_end = 5,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
};

static bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [2] = {
    [ts_external_token__string_start] = true,
  },
  [3] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
  },
  [4] = {
    [ts_external_token__newline] = true,
    [ts_external_token__string_start] = true,
  },
  [5] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__string_start] = true,
  },
  [6] = {
    [ts_external_token__newline] = true,
  },
  [7] = {
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__semicolon] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(1062),
    [sym__statement] = STATE(47),
    [sym__simple_statements] = STATE(47),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym_if_statement] = STATE(47),
    [sym_for_statement] = STATE(47),
    [sym_while_statement] = STATE(47),
    [sym_try_statement] = STATE(47),
    [sym_with_statement] = STATE(47),
    [sym_function_definition] = STATE(47),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_class_definition] = STATE(47),
    [sym_decorated_definition] = STATE(47),
    [sym_decorator] = STATE(723),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(47),
    [aux_sym_decorated_definition_repeat1] = STATE(723),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_with] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(75),
  },
  [2] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(246),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [3] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(403),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [4] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(382),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [5] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(263),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [6] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(182),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [7] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(338),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [8] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(287),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [9] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(388),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [10] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(390),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [11] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(365),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [12] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(437),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [13] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(187),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [14] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(431),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [15] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(317),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [16] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(406),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [17] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(368),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [18] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(369),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [19] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(398),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [20] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(413),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [21] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(436),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [22] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(400),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [23] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(363),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [24] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(336),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [25] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(815),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [26] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(261),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [27] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(399),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [28] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(329),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [29] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(298),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [30] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(259),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [31] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(359),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [32] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(357),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [33] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(356),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [34] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_try_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(45),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(813),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(75),
  },
  [35] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(429),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [36] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(237),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [37] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(425),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [38] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(377),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [39] = {
    [sym__statement] = STATE(46),
    [sym__simple_statements] = STATE(46),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(46),
    [sym_for_statement] = STATE(46),
    [sym_while_statement] = STATE(46),
    [sym_try_statement] = STATE(46),
    [sym_with_statement] = STATE(46),
    [sym_function_definition] = STATE(46),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(46),
    [sym_decorated_definition] = STATE(46),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(235),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(46),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(75),
  },
  [40] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(346),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [41] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_try_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(44),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(731),
    [sym_block] = STATE(380),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(75),
  },
  [42] = {
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_try_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(42),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(731),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(99),
    [anon_sym_import] = ACTIONS(102),
    [anon_sym_from] = ACTIONS(105),
    [anon_sym_LPAREN] = ACTIONS(108),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(114),
    [anon_sym_assert] = ACTIONS(117),
    [anon_sym_return] = ACTIONS(120),
    [anon_sym_del] = ACTIONS(123),
    [anon_sym_raise] = ACTIONS(126),
    [anon_sym_pass] = ACTIONS(129),
    [anon_sym_break] = ACTIONS(132),
    [anon_sym_continue] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(138),
    [anon_sym_async] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(144),
    [anon_sym_while] = ACTIONS(147),
    [anon_sym_try] = ACTIONS(150),
    [anon_sym_with] = ACTIONS(153),
    [anon_sym_def] = ACTIONS(156),
    [anon_sym_LBRACK] = ACTIONS(159),
    [anon_sym_global] = ACTIONS(162),
    [anon_sym_nonlocal] = ACTIONS(165),
    [anon_sym_exec] = ACTIONS(168),
    [anon_sym_class] = ACTIONS(171),
    [anon_sym_AT] = ACTIONS(174),
    [anon_sym_not] = ACTIONS(177),
    [anon_sym_PLUS] = ACTIONS(180),
    [anon_sym_DASH] = ACTIONS(180),
    [anon_sym_TILDE] = ACTIONS(180),
    [anon_sym_lambda] = ACTIONS(183),
    [anon_sym_yield] = ACTIONS(186),
    [sym_ellipsis] = ACTIONS(189),
    [anon_sym_LBRACE] = ACTIONS(192),
    [sym_integer] = ACTIONS(195),
    [sym_float] = ACTIONS(189),
    [sym_true] = ACTIONS(195),
    [sym_false] = ACTIONS(195),
    [sym_none] = ACTIONS(195),
    [anon_sym_await] = ACTIONS(198),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(201),
    [sym__string_start] = ACTIONS(203),
  },
  [43] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(723),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(723),
    [ts_builtin_sym_end] = ACTIONS(201),
    [sym_identifier] = ACTIONS(99),
    [anon_sym_import] = ACTIONS(102),
    [anon_sym_from] = ACTIONS(105),
    [anon_sym_LPAREN] = ACTIONS(108),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_print] = ACTIONS(114),
    [anon_sym_assert] = ACTIONS(117),
    [anon_sym_return] = ACTIONS(120),
    [anon_sym_del] = ACTIONS(123),
    [anon_sym_raise] = ACTIONS(126),
    [anon_sym_pass] = ACTIONS(129),
    [anon_sym_break] = ACTIONS(132),
    [anon_sym_continue] = ACTIONS(135),
    [anon_sym_if] = ACTIONS(206),
    [anon_sym_async] = ACTIONS(209),
    [anon_sym_for] = ACTIONS(212),
    [anon_sym_while] = ACTIONS(215),
    [anon_sym_try] = ACTIONS(218),
    [anon_sym_with] = ACTIONS(221),
    [anon_sym_def] = ACTIONS(224),
    [anon_sym_LBRACK] = ACTIONS(159),
    [anon_sym_global] = ACTIONS(162),
    [anon_sym_nonlocal] = ACTIONS(165),
    [anon_sym_exec] = ACTIONS(168),
    [anon_sym_class] = ACTIONS(227),
    [anon_sym_AT] = ACTIONS(174),
    [anon_sym_not] = ACTIONS(177),
    [anon_sym_PLUS] = ACTIONS(180),
    [anon_sym_DASH] = ACTIONS(180),
    [anon_sym_TILDE] = ACTIONS(180),
    [anon_sym_lambda] = ACTIONS(183),
    [anon_sym_yield] = ACTIONS(186),
    [sym_ellipsis] = ACTIONS(189),
    [anon_sym_LBRACE] = ACTIONS(192),
    [sym_integer] = ACTIONS(195),
    [sym_float] = ACTIONS(189),
    [sym_true] = ACTIONS(195),
    [sym_false] = ACTIONS(195),
    [sym_none] = ACTIONS(195),
    [anon_sym_await] = ACTIONS(198),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(203),
  },
  [44] = {
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_try_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(42),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(731),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(230),
    [sym__string_start] = ACTIONS(75),
  },
  [45] = {
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_try_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(42),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(731),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(232),
    [sym__string_start] = ACTIONS(75),
  },
  [46] = {
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_if_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_try_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_class_definition] = STATE(42),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(731),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(731),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_async] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_try] = ACTIONS(85),
    [anon_sym_with] = ACTIONS(87),
    [anon_sym_def] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(234),
    [sym__string_start] = ACTIONS(75),
  },
  [47] = {
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym_if_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_try_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_class_definition] = STATE(43),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(723),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(723),
    [ts_builtin_sym_end] = ACTIONS(236),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_if] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(35),
    [anon_sym_for] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_with] = ACTIONS(43),
    [anon_sym_def] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(75),
  },
  [48] = {
    [sym_chevron] = STATE(859),
    [sym_named_expression] = STATE(727),
    [sym_expression] = STATE(768),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_attribute] = STATE(534),
    [sym_subscript] = STATE(534),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(238),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(242),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_print] = ACTIONS(247),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_COLON] = ACTIONS(251),
    [anon_sym_in] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(242),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_STAR_STAR] = ACTIONS(240),
    [anon_sym_exec] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_PERCENT] = ACTIONS(240),
    [anon_sym_SLASH_SLASH] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_AMP] = ACTIONS(240),
    [anon_sym_CARET] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(242),
    [anon_sym_EQ_EQ] = ACTIONS(242),
    [anon_sym_BANG_EQ] = ACTIONS(242),
    [anon_sym_GT_EQ] = ACTIONS(242),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_LT_GT] = ACTIONS(242),
    [anon_sym_is] = ACTIONS(240),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_PLUS_EQ] = ACTIONS(251),
    [anon_sym_DASH_EQ] = ACTIONS(251),
    [anon_sym_STAR_EQ] = ACTIONS(251),
    [anon_sym_SLASH_EQ] = ACTIONS(251),
    [anon_sym_AT_EQ] = ACTIONS(251),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(251),
    [anon_sym_PERCENT_EQ] = ACTIONS(251),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(251),
    [anon_sym_GT_GT_EQ] = ACTIONS(251),
    [anon_sym_LT_LT_EQ] = ACTIONS(251),
    [anon_sym_AMP_EQ] = ACTIONS(251),
    [anon_sym_CARET_EQ] = ACTIONS(251),
    [anon_sym_PIPE_EQ] = ACTIONS(251),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__semicolon] = ACTIONS(242),
    [sym__newline] = ACTIONS(242),
    [sym__string_start] = ACTIONS(75),
  },
  [49] = {
    [sym__simple_statements] = STATE(201),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(255),
    [sym__indent] = ACTIONS(257),
    [sym__string_start] = ACTIONS(75),
  },
  [50] = {
    [sym__simple_statements] = STATE(420),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(259),
    [sym__indent] = ACTIONS(261),
    [sym__string_start] = ACTIONS(75),
  },
  [51] = {
    [sym__simple_statements] = STATE(383),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(263),
    [sym__indent] = ACTIONS(265),
    [sym__string_start] = ACTIONS(75),
  },
  [52] = {
    [sym__simple_statements] = STATE(360),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(267),
    [sym__indent] = ACTIONS(269),
    [sym__string_start] = ACTIONS(75),
  },
  [53] = {
    [sym__simple_statements] = STATE(387),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(271),
    [sym__indent] = ACTIONS(273),
    [sym__string_start] = ACTIONS(75),
  },
  [54] = {
    [sym__simple_statements] = STATE(361),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(275),
    [sym__indent] = ACTIONS(277),
    [sym__string_start] = ACTIONS(75),
  },
  [55] = {
    [sym__simple_statements] = STATE(283),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(279),
    [sym__indent] = ACTIONS(281),
    [sym__string_start] = ACTIONS(75),
  },
  [56] = {
    [sym__simple_statements] = STATE(378),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(283),
    [sym__indent] = ACTIONS(285),
    [sym__string_start] = ACTIONS(75),
  },
  [57] = {
    [sym__simple_statements] = STATE(244),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(287),
    [sym__indent] = ACTIONS(289),
    [sym__string_start] = ACTIONS(75),
  },
  [58] = {
    [sym__simple_statements] = STATE(381),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(291),
    [sym__indent] = ACTIONS(293),
    [sym__string_start] = ACTIONS(75),
  },
  [59] = {
    [sym__simple_statements] = STATE(412),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(295),
    [sym__indent] = ACTIONS(297),
    [sym__string_start] = ACTIONS(75),
  },
  [60] = {
    [sym__simple_statements] = STATE(394),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(299),
    [sym__indent] = ACTIONS(301),
    [sym__string_start] = ACTIONS(75),
  },
  [61] = {
    [sym__simple_statements] = STATE(375),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(303),
    [sym__indent] = ACTIONS(305),
    [sym__string_start] = ACTIONS(75),
  },
  [62] = {
    [sym__simple_statements] = STATE(323),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(307),
    [sym__indent] = ACTIONS(309),
    [sym__string_start] = ACTIONS(75),
  },
  [63] = {
    [sym__simple_statements] = STATE(366),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(311),
    [sym__indent] = ACTIONS(313),
    [sym__string_start] = ACTIONS(75),
  },
  [64] = {
    [sym__simple_statements] = STATE(275),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(315),
    [sym__indent] = ACTIONS(317),
    [sym__string_start] = ACTIONS(75),
  },
  [65] = {
    [sym__simple_statements] = STATE(256),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(319),
    [sym__indent] = ACTIONS(321),
    [sym__string_start] = ACTIONS(75),
  },
  [66] = {
    [sym__simple_statements] = STATE(417),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(323),
    [sym__indent] = ACTIONS(325),
    [sym__string_start] = ACTIONS(75),
  },
  [67] = {
    [sym__simple_statements] = STATE(260),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(327),
    [sym__indent] = ACTIONS(329),
    [sym__string_start] = ACTIONS(75),
  },
  [68] = {
    [sym__simple_statements] = STATE(810),
    [sym_import_statement] = STATE(886),
    [sym_future_import_statement] = STATE(886),
    [sym_import_from_statement] = STATE(886),
    [sym_print_statement] = STATE(886),
    [sym_assert_statement] = STATE(886),
    [sym_expression_statement] = STATE(886),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(886),
    [sym_delete_statement] = STATE(886),
    [sym_raise_statement] = STATE(886),
    [sym_pass_statement] = STATE(886),
    [sym_break_statement] = STATE(886),
    [sym_continue_statement] = STATE(886),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(886),
    [sym_nonlocal_statement] = STATE(886),
    [sym_exec_statement] = STATE(886),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(331),
    [sym__indent] = ACTIONS(333),
    [sym__string_start] = ACTIONS(75),
  },
  [69] = {
    [sym__simple_statements] = STATE(423),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(335),
    [sym__indent] = ACTIONS(337),
    [sym__string_start] = ACTIONS(75),
  },
  [70] = {
    [sym__simple_statements] = STATE(185),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(339),
    [sym__indent] = ACTIONS(341),
    [sym__string_start] = ACTIONS(75),
  },
  [71] = {
    [sym__simple_statements] = STATE(310),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(343),
    [sym__indent] = ACTIONS(345),
    [sym__string_start] = ACTIONS(75),
  },
  [72] = {
    [sym__simple_statements] = STATE(367),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(347),
    [sym__indent] = ACTIONS(349),
    [sym__string_start] = ACTIONS(75),
  },
  [73] = {
    [sym__simple_statements] = STATE(404),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(351),
    [sym__indent] = ACTIONS(353),
    [sym__string_start] = ACTIONS(75),
  },
  [74] = {
    [sym__simple_statements] = STATE(358),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(355),
    [sym__indent] = ACTIONS(357),
    [sym__string_start] = ACTIONS(75),
  },
  [75] = {
    [sym__simple_statements] = STATE(258),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(359),
    [sym__indent] = ACTIONS(361),
    [sym__string_start] = ACTIONS(75),
  },
  [76] = {
    [sym__simple_statements] = STATE(324),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(363),
    [sym__indent] = ACTIONS(365),
    [sym__string_start] = ACTIONS(75),
  },
  [77] = {
    [sym__simple_statements] = STATE(262),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(367),
    [sym__indent] = ACTIONS(369),
    [sym__string_start] = ACTIONS(75),
  },
  [78] = {
    [sym__simple_statements] = STATE(295),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__indent] = ACTIONS(373),
    [sym__string_start] = ACTIONS(75),
  },
  [79] = {
    [sym__simple_statements] = STATE(430),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(375),
    [sym__indent] = ACTIONS(377),
    [sym__string_start] = ACTIONS(75),
  },
  [80] = {
    [sym__simple_statements] = STATE(825),
    [sym_import_statement] = STATE(886),
    [sym_future_import_statement] = STATE(886),
    [sym_import_from_statement] = STATE(886),
    [sym_print_statement] = STATE(886),
    [sym_assert_statement] = STATE(886),
    [sym_expression_statement] = STATE(886),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(886),
    [sym_delete_statement] = STATE(886),
    [sym_raise_statement] = STATE(886),
    [sym_pass_statement] = STATE(886),
    [sym_break_statement] = STATE(886),
    [sym_continue_statement] = STATE(886),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(886),
    [sym_nonlocal_statement] = STATE(886),
    [sym_exec_statement] = STATE(886),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__indent] = ACTIONS(381),
    [sym__string_start] = ACTIONS(75),
  },
  [81] = {
    [sym__simple_statements] = STATE(370),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__indent] = ACTIONS(385),
    [sym__string_start] = ACTIONS(75),
  },
  [82] = {
    [sym__simple_statements] = STATE(331),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(387),
    [sym__indent] = ACTIONS(389),
    [sym__string_start] = ACTIONS(75),
  },
  [83] = {
    [sym__simple_statements] = STATE(386),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(391),
    [sym__indent] = ACTIONS(393),
    [sym__string_start] = ACTIONS(75),
  },
  [84] = {
    [sym__simple_statements] = STATE(364),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(395),
    [sym__indent] = ACTIONS(397),
    [sym__string_start] = ACTIONS(75),
  },
  [85] = {
    [sym__simple_statements] = STATE(349),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(399),
    [sym__indent] = ACTIONS(401),
    [sym__string_start] = ACTIONS(75),
  },
  [86] = {
    [sym__simple_statements] = STATE(374),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(403),
    [sym__indent] = ACTIONS(405),
    [sym__string_start] = ACTIONS(75),
  },
  [87] = {
    [sym__simple_statements] = STATE(371),
    [sym_import_statement] = STATE(919),
    [sym_future_import_statement] = STATE(919),
    [sym_import_from_statement] = STATE(919),
    [sym_print_statement] = STATE(919),
    [sym_assert_statement] = STATE(919),
    [sym_expression_statement] = STATE(919),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(919),
    [sym_delete_statement] = STATE(919),
    [sym_raise_statement] = STATE(919),
    [sym_pass_statement] = STATE(919),
    [sym_break_statement] = STATE(919),
    [sym_continue_statement] = STATE(919),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(919),
    [sym_nonlocal_statement] = STATE(919),
    [sym_exec_statement] = STATE(919),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(407),
    [sym__indent] = ACTIONS(409),
    [sym__string_start] = ACTIONS(75),
  },
  [88] = {
    [sym__simple_statements] = STATE(245),
    [sym_import_statement] = STATE(914),
    [sym_future_import_statement] = STATE(914),
    [sym_import_from_statement] = STATE(914),
    [sym_print_statement] = STATE(914),
    [sym_assert_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(914),
    [sym_delete_statement] = STATE(914),
    [sym_raise_statement] = STATE(914),
    [sym_pass_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(914),
    [sym_nonlocal_statement] = STATE(914),
    [sym_exec_statement] = STATE(914),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(411),
    [sym__indent] = ACTIONS(413),
    [sym__string_start] = ACTIONS(75),
  },
  [89] = {
    [sym_import_statement] = STATE(991),
    [sym_future_import_statement] = STATE(991),
    [sym_import_from_statement] = STATE(991),
    [sym_print_statement] = STATE(991),
    [sym_assert_statement] = STATE(991),
    [sym_expression_statement] = STATE(991),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(991),
    [sym_delete_statement] = STATE(991),
    [sym_raise_statement] = STATE(991),
    [sym_pass_statement] = STATE(991),
    [sym_break_statement] = STATE(991),
    [sym_continue_statement] = STATE(991),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(991),
    [sym_nonlocal_statement] = STATE(991),
    [sym_exec_statement] = STATE(991),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(415),
    [sym__string_start] = ACTIONS(75),
  },
  [90] = {
    [sym_import_statement] = STATE(991),
    [sym_future_import_statement] = STATE(991),
    [sym_import_from_statement] = STATE(991),
    [sym_print_statement] = STATE(991),
    [sym_assert_statement] = STATE(991),
    [sym_expression_statement] = STATE(991),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(991),
    [sym_delete_statement] = STATE(991),
    [sym_raise_statement] = STATE(991),
    [sym_pass_statement] = STATE(991),
    [sym_break_statement] = STATE(991),
    [sym_continue_statement] = STATE(991),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(991),
    [sym_nonlocal_statement] = STATE(991),
    [sym_exec_statement] = STATE(991),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(417),
    [sym__string_start] = ACTIONS(75),
  },
  [91] = {
    [sym_import_statement] = STATE(991),
    [sym_future_import_statement] = STATE(991),
    [sym_import_from_statement] = STATE(991),
    [sym_print_statement] = STATE(991),
    [sym_assert_statement] = STATE(991),
    [sym_expression_statement] = STATE(991),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(991),
    [sym_delete_statement] = STATE(991),
    [sym_raise_statement] = STATE(991),
    [sym_pass_statement] = STATE(991),
    [sym_break_statement] = STATE(991),
    [sym_continue_statement] = STATE(991),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(991),
    [sym_nonlocal_statement] = STATE(991),
    [sym_exec_statement] = STATE(991),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(419),
    [sym__string_start] = ACTIONS(75),
  },
  [92] = {
    [sym_import_statement] = STATE(991),
    [sym_future_import_statement] = STATE(991),
    [sym_import_from_statement] = STATE(991),
    [sym_print_statement] = STATE(991),
    [sym_assert_statement] = STATE(991),
    [sym_expression_statement] = STATE(991),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(991),
    [sym_delete_statement] = STATE(991),
    [sym_raise_statement] = STATE(991),
    [sym_pass_statement] = STATE(991),
    [sym_break_statement] = STATE(991),
    [sym_continue_statement] = STATE(991),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(991),
    [sym_nonlocal_statement] = STATE(991),
    [sym_exec_statement] = STATE(991),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(421),
    [sym__string_start] = ACTIONS(75),
  },
  [93] = {
    [sym_import_statement] = STATE(991),
    [sym_future_import_statement] = STATE(991),
    [sym_import_from_statement] = STATE(991),
    [sym_print_statement] = STATE(991),
    [sym_assert_statement] = STATE(991),
    [sym_expression_statement] = STATE(991),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(991),
    [sym_delete_statement] = STATE(991),
    [sym_raise_statement] = STATE(991),
    [sym_pass_statement] = STATE(991),
    [sym_break_statement] = STATE(991),
    [sym_continue_statement] = STATE(991),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(991),
    [sym_nonlocal_statement] = STATE(991),
    [sym_exec_statement] = STATE(991),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(423),
    [sym__string_start] = ACTIONS(75),
  },
  [94] = {
    [sym_import_statement] = STATE(991),
    [sym_future_import_statement] = STATE(991),
    [sym_import_from_statement] = STATE(991),
    [sym_print_statement] = STATE(991),
    [sym_assert_statement] = STATE(991),
    [sym_expression_statement] = STATE(991),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(991),
    [sym_delete_statement] = STATE(991),
    [sym_raise_statement] = STATE(991),
    [sym_pass_statement] = STATE(991),
    [sym_break_statement] = STATE(991),
    [sym_continue_statement] = STATE(991),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(991),
    [sym_nonlocal_statement] = STATE(991),
    [sym_exec_statement] = STATE(991),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(425),
    [sym__string_start] = ACTIONS(75),
  },
  [95] = {
    [sym_import_statement] = STATE(991),
    [sym_future_import_statement] = STATE(991),
    [sym_import_from_statement] = STATE(991),
    [sym_print_statement] = STATE(991),
    [sym_assert_statement] = STATE(991),
    [sym_expression_statement] = STATE(991),
    [sym_named_expression] = STATE(727),
    [sym_return_statement] = STATE(991),
    [sym_delete_statement] = STATE(991),
    [sym_raise_statement] = STATE(991),
    [sym_pass_statement] = STATE(991),
    [sym_break_statement] = STATE(991),
    [sym_continue_statement] = STATE(991),
    [sym__patterns] = STATE(676),
    [sym_pattern] = STATE(659),
    [sym_tuple_pattern] = STATE(664),
    [sym_list_pattern] = STATE(664),
    [sym_list_splat_pattern] = STATE(664),
    [sym_global_statement] = STATE(991),
    [sym_nonlocal_statement] = STATE(991),
    [sym_exec_statement] = STATE(991),
    [sym_expression] = STATE(745),
    [sym_primary_expression] = STATE(499),
    [sym_not_operator] = STATE(727),
    [sym_boolean_operator] = STATE(727),
    [sym_binary_operator] = STATE(534),
    [sym_unary_operator] = STATE(534),
    [sym_comparison_operator] = STATE(727),
    [sym_lambda] = STATE(727),
    [sym_assignment] = STATE(984),
    [sym_augmented_assignment] = STATE(984),
    [sym_left_hand_side] = STATE(678),
    [sym_yield] = STATE(984),
    [sym_attribute] = STATE(179),
    [sym_subscript] = STATE(179),
    [sym_call] = STATE(534),
    [sym_list] = STATE(534),
    [sym_list_comprehension] = STATE(534),
    [sym_dictionary] = STATE(534),
    [sym_dictionary_comprehension] = STATE(534),
    [sym_set] = STATE(534),
    [sym_set_comprehension] = STATE(534),
    [sym_parenthesized_expression] = STATE(534),
    [sym_tuple] = STATE(534),
    [sym_generator_expression] = STATE(534),
    [sym_conditional_expression] = STATE(727),
    [sym_concatenated_string] = STATE(534),
    [sym_string] = STATE(500),
    [sym_await] = STATE(727),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_del] = ACTIONS(23),
    [anon_sym_raise] = ACTIONS(25),
    [anon_sym_pass] = ACTIONS(27),
    [anon_sym_break] = ACTIONS(29),
    [anon_sym_continue] = ACTIONS(31),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_not] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_lambda] = ACTIONS(63),
    [anon_sym_yield] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(67),
    [anon_sym_LBRACE] = ACTIONS(69),
    [sym_integer] = ACTIONS(71),
    [sym_float] = ACTIONS(67),
    [sym_true] = ACTIONS(71),
    [sym_false] = ACTIONS(71),
    [sym_none] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(75),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(47), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(65), 1,
      anon_sym_yield,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(676), 1,
      sym__patterns,
    STATE(678), 1,
      sym_left_hand_side,
    STATE(724), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(427), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(179), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(987), 5,
      sym_expression_list,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
      sym_yield,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [111] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(47), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(65), 1,
      anon_sym_yield,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(676), 1,
      sym__patterns,
    STATE(678), 1,
      sym_left_hand_side,
    STATE(724), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(427), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(179), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(981), 5,
      sym_expression_list,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
      sym_yield,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [222] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(47), 1,
      anon_sym_LBRACK,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(65), 1,
      anon_sym_yield,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(676), 1,
      sym__patterns,
    STATE(678), 1,
      sym_left_hand_side,
    STATE(724), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(427), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(179), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(982), 5,
      sym_expression_list,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
      sym_yield,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [333] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(433), 1,
      anon_sym_STAR,
    ACTIONS(437), 1,
      anon_sym_LBRACK,
    ACTIONS(439), 1,
      anon_sym_RBRACK,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(659), 1,
      sym_pattern,
    STATE(706), 1,
      sym_expression,
    STATE(1040), 1,
      sym__patterns,
    STATE(1092), 1,
      sym__collection_elements,
    ACTIONS(435), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    STATE(572), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    STATE(855), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [445] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(433), 1,
      anon_sym_STAR,
    ACTIONS(437), 1,
      anon_sym_LBRACK,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(459), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(659), 1,
      sym_pattern,
    STATE(706), 1,
      sym_expression,
    STATE(1040), 1,
      sym__patterns,
    STATE(1092), 1,
      sym__collection_elements,
    ACTIONS(435), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    STATE(572), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    STATE(855), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [557] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(471), 1,
      anon_sym_in,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_TILDE,
    STATE(372), 1,
      sym_string,
    STATE(665), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(475), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
    ACTIONS(465), 17,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [655] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(433), 1,
      anon_sym_STAR,
    ACTIONS(437), 1,
      anon_sym_LBRACK,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(479), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(659), 1,
      sym_pattern,
    STATE(711), 1,
      sym_expression,
    STATE(929), 1,
      sym_yield,
    STATE(1018), 1,
      sym__patterns,
    STATE(1033), 1,
      sym__collection_elements,
    ACTIONS(435), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    STATE(572), 2,
      sym_attribute,
      sym_subscript,
    STATE(855), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [769] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    ACTIONS(477), 1,
      anon_sym_TILDE,
    ACTIONS(483), 1,
      anon_sym_in,
    STATE(372), 1,
      sym_string,
    STATE(665), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(475), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
    ACTIONS(481), 17,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [867] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(433), 1,
      anon_sym_STAR,
    ACTIONS(437), 1,
      anon_sym_LBRACK,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(485), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(659), 1,
      sym_pattern,
    STATE(699), 1,
      sym_expression,
    STATE(888), 1,
      sym_list_splat,
    STATE(889), 1,
      sym_parenthesized_list_splat,
    STATE(890), 1,
      sym_yield,
    STATE(1018), 1,
      sym__patterns,
    STATE(1094), 1,
      sym__collection_elements,
    ACTIONS(435), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    STATE(572), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [983] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(433), 1,
      anon_sym_STAR,
    ACTIONS(437), 1,
      anon_sym_LBRACK,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(487), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(659), 1,
      sym_pattern,
    STATE(708), 1,
      sym_expression,
    STATE(1040), 1,
      sym__patterns,
    STATE(1041), 1,
      sym__collection_elements,
    ACTIONS(435), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    STATE(572), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    STATE(855), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1095] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      sym_identifier,
    ACTIONS(431), 1,
      anon_sym_LPAREN,
    ACTIONS(433), 1,
      anon_sym_STAR,
    ACTIONS(437), 1,
      anon_sym_LBRACK,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(489), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(659), 1,
      sym_pattern,
    STATE(699), 1,
      sym_expression,
    STATE(890), 1,
      sym_yield,
    STATE(1018), 1,
      sym__patterns,
    STATE(1094), 1,
      sym__collection_elements,
    ACTIONS(435), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    STATE(572), 2,
      sym_attribute,
      sym_subscript,
    STATE(855), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1209] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(491), 1,
      sym_identifier,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(495), 1,
      anon_sym_RPAREN,
    ACTIONS(497), 1,
      anon_sym_COMMA,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(707), 1,
      sym_expression,
    STATE(941), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(938), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1311] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(511), 1,
      anon_sym_RPAREN,
    ACTIONS(513), 1,
      anon_sym_COMMA,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(801), 1,
      sym_expression,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(930), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1413] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(533), 1,
      anon_sym_lambda,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(715), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(741), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(527), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(531), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1509] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(533), 1,
      anon_sym_lambda,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(715), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(741), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(535), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(537), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(539), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [1665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(543), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [1725] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(491), 1,
      sym_identifier,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(511), 1,
      anon_sym_RPAREN,
    ACTIONS(513), 1,
      anon_sym_COMMA,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(709), 1,
      sym_expression,
    STATE(931), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(930), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [1887] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(533), 1,
      anon_sym_lambda,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(715), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(741), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(551), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(553), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [1983] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [2043] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(491), 1,
      sym_identifier,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(559), 1,
      anon_sym_RPAREN,
    ACTIONS(561), 1,
      anon_sym_COMMA,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(704), 1,
      sym_expression,
    STATE(887), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(891), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2145] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 36,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_RBRACE,
      sym_type_conversion,
  [2205] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(495), 1,
      anon_sym_RPAREN,
    ACTIONS(497), 1,
      anon_sym_COMMA,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(796), 1,
      sym_expression,
    STATE(941), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(938), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2307] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(533), 1,
      anon_sym_lambda,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(715), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(741), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(567), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(569), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2403] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(571), 1,
      anon_sym_COMMA,
    ACTIONS(573), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(693), 1,
      sym_expression,
    STATE(758), 1,
      sym_pair,
    STATE(910), 1,
      sym_dictionary_splat,
    STATE(911), 1,
      sym_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2506] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(575), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2605] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(784), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(579), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(958), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2702] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(585), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2801] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(587), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [2900] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(589), 1,
      anon_sym_COMMA,
    ACTIONS(591), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(692), 1,
      sym_expression,
    STATE(751), 1,
      sym_pair,
    STATE(939), 1,
      sym_dictionary_splat,
    STATE(940), 1,
      sym_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3003] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(593), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(712), 1,
      sym_expression,
    STATE(1019), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(855), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3102] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(595), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(701), 1,
      sym_expression,
    STATE(912), 1,
      sym_yield,
    STATE(1026), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(855), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3203] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(597), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3302] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(599), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(699), 1,
      sym_expression,
    STATE(888), 1,
      sym_list_splat,
    STATE(889), 1,
      sym_parenthesized_list_splat,
    STATE(890), 1,
      sym_yield,
    STATE(1094), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3405] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(601), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3504] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(603), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3603] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(605), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3702] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(784), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(607), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(958), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3799] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(609), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3898] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(611), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [3997] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(613), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4096] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(615), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(706), 1,
      sym_expression,
    STATE(1092), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(855), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4195] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(599), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(699), 1,
      sym_expression,
    STATE(890), 1,
      sym_yield,
    STATE(1094), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(855), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4296] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(617), 1,
      anon_sym_COMMA,
    ACTIONS(619), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(695), 1,
      sym_expression,
    STATE(757), 1,
      sym_pair,
    STATE(898), 1,
      sym_list_splat,
    STATE(899), 1,
      sym_dictionary_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4399] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(621), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4498] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(623), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4597] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(625), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(711), 1,
      sym_expression,
    STATE(929), 1,
      sym_yield,
    STATE(1033), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(855), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4698] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(593), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(706), 1,
      sym_expression,
    STATE(1092), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(855), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4797] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(627), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(708), 1,
      sym_expression,
    STATE(1041), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(855), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4896] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(595), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(699), 1,
      sym_expression,
    STATE(890), 1,
      sym_yield,
    STATE(1094), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(855), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [4997] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(493), 1,
      anon_sym_LPAREN,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(595), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(699), 1,
      sym_expression,
    STATE(888), 1,
      sym_list_splat,
    STATE(889), 1,
      sym_parenthesized_list_splat,
    STATE(890), 1,
      sym_yield,
    STATE(1094), 1,
      sym__collection_elements,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5100] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(499), 1,
      anon_sym_STAR,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(507), 1,
      sym_identifier,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(830), 1,
      sym_expression,
    STATE(1004), 1,
      sym_parenthesized_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(501), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1001), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5196] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    ACTIONS(635), 1,
      anon_sym_except,
    ACTIONS(637), 1,
      anon_sym_finally,
    STATE(296), 1,
      sym_else_clause,
    STATE(424), 1,
      sym_finally_clause,
    STATE(198), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(631), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(629), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [5265] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(639), 1,
      anon_sym_from,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(719), 1,
      sym_expression,
    STATE(948), 1,
      sym_expression_list,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(643), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5358] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 1,
      anon_sym_COMMA,
    ACTIONS(253), 1,
      anon_sym_EQ,
    ACTIONS(645), 1,
      sym__string_start,
    STATE(963), 1,
      sym_string,
    ACTIONS(251), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(240), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(242), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [5425] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    ACTIONS(635), 1,
      anon_sym_except,
    ACTIONS(637), 1,
      anon_sym_finally,
    STATE(286), 1,
      sym_else_clause,
    STATE(402), 1,
      sym_finally_clause,
    STATE(198), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(649), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(647), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [5494] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    ACTIONS(653), 1,
      anon_sym_except,
    ACTIONS(655), 1,
      anon_sym_finally,
    STATE(276), 1,
      sym_else_clause,
    STATE(373), 1,
      sym_finally_clause,
    STATE(186), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(631), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(629), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [5563] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      anon_sym_yield,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(509), 1,
      anon_sym_LPAREN,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(784), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(958), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5656] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    ACTIONS(653), 1,
      anon_sym_except,
    ACTIONS(655), 1,
      anon_sym_finally,
    STATE(312), 1,
      sym_else_clause,
    STATE(432), 1,
      sym_finally_clause,
    STATE(186), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(649), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(647), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [5725] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(657), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(845), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(980), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5817] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(659), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(845), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(980), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [5909] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(661), 1,
      anon_sym_from,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(724), 1,
      sym_expression,
    STATE(926), 1,
      sym_expression_list,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(667), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6001] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [6057] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(547), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [6113] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 1,
      anon_sym_COMMA,
    ACTIONS(676), 1,
      anon_sym_COLON_EQ,
    ACTIONS(678), 2,
      anon_sym_COLON,
      anon_sym_EQ,
    ACTIONS(680), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(674), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [6177] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(682), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(845), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(980), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6269] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(684), 1,
      anon_sym_from,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(724), 1,
      sym_expression,
    STATE(989), 1,
      sym_expression_list,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(643), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6361] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(686), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(845), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(980), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(543), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [6509] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(762), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(688), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6597] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(690), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(845), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(980), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6689] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(762), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(692), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(539), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [6833] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(694), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(845), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(980), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [6925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 16,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_EQ,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(555), 32,
      sym__newline,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      sym__semicolon,
  [6981] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(822), 1,
      sym_expression,
    STATE(993), 1,
      sym_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7072] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(698), 1,
      anon_sym_from,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(770), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(692), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7161] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    ACTIONS(704), 1,
      anon_sym_elif,
    STATE(219), 1,
      aux_sym_if_statement_repeat1,
    STATE(322), 1,
      sym_elif_clause,
    STATE(411), 1,
      sym_else_clause,
    ACTIONS(700), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(702), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [7226] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    ACTIONS(708), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(781), 1,
      sym_expression,
    STATE(1014), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7317] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    ACTIONS(710), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(781), 1,
      sym_expression,
    STATE(1014), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7408] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(714), 1,
      anon_sym_COLON,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(790), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(712), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7497] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(822), 1,
      sym_expression,
    STATE(993), 1,
      sym_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7588] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 1,
      anon_sym_COMMA,
    ACTIONS(678), 1,
      anon_sym_EQ,
    ACTIONS(680), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(674), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [7649] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(718), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(822), 1,
      sym_expression,
    STATE(993), 1,
      sym_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7740] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(724), 1,
      sym_expression,
    STATE(979), 1,
      sym_expression_list,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(720), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7829] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    ACTIONS(726), 1,
      anon_sym_elif,
    STATE(193), 1,
      aux_sym_if_statement_repeat1,
    STATE(294), 1,
      sym_elif_clause,
    STATE(391), 1,
      sym_else_clause,
    ACTIONS(724), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(722), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [7894] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    ACTIONS(728), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(781), 1,
      sym_expression,
    STATE(1014), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [7985] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(730), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(822), 1,
      sym_expression,
    STATE(993), 1,
      sym_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8076] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    ACTIONS(726), 1,
      anon_sym_elif,
    STATE(203), 1,
      aux_sym_if_statement_repeat1,
    STATE(294), 1,
      sym_elif_clause,
    STATE(419), 1,
      sym_else_clause,
    ACTIONS(734), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(732), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [8141] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 1,
      anon_sym_except,
    STATE(186), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(736), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(738), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [8200] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    ACTIONS(704), 1,
      anon_sym_elif,
    STATE(196), 1,
      aux_sym_if_statement_repeat1,
    STATE(322), 1,
      sym_elif_clause,
    STATE(407), 1,
      sym_else_clause,
    ACTIONS(724), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(722), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [8265] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(745), 1,
      anon_sym_COLON,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(776), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(743), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8354] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    ACTIONS(747), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(781), 1,
      sym_expression,
    STATE(1014), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8445] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(749), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(822), 1,
      sym_expression,
    STATE(993), 1,
      sym_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8536] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(753), 1,
      anon_sym_COMMA,
    ACTIONS(760), 1,
      anon_sym_EQ,
    ACTIONS(758), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(756), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(751), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [8597] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    ACTIONS(762), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(781), 1,
      sym_expression,
    STATE(1014), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8688] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    ACTIONS(726), 1,
      anon_sym_elif,
    STATE(210), 1,
      aux_sym_if_statement_repeat1,
    STATE(294), 1,
      sym_elif_clause,
    STATE(415), 1,
      sym_else_clause,
    ACTIONS(766), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(764), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [8753] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(244), 1,
      anon_sym_COMMA,
    ACTIONS(253), 1,
      anon_sym_EQ,
    ACTIONS(251), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(240), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(242), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [8814] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_from,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(770), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(688), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [8903] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    ACTIONS(704), 1,
      anon_sym_elif,
    STATE(219), 1,
      aux_sym_if_statement_repeat1,
    STATE(322), 1,
      sym_elif_clause,
    STATE(422), 1,
      sym_else_clause,
    ACTIONS(766), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(764), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [8968] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    ACTIONS(770), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(781), 1,
      sym_expression,
    STATE(1014), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9059] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_except,
    STATE(198), 2,
      sym_except_clause,
      aux_sym_try_statement_repeat1,
    ACTIONS(736), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(738), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [9118] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(505), 1,
      anon_sym_STAR_STAR,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(845), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(980), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9207] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(777), 1,
      anon_sym_COMMA,
    ACTIONS(784), 1,
      anon_sym_EQ,
    ACTIONS(782), 14,
      anon_sym_COLON,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(780), 15,
      anon_sym_STAR,
      anon_sym_GT_GT,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(775), 16,
      sym__newline,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      sym__semicolon,
  [9268] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    ACTIONS(704), 1,
      anon_sym_elif,
    STATE(174), 1,
      aux_sym_if_statement_repeat1,
    STATE(322), 1,
      sym_elif_clause,
    STATE(416), 1,
      sym_else_clause,
    ACTIONS(734), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(732), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [9333] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(786), 1,
      anon_sym_RBRACE,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(822), 1,
      sym_expression,
    STATE(993), 1,
      sym_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9424] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    ACTIONS(726), 1,
      anon_sym_elif,
    STATE(210), 1,
      aux_sym_if_statement_repeat1,
    STATE(294), 1,
      sym_elif_clause,
    STATE(384), 1,
      sym_else_clause,
    ACTIONS(700), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(702), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [9489] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(533), 1,
      anon_sym_lambda,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(718), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(760), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9575] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(770), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(788), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9661] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(792), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [9715] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(791), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(794), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9801] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(791), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(796), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9887] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(740), 1,
      sym_expression,
    STATE(934), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [9975] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 1,
      anon_sym_elif,
    STATE(210), 1,
      aux_sym_if_statement_repeat1,
    STATE(294), 1,
      sym_elif_clause,
    ACTIONS(800), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(798), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10035] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(753), 1,
      sym_expression,
    STATE(942), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10123] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(831), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(743), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10209] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(533), 1,
      anon_sym_lambda,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(715), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(741), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10295] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_STAR,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(822), 1,
      sym_expression,
    STATE(993), 1,
      sym_list_splat,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(805), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10437] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(752), 1,
      sym_expression,
    STATE(881), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10525] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(805), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(809), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10633] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 1,
      anon_sym_elif,
    STATE(219), 1,
      aux_sym_if_statement_repeat1,
    STATE(322), 1,
      sym_elif_clause,
    ACTIONS(800), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(798), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10693] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(803), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(816), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10779] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(533), 1,
      anon_sym_lambda,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(715), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(736), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [10865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(818), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [10919] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(791), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(822), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11005] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(791), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(824), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(792), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11145] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(770), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(826), 2,
      sym__newline,
      sym__semicolon,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(828), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11285] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(706), 1,
      anon_sym_COLON,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(781), 1,
      sym_expression,
    STATE(1014), 1,
      sym_slice,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11373] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(533), 1,
      anon_sym_lambda,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(714), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(744), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11459] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    ACTIONS(533), 1,
      anon_sym_lambda,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(715), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(730), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11545] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(818), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(828), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11653] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(806), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(832), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(809), 34,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11793] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(836), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11846] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(719), 1,
      sym_expression,
    STATE(1072), 1,
      sym_expression_list,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [11931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(838), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [11984] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(846), 1,
      anon_sym_COLON,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(787), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12069] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(767), 1,
      sym_expression,
    STATE(933), 1,
      sym_type,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12154] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(777), 1,
      sym_expression,
    STATE(928), 1,
      sym_with_item,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12239] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(777), 1,
      sym_expression,
    STATE(971), 1,
      sym_with_item,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12324] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(767), 1,
      sym_expression,
    STATE(1074), 1,
      sym_type,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12409] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(777), 1,
      sym_expression,
    STATE(916), 1,
      sym_with_item,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12494] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(868), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [12547] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(870), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [12600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(874), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [12653] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(767), 1,
      sym_expression,
    STATE(1028), 1,
      sym_type,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12738] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(777), 1,
      sym_expression,
    STATE(994), 1,
      sym_with_item,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12823] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    ACTIONS(878), 1,
      anon_sym_COLON,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(778), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12908] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(719), 1,
      sym_expression,
    STATE(1068), 1,
      sym_expression_list,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [12993] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(767), 1,
      sym_expression,
    STATE(1059), 1,
      sym_type,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13078] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(767), 1,
      sym_expression,
    STATE(844), 1,
      sym_type,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13163] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(719), 1,
      sym_expression,
    STATE(1054), 1,
      sym_expression_list,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13248] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(777), 1,
      sym_expression,
    STATE(901), 1,
      sym_with_item,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13333] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(719), 1,
      sym_expression,
    STATE(1035), 1,
      sym_expression_list,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13418] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(868), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13471] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(724), 1,
      sym_expression,
    STATE(977), 1,
      sym_expression_list,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13556] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(880), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(836), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13662] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(882), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(880), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(874), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13768] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(870), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(838), 33,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_except,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [13874] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(767), 1,
      sym_expression,
    STATE(1076), 1,
      sym_type,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [13959] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(767), 1,
      sym_expression,
    STATE(1095), 1,
      sym_type,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14044] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(794), 1,
      sym_expression,
    STATE(880), 1,
      sym_type,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14129] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(686), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14211] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(779), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14293] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(860), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14375] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(769), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14457] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(858), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14539] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14621] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(863), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14703] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(849), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14785] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    STATE(397), 1,
      sym_else_clause,
    ACTIONS(886), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(884), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [14841] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(655), 1,
      anon_sym_finally,
    STATE(414), 1,
      sym_finally_clause,
    ACTIONS(888), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(890), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [14897] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(843), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [14979] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(842), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15061] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(853), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15143] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(735), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15225] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(841), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15307] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(725), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15389] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    STATE(401), 1,
      sym_else_clause,
    ACTIONS(886), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(884), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [15445] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(848), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15527] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(775), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15609] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_finally,
    STATE(418), 1,
      sym_finally_clause,
    ACTIONS(894), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(892), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [15665] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    STATE(405), 1,
      sym_else_clause,
    ACTIONS(898), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(896), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [15721] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(748), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15803] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(900), 1,
      sym_identifier,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(755), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(902), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(647), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15887] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(694), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [15969] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(686), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16051] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(780), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16133] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(805), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(904), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [16267] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    STATE(408), 1,
      sym_else_clause,
    ACTIONS(908), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(910), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [16323] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_finally,
    STATE(385), 1,
      sym_finally_clause,
    ACTIONS(888), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(890), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [16379] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(733), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16461] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    STATE(362), 1,
      sym_else_clause,
    ACTIONS(912), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(914), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [16517] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(705), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16599] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(829), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16681] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(755), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16763] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(774), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16845] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(729), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [16927] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(773), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17009] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(802), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17091] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(874), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17173] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(722), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17255] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(721), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17337] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(703), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17419] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    STATE(409), 1,
      sym_else_clause,
    ACTIONS(918), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(916), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [17475] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(747), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17557] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(655), 1,
      anon_sym_finally,
    STATE(376), 1,
      sym_finally_clause,
    ACTIONS(894), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(892), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [17613] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(788), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17695] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(793), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17777] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(782), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17859] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(737), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [17941] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    STATE(392), 1,
      sym_else_clause,
    ACTIONS(898), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(896), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [17997] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(786), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18079] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(783), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18161] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 1,
      sym_identifier,
    ACTIONS(844), 1,
      anon_sym_LPAREN,
    ACTIONS(848), 1,
      anon_sym_LBRACK,
    ACTIONS(850), 1,
      anon_sym_not,
    ACTIONS(854), 1,
      anon_sym_lambda,
    ACTIONS(858), 1,
      anon_sym_LBRACE,
    ACTIONS(862), 1,
      anon_sym_await,
    ACTIONS(864), 1,
      sym__string_start,
    STATE(523), 1,
      sym_primary_expression,
    STATE(524), 1,
      sym_string,
    STATE(785), 1,
      sym_expression,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(856), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(852), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(860), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(799), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(627), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18243] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(697), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(906), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(904), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [18377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(922), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [18429] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    STATE(410), 1,
      sym_else_clause,
    ACTIONS(908), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(910), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [18485] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(866), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18567] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(726), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18649] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(795), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18731] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(791), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18813] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    STATE(389), 1,
      sym_else_clause,
    ACTIONS(924), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(926), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [18869] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(689), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [18951] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_else,
    STATE(426), 1,
      sym_else_clause,
    ACTIONS(918), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(916), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19007] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(854), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19089] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(691), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19171] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(684), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19253] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(690), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19335] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    STATE(396), 1,
      sym_else_clause,
    ACTIONS(912), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(914), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19391] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(696), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(930), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [19525] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(797), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19607] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(770), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19689] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(820), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19771] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(809), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19853] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(728), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [19935] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(818), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20017] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(698), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(930), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20151] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_not,
    ACTIONS(63), 1,
      anon_sym_lambda,
    ACTIONS(69), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_await,
    ACTIONS(75), 1,
      sym__string_start,
    ACTIONS(238), 1,
      sym_identifier,
    ACTIONS(663), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_LBRACK,
    STATE(499), 1,
      sym_primary_expression,
    STATE(500), 1,
      sym_string,
    STATE(759), 1,
      sym_expression,
    ACTIONS(67), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(247), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(61), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(71), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(727), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(534), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20233] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(808), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(922), 32,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20367] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(762), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20449] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(700), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20531] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(515), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_not,
    ACTIONS(519), 1,
      anon_sym_lambda,
    ACTIONS(521), 1,
      anon_sym_await,
    ACTIONS(577), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(441), 1,
      sym_primary_expression,
    STATE(800), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(583), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20613] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(710), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20695] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(684), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20777] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      anon_sym_not,
    ACTIONS(445), 1,
      anon_sym_lambda,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(455), 1,
      anon_sym_await,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(503), 1,
      anon_sym_LBRACK,
    ACTIONS(523), 1,
      sym_identifier,
    ACTIONS(525), 1,
      anon_sym_LPAREN,
    STATE(372), 1,
      sym_string,
    STATE(474), 1,
      sym_primary_expression,
    STATE(702), 1,
      sym_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(529), 2,
      anon_sym_print,
      anon_sym_exec,
    ACTIONS(443), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(688), 7,
      sym_named_expression,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
      sym_await,
    STATE(476), 15,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [20859] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_else,
    STATE(379), 1,
      sym_else_clause,
    ACTIONS(924), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(926), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(932), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [20966] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(936), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21017] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(934), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(932), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(938), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(936), 31,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_finally,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(942), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21169] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(946), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(950), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(952), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(958), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(956), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21369] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(962), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21419] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(964), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(970), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(974), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(962), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21619] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(978), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21669] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym__string_start,
    STATE(421), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(674), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [21723] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(890), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21773] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(980), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(942), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(986), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(988), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [21973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(978), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(992), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(996), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1002), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22173] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1006), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1004), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1008), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22273] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1012), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22323] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1016), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22373] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(964), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22423] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1022), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(996), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22523] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(992), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22573] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1024), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22623] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1030), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1028), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22673] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1034), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22723] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(647), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22773] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1022), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(629), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(946), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1036), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [22973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(988), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1006), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1004), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1040), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1036), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23173] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(892), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(950), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23273] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(952), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23323] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1034), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23373] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(958), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(956), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23423] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1030), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1028), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1046), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23523] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1050), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1048), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23573] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1046), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23623] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1012), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23673] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1052), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23723] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1056), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23773] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1016), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1060), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1066), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1002), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [23973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(986), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1066), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1052), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24123] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      sym__string_start,
    STATE(427), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(1070), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1068), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [24177] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1060), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24227] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(980), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(890), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24327] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1056), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1050), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1048), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24427] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      sym__string_start,
    STATE(427), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(1074), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1072), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [24481] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1081), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1079), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24531] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1040), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1008), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24631] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(970), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(894), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(892), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24731] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1081), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1079), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24781] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(629), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24831] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(647), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24881] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 12,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(1024), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 12,
      sym__dedent,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      sym_ellipsis,
      anon_sym_LBRACE,
      sym_float,
    ACTIONS(974), 30,
      anon_sym_import,
      anon_sym_from,
      anon_sym_print,
      anon_sym_assert,
      anon_sym_return,
      anon_sym_del,
      anon_sym_raise,
      anon_sym_pass,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_while,
      anon_sym_try,
      anon_sym_with,
      anon_sym_def,
      anon_sym_global,
      anon_sym_nonlocal,
      anon_sym_exec,
      anon_sym_class,
      anon_sym_not,
      anon_sym_lambda,
      anon_sym_yield,
      sym_integer,
      sym_identifier,
      sym_true,
      sym_false,
      sym_none,
      anon_sym_await,
  [24981] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    STATE(372), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    STATE(676), 1,
      sym__patterns,
    STATE(1052), 1,
      sym_left_hand_side,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [25061] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    ACTIONS(1083), 1,
      anon_sym_RPAREN,
    STATE(372), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym__patterns,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [25141] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    STATE(372), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    STATE(676), 1,
      sym__patterns,
    STATE(1088), 1,
      sym_left_hand_side,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [25221] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1099), 1,
      anon_sym_EQ,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1105), 1,
      anon_sym_not,
    ACTIONS(1109), 1,
      anon_sym_PIPE,
    ACTIONS(1111), 1,
      anon_sym_AMP,
    ACTIONS(1113), 1,
      anon_sym_CARET,
    ACTIONS(1117), 1,
      anon_sym_is,
    STATE(654), 1,
      aux_sym_comparison_operator_repeat1,
    ACTIONS(1091), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1093), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1107), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1115), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1103), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1095), 6,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
    ACTIONS(1089), 10,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_and,
      anon_sym_or,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25303] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    STATE(372), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    STATE(676), 1,
      sym__patterns,
    STATE(1036), 1,
      sym_left_hand_side,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [25383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1121), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1119), 35,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25431] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    STATE(372), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    STATE(676), 1,
      sym__patterns,
    STATE(1039), 1,
      sym_left_hand_side,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [25511] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    STATE(372), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    STATE(676), 1,
      sym__patterns,
    STATE(1099), 1,
      sym_left_hand_side,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [25591] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1125), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1123), 35,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25639] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    STATE(372), 1,
      sym_string,
    STATE(659), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    STATE(676), 1,
      sym__patterns,
    STATE(1101), 1,
      sym_left_hand_side,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [25719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1129), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1127), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25766] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1113), 1,
      anon_sym_CARET,
    ACTIONS(1091), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1093), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1107), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1103), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1133), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1131), 20,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1137), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1135), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25880] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1141), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1139), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1145), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1143), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [25974] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1149), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1147), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26021] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1153), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1151), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1157), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1155), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26115] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1161), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1159), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26162] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1165), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1163), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26209] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1169), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1167), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26256] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1173), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1171), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26303] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1177), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1175), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1181), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1179), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1185), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1183), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26444] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1109), 1,
      anon_sym_PIPE,
    ACTIONS(1111), 1,
      anon_sym_AMP,
    ACTIONS(1113), 1,
      anon_sym_CARET,
    ACTIONS(1091), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1093), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1107), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1103), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1189), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1187), 18,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26515] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1093), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1107), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1103), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1133), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1131), 21,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1193), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1191), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26627] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1111), 1,
      anon_sym_AMP,
    ACTIONS(1113), 1,
      anon_sym_CARET,
    ACTIONS(1091), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1093), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1107), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1103), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1133), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1131), 19,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26696] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1197), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1195), 28,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26753] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1201), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1199), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26800] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1205), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1203), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26847] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1207), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26894] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1103), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1133), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1131), 25,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [26955] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1133), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1131), 28,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1211), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27059] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1225), 1,
      anon_sym_not,
    ACTIONS(1229), 1,
      anon_sym_PIPE,
    ACTIONS(1231), 1,
      anon_sym_AMP,
    ACTIONS(1233), 1,
      anon_sym_CARET,
    ACTIONS(1237), 1,
      anon_sym_is,
    STATE(656), 1,
      aux_sym_comparison_operator_repeat1,
    ACTIONS(1215), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1217), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1227), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1235), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1223), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1219), 6,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
    ACTIONS(1089), 10,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_RBRACK,
      anon_sym_and,
      anon_sym_or,
      anon_sym_RBRACE,
  [27138] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1109), 1,
      anon_sym_PIPE,
    ACTIONS(1111), 1,
      anon_sym_AMP,
    ACTIONS(1113), 1,
      anon_sym_CARET,
    ACTIONS(1091), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1093), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1107), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1103), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1241), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1239), 18,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27209] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27256] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1107), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1103), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1133), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1131), 23,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27319] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1101), 1,
      anon_sym_STAR_STAR,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1133), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1131), 28,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27376] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1245), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1243), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27423] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1249), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1247), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1253), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1251), 34,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27517] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1229), 1,
      anon_sym_PIPE,
    ACTIONS(1231), 1,
      anon_sym_AMP,
    ACTIONS(1233), 1,
      anon_sym_CARET,
    ACTIONS(1189), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1215), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1217), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1227), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1223), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1187), 18,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [27587] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1133), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1131), 28,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [27643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(751), 33,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27689] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(775), 33,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [27735] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    STATE(372), 1,
      sym_string,
    STATE(665), 1,
      sym_pattern,
    STATE(669), 1,
      sym_primary_expression,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [27809] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1133), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1215), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1217), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1227), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1223), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1131), 21,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [27873] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1133), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1215), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1227), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1223), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1131), 23,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [27935] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1229), 1,
      anon_sym_PIPE,
    ACTIONS(1231), 1,
      anon_sym_AMP,
    ACTIONS(1233), 1,
      anon_sym_CARET,
    ACTIONS(1215), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1217), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1227), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1241), 2,
      anon_sym_LT,
      anon_sym_GT,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1223), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1239), 18,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [28005] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_STAR,
    ACTIONS(451), 1,
      anon_sym_LBRACE,
    ACTIONS(457), 1,
      sym__string_start,
    ACTIONS(461), 1,
      sym_identifier,
    ACTIONS(463), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_LBRACK,
    STATE(372), 1,
      sym_string,
    STATE(669), 1,
      sym_primary_expression,
    STATE(998), 1,
      sym_pattern,
    ACTIONS(449), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(469), 2,
      anon_sym_print,
      anon_sym_exec,
    STATE(526), 2,
      sym_attribute,
      sym_subscript,
    ACTIONS(477), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(664), 3,
      sym_tuple_pattern,
      sym_list_pattern,
      sym_list_splat_pattern,
    ACTIONS(453), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(476), 13,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_list_comprehension,
      sym_dictionary,
      sym_dictionary_comprehension,
      sym_set,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_tuple,
      sym_generator_expression,
      sym_concatenated_string,
  [28079] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1133), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1131), 28,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [28135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(240), 5,
      anon_sym_STAR,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(242), 33,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [28181] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1255), 1,
      anon_sym_COLON_EQ,
    ACTIONS(674), 6,
      anon_sym_STAR,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 31,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
      sym_type_conversion,
  [28229] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1133), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1215), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1223), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1131), 25,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [28289] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1231), 1,
      anon_sym_AMP,
    ACTIONS(1233), 1,
      anon_sym_CARET,
    ACTIONS(1133), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1215), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1217), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1227), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1223), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1131), 19,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [28357] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1197), 4,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1195), 28,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [28413] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1085), 1,
      anon_sym_DOT,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1097), 1,
      anon_sym_LBRACK,
    ACTIONS(1221), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1233), 1,
      anon_sym_CARET,
    ACTIONS(1133), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1215), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1217), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1227), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(457), 2,
      sym_argument_list,
      sym_generator_expression,
    ACTIONS(1223), 3,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
    ACTIONS(1131), 20,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_if,
      anon_sym_COLON,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_RBRACK,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [28479] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1257), 1,
      anon_sym_COLON_EQ,
    ACTIONS(674), 5,
      anon_sym_STAR,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(669), 31,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
      anon_sym_is,
      anon_sym_RBRACE,
  [28526] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 1,
      anon_sym_EQ,
    ACTIONS(1259), 1,
      anon_sym_DOT,
    ACTIONS(1261), 1,
      anon_sym_LPAREN,
    ACTIONS(1269), 1,
      anon_sym_LBRACK,
    ACTIONS(1271), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1275), 1,
      anon_sym_not,
    ACTIONS(1279), 1,
      anon_sym_PIPE,
    ACTIONS(1281), 1,
      anon_sym_AMP,
    ACTIONS(1283), 1,
      anon_sym_CARET,
    ACTIONS(1287), 1,
      anon_sym_is,
    STATE(661), 1,
      aux_sym_comparison_operator_repeat1,
    ACTIONS(1263), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1265), 2,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(1277), 2,
      anon_sym