#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1356
#define LARGE_STATE_COUNT 207
#define SYMBOL_COUNT 241
#define ALIAS_COUNT 5
#define TOKEN_COUNT 124
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 34
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 94

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_LBRACE = 6,
  anon_sym_COMMA = 7,
  anon_sym_RBRACE = 8,
  anon_sym_as = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_var = 12,
  anon_sym_let = 13,
  anon_sym_const = 14,
  anon_sym_else = 15,
  anon_sym_if = 16,
  anon_sym_switch = 17,
  anon_sym_for = 18,
  anon_sym_LPAREN = 19,
  anon_sym_RPAREN = 20,
  anon_sym_await = 21,
  anon_sym_in = 22,
  anon_sym_of = 23,
  anon_sym_while = 24,
  anon_sym_do = 25,
  anon_sym_try = 26,
  anon_sym_with = 27,
  anon_sym_break = 28,
  anon_sym_continue = 29,
  anon_sym_debugger = 30,
  anon_sym_return = 31,
  anon_sym_throw = 32,
  anon_sym_SEMI = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_SLASH = 44,
  sym_jsx_text = 45,
  sym_jsx_identifier = 46,
  anon_sym_DOT = 47,
  anon_sym_class = 48,
  anon_sym_extends = 49,
  anon_sym_async = 50,
  anon_sym_function = 51,
  anon_sym_EQ_GT = 52,
  anon_sym_QMARK_DOT = 53,
  anon_sym_new = 54,
  anon_sym_PLUS_EQ = 55,
  anon_sym_DASH_EQ = 56,
  anon_sym_STAR_EQ = 57,
  anon_sym_SLASH_EQ = 58,
  anon_sym_PERCENT_EQ = 59,
  anon_sym_CARET_EQ = 60,
  anon_sym_AMP_EQ = 61,
  anon_sym_PIPE_EQ = 62,
  anon_sym_GT_GT_EQ = 63,
  anon_sym_GT_GT_GT_EQ = 64,
  anon_sym_LT_LT_EQ = 65,
  anon_sym_STAR_STAR_EQ = 66,
  anon_sym_AMP_AMP_EQ = 67,
  anon_sym_PIPE_PIPE_EQ = 68,
  anon_sym_QMARK_QMARK_EQ = 69,
  anon_sym_DOT_DOT_DOT = 70,
  anon_sym_QMARK = 71,
  anon_sym_AMP_AMP = 72,
  anon_sym_PIPE_PIPE = 73,
  anon_sym_GT_GT = 74,
  anon_sym_GT_GT_GT = 75,
  anon_sym_LT_LT = 76,
  anon_sym_AMP = 77,
  anon_sym_CARET = 78,
  anon_sym_PIPE = 79,
  anon_sym_PLUS = 80,
  anon_sym_DASH = 81,
  anon_sym_PERCENT = 82,
  anon_sym_STAR_STAR = 83,
  anon_sym_LT_EQ = 84,
  anon_sym_EQ_EQ = 85,
  anon_sym_EQ_EQ_EQ = 86,
  anon_sym_BANG_EQ = 87,
  anon_sym_BANG_EQ_EQ = 88,
  anon_sym_GT_EQ = 89,
  anon_sym_QMARK_QMARK = 90,
  anon_sym_instanceof = 91,
  anon_sym_BANG = 92,
  anon_sym_TILDE = 93,
  anon_sym_typeof = 94,
  anon_sym_void = 95,
  anon_sym_delete = 96,
  anon_sym_PLUS_PLUS = 97,
  anon_sym_DASH_DASH = 98,
  anon_sym_DQUOTE = 99,
  aux_sym_string_token1 = 100,
  anon_sym_SQUOTE = 101,
  aux_sym_string_token2 = 102,
  sym_escape_sequence = 103,
  sym_comment = 104,
  anon_sym_BQUOTE = 105,
  anon_sym_DOLLAR_LBRACE = 106,
  anon_sym_SLASH2 = 107,
  sym_regex_pattern = 108,
  sym_regex_flags = 109,
  sym_number = 110,
  anon_sym_target = 111,
  sym_this = 112,
  sym_super = 113,
  sym_true = 114,
  sym_false = 115,
  sym_null = 116,
  sym_undefined = 117,
  anon_sym_AT = 118,
  anon_sym_static = 119,
  anon_sym_get = 120,
  anon_sym_set = 121,
  sym__automatic_semicolon = 122,
  sym__template_chars = 123,
  sym_program = 124,
  sym_export_statement = 125,
  sym_export_clause = 126,
  sym__import_export_specifier = 127,
  sym_declaration = 128,
  sym_import = 129,
  sym_import_statement = 130,
  sym_import_clause = 131,
  sym__from_clause = 132,
  sym_namespace_import = 133,
  sym_named_imports = 134,
  sym_expression_statement = 135,
  sym_variable_declaration = 136,
  sym_lexical_declaration = 137,
  sym_variable_declarator = 138,
  sym_statement_block = 139,
  sym_else_clause = 140,
  sym_if_statement = 141,
  sym_switch_statement = 142,
  sym_for_statement = 143,
  sym_for_in_statement = 144,
  sym__for_header = 145,
  sym_while_statement = 146,
  sym_do_statement = 147,
  sym_try_statement = 148,
  sym_with_statement = 149,
  sym_break_statement = 150,
  sym_continue_statement = 151,
  sym_debugger_statement = 152,
  sym_return_statement = 153,
  sym_throw_statement = 154,
  sym_empty_statement = 155,
  sym_labeled_statement = 156,
  sym_switch_body = 157,
  sym_switch_case = 158,
  sym_switch_default = 159,
  sym_catch_clause = 160,
  sym_finally_clause = 161,
  sym_parenthesized_expression = 162,
  sym_expression = 163,
  sym_primary_expression = 164,
  sym_yield_expression = 165,
  sym_object = 166,
  sym_object_pattern = 167,
  sym_assignment_pattern = 168,
  sym_object_assignment_pattern = 169,
  sym_array = 170,
  sym_array_pattern = 171,
  sym_jsx_element = 172,
  sym_jsx_fragment = 173,
  sym_jsx_expression = 174,
  sym_jsx_opening_element = 175,
  sym_nested_identifier = 176,
  sym_jsx_namespace_name = 177,
  sym_jsx_closing_element = 178,
  sym_jsx_self_closing_element = 179,
  sym_jsx_attribute = 180,
  sym_class = 181,
  sym_class_declaration = 182,
  sym_class_heritage = 183,
  sym_function = 184,
  sym_function_declaration = 185,
  sym_generator_function = 186,
  sym_generator_function_declaration = 187,
  sym_arrow_function = 188,
  sym_call_expression = 189,
  sym_new_expression = 190,
  sym_await_expression = 191,
  sym_member_expression = 192,
  sym_subscript_expression = 193,
  sym_assignment_expression = 194,
  sym__augmented_assignment_lhs = 195,
  sym_augmented_assignment_expression = 196,
  sym__initializer = 197,
  sym__destructuring_pattern = 198,
  sym_spread_element = 199,
  sym_ternary_expression = 200,
  sym_binary_expression = 201,
  sym_unary_expression = 202,
  sym_update_expression = 203,
  sym_sequence_expression = 204,
  sym_string = 205,
  sym_template_string = 206,
  sym_template_substitution = 207,
  sym_regex = 208,
  sym_meta_property = 209,
  sym_arguments = 210,
  sym_decorator = 211,
  sym_decorator_member_expression = 212,
  sym_decorator_call_expression = 213,
  sym_class_body = 214,
  sym_public_field_definition = 215,
  sym_formal_parameters = 216,
  sym_pattern = 217,
  sym_rest_pattern = 218,
  sym_method_definition = 219,
  sym_pair = 220,
  sym_pair_pattern = 221,
  sym__property_name = 222,
  sym_computed_property_name = 223,
  aux_sym_program_repeat1 = 224,
  aux_sym_export_statement_repeat1 = 225,
  aux_sym_export_clause_repeat1 = 226,
  aux_sym_named_imports_repeat1 = 227,
  aux_sym_variable_declaration_repeat1 = 228,
  aux_sym_switch_body_repeat1 = 229,
  aux_sym_object_repeat1 = 230,
  aux_sym_object_pattern_repeat1 = 231,
  aux_sym_array_repeat1 = 232,
  aux_sym_array_pattern_repeat1 = 233,
  aux_sym_jsx_element_repeat1 = 234,
  aux_sym_jsx_opening_element_repeat1 = 235,
  aux_sym_string_repeat1 = 236,
  aux_sym_string_repeat2 = 237,
  aux_sym_template_string_repeat1 = 238,
  aux_sym_class_body_repeat1 = 239,
  aux_sym_formal_parameters_repeat1 = 240,
  alias_sym_import_specifier = 241,
  alias_sym_property_identifier = 242,
  alias_sym_shorthand_property_identifier = 243,
  alias_sym_shorthand_property_identifier_pattern = 244,
  alias_sym_statement_identifier = 245,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [sym_jsx_text] = "jsx_text",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_public_field_definition] = "public_field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_jsx_text] = sym_jsx_text,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_initializer = 19,
  field_key = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_object = 25,
  field_open_tag = 26,
  field_operator = 27,
  field_parameter = 28,
  field_parameters = 29,
  field_pattern = 30,
  field_property = 31,
  field_right = 32,
  field_source = 33,
  field_value = 34,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 2},
  [15] = {.index = 18, .length = 2},
  [18] = {.index = 20, .length = 1},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 2},
  [21] = {.index = 25, .length = 2},
  [22] = {.index = 27, .length = 3},
  [23] = {.index = 30, .length = 2},
  [24] = {.index = 32, .length = 2},
  [25] = {.index = 34, .length = 2},
  [26] = {.index = 36, .length = 2},
  [27] = {.index = 38, .length = 1},
  [28] = {.index = 39, .length = 1},
  [29] = {.index = 40, .length = 1},
  [30] = {.index = 41, .length = 1},
  [31] = {.index = 42, .length = 1},
  [32] = {.index = 43, .length = 1},
  [33] = {.index = 44, .length = 2},
  [34] = {.index = 46, .length = 1},
  [35] = {.index = 47, .length = 2},
  [36] = {.index = 49, .length = 2},
  [37] = {.index = 16, .length = 2},
  [38] = {.index = 18, .length = 2},
  [39] = {.index = 51, .length = 3},
  [40] = {.index = 54, .length = 2},
  [41] = {.index = 56, .length = 2},
  [42] = {.index = 58, .length = 2},
  [43] = {.index = 60, .length = 2},
  [44] = {.index = 62, .length = 2},
  [45] = {.index = 64, .length = 2},
  [46] = {.index = 66, .length = 1},
  [47] = {.index = 67, .length = 1},
  [48] = {.index = 68, .length = 2},
  [49] = {.index = 16, .length = 2},
  [50] = {.index = 70, .length = 2},
  [51] = {.index = 72, .length = 3},
  [52] = {.index = 68, .length = 2},
  [53] = {.index = 75, .length = 1},
  [54] = {.index = 76, .length = 3},
  [55] = {.index = 79, .length = 3},
  [56] = {.index = 82, .length = 3},
  [57] = {.index = 85, .length = 2},
  [58] = {.index = 87, .length = 2},
  [59] = {.index = 89, .length = 2},
  [60] = {.index = 91, .length = 1},
  [61] = {.index = 92, .length = 2},
  [62] = {.index = 94, .length = 1},
  [63] = {.index = 95, .length = 2},
  [64] = {.index = 97, .length = 2},
  [65] = {.index = 99, .length = 2},
  [66] = {.index = 101, .length = 2},
  [67] = {.index = 99, .length = 2},
  [68] = {.index = 103, .length = 2},
  [69] = {.index = 105, .length = 3},
  [70] = {.index = 108, .length = 2},
  [71] = {.index = 110, .length = 3},
  [72] = {.index = 113, .length = 2},
  [73] = {.index = 115, .length = 2},
  [74] = {.index = 117, .length = 4},
  [75] = {.index = 121, .length = 2},
  [76] = {.index = 123, .length = 2},
  [77] = {.index = 125, .length = 2},
  [78] = {.index = 127, .length = 3},
  [79] = {.index = 130, .length = 2},
  [80] = {.index = 132, .length = 3},
  [81] = {.index = 135, .length = 1},
  [82] = {.index = 136, .length = 2},
  [83] = {.index = 138, .length = 3},
  [84] = {.index = 141, .length = 4},
  [85] = {.index = 145, .length = 2},
  [86] = {.index = 145, .length = 2},
  [87] = {.index = 147, .length = 3},
  [88] = {.index = 150, .length = 3},
  [89] = {.index = 153, .length = 4},
  [90] = {.index = 157, .length = 2},
  [91] = {.index = 159, .length = 4},
  [92] = {.index = 163, .length = 2},
  [93] = {.index = 165, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_argument, 0},
    {field_operator, 1},
  [9] =
    {field_arguments, 1},
    {field_function, 0},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_label, 0},
  [16] =
    {field_left, 0},
    {field_right, 2},
  [18] =
    {field_body, 2},
    {field_parameter, 0},
  [20] =
    {field_source, 1},
  [21] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [23] =
    {field_condition, 1},
    {field_consequence, 2},
  [25] =
    {field_body, 2},
    {field_value, 1},
  [27] =
    {field_body, 2},
    {field_left, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [30] =
    {field_body, 2},
    {field_condition, 1},
  [32] =
    {field_body, 1},
    {field_handler, 2},
  [34] =
    {field_body, 1},
    {field_finalizer, 2},
  [36] =
    {field_body, 2},
    {field_object, 1},
  [38] =
    {field_label, 1},
  [39] =
    {field_name, 1},
  [40] =
    {field_attribute, 0},
  [41] =
    {field_pattern, 1},
  [42] =
    {field_member, 0},
  [43] =
    {field_property, 0},
  [44] =
    {field_body, 2},
    {field_name, 1},
  [46] =
    {field_body, 2},
  [47] =
    {field_body, 2},
    {field_parameters, 1},
  [49] =
    {field_arguments, 2},
    {field_constructor, 1},
  [51] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [54] =
    {field_object, 0},
    {field_property, 2},
  [56] =
    {field_arguments, 2},
    {field_function, 0},
  [58] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [60] =
    {field_body, 2},
    {field_parameters, 0},
  [62] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [64] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [66] =
    {field_source, 2, .inherited = true},
  [67] =
    {field_value, 2},
  [68] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [70] =
    {field_key, 0},
    {field_value, 2},
  [72] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [75] =
    {field_value, 1},
  [76] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [79] =
    {field_body, 3},
    {field_left, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [82] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [85] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [87] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [89] =
    {field_flags, 3},
    {field_pattern, 1},
  [91] =
    {field_property, 1},
  [92] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [94] =
    {field_member, 1, .inherited = true},
  [95] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [97] =
    {field_body, 3},
    {field_name, 1},
  [99] =
    {field_body, 3},
    {field_parameter, 1},
  [101] =
    {field_body, 3},
    {field_parameters, 2},
  [103] =
    {field_body, 3},
    {field_parameters, 1},
  [105] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [108] =
    {field_index, 2},
    {field_object, 0},
  [110] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [113] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [115] =
    {field_alias, 2},
    {field_name, 0},
  [117] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
  [121] =
    {field_body, 1},
    {field_condition, 3},
  [123] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [125] =
    {field_body, 4},
    {field_parameters, 3},
  [127] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [130] =
    {field_index, 3},
    {field_object, 0},
  [132] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [135] =
    {field_name, 2},
  [136] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [138] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [141] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [145] =
    {field_left, 1},
    {field_right, 3},
  [147] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [150] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [153] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
  [157] =
    {field_left, 2},
    {field_right, 4},
  [159] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [163] =
    {field_body, 4},
    {field_parameter, 2},
  [165] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [13] = {
    [0] = alias_sym_statement_identifier,
  },
  [14] = {
    [0] = sym_identifier,
  },
  [15] = {
    [0] = sym_identifier,
  },
  [16] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [27] = {
    [1] = alias_sym_statement_identifier,
  },
  [40] = {
    [2] = alias_sym_property_identifier,
  },
  [49] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [52] = {
    [1] = alias_sym_import_specifier,
  },
  [65] = {
    [1] = sym_identifier,
  },
  [85] = {
    [1] = sym_identifier,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '`' || (c < 8203
      ? (c < 160
        ? (c >= '{' && c <= '~')
        : c <= 160)
      : (c <= 8203 || (c < 65279
        ? c == 8288
        : c <= 65279)))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(57);
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(123);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(60);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == '?') ADVANCE(111);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(126);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(188);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '[') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(53);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(173);
      if (lookahead != 0) ADVANCE(174);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(58);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == '<') ADVANCE(75);
      if (lookahead == '>') ADVANCE(78);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(188);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(123);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(60);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(82);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == '?') ADVANCE(111);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(126);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > '#' &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '=') ADVANCE(20);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '?') ADVANCE(112);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '=') ADVANCE(20);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '?') ADVANCE(112);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(155);
      if (lookahead != 0) ADVANCE(156);
      END_STATE();
    case 8:
      if (lookahead == '$') ADVANCE(25);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(25);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      END_STATE();
    case 10:
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '/') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(162);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(169);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(168);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(110);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > '~') ADVANCE(188);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '<') ADVANCE(75);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(87);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(88);
      END_STATE();
    case 18:
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(18)
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 21:
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == ']') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(21);
      END_STATE();
    case 22:
      if (lookahead == 'u') ADVANCE(26);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(164);
      END_STATE();
    case 23:
      if (lookahead == 'u') ADVANCE(27);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(28);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(164);
      END_STATE();
    case 25:
      if (lookahead == '{') ADVANCE(171);
      END_STATE();
    case 26:
      if (lookahead == '{') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 27:
      if (lookahead == '{') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 28:
      if (lookahead == '{') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 29:
      if (lookahead == '}') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 30:
      if (lookahead == '}') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 31:
      if (lookahead == '}') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 32:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 33:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(179);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(180);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(178);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(188);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(181);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 52:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(21);
      END_STATE();
    case 53:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(174);
      END_STATE();
    case 54:
      if (eof) ADVANCE(57);
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(123);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(60);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == '?') ADVANCE(111);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(126);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(188);
      END_STATE();
    case 55:
      if (eof) ADVANCE(57);
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '?') ADVANCE(112);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(55)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > '#') ADVANCE(188);
      END_STATE();
    case 56:
      if (eof) ADVANCE(57);
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(75);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(78);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(56)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != '^' &&
          lookahead != '|') ADVANCE(188);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(135);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(93);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(93);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(122);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(121);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(169);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '\n') ADVANCE(88);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(169);
      if (lookahead != 0) ADVANCE(83);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(86);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(88);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(85);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(13);
      if (lookahead != 0) ADVANCE(86);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(85);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(13);
      if (lookahead != 0) ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(87);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(88);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '?') ADVANCE(144);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '?') ADVANCE(143);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(103);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(114);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(113);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '|') ADVANCE(116);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(115);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(148);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(148);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(149);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(149);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(154);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(153);
      if (lookahead == '/') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(154);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(154);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '\n') ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(161);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead == '/') ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(161);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(161);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '/') ADVANCE(159);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(23);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(188);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(164);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(166);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(169);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '[') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(53);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(173);
      if (lookahead != 0) ADVANCE(174);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(53);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(174);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(23);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '`' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(188);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(185);
      if (lookahead == '0') ADVANCE(182);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(33);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(34);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(41);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(176);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(185);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == '_') ADVANCE(35);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(176);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == '_') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > '~' &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(188);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '{') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '|' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(188);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(23);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == 'y') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      if (lookahead == 'w') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 25:
      if (lookahead == 'b') ADVANCE(64);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(68);
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(79);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(129);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 96:
      if (lookahead == 'h') ADVANCE(131);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 100:
      if (lookahead == 'k') ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 102:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 125:
      if (lookahead == 'w') ADVANCE(155);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 132:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 143:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(172);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 156:
      if (lookahead == 'f') ADVANCE(174);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 166:
      if (lookahead == 'y') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(182);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(186);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 189:
      if (lookahead == 'f') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 56},
  [2] = {.lex_state = 56},
  [3] = {.lex_state = 56},
  [4] = {.lex_state = 56},
  [5] = {.lex_state = 56},
  [6] = {.lex_state = 56},
  [7] = {.lex_state = 56},
  [8] = {.lex_state = 56},
  [9] = {.lex_state = 56},
  [10] = {.lex_state = 56},
  [11] = {.lex_state = 56},
  [12] = {.lex_state = 56},
  [13] = {.lex_state = 56},
  [14] = {.lex_state = 56},
  [15] = {.lex_state = 56},
  [16] = {.lex_state = 56},
  [17] = {.lex_state = 56},
  [18] = {.lex_state = 56},
  [19] = {.lex_state = 56},
  [20] = {.lex_state = 56},
  [21] = {.lex_state = 56},
  [22] = {.lex_state = 56},
  [23] = {.lex_state = 56},
  [24] = {.lex_state = 56},
  [25] = {.lex_state = 56},
  [26] = {.lex_state = 56},
  [27] = {.lex_state = 56},
  [28] = {.lex_state = 56},
  [29] = {.lex_state = 56},
  [30] = {.lex_state = 56},
  [31] = {.lex_state = 56},
  [32] = {.lex_state = 56},
  [33] = {.lex_state = 56},
  [34] = {.lex_state = 56},
  [35] = {.lex_state = 56},
  [36] = {.lex_state = 56},
  [37] = {.lex_state = 56},
  [38] = {.lex_state = 56},
  [39] = {.lex_state = 56},
  [40] = {.lex_state = 56},
  [41] = {.lex_state = 56},
  [42] = {.lex_state = 56},
  [43] = {.lex_state = 56},
  [44] = {.lex_state = 55},
  [45] = {.lex_state = 55, .external_lex_state = 2},
  [46] = {.lex_state = 55},
  [47] = {.lex_state = 55, .external_lex_state = 2},
  [48] = {.lex_state = 55, .external_lex_state = 2},
  [49] = {.lex_state = 55, .external_lex_state = 2},
  [50] = {.lex_state = 55, .external_lex_state = 2},
  [51] = {.lex_state = 55, .external_lex_state = 2},
  [52] = {.lex_state = 55, .external_lex_state = 2},
  [53] = {.lex_state = 55, .external_lex_state = 2},
  [54] = {.lex_state = 55, .external_lex_state = 2},
  [55] = {.lex_state = 55, .external_lex_state = 2},
  [56] = {.lex_state = 55, .external_lex_state = 2},
  [57] = {.lex_state = 55, .external_lex_state = 2},
  [58] = {.lex_state = 55, .external_lex_state = 2},
  [59] = {.lex_state = 55, .external_lex_state = 2},
  [60] = {.lex_state = 55, .external_lex_state = 2},
  [61] = {.lex_state = 55, .external_lex_state = 2},
  [62] = {.lex_state = 56},
  [63] = {.lex_state = 56},
  [64] = {.lex_state = 56},
  [65] = {.lex_state = 56},
  [66] = {.lex_state = 56},
  [67] = {.lex_state = 56},
  [68] = {.lex_state = 56},
  [69] = {.lex_state = 56},
  [70] = {.lex_state = 56},
  [71] = {.lex_state = 56},
  [72] = {.lex_state = 56},
  [73] = {.lex_state = 56},
  [74] = {.lex_state = 56},
  [75] = {.lex_state = 56},
  [76] = {.lex_state = 56},
  [77] = {.lex_state = 56},
  [78] = {.lex_state = 56},
  [79] = {.lex_state = 56},
  [80] = {.lex_state = 56},
  [81] = {.lex_state = 56},
  [82] = {.lex_state = 56},
  [83] = {.lex_state = 56, .external_lex_state = 2},
  [84] = {.lex_state = 56},
  [85] = {.lex_state = 56},
  [86] = {.lex_state = 56},
  [87] = {.lex_state = 56},
  [88] = {.lex_state = 56},
  [89] = {.lex_state = 56},
  [90] = {.lex_state = 56},
  [91] = {.lex_state = 56},
  [92] = {.lex_state = 4, .external_lex_state = 2},
  [93] = {.lex_state = 56},
  [94] = {.lex_state = 56},
  [95] = {.lex_state = 56},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 56},
  [98] = {.lex_state = 56},
  [99] = {.lex_state = 56},
  [100] = {.lex_state = 56},
  [101] = {.lex_state = 56},
  [102] = {.lex_state = 56},
  [103] = {.lex_state = 56},
  [104] = {.lex_state = 56},
  [105] = {.lex_state = 56},
  [106] = {.lex_state = 3},
  [107] = {.lex_state = 4, .external_lex_state = 2},
  [108] = {.lex_state = 56},
  [109] = {.lex_state = 56},
  [110] = {.lex_state = 56},
  [111] = {.lex_state = 56},
  [112] = {.lex_state = 56},
  [113] = {.lex_state = 56},
  [114] = {.lex_state = 56},
  [115] = {.lex_state = 56},
  [116] = {.lex_state = 3},
  [117] = {.lex_state = 56},
  [118] = {.lex_state = 56},
  [119] = {.lex_state = 56},
  [120] = {.lex_state = 56},
  [121] = {.lex_state = 4, .external_lex_state = 2},
  [122] = {.lex_state = 3},
  [123] = {.lex_state = 56},
  [124] = {.lex_state = 56},
  [125] = {.lex_state = 56},
  [126] = {.lex_state = 56},
  [127] = {.lex_state = 56},
  [128] = {.lex_state = 56},
  [129] = {.lex_state = 56},
  [130] = {.lex_state = 56},
  [131] = {.lex_state = 56},
  [132] = {.lex_state = 56},
  [133] = {.lex_state = 56},
  [134] = {.lex_state = 56},
  [135] = {.lex_state = 56},
  [136] = {.lex_state = 56},
  [137] = {.lex_state = 56},
  [138] = {.lex_state = 56},
  [139] = {.lex_state = 56},
  [140] = {.lex_state = 56},
  [141] = {.lex_state = 56},
  [142] = {.lex_state = 56},
  [143] = {.lex_state = 56},
  [144] = {.lex_state = 56},
  [145] = {.lex_state = 56},
  [146] = {.lex_state = 56},
  [147] = {.lex_state = 56},
  [148] = {.lex_state = 56},
  [149] = {.lex_state = 56},
  [150] = {.lex_state = 56},
  [151] = {.lex_state = 56},
  [152] = {.lex_state = 56},
  [153] = {.lex_state = 56},
  [154] = {.lex_state = 56},
  [155] = {.lex_state = 56},
  [156] = {.lex_state = 56},
  [157] = {.lex_state = 56},
  [158] = {.lex_state = 56},
  [159] = {.lex_state = 56},
  [160] = {.lex_state = 56},
  [161] = {.lex_state = 56},
  [162] = {.lex_state = 56},
  [163] = {.lex_state = 56},
  [164] = {.lex_state = 56},
  [165] = {.lex_state = 56},
  [166] = {.lex_state = 56},
  [167] = {.lex_state = 56},
  [168] = {.lex_state = 56},
  [169] = {.lex_state = 56},
  [170] = {.lex_state = 56},
  [171] = {.lex_state = 56},
  [172] = {.lex_state = 56},
  [173] = {.lex_state = 56},
  [174] = {.lex_state = 56},
  [175] = {.lex_state = 56},
  [176] = {.lex_state = 56},
  [177] = {.lex_state = 56},
  [178] = {.lex_state = 56},
  [179] = {.lex_state = 56},
  [180] = {.lex_state = 56},
  [181] = {.lex_state = 56},
  [182] = {.lex_state = 56},
  [183] = {.lex_state = 56},
  [184] = {.lex_state = 56},
  [185] = {.lex_state = 56},
  [186] = {.lex_state = 56},
  [187] = {.lex_state = 56},
  [188] = {.lex_state = 56},
  [189] = {.lex_state = 56},
  [190] = {.lex_state = 56},
  [191] = {.lex_state = 56},
  [192] = {.lex_state = 56},
  [193] = {.lex_state = 56},
  [194] = {.lex_state = 56},
  [195] = {.lex_state = 56},
  [196] = {.lex_state = 4, .external_lex_state = 2},
  [197] = {.lex_state = 4, .external_lex_state = 2},
  [198] = {.lex_state = 4, .external_lex_state = 2},
  [199] = {.lex_state = 4, .external_lex_state = 2},
  [200] = {.lex_state = 4, .external_lex_state = 2},
  [201] = {.lex_state = 4, .external_lex_state = 2},
  [202] = {.lex_state = 4, .external_lex_state = 2},
  [203] = {.lex_state = 4, .external_lex_state = 2},
  [204] = {.lex_state = 4, .external_lex_state = 2},
  [205] = {.lex_state = 4, .external_lex_state = 2},
  [206] = {.lex_state = 4, .external_lex_state = 2},
  [207] = {.lex_state = 4},
  [208] = {.lex_state = 56, .external_lex_state = 2},
  [209] = {.lex_state = 56, .external_lex_state = 2},
  [210] = {.lex_state = 4},
  [211] = {.lex_state = 4, .external_lex_state = 2},
  [212] = {.lex_state = 4, .external_lex_state = 2},
  [213] = {.lex_state = 4, .external_lex_state = 2},
  [214] = {.lex_state = 4, .external_lex_state = 2},
  [215] = {.lex_state = 56},
  [216] = {.lex_state = 4, .external_lex_state = 2},
  [217] = {.lex_state = 56},
  [218] = {.lex_state = 56},
  [219] = {.lex_state = 4},
  [220] = {.lex_state = 4},
  [221] = {.lex_state = 56},
  [222] = {.lex_state = 4},
  [223] = {.lex_state = 4},
  [224] = {.lex_state = 56, .external_lex_state = 2},
  [225] = {.lex_state = 56, .external_lex_state = 2},
  [226] = {.lex_state = 4},
  [227] = {.lex_state = 56},
  [228] = {.lex_state = 56},
  [229] = {.lex_state = 56, .external_lex_state = 2},
  [230] = {.lex_state = 56, .external_lex_state = 2},
  [231] = {.lex_state = 56, .external_lex_state = 2},
  [232] = {.lex_state = 56},
  [233] = {.lex_state = 56, .external_lex_state = 2},
  [234] = {.lex_state = 56, .external_lex_state = 2},
  [235] = {.lex_state = 56, .external_lex_state = 2},
  [236] = {.lex_state = 56},
  [237] = {.lex_state = 56, .external_lex_state = 2},
  [238] = {.lex_state = 56, .external_lex_state = 2},
  [239] = {.lex_state = 56, .external_lex_state = 2},
  [240] = {.lex_state = 56},
  [241] = {.lex_state = 56, .external_lex_state = 2},
  [242] = {.lex_state = 56, .external_lex_state = 2},
  [243] = {.lex_state = 56, .external_lex_state = 2},
  [244] = {.lex_state = 56},
  [245] = {.lex_state = 56},
  [246] = {.lex_state = 56},
  [247] = {.lex_state = 56},
  [248] = {.lex_state = 56},
  [249] = {.lex_state = 56},
  [250] = {.lex_state = 56},
  [251] = {.lex_state = 56},
  [252] = {.lex_state = 56},
  [253] = {.lex_state = 56},
  [254] = {.lex_state = 56},
  [255] = {.lex_state = 56},
  [256] = {.lex_state = 56},
  [257] = {.lex_state = 56},
  [258] = {.lex_state = 56},
  [259] = {.lex_state = 56},
  [260] = {.lex_state = 56},
  [261] = {.lex_state = 56},
  [262] = {.lex_state = 56},
  [263] = {.lex_state = 56},
  [264] = {.lex_state = 56},
  [265] = {.lex_state = 56},
  [266] = {.lex_state = 56},
  [267] = {.lex_state = 56},
  [268] = {.lex_state = 56},
  [269] = {.lex_state = 56},
  [270] = {.lex_state = 56},
  [271] = {.lex_state = 56},
  [272] = {.lex_state = 56},
  [273] = {.lex_state = 56},
  [274] = {.lex_state = 56},
  [275] = {.lex_state = 56},
  [276] = {.lex_state = 56},
  [277] = {.lex_state = 56},
  [278] = {.lex_state = 56},
  [279] = {.lex_state = 56},
  [280] = {.lex_state = 56},
  [281] = {.lex_state = 56},
  [282] = {.lex_state = 56},
  [283] = {.lex_state = 56},
  [284] = {.lex_state = 56},
  [285] = {.lex_state = 56},
  [286] = {.lex_state = 56},
  [287] = {.lex_state = 56},
  [288] = {.lex_state = 56},
  [289] = {.lex_state = 56},
  [290] = {.lex_state = 56},
  [291] = {.lex_state = 56},
  [292] = {.lex_state = 56},
  [293] = {.lex_state = 56},
  [294] = {.lex_state = 56},
  [295] = {.lex_state = 56},
  [296] = {.lex_state = 56},
  [297] = {.lex_state = 56},
  [298] = {.lex_state = 56},
  [299] = {.lex_state = 56},
  [300] = {.lex_state = 56},
  [301] = {.lex_state = 56},
  [302] = {.lex_state = 56},
  [303] = {.lex_state = 56},
  [304] = {.lex_state = 56},
  [305] = {.lex_state = 56},
  [306] = {.lex_state = 56},
  [307] = {.lex_state = 56},
  [308] = {.lex_state = 56},
  [309] = {.lex_state = 56},
  [310] = {.lex_state = 56},
  [311] = {.lex_state = 56},
  [312] = {.lex_state = 56},
  [313] = {.lex_state = 56},
  [314] = {.lex_state = 56},
  [315] = {.lex_state = 56},
  [316] = {.lex_state = 56},
  [317] = {.lex_state = 56},
  [318] = {.lex_state = 56},
  [319] = {.lex_state = 56},
  [320] = {.lex_state = 56},
  [321] = {.lex_state = 56},
  [322] = {.lex_state = 56},
  [323] = {.lex_state = 56},
  [324] = {.lex_state = 56},
  [325] = {.lex_state = 56},
  [326] = {.lex_state = 56},
  [327] = {.lex_state = 56},
  [328] = {.lex_state = 56},
  [329] = {.lex_state = 56},
  [330] = {.lex_state = 56},
  [331] = {.lex_state = 56},
  [332] = {.lex_state = 4, .external_lex_state = 2},
  [333] = {.lex_state = 4, .external_lex_state = 2},
  [334] = {.lex_state = 4, .external_lex_state = 2},
  [335] = {.lex_state = 4},
  [336] = {.lex_state = 4},
  [337] = {.lex_state = 4},
  [338] = {.lex_state = 4},
  [339] = {.lex_state = 4},
  [340] = {.lex_state = 4},
  [341] = {.lex_state = 4},
  [342] = {.lex_state = 4},
  [343] = {.lex_state = 4},
  [344] = {.lex_state = 4, .external_lex_state = 2},
  [345] = {.lex_state = 4, .external_lex_state = 2},
  [346] = {.lex_state = 4, .external_lex_state = 2},
  [347] = {.lex_state = 4, .external_lex_state = 2},
  [348] = {.lex_state = 4, .external_lex_state = 2},
  [349] = {.lex_state = 4, .external_lex_state = 2},
  [350] = {.lex_state = 4, .external_lex_state = 2},
  [351] = {.lex_state = 4, .external_lex_state = 2},
  [352] = {.lex_state = 4, .external_lex_state = 2},
  [353] = {.lex_state = 4, .external_lex_state = 2},
  [354] = {.lex_state = 4, .external_lex_state = 2},
  [355] = {.lex_state = 4},
  [356] = {.lex_state = 4, .external_lex_state = 2},
  [357] = {.lex_state = 4, .external_lex_state = 2},
  [358] = {.lex_state = 4, .external_lex_state = 2},
  [359] = {.lex_state = 4},
  [360] = {.lex_state = 4},
  [361] = {.lex_state = 56},
  [362] = {.lex_state = 4, .external_lex_state = 2},
  [363] = {.lex_state = 4, .external_lex_state = 2},
  [364] = {.lex_state = 56},
  [365] = {.lex_state = 56},
  [366] = {.lex_state = 56},
  [367] = {.lex_state = 4, .external_lex_state = 2},
  [368] = {.lex_state = 4},
  [369] = {.lex_state = 4},
  [370] = {.lex_state = 4},
  [371] = {.lex_state = 4},
  [372] = {.lex_state = 4},
  [373] = {.lex_state = 4},
  [374] = {.lex_state = 4},
  [375] = {.lex_state = 4},
  [376] = {.lex_state = 4},
  [377] = {.lex_state = 4},
  [378] = {.lex_state = 55},
  [379] = {.lex_state = 55},
  [380] = {.lex_state = 4},
  [381] = {.lex_state = 55},
  [382] = {.lex_state = 55, .external_lex_state = 2},
  [383] = {.lex_state = 55},
  [384] = {.lex_state = 55, .external_lex_state = 2},
  [385] = {.lex_state = 55},
  [386] = {.lex_state = 55},
  [387] = {.lex_state = 55},
  [388] = {.lex_state = 55},
  [389] = {.lex_state = 55},
  [390] = {.lex_state = 55},
  [391] = {.lex_state = 55},
  [392] = {.lex_state = 55, .external_lex_state = 2},
  [393] = {.lex_state = 55},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 55},
  [396] = {.lex_state = 55},
  [397] = {.lex_state = 55},
  [398] = {.lex_state = 55},
  [399] = {.lex_state = 55},
  [400] = {.lex_state = 55},
  [401] = {.lex_state = 55},
  [402] = {.lex_state = 55},
  [403] = {.lex_state = 55},
  [404] = {.lex_state = 55},
  [405] = {.lex_state = 55},
  [406] = {.lex_state = 55},
  [407] = {.lex_state = 55},
  [408] = {.lex_state = 55},
  [409] = {.lex_state = 55},
  [410] = {.lex_state = 55},
  [411] = {.lex_state = 55, .external_lex_state = 2},
  [412] = {.lex_state = 55},
  [413] = {.lex_state = 55},
  [414] = {.lex_state = 55},
  [415] = {.lex_state = 55},
  [416] = {.lex_state = 55},
  [417] = {.lex_state = 55},
  [418] = {.lex_state = 55},
  [419] = {.lex_state = 55},
  [420] = {.lex_state = 55},
  [421] = {.lex_state = 55},
  [422] = {.lex_state = 55, .external_lex_state = 2},
  [423] = {.lex_state = 55, .external_lex_state = 2},
  [424] = {.lex_state = 55},
  [425] = {.lex_state = 55},
  [426] = {.lex_state = 55},
  [427] = {.lex_state = 55, .external_lex_state = 2},
  [428] = {.lex_state = 55},
  [429] = {.lex_state = 55, .external_lex_state = 2},
  [430] = {.lex_state = 55},
  [431] = {.lex_state = 55},
  [432] = {.lex_state = 55, .external_lex_state = 2},
  [433] = {.lex_state = 55, .external_lex_state = 2},
  [434] = {.lex_state = 55},
  [435] = {.lex_state = 55},
  [436] = {.lex_state = 55, .external_lex_state = 2},
  [437] = {.lex_state = 55},
  [438] = {.lex_state = 55},
  [439] = {.lex_state = 55, .external_lex_state = 2},
  [440] = {.lex_state = 55},
  [441] = {.lex_state = 55},
  [442] = {.lex_state = 55, .external_lex_state = 2},
  [443] = {.lex_state = 55, .external_lex_state = 2},
  [444] = {.lex_state = 55, .external_lex_state = 2},
  [445] = {.lex_state = 55, .external_lex_state = 2},
  [446] = {.lex_state = 55, .external_lex_state = 2},
  [447] = {.lex_state = 55, .external_lex_state = 2},
  [448] = {.lex_state = 55, .external_lex_state = 2},
  [449] = {.lex_state = 55, .external_lex_state = 2},
  [450] = {.lex_state = 55, .external_lex_state = 2},
  [451] = {.lex_state = 55},
  [452] = {.lex_state = 55},
  [453] = {.lex_state = 55},
  [454] = {.lex_state = 55},
  [455] = {.lex_state = 55},
  [456] = {.lex_state = 55},
  [457] = {.lex_state = 55, .external_lex_state = 2},
  [458] = {.lex_state = 55},
  [459] = {.lex_state = 55},
  [460] = {.lex_state = 55},
  [461] = {.lex_state = 55},
  [462] = {.lex_state = 55},
  [463] = {.lex_state = 55},
  [464] = {.lex_state = 55},
  [465] = {.lex_state = 55},
  [466] = {.lex_state = 55},
  [467] = {.lex_state = 55},
  [468] = {.lex_state = 55},
  [469] = {.lex_state = 55, .external_lex_state = 2},
  [470] = {.lex_state = 55},
  [471] = {.lex_state = 55},
  [472] = {.lex_state = 55},
  [473] = {.lex_state = 55, .external_lex_state = 2},
  [474] = {.lex_state = 55},
  [475] = {.lex_state = 55, .external_lex_state = 2},
  [476] = {.lex_state = 55},
  [477] = {.lex_state = 55},
  [478] = {.lex_state = 55},
  [479] = {.lex_state = 55},
  [480] = {.lex_state = 55, .external_lex_state = 2},
  [481] = {.lex_state = 55},
  [482] = {.lex_state = 55, .external_lex_state = 2},
  [483] = {.lex_state = 55, .external_lex_state = 2},
  [484] = {.lex_state = 55},
  [485] = {.lex_state = 55},
  [486] = {.lex_state = 55},
  [487] = {.lex_state = 55, .external_lex_state = 2},
  [488] = {.lex_state = 55, .external_lex_state = 2},
  [489] = {.lex_state = 55},
  [490] = {.lex_state = 55},
  [491] = {.lex_state = 55},
  [492] = {.lex_state = 55},
  [493] = {.lex_state = 55},
  [494] = {.lex_state = 55},
  [495] = {.lex_state = 55},
  [496] = {.lex_state = 55, .external_lex_state = 2},
  [497] = {.lex_state = 55},
  [498] = {.lex_state = 55},
  [499] = {.lex_state = 55, .external_lex_state = 2},
  [500] = {.lex_state = 55},
  [501] = {.lex_state = 55, .external_lex_state = 2},
  [502] = {.lex_state = 55},
  [503] = {.lex_state = 55, .external_lex_state = 2},
  [504] = {.lex_state = 55},
  [505] = {.lex_state = 5, .external_lex_state = 2},
  [506] = {.lex_state = 55},
  [507] = {.lex_state = 55, .external_lex_state = 2},
  [508] = {.lex_state = 55, .external_lex_state = 2},
  [509] = {.lex_state = 55, .external_lex_state = 2},
  [510] = {.lex_state = 55},
  [511] = {.lex_state = 55, .external_lex_state = 2},
  [512] = {.lex_state = 55, .external_lex_state = 2},
  [513] = {.lex_state = 55, .external_lex_state = 2},
  [514] = {.lex_state = 55, .external_lex_state = 2},
  [515] = {.lex_state = 55},
  [516] = {.lex_state = 55, .external_lex_state = 2},
  [517] = {.lex_state = 55, .external_lex_state = 2},
  [518] = {.lex_state = 55, .external_lex_state = 2},
  [519] = {.lex_state = 55, .external_lex_state = 2},
  [520] = {.lex_state = 55, .external_lex_state = 2},
  [521] = {.lex_state = 55, .external_lex_state = 2},
  [522] = {.lex_state = 55, .external_lex_state = 2},
  [523] = {.lex_state = 55, .external_lex_state = 2},
  [524] = {.lex_state = 55, .external_lex_state = 2},
  [525] = {.lex_state = 55},
  [526] = {.lex_state = 55},
  [527] = {.lex_state = 55, .external_lex_state = 2},
  [528] = {.lex_state = 55, .external_lex_state = 2},
  [529] = {.lex_state = 55, .external_lex_state = 2},
  [530] = {.lex_state = 55},
  [531] = {.lex_state = 55},
  [532] = {.lex_state = 55, .external_lex_state = 2},
  [533] = {.lex_state = 55, .external_lex_state = 2},
  [534] = {.lex_state = 55, .external_lex_state = 2},
  [535] = {.lex_state = 55},
  [536] = {.lex_state = 55},
  [537] = {.lex_state = 55, .external_lex_state = 2},
  [538] = {.lex_state = 55, .external_lex_state = 2},
  [539] = {.lex_state = 55, .external_lex_state = 2},
  [540] = {.lex_state = 55, .external_lex_state = 2},
  [541] = {.lex_state = 55},
  [542] = {.lex_state = 55},
  [543] = {.lex_state = 55},
  [544] = {.lex_state = 55},
  [545] = {.lex_state = 55, .external_lex_state = 2},
  [546] = {.lex_state = 55, .external_lex_state = 2},
  [547] = {.lex_state = 55, .external_lex_state = 2},
  [548] = {.lex_state = 55, .external_lex_state = 2},
  [549] = {.lex_state = 55},
  [550] = {.lex_state = 55, .external_lex_state = 2},
  [551] = {.lex_state = 55, .external_lex_state = 2},
  [552] = {.lex_state = 55, .external_lex_state = 2},
  [553] = {.lex_state = 55},
  [554] = {.lex_state = 55, .external_lex_state = 2},
  [555] = {.lex_state = 55},
  [556] = {.lex_state = 55, .external_lex_state = 2},
  [557] = {.lex_state = 55, .external_lex_state = 2},
  [558] = {.lex_state = 55},
  [559] = {.lex_state = 55},
  [560] = {.lex_state = 55, .external_lex_state = 2},
  [561] = {.lex_state = 55},
  [562] = {.lex_state = 55, .external_lex_state = 2},
  [563] = {.lex_state = 55},
  [564] = {.lex_state = 55, .external_lex_state = 2},
  [565] = {.lex_state = 55, .external_lex_state = 2},
  [566] = {.lex_state = 55, .external_lex_state = 2},
  [567] = {.lex_state = 55, .external_lex_state = 2},
  [568] = {.lex_state = 55},
  [569] = {.lex_state = 55, .external_lex_state = 2},
  [570] = {.lex_state = 55, .external_lex_state = 2},
  [571] = {.lex_state = 55, .external_lex_state = 2},
  [572] = {.lex_state = 55},
  [573] = {.lex_state = 55},
  [574] = {.lex_state = 55},
  [575] = {.lex_state = 55, .external_lex_state = 2},
  [576] = {.lex_state = 55},
  [577] = {.lex_state = 55, .external_lex_state = 2},
  [578] = {.lex_state = 55},
  [579] = {.lex_state = 55, .external_lex_state = 2},
  [580] = {.lex_state = 55, .external_lex_state = 2},
  [581] = {.lex_state = 55},
  [582] = {.lex_state = 55, .external_lex_state = 2},
  [583] = {.lex_state = 55},
  [584] = {.lex_state = 55},
  [585] = {.lex_state = 55},
  [586] = {.lex_state = 55, .external_lex_state = 2},
  [587] = {.lex_state = 55},
  [588] = {.lex_state = 55, .external_lex_state = 2},
  [589] = {.lex_state = 55},
  [590] = {.lex_state = 55, .external_lex_state = 2},
  [591] = {.lex_state = 55},
  [592] = {.lex_state = 55, .external_lex_state = 2},
  [593] = {.lex_state = 55},
  [594] = {.lex_state = 55, .external_lex_state = 2},
  [595] = {.lex_state = 55, .external_lex_state = 2},
  [596] = {.lex_state = 55, .external_lex_state = 2},
  [597] = {.lex_state = 55},
  [598] = {.lex_state = 55, .external_lex_state = 2},
  [599] = {.lex_state = 55, .external_lex_state = 2},
  [600] = {.lex_state = 55},
  [601] = {.lex_state = 55, .external_lex_state = 2},
  [602] = {.lex_state = 55},
  [603] = {.lex_state = 55, .external_lex_state = 2},
  [604] = {.lex_state = 55, .external_lex_state = 2},
  [605] = {.lex_state = 55, .external_lex_state = 2},
  [606] = {.lex_state = 55, .external_lex_state = 2},
  [607] = {.lex_state = 55, .external_lex_state = 2},
  [608] = {.lex_state = 55, .external_lex_state = 2},
  [609] = {.lex_state = 55, .external_lex_state = 2},
  [610] = {.lex_state = 55, .external_lex_state = 2},
  [611] = {.lex_state = 55, .external_lex_state = 2},
  [612] = {.lex_state = 55, .external_lex_state = 2},
  [613] = {.lex_state = 55, .external_lex_state = 2},
  [614] = {.lex_state = 55, .external_lex_state = 2},
  [615] = {.lex_state = 55},
  [616] = {.lex_state = 55},
  [617] = {.lex_state = 55, .external_lex_state = 2},
  [618] = {.lex_state = 55},
  [619] = {.lex_state = 55},
  [620] = {.lex_state = 55, .external_lex_state = 2},
  [621] = {.lex_state = 55},
  [622] = {.lex_state = 55},
  [623] = {.lex_state = 55},
  [624] = {.lex_state = 55, .external_lex_state = 2},
  [625] = {.lex_state = 55},
  [626] = {.lex_state = 55},
  [627] = {.lex_state = 55, .external_lex_state = 2},
  [628] = {.lex_state = 55, .external_lex_state = 2},
  [629] = {.lex_state = 55},
  [630] = {.lex_state = 55},
  [631] = {.lex_state = 55},
  [632] = {.lex_state = 55},
  [633] = {.lex_state = 55},
  [634] = {.lex_state = 55},
  [635] = {.lex_state = 55},
  [636] = {.lex_state = 55},
  [637] = {.lex_state = 55},
  [638] = {.lex_state = 55},
  [639] = {.lex_state = 55},
  [640] = {.lex_state = 55},
  [641] = {.lex_state = 55},
  [642] = {.lex_state = 55},
  [643] = {.lex_state = 56},
  [644] = {.lex_state = 56},
  [645] = {.lex_state = 56},
  [646] = {.lex_state = 56},
  [647] = {.lex_state = 56},
  [648] = {.lex_state = 56},
  [649] = {.lex_state = 56},
  [650] = {.lex_state = 56},
  [651] = {.lex_state = 56},
  [652] = {.lex_state = 56},
  [653] = {.lex_state = 56},
  [654] = {.lex_state = 56},
  [655] = {.lex_state = 56},
  [656] = {.lex_state = 56},
  [657] = {.lex_state = 56},
  [658] = {.lex_state = 56},
  [659] = {.lex_state = 56},
  [660] = {.lex_state = 56},
  [661] = {.lex_state = 56},
  [662] = {.lex_state = 56},
  [663] = {.lex_state = 56},
  [664] = {.lex_state = 56},
  [665] = {.lex_state = 56},
  [666] = {.lex_state = 56},
  [667] = {.lex_state = 56},
  [668] = {.lex_state = 56},
  [669] = {.lex_state = 56},
  [670] = {.lex_state = 56},
  [671] = {.lex_state = 56},
  [672] = {.lex_state = 56},
  [673] = {.lex_state = 56},
  [674] = {.lex_state = 56},
  [675] = {.lex_state = 56},
  [676] = {.lex_state = 56},
  [677] = {.lex_state = 56},
  [678] = {.lex_state = 56},
  [679] = {.lex_state = 56},
  [680] = {.lex_state = 56},
  [681] = {.lex_state = 56},
  [682] = {.lex_state = 56, .external_lex_state = 2},
  [683] = {.lex_state = 56},
  [684] = {.lex_state = 56, .external_lex_state = 2},
  [685] = {.lex_state = 56},
  [686] = {.lex_state = 56},
  [687] = {.lex_state = 56, .external_lex_state = 2},
  [688] = {.lex_state = 56},
  [689] = {.lex_state = 56},
  [690] = {.lex_state = 56, .external_lex_state = 2},
  [691] = {.lex_state = 56, .external_lex_state = 2},
  [692] = {.lex_state = 56},
  [693] = {.lex_state = 56},
  [694] = {.lex_state = 56},
  [695] = {.lex_state = 56},
  [696] = {.lex_state = 56},
  [697] = {.lex_state = 56},
  [698] = {.lex_state = 56},
  [699] = {.lex_state = 55},
  [700] = {.lex_state = 56},
  [701] = {.lex_state = 56},
  [702] = {.lex_state = 56},
  [703] = {.lex_state = 56},
  [704] = {.lex_state = 55},
  [705] = {.lex_state = 56},
  [706] = {.lex_state = 56},
  [707] = {.lex_state = 56},
  [708] = {.lex_state = 56},
  [709] = {.lex_state = 56},
  [710] = {.lex_state = 56},
  [711] = {.lex_state = 56},
  [712] = {.lex_state = 4},
  [713] = {.lex_state = 56},
  [714] = {.lex_state = 4},
  [715] = {.lex_state = 56},
  [716] = {.lex_state = 56},
  [717] = {.lex_state = 56},
  [718] = {.lex_state = 56},
  [719] = {.lex_state = 56},
  [720] = {.lex_state = 4},
  [721] = {.lex_state = 56},
  [722] = {.lex_state = 56},
  [723] = {.lex_state = 56},
  [724] = {.lex_state = 56},
  [725] = {.lex_state = 56},
  [726] = {.lex_state = 56},
  [727] = {.lex_state = 56},
  [728] = {.lex_state = 56},
  [729] = {.lex_state = 56},
  [730] = {.lex_state = 56},
  [731] = {.lex_state = 56},
  [732] = {.lex_state = 56},
  [733] = {.lex_state = 56},
  [734] = {.lex_state = 56},
  [735] = {.lex_state = 56},
  [736] = {.lex_state = 56},
  [737] = {.lex_state = 56},
  [738] = {.lex_state = 56},
  [739] = {.lex_state = 56},
  [740] = {.lex_state = 56},
  [741] = {.lex_state = 56},
  [742] = {.lex_state = 56},
  [743] = {.lex_state = 56},
  [744] = {.lex_state = 56},
  [745] = {.lex_state = 56},
  [746] = {.lex_state = 56},
  [747] = {.lex_state = 56},
  [748] = {.lex_state = 56},
  [749] = {.lex_state = 56},
  [750] = {.lex_state = 56},
  [751] = {.lex_state = 56},
  [752] = {.lex_state = 56},
  [753] = {.lex_state = 56},
  [754] = {.lex_state = 56},
  [755] = {.lex_state = 56},
  [756] = {.lex_state = 16},
  [757] = {.lex_state = 16},
  [758] = {.lex_state = 16},
  [759] = {.lex_state = 16},
  [760] = {.lex_state = 17},
  [761] = {.lex_state = 16},
  [762] = {.lex_state = 16},
  [763] = {.lex_state = 17},
  [764] = {.lex_state = 16},
  [765] = {.lex_state = 17},
  [766] = {.lex_state = 56},
  [767] = {.lex_state = 17},
  [768] = {.lex_state = 17},
  [769] = {.lex_state = 16},
  [770] = {.lex_state = 17},
  [771] = {.lex_state = 16},
  [772] = {.lex_state = 17},
  [773] = {.lex_state = 17},
  [774] = {.lex_state = 56},
  [775] = {.lex_state = 16},
  [776] = {.lex_state = 16},
  [777] = {.lex_state = 16},
  [778] = {.lex_state = 17},
  [779] = {.lex_state = 16},
  [780] = {.lex_state = 17},
  [781] = {.lex_state = 16},
  [782] = {.lex_state = 17},
  [783] = {.lex_state = 16},
  [784] = {.lex_state = 16},
  [785] = {.lex_state = 16},
  [786] = {.lex_state = 17},
  [787] = {.lex_state = 16},
  [788] = {.lex_state = 17},
  [789] = {.lex_state = 16},
  [790] = {.lex_state = 17},
  [791] = {.lex_state = 17},
  [792] = {.lex_state = 16},
  [793] = {.lex_state = 16},
  [794] = {.lex_state = 16},
  [795] = {.lex_state = 16},
  [796] = {.lex_state = 16},
  [797] = {.lex_state = 17},
  [798] = {.lex_state = 16},
  [799] = {.lex_state = 16},
  [800] = {.lex_state = 16},
  [801] = {.lex_state = 17},
  [802] = {.lex_state = 16},
  [803] = {.lex_state = 16},
  [804] = {.lex_state = 16},
  [805] = {.lex_state = 16},
  [806] = {.lex_state = 16},
  [807] = {.lex_state = 16},
  [808] = {.lex_state = 56},
  [809] = {.lex_state = 56},
  [810] = {.lex_state = 56},
  [811] = {.lex_state = 56},
  [812] = {.lex_state = 56},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 56},
  [815] = {.lex_state = 56, .external_lex_state = 2},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 56},
  [822] = {.lex_state = 56},
  [823] = {.lex_state = 56},
  [824] = {.lex_state = 56},
  [825] = {.lex_state = 56},
  [826] = {.lex_state = 56},
  [827] = {.lex_state = 56},
  [828] = {.lex_state = 16},
  [829] = {.lex_state = 16},
  [830] = {.lex_state = 8, .external_lex_state = 3},
  [831] = {.lex_state = 8, .external_lex_state = 3},
  [832] = {.lex_state = 0, .external_lex_state = 2},
  [833] = {.lex_state = 56, .external_lex_state = 2},
  [834] = {.lex_state = 16},
  [835] = {.lex_state = 16},
  [836] = {.lex_state = 16},
  [837] = {.lex_state = 56, .external_lex_state = 2},
  [838] = {.lex_state = 56, .external_lex_state = 2},
  [839] = {.lex_state = 56},
  [840] = {.lex_state = 16},
  [841] = {.lex_state = 56, .external_lex_state = 2},
  [842] = {.lex_state = 16},
  [843] = {.lex_state = 56, .external_lex_state = 2},
  [844] = {.lex_state = 8, .external_lex_state = 3},
  [845] = {.lex_state = 56, .external_lex_state = 2},
  [846] = {.lex_state = 56},
  [847] = {.lex_state = 16},
  [848] = {.lex_state = 16},
  [849] = {.lex_state = 0, .external_lex_state = 2},
  [850] = {.lex_state = 56},
  [851] = {.lex_state = 16},
  [852] = {.lex_state = 56, .external_lex_state = 2},
  [853] = {.lex_state = 56},
  [854] = {.lex_state = 8, .external_lex_state = 3},
  [855] = {.lex_state = 16},
  [856] = {.lex_state = 16},
  [857] = {.lex_state = 16},
  [858] = {.lex_state = 16},
  [859] = {.lex_state = 56, .external_lex_state = 2},
  [860] = {.lex_state = 16},
  [861] = {.lex_state = 16},
  [862] = {.lex_state = 56},
  [863] = {.lex_state = 8, .external_lex_state = 3},
  [864] = {.lex_state = 56},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 56},
  [867] = {.lex_state = 56},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 16},
  [870] = {.lex_state = 16},
  [871] = {.lex_state = 16},
  [872] = {.lex_state = 16},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 16},
  [875] = {.lex_state = 16},
  [876] = {.lex_state = 16},
  [877] = {.lex_state = 16},
  [878] = {.lex_state = 16},
  [879] = {.lex_state = 16},
  [880] = {.lex_state = 56},
  [881] = {.lex_state = 16},
  [882] = {.lex_state = 56},
  [883] = {.lex_state = 16},
  [884] = {.lex_state = 16},
  [885] = {.lex_state = 16},
  [886] = {.lex_state = 16},
  [887] = {.lex_state = 56},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 16},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 56},
  [892] = {.lex_state = 56},
  [893] = {.lex_state = 56},
  [894] = {.lex_state = 56},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 16},
  [897] = {.lex_state = 16},
  [898] = {.lex_state = 16},
  [899] = {.lex_state = 56},
  [900] = {.lex_state = 16},
  [901] = {.lex_state = 0, .external_lex_state = 2},
  [902] = {.lex_state = 16},
  [903] = {.lex_state = 56},
  [904] = {.lex_state = 56},
  [905] = {.lex_state = 7},
  [906] = {.lex_state = 10},
  [907] = {.lex_state = 7},
  [908] = {.lex_state = 56},
  [909] = {.lex_state = 56},
  [910] = {.lex_state = 0, .external_lex_state = 2},
  [911] = {.lex_state = 16},
  [912] = {.lex_state = 0, .external_lex_state = 2},
  [913] = {.lex_state = 56},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 56},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 56},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 56},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 56},
  [923] = {.lex_state = 0, .external_lex_state = 2},
  [924] = {.lex_state = 56},
  [925] = {.lex_state = 56},
  [926] = {.lex_state = 56},
  [927] = {.lex_state = 56, .external_lex_state = 2},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 56},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 16},
  [932] = {.lex_state = 56},
  [933] = {.lex_state = 56},
  [934] = {.lex_state = 10},
  [935] = {.lex_state = 56},
  [936] = {.lex_state = 0, .external_lex_state = 2},
  [937] = {.lex_state = 0, .external_lex_state = 2},
  [938] = {.lex_state = 56},
  [939] = {.lex_state = 56},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0, .external_lex_state = 2},
  [942] = {.lex_state = 7},
  [943] = {.lex_state = 10},
  [944] = {.lex_state = 56},
  [945] = {.lex_state = 10},
  [946] = {.lex_state = 10},
  [947] = {.lex_state = 7},
  [948] = {.lex_state = 7},
  [949] = {.lex_state = 10},
  [950] = {.lex_state = 7},
  [951] = {.lex_state = 8, .external_lex_state = 3},
  [952] = {.lex_state = 16},
  [953] = {.lex_state = 56},
  [954] = {.lex_state = 56},
  [955] = {.lex_state = 56},
  [956] = {.lex_state = 56},
  [957] = {.lex_state = 56},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 10},
  [960] = {.lex_state = 56},
  [961] = {.lex_state = 56},
  [962] = {.lex_state = 56},
  [963] = {.lex_state = 7},
  [964] = {.lex_state = 56},
  [965] = {.lex_state = 16},
  [966] = {.lex_state = 0, .external_lex_state = 2},
  [967] = {.lex_state = 17},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 17},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 17},
  [972] = {.lex_state = 17},
  [973] = {.lex_state = 0, .external_lex_state = 2},
  [974] = {.lex_state = 17},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 17},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 17},
  [980] = {.lex_state = 17},
  [981] = {.lex_state = 17},
  [982] = {.lex_state = 17},
  [983] = {.lex_state = 17},
  [984] = {.lex_state = 17},
  [985] = {.lex_state = 56, .external_lex_state = 2},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 3},
  [988] = {.lex_state = 17},
  [989] = {.lex_state = 56},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 56, .external_lex_state = 2},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 56},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 17},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 3},
  [1003] = {.lex_state = 56, .external_lex_state = 2},
  [1004] = {.lex_state = 3},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 56},
  [1007] = {.lex_state = 0, .external_lex_state = 2},
  [1008] = {.lex_state = 56, .external_lex_state = 2},
  [1009] = {.lex_state = 56},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 56},
  [1012] = {.lex_state = 56},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 56},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 17},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 56},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 56},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 56},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 17},
  [1039] = {.lex_state = 56},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 56},
  [1043] = {.lex_state = 56},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 56},
  [1046] = {.lex_state = 3},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 56, .external_lex_state = 2},
  [1054] = {.lex_state = 56},
  [1055] = {.lex_state = 56, .external_lex_state = 2},
  [1056] = {.lex_state = 56},
  [1057] = {.lex_state = 56},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 56},
  [1064] = {.lex_state = 56, .external_lex_state = 2},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 17},
  [1067] = {.lex_state = 56, .external_lex_state = 2},
  [1068] = {.lex_state = 56, .external_lex_state = 2},
  [1069] = {.lex_state = 56},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 3},
  [1076] = {.lex_state = 56},
  [1077] = {.lex_state = 56},
  [1078] = {.lex_state = 0, .external_lex_state = 2},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 56},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0, .external_lex_state = 2},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 56},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 3},
  [1110] = {.lex_state = 0, .external_lex_state = 2},
  [1111] = {.lex_state = 56},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0, .external_lex_state = 2},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 16},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0, .external_lex_state = 2},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0, .external_lex_state = 2},
  [1159] = {.lex_state = 56},
  [1160] = {.lex_state = 56},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 56},
  [1163] = {.lex_state = 0, .external_lex_state = 2},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 56},
  [1184] = {.lex_state = 0, .external_lex_state = 2},
  [1185] = {.lex_state = 56},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0, .external_lex_state = 2},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 56},
  [1193] = {.lex_state = 0, .external_lex_state = 2},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 56},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0, .external_lex_state = 2},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 56},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 3},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0, .external_lex_state = 2},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 56},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 56},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 0, .external_lex_state = 2},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 56},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 3},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0, .external_lex_state = 2},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 0, .external_lex_state = 2},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0, .external_lex_state = 2},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 8},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 56},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 56},
  [1259] = {.lex_state = 56},
  [1260] = {.lex_state = 56},
  [1261] = {.lex_state = 56},
  [1262] = {.lex_state = 56},
  [1263] = {.lex_state = 56},
  [1264] = {.lex_state = 56},
  [1265] = {.lex_state = 56},
  [1266] = {.lex_state = 56},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 56},
  [1269] = {.lex_state = 56},
  [1270] = {.lex_state = 56},
  [1271] = {.lex_state = 56},
  [1272] = {.lex_state = 56},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 56},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 56},
  [1277] = {.lex_state = 56},
  [1278] = {.lex_state = 56},
  [1279] = {.lex_state = 56},
  [1280] = {.lex_state = 56},
  [1281] = {.lex_state = 56},
  [1282] = {.lex_state = 56},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 56},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 0},
  [1288] = {.lex_state = 56},
  [1289] = {.lex_state = 56},
  [1290] = {.lex_state = 56},
  [1291] = {.lex_state = 56},
  [1292] = {.lex_state = 56},
  [1293] = {.lex_state = 56},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 0},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 56},
  [1299] = {.lex_state = 56},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 0},
  [1302] = {.lex_state = 56},
  [1303] = {.lex_state = 0},
  [1304] = {.lex_state = 56},
  [1305] = {.lex_state = 56},
  [1306] = {.lex_state = 0},
  [1307] = {.lex_state = 0},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 56},
  [1310] = {.lex_state = 56},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 56},
  [1313] = {.lex_state = 56},
  [1314] = {.lex_state = 56},
  [1315] = {.lex_state = 0},
  [1316] = {.lex_state = 56},
  [1317] = {.lex_state = 0},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 0},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 56},
  [1324] = {.lex_state = 56},
  [1325] = {.lex_state = 56},
  [1326] = {.lex_state = 0},
  [1327] = {.lex_state = 8},
  [1328] = {.lex_state = 56},
  [1329] = {.lex_state = 56},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 0},
  [1334] = {.lex_state = 1},
  [1335] = {.lex_state = 56},
  [1336] = {.lex_state = 56},
  [1337] = {.lex_state = 56},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 56},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 56},
  [1342] = {.lex_state = 56},
  [1343] = {.lex_state = 56},
  [1344] = {.lex_state = 56},
  [1345] = {.lex_state = 56},
  [1346] = {.lex_state = 56},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 1},
  [1351] = {.lex_state = 56},
  [1352] = {.lex_state = 56},
  [1353] = {.lex_state = 56},
  [1354] = {.lex_state = 56},
  [1355] = {.lex_state = 56},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
};

static bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [3] = {
    [ts_external_token__template_chars] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1321),
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [2] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1307),
    [sym_object_assignment_pattern] = STATE(1052),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1307),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1307),
    [sym_spread_element] = STATE(1050),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(564),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [sym_rest_pattern] = STATE(1052),
    [sym_method_definition] = STATE(1050),
    [sym_pair] = STATE(1050),
    [sym_pair_pattern] = STATE(1052),
    [sym__property_name] = STATE(1049),
    [sym_computed_property_name] = STATE(1049),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(688),
    [aux_sym_object_repeat1] = STATE(1048),
    [aux_sym_object_pattern_repeat1] = STATE(1044),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(109),
    [anon_sym_set] = ACTIONS(109),
  },
  [3] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1307),
    [sym_object_assignment_pattern] = STATE(1052),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1307),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1307),
    [sym_spread_element] = STATE(1050),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(564),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [sym_rest_pattern] = STATE(1052),
    [sym_method_definition] = STATE(1050),
    [sym_pair] = STATE(1050),
    [sym_pair_pattern] = STATE(1052),
    [sym__property_name] = STATE(1049),
    [sym_computed_property_name] = STATE(1049),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(688),
    [aux_sym_object_repeat1] = STATE(1048),
    [aux_sym_object_pattern_repeat1] = STATE(1044),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(111),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(109),
    [anon_sym_set] = ACTIONS(109),
  },
  [4] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1307),
    [sym_object_assignment_pattern] = STATE(1052),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1307),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1307),
    [sym_spread_element] = STATE(1016),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(564),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [sym_rest_pattern] = STATE(1052),
    [sym_method_definition] = STATE(1016),
    [sym_pair] = STATE(1016),
    [sym_pair_pattern] = STATE(1052),
    [sym__property_name] = STATE(1049),
    [sym_computed_property_name] = STATE(1049),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(688),
    [aux_sym_object_repeat1] = STATE(1018),
    [aux_sym_object_pattern_repeat1] = STATE(1044),
    [sym_identifier] = ACTIONS(113),
    [anon_sym_export] = ACTIONS(115),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(119),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(121),
    [anon_sym_get] = ACTIONS(123),
    [anon_sym_set] = ACTIONS(123),
  },
  [5] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1307),
    [sym_object_assignment_pattern] = STATE(1052),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1307),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1307),
    [sym_spread_element] = STATE(1016),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(564),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [sym_rest_pattern] = STATE(1052),
    [sym_method_definition] = STATE(1016),
    [sym_pair] = STATE(1016),
    [sym_pair_pattern] = STATE(1052),
    [sym__property_name] = STATE(1049),
    [sym_computed_property_name] = STATE(1049),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(688),
    [aux_sym_object_repeat1] = STATE(1018),
    [aux_sym_object_pattern_repeat1] = STATE(1044),
    [sym_identifier] = ACTIONS(125),
    [anon_sym_export] = ACTIONS(127),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(129),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(131),
    [anon_sym_get] = ACTIONS(133),
    [anon_sym_set] = ACTIONS(133),
  },
  [6] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1307),
    [sym_object_assignment_pattern] = STATE(1052),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1307),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1307),
    [sym_spread_element] = STATE(1050),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(564),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [sym_rest_pattern] = STATE(1052),
    [sym_method_definition] = STATE(1050),
    [sym_pair] = STATE(1050),
    [sym_pair_pattern] = STATE(1052),
    [sym__property_name] = STATE(1049),
    [sym_computed_property_name] = STATE(1049),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(688),
    [aux_sym_object_repeat1] = STATE(1048),
    [aux_sym_object_pattern_repeat1] = STATE(1044),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(135),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(109),
    [anon_sym_set] = ACTIONS(109),
  },
  [7] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(139),
    [anon_sym_export] = ACTIONS(142),
    [anon_sym_default] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(137),
    [anon_sym_import] = ACTIONS(150),
    [anon_sym_var] = ACTIONS(153),
    [anon_sym_let] = ACTIONS(156),
    [anon_sym_const] = ACTIONS(156),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(162),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(168),
    [anon_sym_await] = ACTIONS(171),
    [anon_sym_while] = ACTIONS(174),
    [anon_sym_do] = ACTIONS(177),
    [anon_sym_try] = ACTIONS(180),
    [anon_sym_with] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(186),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(192),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_throw] = ACTIONS(198),
    [anon_sym_SEMI] = ACTIONS(201),
    [anon_sym_case] = ACTIONS(145),
    [anon_sym_yield] = ACTIONS(204),
    [anon_sym_LBRACK] = ACTIONS(207),
    [anon_sym_LT] = ACTIONS(210),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_class] = ACTIONS(216),
    [anon_sym_async] = ACTIONS(219),
    [anon_sym_function] = ACTIONS(222),
    [anon_sym_new] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(228),
    [anon_sym_DASH] = ACTIONS(228),
    [anon_sym_BANG] = ACTIONS(231),
    [anon_sym_TILDE] = ACTIONS(231),
    [anon_sym_typeof] = ACTIONS(234),
    [anon_sym_void] = ACTIONS(234),
    [anon_sym_delete] = ACTIONS(234),
    [anon_sym_PLUS_PLUS] = ACTIONS(237),
    [anon_sym_DASH_DASH] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(246),
    [sym_number] = ACTIONS(249),
    [sym_this] = ACTIONS(252),
    [sym_super] = ACTIONS(252),
    [sym_true] = ACTIONS(252),
    [sym_false] = ACTIONS(252),
    [sym_null] = ACTIONS(252),
    [sym_undefined] = ACTIONS(252),
    [anon_sym_AT] = ACTIONS(255),
    [anon_sym_static] = ACTIONS(258),
    [anon_sym_get] = ACTIONS(258),
    [anon_sym_set] = ACTIONS(258),
  },
  [8] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(261),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [9] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(267),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [10] = {
    [sym_export_statement] = STATE(8),
    [sym_declaration] = STATE(8),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(8),
    [sym_expression_statement] = STATE(8),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(8),
    [sym_if_statement] = STATE(8),
    [sym_switch_statement] = STATE(8),
    [sym_for_statement] = STATE(8),
    [sym_for_in_statement] = STATE(8),
    [sym_while_statement] = STATE(8),
    [sym_do_statement] = STATE(8),
    [sym_try_statement] = STATE(8),
    [sym_with_statement] = STATE(8),
    [sym_break_statement] = STATE(8),
    [sym_continue_statement] = STATE(8),
    [sym_debugger_statement] = STATE(8),
    [sym_return_statement] = STATE(8),
    [sym_throw_statement] = STATE(8),
    [sym_empty_statement] = STATE(8),
    [sym_labeled_statement] = STATE(8),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(8),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(269),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(271),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [11] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(273),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(275),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(273),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [12] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [13] = {
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(279),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [14] = {
    [sym_export_statement] = STATE(16),
    [sym_declaration] = STATE(16),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_try_statement] = STATE(16),
    [sym_with_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_debugger_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_throw_statement] = STATE(16),
    [sym_empty_statement] = STATE(16),
    [sym_labeled_statement] = STATE(16),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [ts_builtin_sym_end] = ACTIONS(281),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [15] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(283),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [16] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [ts_builtin_sym_end] = ACTIONS(285),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [17] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [ts_builtin_sym_end] = ACTIONS(281),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [18] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(287),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [19] = {
    [sym_export_statement] = STATE(24),
    [sym_declaration] = STATE(24),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_try_statement] = STATE(24),
    [sym_with_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_debugger_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_throw_statement] = STATE(24),
    [sym_empty_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [20] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(291),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [21] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(293),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [22] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [23] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(295),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [24] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(297),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [25] = {
    [sym_export_statement] = STATE(247),
    [sym_declaration] = STATE(246),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(274),
    [sym_expression_statement] = STATE(281),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(255),
    [sym_if_statement] = STATE(306),
    [sym_switch_statement] = STATE(261),
    [sym_for_statement] = STATE(252),
    [sym_for_in_statement] = STATE(297),
    [sym_while_statement] = STATE(296),
    [sym_do_statement] = STATE(254),
    [sym_try_statement] = STATE(256),
    [sym_with_statement] = STATE(258),
    [sym_break_statement] = STATE(260),
    [sym_continue_statement] = STATE(262),
    [sym_debugger_statement] = STATE(263),
    [sym_return_statement] = STATE(264),
    [sym_throw_statement] = STATE(266),
    [sym_empty_statement] = STATE(267),
    [sym_labeled_statement] = STATE(268),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [26] = {
    [sym_export_statement] = STATE(247),
    [sym_declaration] = STATE(246),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(274),
    [sym_expression_statement] = STATE(281),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(255),
    [sym_if_statement] = STATE(306),
    [sym_switch_statement] = STATE(261),
    [sym_for_statement] = STATE(252),
    [sym_for_in_statement] = STATE(297),
    [sym_while_statement] = STATE(296),
    [sym_do_statement] = STATE(254),
    [sym_try_statement] = STATE(256),
    [sym_with_statement] = STATE(258),
    [sym_break_statement] = STATE(260),
    [sym_continue_statement] = STATE(262),
    [sym_debugger_statement] = STATE(263),
    [sym_return_statement] = STATE(264),
    [sym_throw_statement] = STATE(266),
    [sym_empty_statement] = STATE(267),
    [sym_labeled_statement] = STATE(268),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [27] = {
    [sym_export_statement] = STATE(282),
    [sym_declaration] = STATE(282),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(282),
    [sym_expression_statement] = STATE(282),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(282),
    [sym_if_statement] = STATE(282),
    [sym_switch_statement] = STATE(282),
    [sym_for_statement] = STATE(282),
    [sym_for_in_statement] = STATE(282),
    [sym_while_statement] = STATE(282),
    [sym_do_statement] = STATE(282),
    [sym_try_statement] = STATE(282),
    [sym_with_statement] = STATE(282),
    [sym_break_statement] = STATE(282),
    [sym_continue_statement] = STATE(282),
    [sym_debugger_statement] = STATE(282),
    [sym_return_statement] = STATE(282),
    [sym_throw_statement] = STATE(282),
    [sym_empty_statement] = STATE(282),
    [sym_labeled_statement] = STATE(282),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [28] = {
    [sym_export_statement] = STATE(265),
    [sym_declaration] = STATE(265),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(265),
    [sym_expression_statement] = STATE(265),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(265),
    [sym_if_statement] = STATE(265),
    [sym_switch_statement] = STATE(265),
    [sym_for_statement] = STATE(265),
    [sym_for_in_statement] = STATE(265),
    [sym_while_statement] = STATE(265),
    [sym_do_statement] = STATE(265),
    [sym_try_statement] = STATE(265),
    [sym_with_statement] = STATE(265),
    [sym_break_statement] = STATE(265),
    [sym_continue_statement] = STATE(265),
    [sym_debugger_statement] = STATE(265),
    [sym_return_statement] = STATE(265),
    [sym_throw_statement] = STATE(265),
    [sym_empty_statement] = STATE(265),
    [sym_labeled_statement] = STATE(265),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [29] = {
    [sym_export_statement] = STATE(282),
    [sym_declaration] = STATE(282),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(282),
    [sym_expression_statement] = STATE(282),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(282),
    [sym_if_statement] = STATE(282),
    [sym_switch_statement] = STATE(282),
    [sym_for_statement] = STATE(282),
    [sym_for_in_statement] = STATE(282),
    [sym_while_statement] = STATE(282),
    [sym_do_statement] = STATE(282),
    [sym_try_statement] = STATE(282),
    [sym_with_statement] = STATE(282),
    [sym_break_statement] = STATE(282),
    [sym_continue_statement] = STATE(282),
    [sym_debugger_statement] = STATE(282),
    [sym_return_statement] = STATE(282),
    [sym_throw_statement] = STATE(282),
    [sym_empty_statement] = STATE(282),
    [sym_labeled_statement] = STATE(282),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [30] = {
    [sym_export_statement] = STATE(279),
    [sym_declaration] = STATE(279),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(279),
    [sym_expression_statement] = STATE(279),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(279),
    [sym_if_statement] = STATE(279),
    [sym_switch_statement] = STATE(279),
    [sym_for_statement] = STATE(279),
    [sym_for_in_statement] = STATE(279),
    [sym_while_statement] = STATE(279),
    [sym_do_statement] = STATE(279),
    [sym_try_statement] = STATE(279),
    [sym_with_statement] = STATE(279),
    [sym_break_statement] = STATE(279),
    [sym_continue_statement] = STATE(279),
    [sym_debugger_statement] = STATE(279),
    [sym_return_statement] = STATE(279),
    [sym_throw_statement] = STATE(279),
    [sym_empty_statement] = STATE(279),
    [sym_labeled_statement] = STATE(279),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [31] = {
    [sym_export_statement] = STATE(279),
    [sym_declaration] = STATE(279),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(279),
    [sym_expression_statement] = STATE(279),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(279),
    [sym_if_statement] = STATE(279),
    [sym_switch_statement] = STATE(279),
    [sym_for_statement] = STATE(279),
    [sym_for_in_statement] = STATE(279),
    [sym_while_statement] = STATE(279),
    [sym_do_statement] = STATE(279),
    [sym_try_statement] = STATE(279),
    [sym_with_statement] = STATE(279),
    [sym_break_statement] = STATE(279),
    [sym_continue_statement] = STATE(279),
    [sym_debugger_statement] = STATE(279),
    [sym_return_statement] = STATE(279),
    [sym_throw_statement] = STATE(279),
    [sym_empty_statement] = STATE(279),
    [sym_labeled_statement] = STATE(279),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [32] = {
    [sym_export_statement] = STATE(308),
    [sym_declaration] = STATE(308),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(308),
    [sym_expression_statement] = STATE(308),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(308),
    [sym_if_statement] = STATE(308),
    [sym_switch_statement] = STATE(308),
    [sym_for_statement] = STATE(308),
    [sym_for_in_statement] = STATE(308),
    [sym_while_statement] = STATE(308),
    [sym_do_statement] = STATE(308),
    [sym_try_statement] = STATE(308),
    [sym_with_statement] = STATE(308),
    [sym_break_statement] = STATE(308),
    [sym_continue_statement] = STATE(308),
    [sym_debugger_statement] = STATE(308),
    [sym_return_statement] = STATE(308),
    [sym_throw_statement] = STATE(308),
    [sym_empty_statement] = STATE(308),
    [sym_labeled_statement] = STATE(308),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [33] = {
    [sym_export_statement] = STATE(310),
    [sym_declaration] = STATE(311),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(312),
    [sym_expression_statement] = STATE(313),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(314),
    [sym_if_statement] = STATE(315),
    [sym_switch_statement] = STATE(316),
    [sym_for_statement] = STATE(317),
    [sym_for_in_statement] = STATE(318),
    [sym_while_statement] = STATE(319),
    [sym_do_statement] = STATE(320),
    [sym_try_statement] = STATE(321),
    [sym_with_statement] = STATE(322),
    [sym_break_statement] = STATE(323),
    [sym_continue_statement] = STATE(324),
    [sym_debugger_statement] = STATE(325),
    [sym_return_statement] = STATE(326),
    [sym_throw_statement] = STATE(327),
    [sym_empty_statement] = STATE(328),
    [sym_labeled_statement] = STATE(329),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [34] = {
    [sym_export_statement] = STATE(280),
    [sym_declaration] = STATE(280),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(280),
    [sym_expression_statement] = STATE(280),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(280),
    [sym_if_statement] = STATE(280),
    [sym_switch_statement] = STATE(280),
    [sym_for_statement] = STATE(280),
    [sym_for_in_statement] = STATE(280),
    [sym_while_statement] = STATE(280),
    [sym_do_statement] = STATE(280),
    [sym_try_statement] = STATE(280),
    [sym_with_statement] = STATE(280),
    [sym_break_statement] = STATE(280),
    [sym_continue_statement] = STATE(280),
    [sym_debugger_statement] = STATE(280),
    [sym_return_statement] = STATE(280),
    [sym_throw_statement] = STATE(280),
    [sym_empty_statement] = STATE(280),
    [sym_labeled_statement] = STATE(280),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [35] = {
    [sym_export_statement] = STATE(304),
    [sym_declaration] = STATE(304),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(304),
    [sym_expression_statement] = STATE(304),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(304),
    [sym_if_statement] = STATE(304),
    [sym_switch_statement] = STATE(304),
    [sym_for_statement] = STATE(304),
    [sym_for_in_statement] = STATE(304),
    [sym_while_statement] = STATE(304),
    [sym_do_statement] = STATE(304),
    [sym_try_statement] = STATE(304),
    [sym_with_statement] = STATE(304),
    [sym_break_statement] = STATE(304),
    [sym_continue_statement] = STATE(304),
    [sym_debugger_statement] = STATE(304),
    [sym_return_statement] = STATE(304),
    [sym_throw_statement] = STATE(304),
    [sym_empty_statement] = STATE(304),
    [sym_labeled_statement] = STATE(304),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [36] = {
    [sym_export_statement] = STATE(304),
    [sym_declaration] = STATE(304),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(304),
    [sym_expression_statement] = STATE(304),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(304),
    [sym_if_statement] = STATE(304),
    [sym_switch_statement] = STATE(304),
    [sym_for_statement] = STATE(304),
    [sym_for_in_statement] = STATE(304),
    [sym_while_statement] = STATE(304),
    [sym_do_statement] = STATE(304),
    [sym_try_statement] = STATE(304),
    [sym_with_statement] = STATE(304),
    [sym_break_statement] = STATE(304),
    [sym_continue_statement] = STATE(304),
    [sym_debugger_statement] = STATE(304),
    [sym_return_statement] = STATE(304),
    [sym_throw_statement] = STATE(304),
    [sym_empty_statement] = STATE(304),
    [sym_labeled_statement] = STATE(304),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [37] = {
    [sym_export_statement] = STATE(265),
    [sym_declaration] = STATE(265),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(265),
    [sym_expression_statement] = STATE(265),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(265),
    [sym_if_statement] = STATE(265),
    [sym_switch_statement] = STATE(265),
    [sym_for_statement] = STATE(265),
    [sym_for_in_statement] = STATE(265),
    [sym_while_statement] = STATE(265),
    [sym_do_statement] = STATE(265),
    [sym_try_statement] = STATE(265),
    [sym_with_statement] = STATE(265),
    [sym_break_statement] = STATE(265),
    [sym_continue_statement] = STATE(265),
    [sym_debugger_statement] = STATE(265),
    [sym_return_statement] = STATE(265),
    [sym_throw_statement] = STATE(265),
    [sym_empty_statement] = STATE(265),
    [sym_labeled_statement] = STATE(265),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [38] = {
    [sym_export_statement] = STATE(232),
    [sym_declaration] = STATE(232),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(232),
    [sym_expression_statement] = STATE(232),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(232),
    [sym_if_statement] = STATE(232),
    [sym_switch_statement] = STATE(232),
    [sym_for_statement] = STATE(232),
    [sym_for_in_statement] = STATE(232),
    [sym_while_statement] = STATE(232),
    [sym_do_statement] = STATE(232),
    [sym_try_statement] = STATE(232),
    [sym_with_statement] = STATE(232),
    [sym_break_statement] = STATE(232),
    [sym_continue_statement] = STATE(232),
    [sym_debugger_statement] = STATE(232),
    [sym_return_statement] = STATE(232),
    [sym_throw_statement] = STATE(232),
    [sym_empty_statement] = STATE(232),
    [sym_labeled_statement] = STATE(232),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [39] = {
    [sym_export_statement] = STATE(310),
    [sym_declaration] = STATE(311),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(312),
    [sym_expression_statement] = STATE(313),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(314),
    [sym_if_statement] = STATE(315),
    [sym_switch_statement] = STATE(316),
    [sym_for_statement] = STATE(317),
    [sym_for_in_statement] = STATE(318),
    [sym_while_statement] = STATE(319),
    [sym_do_statement] = STATE(320),
    [sym_try_statement] = STATE(321),
    [sym_with_statement] = STATE(322),
    [sym_break_statement] = STATE(323),
    [sym_continue_statement] = STATE(324),
    [sym_debugger_statement] = STATE(325),
    [sym_return_statement] = STATE(326),
    [sym_throw_statement] = STATE(327),
    [sym_empty_statement] = STATE(328),
    [sym_labeled_statement] = STATE(329),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [40] = {
    [sym_export_statement] = STATE(1262),
    [sym_declaration] = STATE(1262),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(1262),
    [sym_expression_statement] = STATE(1262),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(1262),
    [sym_if_statement] = STATE(1262),
    [sym_switch_statement] = STATE(1262),
    [sym_for_statement] = STATE(1262),
    [sym_for_in_statement] = STATE(1262),
    [sym_while_statement] = STATE(1262),
    [sym_do_statement] = STATE(1262),
    [sym_try_statement] = STATE(1262),
    [sym_with_statement] = STATE(1262),
    [sym_break_statement] = STATE(1262),
    [sym_continue_statement] = STATE(1262),
    [sym_debugger_statement] = STATE(1262),
    [sym_return_statement] = STATE(1262),
    [sym_throw_statement] = STATE(1262),
    [sym_empty_statement] = STATE(1262),
    [sym_labeled_statement] = STATE(1262),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [41] = {
    [sym_export_statement] = STATE(1031),
    [sym_declaration] = STATE(1031),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(1031),
    [sym_expression_statement] = STATE(1031),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(1031),
    [sym_if_statement] = STATE(1031),
    [sym_switch_statement] = STATE(1031),
    [sym_for_statement] = STATE(1031),
    [sym_for_in_statement] = STATE(1031),
    [sym_while_statement] = STATE(1031),
    [sym_do_statement] = STATE(1031),
    [sym_try_statement] = STATE(1031),
    [sym_with_statement] = STATE(1031),
    [sym_break_statement] = STATE(1031),
    [sym_continue_statement] = STATE(1031),
    [sym_debugger_statement] = STATE(1031),
    [sym_return_statement] = STATE(1031),
    [sym_throw_statement] = STATE(1031),
    [sym_empty_statement] = STATE(1031),
    [sym_labeled_statement] = STATE(1031),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(882),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [42] = {
    [sym_export_statement] = STATE(308),
    [sym_declaration] = STATE(308),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(308),
    [sym_expression_statement] = STATE(308),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(308),
    [sym_if_statement] = STATE(308),
    [sym_switch_statement] = STATE(308),
    [sym_for_statement] = STATE(308),
    [sym_for_in_statement] = STATE(308),
    [sym_while_statement] = STATE(308),
    [sym_do_statement] = STATE(308),
    [sym_try_statement] = STATE(308),
    [sym_with_statement] = STATE(308),
    [sym_break_statement] = STATE(308),
    [sym_continue_statement] = STATE(308),
    [sym_debugger_statement] = STATE(308),
    [sym_return_statement] = STATE(308),
    [sym_throw_statement] = STATE(308),
    [sym_empty_statement] = STATE(308),
    [sym_labeled_statement] = STATE(308),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [43] = {
    [sym_export_statement] = STATE(280),
    [sym_declaration] = STATE(280),
    [sym_import] = STATE(539),
    [sym_import_statement] = STATE(280),
    [sym_expression_statement] = STATE(280),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_statement_block] = STATE(280),
    [sym_if_statement] = STATE(280),
    [sym_switch_statement] = STATE(280),
    [sym_for_statement] = STATE(280),
    [sym_for_in_statement] = STATE(280),
    [sym_while_statement] = STATE(280),
    [sym_do_statement] = STATE(280),
    [sym_try_statement] = STATE(280),
    [sym_with_statement] = STATE(280),
    [sym_break_statement] = STATE(280),
    [sym_continue_statement] = STATE(280),
    [sym_debugger_statement] = STATE(280),
    [sym_return_statement] = STATE(280),
    [sym_throw_statement] = STATE(280),
    [sym_empty_statement] = STATE(280),
    [sym_labeled_statement] = STATE(280),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_class_declaration] = STATE(275),
    [sym_function] = STATE(539),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function] = STATE(539),
    [sym_generator_function_declaration] = STATE(275),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [44] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(404),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_RBRACE] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_COLON] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_RBRACK] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(343),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_QMARK] = ACTIONS(337),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(355),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [45] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(475),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_STAR] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_RBRACE] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(337),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
    [sym__automatic_semicolon] = ACTIONS(329),
  },
  [46] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(574),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_COLON] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(343),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_QMARK] = ACTIONS(337),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(409),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(417),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_STAR] = ACTIONS(421),
    [anon_sym_default] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_var] = ACTIONS(419),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_const] = ACTIONS(419),
    [anon_sym_else] = ACTIONS(419),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(419),
    [anon_sym_in] = ACTIONS(421),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_do] = ACTIONS(419),
    [anon_sym_try] = ACTIONS(419),
    [anon_sym_with] = ACTIONS(419),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(419),
    [anon_sym_debugger] = ACTIONS(419),
    [anon_sym_return] = ACTIONS(419),
    [anon_sym_throw] = ACTIONS(419),
    [anon_sym_SEMI] = ACTIONS(417),
    [anon_sym_case] = ACTIONS(419),
    [anon_sym_yield] = ACTIONS(419),
    [anon_sym_EQ] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(417),
    [anon_sym_LT] = ACTIONS(419),
    [anon_sym_GT] = ACTIONS(421),
    [anon_sym_SLASH] = ACTIONS(419),
    [anon_sym_DOT] = ACTIONS(421),
    [anon_sym_class] = ACTIONS(419),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(419),
    [anon_sym_QMARK_DOT] = ACTIONS(423),
    [anon_sym_new] = ACTIONS(419),
    [anon_sym_QMARK] = ACTIONS(421),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(421),
    [anon_sym_GT_GT_GT] = ACTIONS(423),
    [anon_sym_LT_LT] = ACTIONS(423),
    [anon_sym_AMP] = ACTIONS(421),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(421),
    [anon_sym_PLUS] = ACTIONS(419),
    [anon_sym_DASH] = ACTIONS(419),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(421),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(421),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_QMARK_QMARK] = ACTIONS(423),
    [anon_sym_instanceof] = ACTIONS(421),
    [anon_sym_BANG] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(419),
    [anon_sym_void] = ACTIONS(419),
    [anon_sym_delete] = ACTIONS(419),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(417),
    [anon_sym_SQUOTE] = ACTIONS(417),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(417),
    [sym_number] = ACTIONS(417),
    [sym_this] = ACTIONS(419),
    [sym_super] = ACTIONS(419),
    [sym_true] = ACTIONS(419),
    [sym_false] = ACTIONS(419),
    [sym_null] = ACTIONS(419),
    [sym_undefined] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym__automatic_semicolon] = ACTIONS(427),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(429),
    [sym_identifier] = ACTIONS(431),
    [anon_sym_export] = ACTIONS(431),
    [anon_sym_STAR] = ACTIONS(433),
    [anon_sym_default] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(429),
    [anon_sym_import] = ACTIONS(431),
    [anon_sym_var] = ACTIONS(431),
    [anon_sym_let] = ACTIONS(431),
    [anon_sym_const] = ACTIONS(431),
    [anon_sym_else] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_switch] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(431),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_await] = ACTIONS(431),
    [anon_sym_in] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(431),
    [anon_sym_do] = ACTIONS(431),
    [anon_sym_try] = ACTIONS(431),
    [anon_sym_with] = ACTIONS(431),
    [anon_sym_break] = ACTIONS(431),
    [anon_sym_continue] = ACTIONS(431),
    [anon_sym_debugger] = ACTIONS(431),
    [anon_sym_return] = ACTIONS(431),
    [anon_sym_throw] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(429),
    [anon_sym_case] = ACTIONS(431),
    [anon_sym_yield] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(431),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(431),
    [anon_sym_DOT] = ACTIONS(433),
    [anon_sym_class] = ACTIONS(431),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_QMARK_DOT] = ACTIONS(435),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_QMARK] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(435),
    [anon_sym_PIPE_PIPE] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_GT_GT_GT] = ACTIONS(435),
    [anon_sym_LT_LT] = ACTIONS(435),
    [anon_sym_AMP] = ACTIONS(433),
    [anon_sym_CARET] = ACTIONS(435),
    [anon_sym_PIPE] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_PERCENT] = ACTIONS(435),
    [anon_sym_STAR_STAR] = ACTIONS(435),
    [anon_sym_LT_EQ] = ACTIONS(435),
    [anon_sym_EQ_EQ] = ACTIONS(433),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(435),
    [anon_sym_BANG_EQ] = ACTIONS(433),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(435),
    [anon_sym_GT_EQ] = ACTIONS(435),
    [anon_sym_QMARK_QMARK] = ACTIONS(435),
    [anon_sym_instanceof] = ACTIONS(433),
    [anon_sym_BANG] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(429),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(429),
    [anon_sym_DASH_DASH] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(429),
    [anon_sym_SQUOTE] = ACTIONS(429),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(429),
    [sym_number] = ACTIONS(429),
    [sym_this] = ACTIONS(431),
    [sym_super] = ACTIONS(431),
    [sym_true] = ACTIONS(431),
    [sym_false] = ACTIONS(431),
    [sym_null] = ACTIONS(431),
    [sym_undefined] = ACTIONS(431),
    [anon_sym_AT] = ACTIONS(429),
    [anon_sym_static] = ACTIONS(431),
    [anon_sym_get] = ACTIONS(431),
    [anon_sym_set] = ACTIONS(431),
    [sym__automatic_semicolon] = ACTIONS(437),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(439),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_export] = ACTIONS(441),
    [anon_sym_STAR] = ACTIONS(443),
    [anon_sym_default] = ACTIONS(441),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(445),
    [anon_sym_RBRACE] = ACTIONS(439),
    [anon_sym_import] = ACTIONS(441),
    [anon_sym_var] = ACTIONS(441),
    [anon_sym_let] = ACTIONS(441),
    [anon_sym_const] = ACTIONS(441),
    [anon_sym_else] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_switch] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_await] = ACTIONS(441),
    [anon_sym_in] = ACTIONS(443),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_do] = ACTIONS(441),
    [anon_sym_try] = ACTIONS(441),
    [anon_sym_with] = ACTIONS(441),
    [anon_sym_break] = ACTIONS(441),
    [anon_sym_continue] = ACTIONS(441),
    [anon_sym_debugger] = ACTIONS(441),
    [anon_sym_return] = ACTIONS(441),
    [anon_sym_throw] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_case] = ACTIONS(441),
    [anon_sym_yield] = ACTIONS(441),
    [anon_sym_LBRACK] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(443),
    [anon_sym_SLASH] = ACTIONS(441),
    [anon_sym_DOT] = ACTIONS(443),
    [anon_sym_class] = ACTIONS(441),
    [anon_sym_async] = ACTIONS(441),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_QMARK_DOT] = ACTIONS(445),
    [anon_sym_new] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(443),
    [anon_sym_AMP_AMP] = ACTIONS(445),
    [anon_sym_PIPE_PIPE] = ACTIONS(445),
    [anon_sym_GT_GT] = ACTIONS(443),
    [anon_sym_GT_GT_GT] = ACTIONS(445),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_AMP] = ACTIONS(443),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(443),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_PERCENT] = ACTIONS(445),
    [anon_sym_STAR_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ] = ACTIONS(443),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ] = ACTIONS(443),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(445),
    [anon_sym_GT_EQ] = ACTIONS(445),
    [anon_sym_QMARK_QMARK] = ACTIONS(445),
    [anon_sym_instanceof] = ACTIONS(443),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_TILDE] = ACTIONS(439),
    [anon_sym_typeof] = ACTIONS(441),
    [anon_sym_void] = ACTIONS(441),
    [anon_sym_delete] = ACTIONS(441),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(439),
    [anon_sym_SQUOTE] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(439),
    [sym_number] = ACTIONS(439),
    [sym_this] = ACTIONS(441),
    [sym_super] = ACTIONS(441),
    [sym_true] = ACTIONS(441),
    [sym_false] = ACTIONS(441),
    [sym_null] = ACTIONS(441),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(439),
    [anon_sym_static] = ACTIONS(441),
    [anon_sym_get] = ACTIONS(441),
    [anon_sym_set] = ACTIONS(441),
    [sym__automatic_semicolon] = ACTIONS(447),
  },
  [50] = {
    [ts_builtin_sym_end] = ACTIONS(449),
    [sym_identifier] = ACTIONS(451),
    [anon_sym_export] = ACTIONS(451),
    [anon_sym_STAR] = ACTIONS(451),
    [anon_sym_default] = ACTIONS(451),
    [anon_sym_LBRACE] = ACTIONS(449),
    [anon_sym_COMMA] = ACTIONS(449),
    [anon_sym_RBRACE] = ACTIONS(449),
    [anon_sym_import] = ACTIONS(451),
    [anon_sym_var] = ACTIONS(451),
    [anon_sym_let] = ACTIONS(451),
    [anon_sym_const] = ACTIONS(451),
    [anon_sym_else] = ACTIONS(451),
    [anon_sym_if] = ACTIONS(451),
    [anon_sym_switch] = ACTIONS(451),
    [anon_sym_for] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(449),
    [anon_sym_await] = ACTIONS(451),
    [anon_sym_in] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(451),
    [anon_sym_do] = ACTIONS(451),
    [anon_sym_try] = ACTIONS(451),
    [anon_sym_with] = ACTIONS(451),
    [anon_sym_break] = ACTIONS(451),
    [anon_sym_continue] = ACTIONS(451),
    [anon_sym_debugger] = ACTIONS(451),
    [anon_sym_return] = ACTIONS(451),
    [anon_sym_throw] = ACTIONS(451),
    [anon_sym_SEMI] = ACTIONS(449),
    [anon_sym_case] = ACTIONS(451),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(449),
    [anon_sym_LT] = ACTIONS(451),
    [anon_sym_GT] = ACTIONS(451),
    [anon_sym_SLASH] = ACTIONS(451),
    [anon_sym_DOT] = ACTIONS(451),
    [anon_sym_class] = ACTIONS(451),
    [anon_sym_async] = ACTIONS(451),
    [anon_sym_function] = ACTIONS(451),
    [anon_sym_QMARK_DOT] = ACTIONS(449),
    [anon_sym_new] = ACTIONS(451),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_AMP_AMP] = ACTIONS(449),
    [anon_sym_PIPE_PIPE] = ACTIONS(449),
    [anon_sym_GT_GT] = ACTIONS(451),
    [anon_sym_GT_GT_GT] = ACTIONS(449),
    [anon_sym_LT_LT] = ACTIONS(449),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_CARET] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(451),
    [anon_sym_DASH] = ACTIONS(451),
    [anon_sym_PERCENT] = ACTIONS(449),
    [anon_sym_STAR_STAR] = ACTIONS(449),
    [anon_sym_LT_EQ] = ACTIONS(449),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(449),
    [anon_sym_BANG_EQ] = ACTIONS(451),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(449),
    [anon_sym_GT_EQ] = ACTIONS(449),
    [anon_sym_QMARK_QMARK] = ACTIONS(449),
    [anon_sym_instanceof] = ACTIONS(451),
    [anon_sym_BANG] = ACTIONS(451),
    [anon_sym_TILDE] = ACTIONS(449),
    [anon_sym_typeof] = ACTIONS(451),
    [anon_sym_void] = ACTIONS(451),
    [anon_sym_delete] = ACTIONS(451),
    [anon_sym_PLUS_PLUS] = ACTIONS(449),
    [anon_sym_DASH_DASH] = ACTIONS(449),
    [anon_sym_DQUOTE] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(449),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(449),
    [sym_number] = ACTIONS(449),
    [sym_this] = ACTIONS(451),
    [sym_super] = ACTIONS(451),
    [sym_true] = ACTIONS(451),
    [sym_false] = ACTIONS(451),
    [sym_null] = ACTIONS(451),
    [sym_undefined] = ACTIONS(451),
    [anon_sym_AT] = ACTIONS(449),
    [anon_sym_static] = ACTIONS(451),
    [anon_sym_get] = ACTIONS(451),
    [anon_sym_set] = ACTIONS(451),
    [sym__automatic_semicolon] = ACTIONS(449),
  },
  [51] = {
    [ts_builtin_sym_end] = ACTIONS(417),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_STAR] = ACTIONS(419),
    [anon_sym_default] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_COMMA] = ACTIONS(417),
    [anon_sym_RBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_var] = ACTIONS(419),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_const] = ACTIONS(419),
    [anon_sym_else] = ACTIONS(419),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(419),
    [anon_sym_in] = ACTIONS(419),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_do] = ACTIONS(419),
    [anon_sym_try] = ACTIONS(419),
    [anon_sym_with] = ACTIONS(419),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(419),
    [anon_sym_debugger] = ACTIONS(419),
    [anon_sym_return] = ACTIONS(419),
    [anon_sym_throw] = ACTIONS(419),
    [anon_sym_SEMI] = ACTIONS(417),
    [anon_sym_case] = ACTIONS(419),
    [anon_sym_yield] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(417),
    [anon_sym_LT] = ACTIONS(419),
    [anon_sym_GT] = ACTIONS(419),
    [anon_sym_SLASH] = ACTIONS(419),
    [anon_sym_DOT] = ACTIONS(419),
    [anon_sym_class] = ACTIONS(419),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(419),
    [anon_sym_QMARK_DOT] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(419),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_AMP_AMP] = ACTIONS(417),
    [anon_sym_PIPE_PIPE] = ACTIONS(417),
    [anon_sym_GT_GT] = ACTIONS(419),
    [anon_sym_GT_GT_GT] = ACTIONS(417),
    [anon_sym_LT_LT] = ACTIONS(417),
    [anon_sym_AMP] = ACTIONS(419),
    [anon_sym_CARET] = ACTIONS(417),
    [anon_sym_PIPE] = ACTIONS(419),
    [anon_sym_PLUS] = ACTIONS(419),
    [anon_sym_DASH] = ACTIONS(419),
    [anon_sym_PERCENT] = ACTIONS(417),
    [anon_sym_STAR_STAR] = ACTIONS(417),
    [anon_sym_LT_EQ] = ACTIONS(417),
    [anon_sym_EQ_EQ] = ACTIONS(419),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(417),
    [anon_sym_BANG_EQ] = ACTIONS(419),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(417),
    [anon_sym_GT_EQ] = ACTIONS(417),
    [anon_sym_QMARK_QMARK] = ACTIONS(417),
    [anon_sym_instanceof] = ACTIONS(419),
    [anon_sym_BANG] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(419),
    [anon_sym_void] = ACTIONS(419),
    [anon_sym_delete] = ACTIONS(419),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(417),
    [anon_sym_SQUOTE] = ACTIONS(417),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(417),
    [sym_number] = ACTIONS(417),
    [sym_this] = ACTIONS(419),
    [sym_super] = ACTIONS(419),
    [sym_true] = ACTIONS(419),
    [sym_false] = ACTIONS(419),
    [sym_null] = ACTIONS(419),
    [sym_undefined] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym__automatic_semicolon] = ACTIONS(453),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(455),
    [sym_identifier] = ACTIONS(457),
    [anon_sym_export] = ACTIONS(457),
    [anon_sym_STAR] = ACTIONS(459),
    [anon_sym_default] = ACTIONS(457),
    [anon_sym_LBRACE] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(461),
    [anon_sym_RBRACE] = ACTIONS(455),
    [anon_sym_import] = ACTIONS(457),
    [anon_sym_var] = ACTIONS(457),
    [anon_sym_let] = ACTIONS(457),
    [anon_sym_const] = ACTIONS(457),
    [anon_sym_else] = ACTIONS(457),
    [anon_sym_if] = ACTIONS(457),
    [anon_sym_switch] = ACTIONS(457),
    [anon_sym_for] = ACTIONS(457),
    [anon_sym_LPAREN] = ACTIONS(455),
    [anon_sym_await] = ACTIONS(457),
    [anon_sym_in] = ACTIONS(459),
    [anon_sym_while] = ACTIONS(457),
    [anon_sym_do] = ACTIONS(457),
    [anon_sym_try] = ACTIONS(457),
    [anon_sym_with] = ACTIONS(457),
    [anon_sym_break] = ACTIONS(457),
    [anon_sym_continue] = ACTIONS(457),
    [anon_sym_debugger] = ACTIONS(457),
    [anon_sym_return] = ACTIONS(457),
    [anon_sym_throw] = ACTIONS(457),
    [anon_sym_SEMI] = ACTIONS(455),
    [anon_sym_case] = ACTIONS(457),
    [anon_sym_yield] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(457),
    [anon_sym_GT] = ACTIONS(459),
    [anon_sym_SLASH] = ACTIONS(457),
    [anon_sym_DOT] = ACTIONS(459),
    [anon_sym_class] = ACTIONS(457),
    [anon_sym_async] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(457),
    [anon_sym_QMARK_DOT] = ACTIONS(461),
    [anon_sym_new] = ACTIONS(457),
    [anon_sym_QMARK] = ACTIONS(459),
    [anon_sym_AMP_AMP] = ACTIONS(461),
    [anon_sym_PIPE_PIPE] = ACTIONS(461),
    [anon_sym_GT_GT] = ACTIONS(459),
    [anon_sym_GT_GT_GT] = ACTIONS(461),
    [anon_sym_LT_LT] = ACTIONS(461),
    [anon_sym_AMP] = ACTIONS(459),
    [anon_sym_CARET] = ACTIONS(461),
    [anon_sym_PIPE] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_PERCENT] = ACTIONS(461),
    [anon_sym_STAR_STAR] = ACTIONS(461),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(459),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(461),
    [anon_sym_BANG_EQ] = ACTIONS(459),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(461),
    [anon_sym_GT_EQ] = ACTIONS(461),
    [anon_sym_QMARK_QMARK] = ACTIONS(461),
    [anon_sym_instanceof] = ACTIONS(459),
    [anon_sym_BANG] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(455),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(455),
    [anon_sym_DASH_DASH] = ACTIONS(455),
    [anon_sym_DQUOTE] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(455),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(455),
    [sym_number] = ACTIONS(455),
    [sym_this] = ACTIONS(457),
    [sym_super] = ACTIONS(457),
    [sym_true] = ACTIONS(457),
    [sym_false] = ACTIONS(457),
    [sym_null] = ACTIONS(457),
    [sym_undefined] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(455),
    [anon_sym_static] = ACTIONS(457),
    [anon_sym_get] = ACTIONS(457),
    [anon_sym_set] = ACTIONS(457),
    [sym__automatic_semicolon] = ACTIONS(463),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(465),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_export] = ACTIONS(467),
    [anon_sym_STAR] = ACTIONS(467),
    [anon_sym_default] = ACTIONS(467),
    [anon_sym_LBRACE] = ACTIONS(465),
    [anon_sym_COMMA] = ACTIONS(465),
    [anon_sym_RBRACE] = ACTIONS(465),
    [anon_sym_import] = ACTIONS(467),
    [anon_sym_var] = ACTIONS(467),
    [anon_sym_let] = ACTIONS(467),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_else] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_switch] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(465),
    [anon_sym_await] = ACTIONS(467),
    [anon_sym_in] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_do] = ACTIONS(467),
    [anon_sym_try] = ACTIONS(467),
    [anon_sym_with] = ACTIONS(467),
    [anon_sym_break] = ACTIONS(467),
    [anon_sym_continue] = ACTIONS(467),
    [anon_sym_debugger] = ACTIONS(467),
    [anon_sym_return] = ACTIONS(467),
    [anon_sym_throw] = ACTIONS(467),
    [anon_sym_SEMI] = ACTIONS(465),
    [anon_sym_case] = ACTIONS(467),
    [anon_sym_yield] = ACTIONS(467),
    [anon_sym_LBRACK] = ACTIONS(465),
    [anon_sym_LT] = ACTIONS(467),
    [anon_sym_GT] = ACTIONS(467),
    [anon_sym_SLASH] = ACTIONS(467),
    [anon_sym_DOT] = ACTIONS(467),
    [anon_sym_class] = ACTIONS(467),
    [anon_sym_async] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_QMARK_DOT] = ACTIONS(465),
    [anon_sym_new] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(467),
    [anon_sym_AMP_AMP] = ACTIONS(465),
    [anon_sym_PIPE_PIPE] = ACTIONS(465),
    [anon_sym_GT_GT] = ACTIONS(467),
    [anon_sym_GT_GT_GT] = ACTIONS(465),
    [anon_sym_LT_LT] = ACTIONS(465),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_CARET] = ACTIONS(465),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(467),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_PERCENT] = ACTIONS(465),
    [anon_sym_STAR_STAR] = ACTIONS(465),
    [anon_sym_LT_EQ] = ACTIONS(465),
    [anon_sym_EQ_EQ] = ACTIONS(467),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(465),
    [anon_sym_BANG_EQ] = ACTIONS(467),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(465),
    [anon_sym_GT_EQ] = ACTIONS(465),
    [anon_sym_QMARK_QMARK] = ACTIONS(465),
    [anon_sym_instanceof] = ACTIONS(467),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(467),
    [anon_sym_void] = ACTIONS(467),
    [anon_sym_delete] = ACTIONS(467),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(465),
    [sym_number] = ACTIONS(465),
    [sym_this] = ACTIONS(467),
    [sym_super] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_undefined] = ACTIONS(467),
    [anon_sym_AT] = ACTIONS(465),
    [anon_sym_static] = ACTIONS(467),
    [anon_sym_get] = ACTIONS(467),
    [anon_sym_set] = ACTIONS(467),
    [sym__automatic_semicolon] = ACTIONS(465),
  },
  [54] = {
    [ts_builtin_sym_end] = ACTIONS(469),
    [sym_identifier] = ACTIONS(471),
    [anon_sym_export] = ACTIONS(471),
    [anon_sym_STAR] = ACTIONS(473),
    [anon_sym_default] = ACTIONS(471),
    [anon_sym_LBRACE] = ACTIONS(469),
    [anon_sym_COMMA] = ACTIONS(475),
    [anon_sym_RBRACE] = ACTIONS(469),
    [anon_sym_import] = ACTIONS(471),
    [anon_sym_var] = ACTIONS(471),
    [anon_sym_let] = ACTIONS(471),
    [anon_sym_const] = ACTIONS(471),
    [anon_sym_else] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(471),
    [anon_sym_switch] = ACTIONS(471),
    [anon_sym_for] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(469),
    [anon_sym_await] = ACTIONS(471),
    [anon_sym_in] = ACTIONS(473),
    [anon_sym_while] = ACTIONS(471),
    [anon_sym_do] = ACTIONS(471),
    [anon_sym_try] = ACTIONS(471),
    [anon_sym_with] = ACTIONS(471),
    [anon_sym_break] = ACTIONS(471),
    [anon_sym_continue] = ACTIONS(471),
    [anon_sym_debugger] = ACTIONS(471),
    [anon_sym_return] = ACTIONS(471),
    [anon_sym_throw] = ACTIONS(471),
    [anon_sym_SEMI] = ACTIONS(469),
    [anon_sym_case] = ACTIONS(471),
    [anon_sym_yield] = ACTIONS(471),
    [anon_sym_LBRACK] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(471),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_SLASH] = ACTIONS(471),
    [anon_sym_DOT] = ACTIONS(473),
    [anon_sym_class] = ACTIONS(471),
    [anon_sym_async] = ACTIONS(471),
    [anon_sym_function] = ACTIONS(471),
    [anon_sym_QMARK_DOT] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(471),
    [anon_sym_QMARK] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(475),
    [anon_sym_PIPE_PIPE] = ACTIONS(475),
    [anon_sym_GT_GT] = ACTIONS(473),
    [anon_sym_GT_GT_GT] = ACTIONS(475),
    [anon_sym_LT_LT] = ACTIONS(475),
    [anon_sym_AMP] = ACTIONS(473),
    [anon_sym_CARET] = ACTIONS(475),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_PLUS] = ACTIONS(471),
    [anon_sym_DASH] = ACTIONS(471),
    [anon_sym_PERCENT] = ACTIONS(475),
    [anon_sym_STAR_STAR] = ACTIONS(475),
    [anon_sym_LT_EQ] = ACTIONS(475),
    [anon_sym_EQ_EQ] = ACTIONS(473),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(475),
    [anon_sym_BANG_EQ] = ACTIONS(473),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(475),
    [anon_sym_GT_EQ] = ACTIONS(475),
    [anon_sym_QMARK_QMARK] = ACTIONS(475),
    [anon_sym_instanceof] = ACTIONS(473),
    [anon_sym_BANG] = ACTIONS(471),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_typeof] = ACTIONS(471),
    [anon_sym_void] = ACTIONS(471),
    [anon_sym_delete] = ACTIONS(471),
    [anon_sym_PLUS_PLUS] = ACTIONS(469),
    [anon_sym_DASH_DASH] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(469),
    [sym_number] = ACTIONS(469),
    [sym_this] = ACTIONS(471),
    [sym_super] = ACTIONS(471),
    [sym_true] = ACTIONS(471),
    [sym_false] = ACTIONS(471),
    [sym_null] = ACTIONS(471),
    [sym_undefined] = ACTIONS(471),
    [anon_sym_AT] = ACTIONS(469),
    [anon_sym_static] = ACTIONS(471),
    [anon_sym_get] = ACTIONS(471),
    [anon_sym_set] = ACTIONS(471),
    [sym__automatic_semicolon] = ACTIONS(477),
  },
  [55] = {
    [ts_builtin_sym_end] = ACTIONS(479),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_export] = ACTIONS(481),
    [anon_sym_STAR] = ACTIONS(481),
    [anon_sym_default] = ACTIONS(481),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_COMMA] = ACTIONS(479),
    [anon_sym_RBRACE] = ACTIONS(479),
    [anon_sym_import] = ACTIONS(481),
    [anon_sym_var] = ACTIONS(481),
    [anon_sym_let] = ACTIONS(481),
    [anon_sym_const] = ACTIONS(481),
    [anon_sym_else] = ACTIONS(481),
    [anon_sym_if] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(481),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(479),
    [anon_sym_await] = ACTIONS(481),
    [anon_sym_in] = ACTIONS(481),
    [anon_sym_while] = ACTIONS(481),
    [anon_sym_do] = ACTIONS(481),
    [anon_sym_try] = ACTIONS(481),
    [anon_sym_with] = ACTIONS(481),
    [anon_sym_break] = ACTIONS(481),
    [anon_sym_continue] = ACTIONS(481),
    [anon_sym_debugger] = ACTIONS(481),
    [anon_sym_return] = ACTIONS(481),
    [anon_sym_throw] = ACTIONS(481),
    [anon_sym_SEMI] = ACTIONS(479),
    [anon_sym_case] = ACTIONS(481),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(481),
    [anon_sym_GT] = ACTIONS(481),
    [anon_sym_SLASH] = ACTIONS(481),
    [anon_sym_DOT] = ACTIONS(481),
    [anon_sym_class] = ACTIONS(481),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(481),
    [anon_sym_QMARK_DOT] = ACTIONS(479),
    [anon_sym_new] = ACTIONS(481),
    [anon_sym_QMARK] = ACTIONS(481),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [anon_sym_GT_GT] = ACTIONS(481),
    [anon_sym_GT_GT_GT] = ACTIONS(479),
    [anon_sym_LT_LT] = ACTIONS(479),
    [anon_sym_AMP] = ACTIONS(481),
    [anon_sym_CARET] = ACTIONS(479),
    [anon_sym_PIPE] = ACTIONS(481),
    [anon_sym_PLUS] = ACTIONS(481),
    [anon_sym_DASH] = ACTIONS(481),
    [anon_sym_PERCENT] = ACTIONS(479),
    [anon_sym_STAR_STAR] = ACTIONS(479),
    [anon_sym_LT_EQ] = ACTIONS(479),
    [anon_sym_EQ_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(479),
    [anon_sym_BANG_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(479),
    [anon_sym_GT_EQ] = ACTIONS(479),
    [anon_sym_QMARK_QMARK] = ACTIONS(479),
    [anon_sym_instanceof] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(481),
    [anon_sym_TILDE] = ACTIONS(479),
    [anon_sym_typeof] = ACTIONS(481),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(481),
    [anon_sym_PLUS_PLUS] = ACTIONS(479),
    [anon_sym_DASH_DASH] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(479),
    [anon_sym_SQUOTE] = ACTIONS(479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(479),
    [sym_number] = ACTIONS(479),
    [sym_this] = ACTIONS(481),
    [sym_super] = ACTIONS(481),
    [sym_true] = ACTIONS(481),
    [sym_false] = ACTIONS(481),
    [sym_null] = ACTIONS(481),
    [sym_undefined] = ACTIONS(481),
    [anon_sym_AT] = ACTIONS(479),
    [anon_sym_static] = ACTIONS(481),
    [anon_sym_get] = ACTIONS(481),
    [anon_sym_set] = ACTIONS(481),
    [sym__automatic_semicolon] = ACTIONS(483),
  },
  [56] = {
    [ts_builtin_sym_end] = ACTIONS(485),
    [sym_identifier] = ACTIONS(487),
    [anon_sym_export] = ACTIONS(487),
    [anon_sym_STAR] = ACTIONS(489),
    [anon_sym_default] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_COMMA] = ACTIONS(491),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_import] = ACTIONS(487),
    [anon_sym_var] = ACTIONS(487),
    [anon_sym_let] = ACTIONS(487),
    [anon_sym_const] = ACTIONS(487),
    [anon_sym_else] = ACTIONS(487),
    [anon_sym_if] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_for] = ACTIONS(487),
    [anon_sym_LPAREN] = ACTIONS(485),
    [anon_sym_await] = ACTIONS(487),
    [anon_sym_in] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(487),
    [anon_sym_do] = ACTIONS(487),
    [anon_sym_try] = ACTIONS(487),
    [anon_sym_with] = ACTIONS(487),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_debugger] = ACTIONS(487),
    [anon_sym_return] = ACTIONS(487),
    [anon_sym_throw] = ACTIONS(487),
    [anon_sym_SEMI] = ACTIONS(485),
    [anon_sym_case] = ACTIONS(487),
    [anon_sym_yield] = ACTIONS(487),
    [anon_sym_LBRACK] = ACTIONS(485),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(489),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_DOT] = ACTIONS(489),
    [anon_sym_class] = ACTIONS(487),
    [anon_sym_async] = ACTIONS(487),
    [anon_sym_function] = ACTIONS(487),
    [anon_sym_QMARK_DOT] = ACTIONS(491),
    [anon_sym_new] = ACTIONS(487),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_GT_GT] = ACTIONS(489),
    [anon_sym_GT_GT_GT] = ACTIONS(491),
    [anon_sym_LT_LT] = ACTIONS(491),
    [anon_sym_AMP] = ACTIONS(489),
    [anon_sym_CARET] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(489),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_PERCENT] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(491),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(489),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(491),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_QMARK_QMARK] = ACTIONS(491),
    [anon_sym_instanceof] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(485),
    [anon_sym_typeof] = ACTIONS(487),
    [anon_sym_void] = ACTIONS(487),
    [anon_sym_delete] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_DQUOTE] = ACTIONS(485),
    [anon_sym_SQUOTE] = ACTIONS(485),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(485),
    [sym_number] = ACTIONS(485),
    [sym_this] = ACTIONS(487),
    [sym_super] = ACTIONS(487),
    [sym_true] = ACTIONS(487),
    [sym_false] = ACTIONS(487),
    [sym_null] = ACTIONS(487),
    [sym_undefined] = ACTIONS(487),
    [anon_sym_AT] = ACTIONS(485),
    [anon_sym_static] = ACTIONS(487),
    [anon_sym_get] = ACTIONS(487),
    [anon_sym_set] = ACTIONS(487),
    [sym__automatic_semicolon] = ACTIONS(493),
  },
  [57] = {
    [ts_builtin_sym_end] = ACTIONS(479),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_export] = ACTIONS(481),
    [anon_sym_STAR] = ACTIONS(481),
    [anon_sym_default] = ACTIONS(481),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_COMMA] = ACTIONS(479),
    [anon_sym_RBRACE] = ACTIONS(479),
    [anon_sym_import] = ACTIONS(481),
    [anon_sym_var] = ACTIONS(481),
    [anon_sym_let] = ACTIONS(481),
    [anon_sym_const] = ACTIONS(481),
    [anon_sym_else] = ACTIONS(481),
    [anon_sym_if] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(481),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(479),
    [anon_sym_await] = ACTIONS(481),
    [anon_sym_in] = ACTIONS(481),
    [anon_sym_while] = ACTIONS(481),
    [anon_sym_do] = ACTIONS(481),
    [anon_sym_try] = ACTIONS(481),
    [anon_sym_with] = ACTIONS(481),
    [anon_sym_break] = ACTIONS(481),
    [anon_sym_continue] = ACTIONS(481),
    [anon_sym_debugger] = ACTIONS(481),
    [anon_sym_return] = ACTIONS(481),
    [anon_sym_throw] = ACTIONS(481),
    [anon_sym_SEMI] = ACTIONS(479),
    [anon_sym_case] = ACTIONS(481),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(481),
    [anon_sym_GT] = ACTIONS(481),
    [anon_sym_SLASH] = ACTIONS(481),
    [anon_sym_DOT] = ACTIONS(481),
    [anon_sym_class] = ACTIONS(481),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(481),
    [anon_sym_QMARK_DOT] = ACTIONS(479),
    [anon_sym_new] = ACTIONS(481),
    [anon_sym_QMARK] = ACTIONS(481),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [anon_sym_GT_GT] = ACTIONS(481),
    [anon_sym_GT_GT_GT] = ACTIONS(479),
    [anon_sym_LT_LT] = ACTIONS(479),
    [anon_sym_AMP] = ACTIONS(481),
    [anon_sym_CARET] = ACTIONS(479),
    [anon_sym_PIPE] = ACTIONS(481),
    [anon_sym_PLUS] = ACTIONS(481),
    [anon_sym_DASH] = ACTIONS(481),
    [anon_sym_PERCENT] = ACTIONS(479),
    [anon_sym_STAR_STAR] = ACTIONS(479),
    [anon_sym_LT_EQ] = ACTIONS(479),
    [anon_sym_EQ_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(479),
    [anon_sym_BANG_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(479),
    [anon_sym_GT_EQ] = ACTIONS(479),
    [anon_sym_QMARK_QMARK] = ACTIONS(479),
    [anon_sym_instanceof] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(481),
    [anon_sym_TILDE] = ACTIONS(479),
    [anon_sym_typeof] = ACTIONS(481),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(481),
    [anon_sym_PLUS_PLUS] = ACTIONS(479),
    [anon_sym_DASH_DASH] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(479),
    [anon_sym_SQUOTE] = ACTIONS(479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(479),
    [sym_number] = ACTIONS(479),
    [sym_this] = ACTIONS(481),
    [sym_super] = ACTIONS(481),
    [sym_true] = ACTIONS(481),
    [sym_false] = ACTIONS(481),
    [sym_null] = ACTIONS(481),
    [sym_undefined] = ACTIONS(481),
    [anon_sym_AT] = ACTIONS(479),
    [anon_sym_static] = ACTIONS(481),
    [anon_sym_get] = ACTIONS(481),
    [anon_sym_set] = ACTIONS(481),
    [sym__automatic_semicolon] = ACTIONS(479),
  },
  [58] = {
    [ts_builtin_sym_end] = ACTIONS(495),
    [sym_identifier] = ACTIONS(497),
    [anon_sym_export] = ACTIONS(497),
    [anon_sym_STAR] = ACTIONS(499),
    [anon_sym_default] = ACTIONS(497),
    [anon_sym_LBRACE] = ACTIONS(495),
    [anon_sym_COMMA] = ACTIONS(501),
    [anon_sym_RBRACE] = ACTIONS(495),
    [anon_sym_import] = ACTIONS(497),
    [anon_sym_var] = ACTIONS(497),
    [anon_sym_let] = ACTIONS(497),
    [anon_sym_const] = ACTIONS(497),
    [anon_sym_else] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(497),
    [anon_sym_switch] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_LPAREN] = ACTIONS(495),
    [anon_sym_await] = ACTIONS(497),
    [anon_sym_in] = ACTIONS(499),
    [anon_sym_while] = ACTIONS(497),
    [anon_sym_do] = ACTIONS(497),
    [anon_sym_try] = ACTIONS(497),
    [anon_sym_with] = ACTIONS(497),
    [anon_sym_break] = ACTIONS(497),
    [anon_sym_continue] = ACTIONS(497),
    [anon_sym_debugger] = ACTIONS(497),
    [anon_sym_return] = ACTIONS(497),
    [anon_sym_throw] = ACTIONS(497),
    [anon_sym_SEMI] = ACTIONS(495),
    [anon_sym_case] = ACTIONS(497),
    [anon_sym_yield] = ACTIONS(497),
    [anon_sym_LBRACK] = ACTIONS(495),
    [anon_sym_LT] = ACTIONS(497),
    [anon_sym_GT] = ACTIONS(499),
    [anon_sym_SLASH] = ACTIONS(497),
    [anon_sym_DOT] = ACTIONS(499),
    [anon_sym_class] = ACTIONS(497),
    [anon_sym_async] = ACTIONS(497),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_QMARK_DOT] = ACTIONS(501),
    [anon_sym_new] = ACTIONS(497),
    [anon_sym_QMARK] = ACTIONS(499),
    [anon_sym_AMP_AMP] = ACTIONS(501),
    [anon_sym_PIPE_PIPE] = ACTIONS(501),
    [anon_sym_GT_GT] = ACTIONS(499),
    [anon_sym_GT_GT_GT] = ACTIONS(501),
    [anon_sym_LT_LT] = ACTIONS(501),
    [anon_sym_AMP] = ACTIONS(499),
    [anon_sym_CARET] = ACTIONS(501),
    [anon_sym_PIPE] = ACTIONS(499),
    [anon_sym_PLUS] = ACTIONS(497),
    [anon_sym_DASH] = ACTIONS(497),
    [anon_sym_PERCENT] = ACTIONS(501),
    [anon_sym_STAR_STAR] = ACTIONS(501),
    [anon_sym_LT_EQ] = ACTIONS(501),
    [anon_sym_EQ_EQ] = ACTIONS(499),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(501),
    [anon_sym_BANG_EQ] = ACTIONS(499),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(501),
    [anon_sym_GT_EQ] = ACTIONS(501),
    [anon_sym_QMARK_QMARK] = ACTIONS(501),
    [anon_sym_instanceof] = ACTIONS(499),
    [anon_sym_BANG] = ACTIONS(497),
    [anon_sym_TILDE] = ACTIONS(495),
    [anon_sym_typeof] = ACTIONS(497),
    [anon_sym_void] = ACTIONS(497),
    [anon_sym_delete] = ACTIONS(497),
    [anon_sym_PLUS_PLUS] = ACTIONS(495),
    [anon_sym_DASH_DASH] = ACTIONS(495),
    [anon_sym_DQUOTE] = ACTIONS(495),
    [anon_sym_SQUOTE] = ACTIONS(495),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(495),
    [sym_number] = ACTIONS(495),
    [sym_this] = ACTIONS(497),
    [sym_super] = ACTIONS(497),
    [sym_true] = ACTIONS(497),
    [sym_false] = ACTIONS(497),
    [sym_null] = ACTIONS(497),
    [sym_undefined] = ACTIONS(497),
    [anon_sym_AT] = ACTIONS(495),
    [anon_sym_static] = ACTIONS(497),
    [anon_sym_get] = ACTIONS(497),
    [anon_sym_set] = ACTIONS(497),
    [sym__automatic_semicolon] = ACTIONS(503),
  },
  [59] = {
    [ts_builtin_sym_end] = ACTIONS(505),
    [sym_identifier] = ACTIONS(507),
    [anon_sym_export] = ACTIONS(507),
    [anon_sym_STAR] = ACTIONS(509),
    [anon_sym_default] = ACTIONS(507),
    [anon_sym_LBRACE] = ACTIONS(505),
    [anon_sym_COMMA] = ACTIONS(511),
    [anon_sym_RBRACE] = ACTIONS(505),
    [anon_sym_import] = ACTIONS(507),
    [anon_sym_var] = ACTIONS(507),
    [anon_sym_let] = ACTIONS(507),
    [anon_sym_const] = ACTIONS(507),
    [anon_sym_else] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(507),
    [anon_sym_switch] = ACTIONS(507),
    [anon_sym_for] = ACTIONS(507),
    [anon_sym_LPAREN] = ACTIONS(505),
    [anon_sym_await] = ACTIONS(507),
    [anon_sym_in] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(507),
    [anon_sym_do] = ACTIONS(507),
    [anon_sym_try] = ACTIONS(507),
    [anon_sym_with] = ACTIONS(507),
    [anon_sym_break] = ACTIONS(507),
    [anon_sym_continue] = ACTIONS(507),
    [anon_sym_debugger] = ACTIONS(507),
    [anon_sym_return] = ACTIONS(507),
    [anon_sym_throw] = ACTIONS(507),
    [anon_sym_SEMI] = ACTIONS(505),
    [anon_sym_case] = ACTIONS(507),
    [anon_sym_yield] = ACTIONS(507),
    [anon_sym_LBRACK] = ACTIONS(505),
    [anon_sym_LT] = ACTIONS(507),
    [anon_sym_GT] = ACTIONS(509),
    [anon_sym_SLASH] = ACTIONS(507),
    [anon_sym_DOT] = ACTIONS(509),
    [anon_sym_class] = ACTIONS(507),
    [anon_sym_async] = ACTIONS(507),
    [anon_sym_function] = ACTIONS(507),
    [anon_sym_QMARK_DOT] = ACTIONS(511),
    [anon_sym_new] = ACTIONS(507),
    [anon_sym_QMARK] = ACTIONS(509),
    [anon_sym_AMP_AMP] = ACTIONS(511),
    [anon_sym_PIPE_PIPE] = ACTIONS(511),
    [anon_sym_GT_GT] = ACTIONS(509),
    [anon_sym_GT_GT_GT] = ACTIONS(511),
    [anon_sym_LT_LT] = ACTIONS(511),
    [anon_sym_AMP] = ACTIONS(509),
    [anon_sym_CARET] = ACTIONS(511),
    [anon_sym_PIPE] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(507),
    [anon_sym_DASH] = ACTIONS(507),
    [anon_sym_PERCENT] = ACTIONS(511),
    [anon_sym_STAR_STAR] = ACTIONS(511),
    [anon_sym_LT_EQ] = ACTIONS(511),
    [anon_sym_EQ_EQ] = ACTIONS(509),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(511),
    [anon_sym_BANG_EQ] = ACTIONS(509),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(511),
    [anon_sym_GT_EQ] = ACTIONS(511),
    [anon_sym_QMARK_QMARK] = ACTIONS(511),
    [anon_sym_instanceof] = ACTIONS(509),
    [anon_sym_BANG] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(505),
    [anon_sym_typeof] = ACTIONS(507),
    [anon_sym_void] = ACTIONS(507),
    [anon_sym_delete] = ACTIONS(507),
    [anon_sym_PLUS_PLUS] = ACTIONS(505),
    [anon_sym_DASH_DASH] = ACTIONS(505),
    [anon_sym_DQUOTE] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(505),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(505),
    [sym_number] = ACTIONS(505),
    [sym_this] = ACTIONS(507),
    [sym_super] = ACTIONS(507),
    [sym_true] = ACTIONS(507),
    [sym_false] = ACTIONS(507),
    [sym_null] = ACTIONS(507),
    [sym_undefined] = ACTIONS(507),
    [anon_sym_AT] = ACTIONS(505),
    [anon_sym_static] = ACTIONS(507),
    [anon_sym_get] = ACTIONS(507),
    [anon_sym_set] = ACTIONS(507),
    [sym__automatic_semicolon] = ACTIONS(513),
  },
  [60] = {
    [ts_builtin_sym_end] = ACTIONS(515),
    [sym_identifier] = ACTIONS(517),
    [anon_sym_export] = ACTIONS(517),
    [anon_sym_STAR] = ACTIONS(517),
    [anon_sym_default] = ACTIONS(517),
    [anon_sym_LBRACE] = ACTIONS(515),
    [anon_sym_COMMA] = ACTIONS(515),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_import] = ACTIONS(517),
    [anon_sym_var] = ACTIONS(517),
    [anon_sym_let] = ACTIONS(517),
    [anon_sym_const] = ACTIONS(517),
    [anon_sym_else] = ACTIONS(517),
    [anon_sym_if] = ACTIONS(517),
    [anon_sym_switch] = ACTIONS(517),
    [anon_sym_for] = ACTIONS(517),
    [anon_sym_LPAREN] = ACTIONS(515),
    [anon_sym_await] = ACTIONS(517),
    [anon_sym_in] = ACTIONS(517),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(517),
    [anon_sym_try] = ACTIONS(517),
    [anon_sym_with] = ACTIONS(517),
    [anon_sym_break] = ACTIONS(517),
    [anon_sym_continue] = ACTIONS(517),
    [anon_sym_debugger] = ACTIONS(517),
    [anon_sym_return] = ACTIONS(517),
    [anon_sym_throw] = ACTIONS(517),
    [anon_sym_SEMI] = ACTIONS(515),
    [anon_sym_case] = ACTIONS(517),
    [anon_sym_yield] = ACTIONS(517),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LT] = ACTIONS(517),
    [anon_sym_GT] = ACTIONS(517),
    [anon_sym_SLASH] = ACTIONS(517),
    [anon_sym_DOT] = ACTIONS(517),
    [anon_sym_class] = ACTIONS(517),
    [anon_sym_async] = ACTIONS(517),
    [anon_sym_function] = ACTIONS(517),
    [anon_sym_QMARK_DOT] = ACTIONS(515),
    [anon_sym_new] = ACTIONS(517),
    [anon_sym_QMARK] = ACTIONS(517),
    [anon_sym_AMP_AMP] = ACTIONS(515),
    [anon_sym_PIPE_PIPE] = ACTIONS(515),
    [anon_sym_GT_GT] = ACTIONS(517),
    [anon_sym_GT_GT_GT] = ACTIONS(515),
    [anon_sym_LT_LT] = ACTIONS(515),
    [anon_sym_AMP] = ACTIONS(517),
    [anon_sym_CARET] = ACTIONS(515),
    [anon_sym_PIPE] = ACTIONS(517),
    [anon_sym_PLUS] = ACTIONS(517),
    [anon_sym_DASH] = ACTIONS(517),
    [anon_sym_PERCENT] = ACTIONS(515),
    [anon_sym_STAR_STAR] = ACTIONS(515),
    [anon_sym_LT_EQ] = ACTIONS(515),
    [anon_sym_EQ_EQ] = ACTIONS(517),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(515),
    [anon_sym_BANG_EQ] = ACTIONS(517),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(515),
    [anon_sym_GT_EQ] = ACTIONS(515),
    [anon_sym_QMARK_QMARK] = ACTIONS(515),
    [anon_sym_instanceof] = ACTIONS(517),
    [anon_sym_BANG] = ACTIONS(517),
    [anon_sym_TILDE] = ACTIONS(515),
    [anon_sym_typeof] = ACTIONS(517),
    [anon_sym_void] = ACTIONS(517),
    [anon_sym_delete] = ACTIONS(517),
    [anon_sym_PLUS_PLUS] = ACTIONS(515),
    [anon_sym_DASH_DASH] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(515),
    [anon_sym_SQUOTE] = ACTIONS(515),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(515),
    [sym_number] = ACTIONS(515),
    [sym_this] = ACTIONS(517),
    [sym_super] = ACTIONS(517),
    [sym_true] = ACTIONS(517),
    [sym_false] = ACTIONS(517),
    [sym_null] = ACTIONS(517),
    [sym_undefined] = ACTIONS(517),
    [anon_sym_AT] = ACTIONS(515),
    [anon_sym_static] = ACTIONS(517),
    [anon_sym_get] = ACTIONS(517),
    [anon_sym_set] = ACTIONS(517),
    [sym__automatic_semicolon] = ACTIONS(515),
  },
  [61] = {
    [ts_builtin_sym_end] = ACTIONS(519),
    [sym_identifier] = ACTIONS(521),
    [anon_sym_export] = ACTIONS(521),
    [anon_sym_STAR] = ACTIONS(523),
    [anon_sym_default] = ACTIONS(521),
    [anon_sym_LBRACE] = ACTIONS(519),
    [anon_sym_COMMA] = ACTIONS(525),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_import] = ACTIONS(521),
    [anon_sym_var] = ACTIONS(521),
    [anon_sym_let] = ACTIONS(521),
    [anon_sym_const] = ACTIONS(521),
    [anon_sym_else] = ACTIONS(521),
    [anon_sym_if] = ACTIONS(521),
    [anon_sym_switch] = ACTIONS(521),
    [anon_sym_for] = ACTIONS(521),
    [anon_sym_LPAREN] = ACTIONS(519),
    [anon_sym_await] = ACTIONS(521),
    [anon_sym_in] = ACTIONS(523),
    [anon_sym_while] = ACTIONS(521),
    [anon_sym_do] = ACTIONS(521),
    [anon_sym_try] = ACTIONS(521),
    [anon_sym_with] = ACTIONS(521),
    [anon_sym_break] = ACTIONS(521),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_debugger] = ACTIONS(521),
    [anon_sym_return] = ACTIONS(521),
    [anon_sym_throw] = ACTIONS(521),
    [anon_sym_SEMI] = ACTIONS(519),
    [anon_sym_case] = ACTIONS(521),
    [anon_sym_yield] = ACTIONS(521),
    [anon_sym_LBRACK] = ACTIONS(519),
    [anon_sym_LT] = ACTIONS(521),
    [anon_sym_GT] = ACTIONS(523),
    [anon_sym_SLASH] = ACTIONS(521),
    [anon_sym_DOT] = ACTIONS(523),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(521),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_QMARK_DOT] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(521),
    [anon_sym_QMARK] = ACTIONS(523),
    [anon_sym_AMP_AMP] = ACTIONS(525),
    [anon_sym_PIPE_PIPE] = ACTIONS(525),
    [anon_sym_GT_GT] = ACTIONS(523),
    [anon_sym_GT_GT_GT] = ACTIONS(525),
    [anon_sym_LT_LT] = ACTIONS(525),
    [anon_sym_AMP] = ACTIONS(523),
    [anon_sym_CARET] = ACTIONS(525),
    [anon_sym_PIPE] = ACTIONS(523),
    [anon_sym_PLUS] = ACTIONS(521),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_PERCENT] = ACTIONS(525),
    [anon_sym_STAR_STAR] = ACTIONS(525),
    [anon_sym_LT_EQ] = ACTIONS(525),
    [anon_sym_EQ_EQ] = ACTIONS(523),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(525),
    [anon_sym_BANG_EQ] = ACTIONS(523),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(525),
    [anon_sym_GT_EQ] = ACTIONS(525),
    [anon_sym_QMARK_QMARK] = ACTIONS(525),
    [anon_sym_instanceof] = ACTIONS(523),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_TILDE] = ACTIONS(519),
    [anon_sym_typeof] = ACTIONS(521),
    [anon_sym_void] = ACTIONS(521),
    [anon_sym_delete] = ACTIONS(521),
    [anon_sym_PLUS_PLUS] = ACTIONS(519),
    [anon_sym_DASH_DASH] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(519),
    [sym_number] = ACTIONS(519),
    [sym_this] = ACTIONS(521),
    [sym_super] = ACTIONS(521),
    [sym_true] = ACTIONS(521),
    [sym_false] = ACTIONS(521),
    [sym_null] = ACTIONS(521),
    [sym_undefined] = ACTIONS(521),
    [anon_sym_AT] = ACTIONS(519),
    [anon_sym_static] = ACTIONS(521),
    [anon_sym_get] = ACTIONS(521),
    [anon_sym_set] = ACTIONS(521),
    [sym__automatic_semicolon] = ACTIONS(527),
  },
  [62] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(525),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1026),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_spread_element] = STATE(1034),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(930),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_repeat1] = STATE(1036),
    [aux_sym_array_pattern_repeat1] = STATE(1013),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(535),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [63] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(525),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1026),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_spread_element] = STATE(1034),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(930),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_repeat1] = STATE(1036),
    [aux_sym_array_pattern_repeat1] = STATE(1013),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(543),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [64] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(525),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1026),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_spread_element] = STATE(1034),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(930),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_repeat1] = STATE(1036),
    [aux_sym_array_pattern_repeat1] = STATE(1013),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(545),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [65] = {
    [sym_import] = STATE(539),
    [sym_expression_statement] = STATE(80),
    [sym_variable_declaration] = STATE(80),
    [sym_lexical_declaration] = STATE(80),
    [sym_empty_statement] = STATE(80),
    [sym_parenthesized_expression] = STATE(363),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1011),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1011),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(363),
    [sym_subscript_expression] = STATE(363),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1011),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(547),
    [anon_sym_export] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(553),
    [anon_sym_let] = ACTIONS(555),
    [anon_sym_const] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(549),
    [anon_sym_get] = ACTIONS(549),
    [anon_sym_set] = ACTIONS(549),
  },
  [66] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(515),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1026),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_spread_element] = STATE(1025),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(930),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_repeat1] = STATE(968),
    [aux_sym_array_pattern_repeat1] = STATE(1013),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(561),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [67] = {
    [sym_import] = STATE(539),
    [sym_expression_statement] = STATE(78),
    [sym_variable_declaration] = STATE(78),
    [sym_lexical_declaration] = STATE(78),
    [sym_empty_statement] = STATE(78),
    [sym_parenthesized_expression] = STATE(363),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1011),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1011),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(363),
    [sym_subscript_expression] = STATE(363),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1011),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(547),
    [anon_sym_export] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(553),
    [anon_sym_let] = ACTIONS(555),
    [anon_sym_const] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(549),
    [anon_sym_get] = ACTIONS(549),
    [anon_sym_set] = ACTIONS(549),
  },
  [68] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(525),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1026),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_spread_element] = STATE(1034),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(930),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_repeat1] = STATE(1036),
    [aux_sym_array_pattern_repeat1] = STATE(1013),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(563),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [69] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(515),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1026),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_spread_element] = STATE(1025),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(930),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_repeat1] = STATE(968),
    [aux_sym_array_pattern_repeat1] = STATE(1013),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(565),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [70] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(506),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1026),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_spread_element] = STATE(1025),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(930),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_repeat1] = STATE(968),
    [aux_sym_array_pattern_repeat1] = STATE(1013),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(565),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [71] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(510),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1140),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_spread_element] = STATE(1022),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(1027),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(567),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(567),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [72] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(637),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1026),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(930),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_pattern_repeat1] = STATE(1013),
    [sym_identifier] = ACTIONS(570),
    [anon_sym_export] = ACTIONS(572),
    [anon_sym_LBRACE] = ACTIONS(574),
    [anon_sym_COMMA] = ACTIONS(576),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(578),
    [anon_sym_RBRACK] = ACTIONS(580),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(582),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
  },
  [73] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(549),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1030),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1300),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(921),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(586),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [74] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(602),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(919),
    [sym_assignment_pattern] = STATE(1030),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(919),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(919),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1252),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(921),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(586),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [75] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(526),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_spread_element] = STATE(1073),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_repeat1] = STATE(970),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(588),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(590),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [76] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(510),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_spread_element] = STATE(1022),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(594),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(594),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_RBRACK] = ACTIONS(594),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [77] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(531),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_spread_element] = STATE(1065),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [aux_sym_array_repeat1] = STATE(1062),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(588),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(596),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [78] = {
    [sym_import] = STATE(539),
    [sym_expression_statement] = STATE(86),
    [sym_empty_statement] = STATE(86),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [79] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(589),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_spread_element] = STATE(1303),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1303),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [80] = {
    [sym_import] = STATE(539),
    [sym_expression_statement] = STATE(85),
    [sym_empty_statement] = STATE(85),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(522),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1156),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [81] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(559),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_spread_element] = STATE(1347),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1347),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(600),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [82] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(558),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(975),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(975),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(975),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [sym_pattern] = STATE(1142),
    [sym_rest_pattern] = STATE(895),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(602),
    [anon_sym_export] = ACTIONS(604),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(606),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(604),
    [anon_sym_get] = ACTIONS(604),
    [anon_sym_set] = ACTIONS(604),
  },
  [83] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(507),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1234),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(608),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
    [sym__automatic_semicolon] = ACTIONS(608),
  },
  [84] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(380),
    [sym_expression] = STATE(640),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1045),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1045),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(380),
    [sym_subscript_expression] = STATE(380),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1045),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(610),
    [anon_sym_export] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(614),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_var] = ACTIONS(616),
    [anon_sym_let] = ACTIONS(616),
    [anon_sym_const] = ACTIONS(616),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(618),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(620),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(612),
    [anon_sym_get] = ACTIONS(612),
    [anon_sym_set] = ACTIONS(612),
  },
  [85] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(585),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1295),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(622),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [86] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(626),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1287),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(624),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [87] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(533),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1091),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [88] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(472),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(401),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [89] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(471),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(398),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [90] = {
    [sym_import] = STATE(539),
    [sym_statement_block] = STATE(554),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(450),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [91] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(408),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(958),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [92] = {
    [sym_export_clause] = STATE(927),
    [sym_declaration] = STATE(293),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_class_declaration] = STATE(275),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function_declaration] = STATE(275),
    [sym_decorator] = STATE(750),
    [aux_sym_export_statement_repeat1] = STATE(922),
    [aux_sym_object_repeat1] = STATE(976),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [anon_sym_STAR] = ACTIONS(630),
    [anon_sym_default] = ACTIONS(632),
    [anon_sym_LBRACE] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_var] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(642),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(636),
    [anon_sym_class] = ACTIONS(654),
    [anon_sym_async] = ACTIONS(656),
    [anon_sym_function] = ACTIONS(658),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(636),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [93] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(477),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(399),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [94] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(581),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1283),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [95] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(440),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(389),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [96] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(640),
    [sym_primary_expression] = STATE(400),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(664),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [97] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(471),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(622),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [98] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(477),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(623),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [99] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(587),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1284),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [100] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(440),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(542),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [101] = {
    [sym_import] = STATE(539),
    [sym_statement_block] = STATE(592),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(449),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [102] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(472),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(591),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [103] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(479),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(625),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [104] = {
    [sym_import] = STATE(539),
    [sym_statement_block] = STATE(605),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(433),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [105] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(593),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1286),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [106] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(640),
    [sym_primary_expression] = STATE(400),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(668),
    [anon_sym_export] = ACTIONS(670),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(664),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(672),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(670),
    [anon_sym_get] = ACTIONS(670),
    [anon_sym_set] = ACTIONS(670),
  },
  [107] = {
    [sym_export_clause] = STATE(927),
    [sym_declaration] = STATE(293),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_class_declaration] = STATE(275),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function_declaration] = STATE(275),
    [sym_decorator] = STATE(750),
    [aux_sym_export_statement_repeat1] = STATE(922),
    [aux_sym_object_repeat1] = STATE(1058),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [anon_sym_STAR] = ACTIONS(630),
    [anon_sym_default] = ACTIONS(632),
    [anon_sym_LBRACE] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(674),
    [anon_sym_var] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(642),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(636),
    [anon_sym_class] = ACTIONS(654),
    [anon_sym_async] = ACTIONS(656),
    [anon_sym_function] = ACTIONS(658),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(636),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [108] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(572),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1349),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [109] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(553),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1340),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [110] = {
    [sym_import] = STATE(539),
    [sym_statement_block] = STATE(607),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(501),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [111] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(578),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1326),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [112] = {
    [sym_import] = STATE(539),
    [sym_statement_block] = STATE(609),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(503),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [113] = {
    [sym_import] = STATE(539),
    [sym_statement_block] = STATE(557),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(429),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [114] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(555),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1315),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [115] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(479),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(407),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [116] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(640),
    [sym_primary_expression] = STATE(400),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(676),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [117] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(454),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(390),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [118] = {
    [sym_import] = STATE(426),
    [sym_statement_block] = STATE(454),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(618),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [119] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(568),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1348),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [120] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(583),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1338),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [121] = {
    [sym_export_clause] = STATE(927),
    [sym_declaration] = STATE(293),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_class_declaration] = STATE(275),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function_declaration] = STATE(275),
    [sym_decorator] = STATE(750),
    [aux_sym_export_statement_repeat1] = STATE(922),
    [aux_sym_object_repeat1] = STATE(1058),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [anon_sym_STAR] = ACTIONS(630),
    [anon_sym_default] = ACTIONS(632),
    [anon_sym_LBRACE] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(678),
    [anon_sym_var] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(642),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(636),
    [anon_sym_class] = ACTIONS(654),
    [anon_sym_async] = ACTIONS(656),
    [anon_sym_function] = ACTIONS(658),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(636),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [122] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(367),
    [sym_expression] = STATE(639),
    [sym_primary_expression] = STATE(518),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(367),
    [sym_subscript_expression] = STATE(367),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(680),
    [anon_sym_export] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(676),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(684),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(686),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(682),
    [anon_sym_get] = ACTIONS(682),
    [anon_sym_set] = ACTIONS(682),
  },
  [123] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(619),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1273),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [124] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(523),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_sequence_expression] = STATE(1239),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [125] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(602),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_sequence_expression] = STATE(1252),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [126] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(488),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [127] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(386),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [128] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(498),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [129] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(637),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [130] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(412),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [131] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(395),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [132] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(576),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [133] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(413),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [134] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(627),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [135] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(521),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [136] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(415),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [137] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(383),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [138] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(499),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [139] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(383),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [140] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(621),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [141] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(483),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [142] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(396),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [143] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(409),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [144] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(558),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [145] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(473),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [146] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(391),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [147] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(406),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [148] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(530),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [149] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(387),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [150] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(597),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [151] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(563),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [152] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(541),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [153] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(457),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [154] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(561),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [155] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(498),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(992),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(992),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(992),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [156] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(616),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [157] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(573),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [158] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(543),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [159] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(631),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [160] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(584),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [161] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(536),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [162] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(393),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [163] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(496),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [164] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(414),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [165] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(388),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [166] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(480),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [167] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(615),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [168] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(633),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [169] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(600),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [170] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(487),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [171] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(448),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [172] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(387),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [173] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(535),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [174] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(386),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [175] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(469),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [176] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(405),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [177] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(447),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [178] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(630),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [179] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(482),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [180] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(427),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [181] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(446),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [182] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(498),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1070),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1070),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1070),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(690),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [183] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(445),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [184] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(629),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [185] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(432),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [186] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(544),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [187] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(562),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [188] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(439),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [189] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(385),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [190] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(442),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [191] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(410),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [192] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(355),
    [sym_expression] = STATE(385),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1333),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1333),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(355),
    [sym_subscript_expression] = STATE(355),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(714),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1333),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1322),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [193] = {
    [sym_import] = STATE(426),
    [sym_parenthesized_expression] = STATE(340),
    [sym_expression] = STATE(632),
    [sym_primary_expression] = STATE(425),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(426),
    [sym_object_pattern] = STATE(1317),
    [sym_array] = STATE(426),
    [sym_array_pattern] = STATE(1317),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(768),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(426),
    [sym_function] = STATE(426),
    [sym_generator_function] = STATE(426),
    [sym_arrow_function] = STATE(426),
    [sym_call_expression] = STATE(426),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(340),
    [sym_subscript_expression] = STATE(340),
    [sym_assignment_expression] = STATE(424),
    [sym__augmented_assignment_lhs] = STATE(712),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym__destructuring_pattern] = STATE(1317),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(426),
    [sym_template_string] = STATE(426),
    [sym_regex] = STATE(426),
    [sym_meta_property] = STATE(426),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1267),
    [aux_sym_export_statement_repeat1] = STATE(924),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [194] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(443),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [195] = {
    [sym_import] = STATE(539),
    [sym_parenthesized_expression] = STATE(362),
    [sym_expression] = STATE(444),
    [sym_primary_expression] = STATE(546),
    [sym_yield_expression] = STATE(550),
    [sym_object] = STATE(539),
    [sym_object_pattern] = STATE(1320),
    [sym_array] = STATE(539),
    [sym_array_pattern] = STATE(1320),
    [sym_jsx_element] = STATE(550),
    [sym_jsx_fragment] = STATE(550),
    [sym_jsx_opening_element] = STATE(772),
    [sym_jsx_self_closing_element] = STATE(550),
    [sym_class] = STATE(539),
    [sym_function] = STATE(539),
    [sym_generator_function] = STATE(539),
    [sym_arrow_function] = STATE(539),
    [sym_call_expression] = STATE(539),
    [sym_new_expression] = STATE(550),
    [sym_await_expression] = STATE(550),
    [sym_member_expression] = STATE(362),
    [sym_subscript_expression] = STATE(362),
    [sym_assignment_expression] = STATE(550),
    [sym__augmented_assignment_lhs] = STATE(720),
    [sym_augmented_assignment_expression] = STATE(550),
    [sym__destructuring_pattern] = STATE(1320),
    [sym_ternary_expression] = STATE(550),
    [sym_binary_expression] = STATE(550),
    [sym_unary_expression] = STATE(550),
    [sym_update_expression] = STATE(550),
    [sym_string] = STATE(539),
    [sym_template_string] = STATE(539),
    [sym_regex] = STATE(539),
    [sym_meta_property] = STATE(539),
    [sym_decorator] = STATE(750),
    [sym_formal_parameters] = STATE(1318),
    [aux_sym_export_statement_repeat1] = STATE(925),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [196] = {
    [sym_export_clause] = STATE(927),
    [sym_declaration] = STATE(293),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_class_declaration] = STATE(275),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function_declaration] = STATE(275),
    [sym_decorator] = STATE(750),
    [aux_sym_export_statement_repeat1] = STATE(955),
    [anon_sym_STAR] = ACTIONS(630),
    [anon_sym_default] = ACTIONS(632),
    [anon_sym_LBRACE] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_var] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(642),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(692),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(636),
    [anon_sym_class] = ACTIONS(696),
    [anon_sym_async] = ACTIONS(698),
    [anon_sym_function] = ACTIONS(700),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(636),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [197] = {
    [sym_export_clause] = STATE(927),
    [sym_declaration] = STATE(293),
    [sym_variable_declaration] = STATE(275),
    [sym_lexical_declaration] = STATE(275),
    [sym_class_declaration] = STATE(275),
    [sym_function_declaration] = STATE(275),
    [sym_generator_function_declaration] = STATE(275),
    [sym_decorator] = STATE(750),
    [aux_sym_export_statement_repeat1] = STATE(922),
    [anon_sym_STAR] = ACTIONS(630),
    [anon_sym_default] = ACTIONS(632),
    [anon_sym_LBRACE] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_var] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(642),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(702),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(636),
    [anon_sym_class] = ACTIONS(654),
    [anon_sym_async] = ACTIONS(656),
    [anon_sym_function] = ACTIONS(658),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(636),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [198] = {
    [sym_string] = STATE(1181),
    [sym_formal_parameters] = STATE(1257),
    [sym__property_name] = STATE(1181),
    [sym_computed_property_name] = STATE(1181),
    [aux_sym_object_repeat1] = STATE(1058),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [sym_identifier] = ACTIONS(704),
    [anon_sym_export] = ACTIONS(706),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(674),
    [anon_sym_LPAREN] = ACTIONS(711),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_async] = ACTIONS(706),
    [anon_sym_function] = ACTIONS(718),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(647),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(706),
    [anon_sym_get] = ACTIONS(722),
    [anon_sym_set] = ACTIONS(722),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [199] = {
    [sym_string] = STATE(1181),
    [sym_formal_parameters] = STATE(1257),
    [sym__property_name] = STATE(1181),
    [sym_computed_property_name] = STATE(1181),
    [aux_sym_object_repeat1] = STATE(976),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [sym_identifier] = ACTIONS(704),
    [anon_sym_export] = ACTIONS(706),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_LPAREN] = ACTIONS(711),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_async] = ACTIONS(706),
    [anon_sym_function] = ACTIONS(718),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(647),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(706),
    [anon_sym_get] = ACTIONS(722),
    [anon_sym_set] = ACTIONS(722),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [200] = {
    [sym_string] = STATE(1181),
    [sym_formal_parameters] = STATE(1257),
    [sym__property_name] = STATE(1181),
    [sym_computed_property_name] = STATE(1181),
    [aux_sym_object_repeat1] = STATE(1058),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [sym_identifier] = ACTIONS(704),
    [anon_sym_export] = ACTIONS(706),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(711),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_async] = ACTIONS(706),
    [anon_sym_function] = ACTIONS(718),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(647),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(706),
    [anon_sym_get] = ACTIONS(722),
    [anon_sym_set] = ACTIONS(722),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [201] = {
    [sym_string] = STATE(1181),
    [sym__property_name] = STATE(1181),
    [sym_computed_property_name] = STATE(1181),
    [aux_sym_object_repeat1] = STATE(976),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_async] = ACTIONS(726),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(647),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(728),
    [anon_sym_set] = ACTIONS(728),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [202] = {
    [sym_string] = STATE(1181),
    [sym__property_name] = STATE(1181),
    [sym_computed_property_name] = STATE(1181),
    [aux_sym_object_repeat1] = STATE(1058),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(647),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_async] = ACTIONS(724),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(647),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(724),
    [anon_sym_set] = ACTIONS(724),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [203] = {
    [sym_string] = STATE(1181),
    [sym__property_name] = STATE(1181),
    [sym_computed_property_name] = STATE(1181),
    [aux_sym_object_repeat1] = STATE(1058),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(674),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_async] = ACTIONS(726),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(647),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(728),
    [anon_sym_set] = ACTIONS(728),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [204] = {
    [sym_string] = STATE(1181),
    [sym__property_name] = STATE(1181),
    [sym_computed_property_name] = STATE(1181),
    [aux_sym_object_repeat1] = STATE(1058),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(678),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_async] = ACTIONS(726),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(647),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(728),
    [anon_sym_set] = ACTIONS(728),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [205] = {
    [sym_string] = STATE(1181),
    [sym__property_name] = STATE(1181),
    [sym_computed_property_name] = STATE(1181),
    [aux_sym_object_repeat1] = STATE(976),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(647),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(638),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_async] = ACTIONS(724),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(647),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(724),
    [anon_sym_set] = ACTIONS(724),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
  [206] = {
    [sym_string] = STATE(1181),
    [sym__property_name] = STATE(1181),
    [sym_computed_property_name] = STATE(1181),
    [aux_sym_object_repeat1] = STATE(1058),
    [aux_sym_object_pattern_repeat1] = STATE(978),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(647),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(674),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_in] = ACTIONS(647),
    [anon_sym_SEMI] = ACTIONS(636),
    [anon_sym_COLON] = ACTIONS(649),
    [anon_sym_EQ] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(647),
    [anon_sym_GT] = ACTIONS(647),
    [anon_sym_SLASH] = ACTIONS(647),
    [anon_sym_DOT] = ACTIONS(647),
    [anon_sym_async] = ACTIONS(724),
    [anon_sym_EQ_GT] = ACTIONS(660),
    [anon_sym_QMARK_DOT] = ACTIONS(636),
    [anon_sym_PLUS_EQ] = ACTIONS(662),
    [anon_sym_DASH_EQ] = ACTIONS(662),
    [anon_sym_STAR_EQ] = ACTIONS(662),
    [anon_sym_SLASH_EQ] = ACTIONS(662),
    [anon_sym_PERCENT_EQ] = ACTIONS(662),
    [anon_sym_CARET_EQ] = ACTIONS(662),
    [anon_sym_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(662),
    [anon_sym_LT_LT_EQ] = ACTIONS(662),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(662),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(662),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(662),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(662),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_AMP_AMP] = ACTIONS(647),
    [anon_sym_PIPE_PIPE] = ACTIONS(647),
    [anon_sym_GT_GT] = ACTIONS(647),
    [anon_sym_GT_GT_GT] = ACTIONS(647),
    [anon_sym_LT_LT] = ACTIONS(647),
    [anon_sym_AMP] = ACTIONS(647),
    [anon_sym_CARET] = ACTIONS(647),
    [anon_sym_PIPE] = ACTIONS(647),
    [anon_sym_PLUS] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(647),
    [anon_sym_PERCENT] = ACTIONS(647),
    [anon_sym_STAR_STAR] = ACTIONS(647),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(647),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(647),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(647),
    [anon_sym_instanceof] = ACTIONS(647),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(724),
    [anon_sym_set] = ACTIONS(724),
    [sym__automatic_semicolon] = ACTIONS(636),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_EQ,
    ACTIONS(739), 1,
      anon_sym_function,
    ACTIONS(741), 1,
      anon_sym_EQ_GT,
    STATE(1332), 1,
      sym_formal_parameters,
    ACTIONS(732), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 15,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [87] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(743), 1,
      sym__automatic_semicolon,
    ACTIONS(479), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(481), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [160] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym__automatic_semicolon,
    ACTIONS(417), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(419), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [233] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_function,
    ACTIONS(741), 1,
      anon_sym_EQ_GT,
    ACTIONS(745), 1,
      anon_sym_EQ,
    STATE(1332), 1,
      sym_formal_parameters,
    ACTIONS(732), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 15,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [320] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 1,
      anon_sym_EQ_GT,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_EQ,
    ACTIONS(747), 1,
      sym_identifier,
    ACTIONS(751), 1,
      anon_sym_function,
    STATE(1257), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [406] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 1,
      anon_sym_EQ_GT,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(747), 1,
      sym_identifier,
    ACTIONS(751), 1,
      anon_sym_function,
    STATE(1257), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [492] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 1,
      anon_sym_EQ_GT,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(747), 1,
      sym_identifier,
    ACTIONS(751), 1,
      anon_sym_function,
    ACTIONS(753), 1,
      anon_sym_in,
    ACTIONS(756), 1,
      anon_sym_of,
    STATE(1257), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [582] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 1,
      anon_sym_EQ_GT,
    ACTIONS(692), 1,
      anon_sym_COLON,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(747), 1,
      sym_identifier,
    ACTIONS(758), 1,
      anon_sym_function,
    STATE(1257), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [670] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_catch,
    ACTIONS(766), 1,
      anon_sym_finally,
    STATE(221), 1,
      sym_catch_clause,
    STATE(305), 1,
      sym_finally_clause,
    ACTIONS(760), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(762), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [748] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(660), 1,
      anon_sym_EQ_GT,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(702), 1,
      anon_sym_COLON,
    ACTIONS(718), 1,
      anon_sym_function,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(747), 1,
      sym_identifier,
    STATE(1257), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [836] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(481), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(451), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [976] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_function,
    ACTIONS(741), 1,
      anon_sym_EQ_GT,
    ACTIONS(771), 1,
      anon_sym_EQ,
    STATE(1332), 1,
      sym_formal_parameters,
    ACTIONS(768), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(732), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1063] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_function,
    ACTIONS(741), 1,
      anon_sym_EQ_GT,
    ACTIONS(768), 1,
      anon_sym_RBRACK,
    ACTIONS(771), 1,
      anon_sym_EQ,
    ACTIONS(774), 1,
      anon_sym_COMMA,
    STATE(1332), 1,
      sym_formal_parameters,
    ACTIONS(732), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1151] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_finally,
    STATE(270), 1,
      sym_finally_clause,
    ACTIONS(776), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(778), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1223] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_EQ,
    ACTIONS(739), 1,
      anon_sym_function,
    ACTIONS(780), 1,
      sym_identifier,
    ACTIONS(784), 1,
      anon_sym_EQ_GT,
    STATE(1294), 1,
      sym_formal_parameters,
    ACTIONS(782), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 12,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1307] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_function,
    ACTIONS(741), 1,
      anon_sym_EQ_GT,
    ACTIONS(745), 1,
      anon_sym_EQ,
    STATE(1332), 1,
      sym_formal_parameters,
    ACTIONS(768), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(732), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1393] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 1,
      sym__automatic_semicolon,
    ACTIONS(455), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(457), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1462] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      sym__automatic_semicolon,
    ACTIONS(495), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(497), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1531] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(737), 1,
      anon_sym_EQ,
    ACTIONS(739), 1,
      anon_sym_function,
    ACTIONS(753), 1,
      anon_sym_in,
    ACTIONS(756), 1,
      anon_sym_of,
    ACTIONS(780), 1,
      sym_identifier,
    ACTIONS(784), 1,
      anon_sym_EQ_GT,
    STATE(1294), 1,
      sym_formal_parameters,
    ACTIONS(782), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(662), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(647), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1618] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(788), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1685] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(792), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1752] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 1,
      sym__automatic_semicolon,
    ACTIONS(519), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(521), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1821] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 1,
      sym__automatic_semicolon,
    ACTIONS(485), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(487), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1890] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 1,
      sym__automatic_semicolon,
    ACTIONS(429), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(431), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1959] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 1,
      anon_sym_else,
    STATE(250), 1,
      sym_else_clause,
    ACTIONS(794), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(796), 41,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2030] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 1,
      sym__automatic_semicolon,
    ACTIONS(469), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(471), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(451), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2166] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 1,
      sym__automatic_semicolon,
    ACTIONS(417), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(419), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2235] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(804), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2302] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 1,
      sym__automatic_semicolon,
    ACTIONS(439), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(441), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2371] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      sym__automatic_semicolon,
    ACTIONS(505), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(507), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2440] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(481), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2507] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(808), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(517), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2641] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(467), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2708] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 1,
      sym__automatic_semicolon,
    ACTIONS(479), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(481), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(814), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(818), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2909] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(824), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(826), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(830), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3173] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(834), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(836), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(838), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3371] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(842), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3437] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(846), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(846), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3899] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3965] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4097] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(850), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4229] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4295] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4427] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(854), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(856), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(858), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(862), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(866), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(870), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(874), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4889] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(878), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(882), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5021] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(882), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(886), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5153] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(890), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(894), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(898), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(902), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(906), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5549] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(882), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5615] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(882), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(910), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5747] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(914), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(918), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(922), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5945] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(926), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(930), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(934), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6143] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(938), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6209] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6275] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6341] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(942), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6407] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(946), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(950), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(954), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(958), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6671] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(962), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6737] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(966), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6803] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(970), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6869] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [6935] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(974), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7001] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(978), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7067] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(982), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(986), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(986), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7265] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(986), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(986), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [7397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(986), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_asyn