#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1212
#define LARGE_STATE_COUNT 207
#define SYMBOL_COUNT 241
#define ALIAS_COUNT 5
#define TOKEN_COUNT 124
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 34
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 90

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_LBRACE = 6,
  anon_sym_COMMA = 7,
  anon_sym_RBRACE = 8,
  anon_sym_as = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_var = 12,
  anon_sym_let = 13,
  anon_sym_const = 14,
  anon_sym_else = 15,
  anon_sym_if = 16,
  anon_sym_switch = 17,
  anon_sym_for = 18,
  anon_sym_LPAREN = 19,
  anon_sym_RPAREN = 20,
  anon_sym_await = 21,
  anon_sym_in = 22,
  anon_sym_of = 23,
  anon_sym_while = 24,
  anon_sym_do = 25,
  anon_sym_try = 26,
  anon_sym_with = 27,
  anon_sym_break = 28,
  anon_sym_continue = 29,
  anon_sym_debugger = 30,
  anon_sym_return = 31,
  anon_sym_throw = 32,
  anon_sym_SEMI = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_SLASH = 44,
  sym_jsx_text = 45,
  sym_jsx_identifier = 46,
  anon_sym_DOT = 47,
  anon_sym_class = 48,
  anon_sym_extends = 49,
  anon_sym_async = 50,
  anon_sym_function = 51,
  anon_sym_EQ_GT = 52,
  anon_sym_QMARK_DOT = 53,
  anon_sym_new = 54,
  anon_sym_PLUS_EQ = 55,
  anon_sym_DASH_EQ = 56,
  anon_sym_STAR_EQ = 57,
  anon_sym_SLASH_EQ = 58,
  anon_sym_PERCENT_EQ = 59,
  anon_sym_CARET_EQ = 60,
  anon_sym_AMP_EQ = 61,
  anon_sym_PIPE_EQ = 62,
  anon_sym_GT_GT_EQ = 63,
  anon_sym_GT_GT_GT_EQ = 64,
  anon_sym_LT_LT_EQ = 65,
  anon_sym_STAR_STAR_EQ = 66,
  anon_sym_AMP_AMP_EQ = 67,
  anon_sym_PIPE_PIPE_EQ = 68,
  anon_sym_QMARK_QMARK_EQ = 69,
  anon_sym_DOT_DOT_DOT = 70,
  anon_sym_QMARK = 71,
  anon_sym_AMP_AMP = 72,
  anon_sym_PIPE_PIPE = 73,
  anon_sym_GT_GT = 74,
  anon_sym_GT_GT_GT = 75,
  anon_sym_LT_LT = 76,
  anon_sym_AMP = 77,
  anon_sym_CARET = 78,
  anon_sym_PIPE = 79,
  anon_sym_PLUS = 80,
  anon_sym_DASH = 81,
  anon_sym_PERCENT = 82,
  anon_sym_STAR_STAR = 83,
  anon_sym_LT_EQ = 84,
  anon_sym_EQ_EQ = 85,
  anon_sym_EQ_EQ_EQ = 86,
  anon_sym_BANG_EQ = 87,
  anon_sym_BANG_EQ_EQ = 88,
  anon_sym_GT_EQ = 89,
  anon_sym_QMARK_QMARK = 90,
  anon_sym_instanceof = 91,
  anon_sym_BANG = 92,
  anon_sym_TILDE = 93,
  anon_sym_typeof = 94,
  anon_sym_void = 95,
  anon_sym_delete = 96,
  anon_sym_PLUS_PLUS = 97,
  anon_sym_DASH_DASH = 98,
  anon_sym_DQUOTE = 99,
  aux_sym_string_token1 = 100,
  anon_sym_SQUOTE = 101,
  aux_sym_string_token2 = 102,
  sym_escape_sequence = 103,
  sym_comment = 104,
  anon_sym_BQUOTE = 105,
  anon_sym_DOLLAR_LBRACE = 106,
  anon_sym_SLASH2 = 107,
  sym_regex_pattern = 108,
  sym_regex_flags = 109,
  sym_number = 110,
  anon_sym_target = 111,
  sym_this = 112,
  sym_super = 113,
  sym_true = 114,
  sym_false = 115,
  sym_null = 116,
  sym_undefined = 117,
  anon_sym_AT = 118,
  anon_sym_static = 119,
  anon_sym_get = 120,
  anon_sym_set = 121,
  sym__automatic_semicolon = 122,
  sym__template_chars = 123,
  sym_program = 124,
  sym_export_statement = 125,
  sym_export_clause = 126,
  sym__import_export_specifier = 127,
  sym_declaration = 128,
  sym_import = 129,
  sym_import_statement = 130,
  sym_import_clause = 131,
  sym__from_clause = 132,
  sym_namespace_import = 133,
  sym_named_imports = 134,
  sym_expression_statement = 135,
  sym_variable_declaration = 136,
  sym_lexical_declaration = 137,
  sym_variable_declarator = 138,
  sym_statement_block = 139,
  sym_else_clause = 140,
  sym_if_statement = 141,
  sym_switch_statement = 142,
  sym_for_statement = 143,
  sym_for_in_statement = 144,
  sym__for_header = 145,
  sym_while_statement = 146,
  sym_do_statement = 147,
  sym_try_statement = 148,
  sym_with_statement = 149,
  sym_break_statement = 150,
  sym_continue_statement = 151,
  sym_debugger_statement = 152,
  sym_return_statement = 153,
  sym_throw_statement = 154,
  sym_empty_statement = 155,
  sym_labeled_statement = 156,
  sym_switch_body = 157,
  sym_switch_case = 158,
  sym_switch_default = 159,
  sym_catch_clause = 160,
  sym_finally_clause = 161,
  sym_parenthesized_expression = 162,
  sym_expression = 163,
  sym_primary_expression = 164,
  sym_yield_expression = 165,
  sym_object = 166,
  sym_object_pattern = 167,
  sym_assignment_pattern = 168,
  sym_object_assignment_pattern = 169,
  sym_array = 170,
  sym_array_pattern = 171,
  sym_jsx_element = 172,
  sym_jsx_fragment = 173,
  sym_jsx_expression = 174,
  sym_jsx_opening_element = 175,
  sym_nested_identifier = 176,
  sym_jsx_namespace_name = 177,
  sym_jsx_closing_element = 178,
  sym_jsx_self_closing_element = 179,
  sym_jsx_attribute = 180,
  sym_class = 181,
  sym_class_declaration = 182,
  sym_class_heritage = 183,
  sym_function = 184,
  sym_function_declaration = 185,
  sym_generator_function = 186,
  sym_generator_function_declaration = 187,
  sym_arrow_function = 188,
  sym_call_expression = 189,
  sym_new_expression = 190,
  sym_await_expression = 191,
  sym_member_expression = 192,
  sym_subscript_expression = 193,
  sym_assignment_expression = 194,
  sym__augmented_assignment_lhs = 195,
  sym_augmented_assignment_expression = 196,
  sym__initializer = 197,
  sym__destructuring_pattern = 198,
  sym_spread_element = 199,
  sym_ternary_expression = 200,
  sym_binary_expression = 201,
  sym_unary_expression = 202,
  sym_update_expression = 203,
  sym_sequence_expression = 204,
  sym_string = 205,
  sym_template_string = 206,
  sym_template_substitution = 207,
  sym_regex = 208,
  sym_meta_property = 209,
  sym_arguments = 210,
  sym_decorator = 211,
  sym_decorator_member_expression = 212,
  sym_decorator_call_expression = 213,
  sym_class_body = 214,
  sym_public_field_definition = 215,
  sym_formal_parameters = 216,
  sym_pattern = 217,
  sym_rest_pattern = 218,
  sym_method_definition = 219,
  sym_pair = 220,
  sym_pair_pattern = 221,
  sym__property_name = 222,
  sym_computed_property_name = 223,
  aux_sym_program_repeat1 = 224,
  aux_sym_export_statement_repeat1 = 225,
  aux_sym_export_clause_repeat1 = 226,
  aux_sym_named_imports_repeat1 = 227,
  aux_sym_variable_declaration_repeat1 = 228,
  aux_sym_switch_body_repeat1 = 229,
  aux_sym_object_repeat1 = 230,
  aux_sym_object_pattern_repeat1 = 231,
  aux_sym_array_repeat1 = 232,
  aux_sym_array_pattern_repeat1 = 233,
  aux_sym_jsx_element_repeat1 = 234,
  aux_sym_jsx_opening_element_repeat1 = 235,
  aux_sym_string_repeat1 = 236,
  aux_sym_string_repeat2 = 237,
  aux_sym_template_string_repeat1 = 238,
  aux_sym_class_body_repeat1 = 239,
  aux_sym_formal_parameters_repeat1 = 240,
  alias_sym_import_specifier = 241,
  alias_sym_property_identifier = 242,
  alias_sym_shorthand_property_identifier = 243,
  alias_sym_shorthand_property_identifier_pattern = 244,
  alias_sym_statement_identifier = 245,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [sym_jsx_text] = "jsx_text",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_public_field_definition] = "public_field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_jsx_text] = sym_jsx_text,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_initializer = 19,
  field_key = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_object = 25,
  field_open_tag = 26,
  field_operator = 27,
  field_parameter = 28,
  field_parameters = 29,
  field_pattern = 30,
  field_property = 31,
  field_right = 32,
  field_source = 33,
  field_value = 34,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 2},
  [15] = {.index = 18, .length = 2},
  [18] = {.index = 20, .length = 1},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 2},
  [21] = {.index = 25, .length = 2},
  [22] = {.index = 27, .length = 3},
  [23] = {.index = 30, .length = 2},
  [24] = {.index = 32, .length = 2},
  [25] = {.index = 34, .length = 2},
  [26] = {.index = 36, .length = 2},
  [27] = {.index = 38, .length = 1},
  [28] = {.index = 39, .length = 1},
  [29] = {.index = 40, .length = 1},
  [30] = {.index = 41, .length = 1},
  [31] = {.index = 42, .length = 1},
  [32] = {.index = 43, .length = 1},
  [33] = {.index = 44, .length = 2},
  [34] = {.index = 46, .length = 1},
  [35] = {.index = 47, .length = 2},
  [36] = {.index = 49, .length = 2},
  [37] = {.index = 16, .length = 2},
  [38] = {.index = 18, .length = 2},
  [39] = {.index = 51, .length = 3},
  [40] = {.index = 54, .length = 2},
  [41] = {.index = 56, .length = 2},
  [42] = {.index = 58, .length = 2},
  [43] = {.index = 60, .length = 2},
  [44] = {.index = 62, .length = 2},
  [45] = {.index = 64, .length = 1},
  [46] = {.index = 65, .length = 1},
  [47] = {.index = 16, .length = 2},
  [48] = {.index = 66, .length = 2},
  [49] = {.index = 68, .length = 3},
  [50] = {.index = 71, .length = 2},
  [51] = {.index = 73, .length = 1},
  [52] = {.index = 74, .length = 3},
  [53] = {.index = 77, .length = 3},
  [54] = {.index = 80, .length = 3},
  [55] = {.index = 83, .length = 2},
  [56] = {.index = 85, .length = 2},
  [57] = {.index = 87, .length = 2},
  [58] = {.index = 89, .length = 1},
  [59] = {.index = 90, .length = 2},
  [60] = {.index = 92, .length = 1},
  [61] = {.index = 93, .length = 2},
  [62] = {.index = 95, .length = 2},
  [63] = {.index = 97, .length = 2},
  [64] = {.index = 99, .length = 2},
  [65] = {.index = 97, .length = 2},
  [66] = {.index = 101, .length = 2},
  [67] = {.index = 103, .length = 3},
  [68] = {.index = 106, .length = 2},
  [69] = {.index = 108, .length = 3},
  [70] = {.index = 111, .length = 2},
  [71] = {.index = 113, .length = 2},
  [72] = {.index = 71, .length = 2},
  [73] = {.index = 115, .length = 2},
  [74] = {.index = 117, .length = 2},
  [75] = {.index = 119, .length = 2},
  [76] = {.index = 121, .length = 3},
  [77] = {.index = 124, .length = 2},
  [78] = {.index = 126, .length = 3},
  [79] = {.index = 129, .length = 1},
  [80] = {.index = 130, .length = 2},
  [81] = {.index = 132, .length = 3},
  [82] = {.index = 135, .length = 2},
  [83] = {.index = 135, .length = 2},
  [84] = {.index = 137, .length = 3},
  [85] = {.index = 140, .length = 3},
  [86] = {.index = 143, .length = 2},
  [87] = {.index = 145, .length = 4},
  [88] = {.index = 149, .length = 2},
  [89] = {.index = 151, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_argument, 0},
    {field_operator, 1},
  [9] =
    {field_arguments, 1},
    {field_function, 0},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_label, 0},
  [16] =
    {field_left, 0},
    {field_right, 2},
  [18] =
    {field_body, 2},
    {field_parameter, 0},
  [20] =
    {field_source, 1},
  [21] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [23] =
    {field_condition, 1},
    {field_consequence, 2},
  [25] =
    {field_body, 2},
    {field_value, 1},
  [27] =
    {field_body, 2},
    {field_left, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [30] =
    {field_body, 2},
    {field_condition, 1},
  [32] =
    {field_body, 1},
    {field_handler, 2},
  [34] =
    {field_body, 1},
    {field_finalizer, 2},
  [36] =
    {field_body, 2},
    {field_object, 1},
  [38] =
    {field_label, 1},
  [39] =
    {field_name, 1},
  [40] =
    {field_attribute, 0},
  [41] =
    {field_pattern, 1},
  [42] =
    {field_member, 0},
  [43] =
    {field_property, 0},
  [44] =
    {field_body, 2},
    {field_name, 1},
  [46] =
    {field_body, 2},
  [47] =
    {field_body, 2},
    {field_parameters, 1},
  [49] =
    {field_arguments, 2},
    {field_constructor, 1},
  [51] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [54] =
    {field_object, 0},
    {field_property, 2},
  [56] =
    {field_arguments, 2},
    {field_function, 0},
  [58] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [60] =
    {field_body, 2},
    {field_parameters, 0},
  [62] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [64] =
    {field_source, 2, .inherited = true},
  [65] =
    {field_value, 2},
  [66] =
    {field_key, 0},
    {field_value, 2},
  [68] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [71] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [73] =
    {field_value, 1},
  [74] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [77] =
    {field_body, 3},
    {field_left, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [80] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [83] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [85] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [87] =
    {field_flags, 3},
    {field_pattern, 1},
  [89] =
    {field_property, 1},
  [90] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [92] =
    {field_member, 1, .inherited = true},
  [93] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [95] =
    {field_body, 3},
    {field_name, 1},
  [97] =
    {field_body, 3},
    {field_parameter, 1},
  [99] =
    {field_body, 3},
    {field_parameters, 2},
  [101] =
    {field_body, 3},
    {field_parameters, 1},
  [103] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [106] =
    {field_index, 2},
    {field_object, 0},
  [108] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [111] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [113] =
    {field_alias, 2},
    {field_name, 0},
  [115] =
    {field_body, 1},
    {field_condition, 3},
  [117] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [119] =
    {field_body, 4},
    {field_parameters, 3},
  [121] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [124] =
    {field_index, 3},
    {field_object, 0},
  [126] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [129] =
    {field_name, 2},
  [130] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [132] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [135] =
    {field_left, 1},
    {field_right, 3},
  [137] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [140] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [143] =
    {field_left, 2},
    {field_right, 4},
  [145] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [149] =
    {field_body, 4},
    {field_parameter, 2},
  [151] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [13] = {
    [0] = alias_sym_statement_identifier,
  },
  [14] = {
    [0] = sym_identifier,
  },
  [15] = {
    [0] = sym_identifier,
  },
  [16] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [27] = {
    [1] = alias_sym_statement_identifier,
  },
  [40] = {
    [2] = alias_sym_property_identifier,
  },
  [47] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [50] = {
    [1] = alias_sym_import_specifier,
  },
  [63] = {
    [1] = sym_identifier,
  },
  [82] = {
    [1] = sym_identifier,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '%'
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : c <= '^')))
    : (c <= '`' || (c < 8203
      ? (c < 160
        ? (c >= '{' && c <= '~')
        : c <= 160)
      : (c <= 8203 || (c < 65279
        ? c == 8288
        : c <= 65279)))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(57);
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(123);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(60);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == '?') ADVANCE(111);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(126);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(188);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '[') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(53);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(173);
      if (lookahead != 0) ADVANCE(174);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(58);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == '<') ADVANCE(75);
      if (lookahead == '>') ADVANCE(78);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(188);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(123);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(60);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(82);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == '?') ADVANCE(111);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(126);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > '#' &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '=') ADVANCE(20);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '?') ADVANCE(112);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '=') ADVANCE(20);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '?') ADVANCE(112);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(6)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(188);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(155);
      if (lookahead != 0) ADVANCE(156);
      END_STATE();
    case 8:
      if (lookahead == '$') ADVANCE(25);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(25);
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      END_STATE();
    case 10:
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '/') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(162);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(169);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(168);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead != 0) ADVANCE(13);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(110);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '>') ADVANCE(78);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > '~') ADVANCE(188);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '<') ADVANCE(75);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(87);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(88);
      END_STATE();
    case 18:
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(18)
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 21:
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == ']') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(21);
      END_STATE();
    case 22:
      if (lookahead == 'u') ADVANCE(26);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(164);
      END_STATE();
    case 23:
      if (lookahead == 'u') ADVANCE(27);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(28);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(164);
      END_STATE();
    case 25:
      if (lookahead == '{') ADVANCE(171);
      END_STATE();
    case 26:
      if (lookahead == '{') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 27:
      if (lookahead == '{') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 28:
      if (lookahead == '{') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 29:
      if (lookahead == '}') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 30:
      if (lookahead == '}') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 31:
      if (lookahead == '}') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 32:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 33:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(179);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(180);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(178);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(188);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(181);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 52:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(21);
      END_STATE();
    case 53:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(174);
      END_STATE();
    case 54:
      if (eof) ADVANCE(57);
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(134);
      if (lookahead == '&') ADVANCE(123);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(60);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(76);
      if (lookahead == '=') ADVANCE(71);
      if (lookahead == '>') ADVANCE(79);
      if (lookahead == '?') ADVANCE(111);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(126);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(127);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(188);
      END_STATE();
    case 55:
      if (eof) ADVANCE(57);
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '%') ADVANCE(133);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(61);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(77);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '>') ADVANCE(80);
      if (lookahead == '?') ADVANCE(112);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '^') ADVANCE(125);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '|') ADVANCE(128);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(55)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > '#') ADVANCE(188);
      END_STATE();
    case 56:
      if (eof) ADVANCE(57);
      if (lookahead == '!') ADVANCE(145);
      if (lookahead == '"') ADVANCE(150);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '\'') ADVANCE(157);
      if (lookahead == '(') ADVANCE(65);
      if (lookahead == ')') ADVANCE(66);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(63);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(14);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '0') ADVANCE(177);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(67);
      if (lookahead == '<') ADVANCE(75);
      if (lookahead == '=') ADVANCE(72);
      if (lookahead == '>') ADVANCE(78);
      if (lookahead == '@') ADVANCE(189);
      if (lookahead == '[') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == ']') ADVANCE(74);
      if (lookahead == '`') ADVANCE(170);
      if (lookahead == '{') ADVANCE(62);
      if (lookahead == '}') ADVANCE(64);
      if (lookahead == '~') ADVANCE(147);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(56)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != '^' &&
          lookahead != '|') ADVANCE(188);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(136);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(135);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(93);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(93);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(122);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(121);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(142);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(169);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(169);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '\n') ADVANCE(88);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(169);
      if (lookahead != 0) ADVANCE(83);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(86);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(88);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(85);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(13);
      if (lookahead != 0) ADVANCE(86);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(85);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(13);
      if (lookahead != 0) ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(87);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(88);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '?') ADVANCE(144);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '?') ADVANCE(143);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(103);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(114);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(113);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '|') ADVANCE(116);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(115);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(148);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(148);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(149);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(149);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(154);
      if (lookahead == '/') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(153);
      if (lookahead == '/') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(154);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(154);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '\n') ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(161);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead == '/') ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(161);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(160);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(161);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '/') ADVANCE(159);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(23);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(188);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(164);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(166);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(169);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '/') ADVANCE(11);
      if (lookahead == '[') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(53);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(173);
      if (lookahead != 0) ADVANCE(174);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(53);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(174);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(23);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(175);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '`' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(188);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(185);
      if (lookahead == '0') ADVANCE(182);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(33);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(34);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(41);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(176);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(185);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == '_') ADVANCE(35);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(176);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == '_') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(186);
      if (lookahead != 0 &&
          lookahead > '~' &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(188);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '{') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '|' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(188);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(23);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == 'y') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      if (lookahead == 'w') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 25:
      if (lookahead == 'b') ADVANCE(64);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(68);
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(79);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(129);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 96:
      if (lookahead == 'h') ADVANCE(131);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 100:
      if (lookahead == 'k') ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 102:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 125:
      if (lookahead == 'w') ADVANCE(155);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 132:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 143:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(172);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 156:
      if (lookahead == 'f') ADVANCE(174);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 166:
      if (lookahead == 'y') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(182);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(186);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 189:
      if (lookahead == 'f') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 56},
  [2] = {.lex_state = 56},
  [3] = {.lex_state = 56},
  [4] = {.lex_state = 56},
  [5] = {.lex_state = 56},
  [6] = {.lex_state = 56},
  [7] = {.lex_state = 56},
  [8] = {.lex_state = 56},
  [9] = {.lex_state = 56},
  [10] = {.lex_state = 56},
  [11] = {.lex_state = 56},
  [12] = {.lex_state = 56},
  [13] = {.lex_state = 56},
  [14] = {.lex_state = 56},
  [15] = {.lex_state = 56},
  [16] = {.lex_state = 56},
  [17] = {.lex_state = 56},
  [18] = {.lex_state = 56},
  [19] = {.lex_state = 56},
  [20] = {.lex_state = 56},
  [21] = {.lex_state = 56},
  [22] = {.lex_state = 56},
  [23] = {.lex_state = 56},
  [24] = {.lex_state = 56},
  [25] = {.lex_state = 56},
  [26] = {.lex_state = 56},
  [27] = {.lex_state = 56},
  [28] = {.lex_state = 56},
  [29] = {.lex_state = 56},
  [30] = {.lex_state = 56},
  [31] = {.lex_state = 56},
  [32] = {.lex_state = 56},
  [33] = {.lex_state = 56},
  [34] = {.lex_state = 56},
  [35] = {.lex_state = 56},
  [36] = {.lex_state = 56},
  [37] = {.lex_state = 56},
  [38] = {.lex_state = 56},
  [39] = {.lex_state = 56},
  [40] = {.lex_state = 56},
  [41] = {.lex_state = 56},
  [42] = {.lex_state = 56},
  [43] = {.lex_state = 56},
  [44] = {.lex_state = 55},
  [45] = {.lex_state = 55, .external_lex_state = 2},
  [46] = {.lex_state = 55},
  [47] = {.lex_state = 55, .external_lex_state = 2},
  [48] = {.lex_state = 55, .external_lex_state = 2},
  [49] = {.lex_state = 55, .external_lex_state = 2},
  [50] = {.lex_state = 55, .external_lex_state = 2},
  [51] = {.lex_state = 55, .external_lex_state = 2},
  [52] = {.lex_state = 55, .external_lex_state = 2},
  [53] = {.lex_state = 55, .external_lex_state = 2},
  [54] = {.lex_state = 55, .external_lex_state = 2},
  [55] = {.lex_state = 55, .external_lex_state = 2},
  [56] = {.lex_state = 55, .external_lex_state = 2},
  [57] = {.lex_state = 55, .external_lex_state = 2},
  [58] = {.lex_state = 55, .external_lex_state = 2},
  [59] = {.lex_state = 55, .external_lex_state = 2},
  [60] = {.lex_state = 55, .external_lex_state = 2},
  [61] = {.lex_state = 55, .external_lex_state = 2},
  [62] = {.lex_state = 56},
  [63] = {.lex_state = 56},
  [64] = {.lex_state = 56},
  [65] = {.lex_state = 56},
  [66] = {.lex_state = 56},
  [67] = {.lex_state = 56},
  [68] = {.lex_state = 56},
  [69] = {.lex_state = 56},
  [70] = {.lex_state = 56},
  [71] = {.lex_state = 56},
  [72] = {.lex_state = 56},
  [73] = {.lex_state = 56},
  [74] = {.lex_state = 56},
  [75] = {.lex_state = 56},
  [76] = {.lex_state = 56},
  [77] = {.lex_state = 56},
  [78] = {.lex_state = 56},
  [79] = {.lex_state = 56},
  [80] = {.lex_state = 56},
  [81] = {.lex_state = 56},
  [82] = {.lex_state = 56},
  [83] = {.lex_state = 56},
  [84] = {.lex_state = 56, .external_lex_state = 2},
  [85] = {.lex_state = 56},
  [86] = {.lex_state = 56},
  [87] = {.lex_state = 56},
  [88] = {.lex_state = 56},
  [89] = {.lex_state = 4, .external_lex_state = 2},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 3},
  [92] = {.lex_state = 56},
  [93] = {.lex_state = 56},
  [94] = {.lex_state = 56},
  [95] = {.lex_state = 3},
  [96] = {.lex_state = 56},
  [97] = {.lex_state = 56},
  [98] = {.lex_state = 4, .external_lex_state = 2},
  [99] = {.lex_state = 56},
  [100] = {.lex_state = 56},
  [101] = {.lex_state = 56},
  [102] = {.lex_state = 4, .external_lex_state = 2},
  [103] = {.lex_state = 56},
  [104] = {.lex_state = 56},
  [105] = {.lex_state = 56},
  [106] = {.lex_state = 56},
  [107] = {.lex_state = 56},
  [108] = {.lex_state = 3},
  [109] = {.lex_state = 56},
  [110] = {.lex_state = 56},
  [111] = {.lex_state = 56},
  [112] = {.lex_state = 56},
  [113] = {.lex_state = 56},
  [114] = {.lex_state = 56},
  [115] = {.lex_state = 56},
  [116] = {.lex_state = 56},
  [117] = {.lex_state = 56},
  [118] = {.lex_state = 56},
  [119] = {.lex_state = 56},
  [120] = {.lex_state = 56},
  [121] = {.lex_state = 56},
  [122] = {.lex_state = 56},
  [123] = {.lex_state = 56},
  [124] = {.lex_state = 56},
  [125] = {.lex_state = 56},
  [126] = {.lex_state = 56},
  [127] = {.lex_state = 56},
  [128] = {.lex_state = 56},
  [129] = {.lex_state = 56},
  [130] = {.lex_state = 56},
  [131] = {.lex_state = 56},
  [132] = {.lex_state = 56},
  [133] = {.lex_state = 56},
  [134] = {.lex_state = 56},
  [135] = {.lex_state = 56},
  [136] = {.lex_state = 56},
  [137] = {.lex_state = 56},
  [138] = {.lex_state = 56},
  [139] = {.lex_state = 56},
  [140] = {.lex_state = 56},
  [141] = {.lex_state = 56},
  [142] = {.lex_state = 56},
  [143] = {.lex_state = 56},
  [144] = {.lex_state = 56},
  [145] = {.lex_state = 56},
  [146] = {.lex_state = 56},
  [147] = {.lex_state = 56},
  [148] = {.lex_state = 56},
  [149] = {.lex_state = 56},
  [150] = {.lex_state = 56},
  [151] = {.lex_state = 56},
  [152] = {.lex_state = 56},
  [153] = {.lex_state = 56},
  [154] = {.lex_state = 56},
  [155] = {.lex_state = 56},
  [156] = {.lex_state = 56},
  [157] = {.lex_state = 56},
  [158] = {.lex_state = 56},
  [159] = {.lex_state = 56},
  [160] = {.lex_state = 56},
  [161] = {.lex_state = 56},
  [162] = {.lex_state = 56},
  [163] = {.lex_state = 56},
  [164] = {.lex_state = 56},
  [165] = {.lex_state = 56},
  [166] = {.lex_state = 56},
  [167] = {.lex_state = 56},
  [168] = {.lex_state = 56},
  [169] = {.lex_state = 56},
  [170] = {.lex_state = 56},
  [171] = {.lex_state = 56},
  [172] = {.lex_state = 56},
  [173] = {.lex_state = 56},
  [174] = {.lex_state = 56},
  [175] = {.lex_state = 56},
  [176] = {.lex_state = 56},
  [177] = {.lex_state = 56},
  [178] = {.lex_state = 56},
  [179] = {.lex_state = 56},
  [180] = {.lex_state = 56},
  [181] = {.lex_state = 56},
  [182] = {.lex_state = 56},
  [183] = {.lex_state = 56},
  [184] = {.lex_state = 56},
  [185] = {.lex_state = 56},
  [186] = {.lex_state = 56},
  [187] = {.lex_state = 56},
  [188] = {.lex_state = 56},
  [189] = {.lex_state = 56},
  [190] = {.lex_state = 56},
  [191] = {.lex_state = 56},
  [192] = {.lex_state = 56},
  [193] = {.lex_state = 56},
  [194] = {.lex_state = 56},
  [195] = {.lex_state = 56},
  [196] = {.lex_state = 4, .external_lex_state = 2},
  [197] = {.lex_state = 4, .external_lex_state = 2},
  [198] = {.lex_state = 4, .external_lex_state = 2},
  [199] = {.lex_state = 4, .external_lex_state = 2},
  [200] = {.lex_state = 4, .external_lex_state = 2},
  [201] = {.lex_state = 4, .external_lex_state = 2},
  [202] = {.lex_state = 4, .external_lex_state = 2},
  [203] = {.lex_state = 4, .external_lex_state = 2},
  [204] = {.lex_state = 4, .external_lex_state = 2},
  [205] = {.lex_state = 4, .external_lex_state = 2},
  [206] = {.lex_state = 4, .external_lex_state = 2},
  [207] = {.lex_state = 56, .external_lex_state = 2},
  [208] = {.lex_state = 56, .external_lex_state = 2},
  [209] = {.lex_state = 4},
  [210] = {.lex_state = 4},
  [211] = {.lex_state = 4, .external_lex_state = 2},
  [212] = {.lex_state = 56},
  [213] = {.lex_state = 4, .external_lex_state = 2},
  [214] = {.lex_state = 4, .external_lex_state = 2},
  [215] = {.lex_state = 56},
  [216] = {.lex_state = 56},
  [217] = {.lex_state = 4, .external_lex_state = 2},
  [218] = {.lex_state = 4, .external_lex_state = 2},
  [219] = {.lex_state = 4},
  [220] = {.lex_state = 56},
  [221] = {.lex_state = 4},
  [222] = {.lex_state = 4},
  [223] = {.lex_state = 4},
  [224] = {.lex_state = 56, .external_lex_state = 2},
  [225] = {.lex_state = 56},
  [226] = {.lex_state = 56},
  [227] = {.lex_state = 56, .external_lex_state = 2},
  [228] = {.lex_state = 56},
  [229] = {.lex_state = 56, .external_lex_state = 2},
  [230] = {.lex_state = 4},
  [231] = {.lex_state = 56, .external_lex_state = 2},
  [232] = {.lex_state = 56, .external_lex_state = 2},
  [233] = {.lex_state = 56},
  [234] = {.lex_state = 56, .external_lex_state = 2},
  [235] = {.lex_state = 56, .external_lex_state = 2},
  [236] = {.lex_state = 56, .external_lex_state = 2},
  [237] = {.lex_state = 56, .external_lex_state = 2},
  [238] = {.lex_state = 56, .external_lex_state = 2},
  [239] = {.lex_state = 56, .external_lex_state = 2},
  [240] = {.lex_state = 56},
  [241] = {.lex_state = 56, .external_lex_state = 2},
  [242] = {.lex_state = 56, .external_lex_state = 2},
  [243] = {.lex_state = 56, .external_lex_state = 2},
  [244] = {.lex_state = 56},
  [245] = {.lex_state = 56},
  [246] = {.lex_state = 56},
  [247] = {.lex_state = 56},
  [248] = {.lex_state = 56},
  [249] = {.lex_state = 56},
  [250] = {.lex_state = 56},
  [251] = {.lex_state = 56},
  [252] = {.lex_state = 56},
  [253] = {.lex_state = 56},
  [254] = {.lex_state = 56},
  [255] = {.lex_state = 56},
  [256] = {.lex_state = 56},
  [257] = {.lex_state = 56},
  [258] = {.lex_state = 56},
  [259] = {.lex_state = 56},
  [260] = {.lex_state = 56},
  [261] = {.lex_state = 56},
  [262] = {.lex_state = 56},
  [263] = {.lex_state = 56},
  [264] = {.lex_state = 56},
  [265] = {.lex_state = 56},
  [266] = {.lex_state = 56},
  [267] = {.lex_state = 56},
  [268] = {.lex_state = 56},
  [269] = {.lex_state = 56},
  [270] = {.lex_state = 56},
  [271] = {.lex_state = 56},
  [272] = {.lex_state = 56},
  [273] = {.lex_state = 56},
  [274] = {.lex_state = 56},
  [275] = {.lex_state = 56},
  [276] = {.lex_state = 56},
  [277] = {.lex_state = 56},
  [278] = {.lex_state = 56},
  [279] = {.lex_state = 56},
  [280] = {.lex_state = 56},
  [281] = {.lex_state = 56},
  [282] = {.lex_state = 56},
  [283] = {.lex_state = 56},
  [284] = {.lex_state = 56},
  [285] = {.lex_state = 56},
  [286] = {.lex_state = 56},
  [287] = {.lex_state = 56},
  [288] = {.lex_state = 56},
  [289] = {.lex_state = 4, .external_lex_state = 2},
  [290] = {.lex_state = 4, .external_lex_state = 2},
  [291] = {.lex_state = 4, .external_lex_state = 2},
  [292] = {.lex_state = 4},
  [293] = {.lex_state = 4},
  [294] = {.lex_state = 4},
  [295] = {.lex_state = 4},
  [296] = {.lex_state = 4},
  [297] = {.lex_state = 4},
  [298] = {.lex_state = 4},
  [299] = {.lex_state = 4},
  [300] = {.lex_state = 4},
  [301] = {.lex_state = 4, .external_lex_state = 2},
  [302] = {.lex_state = 4, .external_lex_state = 2},
  [303] = {.lex_state = 4, .external_lex_state = 2},
  [304] = {.lex_state = 4, .external_lex_state = 2},
  [305] = {.lex_state = 4, .external_lex_state = 2},
  [306] = {.lex_state = 4, .external_lex_state = 2},
  [307] = {.lex_state = 4, .external_lex_state = 2},
  [308] = {.lex_state = 4, .external_lex_state = 2},
  [309] = {.lex_state = 4, .external_lex_state = 2},
  [310] = {.lex_state = 4, .external_lex_state = 2},
  [311] = {.lex_state = 4, .external_lex_state = 2},
  [312] = {.lex_state = 4, .external_lex_state = 2},
  [313] = {.lex_state = 4},
  [314] = {.lex_state = 4, .external_lex_state = 2},
  [315] = {.lex_state = 4, .external_lex_state = 2},
  [316] = {.lex_state = 4, .external_lex_state = 2},
  [317] = {.lex_state = 4},
  [318] = {.lex_state = 56},
  [319] = {.lex_state = 56},
  [320] = {.lex_state = 56},
  [321] = {.lex_state = 4, .external_lex_state = 2},
  [322] = {.lex_state = 56},
  [323] = {.lex_state = 4, .external_lex_state = 2},
  [324] = {.lex_state = 4},
  [325] = {.lex_state = 4},
  [326] = {.lex_state = 4},
  [327] = {.lex_state = 4},
  [328] = {.lex_state = 4},
  [329] = {.lex_state = 4},
  [330] = {.lex_state = 4},
  [331] = {.lex_state = 4},
  [332] = {.lex_state = 4},
  [333] = {.lex_state = 4},
  [334] = {.lex_state = 4},
  [335] = {.lex_state = 55},
  [336] = {.lex_state = 55},
  [337] = {.lex_state = 55},
  [338] = {.lex_state = 4},
  [339] = {.lex_state = 55, .external_lex_state = 2},
  [340] = {.lex_state = 55},
  [341] = {.lex_state = 55},
  [342] = {.lex_state = 55},
  [343] = {.lex_state = 55},
  [344] = {.lex_state = 55, .external_lex_state = 2},
  [345] = {.lex_state = 55},
  [346] = {.lex_state = 55},
  [347] = {.lex_state = 55},
  [348] = {.lex_state = 55},
  [349] = {.lex_state = 55},
  [350] = {.lex_state = 55},
  [351] = {.lex_state = 55, .external_lex_state = 2},
  [352] = {.lex_state = 55},
  [353] = {.lex_state = 55, .external_lex_state = 2},
  [354] = {.lex_state = 55},
  [355] = {.lex_state = 55},
  [356] = {.lex_state = 55},
  [357] = {.lex_state = 55},
  [358] = {.lex_state = 55},
  [359] = {.lex_state = 55},
  [360] = {.lex_state = 55},
  [361] = {.lex_state = 5},
  [362] = {.lex_state = 55},
  [363] = {.lex_state = 55},
  [364] = {.lex_state = 55},
  [365] = {.lex_state = 55},
  [366] = {.lex_state = 55},
  [367] = {.lex_state = 55},
  [368] = {.lex_state = 55},
  [369] = {.lex_state = 55},
  [370] = {.lex_state = 55},
  [371] = {.lex_state = 55},
  [372] = {.lex_state = 55},
  [373] = {.lex_state = 55},
  [374] = {.lex_state = 55},
  [375] = {.lex_state = 55},
  [376] = {.lex_state = 55},
  [377] = {.lex_state = 55},
  [378] = {.lex_state = 55},
  [379] = {.lex_state = 55},
  [380] = {.lex_state = 55},
  [381] = {.lex_state = 55},
  [382] = {.lex_state = 55},
  [383] = {.lex_state = 55},
  [384] = {.lex_state = 55},
  [385] = {.lex_state = 55},
  [386] = {.lex_state = 55},
  [387] = {.lex_state = 55},
  [388] = {.lex_state = 55},
  [389] = {.lex_state = 55, .external_lex_state = 2},
  [390] = {.lex_state = 55, .external_lex_state = 2},
  [391] = {.lex_state = 55},
  [392] = {.lex_state = 55, .external_lex_state = 2},
  [393] = {.lex_state = 55, .external_lex_state = 2},
  [394] = {.lex_state = 55, .external_lex_state = 2},
  [395] = {.lex_state = 55},
  [396] = {.lex_state = 55},
  [397] = {.lex_state = 55},
  [398] = {.lex_state = 55, .external_lex_state = 2},
  [399] = {.lex_state = 55, .external_lex_state = 2},
  [400] = {.lex_state = 55},
  [401] = {.lex_state = 55},
  [402] = {.lex_state = 55, .external_lex_state = 2},
  [403] = {.lex_state = 55},
  [404] = {.lex_state = 55, .external_lex_state = 2},
  [405] = {.lex_state = 55},
  [406] = {.lex_state = 55, .external_lex_state = 2},
  [407] = {.lex_state = 55, .external_lex_state = 2},
  [408] = {.lex_state = 55, .external_lex_state = 2},
  [409] = {.lex_state = 55, .external_lex_state = 2},
  [410] = {.lex_state = 55, .external_lex_state = 2},
  [411] = {.lex_state = 55, .external_lex_state = 2},
  [412] = {.lex_state = 55, .external_lex_state = 2},
  [413] = {.lex_state = 55},
  [414] = {.lex_state = 55},
  [415] = {.lex_state = 55},
  [416] = {.lex_state = 55},
  [417] = {.lex_state = 55},
  [418] = {.lex_state = 55},
  [419] = {.lex_state = 55, .external_lex_state = 2},
  [420] = {.lex_state = 55},
  [421] = {.lex_state = 55, .external_lex_state = 2},
  [422] = {.lex_state = 55, .external_lex_state = 2},
  [423] = {.lex_state = 55},
  [424] = {.lex_state = 55},
  [425] = {.lex_state = 55, .external_lex_state = 2},
  [426] = {.lex_state = 55},
  [427] = {.lex_state = 55},
  [428] = {.lex_state = 55, .external_lex_state = 2},
  [429] = {.lex_state = 55},
  [430] = {.lex_state = 55},
  [431] = {.lex_state = 55},
  [432] = {.lex_state = 55},
  [433] = {.lex_state = 55},
  [434] = {.lex_state = 55, .external_lex_state = 2},
  [435] = {.lex_state = 55},
  [436] = {.lex_state = 55},
  [437] = {.lex_state = 55, .external_lex_state = 2},
  [438] = {.lex_state = 55, .external_lex_state = 2},
  [439] = {.lex_state = 55},
  [440] = {.lex_state = 55, .external_lex_state = 2},
  [441] = {.lex_state = 55},
  [442] = {.lex_state = 55},
  [443] = {.lex_state = 55, .external_lex_state = 2},
  [444] = {.lex_state = 55, .external_lex_state = 2},
  [445] = {.lex_state = 55},
  [446] = {.lex_state = 55},
  [447] = {.lex_state = 55},
  [448] = {.lex_state = 55},
  [449] = {.lex_state = 55, .external_lex_state = 2},
  [450] = {.lex_state = 55},
  [451] = {.lex_state = 55},
  [452] = {.lex_state = 55},
  [453] = {.lex_state = 55},
  [454] = {.lex_state = 55, .external_lex_state = 2},
  [455] = {.lex_state = 55},
  [456] = {.lex_state = 55},
  [457] = {.lex_state = 55, .external_lex_state = 2},
  [458] = {.lex_state = 55},
  [459] = {.lex_state = 55, .external_lex_state = 2},
  [460] = {.lex_state = 55},
  [461] = {.lex_state = 55, .external_lex_state = 2},
  [462] = {.lex_state = 55, .external_lex_state = 2},
  [463] = {.lex_state = 55},
  [464] = {.lex_state = 55, .external_lex_state = 2},
  [465] = {.lex_state = 55, .external_lex_state = 2},
  [466] = {.lex_state = 55, .external_lex_state = 2},
  [467] = {.lex_state = 55, .external_lex_state = 2},
  [468] = {.lex_state = 55, .external_lex_state = 2},
  [469] = {.lex_state = 55, .external_lex_state = 2},
  [470] = {.lex_state = 55, .external_lex_state = 2},
  [471] = {.lex_state = 55},
  [472] = {.lex_state = 55, .external_lex_state = 2},
  [473] = {.lex_state = 55, .external_lex_state = 2},
  [474] = {.lex_state = 55, .external_lex_state = 2},
  [475] = {.lex_state = 55, .external_lex_state = 2},
  [476] = {.lex_state = 55, .external_lex_state = 2},
  [477] = {.lex_state = 55, .external_lex_state = 2},
  [478] = {.lex_state = 55, .external_lex_state = 2},
  [479] = {.lex_state = 55, .external_lex_state = 2},
  [480] = {.lex_state = 55},
  [481] = {.lex_state = 5, .external_lex_state = 2},
  [482] = {.lex_state = 55, .external_lex_state = 2},
  [483] = {.lex_state = 55, .external_lex_state = 2},
  [484] = {.lex_state = 55},
  [485] = {.lex_state = 55},
  [486] = {.lex_state = 55, .external_lex_state = 2},
  [487] = {.lex_state = 55},
  [488] = {.lex_state = 55},
  [489] = {.lex_state = 55, .external_lex_state = 2},
  [490] = {.lex_state = 55, .external_lex_state = 2},
  [491] = {.lex_state = 55, .external_lex_state = 2},
  [492] = {.lex_state = 55, .external_lex_state = 2},
  [493] = {.lex_state = 55, .external_lex_state = 2},
  [494] = {.lex_state = 55, .external_lex_state = 2},
  [495] = {.lex_state = 55, .external_lex_state = 2},
  [496] = {.lex_state = 55, .external_lex_state = 2},
  [497] = {.lex_state = 55, .external_lex_state = 2},
  [498] = {.lex_state = 55, .external_lex_state = 2},
  [499] = {.lex_state = 55},
  [500] = {.lex_state = 55, .external_lex_state = 2},
  [501] = {.lex_state = 55, .external_lex_state = 2},
  [502] = {.lex_state = 55},
  [503] = {.lex_state = 55},
  [504] = {.lex_state = 55, .external_lex_state = 2},
  [505] = {.lex_state = 55, .external_lex_state = 2},
  [506] = {.lex_state = 55, .external_lex_state = 2},
  [507] = {.lex_state = 55, .external_lex_state = 2},
  [508] = {.lex_state = 55, .external_lex_state = 2},
  [509] = {.lex_state = 55},
  [510] = {.lex_state = 55, .external_lex_state = 2},
  [511] = {.lex_state = 55},
  [512] = {.lex_state = 55},
  [513] = {.lex_state = 55, .external_lex_state = 2},
  [514] = {.lex_state = 55, .external_lex_state = 2},
  [515] = {.lex_state = 55, .external_lex_state = 2},
  [516] = {.lex_state = 55, .external_lex_state = 2},
  [517] = {.lex_state = 55, .external_lex_state = 2},
  [518] = {.lex_state = 55},
  [519] = {.lex_state = 55},
  [520] = {.lex_state = 55, .external_lex_state = 2},
  [521] = {.lex_state = 55},
  [522] = {.lex_state = 55, .external_lex_state = 2},
  [523] = {.lex_state = 55, .external_lex_state = 2},
  [524] = {.lex_state = 55},
  [525] = {.lex_state = 55},
  [526] = {.lex_state = 55},
  [527] = {.lex_state = 55},
  [528] = {.lex_state = 55},
  [529] = {.lex_state = 55, .external_lex_state = 2},
  [530] = {.lex_state = 55, .external_lex_state = 2},
  [531] = {.lex_state = 55, .external_lex_state = 2},
  [532] = {.lex_state = 55},
  [533] = {.lex_state = 55},
  [534] = {.lex_state = 55},
  [535] = {.lex_state = 55, .external_lex_state = 2},
  [536] = {.lex_state = 55, .external_lex_state = 2},
  [537] = {.lex_state = 55},
  [538] = {.lex_state = 55, .external_lex_state = 2},
  [539] = {.lex_state = 55},
  [540] = {.lex_state = 55},
  [541] = {.lex_state = 55, .external_lex_state = 2},
  [542] = {.lex_state = 55},
  [543] = {.lex_state = 55},
  [544] = {.lex_state = 55, .external_lex_state = 2},
  [545] = {.lex_state = 55, .external_lex_state = 2},
  [546] = {.lex_state = 55, .external_lex_state = 2},
  [547] = {.lex_state = 55},
  [548] = {.lex_state = 55},
  [549] = {.lex_state = 55, .external_lex_state = 2},
  [550] = {.lex_state = 55},
  [551] = {.lex_state = 55},
  [552] = {.lex_state = 55, .external_lex_state = 2},
  [553] = {.lex_state = 55, .external_lex_state = 2},
  [554] = {.lex_state = 55, .external_lex_state = 2},
  [555] = {.lex_state = 55, .external_lex_state = 2},
  [556] = {.lex_state = 55, .external_lex_state = 2},
  [557] = {.lex_state = 55, .external_lex_state = 2},
  [558] = {.lex_state = 55, .external_lex_state = 2},
  [559] = {.lex_state = 55, .external_lex_state = 2},
  [560] = {.lex_state = 55},
  [561] = {.lex_state = 55, .external_lex_state = 2},
  [562] = {.lex_state = 55},
  [563] = {.lex_state = 55, .external_lex_state = 2},
  [564] = {.lex_state = 55},
  [565] = {.lex_state = 55, .external_lex_state = 2},
  [566] = {.lex_state = 55},
  [567] = {.lex_state = 55, .external_lex_state = 2},
  [568] = {.lex_state = 55},
  [569] = {.lex_state = 55},
  [570] = {.lex_state = 55, .external_lex_state = 2},
  [571] = {.lex_state = 55},
  [572] = {.lex_state = 55, .external_lex_state = 2},
  [573] = {.lex_state = 55},
  [574] = {.lex_state = 55},
  [575] = {.lex_state = 55},
  [576] = {.lex_state = 55},
  [577] = {.lex_state = 55, .external_lex_state = 2},
  [578] = {.lex_state = 55},
  [579] = {.lex_state = 55},
  [580] = {.lex_state = 55},
  [581] = {.lex_state = 55},
  [582] = {.lex_state = 55},
  [583] = {.lex_state = 55},
  [584] = {.lex_state = 55},
  [585] = {.lex_state = 55},
  [586] = {.lex_state = 55},
  [587] = {.lex_state = 55},
  [588] = {.lex_state = 55},
  [589] = {.lex_state = 55},
  [590] = {.lex_state = 55},
  [591] = {.lex_state = 55},
  [592] = {.lex_state = 56},
  [593] = {.lex_state = 56},
  [594] = {.lex_state = 56},
  [595] = {.lex_state = 56},
  [596] = {.lex_state = 56},
  [597] = {.lex_state = 56},
  [598] = {.lex_state = 56},
  [599] = {.lex_state = 56},
  [600] = {.lex_state = 56},
  [601] = {.lex_state = 56},
  [602] = {.lex_state = 56},
  [603] = {.lex_state = 56},
  [604] = {.lex_state = 56},
  [605] = {.lex_state = 56},
  [606] = {.lex_state = 56},
  [607] = {.lex_state = 56},
  [608] = {.lex_state = 56},
  [609] = {.lex_state = 56},
  [610] = {.lex_state = 56},
  [611] = {.lex_state = 56},
  [612] = {.lex_state = 56},
  [613] = {.lex_state = 56},
  [614] = {.lex_state = 56},
  [615] = {.lex_state = 56},
  [616] = {.lex_state = 56},
  [617] = {.lex_state = 56},
  [618] = {.lex_state = 56},
  [619] = {.lex_state = 56},
  [620] = {.lex_state = 56},
  [621] = {.lex_state = 56},
  [622] = {.lex_state = 56},
  [623] = {.lex_state = 56},
  [624] = {.lex_state = 56},
  [625] = {.lex_state = 56},
  [626] = {.lex_state = 56},
  [627] = {.lex_state = 56},
  [628] = {.lex_state = 56},
  [629] = {.lex_state = 56},
  [630] = {.lex_state = 56},
  [631] = {.lex_state = 56, .external_lex_state = 2},
  [632] = {.lex_state = 56},
  [633] = {.lex_state = 56},
  [634] = {.lex_state = 56},
  [635] = {.lex_state = 56, .external_lex_state = 2},
  [636] = {.lex_state = 56},
  [637] = {.lex_state = 56, .external_lex_state = 2},
  [638] = {.lex_state = 56},
  [639] = {.lex_state = 56},
  [640] = {.lex_state = 56, .external_lex_state = 2},
  [641] = {.lex_state = 56},
  [642] = {.lex_state = 56},
  [643] = {.lex_state = 56},
  [644] = {.lex_state = 56, .external_lex_state = 2},
  [645] = {.lex_state = 55},
  [646] = {.lex_state = 56},
  [647] = {.lex_state = 56},
  [648] = {.lex_state = 56},
  [649] = {.lex_state = 56},
  [650] = {.lex_state = 56},
  [651] = {.lex_state = 56},
  [652] = {.lex_state = 56},
  [653] = {.lex_state = 4},
  [654] = {.lex_state = 56},
  [655] = {.lex_state = 56},
  [656] = {.lex_state = 55},
  [657] = {.lex_state = 4},
  [658] = {.lex_state = 56},
  [659] = {.lex_state = 56},
  [660] = {.lex_state = 56},
  [661] = {.lex_state = 4},
  [662] = {.lex_state = 56},
  [663] = {.lex_state = 56},
  [664] = {.lex_state = 56},
  [665] = {.lex_state = 56},
  [666] = {.lex_state = 56},
  [667] = {.lex_state = 56},
  [668] = {.lex_state = 56},
  [669] = {.lex_state = 56},
  [670] = {.lex_state = 56},
  [671] = {.lex_state = 56},
  [672] = {.lex_state = 56},
  [673] = {.lex_state = 56},
  [674] = {.lex_state = 56},
  [675] = {.lex_state = 56},
  [676] = {.lex_state = 56},
  [677] = {.lex_state = 56},
  [678] = {.lex_state = 56},
  [679] = {.lex_state = 16},
  [680] = {.lex_state = 16},
  [681] = {.lex_state = 16},
  [682] = {.lex_state = 16},
  [683] = {.lex_state = 17},
  [684] = {.lex_state = 16},
  [685] = {.lex_state = 16},
  [686] = {.lex_state = 17},
  [687] = {.lex_state = 16},
  [688] = {.lex_state = 17},
  [689] = {.lex_state = 16},
  [690] = {.lex_state = 17},
  [691] = {.lex_state = 17},
  [692] = {.lex_state = 16},
  [693] = {.lex_state = 16},
  [694] = {.lex_state = 16},
  [695] = {.lex_state = 16},
  [696] = {.lex_state = 17},
  [697] = {.lex_state = 17},
  [698] = {.lex_state = 17},
  [699] = {.lex_state = 56},
  [700] = {.lex_state = 56},
  [701] = {.lex_state = 17},
  [702] = {.lex_state = 16},
  [703] = {.lex_state = 16},
  [704] = {.lex_state = 17},
  [705] = {.lex_state = 17},
  [706] = {.lex_state = 16},
  [707] = {.lex_state = 17},
  [708] = {.lex_state = 17},
  [709] = {.lex_state = 16},
  [710] = {.lex_state = 16},
  [711] = {.lex_state = 16},
  [712] = {.lex_state = 16},
  [713] = {.lex_state = 17},
  [714] = {.lex_state = 16},
  [715] = {.lex_state = 17},
  [716] = {.lex_state = 16},
  [717] = {.lex_state = 17},
  [718] = {.lex_state = 17},
  [719] = {.lex_state = 56},
  [720] = {.lex_state = 56},
  [721] = {.lex_state = 56},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 56},
  [725] = {.lex_state = 56},
  [726] = {.lex_state = 56},
  [727] = {.lex_state = 56},
  [728] = {.lex_state = 56},
  [729] = {.lex_state = 56},
  [730] = {.lex_state = 56},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 56},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 56},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 56},
  [737] = {.lex_state = 16},
  [738] = {.lex_state = 56, .external_lex_state = 2},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 16},
  [741] = {.lex_state = 56, .external_lex_state = 2},
  [742] = {.lex_state = 8, .external_lex_state = 3},
  [743] = {.lex_state = 0, .external_lex_state = 2},
  [744] = {.lex_state = 16},
  [745] = {.lex_state = 16},
  [746] = {.lex_state = 56},
  [747] = {.lex_state = 8, .external_lex_state = 3},
  [748] = {.lex_state = 8, .external_lex_state = 3},
  [749] = {.lex_state = 16},
  [750] = {.lex_state = 16},
  [751] = {.lex_state = 16},
  [752] = {.lex_state = 56},
  [753] = {.lex_state = 16},
  [754] = {.lex_state = 56, .external_lex_state = 2},
  [755] = {.lex_state = 16},
  [756] = {.lex_state = 16},
  [757] = {.lex_state = 8, .external_lex_state = 3},
  [758] = {.lex_state = 8, .external_lex_state = 3},
  [759] = {.lex_state = 16},
  [760] = {.lex_state = 16},
  [761] = {.lex_state = 56, .external_lex_state = 2},
  [762] = {.lex_state = 0, .external_lex_state = 2},
  [763] = {.lex_state = 16},
  [764] = {.lex_state = 16},
  [765] = {.lex_state = 56, .external_lex_state = 2},
  [766] = {.lex_state = 56, .external_lex_state = 2},
  [767] = {.lex_state = 56, .external_lex_state = 2},
  [768] = {.lex_state = 56},
  [769] = {.lex_state = 56},
  [770] = {.lex_state = 56, .external_lex_state = 2},
  [771] = {.lex_state = 56, .external_lex_state = 2},
  [772] = {.lex_state = 16},
  [773] = {.lex_state = 16},
  [774] = {.lex_state = 56},
  [775] = {.lex_state = 56},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0, .external_lex_state = 2},
  [778] = {.lex_state = 56},
  [779] = {.lex_state = 16},
  [780] = {.lex_state = 16},
  [781] = {.lex_state = 56},
  [782] = {.lex_state = 16},
  [783] = {.lex_state = 16},
  [784] = {.lex_state = 16},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 56},
  [787] = {.lex_state = 16},
  [788] = {.lex_state = 16},
  [789] = {.lex_state = 16},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 16},
  [792] = {.lex_state = 16},
  [793] = {.lex_state = 16},
  [794] = {.lex_state = 16},
  [795] = {.lex_state = 56},
  [796] = {.lex_state = 16},
  [797] = {.lex_state = 16},
  [798] = {.lex_state = 16},
  [799] = {.lex_state = 56},
  [800] = {.lex_state = 16},
  [801] = {.lex_state = 56},
  [802] = {.lex_state = 16},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 56},
  [805] = {.lex_state = 16},
  [806] = {.lex_state = 56},
  [807] = {.lex_state = 56},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 56},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 56, .external_lex_state = 2},
  [812] = {.lex_state = 10},
  [813] = {.lex_state = 56},
  [814] = {.lex_state = 56},
  [815] = {.lex_state = 56},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 56},
  [818] = {.lex_state = 56},
  [819] = {.lex_state = 7},
  [820] = {.lex_state = 56},
  [821] = {.lex_state = 0, .external_lex_state = 2},
  [822] = {.lex_state = 8, .external_lex_state = 3},
  [823] = {.lex_state = 56},
  [824] = {.lex_state = 10},
  [825] = {.lex_state = 56},
  [826] = {.lex_state = 56},
  [827] = {.lex_state = 7},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 10},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 56},
  [832] = {.lex_state = 16},
  [833] = {.lex_state = 56},
  [834] = {.lex_state = 10},
  [835] = {.lex_state = 56},
  [836] = {.lex_state = 56},
  [837] = {.lex_state = 0, .external_lex_state = 2},
  [838] = {.lex_state = 0, .external_lex_state = 2},
  [839] = {.lex_state = 0, .external_lex_state = 2},
  [840] = {.lex_state = 0, .external_lex_state = 2},
  [841] = {.lex_state = 56},
  [842] = {.lex_state = 0, .external_lex_state = 2},
  [843] = {.lex_state = 16},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 56},
  [847] = {.lex_state = 56},
  [848] = {.lex_state = 56},
  [849] = {.lex_state = 7},
  [850] = {.lex_state = 56},
  [851] = {.lex_state = 16},
  [852] = {.lex_state = 56},
  [853] = {.lex_state = 56},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 7},
  [856] = {.lex_state = 56},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 56},
  [859] = {.lex_state = 0, .external_lex_state = 2},
  [860] = {.lex_state = 7},
  [861] = {.lex_state = 10},
  [862] = {.lex_state = 7},
  [863] = {.lex_state = 56},
  [864] = {.lex_state = 16},
  [865] = {.lex_state = 56},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 7},
  [868] = {.lex_state = 10},
  [869] = {.lex_state = 56},
  [870] = {.lex_state = 56},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 56},
  [873] = {.lex_state = 56},
  [874] = {.lex_state = 10},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 17},
  [878] = {.lex_state = 17},
  [879] = {.lex_state = 17},
  [880] = {.lex_state = 56},
  [881] = {.lex_state = 56, .external_lex_state = 2},
  [882] = {.lex_state = 17},
  [883] = {.lex_state = 17},
  [884] = {.lex_state = 17},
  [885] = {.lex_state = 56, .external_lex_state = 2},
  [886] = {.lex_state = 56},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 56},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 56},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 56},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 56, .external_lex_state = 2},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 56},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 56},
  [913] = {.lex_state = 56},
  [914] = {.lex_state = 56},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 17},
  [917] = {.lex_state = 56, .external_lex_state = 2},
  [918] = {.lex_state = 56},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 56},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 3},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0, .external_lex_state = 2},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 56},
  [937] = {.lex_state = 56},
  [938] = {.lex_state = 56},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 3},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 56, .external_lex_state = 2},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 17},
  [951] = {.lex_state = 56},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 56},
  [957] = {.lex_state = 17},
  [958] = {.lex_state = 56, .external_lex_state = 2},
  [959] = {.lex_state = 56, .external_lex_state = 2},
  [960] = {.lex_state = 56},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 56},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0, .external_lex_state = 2},
  [966] = {.lex_state = 56},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 3},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 17},
  [972] = {.lex_state = 3},
  [973] = {.lex_state = 17},
  [974] = {.lex_state = 0, .external_lex_state = 2},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 56},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 56},
  [983] = {.lex_state = 56},
  [984] = {.lex_state = 56},
  [985] = {.lex_state = 3},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0, .external_lex_state = 2},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0, .external_lex_state = 2},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0, .external_lex_state = 2},
  [1012] = {.lex_state = 3},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 56},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0, .external_lex_state = 2},
  [1031] = {.lex_state = 56},
  [1032] = {.lex_state = 0, .external_lex_state = 2},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 56},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0, .external_lex_state = 2},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 56},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 56},
  [1045] = {.lex_state = 0, .external_lex_state = 2},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0, .external_lex_state = 2},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 16},
  [1057] = {.lex_state = 56},
  [1058] = {.lex_state = 0, .external_lex_state = 2},
  [1059] = {.lex_state = 0, .external_lex_state = 2},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0, .external_lex_state = 2},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0, .external_lex_state = 2},
  [1073] = {.lex_state = 56},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 3},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0, .external_lex_state = 2},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 56},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 3},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 56},
  [1100] = {.lex_state = 0, .external_lex_state = 2},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 56},
  [1103] = {.lex_state = 56},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 56},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 56},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 56},
  [1123] = {.lex_state = 1},
  [1124] = {.lex_state = 56},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 56},
  [1133] = {.lex_state = 56},
  [1134] = {.lex_state = 56},
  [1135] = {.lex_state = 56},
  [1136] = {.lex_state = 56},
  [1137] = {.lex_state = 56},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 56},
  [1140] = {.lex_state = 56},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 56},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 56},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 8},
  [1149] = {.lex_state = 8},
  [1150] = {.lex_state = 56},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 56},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 56},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 56},
  [1159] = {.lex_state = 56},
  [1160] = {.lex_state = 56},
  [1161] = {.lex_state = 56},
  [1162] = {.lex_state = 56},
  [1163] = {.lex_state = 56},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 56},
  [1166] = {.lex_state = 56},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 56},
  [1171] = {.lex_state = 56},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 56},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 56},
  [1177] = {.lex_state = 56},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 0},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 56},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 56},
  [1185] = {.lex_state = 56},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 56},
  [1189] = {.lex_state = 56},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 56},
  [1192] = {.lex_state = 0},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 56},
  [1195] = {.lex_state = 56},
  [1196] = {.lex_state = 56},
  [1197] = {.lex_state = 56},
  [1198] = {.lex_state = 1},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 56},
  [1201] = {.lex_state = 56},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 56},
  [1204] = {.lex_state = 56},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 56},
  [1208] = {.lex_state = 56},
  [1209] = {.lex_state = 56},
  [1210] = {.lex_state = 56},
  [1211] = {.lex_state = 56},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
};

static bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [3] = {
    [ts_external_token__template_chars] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1192),
    [sym_export_statement] = STATE(16),
    [sym_declaration] = STATE(16),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_try_statement] = STATE(16),
    [sym_with_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_debugger_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_throw_statement] = STATE(16),
    [sym_empty_statement] = STATE(16),
    [sym_labeled_statement] = STATE(16),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [2] = {
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1181),
    [sym_object_assignment_pattern] = STATE(897),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1181),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1181),
    [sym_spread_element] = STATE(898),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(507),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [sym_rest_pattern] = STATE(897),
    [sym_method_definition] = STATE(898),
    [sym_pair] = STATE(898),
    [sym_pair_pattern] = STATE(897),
    [sym__property_name] = STATE(899),
    [sym_computed_property_name] = STATE(899),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(630),
    [aux_sym_object_repeat1] = STATE(900),
    [aux_sym_object_pattern_repeat1] = STATE(901),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(109),
    [anon_sym_set] = ACTIONS(109),
  },
  [3] = {
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1181),
    [sym_object_assignment_pattern] = STATE(897),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1181),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1181),
    [sym_spread_element] = STATE(898),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(507),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [sym_rest_pattern] = STATE(897),
    [sym_method_definition] = STATE(898),
    [sym_pair] = STATE(898),
    [sym_pair_pattern] = STATE(897),
    [sym__property_name] = STATE(899),
    [sym_computed_property_name] = STATE(899),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(630),
    [aux_sym_object_repeat1] = STATE(900),
    [aux_sym_object_pattern_repeat1] = STATE(901),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(111),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(109),
    [anon_sym_set] = ACTIONS(109),
  },
  [4] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1181),
    [sym_object_assignment_pattern] = STATE(897),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1181),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1181),
    [sym_spread_element] = STATE(890),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(507),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [sym_rest_pattern] = STATE(897),
    [sym_method_definition] = STATE(890),
    [sym_pair] = STATE(890),
    [sym_pair_pattern] = STATE(897),
    [sym__property_name] = STATE(899),
    [sym_computed_property_name] = STATE(899),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(630),
    [aux_sym_object_repeat1] = STATE(892),
    [aux_sym_object_pattern_repeat1] = STATE(901),
    [sym_identifier] = ACTIONS(113),
    [anon_sym_export] = ACTIONS(115),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(119),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(121),
    [anon_sym_get] = ACTIONS(123),
    [anon_sym_set] = ACTIONS(123),
  },
  [5] = {
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1181),
    [sym_object_assignment_pattern] = STATE(897),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1181),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1181),
    [sym_spread_element] = STATE(898),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(507),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [sym_rest_pattern] = STATE(897),
    [sym_method_definition] = STATE(898),
    [sym_pair] = STATE(898),
    [sym_pair_pattern] = STATE(897),
    [sym__property_name] = STATE(899),
    [sym_computed_property_name] = STATE(899),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(630),
    [aux_sym_object_repeat1] = STATE(900),
    [aux_sym_object_pattern_repeat1] = STATE(901),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(125),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(109),
    [anon_sym_set] = ACTIONS(109),
  },
  [6] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1181),
    [sym_object_assignment_pattern] = STATE(897),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1181),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1181),
    [sym_spread_element] = STATE(890),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(507),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [sym_rest_pattern] = STATE(897),
    [sym_method_definition] = STATE(890),
    [sym_pair] = STATE(890),
    [sym_pair_pattern] = STATE(897),
    [sym__property_name] = STATE(899),
    [sym_computed_property_name] = STATE(899),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(630),
    [aux_sym_object_repeat1] = STATE(892),
    [aux_sym_object_pattern_repeat1] = STATE(901),
    [sym_identifier] = ACTIONS(127),
    [anon_sym_export] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(131),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(105),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(133),
    [anon_sym_get] = ACTIONS(135),
    [anon_sym_set] = ACTIONS(135),
  },
  [7] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(139),
    [anon_sym_export] = ACTIONS(142),
    [anon_sym_default] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(137),
    [anon_sym_import] = ACTIONS(150),
    [anon_sym_var] = ACTIONS(153),
    [anon_sym_let] = ACTIONS(156),
    [anon_sym_const] = ACTIONS(156),
    [anon_sym_if] = ACTIONS(159),
    [anon_sym_switch] = ACTIONS(162),
    [anon_sym_for] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(168),
    [anon_sym_await] = ACTIONS(171),
    [anon_sym_while] = ACTIONS(174),
    [anon_sym_do] = ACTIONS(177),
    [anon_sym_try] = ACTIONS(180),
    [anon_sym_with] = ACTIONS(183),
    [anon_sym_break] = ACTIONS(186),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(192),
    [anon_sym_return] = ACTIONS(195),
    [anon_sym_throw] = ACTIONS(198),
    [anon_sym_SEMI] = ACTIONS(201),
    [anon_sym_case] = ACTIONS(145),
    [anon_sym_yield] = ACTIONS(204),
    [anon_sym_LBRACK] = ACTIONS(207),
    [anon_sym_LT] = ACTIONS(210),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_class] = ACTIONS(216),
    [anon_sym_async] = ACTIONS(219),
    [anon_sym_function] = ACTIONS(222),
    [anon_sym_new] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(228),
    [anon_sym_DASH] = ACTIONS(228),
    [anon_sym_BANG] = ACTIONS(231),
    [anon_sym_TILDE] = ACTIONS(231),
    [anon_sym_typeof] = ACTIONS(234),
    [anon_sym_void] = ACTIONS(234),
    [anon_sym_delete] = ACTIONS(234),
    [anon_sym_PLUS_PLUS] = ACTIONS(237),
    [anon_sym_DASH_DASH] = ACTIONS(237),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(246),
    [sym_number] = ACTIONS(249),
    [sym_this] = ACTIONS(252),
    [sym_super] = ACTIONS(252),
    [sym_true] = ACTIONS(252),
    [sym_false] = ACTIONS(252),
    [sym_null] = ACTIONS(252),
    [sym_undefined] = ACTIONS(252),
    [anon_sym_AT] = ACTIONS(255),
    [anon_sym_static] = ACTIONS(258),
    [anon_sym_get] = ACTIONS(258),
    [anon_sym_set] = ACTIONS(258),
  },
  [8] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(261),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [9] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(265),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(267),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(265),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [10] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(269),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(271),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [11] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(273),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(275),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(273),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [12] = {
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [13] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(279),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [14] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [15] = {
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(283),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [16] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [ts_builtin_sym_end] = ACTIONS(285),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [17] = {
    [sym_export_statement] = STATE(21),
    [sym_declaration] = STATE(21),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_for_in_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_with_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_debugger_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_empty_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(287),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [18] = {
    [sym_export_statement] = STATE(14),
    [sym_declaration] = STATE(14),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_for_in_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_with_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_debugger_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_empty_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [19] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [ts_builtin_sym_end] = ACTIONS(289),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [20] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(291),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [21] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(293),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [22] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(295),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [23] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(297),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [24] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [ts_builtin_sym_end] = ACTIONS(285),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [25] = {
    [sym_export_statement] = STATE(245),
    [sym_declaration] = STATE(245),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(245),
    [sym_expression_statement] = STATE(245),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(245),
    [sym_if_statement] = STATE(245),
    [sym_switch_statement] = STATE(245),
    [sym_for_statement] = STATE(245),
    [sym_for_in_statement] = STATE(245),
    [sym_while_statement] = STATE(245),
    [sym_do_statement] = STATE(245),
    [sym_try_statement] = STATE(245),
    [sym_with_statement] = STATE(245),
    [sym_break_statement] = STATE(245),
    [sym_continue_statement] = STATE(245),
    [sym_debugger_statement] = STATE(245),
    [sym_return_statement] = STATE(245),
    [sym_throw_statement] = STATE(245),
    [sym_empty_statement] = STATE(245),
    [sym_labeled_statement] = STATE(245),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [26] = {
    [sym_export_statement] = STATE(914),
    [sym_declaration] = STATE(914),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(914),
    [sym_expression_statement] = STATE(914),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(914),
    [sym_if_statement] = STATE(914),
    [sym_switch_statement] = STATE(914),
    [sym_for_statement] = STATE(914),
    [sym_for_in_statement] = STATE(914),
    [sym_while_statement] = STATE(914),
    [sym_do_statement] = STATE(914),
    [sym_try_statement] = STATE(914),
    [sym_with_statement] = STATE(914),
    [sym_break_statement] = STATE(914),
    [sym_continue_statement] = STATE(914),
    [sym_debugger_statement] = STATE(914),
    [sym_return_statement] = STATE(914),
    [sym_throw_statement] = STATE(914),
    [sym_empty_statement] = STATE(914),
    [sym_labeled_statement] = STATE(914),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [27] = {
    [sym_export_statement] = STATE(248),
    [sym_declaration] = STATE(248),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(248),
    [sym_expression_statement] = STATE(248),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(248),
    [sym_if_statement] = STATE(248),
    [sym_switch_statement] = STATE(248),
    [sym_for_statement] = STATE(248),
    [sym_for_in_statement] = STATE(248),
    [sym_while_statement] = STATE(248),
    [sym_do_statement] = STATE(248),
    [sym_try_statement] = STATE(248),
    [sym_with_statement] = STATE(248),
    [sym_break_statement] = STATE(248),
    [sym_continue_statement] = STATE(248),
    [sym_debugger_statement] = STATE(248),
    [sym_return_statement] = STATE(248),
    [sym_throw_statement] = STATE(248),
    [sym_empty_statement] = STATE(248),
    [sym_labeled_statement] = STATE(248),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [28] = {
    [sym_export_statement] = STATE(226),
    [sym_declaration] = STATE(226),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(226),
    [sym_expression_statement] = STATE(226),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(226),
    [sym_if_statement] = STATE(226),
    [sym_switch_statement] = STATE(226),
    [sym_for_statement] = STATE(226),
    [sym_for_in_statement] = STATE(226),
    [sym_while_statement] = STATE(226),
    [sym_do_statement] = STATE(226),
    [sym_try_statement] = STATE(226),
    [sym_with_statement] = STATE(226),
    [sym_break_statement] = STATE(226),
    [sym_continue_statement] = STATE(226),
    [sym_debugger_statement] = STATE(226),
    [sym_return_statement] = STATE(226),
    [sym_throw_statement] = STATE(226),
    [sym_empty_statement] = STATE(226),
    [sym_labeled_statement] = STATE(226),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [29] = {
    [sym_export_statement] = STATE(248),
    [sym_declaration] = STATE(248),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(248),
    [sym_expression_statement] = STATE(248),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(248),
    [sym_if_statement] = STATE(248),
    [sym_switch_statement] = STATE(248),
    [sym_for_statement] = STATE(248),
    [sym_for_in_statement] = STATE(248),
    [sym_while_statement] = STATE(248),
    [sym_do_statement] = STATE(248),
    [sym_try_statement] = STATE(248),
    [sym_with_statement] = STATE(248),
    [sym_break_statement] = STATE(248),
    [sym_continue_statement] = STATE(248),
    [sym_debugger_statement] = STATE(248),
    [sym_return_statement] = STATE(248),
    [sym_throw_statement] = STATE(248),
    [sym_empty_statement] = STATE(248),
    [sym_labeled_statement] = STATE(248),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [30] = {
    [sym_export_statement] = STATE(261),
    [sym_declaration] = STATE(261),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(261),
    [sym_expression_statement] = STATE(261),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(261),
    [sym_if_statement] = STATE(261),
    [sym_switch_statement] = STATE(261),
    [sym_for_statement] = STATE(261),
    [sym_for_in_statement] = STATE(261),
    [sym_while_statement] = STATE(261),
    [sym_do_statement] = STATE(261),
    [sym_try_statement] = STATE(261),
    [sym_with_statement] = STATE(261),
    [sym_break_statement] = STATE(261),
    [sym_continue_statement] = STATE(261),
    [sym_debugger_statement] = STATE(261),
    [sym_return_statement] = STATE(261),
    [sym_throw_statement] = STATE(261),
    [sym_empty_statement] = STATE(261),
    [sym_labeled_statement] = STATE(261),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [31] = {
    [sym_export_statement] = STATE(281),
    [sym_declaration] = STATE(281),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(281),
    [sym_expression_statement] = STATE(281),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(281),
    [sym_if_statement] = STATE(281),
    [sym_switch_statement] = STATE(281),
    [sym_for_statement] = STATE(281),
    [sym_for_in_statement] = STATE(281),
    [sym_while_statement] = STATE(281),
    [sym_do_statement] = STATE(281),
    [sym_try_statement] = STATE(281),
    [sym_with_statement] = STATE(281),
    [sym_break_statement] = STATE(281),
    [sym_continue_statement] = STATE(281),
    [sym_debugger_statement] = STATE(281),
    [sym_return_statement] = STATE(281),
    [sym_throw_statement] = STATE(281),
    [sym_empty_statement] = STATE(281),
    [sym_labeled_statement] = STATE(281),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [32] = {
    [sym_export_statement] = STATE(1120),
    [sym_declaration] = STATE(1120),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(1120),
    [sym_expression_statement] = STATE(1120),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(1120),
    [sym_if_statement] = STATE(1120),
    [sym_switch_statement] = STATE(1120),
    [sym_for_statement] = STATE(1120),
    [sym_for_in_statement] = STATE(1120),
    [sym_while_statement] = STATE(1120),
    [sym_do_statement] = STATE(1120),
    [sym_try_statement] = STATE(1120),
    [sym_with_statement] = STATE(1120),
    [sym_break_statement] = STATE(1120),
    [sym_continue_statement] = STATE(1120),
    [sym_debugger_statement] = STATE(1120),
    [sym_return_statement] = STATE(1120),
    [sym_throw_statement] = STATE(1120),
    [sym_empty_statement] = STATE(1120),
    [sym_labeled_statement] = STATE(1120),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [33] = {
    [sym_export_statement] = STATE(271),
    [sym_declaration] = STATE(271),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(271),
    [sym_expression_statement] = STATE(271),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(271),
    [sym_if_statement] = STATE(271),
    [sym_switch_statement] = STATE(271),
    [sym_for_statement] = STATE(271),
    [sym_for_in_statement] = STATE(271),
    [sym_while_statement] = STATE(271),
    [sym_do_statement] = STATE(271),
    [sym_try_statement] = STATE(271),
    [sym_with_statement] = STATE(271),
    [sym_break_statement] = STATE(271),
    [sym_continue_statement] = STATE(271),
    [sym_debugger_statement] = STATE(271),
    [sym_return_statement] = STATE(271),
    [sym_throw_statement] = STATE(271),
    [sym_empty_statement] = STATE(271),
    [sym_labeled_statement] = STATE(271),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [34] = {
    [sym_export_statement] = STATE(246),
    [sym_declaration] = STATE(246),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(246),
    [sym_expression_statement] = STATE(246),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(246),
    [sym_if_statement] = STATE(246),
    [sym_switch_statement] = STATE(246),
    [sym_for_statement] = STATE(246),
    [sym_for_in_statement] = STATE(246),
    [sym_while_statement] = STATE(246),
    [sym_do_statement] = STATE(246),
    [sym_try_statement] = STATE(246),
    [sym_with_statement] = STATE(246),
    [sym_break_statement] = STATE(246),
    [sym_continue_statement] = STATE(246),
    [sym_debugger_statement] = STATE(246),
    [sym_return_statement] = STATE(246),
    [sym_throw_statement] = STATE(246),
    [sym_empty_statement] = STATE(246),
    [sym_labeled_statement] = STATE(246),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [35] = {
    [sym_export_statement] = STATE(244),
    [sym_declaration] = STATE(244),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(244),
    [sym_expression_statement] = STATE(244),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(244),
    [sym_if_statement] = STATE(244),
    [sym_switch_statement] = STATE(244),
    [sym_for_statement] = STATE(244),
    [sym_for_in_statement] = STATE(244),
    [sym_while_statement] = STATE(244),
    [sym_do_statement] = STATE(244),
    [sym_try_statement] = STATE(244),
    [sym_with_statement] = STATE(244),
    [sym_break_statement] = STATE(244),
    [sym_continue_statement] = STATE(244),
    [sym_debugger_statement] = STATE(244),
    [sym_return_statement] = STATE(244),
    [sym_throw_statement] = STATE(244),
    [sym_empty_statement] = STATE(244),
    [sym_labeled_statement] = STATE(244),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [36] = {
    [sym_export_statement] = STATE(271),
    [sym_declaration] = STATE(271),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(271),
    [sym_expression_statement] = STATE(271),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(271),
    [sym_if_statement] = STATE(271),
    [sym_switch_statement] = STATE(271),
    [sym_for_statement] = STATE(271),
    [sym_for_in_statement] = STATE(271),
    [sym_while_statement] = STATE(271),
    [sym_do_statement] = STATE(271),
    [sym_try_statement] = STATE(271),
    [sym_with_statement] = STATE(271),
    [sym_break_statement] = STATE(271),
    [sym_continue_statement] = STATE(271),
    [sym_debugger_statement] = STATE(271),
    [sym_return_statement] = STATE(271),
    [sym_throw_statement] = STATE(271),
    [sym_empty_statement] = STATE(271),
    [sym_labeled_statement] = STATE(271),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [37] = {
    [sym_export_statement] = STATE(244),
    [sym_declaration] = STATE(244),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(244),
    [sym_expression_statement] = STATE(244),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(244),
    [sym_if_statement] = STATE(244),
    [sym_switch_statement] = STATE(244),
    [sym_for_statement] = STATE(244),
    [sym_for_in_statement] = STATE(244),
    [sym_while_statement] = STATE(244),
    [sym_do_statement] = STATE(244),
    [sym_try_statement] = STATE(244),
    [sym_with_statement] = STATE(244),
    [sym_break_statement] = STATE(244),
    [sym_continue_statement] = STATE(244),
    [sym_debugger_statement] = STATE(244),
    [sym_return_statement] = STATE(244),
    [sym_throw_statement] = STATE(244),
    [sym_empty_statement] = STATE(244),
    [sym_labeled_statement] = STATE(244),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [38] = {
    [sym_export_statement] = STATE(279),
    [sym_declaration] = STATE(279),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(279),
    [sym_expression_statement] = STATE(279),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(279),
    [sym_if_statement] = STATE(279),
    [sym_switch_statement] = STATE(279),
    [sym_for_statement] = STATE(279),
    [sym_for_in_statement] = STATE(279),
    [sym_while_statement] = STATE(279),
    [sym_do_statement] = STATE(279),
    [sym_try_statement] = STATE(279),
    [sym_with_statement] = STATE(279),
    [sym_break_statement] = STATE(279),
    [sym_continue_statement] = STATE(279),
    [sym_debugger_statement] = STATE(279),
    [sym_return_statement] = STATE(279),
    [sym_throw_statement] = STATE(279),
    [sym_empty_statement] = STATE(279),
    [sym_labeled_statement] = STATE(279),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [39] = {
    [sym_export_statement] = STATE(279),
    [sym_declaration] = STATE(279),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(279),
    [sym_expression_statement] = STATE(279),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(279),
    [sym_if_statement] = STATE(279),
    [sym_switch_statement] = STATE(279),
    [sym_for_statement] = STATE(279),
    [sym_for_in_statement] = STATE(279),
    [sym_while_statement] = STATE(279),
    [sym_do_statement] = STATE(279),
    [sym_try_statement] = STATE(279),
    [sym_with_statement] = STATE(279),
    [sym_break_statement] = STATE(279),
    [sym_continue_statement] = STATE(279),
    [sym_debugger_statement] = STATE(279),
    [sym_return_statement] = STATE(279),
    [sym_throw_statement] = STATE(279),
    [sym_empty_statement] = STATE(279),
    [sym_labeled_statement] = STATE(279),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [40] = {
    [sym_export_statement] = STATE(245),
    [sym_declaration] = STATE(245),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(245),
    [sym_expression_statement] = STATE(245),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(245),
    [sym_if_statement] = STATE(245),
    [sym_switch_statement] = STATE(245),
    [sym_for_statement] = STATE(245),
    [sym_for_in_statement] = STATE(245),
    [sym_while_statement] = STATE(245),
    [sym_do_statement] = STATE(245),
    [sym_try_statement] = STATE(245),
    [sym_with_statement] = STATE(245),
    [sym_break_statement] = STATE(245),
    [sym_continue_statement] = STATE(245),
    [sym_debugger_statement] = STATE(245),
    [sym_return_statement] = STATE(245),
    [sym_throw_statement] = STATE(245),
    [sym_empty_statement] = STATE(245),
    [sym_labeled_statement] = STATE(245),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [41] = {
    [sym_export_statement] = STATE(261),
    [sym_declaration] = STATE(261),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(261),
    [sym_expression_statement] = STATE(261),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(261),
    [sym_if_statement] = STATE(261),
    [sym_switch_statement] = STATE(261),
    [sym_for_statement] = STATE(261),
    [sym_for_in_statement] = STATE(261),
    [sym_while_statement] = STATE(261),
    [sym_do_statement] = STATE(261),
    [sym_try_statement] = STATE(261),
    [sym_with_statement] = STATE(261),
    [sym_break_statement] = STATE(261),
    [sym_continue_statement] = STATE(261),
    [sym_debugger_statement] = STATE(261),
    [sym_return_statement] = STATE(261),
    [sym_throw_statement] = STATE(261),
    [sym_empty_statement] = STATE(261),
    [sym_labeled_statement] = STATE(261),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(795),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [42] = {
    [sym_export_statement] = STATE(246),
    [sym_declaration] = STATE(246),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(246),
    [sym_expression_statement] = STATE(246),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(246),
    [sym_if_statement] = STATE(246),
    [sym_switch_statement] = STATE(246),
    [sym_for_statement] = STATE(246),
    [sym_for_in_statement] = STATE(246),
    [sym_while_statement] = STATE(246),
    [sym_do_statement] = STATE(246),
    [sym_try_statement] = STATE(246),
    [sym_with_statement] = STATE(246),
    [sym_break_statement] = STATE(246),
    [sym_continue_statement] = STATE(246),
    [sym_debugger_statement] = STATE(246),
    [sym_return_statement] = STATE(246),
    [sym_throw_statement] = STATE(246),
    [sym_empty_statement] = STATE(246),
    [sym_labeled_statement] = STATE(246),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [43] = {
    [sym_export_statement] = STATE(281),
    [sym_declaration] = STATE(281),
    [sym_import] = STATE(553),
    [sym_import_statement] = STATE(281),
    [sym_expression_statement] = STATE(281),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_statement_block] = STATE(281),
    [sym_if_statement] = STATE(281),
    [sym_switch_statement] = STATE(281),
    [sym_for_statement] = STATE(281),
    [sym_for_in_statement] = STATE(281),
    [sym_while_statement] = STATE(281),
    [sym_do_statement] = STATE(281),
    [sym_try_statement] = STATE(281),
    [sym_with_statement] = STATE(281),
    [sym_break_statement] = STATE(281),
    [sym_continue_statement] = STATE(281),
    [sym_debugger_statement] = STATE(281),
    [sym_return_statement] = STATE(281),
    [sym_throw_statement] = STATE(281),
    [sym_empty_statement] = STATE(281),
    [sym_labeled_statement] = STATE(281),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_class_declaration] = STATE(251),
    [sym_function] = STATE(553),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function] = STATE(553),
    [sym_generator_function_declaration] = STATE(251),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(799),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [44] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(358),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_RBRACE] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_COLON] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_RBRACK] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(343),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_QMARK] = ACTIONS(337),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(355),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [45] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(399),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_STAR] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_RBRACE] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(337),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
    [sym__automatic_semicolon] = ACTIONS(329),
  },
  [46] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(534),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_STAR] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_COLON] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(343),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_QMARK] = ACTIONS(337),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(409),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(417),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_STAR] = ACTIONS(421),
    [anon_sym_default] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_var] = ACTIONS(419),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_const] = ACTIONS(419),
    [anon_sym_else] = ACTIONS(419),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(419),
    [anon_sym_in] = ACTIONS(421),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_do] = ACTIONS(419),
    [anon_sym_try] = ACTIONS(419),
    [anon_sym_with] = ACTIONS(419),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(419),
    [anon_sym_debugger] = ACTIONS(419),
    [anon_sym_return] = ACTIONS(419),
    [anon_sym_throw] = ACTIONS(419),
    [anon_sym_SEMI] = ACTIONS(417),
    [anon_sym_case] = ACTIONS(419),
    [anon_sym_yield] = ACTIONS(419),
    [anon_sym_EQ] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(417),
    [anon_sym_LT] = ACTIONS(419),
    [anon_sym_GT] = ACTIONS(421),
    [anon_sym_SLASH] = ACTIONS(419),
    [anon_sym_DOT] = ACTIONS(421),
    [anon_sym_class] = ACTIONS(419),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(419),
    [anon_sym_QMARK_DOT] = ACTIONS(423),
    [anon_sym_new] = ACTIONS(419),
    [anon_sym_QMARK] = ACTIONS(421),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(421),
    [anon_sym_GT_GT_GT] = ACTIONS(423),
    [anon_sym_LT_LT] = ACTIONS(423),
    [anon_sym_AMP] = ACTIONS(421),
    [anon_sym_CARET] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(421),
    [anon_sym_PLUS] = ACTIONS(419),
    [anon_sym_DASH] = ACTIONS(419),
    [anon_sym_PERCENT] = ACTIONS(423),
    [anon_sym_STAR_STAR] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(423),
    [anon_sym_EQ_EQ] = ACTIONS(421),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(421),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(423),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_QMARK_QMARK] = ACTIONS(423),
    [anon_sym_instanceof] = ACTIONS(421),
    [anon_sym_BANG] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(419),
    [anon_sym_void] = ACTIONS(419),
    [anon_sym_delete] = ACTIONS(419),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(417),
    [anon_sym_SQUOTE] = ACTIONS(417),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(417),
    [sym_number] = ACTIONS(417),
    [sym_this] = ACTIONS(419),
    [sym_super] = ACTIONS(419),
    [sym_true] = ACTIONS(419),
    [sym_false] = ACTIONS(419),
    [sym_null] = ACTIONS(419),
    [sym_undefined] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym__automatic_semicolon] = ACTIONS(427),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(429),
    [sym_identifier] = ACTIONS(431),
    [anon_sym_export] = ACTIONS(431),
    [anon_sym_STAR] = ACTIONS(431),
    [anon_sym_default] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(429),
    [anon_sym_RBRACE] = ACTIONS(429),
    [anon_sym_import] = ACTIONS(431),
    [anon_sym_var] = ACTIONS(431),
    [anon_sym_let] = ACTIONS(431),
    [anon_sym_const] = ACTIONS(431),
    [anon_sym_else] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_switch] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(431),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_await] = ACTIONS(431),
    [anon_sym_in] = ACTIONS(431),
    [anon_sym_while] = ACTIONS(431),
    [anon_sym_do] = ACTIONS(431),
    [anon_sym_try] = ACTIONS(431),
    [anon_sym_with] = ACTIONS(431),
    [anon_sym_break] = ACTIONS(431),
    [anon_sym_continue] = ACTIONS(431),
    [anon_sym_debugger] = ACTIONS(431),
    [anon_sym_return] = ACTIONS(431),
    [anon_sym_throw] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(429),
    [anon_sym_case] = ACTIONS(431),
    [anon_sym_yield] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(431),
    [anon_sym_GT] = ACTIONS(431),
    [anon_sym_SLASH] = ACTIONS(431),
    [anon_sym_DOT] = ACTIONS(431),
    [anon_sym_class] = ACTIONS(431),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_QMARK_DOT] = ACTIONS(429),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_QMARK] = ACTIONS(431),
    [anon_sym_AMP_AMP] = ACTIONS(429),
    [anon_sym_PIPE_PIPE] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(431),
    [anon_sym_GT_GT_GT] = ACTIONS(429),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(431),
    [anon_sym_CARET] = ACTIONS(429),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_STAR_STAR] = ACTIONS(429),
    [anon_sym_LT_EQ] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(431),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(429),
    [anon_sym_BANG_EQ] = ACTIONS(431),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(429),
    [anon_sym_GT_EQ] = ACTIONS(429),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_instanceof] = ACTIONS(431),
    [anon_sym_BANG] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(429),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(429),
    [anon_sym_DASH_DASH] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(429),
    [anon_sym_SQUOTE] = ACTIONS(429),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(429),
    [sym_number] = ACTIONS(429),
    [sym_this] = ACTIONS(431),
    [sym_super] = ACTIONS(431),
    [sym_true] = ACTIONS(431),
    [sym_false] = ACTIONS(431),
    [sym_null] = ACTIONS(431),
    [sym_undefined] = ACTIONS(431),
    [anon_sym_AT] = ACTIONS(429),
    [anon_sym_static] = ACTIONS(431),
    [anon_sym_get] = ACTIONS(431),
    [anon_sym_set] = ACTIONS(431),
    [sym__automatic_semicolon] = ACTIONS(429),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(433),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_export] = ACTIONS(435),
    [anon_sym_STAR] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_COMMA] = ACTIONS(439),
    [anon_sym_RBRACE] = ACTIONS(433),
    [anon_sym_import] = ACTIONS(435),
    [anon_sym_var] = ACTIONS(435),
    [anon_sym_let] = ACTIONS(435),
    [anon_sym_const] = ACTIONS(435),
    [anon_sym_else] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(433),
    [anon_sym_await] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(437),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_try] = ACTIONS(435),
    [anon_sym_with] = ACTIONS(435),
    [anon_sym_break] = ACTIONS(435),
    [anon_sym_continue] = ACTIONS(435),
    [anon_sym_debugger] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_throw] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(433),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_yield] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(433),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_DOT] = ACTIONS(437),
    [anon_sym_class] = ACTIONS(435),
    [anon_sym_async] = ACTIONS(435),
    [anon_sym_function] = ACTIONS(435),
    [anon_sym_QMARK_DOT] = ACTIONS(439),
    [anon_sym_new] = ACTIONS(435),
    [anon_sym_QMARK] = ACTIONS(437),
    [anon_sym_AMP_AMP] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_GT_GT] = ACTIONS(437),
    [anon_sym_GT_GT_GT] = ACTIONS(439),
    [anon_sym_LT_LT] = ACTIONS(439),
    [anon_sym_AMP] = ACTIONS(437),
    [anon_sym_CARET] = ACTIONS(439),
    [anon_sym_PIPE] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_PERCENT] = ACTIONS(439),
    [anon_sym_STAR_STAR] = ACTIONS(439),
    [anon_sym_LT_EQ] = ACTIONS(439),
    [anon_sym_EQ_EQ] = ACTIONS(437),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(439),
    [anon_sym_BANG_EQ] = ACTIONS(437),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(439),
    [anon_sym_GT_EQ] = ACTIONS(439),
    [anon_sym_QMARK_QMARK] = ACTIONS(439),
    [anon_sym_instanceof] = ACTIONS(437),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(433),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(433),
    [anon_sym_DASH_DASH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [anon_sym_SQUOTE] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [sym_number] = ACTIONS(433),
    [sym_this] = ACTIONS(435),
    [sym_super] = ACTIONS(435),
    [sym_true] = ACTIONS(435),
    [sym_false] = ACTIONS(435),
    [sym_null] = ACTIONS(435),
    [sym_undefined] = ACTIONS(435),
    [anon_sym_AT] = ACTIONS(433),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [sym__automatic_semicolon] = ACTIONS(441),
  },
  [50] = {
    [ts_builtin_sym_end] = ACTIONS(443),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_default] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(443),
    [anon_sym_COMMA] = ACTIONS(443),
    [anon_sym_RBRACE] = ACTIONS(443),
    [anon_sym_import] = ACTIONS(445),
    [anon_sym_var] = ACTIONS(445),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_const] = ACTIONS(445),
    [anon_sym_else] = ACTIONS(445),
    [anon_sym_if] = ACTIONS(445),
    [anon_sym_switch] = ACTIONS(445),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_await] = ACTIONS(445),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(445),
    [anon_sym_do] = ACTIONS(445),
    [anon_sym_try] = ACTIONS(445),
    [anon_sym_with] = ACTIONS(445),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(445),
    [anon_sym_debugger] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(445),
    [anon_sym_throw] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(443),
    [anon_sym_case] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(445),
    [anon_sym_LBRACK] = ACTIONS(443),
    [anon_sym_LT] = ACTIONS(445),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(445),
    [anon_sym_DOT] = ACTIONS(445),
    [anon_sym_class] = ACTIONS(445),
    [anon_sym_async] = ACTIONS(445),
    [anon_sym_function] = ACTIONS(445),
    [anon_sym_QMARK_DOT] = ACTIONS(443),
    [anon_sym_new] = ACTIONS(445),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(443),
    [anon_sym_LT_LT] = ACTIONS(443),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [anon_sym_PERCENT] = ACTIONS(443),
    [anon_sym_STAR_STAR] = ACTIONS(443),
    [anon_sym_LT_EQ] = ACTIONS(443),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(443),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(443),
    [anon_sym_GT_EQ] = ACTIONS(443),
    [anon_sym_QMARK_QMARK] = ACTIONS(443),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(445),
    [anon_sym_void] = ACTIONS(445),
    [anon_sym_delete] = ACTIONS(445),
    [anon_sym_PLUS_PLUS] = ACTIONS(443),
    [anon_sym_DASH_DASH] = ACTIONS(443),
    [anon_sym_DQUOTE] = ACTIONS(443),
    [anon_sym_SQUOTE] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(443),
    [sym_number] = ACTIONS(443),
    [sym_this] = ACTIONS(445),
    [sym_super] = ACTIONS(445),
    [sym_true] = ACTIONS(445),
    [sym_false] = ACTIONS(445),
    [sym_null] = ACTIONS(445),
    [sym_undefined] = ACTIONS(445),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym__automatic_semicolon] = ACTIONS(443),
  },
  [51] = {
    [ts_builtin_sym_end] = ACTIONS(447),
    [sym_identifier] = ACTIONS(449),
    [anon_sym_export] = ACTIONS(449),
    [anon_sym_STAR] = ACTIONS(451),
    [anon_sym_default] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(447),
    [anon_sym_import] = ACTIONS(449),
    [anon_sym_var] = ACTIONS(449),
    [anon_sym_let] = ACTIONS(449),
    [anon_sym_const] = ACTIONS(449),
    [anon_sym_else] = ACTIONS(449),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_switch] = ACTIONS(449),
    [anon_sym_for] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(447),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_in] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(449),
    [anon_sym_do] = ACTIONS(449),
    [anon_sym_try] = ACTIONS(449),
    [anon_sym_with] = ACTIONS(449),
    [anon_sym_break] = ACTIONS(449),
    [anon_sym_continue] = ACTIONS(449),
    [anon_sym_debugger] = ACTIONS(449),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_throw] = ACTIONS(449),
    [anon_sym_SEMI] = ACTIONS(447),
    [anon_sym_case] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(449),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_LT] = ACTIONS(449),
    [anon_sym_GT] = ACTIONS(451),
    [anon_sym_SLASH] = ACTIONS(449),
    [anon_sym_DOT] = ACTIONS(451),
    [anon_sym_class] = ACTIONS(449),
    [anon_sym_async] = ACTIONS(449),
    [anon_sym_function] = ACTIONS(449),
    [anon_sym_QMARK_DOT] = ACTIONS(453),
    [anon_sym_new] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(451),
    [anon_sym_GT_GT_GT] = ACTIONS(453),
    [anon_sym_LT_LT] = ACTIONS(453),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_CARET] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(449),
    [anon_sym_DASH] = ACTIONS(449),
    [anon_sym_PERCENT] = ACTIONS(453),
    [anon_sym_STAR_STAR] = ACTIONS(453),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(451),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(451),
    [anon_sym_BANG] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(447),
    [anon_sym_typeof] = ACTIONS(449),
    [anon_sym_void] = ACTIONS(449),
    [anon_sym_delete] = ACTIONS(449),
    [anon_sym_PLUS_PLUS] = ACTIONS(447),
    [anon_sym_DASH_DASH] = ACTIONS(447),
    [anon_sym_DQUOTE] = ACTIONS(447),
    [anon_sym_SQUOTE] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(447),
    [sym_number] = ACTIONS(447),
    [sym_this] = ACTIONS(449),
    [sym_super] = ACTIONS(449),
    [sym_true] = ACTIONS(449),
    [sym_false] = ACTIONS(449),
    [sym_null] = ACTIONS(449),
    [sym_undefined] = ACTIONS(449),
    [anon_sym_AT] = ACTIONS(447),
    [anon_sym_static] = ACTIONS(449),
    [anon_sym_get] = ACTIONS(449),
    [anon_sym_set] = ACTIONS(449),
    [sym__automatic_semicolon] = ACTIONS(455),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(457),
    [sym_identifier] = ACTIONS(459),
    [anon_sym_export] = ACTIONS(459),
    [anon_sym_STAR] = ACTIONS(461),
    [anon_sym_default] = ACTIONS(459),
    [anon_sym_LBRACE] = ACTIONS(457),
    [anon_sym_COMMA] = ACTIONS(463),
    [anon_sym_RBRACE] = ACTIONS(457),
    [anon_sym_import] = ACTIONS(459),
    [anon_sym_var] = ACTIONS(459),
    [anon_sym_let] = ACTIONS(459),
    [anon_sym_const] = ACTIONS(459),
    [anon_sym_else] = ACTIONS(459),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_switch] = ACTIONS(459),
    [anon_sym_for] = ACTIONS(459),
    [anon_sym_LPAREN] = ACTIONS(457),
    [anon_sym_await] = ACTIONS(459),
    [anon_sym_in] = ACTIONS(461),
    [anon_sym_while] = ACTIONS(459),
    [anon_sym_do] = ACTIONS(459),
    [anon_sym_try] = ACTIONS(459),
    [anon_sym_with] = ACTIONS(459),
    [anon_sym_break] = ACTIONS(459),
    [anon_sym_continue] = ACTIONS(459),
    [anon_sym_debugger] = ACTIONS(459),
    [anon_sym_return] = ACTIONS(459),
    [anon_sym_throw] = ACTIONS(459),
    [anon_sym_SEMI] = ACTIONS(457),
    [anon_sym_case] = ACTIONS(459),
    [anon_sym_yield] = ACTIONS(459),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(459),
    [anon_sym_GT] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(459),
    [anon_sym_DOT] = ACTIONS(461),
    [anon_sym_class] = ACTIONS(459),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(459),
    [anon_sym_QMARK_DOT] = ACTIONS(463),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(463),
    [anon_sym_GT_GT] = ACTIONS(461),
    [anon_sym_GT_GT_GT] = ACTIONS(463),
    [anon_sym_LT_LT] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(461),
    [anon_sym_CARET] = ACTIONS(463),
    [anon_sym_PIPE] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(459),
    [anon_sym_DASH] = ACTIONS(459),
    [anon_sym_PERCENT] = ACTIONS(463),
    [anon_sym_STAR_STAR] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(463),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(463),
    [anon_sym_GT_EQ] = ACTIONS(463),
    [anon_sym_QMARK_QMARK] = ACTIONS(463),
    [anon_sym_instanceof] = ACTIONS(461),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_typeof] = ACTIONS(459),
    [anon_sym_void] = ACTIONS(459),
    [anon_sym_delete] = ACTIONS(459),
    [anon_sym_PLUS_PLUS] = ACTIONS(457),
    [anon_sym_DASH_DASH] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(457),
    [sym_number] = ACTIONS(457),
    [sym_this] = ACTIONS(459),
    [sym_super] = ACTIONS(459),
    [sym_true] = ACTIONS(459),
    [sym_false] = ACTIONS(459),
    [sym_null] = ACTIONS(459),
    [sym_undefined] = ACTIONS(459),
    [anon_sym_AT] = ACTIONS(457),
    [anon_sym_static] = ACTIONS(459),
    [anon_sym_get] = ACTIONS(459),
    [anon_sym_set] = ACTIONS(459),
    [sym__automatic_semicolon] = ACTIONS(465),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(467),
    [sym_identifier] = ACTIONS(469),
    [anon_sym_export] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(469),
    [anon_sym_default] = ACTIONS(469),
    [anon_sym_LBRACE] = ACTIONS(467),
    [anon_sym_COMMA] = ACTIONS(467),
    [anon_sym_RBRACE] = ACTIONS(467),
    [anon_sym_import] = ACTIONS(469),
    [anon_sym_var] = ACTIONS(469),
    [anon_sym_let] = ACTIONS(469),
    [anon_sym_const] = ACTIONS(469),
    [anon_sym_else] = ACTIONS(469),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_switch] = ACTIONS(469),
    [anon_sym_for] = ACTIONS(469),
    [anon_sym_LPAREN] = ACTIONS(467),
    [anon_sym_await] = ACTIONS(469),
    [anon_sym_in] = ACTIONS(469),
    [anon_sym_while] = ACTIONS(469),
    [anon_sym_do] = ACTIONS(469),
    [anon_sym_try] = ACTIONS(469),
    [anon_sym_with] = ACTIONS(469),
    [anon_sym_break] = ACTIONS(469),
    [anon_sym_continue] = ACTIONS(469),
    [anon_sym_debugger] = ACTIONS(469),
    [anon_sym_return] = ACTIONS(469),
    [anon_sym_throw] = ACTIONS(469),
    [anon_sym_SEMI] = ACTIONS(467),
    [anon_sym_case] = ACTIONS(469),
    [anon_sym_yield] = ACTIONS(469),
    [anon_sym_LBRACK] = ACTIONS(467),
    [anon_sym_LT] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(469),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_DOT] = ACTIONS(469),
    [anon_sym_class] = ACTIONS(469),
    [anon_sym_async] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_QMARK_DOT] = ACTIONS(467),
    [anon_sym_new] = ACTIONS(469),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(467),
    [anon_sym_GT_GT] = ACTIONS(469),
    [anon_sym_GT_GT_GT] = ACTIONS(467),
    [anon_sym_LT_LT] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(469),
    [anon_sym_CARET] = ACTIONS(467),
    [anon_sym_PIPE] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(469),
    [anon_sym_PERCENT] = ACTIONS(467),
    [anon_sym_STAR_STAR] = ACTIONS(467),
    [anon_sym_LT_EQ] = ACTIONS(467),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(467),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(467),
    [anon_sym_GT_EQ] = ACTIONS(467),
    [anon_sym_QMARK_QMARK] = ACTIONS(467),
    [anon_sym_instanceof] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(467),
    [anon_sym_typeof] = ACTIONS(469),
    [anon_sym_void] = ACTIONS(469),
    [anon_sym_delete] = ACTIONS(469),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [anon_sym_DQUOTE] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(467),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(467),
    [sym_number] = ACTIONS(467),
    [sym_this] = ACTIONS(469),
    [sym_super] = ACTIONS(469),
    [sym_true] = ACTIONS(469),
    [sym_false] = ACTIONS(469),
    [sym_null] = ACTIONS(469),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(469),
    [anon_sym_get] = ACTIONS(469),
    [anon_sym_set] = ACTIONS(469),
    [sym__automatic_semicolon] = ACTIONS(467),
  },
  [54] = {
    [ts_builtin_sym_end] = ACTIONS(471),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_STAR] = ACTIONS(473),
    [anon_sym_default] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_COMMA] = ACTIONS(471),
    [anon_sym_RBRACE] = ACTIONS(471),
    [anon_sym_import] = ACTIONS(473),
    [anon_sym_var] = ACTIONS(473),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_const] = ACTIONS(473),
    [anon_sym_else] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_switch] = ACTIONS(473),
    [anon_sym_for] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_await] = ACTIONS(473),
    [anon_sym_in] = ACTIONS(473),
    [anon_sym_while] = ACTIONS(473),
    [anon_sym_do] = ACTIONS(473),
    [anon_sym_try] = ACTIONS(473),
    [anon_sym_with] = ACTIONS(473),
    [anon_sym_break] = ACTIONS(473),
    [anon_sym_continue] = ACTIONS(473),
    [anon_sym_debugger] = ACTIONS(473),
    [anon_sym_return] = ACTIONS(473),
    [anon_sym_throw] = ACTIONS(473),
    [anon_sym_SEMI] = ACTIONS(471),
    [anon_sym_case] = ACTIONS(473),
    [anon_sym_yield] = ACTIONS(473),
    [anon_sym_LBRACK] = ACTIONS(471),
    [anon_sym_LT] = ACTIONS(473),
    [anon_sym_GT] = ACTIONS(473),
    [anon_sym_SLASH] = ACTIONS(473),
    [anon_sym_DOT] = ACTIONS(473),
    [anon_sym_class] = ACTIONS(473),
    [anon_sym_async] = ACTIONS(473),
    [anon_sym_function] = ACTIONS(473),
    [anon_sym_QMARK_DOT] = ACTIONS(471),
    [anon_sym_new] = ACTIONS(473),
    [anon_sym_QMARK] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(471),
    [anon_sym_PIPE_PIPE] = ACTIONS(471),
    [anon_sym_GT_GT] = ACTIONS(473),
    [anon_sym_GT_GT_GT] = ACTIONS(471),
    [anon_sym_LT_LT] = ACTIONS(471),
    [anon_sym_AMP] = ACTIONS(473),
    [anon_sym_CARET] = ACTIONS(471),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_PLUS] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(473),
    [anon_sym_PERCENT] = ACTIONS(471),
    [anon_sym_STAR_STAR] = ACTIONS(471),
    [anon_sym_LT_EQ] = ACTIONS(471),
    [anon_sym_EQ_EQ] = ACTIONS(473),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(471),
    [anon_sym_BANG_EQ] = ACTIONS(473),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(471),
    [anon_sym_GT_EQ] = ACTIONS(471),
    [anon_sym_QMARK_QMARK] = ACTIONS(471),
    [anon_sym_instanceof] = ACTIONS(473),
    [anon_sym_BANG] = ACTIONS(473),
    [anon_sym_TILDE] = ACTIONS(471),
    [anon_sym_typeof] = ACTIONS(473),
    [anon_sym_void] = ACTIONS(473),
    [anon_sym_delete] = ACTIONS(473),
    [anon_sym_PLUS_PLUS] = ACTIONS(471),
    [anon_sym_DASH_DASH] = ACTIONS(471),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_SQUOTE] = ACTIONS(471),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(471),
    [sym_number] = ACTIONS(471),
    [sym_this] = ACTIONS(473),
    [sym_super] = ACTIONS(473),
    [sym_true] = ACTIONS(473),
    [sym_false] = ACTIONS(473),
    [sym_null] = ACTIONS(473),
    [sym_undefined] = ACTIONS(473),
    [anon_sym_AT] = ACTIONS(471),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym__automatic_semicolon] = ACTIONS(471),
  },
  [55] = {
    [ts_builtin_sym_end] = ACTIONS(475),
    [sym_identifier] = ACTIONS(477),
    [anon_sym_export] = ACTIONS(477),
    [anon_sym_STAR] = ACTIONS(479),
    [anon_sym_default] = ACTIONS(477),
    [anon_sym_LBRACE] = ACTIONS(475),
    [anon_sym_COMMA] = ACTIONS(481),
    [anon_sym_RBRACE] = ACTIONS(475),
    [anon_sym_import] = ACTIONS(477),
    [anon_sym_var] = ACTIONS(477),
    [anon_sym_let] = ACTIONS(477),
    [anon_sym_const] = ACTIONS(477),
    [anon_sym_else] = ACTIONS(477),
    [anon_sym_if] = ACTIONS(477),
    [anon_sym_switch] = ACTIONS(477),
    [anon_sym_for] = ACTIONS(477),
    [anon_sym_LPAREN] = ACTIONS(475),
    [anon_sym_await] = ACTIONS(477),
    [anon_sym_in] = ACTIONS(479),
    [anon_sym_while] = ACTIONS(477),
    [anon_sym_do] = ACTIONS(477),
    [anon_sym_try] = ACTIONS(477),
    [anon_sym_with] = ACTIONS(477),
    [anon_sym_break] = ACTIONS(477),
    [anon_sym_continue] = ACTIONS(477),
    [anon_sym_debugger] = ACTIONS(477),
    [anon_sym_return] = ACTIONS(477),
    [anon_sym_throw] = ACTIONS(477),
    [anon_sym_SEMI] = ACTIONS(475),
    [anon_sym_case] = ACTIONS(477),
    [anon_sym_yield] = ACTIONS(477),
    [anon_sym_LBRACK] = ACTIONS(475),
    [anon_sym_LT] = ACTIONS(477),
    [anon_sym_GT] = ACTIONS(479),
    [anon_sym_SLASH] = ACTIONS(477),
    [anon_sym_DOT] = ACTIONS(479),
    [anon_sym_class] = ACTIONS(477),
    [anon_sym_async] = ACTIONS(477),
    [anon_sym_function] = ACTIONS(477),
    [anon_sym_QMARK_DOT] = ACTIONS(481),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_QMARK] = ACTIONS(479),
    [anon_sym_AMP_AMP] = ACTIONS(481),
    [anon_sym_PIPE_PIPE] = ACTIONS(481),
    [anon_sym_GT_GT] = ACTIONS(479),
    [anon_sym_GT_GT_GT] = ACTIONS(481),
    [anon_sym_LT_LT] = ACTIONS(481),
    [anon_sym_AMP] = ACTIONS(479),
    [anon_sym_CARET] = ACTIONS(481),
    [anon_sym_PIPE] = ACTIONS(479),
    [anon_sym_PLUS] = ACTIONS(477),
    [anon_sym_DASH] = ACTIONS(477),
    [anon_sym_PERCENT] = ACTIONS(481),
    [anon_sym_STAR_STAR] = ACTIONS(481),
    [anon_sym_LT_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ] = ACTIONS(479),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ] = ACTIONS(479),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(481),
    [anon_sym_GT_EQ] = ACTIONS(481),
    [anon_sym_QMARK_QMARK] = ACTIONS(481),
    [anon_sym_instanceof] = ACTIONS(479),
    [anon_sym_BANG] = ACTIONS(477),
    [anon_sym_TILDE] = ACTIONS(475),
    [anon_sym_typeof] = ACTIONS(477),
    [anon_sym_void] = ACTIONS(477),
    [anon_sym_delete] = ACTIONS(477),
    [anon_sym_PLUS_PLUS] = ACTIONS(475),
    [anon_sym_DASH_DASH] = ACTIONS(475),
    [anon_sym_DQUOTE] = ACTIONS(475),
    [anon_sym_SQUOTE] = ACTIONS(475),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(475),
    [sym_number] = ACTIONS(475),
    [sym_this] = ACTIONS(477),
    [sym_super] = ACTIONS(477),
    [sym_true] = ACTIONS(477),
    [sym_false] = ACTIONS(477),
    [sym_null] = ACTIONS(477),
    [sym_undefined] = ACTIONS(477),
    [anon_sym_AT] = ACTIONS(475),
    [anon_sym_static] = ACTIONS(477),
    [anon_sym_get] = ACTIONS(477),
    [anon_sym_set] = ACTIONS(477),
    [sym__automatic_semicolon] = ACTIONS(483),
  },
  [56] = {
    [ts_builtin_sym_end] = ACTIONS(429),
    [sym_identifier] = ACTIONS(431),
    [anon_sym_export] = ACTIONS(431),
    [anon_sym_STAR] = ACTIONS(431),
    [anon_sym_default] = ACTIONS(431),
    [anon_sym_LBRACE] = ACTIONS(429),
    [anon_sym_COMMA] = ACTIONS(429),
    [anon_sym_RBRACE] = ACTIONS(429),
    [anon_sym_import] = ACTIONS(431),
    [anon_sym_var] = ACTIONS(431),
    [anon_sym_let] = ACTIONS(431),
    [anon_sym_const] = ACTIONS(431),
    [anon_sym_else] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(431),
    [anon_sym_switch] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(431),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_await] = ACTIONS(431),
    [anon_sym_in] = ACTIONS(431),
    [anon_sym_while] = ACTIONS(431),
    [anon_sym_do] = ACTIONS(431),
    [anon_sym_try] = ACTIONS(431),
    [anon_sym_with] = ACTIONS(431),
    [anon_sym_break] = ACTIONS(431),
    [anon_sym_continue] = ACTIONS(431),
    [anon_sym_debugger] = ACTIONS(431),
    [anon_sym_return] = ACTIONS(431),
    [anon_sym_throw] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(429),
    [anon_sym_case] = ACTIONS(431),
    [anon_sym_yield] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(429),
    [anon_sym_LT] = ACTIONS(431),
    [anon_sym_GT] = ACTIONS(431),
    [anon_sym_SLASH] = ACTIONS(431),
    [anon_sym_DOT] = ACTIONS(431),
    [anon_sym_class] = ACTIONS(431),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(431),
    [anon_sym_QMARK_DOT] = ACTIONS(429),
    [anon_sym_new] = ACTIONS(431),
    [anon_sym_QMARK] = ACTIONS(431),
    [anon_sym_AMP_AMP] = ACTIONS(429),
    [anon_sym_PIPE_PIPE] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(431),
    [anon_sym_GT_GT_GT] = ACTIONS(429),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(431),
    [anon_sym_CARET] = ACTIONS(429),
    [anon_sym_PIPE] = ACTIONS(431),
    [anon_sym_PLUS] = ACTIONS(431),
    [anon_sym_DASH] = ACTIONS(431),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_STAR_STAR] = ACTIONS(429),
    [anon_sym_LT_EQ] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(431),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(429),
    [anon_sym_BANG_EQ] = ACTIONS(431),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(429),
    [anon_sym_GT_EQ] = ACTIONS(429),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_instanceof] = ACTIONS(431),
    [anon_sym_BANG] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(429),
    [anon_sym_typeof] = ACTIONS(431),
    [anon_sym_void] = ACTIONS(431),
    [anon_sym_delete] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(429),
    [anon_sym_DASH_DASH] = ACTIONS(429),
    [anon_sym_DQUOTE] = ACTIONS(429),
    [anon_sym_SQUOTE] = ACTIONS(429),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(429),
    [sym_number] = ACTIONS(429),
    [sym_this] = ACTIONS(431),
    [sym_super] = ACTIONS(431),
    [sym_true] = ACTIONS(431),
    [sym_false] = ACTIONS(431),
    [sym_null] = ACTIONS(431),
    [sym_undefined] = ACTIONS(431),
    [anon_sym_AT] = ACTIONS(429),
    [anon_sym_static] = ACTIONS(431),
    [anon_sym_get] = ACTIONS(431),
    [anon_sym_set] = ACTIONS(431),
    [sym__automatic_semicolon] = ACTIONS(485),
  },
  [57] = {
    [ts_builtin_sym_end] = ACTIONS(487),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_export] = ACTIONS(489),
    [anon_sym_STAR] = ACTIONS(491),
    [anon_sym_default] = ACTIONS(489),
    [anon_sym_LBRACE] = ACTIONS(487),
    [anon_sym_COMMA] = ACTIONS(493),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_import] = ACTIONS(489),
    [anon_sym_var] = ACTIONS(489),
    [anon_sym_let] = ACTIONS(489),
    [anon_sym_const] = ACTIONS(489),
    [anon_sym_else] = ACTIONS(489),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_switch] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_LPAREN] = ACTIONS(487),
    [anon_sym_await] = ACTIONS(489),
    [anon_sym_in] = ACTIONS(491),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(489),
    [anon_sym_try] = ACTIONS(489),
    [anon_sym_with] = ACTIONS(489),
    [anon_sym_break] = ACTIONS(489),
    [anon_sym_continue] = ACTIONS(489),
    [anon_sym_debugger] = ACTIONS(489),
    [anon_sym_return] = ACTIONS(489),
    [anon_sym_throw] = ACTIONS(489),
    [anon_sym_SEMI] = ACTIONS(487),
    [anon_sym_case] = ACTIONS(489),
    [anon_sym_yield] = ACTIONS(489),
    [anon_sym_LBRACK] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(489),
    [anon_sym_GT] = ACTIONS(491),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_DOT] = ACTIONS(491),
    [anon_sym_class] = ACTIONS(489),
    [anon_sym_async] = ACTIONS(489),
    [anon_sym_function] = ACTIONS(489),
    [anon_sym_QMARK_DOT] = ACTIONS(493),
    [anon_sym_new] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_GT_GT] = ACTIONS(491),
    [anon_sym_GT_GT_GT] = ACTIONS(493),
    [anon_sym_LT_LT] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(491),
    [anon_sym_CARET] = ACTIONS(493),
    [anon_sym_PIPE] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(489),
    [anon_sym_DASH] = ACTIONS(489),
    [anon_sym_PERCENT] = ACTIONS(493),
    [anon_sym_STAR_STAR] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(493),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_QMARK_QMARK] = ACTIONS(493),
    [anon_sym_instanceof] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(487),
    [anon_sym_typeof] = ACTIONS(489),
    [anon_sym_void] = ACTIONS(489),
    [anon_sym_delete] = ACTIONS(489),
    [anon_sym_PLUS_PLUS] = ACTIONS(487),
    [anon_sym_DASH_DASH] = ACTIONS(487),
    [anon_sym_DQUOTE] = ACTIONS(487),
    [anon_sym_SQUOTE] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(487),
    [sym_number] = ACTIONS(487),
    [sym_this] = ACTIONS(489),
    [sym_super] = ACTIONS(489),
    [sym_true] = ACTIONS(489),
    [sym_false] = ACTIONS(489),
    [sym_null] = ACTIONS(489),
    [sym_undefined] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(487),
    [anon_sym_static] = ACTIONS(489),
    [anon_sym_get] = ACTIONS(489),
    [anon_sym_set] = ACTIONS(489),
    [sym__automatic_semicolon] = ACTIONS(495),
  },
  [58] = {
    [ts_builtin_sym_end] = ACTIONS(417),
    [sym_identifier] = ACTIONS(419),
    [anon_sym_export] = ACTIONS(419),
    [anon_sym_STAR] = ACTIONS(419),
    [anon_sym_default] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(417),
    [anon_sym_COMMA] = ACTIONS(417),
    [anon_sym_RBRACE] = ACTIONS(417),
    [anon_sym_import] = ACTIONS(419),
    [anon_sym_var] = ACTIONS(419),
    [anon_sym_let] = ACTIONS(419),
    [anon_sym_const] = ACTIONS(419),
    [anon_sym_else] = ACTIONS(419),
    [anon_sym_if] = ACTIONS(419),
    [anon_sym_switch] = ACTIONS(419),
    [anon_sym_for] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(417),
    [anon_sym_await] = ACTIONS(419),
    [anon_sym_in] = ACTIONS(419),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_do] = ACTIONS(419),
    [anon_sym_try] = ACTIONS(419),
    [anon_sym_with] = ACTIONS(419),
    [anon_sym_break] = ACTIONS(419),
    [anon_sym_continue] = ACTIONS(419),
    [anon_sym_debugger] = ACTIONS(419),
    [anon_sym_return] = ACTIONS(419),
    [anon_sym_throw] = ACTIONS(419),
    [anon_sym_SEMI] = ACTIONS(417),
    [anon_sym_case] = ACTIONS(419),
    [anon_sym_yield] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(417),
    [anon_sym_LT] = ACTIONS(419),
    [anon_sym_GT] = ACTIONS(419),
    [anon_sym_SLASH] = ACTIONS(419),
    [anon_sym_DOT] = ACTIONS(419),
    [anon_sym_class] = ACTIONS(419),
    [anon_sym_async] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(419),
    [anon_sym_QMARK_DOT] = ACTIONS(417),
    [anon_sym_new] = ACTIONS(419),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_AMP_AMP] = ACTIONS(417),
    [anon_sym_PIPE_PIPE] = ACTIONS(417),
    [anon_sym_GT_GT] = ACTIONS(419),
    [anon_sym_GT_GT_GT] = ACTIONS(417),
    [anon_sym_LT_LT] = ACTIONS(417),
    [anon_sym_AMP] = ACTIONS(419),
    [anon_sym_CARET] = ACTIONS(417),
    [anon_sym_PIPE] = ACTIONS(419),
    [anon_sym_PLUS] = ACTIONS(419),
    [anon_sym_DASH] = ACTIONS(419),
    [anon_sym_PERCENT] = ACTIONS(417),
    [anon_sym_STAR_STAR] = ACTIONS(417),
    [anon_sym_LT_EQ] = ACTIONS(417),
    [anon_sym_EQ_EQ] = ACTIONS(419),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(417),
    [anon_sym_BANG_EQ] = ACTIONS(419),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(417),
    [anon_sym_GT_EQ] = ACTIONS(417),
    [anon_sym_QMARK_QMARK] = ACTIONS(417),
    [anon_sym_instanceof] = ACTIONS(419),
    [anon_sym_BANG] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(417),
    [anon_sym_typeof] = ACTIONS(419),
    [anon_sym_void] = ACTIONS(419),
    [anon_sym_delete] = ACTIONS(419),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(417),
    [anon_sym_SQUOTE] = ACTIONS(417),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(417),
    [sym_number] = ACTIONS(417),
    [sym_this] = ACTIONS(419),
    [sym_super] = ACTIONS(419),
    [sym_true] = ACTIONS(419),
    [sym_false] = ACTIONS(419),
    [sym_null] = ACTIONS(419),
    [sym_undefined] = ACTIONS(419),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_static] = ACTIONS(419),
    [anon_sym_get] = ACTIONS(419),
    [anon_sym_set] = ACTIONS(419),
    [sym__automatic_semicolon] = ACTIONS(497),
  },
  [59] = {
    [ts_builtin_sym_end] = ACTIONS(499),
    [sym_identifier] = ACTIONS(501),
    [anon_sym_export] = ACTIONS(501),
    [anon_sym_STAR] = ACTIONS(503),
    [anon_sym_default] = ACTIONS(501),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_COMMA] = ACTIONS(505),
    [anon_sym_RBRACE] = ACTIONS(499),
    [anon_sym_import] = ACTIONS(501),
    [anon_sym_var] = ACTIONS(501),
    [anon_sym_let] = ACTIONS(501),
    [anon_sym_const] = ACTIONS(501),
    [anon_sym_else] = ACTIONS(501),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_switch] = ACTIONS(501),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_LPAREN] = ACTIONS(499),
    [anon_sym_await] = ACTIONS(501),
    [anon_sym_in] = ACTIONS(503),
    [anon_sym_while] = ACTIONS(501),
    [anon_sym_do] = ACTIONS(501),
    [anon_sym_try] = ACTIONS(501),
    [anon_sym_with] = ACTIONS(501),
    [anon_sym_break] = ACTIONS(501),
    [anon_sym_continue] = ACTIONS(501),
    [anon_sym_debugger] = ACTIONS(501),
    [anon_sym_return] = ACTIONS(501),
    [anon_sym_throw] = ACTIONS(501),
    [anon_sym_SEMI] = ACTIONS(499),
    [anon_sym_case] = ACTIONS(501),
    [anon_sym_yield] = ACTIONS(501),
    [anon_sym_LBRACK] = ACTIONS(499),
    [anon_sym_LT] = ACTIONS(501),
    [anon_sym_GT] = ACTIONS(503),
    [anon_sym_SLASH] = ACTIONS(501),
    [anon_sym_DOT] = ACTIONS(503),
    [anon_sym_class] = ACTIONS(501),
    [anon_sym_async] = ACTIONS(501),
    [anon_sym_function] = ACTIONS(501),
    [anon_sym_QMARK_DOT] = ACTIONS(505),
    [anon_sym_new] = ACTIONS(501),
    [anon_sym_QMARK] = ACTIONS(503),
    [anon_sym_AMP_AMP] = ACTIONS(505),
    [anon_sym_PIPE_PIPE] = ACTIONS(505),
    [anon_sym_GT_GT] = ACTIONS(503),
    [anon_sym_GT_GT_GT] = ACTIONS(505),
    [anon_sym_LT_LT] = ACTIONS(505),
    [anon_sym_AMP] = ACTIONS(503),
    [anon_sym_CARET] = ACTIONS(505),
    [anon_sym_PIPE] = ACTIONS(503),
    [anon_sym_PLUS] = ACTIONS(501),
    [anon_sym_DASH] = ACTIONS(501),
    [anon_sym_PERCENT] = ACTIONS(505),
    [anon_sym_STAR_STAR] = ACTIONS(505),
    [anon_sym_LT_EQ] = ACTIONS(505),
    [anon_sym_EQ_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(505),
    [anon_sym_BANG_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(505),
    [anon_sym_GT_EQ] = ACTIONS(505),
    [anon_sym_QMARK_QMARK] = ACTIONS(505),
    [anon_sym_instanceof] = ACTIONS(503),
    [anon_sym_BANG] = ACTIONS(501),
    [anon_sym_TILDE] = ACTIONS(499),
    [anon_sym_typeof] = ACTIONS(501),
    [anon_sym_void] = ACTIONS(501),
    [anon_sym_delete] = ACTIONS(501),
    [anon_sym_PLUS_PLUS] = ACTIONS(499),
    [anon_sym_DASH_DASH] = ACTIONS(499),
    [anon_sym_DQUOTE] = ACTIONS(499),
    [anon_sym_SQUOTE] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(499),
    [sym_number] = ACTIONS(499),
    [sym_this] = ACTIONS(501),
    [sym_super] = ACTIONS(501),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [sym_null] = ACTIONS(501),
    [sym_undefined] = ACTIONS(501),
    [anon_sym_AT] = ACTIONS(499),
    [anon_sym_static] = ACTIONS(501),
    [anon_sym_get] = ACTIONS(501),
    [anon_sym_set] = ACTIONS(501),
    [sym__automatic_semicolon] = ACTIONS(507),
  },
  [60] = {
    [ts_builtin_sym_end] = ACTIONS(509),
    [sym_identifier] = ACTIONS(511),
    [anon_sym_export] = ACTIONS(511),
    [anon_sym_STAR] = ACTIONS(513),
    [anon_sym_default] = ACTIONS(511),
    [anon_sym_LBRACE] = ACTIONS(509),
    [anon_sym_COMMA] = ACTIONS(515),
    [anon_sym_RBRACE] = ACTIONS(509),
    [anon_sym_import] = ACTIONS(511),
    [anon_sym_var] = ACTIONS(511),
    [anon_sym_let] = ACTIONS(511),
    [anon_sym_const] = ACTIONS(511),
    [anon_sym_else] = ACTIONS(511),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_switch] = ACTIONS(511),
    [anon_sym_for] = ACTIONS(511),
    [anon_sym_LPAREN] = ACTIONS(509),
    [anon_sym_await] = ACTIONS(511),
    [anon_sym_in] = ACTIONS(513),
    [anon_sym_while] = ACTIONS(511),
    [anon_sym_do] = ACTIONS(511),
    [anon_sym_try] = ACTIONS(511),
    [anon_sym_with] = ACTIONS(511),
    [anon_sym_break] = ACTIONS(511),
    [anon_sym_continue] = ACTIONS(511),
    [anon_sym_debugger] = ACTIONS(511),
    [anon_sym_return] = ACTIONS(511),
    [anon_sym_throw] = ACTIONS(511),
    [anon_sym_SEMI] = ACTIONS(509),
    [anon_sym_case] = ACTIONS(511),
    [anon_sym_yield] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(509),
    [anon_sym_LT] = ACTIONS(511),
    [anon_sym_GT] = ACTIONS(513),
    [anon_sym_SLASH] = ACTIONS(511),
    [anon_sym_DOT] = ACTIONS(513),
    [anon_sym_class] = ACTIONS(511),
    [anon_sym_async] = ACTIONS(511),
    [anon_sym_function] = ACTIONS(511),
    [anon_sym_QMARK_DOT] = ACTIONS(515),
    [anon_sym_new] = ACTIONS(511),
    [anon_sym_QMARK] = ACTIONS(513),
    [anon_sym_AMP_AMP] = ACTIONS(515),
    [anon_sym_PIPE_PIPE] = ACTIONS(515),
    [anon_sym_GT_GT] = ACTIONS(513),
    [anon_sym_GT_GT_GT] = ACTIONS(515),
    [anon_sym_LT_LT] = ACTIONS(515),
    [anon_sym_AMP] = ACTIONS(513),
    [anon_sym_CARET] = ACTIONS(515),
    [anon_sym_PIPE] = ACTIONS(513),
    [anon_sym_PLUS] = ACTIONS(511),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT] = ACTIONS(515),
    [anon_sym_STAR_STAR] = ACTIONS(515),
    [anon_sym_LT_EQ] = ACTIONS(515),
    [anon_sym_EQ_EQ] = ACTIONS(513),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(515),
    [anon_sym_BANG_EQ] = ACTIONS(513),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(515),
    [anon_sym_GT_EQ] = ACTIONS(515),
    [anon_sym_QMARK_QMARK] = ACTIONS(515),
    [anon_sym_instanceof] = ACTIONS(513),
    [anon_sym_BANG] = ACTIONS(511),
    [anon_sym_TILDE] = ACTIONS(509),
    [anon_sym_typeof] = ACTIONS(511),
    [anon_sym_void] = ACTIONS(511),
    [anon_sym_delete] = ACTIONS(511),
    [anon_sym_PLUS_PLUS] = ACTIONS(509),
    [anon_sym_DASH_DASH] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(509),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(509),
    [sym_number] = ACTIONS(509),
    [sym_this] = ACTIONS(511),
    [sym_super] = ACTIONS(511),
    [sym_true] = ACTIONS(511),
    [sym_false] = ACTIONS(511),
    [sym_null] = ACTIONS(511),
    [sym_undefined] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(509),
    [anon_sym_static] = ACTIONS(511),
    [anon_sym_get] = ACTIONS(511),
    [anon_sym_set] = ACTIONS(511),
    [sym__automatic_semicolon] = ACTIONS(517),
  },
  [61] = {
    [ts_builtin_sym_end] = ACTIONS(519),
    [sym_identifier] = ACTIONS(521),
    [anon_sym_export] = ACTIONS(521),
    [anon_sym_STAR] = ACTIONS(523),
    [anon_sym_default] = ACTIONS(521),
    [anon_sym_LBRACE] = ACTIONS(519),
    [anon_sym_COMMA] = ACTIONS(525),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_import] = ACTIONS(521),
    [anon_sym_var] = ACTIONS(521),
    [anon_sym_let] = ACTIONS(521),
    [anon_sym_const] = ACTIONS(521),
    [anon_sym_else] = ACTIONS(521),
    [anon_sym_if] = ACTIONS(521),
    [anon_sym_switch] = ACTIONS(521),
    [anon_sym_for] = ACTIONS(521),
    [anon_sym_LPAREN] = ACTIONS(519),
    [anon_sym_await] = ACTIONS(521),
    [anon_sym_in] = ACTIONS(523),
    [anon_sym_while] = ACTIONS(521),
    [anon_sym_do] = ACTIONS(521),
    [anon_sym_try] = ACTIONS(521),
    [anon_sym_with] = ACTIONS(521),
    [anon_sym_break] = ACTIONS(521),
    [anon_sym_continue] = ACTIONS(521),
    [anon_sym_debugger] = ACTIONS(521),
    [anon_sym_return] = ACTIONS(521),
    [anon_sym_throw] = ACTIONS(521),
    [anon_sym_SEMI] = ACTIONS(519),
    [anon_sym_case] = ACTIONS(521),
    [anon_sym_yield] = ACTIONS(521),
    [anon_sym_LBRACK] = ACTIONS(519),
    [anon_sym_LT] = ACTIONS(521),
    [anon_sym_GT] = ACTIONS(523),
    [anon_sym_SLASH] = ACTIONS(521),
    [anon_sym_DOT] = ACTIONS(523),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(521),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_QMARK_DOT] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(521),
    [anon_sym_QMARK] = ACTIONS(523),
    [anon_sym_AMP_AMP] = ACTIONS(525),
    [anon_sym_PIPE_PIPE] = ACTIONS(525),
    [anon_sym_GT_GT] = ACTIONS(523),
    [anon_sym_GT_GT_GT] = ACTIONS(525),
    [anon_sym_LT_LT] = ACTIONS(525),
    [anon_sym_AMP] = ACTIONS(523),
    [anon_sym_CARET] = ACTIONS(525),
    [anon_sym_PIPE] = ACTIONS(523),
    [anon_sym_PLUS] = ACTIONS(521),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_PERCENT] = ACTIONS(525),
    [anon_sym_STAR_STAR] = ACTIONS(525),
    [anon_sym_LT_EQ] = ACTIONS(525),
    [anon_sym_EQ_EQ] = ACTIONS(523),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(525),
    [anon_sym_BANG_EQ] = ACTIONS(523),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(525),
    [anon_sym_GT_EQ] = ACTIONS(525),
    [anon_sym_QMARK_QMARK] = ACTIONS(525),
    [anon_sym_instanceof] = ACTIONS(523),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_TILDE] = ACTIONS(519),
    [anon_sym_typeof] = ACTIONS(521),
    [anon_sym_void] = ACTIONS(521),
    [anon_sym_delete] = ACTIONS(521),
    [anon_sym_PLUS_PLUS] = ACTIONS(519),
    [anon_sym_DASH_DASH] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(519),
    [sym_number] = ACTIONS(519),
    [sym_this] = ACTIONS(521),
    [sym_super] = ACTIONS(521),
    [sym_true] = ACTIONS(521),
    [sym_false] = ACTIONS(521),
    [sym_null] = ACTIONS(521),
    [sym_undefined] = ACTIONS(521),
    [anon_sym_AT] = ACTIONS(519),
    [anon_sym_static] = ACTIONS(521),
    [anon_sym_get] = ACTIONS(521),
    [anon_sym_set] = ACTIONS(521),
    [sym__automatic_semicolon] = ACTIONS(527),
  },
  [62] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(463),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(903),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_spread_element] = STATE(875),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(857),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_repeat1] = STATE(910),
    [aux_sym_array_pattern_repeat1] = STATE(908),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(535),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [63] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(463),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(903),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_spread_element] = STATE(875),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(857),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_repeat1] = STATE(910),
    [aux_sym_array_pattern_repeat1] = STATE(908),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(543),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [64] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(463),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(903),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_spread_element] = STATE(875),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(857),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_repeat1] = STATE(910),
    [aux_sym_array_pattern_repeat1] = STATE(908),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(545),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [65] = {
    [sym_import] = STATE(553),
    [sym_expression_statement] = STATE(79),
    [sym_variable_declaration] = STATE(79),
    [sym_lexical_declaration] = STATE(79),
    [sym_empty_statement] = STATE(79),
    [sym_parenthesized_expression] = STATE(323),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(937),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(937),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(323),
    [sym_subscript_expression] = STATE(323),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(937),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(547),
    [anon_sym_export] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(553),
    [anon_sym_let] = ACTIONS(555),
    [anon_sym_const] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(549),
    [anon_sym_get] = ACTIONS(549),
    [anon_sym_set] = ACTIONS(549),
  },
  [66] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(480),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(903),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_spread_element] = STATE(905),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(857),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_repeat1] = STATE(906),
    [aux_sym_array_pattern_repeat1] = STATE(908),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(561),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [67] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(485),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(903),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_spread_element] = STATE(905),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(857),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_repeat1] = STATE(906),
    [aux_sym_array_pattern_repeat1] = STATE(908),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(561),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [68] = {
    [sym_import] = STATE(553),
    [sym_expression_statement] = STATE(81),
    [sym_variable_declaration] = STATE(81),
    [sym_lexical_declaration] = STATE(81),
    [sym_empty_statement] = STATE(81),
    [sym_parenthesized_expression] = STATE(323),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(937),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(937),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(323),
    [sym_subscript_expression] = STATE(323),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(937),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(547),
    [anon_sym_export] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(551),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(553),
    [anon_sym_let] = ACTIONS(555),
    [anon_sym_const] = ACTIONS(555),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(549),
    [anon_sym_get] = ACTIONS(549),
    [anon_sym_set] = ACTIONS(549),
  },
  [69] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(463),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(903),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_spread_element] = STATE(875),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(857),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_repeat1] = STATE(910),
    [aux_sym_array_pattern_repeat1] = STATE(908),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(563),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [70] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(480),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(903),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_spread_element] = STATE(905),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(857),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_repeat1] = STATE(906),
    [aux_sym_array_pattern_repeat1] = STATE(908),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(565),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [71] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(458),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(1066),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_spread_element] = STATE(942),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(943),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_COMMA] = ACTIONS(567),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_RBRACK] = ACTIONS(567),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [72] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(585),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(903),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(857),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_pattern_repeat1] = STATE(908),
    [sym_identifier] = ACTIONS(570),
    [anon_sym_export] = ACTIONS(572),
    [anon_sym_LBRACE] = ACTIONS(574),
    [anon_sym_COMMA] = ACTIONS(576),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(578),
    [anon_sym_RBRACK] = ACTIONS(580),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(582),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
  },
  [73] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(568),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(902),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1169),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(845),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(586),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [74] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(576),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(854),
    [sym_assignment_pattern] = STATE(902),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(854),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(854),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1167),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(845),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(586),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(531),
    [anon_sym_get] = ACTIONS(531),
    [anon_sym_set] = ACTIONS(531),
  },
  [75] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(471),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_spread_element] = STATE(952),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_repeat1] = STATE(953),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(588),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(590),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [76] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(458),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_spread_element] = STATE(942),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(594),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(594),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_RBRACK] = ACTIONS(594),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [77] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(460),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_spread_element] = STATE(954),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [aux_sym_array_repeat1] = STATE(955),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(588),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(596),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [78] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(509),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_spread_element] = STATE(1183),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1183),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [79] = {
    [sym_import] = STATE(553),
    [sym_expression_statement] = STATE(86),
    [sym_empty_statement] = STATE(86),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [80] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(560),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_spread_element] = STATE(1186),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1186),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(600),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [81] = {
    [sym_import] = STATE(553),
    [sym_expression_statement] = STATE(85),
    [sym_empty_statement] = STATE(85),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(477),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1030),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [82] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(338),
    [sym_expression] = STATE(591),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(886),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(886),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(338),
    [sym_subscript_expression] = STATE(338),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(886),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(602),
    [anon_sym_export] = ACTIONS(604),
    [anon_sym_LBRACE] = ACTIONS(606),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_var] = ACTIONS(608),
    [anon_sym_let] = ACTIONS(608),
    [anon_sym_const] = ACTIONS(608),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(612),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(604),
    [anon_sym_get] = ACTIONS(604),
    [anon_sym_set] = ACTIONS(604),
  },
  [83] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(547),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(888),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(888),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(888),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [sym_pattern] = STATE(1019),
    [sym_rest_pattern] = STATE(776),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(614),
    [anon_sym_export] = ACTIONS(616),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(618),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(584),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(616),
    [anon_sym_get] = ACTIONS(616),
    [anon_sym_set] = ACTIONS(616),
  },
  [84] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(468),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1100),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(620),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
    [sym__automatic_semicolon] = ACTIONS(620),
  },
  [85] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(566),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1131),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(622),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [86] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(502),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1157),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(624),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [87] = {
    [sym_import] = STATE(553),
    [sym_statement_block] = STATE(538),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(444),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [88] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(348),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(828),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [89] = {
    [sym_export_clause] = STATE(811),
    [sym_declaration] = STATE(283),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_class_declaration] = STATE(251),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function_declaration] = STATE(251),
    [sym_decorator] = STATE(673),
    [aux_sym_export_statement_repeat1] = STATE(853),
    [aux_sym_object_repeat1] = STATE(932),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_default] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_var] = ACTIONS(638),
    [anon_sym_let] = ACTIONS(640),
    [anon_sym_const] = ACTIONS(640),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(634),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(634),
    [anon_sym_class] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_function] = ACTIONS(656),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [90] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(591),
    [sym_primary_expression] = STATE(370),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(662),
    [anon_sym_export] = ACTIONS(664),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(666),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(668),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(664),
    [anon_sym_get] = ACTIONS(664),
    [anon_sym_set] = ACTIONS(664),
  },
  [91] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(591),
    [sym_primary_expression] = STATE(370),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(666),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [92] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(469),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1068),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [93] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(576),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1167),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [94] = {
    [sym_import] = STATE(553),
    [sym_statement_block] = STATE(567),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(428),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [95] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(321),
    [sym_expression] = STATE(590),
    [sym_primary_expression] = STATE(461),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(321),
    [sym_subscript_expression] = STATE(321),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(670),
    [anon_sym_export] = ACTIONS(672),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(674),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(676),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(678),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(672),
    [anon_sym_get] = ACTIONS(672),
    [anon_sym_set] = ACTIONS(672),
  },
  [96] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(382),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(368),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [97] = {
    [sym_import] = STATE(553),
    [sym_statement_block] = STATE(514),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(421),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [98] = {
    [sym_export_clause] = STATE(811),
    [sym_declaration] = STATE(283),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_class_declaration] = STATE(251),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function_declaration] = STATE(251),
    [sym_decorator] = STATE(673),
    [aux_sym_export_statement_repeat1] = STATE(853),
    [aux_sym_object_repeat1] = STATE(920),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_default] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(682),
    [anon_sym_var] = ACTIONS(638),
    [anon_sym_let] = ACTIONS(640),
    [anon_sym_const] = ACTIONS(640),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(634),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(634),
    [anon_sym_class] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_function] = ACTIONS(656),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [99] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(436),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(355),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [100] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(433),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(356),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [101] = {
    [sym_import] = STATE(553),
    [sym_statement_block] = STATE(530),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(437),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [102] = {
    [sym_export_clause] = STATE(811),
    [sym_declaration] = STATE(283),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_class_declaration] = STATE(251),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function_declaration] = STATE(251),
    [sym_decorator] = STATE(673),
    [aux_sym_export_statement_repeat1] = STATE(853),
    [aux_sym_object_repeat1] = STATE(932),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_default] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(684),
    [anon_sym_var] = ACTIONS(638),
    [anon_sym_let] = ACTIONS(640),
    [anon_sym_const] = ACTIONS(640),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(634),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(634),
    [anon_sym_class] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_function] = ACTIONS(656),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [103] = {
    [sym_import] = STATE(553),
    [sym_statement_block] = STATE(536),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(443),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [104] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(562),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1179),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [105] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(487),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1180),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [106] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(374),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(357),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [107] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(476),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_sequence_expression] = STATE(1000),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [108] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(591),
    [sym_primary_expression] = STATE(370),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(674),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [109] = {
    [sym_import] = STATE(553),
    [sym_statement_block] = STATE(501),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(393),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(626),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [110] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(499),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1175),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [111] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(548),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1202),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [112] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(537),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1178),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [113] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(571),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1144),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [114] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(532),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1193),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [115] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(551),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1206),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [116] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(573),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1151),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [117] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(405),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(524),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [118] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(405),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(360),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [119] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(431),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(550),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [120] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(374),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(521),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [121] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(433),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(519),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [122] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(569),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_sequence_expression] = STATE(1138),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [123] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(436),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(518),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [124] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(431),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(350),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(680),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [125] = {
    [sym_import] = STATE(403),
    [sym_statement_block] = STATE(382),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(525),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [126] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(575),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [127] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(572),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [128] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(407),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [129] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(454),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [130] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(547),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [131] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(363),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [132] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(359),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [133] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(457),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [134] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(438),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [135] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(585),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [136] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(422),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [137] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(349),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [138] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(340),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [139] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(347),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [140] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(365),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [141] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(369),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [142] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(342),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [143] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(341),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [144] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(340),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [145] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(362),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [146] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(366),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [147] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(512),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [148] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(528),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [149] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(389),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [150] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(542),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [151] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(343),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [152] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(440),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [153] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(564),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [154] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(503),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [155] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(543),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [156] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(540),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [157] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(372),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [158] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(539),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [159] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(533),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [160] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(343),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [161] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(488),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [162] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(527),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [163] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(364),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [164] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(580),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [165] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(584),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [166] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(475),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [167] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(425),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [168] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(578),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [169] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(574),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [170] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(419),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [171] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(511),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [172] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(556),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [173] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(352),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [174] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(341),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [175] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(354),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [176] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(526),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [177] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(379),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [178] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(484),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [179] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(379),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(887),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(887),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(887),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [180] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(392),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [181] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(583),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [182] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(371),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [183] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(449),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [184] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(434),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [185] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(394),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [186] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(379),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(923),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(923),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(923),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(690),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [187] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(402),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [188] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(404),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [189] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(313),
    [sym_expression] = STATE(342),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1174),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1174),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(313),
    [sym_subscript_expression] = STATE(313),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(657),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1174),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1205),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(359),
    [anon_sym_void] = ACTIONS(359),
    [anon_sym_delete] = ACTIONS(359),
    [anon_sym_PLUS_PLUS] = ACTIONS(361),
    [anon_sym_DASH_DASH] = ACTIONS(361),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [190] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(412),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [191] = {
    [sym_import] = STATE(403),
    [sym_parenthesized_expression] = STATE(300),
    [sym_expression] = STATE(586),
    [sym_primary_expression] = STATE(401),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(403),
    [sym_object_pattern] = STATE(1155),
    [sym_array] = STATE(403),
    [sym_array_pattern] = STATE(1155),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(688),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(403),
    [sym_function] = STATE(403),
    [sym_generator_function] = STATE(403),
    [sym_arrow_function] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(300),
    [sym_subscript_expression] = STATE(300),
    [sym_assignment_expression] = STATE(400),
    [sym__augmented_assignment_lhs] = STATE(653),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym__destructuring_pattern] = STATE(1155),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(403),
    [sym_template_string] = STATE(403),
    [sym_regex] = STATE(403),
    [sym_meta_property] = STATE(403),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1172),
    [aux_sym_export_statement_repeat1] = STATE(814),
    [sym_identifier] = ACTIONS(391),
    [anon_sym_export] = ACTIONS(393),
    [anon_sym_LBRACE] = ACTIONS(397),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(399),
    [anon_sym_yield] = ACTIONS(401),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(537),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(411),
    [anon_sym_typeof] = ACTIONS(413),
    [anon_sym_void] = ACTIONS(413),
    [anon_sym_delete] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(415),
    [anon_sym_DASH_DASH] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [sym_number] = ACTIONS(369),
    [sym_this] = ACTIONS(371),
    [sym_super] = ACTIONS(371),
    [sym_true] = ACTIONS(371),
    [sym_false] = ACTIONS(371),
    [sym_null] = ACTIONS(371),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(393),
    [anon_sym_get] = ACTIONS(393),
    [anon_sym_set] = ACTIONS(393),
  },
  [192] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(408),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [193] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(409),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [194] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(410),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [195] = {
    [sym_import] = STATE(553),
    [sym_parenthesized_expression] = STATE(316),
    [sym_expression] = STATE(411),
    [sym_primary_expression] = STATE(494),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(553),
    [sym_object_pattern] = STATE(1190),
    [sym_array] = STATE(553),
    [sym_array_pattern] = STATE(1190),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(697),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(553),
    [sym_function] = STATE(553),
    [sym_generator_function] = STATE(553),
    [sym_arrow_function] = STATE(553),
    [sym_call_expression] = STATE(553),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(316),
    [sym_subscript_expression] = STATE(316),
    [sym_assignment_expression] = STATE(495),
    [sym__augmented_assignment_lhs] = STATE(661),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym__destructuring_pattern] = STATE(1190),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(553),
    [sym_template_string] = STATE(553),
    [sym_regex] = STATE(553),
    [sym_meta_property] = STATE(553),
    [sym_decorator] = STATE(673),
    [sym_formal_parameters] = STATE(1187),
    [aux_sym_export_statement_repeat1] = STATE(870),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(385),
    [anon_sym_async] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [196] = {
    [sym_export_clause] = STATE(811),
    [sym_declaration] = STATE(283),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_class_declaration] = STATE(251),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function_declaration] = STATE(251),
    [sym_decorator] = STATE(673),
    [aux_sym_export_statement_repeat1] = STATE(835),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_default] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_var] = ACTIONS(638),
    [anon_sym_let] = ACTIONS(640),
    [anon_sym_const] = ACTIONS(640),
    [anon_sym_LPAREN] = ACTIONS(634),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(692),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(634),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(634),
    [anon_sym_class] = ACTIONS(696),
    [anon_sym_async] = ACTIONS(698),
    [anon_sym_function] = ACTIONS(700),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [197] = {
    [sym_export_clause] = STATE(811),
    [sym_declaration] = STATE(283),
    [sym_variable_declaration] = STATE(251),
    [sym_lexical_declaration] = STATE(251),
    [sym_class_declaration] = STATE(251),
    [sym_function_declaration] = STATE(251),
    [sym_generator_function_declaration] = STATE(251),
    [sym_decorator] = STATE(673),
    [aux_sym_export_statement_repeat1] = STATE(853),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_default] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_var] = ACTIONS(638),
    [anon_sym_let] = ACTIONS(640),
    [anon_sym_const] = ACTIONS(640),
    [anon_sym_LPAREN] = ACTIONS(634),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(702),
    [anon_sym_EQ] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(634),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(634),
    [anon_sym_class] = ACTIONS(652),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_function] = ACTIONS(656),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [198] = {
    [sym_string] = STATE(1109),
    [sym_formal_parameters] = STATE(1164),
    [sym__property_name] = STATE(1109),
    [sym_computed_property_name] = STATE(1109),
    [aux_sym_object_repeat1] = STATE(932),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [sym_identifier] = ACTIONS(704),
    [anon_sym_export] = ACTIONS(706),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(684),
    [anon_sym_LPAREN] = ACTIONS(711),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_async] = ACTIONS(706),
    [anon_sym_function] = ACTIONS(718),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(706),
    [anon_sym_get] = ACTIONS(722),
    [anon_sym_set] = ACTIONS(722),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [199] = {
    [sym_string] = STATE(1109),
    [sym_formal_parameters] = STATE(1164),
    [sym__property_name] = STATE(1109),
    [sym_computed_property_name] = STATE(1109),
    [aux_sym_object_repeat1] = STATE(920),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [sym_identifier] = ACTIONS(704),
    [anon_sym_export] = ACTIONS(706),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(682),
    [anon_sym_LPAREN] = ACTIONS(711),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_async] = ACTIONS(706),
    [anon_sym_function] = ACTIONS(718),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(706),
    [anon_sym_get] = ACTIONS(722),
    [anon_sym_set] = ACTIONS(722),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [200] = {
    [sym_string] = STATE(1109),
    [sym_formal_parameters] = STATE(1164),
    [sym__property_name] = STATE(1109),
    [sym_computed_property_name] = STATE(1109),
    [aux_sym_object_repeat1] = STATE(932),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [sym_identifier] = ACTIONS(704),
    [anon_sym_export] = ACTIONS(706),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_LPAREN] = ACTIONS(711),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_async] = ACTIONS(706),
    [anon_sym_function] = ACTIONS(718),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(706),
    [anon_sym_get] = ACTIONS(722),
    [anon_sym_set] = ACTIONS(722),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [201] = {
    [sym_string] = STATE(1109),
    [sym__property_name] = STATE(1109),
    [sym_computed_property_name] = STATE(1109),
    [aux_sym_object_repeat1] = STATE(920),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(682),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_async] = ACTIONS(726),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(728),
    [anon_sym_set] = ACTIONS(728),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [202] = {
    [sym_string] = STATE(1109),
    [sym__property_name] = STATE(1109),
    [sym_computed_property_name] = STATE(1109),
    [aux_sym_object_repeat1] = STATE(920),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(645),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(682),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_async] = ACTIONS(724),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(724),
    [anon_sym_set] = ACTIONS(724),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [203] = {
    [sym_string] = STATE(1109),
    [sym__property_name] = STATE(1109),
    [sym_computed_property_name] = STATE(1109),
    [aux_sym_object_repeat1] = STATE(932),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(645),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_async] = ACTIONS(724),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(724),
    [anon_sym_set] = ACTIONS(724),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [204] = {
    [sym_string] = STATE(1109),
    [sym__property_name] = STATE(1109),
    [sym_computed_property_name] = STATE(1109),
    [aux_sym_object_repeat1] = STATE(932),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(684),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_async] = ACTIONS(726),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(728),
    [anon_sym_set] = ACTIONS(728),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [205] = {
    [sym_string] = STATE(1109),
    [sym__property_name] = STATE(1109),
    [sym_computed_property_name] = STATE(1109),
    [aux_sym_object_repeat1] = STATE(932),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(645),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(684),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_async] = ACTIONS(724),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(724),
    [anon_sym_set] = ACTIONS(724),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
  [206] = {
    [sym_string] = STATE(1109),
    [sym__property_name] = STATE(1109),
    [sym_computed_property_name] = STATE(1109),
    [aux_sym_object_repeat1] = STATE(932),
    [aux_sym_object_pattern_repeat1] = STATE(921),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_export] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_LPAREN] = ACTIONS(642),
    [anon_sym_in] = ACTIONS(645),
    [anon_sym_SEMI] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LT] = ACTIONS(645),
    [anon_sym_GT] = ACTIONS(645),
    [anon_sym_SLASH] = ACTIONS(645),
    [anon_sym_DOT] = ACTIONS(645),
    [anon_sym_async] = ACTIONS(726),
    [anon_sym_EQ_GT] = ACTIONS(658),
    [anon_sym_QMARK_DOT] = ACTIONS(634),
    [anon_sym_PLUS_EQ] = ACTIONS(660),
    [anon_sym_DASH_EQ] = ACTIONS(660),
    [anon_sym_STAR_EQ] = ACTIONS(660),
    [anon_sym_SLASH_EQ] = ACTIONS(660),
    [anon_sym_PERCENT_EQ] = ACTIONS(660),
    [anon_sym_CARET_EQ] = ACTIONS(660),
    [anon_sym_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(660),
    [anon_sym_LT_LT_EQ] = ACTIONS(660),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(660),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(660),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(660),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(660),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_AMP_AMP] = ACTIONS(645),
    [anon_sym_PIPE_PIPE] = ACTIONS(645),
    [anon_sym_GT_GT] = ACTIONS(645),
    [anon_sym_GT_GT_GT] = ACTIONS(645),
    [anon_sym_LT_LT] = ACTIONS(645),
    [anon_sym_AMP] = ACTIONS(645),
    [anon_sym_CARET] = ACTIONS(645),
    [anon_sym_PIPE] = ACTIONS(645),
    [anon_sym_PLUS] = ACTIONS(645),
    [anon_sym_DASH] = ACTIONS(645),
    [anon_sym_PERCENT] = ACTIONS(645),
    [anon_sym_STAR_STAR] = ACTIONS(645),
    [anon_sym_LT_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ] = ACTIONS(645),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ] = ACTIONS(645),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(634),
    [anon_sym_GT_EQ] = ACTIONS(634),
    [anon_sym_QMARK_QMARK] = ACTIONS(645),
    [anon_sym_instanceof] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(634),
    [anon_sym_DASH_DASH] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(634),
    [sym_number] = ACTIONS(720),
    [anon_sym_static] = ACTIONS(724),
    [anon_sym_get] = ACTIONS(728),
    [anon_sym_set] = ACTIONS(728),
    [sym__automatic_semicolon] = ACTIONS(634),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      sym__automatic_semicolon,
    ACTIONS(417), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(419), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [73] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 1,
      sym__automatic_semicolon,
    ACTIONS(429), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(431), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [146] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 1,
      sym_identifier,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_EQ,
    ACTIONS(741), 1,
      anon_sym_function,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(734), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 15,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [233] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 1,
      sym_identifier,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(741), 1,
      anon_sym_function,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(745), 1,
      anon_sym_EQ,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(734), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 15,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [320] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(747), 1,
      sym_identifier,
    ACTIONS(751), 1,
      anon_sym_in,
    ACTIONS(754), 1,
      anon_sym_of,
    ACTIONS(756), 1,
      anon_sym_function,
    STATE(1164), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [410] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(431), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [480] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(747), 1,
      sym_identifier,
    ACTIONS(756), 1,
      anon_sym_function,
    STATE(1164), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [566] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(702), 1,
      anon_sym_COLON,
    ACTIONS(718), 1,
      anon_sym_function,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(747), 1,
      sym_identifier,
    STATE(1164), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [654] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 1,
      anon_sym_catch,
    ACTIONS(764), 1,
      anon_sym_finally,
    STATE(220), 1,
      sym_catch_clause,
    STATE(272), 1,
      sym_finally_clause,
    ACTIONS(758), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(760), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(469), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [802] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(692), 1,
      anon_sym_COLON,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(747), 1,
      sym_identifier,
    ACTIONS(766), 1,
      anon_sym_function,
    STATE(1164), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [890] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(745), 1,
      anon_sym_EQ,
    ACTIONS(747), 1,
      sym_identifier,
    ACTIONS(756), 1,
      anon_sym_function,
    STATE(1164), 1,
      sym_formal_parameters,
    ACTIONS(749), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [976] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 1,
      sym_identifier,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(741), 1,
      anon_sym_function,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(771), 1,
      anon_sym_EQ,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(768), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(734), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1063] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_finally,
    STATE(258), 1,
      sym_finally_clause,
    ACTIONS(774), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(776), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1135] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(741), 1,
      anon_sym_function,
    ACTIONS(745), 1,
      anon_sym_EQ,
    ACTIONS(778), 1,
      sym_identifier,
    ACTIONS(782), 1,
      anon_sym_EQ_GT,
    STATE(1141), 1,
      sym_formal_parameters,
    ACTIONS(780), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 12,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1219] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 1,
      sym_identifier,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(741), 1,
      anon_sym_function,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(768), 1,
      anon_sym_RBRACK,
    ACTIONS(771), 1,
      anon_sym_EQ,
    ACTIONS(784), 1,
      anon_sym_COMMA,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(734), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1307] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(732), 1,
      sym_identifier,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(739), 1,
      anon_sym_EQ,
    ACTIONS(741), 1,
      anon_sym_function,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    STATE(1126), 1,
      sym_formal_parameters,
    ACTIONS(768), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(734), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1393] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      sym__automatic_semicolon,
    ACTIONS(433), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(435), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1462] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(788), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1529] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 1,
      anon_sym_else,
    STATE(252), 1,
      sym_else_clause,
    ACTIONS(790), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(792), 41,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(473), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(796), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(798), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1734] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 1,
      sym__automatic_semicolon,
    ACTIONS(509), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(511), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1803] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 1,
      anon_sym_LPAREN,
    ACTIONS(741), 1,
      anon_sym_function,
    ACTIONS(745), 1,
      anon_sym_EQ,
    ACTIONS(751), 1,
      anon_sym_in,
    ACTIONS(754), 1,
      anon_sym_of,
    ACTIONS(778), 1,
      sym_identifier,
    ACTIONS(782), 1,
      anon_sym_EQ_GT,
    STATE(1141), 1,
      sym_formal_parameters,
    ACTIONS(780), 5,
      anon_sym_export,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(634), 10,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1890] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(443), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(445), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(431), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2024] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(802), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2091] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym__automatic_semicolon,
    ACTIONS(447), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(449), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2160] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 1,
      sym__automatic_semicolon,
    ACTIONS(487), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(489), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2229] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(804), 1,
      sym__automatic_semicolon,
    ACTIONS(417), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(419), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2298] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(469), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2365] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 1,
      sym__automatic_semicolon,
    ACTIONS(499), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(501), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2434] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 1,
      sym__automatic_semicolon,
    ACTIONS(475), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(477), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(808), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2570] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 1,
      sym__automatic_semicolon,
    ACTIONS(457), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(459), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2639] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 1,
      sym__automatic_semicolon,
    ACTIONS(519), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(521), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2708] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 1,
      sym__automatic_semicolon,
    ACTIONS(429), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(431), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(814), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(818), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2909] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(822), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2975] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(824), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(826), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(830), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(834), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3173] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(836), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(838), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(842), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(846), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3371] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(850), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3437] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(854), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3503] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(856), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(858), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(862), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(866), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(870), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(874), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(878), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3899] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(882), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3965] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(886), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4031] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(890), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4097] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(894), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(898), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4229] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(902), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4295] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(904), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(906), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4361] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(908), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(910), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4427] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(912), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(914), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(916), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(918), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4559] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(920), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(922), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(924), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(926), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(930), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(932), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(934), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(936), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(938), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4889] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(940), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(942), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(946), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5021] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(948), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(950), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(952), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(954), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5153] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(958), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5219] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(960), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(962), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(964), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(966), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(970), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(974), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(976), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(978), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5549] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(982), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5615] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(986), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(990), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_else,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5747] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 1,
      anon_sym_COLON,
    ACTIONS(682), 1,
      anon_sym_RBRACE,
    ACTIONS(996), 1,
      anon_sym_LPAREN,
    ACTIONS(999), 1,
      anon_sym_EQ,
    ACTIONS(1001), 1,
      anon_sym_EQ_GT,
    STATE(920), 1,
      aux_sym_object_repeat1,
    STATE(921), 1,
      aux_sym_object_pattern_repeat1,
    ACTIONS(994), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5828] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 1,
      anon_sym_COLON,
    ACTIONS(684), 1,
      anon_sym_RBRACE,
    ACTIONS(996), 1,
      anon_sym_LPAREN,
    ACTIONS(999), 1,
      anon_sym_EQ,
    ACTIONS(1001), 1,
      anon_sym_EQ_GT,
    STATE(921), 1,
      aux_sym_object_pattern_repeat1,
    STATE(932), 1,
      aux_sym_object_repeat1,
    ACTIONS(994), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5909] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 1,
      anon_sym_RBRACE,
    ACTIONS(647), 1,
      anon_sym_COLON,
    ACTIONS(996), 1,
      anon_sym_LPAREN,
    ACTIONS(999), 1,
      anon_sym_EQ,
    ACTIONS(1001), 1,
      anon_sym_EQ_GT,
    STATE(921), 1,
      aux_sym_object_pattern_repeat1,
    STATE(932), 1,
      aux_sym_object_repeat1,
    ACTIONS(994), 14,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5990] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1007), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6054] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1011), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6118] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1015), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6182] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1019), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6246] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(745), 1,
      anon_sym_EQ,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(634), 17,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(645), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6315] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1021), 1,
      anon_sym_EQ,
    ACTIONS(1023), 1,
      anon_sym_EQ_GT,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(994), 17,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6384] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(739), 1,
      anon_sym_EQ,
    ACTIONS(743), 1,
      anon_sym_EQ_GT,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(634), 17,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(645), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6453] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1023), 1,
      anon_sym_EQ_GT,
    ACTIONS(1025), 1,
      anon_sym_EQ,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(994), 17,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6522] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1025), 1,
      anon_sym_EQ,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(994), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6589] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_EQ_GT,
    ACTIONS(1027), 1,
      anon_sym_EQ,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(994), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6657] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(702), 1,
      anon_sym_COLON,
    ACTIONS(634), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6727] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_EQ_GT,
    ACTIONS(1027), 1,
      anon_sym_EQ,
    ACTIONS(1029), 1,
      anon_sym_in,
    ACTIONS(1032), 1,
      anon_sym_of,
    ACTIONS(994), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(992), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6799] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(634), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(645), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6867] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 1,
      anon_sym_COLON,
    ACTIONS(1001), 1,
      anon_sym_EQ_GT,
    ACTIONS(1027), 1,
      anon_sym_EQ,
    ACTIONS(994), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1015), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1007), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7061] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(751), 1,
      anon_sym_in,
    ACTIONS(1034), 1,
      anon_sym_of,
    ACTIONS(634), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7133] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(745), 1,
      anon_sym_EQ,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(634), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(645), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7201] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(658), 1,
      anon_sym_EQ_GT,
    ACTIONS(692), 1,
      anon_sym_COLON,
    ACTIONS(694), 1,
      anon_sym_EQ,
    ACTIONS(634), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(660), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(645), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7271] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 1,
      anon_sym_COLON,
    ACTIONS(1001), 1,
      anon_sym_EQ_GT,
    ACTIONS(1027), 1,
      anon_sym_EQ,
    ACTIONS(994), 15,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7341] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1009), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1011), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7403] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1021), 1,
      anon_sym_EQ,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(994), 17,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7469] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_EQ_GT,
    ACTIONS(1025), 1,
      anon_sym_EQ,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(994), 16,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(992), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1017), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(1019), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7599] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1027), 1,
      anon_sym_EQ,
    ACTIONS(1003), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
   