#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 11
#define STATE_COUNT 1171
#define LARGE_STATE_COUNT 193
#define SYMBOL_COUNT 230
#define ALIAS_COUNT 7
#define TOKEN_COUNT 124
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 34
#define MAX_ALIAS_SEQUENCE_LENGTH 7

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_LBRACE = 6,
  anon_sym_COMMA = 7,
  anon_sym_RBRACE = 8,
  anon_sym_as = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_var = 12,
  anon_sym_let = 13,
  anon_sym_const = 14,
  anon_sym_if = 15,
  anon_sym_else = 16,
  anon_sym_switch = 17,
  anon_sym_for = 18,
  anon_sym_LPAREN = 19,
  anon_sym_RPAREN = 20,
  anon_sym_await = 21,
  anon_sym_in = 22,
  anon_sym_of = 23,
  anon_sym_while = 24,
  anon_sym_do = 25,
  anon_sym_try = 26,
  anon_sym_with = 27,
  anon_sym_break = 28,
  anon_sym_continue = 29,
  anon_sym_debugger = 30,
  anon_sym_return = 31,
  anon_sym_throw = 32,
  anon_sym_SEMI = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_SLASH = 44,
  sym_jsx_text = 45,
  sym_jsx_identifier = 46,
  anon_sym_DOT = 47,
  anon_sym_class = 48,
  anon_sym_extends = 49,
  anon_sym_async = 50,
  anon_sym_function = 51,
  anon_sym_EQ_GT = 52,
  anon_sym_QMARK_DOT = 53,
  anon_sym_new = 54,
  anon_sym_PLUS_EQ = 55,
  anon_sym_DASH_EQ = 56,
  anon_sym_STAR_EQ = 57,
  anon_sym_SLASH_EQ = 58,
  anon_sym_PERCENT_EQ = 59,
  anon_sym_CARET_EQ = 60,
  anon_sym_AMP_EQ = 61,
  anon_sym_PIPE_EQ = 62,
  anon_sym_GT_GT_EQ = 63,
  anon_sym_GT_GT_GT_EQ = 64,
  anon_sym_LT_LT_EQ = 65,
  anon_sym_STAR_STAR_EQ = 66,
  anon_sym_AMP_AMP_EQ = 67,
  anon_sym_PIPE_PIPE_EQ = 68,
  anon_sym_QMARK_QMARK_EQ = 69,
  anon_sym_DOT_DOT_DOT = 70,
  anon_sym_QMARK = 71,
  anon_sym_AMP_AMP = 72,
  anon_sym_PIPE_PIPE = 73,
  anon_sym_GT_GT = 74,
  anon_sym_GT_GT_GT = 75,
  anon_sym_LT_LT = 76,
  anon_sym_AMP = 77,
  anon_sym_CARET = 78,
  anon_sym_PIPE = 79,
  anon_sym_PLUS = 80,
  anon_sym_DASH = 81,
  anon_sym_PERCENT = 82,
  anon_sym_STAR_STAR = 83,
  anon_sym_LT_EQ = 84,
  anon_sym_EQ_EQ = 85,
  anon_sym_EQ_EQ_EQ = 86,
  anon_sym_BANG_EQ = 87,
  anon_sym_BANG_EQ_EQ = 88,
  anon_sym_GT_EQ = 89,
  anon_sym_QMARK_QMARK = 90,
  anon_sym_instanceof = 91,
  anon_sym_BANG = 92,
  anon_sym_TILDE = 93,
  anon_sym_typeof = 94,
  anon_sym_void = 95,
  anon_sym_delete = 96,
  anon_sym_PLUS_PLUS = 97,
  anon_sym_DASH_DASH = 98,
  anon_sym_DQUOTE = 99,
  aux_sym_string_token1 = 100,
  anon_sym_SQUOTE = 101,
  aux_sym_string_token2 = 102,
  sym_escape_sequence = 103,
  sym_comment = 104,
  anon_sym_BQUOTE = 105,
  anon_sym_DOLLAR_LBRACE = 106,
  anon_sym_SLASH2 = 107,
  sym_regex_pattern = 108,
  sym_regex_flags = 109,
  sym_number = 110,
  anon_sym_target = 111,
  sym_this = 112,
  sym_super = 113,
  sym_true = 114,
  sym_false = 115,
  sym_null = 116,
  sym_undefined = 117,
  anon_sym_AT = 118,
  anon_sym_static = 119,
  anon_sym_get = 120,
  anon_sym_set = 121,
  sym__automatic_semicolon = 122,
  sym__template_chars = 123,
  sym_program = 124,
  sym_export_statement = 125,
  sym_export_clause = 126,
  sym__import_export_specifier = 127,
  sym__declaration = 128,
  sym_import = 129,
  sym_import_statement = 130,
  sym_import_clause = 131,
  sym__from_clause = 132,
  sym_namespace_import = 133,
  sym_named_imports = 134,
  sym_expression_statement = 135,
  sym_variable_declaration = 136,
  sym_lexical_declaration = 137,
  sym_variable_declarator = 138,
  sym_statement_block = 139,
  sym_if_statement = 140,
  sym_switch_statement = 141,
  sym_for_statement = 142,
  sym_for_in_statement = 143,
  sym__for_header = 144,
  sym_while_statement = 145,
  sym_do_statement = 146,
  sym_try_statement = 147,
  sym_with_statement = 148,
  sym_break_statement = 149,
  sym_continue_statement = 150,
  sym_debugger_statement = 151,
  sym_return_statement = 152,
  sym_throw_statement = 153,
  sym_empty_statement = 154,
  sym_labeled_statement = 155,
  sym_switch_body = 156,
  sym_switch_case = 157,
  sym_switch_default = 158,
  sym_catch_clause = 159,
  sym_finally_clause = 160,
  sym_parenthesized_expression = 161,
  sym__expression = 162,
  sym_yield_expression = 163,
  sym_object = 164,
  sym_assignment_pattern = 165,
  sym_array = 166,
  sym_jsx_element = 167,
  sym_jsx_fragment = 168,
  sym_jsx_expression = 169,
  sym_jsx_opening_element = 170,
  sym_nested_identifier = 171,
  sym_jsx_namespace_name = 172,
  sym_jsx_closing_element = 173,
  sym_jsx_self_closing_element = 174,
  sym_jsx_attribute = 175,
  sym_class = 176,
  sym_class_declaration = 177,
  sym_class_heritage = 178,
  sym_function = 179,
  sym_function_declaration = 180,
  sym_generator_function = 181,
  sym_generator_function_declaration = 182,
  sym_arrow_function = 183,
  sym_call_expression = 184,
  sym_new_expression = 185,
  sym_await_expression = 186,
  sym_member_expression = 187,
  sym_subscript_expression = 188,
  sym_assignment_expression = 189,
  sym_augmented_assignment_expression = 190,
  sym__initializer = 191,
  sym_spread_element = 192,
  sym_ternary_expression = 193,
  sym_binary_expression = 194,
  sym_unary_expression = 195,
  sym_update_expression = 196,
  sym_sequence_expression = 197,
  sym_string = 198,
  sym_template_string = 199,
  sym_template_substitution = 200,
  sym_regex = 201,
  sym_meta_property = 202,
  sym_arguments = 203,
  sym_decorator = 204,
  sym_decorator_member_expression = 205,
  sym_decorator_call_expression = 206,
  sym_class_body = 207,
  sym_public_field_definition = 208,
  sym_formal_parameters = 209,
  sym_rest_parameter = 210,
  sym_method_definition = 211,
  sym_pair = 212,
  sym__property_name = 213,
  sym_computed_property_name = 214,
  aux_sym_program_repeat1 = 215,
  aux_sym_export_statement_repeat1 = 216,
  aux_sym_export_clause_repeat1 = 217,
  aux_sym_named_imports_repeat1 = 218,
  aux_sym_variable_declaration_repeat1 = 219,
  aux_sym_switch_body_repeat1 = 220,
  aux_sym_object_repeat1 = 221,
  aux_sym_array_repeat1 = 222,
  aux_sym_jsx_element_repeat1 = 223,
  aux_sym_jsx_opening_element_repeat1 = 224,
  aux_sym_string_repeat1 = 225,
  aux_sym_string_repeat2 = 226,
  aux_sym_template_string_repeat1 = 227,
  aux_sym_class_body_repeat1 = 228,
  aux_sym_formal_parameters_repeat1 = 229,
  alias_sym_array_pattern = 230,
  alias_sym_export_specifier = 231,
  alias_sym_import_specifier = 232,
  alias_sym_object_pattern = 233,
  alias_sym_property_identifier = 234,
  alias_sym_shorthand_property_identifier = 235,
  alias_sym_statement_identifier = 236,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [sym_jsx_text] = "jsx_text",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "??=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_QMARK] = "?",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "??",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token2] = "string_token2",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "_import_export_specifier",
  [sym__declaration] = "_declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__expression] = "_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_array] = "array",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_public_field_definition] = "public_field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_rest_parameter] = "rest_parameter",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_array_pattern] = "array_pattern",
  [alias_sym_export_specifier] = "export_specifier",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_object_pattern] = "object_pattern",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_jsx_text] = sym_jsx_text,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym__declaration] = sym__declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__expression] = sym__expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_array] = sym_array,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_rest_parameter] = sym_rest_parameter,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_array_pattern] = alias_sym_array_pattern,
  [alias_sym_export_specifier] = alias_sym_export_specifier,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_object_pattern] = alias_sym_object_pattern,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_initializer = 19,
  field_key = 20,
  field_label = 21,
  field_left = 22,
  field_member = 23,
  field_name = 24,
  field_object = 25,
  field_open_tag = 26,
  field_operator = 27,
  field_parameter = 28,
  field_parameters = 29,
  field_pattern = 30,
  field_property = 31,
  field_right = 32,
  field_source = 33,
  field_value = 34,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[111] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 2, .length = 1},
  [8] = {.index = 3, .length = 1},
  [9] = {.index = 4, .length = 1},
  [10] = {.index = 4, .length = 1},
  [11] = {.index = 5, .length = 2},
  [12] = {.index = 7, .length = 2},
  [13] = {.index = 9, .length = 2},
  [14] = {.index = 11, .length = 2},
  [15] = {.index = 13, .length = 2},
  [17] = {.index = 15, .length = 1},
  [18] = {.index = 16, .length = 2},
  [19] = {.index = 16, .length = 2},
  [20] = {.index = 16, .length = 2},
  [21] = {.index = 18, .length = 2},
  [22] = {.index = 20, .length = 2},
  [23] = {.index = 22, .length = 3},
  [27] = {.index = 25, .length = 2},
  [28] = {.index = 27, .length = 2},
  [29] = {.index = 29, .length = 2},
  [30] = {.index = 31, .length = 2},
  [31] = {.index = 33, .length = 1},
  [32] = {.index = 34, .length = 1},
  [33] = {.index = 35, .length = 1},
  [34] = {.index = 36, .length = 1},
  [35] = {.index = 37, .length = 1},
  [36] = {.index = 38, .length = 1},
  [37] = {.index = 39, .length = 2},
  [38] = {.index = 41, .length = 1},
  [39] = {.index = 42, .length = 1},
  [40] = {.index = 43, .length = 2},
  [41] = {.index = 45, .length = 2},
  [42] = {.index = 47, .length = 2},
  [43] = {.index = 49, .length = 2},
  [44] = {.index = 51, .length = 2},
  [45] = {.index = 53, .length = 2},
  [46] = {.index = 53, .length = 2},
  [47] = {.index = 45, .length = 2},
  [48] = {.index = 49, .length = 2},
  [49] = {.index = 43, .length = 2},
  [50] = {.index = 47, .length = 2},
  [51] = {.index = 55, .length = 3},
  [52] = {.index = 43, .length = 2},
  [53] = {.index = 43, .length = 2},
  [54] = {.index = 58, .length = 2},
  [55] = {.index = 60, .length = 2},
  [56] = {.index = 62, .length = 2},
  [57] = {.index = 64, .length = 1},
  [58] = {.index = 65, .length = 1},
  [59] = {.index = 66, .length = 2},
  [60] = {.index = 43, .length = 2},
  [61] = {.index = 68, .length = 2},
  [62] = {.index = 70, .length = 3},
  [63] = {.index = 66, .length = 2},
  [64] = {.index = 73, .length = 1},
  [65] = {.index = 74, .length = 3},
  [66] = {.index = 77, .length = 3},
  [67] = {.index = 80, .length = 2},
  [68] = {.index = 82, .length = 2},
  [69] = {.index = 84, .length = 2},
  [70] = {.index = 86, .length = 1},
  [71] = {.index = 87, .length = 2},
  [72] = {.index = 89, .length = 1},
  [73] = {.index = 90, .length = 2},
  [74] = {.index = 92, .length = 2},
  [75] = {.index = 94, .length = 2},
  [76] = {.index = 96, .length = 2},
  [77] = {.index = 98, .length = 2},
  [78] = {.index = 96, .length = 2},
  [79] = {.index = 100, .length = 2},
  [80] = {.index = 102, .length = 3},
  [81] = {.index = 94, .length = 2},
  [82] = {.index = 105, .length = 3},
  [83] = {.index = 108, .length = 2},
  [84] = {.index = 110, .length = 2},
  [85] = {.index = 112, .length = 3},
  [86] = {.index = 115, .length = 2},
  [87] = {.index = 117, .length = 2},
  [88] = {.index = 119, .length = 2},
  [89] = {.index = 121, .length = 3},
  [90] = {.index = 124, .length = 2},
  [91] = {.index = 124, .length = 2},
  [92] = {.index = 126, .length = 3},
  [93] = {.index = 129, .length = 1},
  [94] = {.index = 130, .length = 2},
  [95] = {.index = 132, .length = 3},
  [96] = {.index = 135, .length = 2},
  [97] = {.index = 135, .length = 2},
  [98] = {.index = 137, .length = 3},
  [99] = {.index = 135, .length = 2},
  [100] = {.index = 135, .length = 2},
  [101] = {.index = 140, .length = 3},
  [102] = {.index = 143, .length = 2},
  [103] = {.index = 143, .length = 2},
  [104] = {.index = 143, .length = 2},
  [105] = {.index = 143, .length = 2},
  [106] = {.index = 145, .length = 4},
  [107] = {.index = 149, .length = 2},
  [108] = {.index = 149, .length = 2},
  [109] = {.index = 149, .length = 2},
  [110] = {.index = 151, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_argument, 0},
    {field_operator, 1},
  [9] =
    {field_arguments, 1},
    {field_function, 0},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_source, 1},
  [16] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [18] =
    {field_condition, 1},
    {field_consequence, 2},
  [20] =
    {field_body, 2},
    {field_value, 1},
  [22] =
    {field_body, 2},
    {field_left, 1, .inherited = true},
    {field_right, 1, .inherited = true},
  [25] =
    {field_body, 2},
    {field_condition, 1},
  [27] =
    {field_body, 1},
    {field_handler, 2},
  [29] =
    {field_body, 1},
    {field_finalizer, 2},
  [31] =
    {field_body, 2},
    {field_object, 1},
  [33] =
    {field_label, 1},
  [34] =
    {field_name, 1},
  [35] =
    {field_attribute, 0},
  [36] =
    {field_pattern, 1},
  [37] =
    {field_member, 0},
  [38] =
    {field_property, 0},
  [39] =
    {field_body, 2},
    {field_name, 1},
  [41] =
    {field_body, 2},
  [42] =
    {field_label, 0},
  [43] =
    {field_left, 0},
    {field_right, 2},
  [45] =
    {field_object, 0},
    {field_property, 2},
  [47] =
    {field_body, 2},
    {field_parameter, 0},
  [49] =
    {field_arguments, 2},
    {field_function, 0},
  [51] =
    {field_body, 2},
    {field_parameters, 1},
  [53] =
    {field_arguments, 2},
    {field_constructor, 1},
  [55] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [58] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [60] =
    {field_body, 2},
    {field_parameters, 0},
  [62] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [64] =
    {field_source, 2, .inherited = true},
  [65] =
    {field_value, 2},
  [66] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [68] =
    {field_key, 0},
    {field_value, 2},
  [70] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [73] =
    {field_value, 1},
  [74] =
    {field_body, 3},
    {field_left, 2, .inherited = true},
    {field_right, 2, .inherited = true},
  [77] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [80] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [82] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [84] =
    {field_flags, 3},
    {field_pattern, 1},
  [86] =
    {field_property, 1},
  [87] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [89] =
    {field_member, 1, .inherited = true},
  [90] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [92] =
    {field_body, 3},
    {field_name, 1},
  [94] =
    {field_index, 2},
    {field_object, 0},
  [96] =
    {field_body, 3},
    {field_parameter, 1},
  [98] =
    {field_body, 3},
    {field_parameters, 2},
  [100] =
    {field_body, 3},
    {field_parameters, 1},
  [102] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [105] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [108] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [110] =
    {field_alias, 2},
    {field_name, 0},
  [112] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [115] =
    {field_body, 1},
    {field_condition, 3},
  [117] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [119] =
    {field_body, 4},
    {field_parameters, 3},
  [121] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [124] =
    {field_index, 3},
    {field_object, 0},
  [126] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [129] =
    {field_name, 2},
  [130] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [132] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [135] =
    {field_left, 1},
    {field_right, 3},
  [137] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [140] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [143] =
    {field_left, 2},
    {field_right, 4},
  [145] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [149] =
    {field_body, 4},
    {field_parameter, 2},
  [151] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
};

static TSSymbol ts_alias_sequences[111][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [6] = {
    [0] = alias_sym_object_pattern,
  },
  [7] = {
    [0] = alias_sym_array_pattern,
  },
  [9] = {
    [1] = sym_identifier,
  },
  [16] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [19] = {
    [0] = alias_sym_object_pattern,
  },
  [20] = {
    [0] = alias_sym_array_pattern,
  },
  [24] = {
    [1] = sym_identifier,
  },
  [25] = {
    [1] = alias_sym_object_pattern,
  },
  [26] = {
    [1] = alias_sym_array_pattern,
  },
  [31] = {
    [1] = alias_sym_statement_identifier,
  },
  [39] = {
    [0] = alias_sym_statement_identifier,
  },
  [40] = {
    [0] = sym_identifier,
  },
  [41] = {
    [0] = sym_identifier,
    [2] = alias_sym_property_identifier,
  },
  [42] = {
    [0] = sym_identifier,
  },
  [43] = {
    [0] = sym_identifier,
  },
  [45] = {
    [1] = sym_identifier,
  },
  [47] = {
    [2] = alias_sym_property_identifier,
  },
  [52] = {
    [0] = alias_sym_object_pattern,
  },
  [53] = {
    [0] = alias_sym_array_pattern,
  },
  [59] = {
    [1] = alias_sym_export_specifier,
  },
  [60] = {
    [0] = alias_sym_shorthand_property_identifier,
  },
  [63] = {
    [1] = alias_sym_import_specifier,
  },
  [75] = {
    [0] = sym_identifier,
  },
  [76] = {
    [1] = sym_identifier,
  },
  [90] = {
    [0] = sym_identifier,
  },
  [96] = {
    [1] = sym_identifier,
  },
  [99] = {
    [1] = alias_sym_object_pattern,
  },
  [100] = {
    [1] = alias_sym_array_pattern,
  },
  [102] = {
    [2] = sym_identifier,
  },
  [104] = {
    [2] = alias_sym_object_pattern,
  },
  [105] = {
    [2] = alias_sym_array_pattern,
  },
  [108] = {
    [2] = alias_sym_object_pattern,
  },
  [109] = {
    [2] = alias_sym_array_pattern,
  },
};

static inline bool sym_identifier_character_set_1(int32_t lookahead) {
  return
    lookahead == 0 ||
    (0 <= lookahead && lookahead <= '#') ||
    ('%' <= lookahead && lookahead <= '/') ||
    (':' <= lookahead && lookahead <= '@') ||
    ('[' <= lookahead && lookahead <= '^') ||
    lookahead == '`' ||
    ('{' <= lookahead && lookahead <= '~') ||
    lookahead == 160 ||
    lookahead == 8203 ||
    lookahead == 8288 ||
    lookahead == 65279;
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(148);
      if (lookahead == '"') ADVANCE(152);
      if (lookahead == '#') ADVANCE(6);
      if (lookahead == '$') ADVANCE(192);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(125);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(132);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(134);
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead == '0') ADVANCE(182);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '@') ADVANCE(194);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(128);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(129);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '~') ADVANCE(149);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(58)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead)) ADVANCE(193);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(164);
      if (lookahead != 0) ADVANCE(165);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(160);
      if (lookahead == '\r') ADVANCE(167);
      if (lookahead == 'u') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(171);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(11)
      if (lookahead == '"') ADVANCE(152);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(157);
      if (lookahead != 0) ADVANCE(158);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(153);
      if (lookahead == '\r') ADVANCE(168);
      if (lookahead == 'u') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(171);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '[') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(178);
      if (lookahead != 0) ADVANCE(179);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(62);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(147);
      if (lookahead == '"') ADVANCE(152);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == '+') ADVANCE(131);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '0') ADVANCE(182);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '>') ADVANCE(81);
      if (lookahead == '@') ADVANCE(194);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '~') ADVANCE(149);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(7)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(193);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '"') ADVANCE(152);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(125);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(132);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(134);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(85);
      if (lookahead == '0') ADVANCE(182);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(128);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(129);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          lookahead != '@' &&
          lookahead != '~') ADVANCE(193);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '%') ADVANCE(135);
      if (lookahead == '&') ADVANCE(126);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(131);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(114);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(127);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(180);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(193);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '%') ADVANCE(135);
      if (lookahead == '&') ADVANCE(126);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(131);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(114);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(127);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(10)
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(193);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(152);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      END_STATE();
    case 13:
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      END_STATE();
    case 14:
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(174);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '.') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(112);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(92);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(20)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      if (lookahead != 0 &&
          (lookahead < 0 || '~' < lookahead)) ADVANCE(193);
      END_STATE();
    case 21:
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(89);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(90);
      END_STATE();
    case 22:
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(22)
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 25:
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == ']') ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(25);
      END_STATE();
    case 26:
      if (lookahead == 'u') ADVANCE(30);
      if (lookahead == 'x') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(171);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 27:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 28:
      if (lookahead == 'u') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(171);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 29:
      if (lookahead == '{') ADVANCE(176);
      END_STATE();
    case 30:
      if (lookahead == '{') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 31:
      if (lookahead == '{') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 32:
      if (lookahead == '{') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 33:
      if (lookahead == '}') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 34:
      if (lookahead == '}') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 35:
      if (lookahead == '}') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 36:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 37:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(184);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(185);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(187);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(193);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(186);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(169);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 56:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(25);
      END_STATE();
    case 57:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(179);
      END_STATE();
    case 58:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(148);
      if (lookahead == '"') ADVANCE(152);
      if (lookahead == '#') ADVANCE(6);
      if (lookahead == '$') ADVANCE(192);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(125);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(132);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(134);
      if (lookahead == '.') ADVANCE(93);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '0') ADVANCE(182);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(79);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead == '?') ADVANCE(113);
      if (lookahead == '@') ADVANCE(194);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(128);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(129);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '~') ADVANCE(149);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(58)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead)) ADVANCE(193);
      END_STATE();
    case 59:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(148);
      if (lookahead == '"') ADVANCE(152);
      if (lookahead == '%') ADVANCE(135);
      if (lookahead == '&') ADVANCE(126);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(131);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '0') ADVANCE(182);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(80);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(114);
      if (lookahead == '@') ADVANCE(194);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '^') ADVANCE(127);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(130);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '~') ADVANCE(149);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(59)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead)) ADVANCE(193);
      END_STATE();
    case 60:
      if (eof) ADVANCE(61);
      if (lookahead == '!') ADVANCE(147);
      if (lookahead == '"') ADVANCE(152);
      if (lookahead == '#') ADVANCE(6);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(69);
      if (lookahead == ')') ADVANCE(70);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(131);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(18);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '0') ADVANCE(182);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(71);
      if (lookahead == '<') ADVANCE(78);
      if (lookahead == '=') ADVANCE(75);
      if (lookahead == '>') ADVANCE(81);
      if (lookahead == '@') ADVANCE(194);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(77);
      if (lookahead == '`') ADVANCE(175);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '~') ADVANCE(149);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(60)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (lookahead != 0 &&
          (lookahead < 0 || 31 < lookahead) &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != '^' &&
          lookahead != '|') ADVANCE(193);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(138);
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(137);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(140);
      if (lookahead == '>') ADVANCE(95);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(95);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(124);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(123);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(144);
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(144);
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(174);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(174);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(88);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(90);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(87);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(17);
      if (lookahead != 0) ADVANCE(88);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(87);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(17);
      if (lookahead != 0) ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(89);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(90);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(91);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '?') ADVANCE(146);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(96);
      if (lookahead == '?') ADVANCE(145);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(122);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(121);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(116);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(115);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '|') ADVANCE(118);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(117);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(150);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(150);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(151);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(151);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(143);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead == '/') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(157);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(158);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(163);
      if (lookahead == '/') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead == '/') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(160);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(153);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(27);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(193);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(166);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(170);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(173);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(174);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(174);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '[') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(179);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(27);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(180);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '`' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(193);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(190);
      if (lookahead == '0') ADVANCE(187);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(37);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(38);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(45);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(181);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(190);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(181);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (lookahead == '_') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(189);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(191);
      if (lookahead != 0 &&
          (lookahead < 0 || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(193);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '{') ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < 0 || '#' < lookahead) &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '|' || '~' < lookahead) &&
          lookahead != 160 &&
          lookahead != 8203 &&
          lookahead != 8288 &&
          lookahead != 65279) ADVANCE(193);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(27);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == 'y') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      if (lookahead == 'w') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 25:
      if (lookahead == 'b') ADVANCE(64);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(68);
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(79);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(129);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 96:
      if (lookahead == 'h') ADVANCE(131);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 100:
      if (lookahead == 'k') ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 102:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 125:
      if (lookahead == 'w') ADVANCE(155);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 132:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 143:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(172);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 156:
      if (lookahead == 'f') ADVANCE(174);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 166:
      if (lookahead == 'y') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(182);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(186);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 189:
      if (lookahead == 'f') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 60},
  [2] = {.lex_state = 60},
  [3] = {.lex_state = 60},
  [4] = {.lex_state = 60},
  [5] = {.lex_state = 60},
  [6] = {.lex_state = 60},
  [7] = {.lex_state = 60},
  [8] = {.lex_state = 60},
  [9] = {.lex_state = 60},
  [10] = {.lex_state = 60},
  [11] = {.lex_state = 60},
  [12] = {.lex_state = 60},
  [13] = {.lex_state = 60},
  [14] = {.lex_state = 60},
  [15] = {.lex_state = 60},
  [16] = {.lex_state = 60},
  [17] = {.lex_state = 60},
  [18] = {.lex_state = 60},
  [19] = {.lex_state = 60},
  [20] = {.lex_state = 60},
  [21] = {.lex_state = 60},
  [22] = {.lex_state = 60},
  [23] = {.lex_state = 60},
  [24] = {.lex_state = 60},
  [25] = {.lex_state = 60},
  [26] = {.lex_state = 60},
  [27] = {.lex_state = 60},
  [28] = {.lex_state = 60},
  [29] = {.lex_state = 60},
  [30] = {.lex_state = 60},
  [31] = {.lex_state = 60},
  [32] = {.lex_state = 60},
  [33] = {.lex_state = 60},
  [34] = {.lex_state = 60},
  [35] = {.lex_state = 60},
  [36] = {.lex_state = 60},
  [37] = {.lex_state = 60},
  [38] = {.lex_state = 60},
  [39] = {.lex_state = 60},
  [40] = {.lex_state = 60},
  [41] = {.lex_state = 60},
  [42] = {.lex_state = 60},
  [43] = {.lex_state = 59},
  [44] = {.lex_state = 59, .external_lex_state = 2},
  [45] = {.lex_state = 59, .external_lex_state = 2},
  [46] = {.lex_state = 59, .external_lex_state = 2},
  [47] = {.lex_state = 59, .external_lex_state = 2},
  [48] = {.lex_state = 59, .external_lex_state = 2},
  [49] = {.lex_state = 59, .external_lex_state = 2},
  [50] = {.lex_state = 59, .external_lex_state = 2},
  [51] = {.lex_state = 59, .external_lex_state = 2},
  [52] = {.lex_state = 59, .external_lex_state = 2},
  [53] = {.lex_state = 59, .external_lex_state = 2},
  [54] = {.lex_state = 59, .external_lex_state = 2},
  [55] = {.lex_state = 59, .external_lex_state = 2},
  [56] = {.lex_state = 59, .external_lex_state = 2},
  [57] = {.lex_state = 59, .external_lex_state = 2},
  [58] = {.lex_state = 59, .external_lex_state = 2},
  [59] = {.lex_state = 59, .external_lex_state = 2},
  [60] = {.lex_state = 60},
  [61] = {.lex_state = 60},
  [62] = {.lex_state = 60},
  [63] = {.lex_state = 60},
  [64] = {.lex_state = 60},
  [65] = {.lex_state = 60},
  [66] = {.lex_state = 60},
  [67] = {.lex_state = 60},
  [68] = {.lex_state = 60},
  [69] = {.lex_state = 60},
  [70] = {.lex_state = 60},
  [71] = {.lex_state = 60},
  [72] = {.lex_state = 60},
  [73] = {.lex_state = 60},
  [74] = {.lex_state = 60},
  [75] = {.lex_state = 60, .external_lex_state = 2},
  [76] = {.lex_state = 60},
  [77] = {.lex_state = 60},
  [78] = {.lex_state = 60},
  [79] = {.lex_state = 60},
  [80] = {.lex_state = 60},
  [81] = {.lex_state = 7},
  [82] = {.lex_state = 7},
  [83] = {.lex_state = 60},
  [84] = {.lex_state = 60},
  [85] = {.lex_state = 60},
  [86] = {.lex_state = 7},
  [87] = {.lex_state = 60},
  [88] = {.lex_state = 60},
  [89] = {.lex_state = 60},
  [90] = {.lex_state = 60},
  [91] = {.lex_state = 60},
  [92] = {.lex_state = 60},
  [93] = {.lex_state = 60},
  [94] = {.lex_state = 60},
  [95] = {.lex_state = 60},
  [96] = {.lex_state = 60},
  [97] = {.lex_state = 60},
  [98] = {.lex_state = 60},
  [99] = {.lex_state = 60},
  [100] = {.lex_state = 8, .external_lex_state = 2},
  [101] = {.lex_state = 60},
  [102] = {.lex_state = 60},
  [103] = {.lex_state = 60},
  [104] = {.lex_state = 60},
  [105] = {.lex_state = 60},
  [106] = {.lex_state = 60},
  [107] = {.lex_state = 60},
  [108] = {.lex_state = 60},
  [109] = {.lex_state = 60},
  [110] = {.lex_state = 60},
  [111] = {.lex_state = 60},
  [112] = {.lex_state = 60},
  [113] = {.lex_state = 60},
  [114] = {.lex_state = 60},
  [115] = {.lex_state = 60},
  [116] = {.lex_state = 60},
  [117] = {.lex_state = 60},
  [118] = {.lex_state = 60},
  [119] = {.lex_state = 60},
  [120] = {.lex_state = 8, .external_lex_state = 2},
  [121] = {.lex_state = 60},
  [122] = {.lex_state = 60},
  [123] = {.lex_state = 60},
  [124] = {.lex_state = 60},
  [125] = {.lex_state = 60},
  [126] = {.lex_state = 60},
  [127] = {.lex_state = 60},
  [128] = {.lex_state = 60},
  [129] = {.lex_state = 60},
  [130] = {.lex_state = 60},
  [131] = {.lex_state = 60},
  [132] = {.lex_state = 60},
  [133] = {.lex_state = 60},
  [134] = {.lex_state = 60},
  [135] = {.lex_state = 60},
  [136] = {.lex_state = 60},
  [137] = {.lex_state = 60},
  [138] = {.lex_state = 60},
  [139] = {.lex_state = 60},
  [140] = {.lex_state = 60},
  [141] = {.lex_state = 60},
  [142] = {.lex_state = 60},
  [143] = {.lex_state = 60},
  [144] = {.lex_state = 60},
  [145] = {.lex_state = 60},
  [146] = {.lex_state = 60},
  [147] = {.lex_state = 60},
  [148] = {.lex_state = 60},
  [149] = {.lex_state = 60},
  [150] = {.lex_state = 60},
  [151] = {.lex_state = 60},
  [152] = {.lex_state = 60},
  [153] = {.lex_state = 60},
  [154] = {.lex_state = 60},
  [155] = {.lex_state = 60},
  [156] = {.lex_state = 60},
  [157] = {.lex_state = 60},
  [158] = {.lex_state = 60},
  [159] = {.lex_state = 60},
  [160] = {.lex_state = 60},
  [161] = {.lex_state = 60},
  [162] = {.lex_state = 60},
  [163] = {.lex_state = 60},
  [164] = {.lex_state = 60},
  [165] = {.lex_state = 60},
  [166] = {.lex_state = 60},
  [167] = {.lex_state = 60},
  [168] = {.lex_state = 60},
  [169] = {.lex_state = 60},
  [170] = {.lex_state = 60},
  [171] = {.lex_state = 60},
  [172] = {.lex_state = 60},
  [173] = {.lex_state = 60},
  [174] = {.lex_state = 60},
  [175] = {.lex_state = 60},
  [176] = {.lex_state = 60},
  [177] = {.lex_state = 60},
  [178] = {.lex_state = 60},
  [179] = {.lex_state = 60},
  [180] = {.lex_state = 60},
  [181] = {.lex_state = 60},
  [182] = {.lex_state = 60},
  [183] = {.lex_state = 60},
  [184] = {.lex_state = 60},
  [185] = {.lex_state = 60},
  [186] = {.lex_state = 60},
  [187] = {.lex_state = 60},
  [188] = {.lex_state = 8, .external_lex_state = 2},
  [189] = {.lex_state = 8, .external_lex_state = 2},
  [190] = {.lex_state = 8, .external_lex_state = 2},
  [191] = {.lex_state = 8, .external_lex_state = 2},
  [192] = {.lex_state = 8},
  [193] = {.lex_state = 8},
  [194] = {.lex_state = 60, .external_lex_state = 2},
  [195] = {.lex_state = 60, .external_lex_state = 2},
  [196] = {.lex_state = 8, .external_lex_state = 2},
  [197] = {.lex_state = 60},
  [198] = {.lex_state = 60},
  [199] = {.lex_state = 60},
  [200] = {.lex_state = 8, .external_lex_state = 2},
  [201] = {.lex_state = 8, .external_lex_state = 2},
  [202] = {.lex_state = 8, .external_lex_state = 2},
  [203] = {.lex_state = 8, .external_lex_state = 2},
  [204] = {.lex_state = 8},
  [205] = {.lex_state = 60},
  [206] = {.lex_state = 60},
  [207] = {.lex_state = 60, .external_lex_state = 2},
  [208] = {.lex_state = 60},
  [209] = {.lex_state = 60, .external_lex_state = 2},
  [210] = {.lex_state = 60, .external_lex_state = 2},
  [211] = {.lex_state = 60, .external_lex_state = 2},
  [212] = {.lex_state = 60, .external_lex_state = 2},
  [213] = {.lex_state = 60, .external_lex_state = 2},
  [214] = {.lex_state = 60, .external_lex_state = 2},
  [215] = {.lex_state = 60, .external_lex_state = 2},
  [216] = {.lex_state = 60},
  [217] = {.lex_state = 60},
  [218] = {.lex_state = 60, .external_lex_state = 2},
  [219] = {.lex_state = 60, .external_lex_state = 2},
  [220] = {.lex_state = 60, .external_lex_state = 2},
  [221] = {.lex_state = 60},
  [222] = {.lex_state = 60, .external_lex_state = 2},
  [223] = {.lex_state = 60, .external_lex_state = 2},
  [224] = {.lex_state = 60, .external_lex_state = 2},
  [225] = {.lex_state = 60},
  [226] = {.lex_state = 60},
  [227] = {.lex_state = 60},
  [228] = {.lex_state = 60},
  [229] = {.lex_state = 60},
  [230] = {.lex_state = 60},
  [231] = {.lex_state = 8},
  [232] = {.lex_state = 60},
  [233] = {.lex_state = 60},
  [234] = {.lex_state = 60},
  [235] = {.lex_state = 60},
  [236] = {.lex_state = 60},
  [237] = {.lex_state = 60},
  [238] = {.lex_state = 60},
  [239] = {.lex_state = 60},
  [240] = {.lex_state = 60},
  [241] = {.lex_state = 60},
  [242] = {.lex_state = 60},
  [243] = {.lex_state = 60},
  [244] = {.lex_state = 60},
  [245] = {.lex_state = 60},
  [246] = {.lex_state = 60},
  [247] = {.lex_state = 60},
  [248] = {.lex_state = 60},
  [249] = {.lex_state = 60},
  [250] = {.lex_state = 60},
  [251] = {.lex_state = 60},
  [252] = {.lex_state = 60},
  [253] = {.lex_state = 60},
  [254] = {.lex_state = 60},
  [255] = {.lex_state = 60},
  [256] = {.lex_state = 60},
  [257] = {.lex_state = 60},
  [258] = {.lex_state = 60},
  [259] = {.lex_state = 60},
  [260] = {.lex_state = 60},
  [261] = {.lex_state = 60},
  [262] = {.lex_state = 8},
  [263] = {.lex_state = 60},
  [264] = {.lex_state = 60},
  [265] = {.lex_state = 60},
  [266] = {.lex_state = 60},
  [267] = {.lex_state = 60},
  [268] = {.lex_state = 60},
  [269] = {.lex_state = 60},
  [270] = {.lex_state = 60},
  [271] = {.lex_state = 60},
  [272] = {.lex_state = 8},
  [273] = {.lex_state = 8},
  [274] = {.lex_state = 8},
  [275] = {.lex_state = 8, .external_lex_state = 2},
  [276] = {.lex_state = 8},
  [277] = {.lex_state = 8},
  [278] = {.lex_state = 8},
  [279] = {.lex_state = 8},
  [280] = {.lex_state = 8},
  [281] = {.lex_state = 8},
  [282] = {.lex_state = 8, .external_lex_state = 2},
  [283] = {.lex_state = 8},
  [284] = {.lex_state = 8},
  [285] = {.lex_state = 8},
  [286] = {.lex_state = 8, .external_lex_state = 2},
  [287] = {.lex_state = 8},
  [288] = {.lex_state = 8, .external_lex_state = 2},
  [289] = {.lex_state = 8, .external_lex_state = 2},
  [290] = {.lex_state = 8, .external_lex_state = 2},
  [291] = {.lex_state = 8, .external_lex_state = 2},
  [292] = {.lex_state = 8, .external_lex_state = 2},
  [293] = {.lex_state = 8, .external_lex_state = 2},
  [294] = {.lex_state = 8, .external_lex_state = 2},
  [295] = {.lex_state = 8, .external_lex_state = 2},
  [296] = {.lex_state = 8, .external_lex_state = 2},
  [297] = {.lex_state = 8, .external_lex_state = 2},
  [298] = {.lex_state = 8, .external_lex_state = 2},
  [299] = {.lex_state = 8, .external_lex_state = 2},
  [300] = {.lex_state = 8, .external_lex_state = 2},
  [301] = {.lex_state = 8, .external_lex_state = 2},
  [302] = {.lex_state = 8, .external_lex_state = 2},
  [303] = {.lex_state = 8, .external_lex_state = 2},
  [304] = {.lex_state = 8, .external_lex_state = 2},
  [305] = {.lex_state = 8, .external_lex_state = 2},
  [306] = {.lex_state = 60},
  [307] = {.lex_state = 60},
  [308] = {.lex_state = 60},
  [309] = {.lex_state = 60},
  [310] = {.lex_state = 60},
  [311] = {.lex_state = 60},
  [312] = {.lex_state = 60},
  [313] = {.lex_state = 8},
  [314] = {.lex_state = 60},
  [315] = {.lex_state = 8},
  [316] = {.lex_state = 60},
  [317] = {.lex_state = 8, .external_lex_state = 2},
  [318] = {.lex_state = 8, .external_lex_state = 2},
  [319] = {.lex_state = 8, .external_lex_state = 2},
  [320] = {.lex_state = 8},
  [321] = {.lex_state = 8},
  [322] = {.lex_state = 8},
  [323] = {.lex_state = 8},
  [324] = {.lex_state = 8},
  [325] = {.lex_state = 59},
  [326] = {.lex_state = 8},
  [327] = {.lex_state = 8},
  [328] = {.lex_state = 59},
  [329] = {.lex_state = 59},
  [330] = {.lex_state = 59, .external_lex_state = 2},
  [331] = {.lex_state = 59},
  [332] = {.lex_state = 59},
  [333] = {.lex_state = 59},
  [334] = {.lex_state = 59},
  [335] = {.lex_state = 59},
  [336] = {.lex_state = 59},
  [337] = {.lex_state = 59},
  [338] = {.lex_state = 59},
  [339] = {.lex_state = 59},
  [340] = {.lex_state = 59},
  [341] = {.lex_state = 59},
  [342] = {.lex_state = 59},
  [343] = {.lex_state = 59},
  [344] = {.lex_state = 59},
  [345] = {.lex_state = 59},
  [346] = {.lex_state = 59},
  [347] = {.lex_state = 59},
  [348] = {.lex_state = 59},
  [349] = {.lex_state = 59},
  [350] = {.lex_state = 59},
  [351] = {.lex_state = 59},
  [352] = {.lex_state = 59},
  [353] = {.lex_state = 59},
  [354] = {.lex_state = 59},
  [355] = {.lex_state = 59, .external_lex_state = 2},
  [356] = {.lex_state = 59},
  [357] = {.lex_state = 59},
  [358] = {.lex_state = 59},
  [359] = {.lex_state = 59},
  [360] = {.lex_state = 59},
  [361] = {.lex_state = 59},
  [362] = {.lex_state = 59},
  [363] = {.lex_state = 59},
  [364] = {.lex_state = 59},
  [365] = {.lex_state = 59},
  [366] = {.lex_state = 59},
  [367] = {.lex_state = 59},
  [368] = {.lex_state = 59},
  [369] = {.lex_state = 59},
  [370] = {.lex_state = 59},
  [371] = {.lex_state = 59},
  [372] = {.lex_state = 59},
  [373] = {.lex_state = 59, .external_lex_state = 2},
  [374] = {.lex_state = 59},
  [375] = {.lex_state = 9},
  [376] = {.lex_state = 59, .external_lex_state = 2},
  [377] = {.lex_state = 59},
  [378] = {.lex_state = 59, .external_lex_state = 2},
  [379] = {.lex_state = 59},
  [380] = {.lex_state = 59},
  [381] = {.lex_state = 59, .external_lex_state = 2},
  [382] = {.lex_state = 59},
  [383] = {.lex_state = 59, .external_lex_state = 2},
  [384] = {.lex_state = 59, .external_lex_state = 2},
  [385] = {.lex_state = 59},
  [386] = {.lex_state = 59},
  [387] = {.lex_state = 59, .external_lex_state = 2},
  [388] = {.lex_state = 59},
  [389] = {.lex_state = 59},
  [390] = {.lex_state = 59},
  [391] = {.lex_state = 59, .external_lex_state = 2},
  [392] = {.lex_state = 59, .external_lex_state = 2},
  [393] = {.lex_state = 59, .external_lex_state = 2},
  [394] = {.lex_state = 59, .external_lex_state = 2},
  [395] = {.lex_state = 59, .external_lex_state = 2},
  [396] = {.lex_state = 59, .external_lex_state = 2},
  [397] = {.lex_state = 59},
  [398] = {.lex_state = 59},
  [399] = {.lex_state = 59},
  [400] = {.lex_state = 59, .external_lex_state = 2},
  [401] = {.lex_state = 59, .external_lex_state = 2},
  [402] = {.lex_state = 59, .external_lex_state = 2},
  [403] = {.lex_state = 59, .external_lex_state = 2},
  [404] = {.lex_state = 59, .external_lex_state = 2},
  [405] = {.lex_state = 59},
  [406] = {.lex_state = 59, .external_lex_state = 2},
  [407] = {.lex_state = 59},
  [408] = {.lex_state = 59},
  [409] = {.lex_state = 59},
  [410] = {.lex_state = 59},
  [411] = {.lex_state = 59},
  [412] = {.lex_state = 59},
  [413] = {.lex_state = 59, .external_lex_state = 2},
  [414] = {.lex_state = 59, .external_lex_state = 2},
  [415] = {.lex_state = 59, .external_lex_state = 2},
  [416] = {.lex_state = 59, .external_lex_state = 2},
  [417] = {.lex_state = 59, .external_lex_state = 2},
  [418] = {.lex_state = 59, .external_lex_state = 2},
  [419] = {.lex_state = 59, .external_lex_state = 2},
  [420] = {.lex_state = 59, .external_lex_state = 2},
  [421] = {.lex_state = 59, .external_lex_state = 2},
  [422] = {.lex_state = 59},
  [423] = {.lex_state = 59},
  [424] = {.lex_state = 59, .external_lex_state = 2},
  [425] = {.lex_state = 59, .external_lex_state = 2},
  [426] = {.lex_state = 59, .external_lex_state = 2},
  [427] = {.lex_state = 59},
  [428] = {.lex_state = 59},
  [429] = {.lex_state = 59, .external_lex_state = 2},
  [430] = {.lex_state = 59},
  [431] = {.lex_state = 59},
  [432] = {.lex_state = 59},
  [433] = {.lex_state = 59},
  [434] = {.lex_state = 59, .external_lex_state = 2},
  [435] = {.lex_state = 59},
  [436] = {.lex_state = 59},
  [437] = {.lex_state = 59},
  [438] = {.lex_state = 59},
  [439] = {.lex_state = 59},
  [440] = {.lex_state = 59, .external_lex_state = 2},
  [441] = {.lex_state = 59},
  [442] = {.lex_state = 59},
  [443] = {.lex_state = 59, .external_lex_state = 2},
  [444] = {.lex_state = 59, .external_lex_state = 2},
  [445] = {.lex_state = 59},
  [446] = {.lex_state = 59},
  [447] = {.lex_state = 59},
  [448] = {.lex_state = 59},
  [449] = {.lex_state = 59},
  [450] = {.lex_state = 59},
  [451] = {.lex_state = 59},
  [452] = {.lex_state = 59, .external_lex_state = 2},
  [453] = {.lex_state = 59},
  [454] = {.lex_state = 59, .external_lex_state = 2},
  [455] = {.lex_state = 59, .external_lex_state = 2},
  [456] = {.lex_state = 59, .external_lex_state = 2},
  [457] = {.lex_state = 59},
  [458] = {.lex_state = 59, .external_lex_state = 2},
  [459] = {.lex_state = 59, .external_lex_state = 2},
  [460] = {.lex_state = 59},
  [461] = {.lex_state = 59},
  [462] = {.lex_state = 59, .external_lex_state = 2},
  [463] = {.lex_state = 59, .external_lex_state = 2},
  [464] = {.lex_state = 59, .external_lex_state = 2},
  [465] = {.lex_state = 59},
  [466] = {.lex_state = 59, .external_lex_state = 2},
  [467] = {.lex_state = 59},
  [468] = {.lex_state = 59, .external_lex_state = 2},
  [469] = {.lex_state = 59, .external_lex_state = 2},
  [470] = {.lex_state = 59, .external_lex_state = 2},
  [471] = {.lex_state = 59, .external_lex_state = 2},
  [472] = {.lex_state = 59},
  [473] = {.lex_state = 59},
  [474] = {.lex_state = 59},
  [475] = {.lex_state = 59, .external_lex_state = 2},
  [476] = {.lex_state = 59, .external_lex_state = 2},
  [477] = {.lex_state = 59, .external_lex_state = 2},
  [478] = {.lex_state = 59, .external_lex_state = 2},
  [479] = {.lex_state = 59},
  [480] = {.lex_state = 59, .external_lex_state = 2},
  [481] = {.lex_state = 59, .external_lex_state = 2},
  [482] = {.lex_state = 59},
  [483] = {.lex_state = 59},
  [484] = {.lex_state = 59},
  [485] = {.lex_state = 59, .external_lex_state = 2},
  [486] = {.lex_state = 59, .external_lex_state = 2},
  [487] = {.lex_state = 59, .external_lex_state = 2},
  [488] = {.lex_state = 59, .external_lex_state = 2},
  [489] = {.lex_state = 9, .external_lex_state = 2},
  [490] = {.lex_state = 59, .external_lex_state = 2},
  [491] = {.lex_state = 59, .external_lex_state = 2},
  [492] = {.lex_state = 59},
  [493] = {.lex_state = 59},
  [494] = {.lex_state = 59, .external_lex_state = 2},
  [495] = {.lex_state = 59, .external_lex_state = 2},
  [496] = {.lex_state = 59, .external_lex_state = 2},
  [497] = {.lex_state = 59, .external_lex_state = 2},
  [498] = {.lex_state = 59, .external_lex_state = 2},
  [499] = {.lex_state = 59, .external_lex_state = 2},
  [500] = {.lex_state = 59, .external_lex_state = 2},
  [501] = {.lex_state = 59},
  [502] = {.lex_state = 59, .external_lex_state = 2},
  [503] = {.lex_state = 59, .external_lex_state = 2},
  [504] = {.lex_state = 59, .external_lex_state = 2},
  [505] = {.lex_state = 59, .external_lex_state = 2},
  [506] = {.lex_state = 59, .external_lex_state = 2},
  [507] = {.lex_state = 59, .external_lex_state = 2},
  [508] = {.lex_state = 59, .external_lex_state = 2},
  [509] = {.lex_state = 59},
  [510] = {.lex_state = 59, .external_lex_state = 2},
  [511] = {.lex_state = 59, .external_lex_state = 2},
  [512] = {.lex_state = 59, .external_lex_state = 2},
  [513] = {.lex_state = 59, .external_lex_state = 2},
  [514] = {.lex_state = 59, .external_lex_state = 2},
  [515] = {.lex_state = 59, .external_lex_state = 2},
  [516] = {.lex_state = 59, .external_lex_state = 2},
  [517] = {.lex_state = 59, .external_lex_state = 2},
  [518] = {.lex_state = 59, .external_lex_state = 2},
  [519] = {.lex_state = 59, .external_lex_state = 2},
  [520] = {.lex_state = 59},
  [521] = {.lex_state = 59},
  [522] = {.lex_state = 59},
  [523] = {.lex_state = 59},
  [524] = {.lex_state = 59},
  [525] = {.lex_state = 59},
  [526] = {.lex_state = 59},
  [527] = {.lex_state = 59, .external_lex_state = 2},
  [528] = {.lex_state = 59},
  [529] = {.lex_state = 59},
  [530] = {.lex_state = 59},
  [531] = {.lex_state = 59, .external_lex_state = 2},
  [532] = {.lex_state = 59, .external_lex_state = 2},
  [533] = {.lex_state = 59},
  [534] = {.lex_state = 59},
  [535] = {.lex_state = 59},
  [536] = {.lex_state = 59, .external_lex_state = 2},
  [537] = {.lex_state = 59, .external_lex_state = 2},
  [538] = {.lex_state = 59, .external_lex_state = 2},
  [539] = {.lex_state = 59, .external_lex_state = 2},
  [540] = {.lex_state = 59, .external_lex_state = 2},
  [541] = {.lex_state = 59, .external_lex_state = 2},
  [542] = {.lex_state = 59, .external_lex_state = 2},
  [543] = {.lex_state = 59},
  [544] = {.lex_state = 59, .external_lex_state = 2},
  [545] = {.lex_state = 59, .external_lex_state = 2},
  [546] = {.lex_state = 59, .external_lex_state = 2},
  [547] = {.lex_state = 59},
  [548] = {.lex_state = 59, .external_lex_state = 2},
  [549] = {.lex_state = 59},
  [550] = {.lex_state = 59, .external_lex_state = 2},
  [551] = {.lex_state = 59},
  [552] = {.lex_state = 59, .external_lex_state = 2},
  [553] = {.lex_state = 59, .external_lex_state = 2},
  [554] = {.lex_state = 59},
  [555] = {.lex_state = 59, .external_lex_state = 2},
  [556] = {.lex_state = 59, .external_lex_state = 2},
  [557] = {.lex_state = 59, .external_lex_state = 2},
  [558] = {.lex_state = 59, .external_lex_state = 2},
  [559] = {.lex_state = 59, .external_lex_state = 2},
  [560] = {.lex_state = 59, .external_lex_state = 2},
  [561] = {.lex_state = 59},
  [562] = {.lex_state = 59},
  [563] = {.lex_state = 59},
  [564] = {.lex_state = 59},
  [565] = {.lex_state = 59},
  [566] = {.lex_state = 59},
  [567] = {.lex_state = 59, .external_lex_state = 2},
  [568] = {.lex_state = 59},
  [569] = {.lex_state = 59, .external_lex_state = 2},
  [570] = {.lex_state = 59},
  [571] = {.lex_state = 59, .external_lex_state = 2},
  [572] = {.lex_state = 59},
  [573] = {.lex_state = 59, .external_lex_state = 2},
  [574] = {.lex_state = 59},
  [575] = {.lex_state = 59, .external_lex_state = 2},
  [576] = {.lex_state = 59},
  [577] = {.lex_state = 59},
  [578] = {.lex_state = 59, .external_lex_state = 2},
  [579] = {.lex_state = 59},
  [580] = {.lex_state = 59, .external_lex_state = 2},
  [581] = {.lex_state = 59, .external_lex_state = 2},
  [582] = {.lex_state = 59, .external_lex_state = 2},
  [583] = {.lex_state = 59, .external_lex_state = 2},
  [584] = {.lex_state = 59, .external_lex_state = 2},
  [585] = {.lex_state = 59},
  [586] = {.lex_state = 59},
  [587] = {.lex_state = 59},
  [588] = {.lex_state = 59},
  [589] = {.lex_state = 59},
  [590] = {.lex_state = 59},
  [591] = {.lex_state = 59},
  [592] = {.lex_state = 59},
  [593] = {.lex_state = 59},
  [594] = {.lex_state = 59},
  [595] = {.lex_state = 59},
  [596] = {.lex_state = 59},
  [597] = {.lex_state = 59},
  [598] = {.lex_state = 59},
  [599] = {.lex_state = 60},
  [600] = {.lex_state = 60},
  [601] = {.lex_state = 60},
  [602] = {.lex_state = 60},
  [603] = {.lex_state = 60},
  [604] = {.lex_state = 60},
  [605] = {.lex_state = 60},
  [606] = {.lex_state = 60},
  [607] = {.lex_state = 60},
  [608] = {.lex_state = 60},
  [609] = {.lex_state = 60},
  [610] = {.lex_state = 60},
  [611] = {.lex_state = 60},
  [612] = {.lex_state = 60},
  [613] = {.lex_state = 60},
  [614] = {.lex_state = 60},
  [615] = {.lex_state = 60},
  [616] = {.lex_state = 60},
  [617] = {.lex_state = 60},
  [618] = {.lex_state = 60},
  [619] = {.lex_state = 60},
  [620] = {.lex_state = 60, .external_lex_state = 2},
  [621] = {.lex_state = 60, .external_lex_state = 2},
  [622] = {.lex_state = 60, .external_lex_state = 2},
  [623] = {.lex_state = 60},
  [624] = {.lex_state = 60},
  [625] = {.lex_state = 60, .external_lex_state = 2},
  [626] = {.lex_state = 60, .external_lex_state = 2},
  [627] = {.lex_state = 60},
  [628] = {.lex_state = 59},
  [629] = {.lex_state = 60},
  [630] = {.lex_state = 59},
  [631] = {.lex_state = 60},
  [632] = {.lex_state = 60},
  [633] = {.lex_state = 60},
  [634] = {.lex_state = 60},
  [635] = {.lex_state = 60},
  [636] = {.lex_state = 60},
  [637] = {.lex_state = 60},
  [638] = {.lex_state = 60},
  [639] = {.lex_state = 60},
  [640] = {.lex_state = 60},
  [641] = {.lex_state = 60},
  [642] = {.lex_state = 60},
  [643] = {.lex_state = 60},
  [644] = {.lex_state = 60},
  [645] = {.lex_state = 60},
  [646] = {.lex_state = 60},
  [647] = {.lex_state = 60},
  [648] = {.lex_state = 60},
  [649] = {.lex_state = 60},
  [650] = {.lex_state = 60},
  [651] = {.lex_state = 60},
  [652] = {.lex_state = 60},
  [653] = {.lex_state = 60},
  [654] = {.lex_state = 60},
  [655] = {.lex_state = 60},
  [656] = {.lex_state = 60},
  [657] = {.lex_state = 60},
  [658] = {.lex_state = 60},
  [659] = {.lex_state = 60},
  [660] = {.lex_state = 60},
  [661] = {.lex_state = 60},
  [662] = {.lex_state = 60},
  [663] = {.lex_state = 20},
  [664] = {.lex_state = 20},
  [665] = {.lex_state = 20},
  [666] = {.lex_state = 20},
  [667] = {.lex_state = 60},
  [668] = {.lex_state = 20},
  [669] = {.lex_state = 21},
  [670] = {.lex_state = 20},
  [671] = {.lex_state = 21},
  [672] = {.lex_state = 60},
  [673] = {.lex_state = 21},
  [674] = {.lex_state = 21},
  [675] = {.lex_state = 20},
  [676] = {.lex_state = 21},
  [677] = {.lex_state = 20},
  [678] = {.lex_state = 20},
  [679] = {.lex_state = 20},
  [680] = {.lex_state = 20},
  [681] = {.lex_state = 21},
  [682] = {.lex_state = 21},
  [683] = {.lex_state = 20},
  [684] = {.lex_state = 21},
  [685] = {.lex_state = 20},
  [686] = {.lex_state = 21},
  [687] = {.lex_state = 20},
  [688] = {.lex_state = 20},
  [689] = {.lex_state = 20},
  [690] = {.lex_state = 20},
  [691] = {.lex_state = 21},
  [692] = {.lex_state = 21},
  [693] = {.lex_state = 21},
  [694] = {.lex_state = 21},
  [695] = {.lex_state = 20},
  [696] = {.lex_state = 21},
  [697] = {.lex_state = 20},
  [698] = {.lex_state = 21},
  [699] = {.lex_state = 20},
  [700] = {.lex_state = 21},
  [701] = {.lex_state = 21},
  [702] = {.lex_state = 20},
  [703] = {.lex_state = 20},
  [704] = {.lex_state = 20},
  [705] = {.lex_state = 60},
  [706] = {.lex_state = 20},
  [707] = {.lex_state = 12, .external_lex_state = 3},
  [708] = {.lex_state = 12, .external_lex_state = 3},
  [709] = {.lex_state = 20},
  [710] = {.lex_state = 0, .external_lex_state = 2},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 12, .external_lex_state = 3},
  [713] = {.lex_state = 60},
  [714] = {.lex_state = 20},
  [715] = {.lex_state = 60},
  [716] = {.lex_state = 20},
  [717] = {.lex_state = 20},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 60},
  [720] = {.lex_state = 20},
  [721] = {.lex_state = 20},
  [722] = {.lex_state = 20},
  [723] = {.lex_state = 60},
  [724] = {.lex_state = 20},
  [725] = {.lex_state = 20},
  [726] = {.lex_state = 0, .external_lex_state = 2},
  [727] = {.lex_state = 20},
  [728] = {.lex_state = 12, .external_lex_state = 3},
  [729] = {.lex_state = 12, .external_lex_state = 3},
  [730] = {.lex_state = 20},
  [731] = {.lex_state = 20},
  [732] = {.lex_state = 20},
  [733] = {.lex_state = 60},
  [734] = {.lex_state = 20},
  [735] = {.lex_state = 20},
  [736] = {.lex_state = 60},
  [737] = {.lex_state = 60},
  [738] = {.lex_state = 20},
  [739] = {.lex_state = 60},
  [740] = {.lex_state = 0, .external_lex_state = 2},
  [741] = {.lex_state = 0, .external_lex_state = 2},
  [742] = {.lex_state = 20},
  [743] = {.lex_state = 60},
  [744] = {.lex_state = 60},
  [745] = {.lex_state = 60},
  [746] = {.lex_state = 60},
  [747] = {.lex_state = 0, .external_lex_state = 2},
  [748] = {.lex_state = 60},
  [749] = {.lex_state = 20},
  [750] = {.lex_state = 20},
  [751] = {.lex_state = 20},
  [752] = {.lex_state = 60},
  [753] = {.lex_state = 20},
  [754] = {.lex_state = 20},
  [755] = {.lex_state = 20},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 20},
  [758] = {.lex_state = 20},
  [759] = {.lex_state = 20},
  [760] = {.lex_state = 20},
  [761] = {.lex_state = 60},
  [762] = {.lex_state = 20},
  [763] = {.lex_state = 20},
  [764] = {.lex_state = 20},
  [765] = {.lex_state = 20},
  [766] = {.lex_state = 60},
  [767] = {.lex_state = 60},
  [768] = {.lex_state = 0, .external_lex_state = 2},
  [769] = {.lex_state = 60},
  [770] = {.lex_state = 60},
  [771] = {.lex_state = 1},
  [772] = {.lex_state = 60},
  [773] = {.lex_state = 60},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 20},
  [776] = {.lex_state = 60},
  [777] = {.lex_state = 1},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 3},
  [780] = {.lex_state = 0, .external_lex_state = 2},
  [781] = {.lex_state = 1},
  [782] = {.lex_state = 60},
  [783] = {.lex_state = 3},
  [784] = {.lex_state = 1},
  [785] = {.lex_state = 3},
  [786] = {.lex_state = 3},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0, .external_lex_state = 2},
  [789] = {.lex_state = 20},
  [790] = {.lex_state = 1},
  [791] = {.lex_state = 60},
  [792] = {.lex_state = 0, .external_lex_state = 2},
  [793] = {.lex_state = 60},
  [794] = {.lex_state = 60},
  [795] = {.lex_state = 3},
  [796] = {.lex_state = 60},
  [797] = {.lex_state = 0, .external_lex_state = 2},
  [798] = {.lex_state = 60},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 20},
  [801] = {.lex_state = 60},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 60},
  [804] = {.lex_state = 3},
  [805] = {.lex_state = 60},
  [806] = {.lex_state = 60},
  [807] = {.lex_state = 60},
  [808] = {.lex_state = 60},
  [809] = {.lex_state = 60},
  [810] = {.lex_state = 0, .external_lex_state = 2},
  [811] = {.lex_state = 1},
  [812] = {.lex_state = 1},
  [813] = {.lex_state = 3},
  [814] = {.lex_state = 0, .external_lex_state = 2},
  [815] = {.lex_state = 60},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 60},
  [818] = {.lex_state = 60},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 60},
  [821] = {.lex_state = 60},
  [822] = {.lex_state = 60},
  [823] = {.lex_state = 60},
  [824] = {.lex_state = 20},
  [825] = {.lex_state = 60},
  [826] = {.lex_state = 60},
  [827] = {.lex_state = 12, .external_lex_state = 3},
  [828] = {.lex_state = 60},
  [829] = {.lex_state = 60},
  [830] = {.lex_state = 60, .external_lex_state = 2},
  [831] = {.lex_state = 60},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 21},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 21},
  [837] = {.lex_state = 60},
  [838] = {.lex_state = 7},
  [839] = {.lex_state = 60},
  [840] = {.lex_state = 7},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 60, .external_lex_state = 2},
  [843] = {.lex_state = 7},
  [844] = {.lex_state = 60},
  [845] = {.lex_state = 60, .external_lex_state = 2},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 60},
  [851] = {.lex_state = 60},
  [852] = {.lex_state = 60, .external_lex_state = 2},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 60},
  [855] = {.lex_state = 60, .external_lex_state = 2},
  [856] = {.lex_state = 7},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 60},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 60},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 60, .external_lex_state = 2},
  [867] = {.lex_state = 60},
  [868] = {.lex_state = 60},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 60},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 60},
  [878] = {.lex_state = 0, .external_lex_state = 2},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 21},
  [881] = {.lex_state = 0, .external_lex_state = 2},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0, .external_lex_state = 2},
  [884] = {.lex_state = 0, .external_lex_state = 2},
  [885] = {.lex_state = 60, .external_lex_state = 2},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 60},
  [888] = {.lex_state = 60},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 60, .external_lex_state = 2},
  [894] = {.lex_state = 60},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 60, .external_lex_state = 2},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 21},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 60},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 21},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 21},
  [910] = {.lex_state = 21},
  [911] = {.lex_state = 21},
  [912] = {.lex_state = 21},
  [913] = {.lex_state = 21},
  [914] = {.lex_state = 21},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 20},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 60},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 60},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0, .external_lex_state = 2},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 60},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 60},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 60},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 60},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0, .external_lex_state = 2},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0, .external_lex_state = 2},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0, .external_lex_state = 2},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 60},
  [975] = {.lex_state = 60},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0, .external_lex_state = 2},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0, .external_lex_state = 2},
  [986] = {.lex_state = 0, .external_lex_state = 2},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0, .external_lex_state = 2},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0, .external_lex_state = 2},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0, .external_lex_state = 2},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0, .external_lex_state = 2},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 60},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 60},
  [1022] = {.lex_state = 0, .external_lex_state = 2},
  [1023] = {.lex_state = 7},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0, .external_lex_state = 2},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0, .external_lex_state = 2},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 60},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 60},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 7},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 60},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 60},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 7},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 7},
  [1065] = {.lex_state = 60},
  [1066] = {.lex_state = 60},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0, .external_lex_state = 2},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 60},
  [1074] = {.lex_state = 60},
  [1075] = {.lex_state = 60},
  [1076] = {.lex_state = 60},
  [1077] = {.lex_state = 5},
  [1078] = {.lex_state = 60},
  [1079] = {.lex_state = 60},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 5},
  [1082] = {.lex_state = 60},
  [1083] = {.lex_state = 60},
  [1084] = {.lex_state = 60},
  [1085] = {.lex_state = 60},
  [1086] = {.lex_state = 60},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 60},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 60},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 60},
  [1095] = {.lex_state = 60},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 60},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 60},
  [1101] = {.lex_state = 60},
  [1102] = {.lex_state = 60},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 60},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 60},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 60},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 60},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 60},
  [1123] = {.lex_state = 60},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 60},
  [1126] = {.lex_state = 60},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 60},
  [1129] = {.lex_state = 60},
  [1130] = {.lex_state = 12},
  [1131] = {.lex_state = 60},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 60},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 60},
  [1141] = {.lex_state = 60},
  [1142] = {.lex_state = 60},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 60},
  [1147] = {.lex_state = 60},
  [1148] = {.lex_state = 60},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 60},
  [1152] = {.lex_state = 60},
  [1153] = {.lex_state = 60},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 60},
  [1156] = {.lex_state = 12},
  [1157] = {.lex_state = 60},
  [1158] = {.lex_state = 60},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 60},
  [1162] = {.lex_state = 60},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 60},
  [1165] = {.lex_state = 60},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 60},
  [1169] = {.lex_state = 60},
  [1170] = {.lex_state = 60},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
};

static bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
  },
  [2] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [3] = {
    [ts_external_token__template_chars] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1144),
    [sym_export_statement] = STATE(21),
    [sym__declaration] = STATE(21),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(21),
    [sym_expression_statement] = STATE(21),
    [sym_variable_declaration] = STATE(21),
    [sym_lexical_declaration] = STATE(21),
    [sym_statement_block] = STATE(21),
    [sym_if_statement] = STATE(21),
    [sym_switch_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_for_in_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_do_statement] = STATE(21),
    [sym_try_statement] = STATE(21),
    [sym_with_statement] = STATE(21),
    [sym_break_statement] = STATE(21),
    [sym_continue_statement] = STATE(21),
    [sym_debugger_statement] = STATE(21),
    [sym_return_statement] = STATE(21),
    [sym_throw_statement] = STATE(21),
    [sym_empty_statement] = STATE(21),
    [sym_labeled_statement] = STATE(21),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(21),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(21),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(21),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [2] = {
    [sym_export_statement] = STATE(15),
    [sym__declaration] = STATE(15),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(15),
    [sym_lexical_declaration] = STATE(15),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(584),
    [sym_assignment_pattern] = STATE(908),
    [sym_array] = STATE(583),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(15),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(15),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(15),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_spread_element] = STATE(908),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(581),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [sym_method_definition] = STATE(908),
    [sym_pair] = STATE(908),
    [sym__property_name] = STATE(903),
    [sym_computed_property_name] = STATE(903),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(618),
    [aux_sym_object_repeat1] = STATE(915),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(93),
    [anon_sym_RBRACE] = ACTIONS(95),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(99),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(103),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
  },
  [3] = {
    [sym_export_statement] = STATE(15),
    [sym__declaration] = STATE(15),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(15),
    [sym_lexical_declaration] = STATE(15),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(584),
    [sym_assignment_pattern] = STATE(908),
    [sym_array] = STATE(583),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(15),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(15),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(15),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_spread_element] = STATE(908),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(581),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [sym_method_definition] = STATE(908),
    [sym_pair] = STATE(908),
    [sym__property_name] = STATE(903),
    [sym_computed_property_name] = STATE(903),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(618),
    [aux_sym_object_repeat1] = STATE(915),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(93),
    [anon_sym_RBRACE] = ACTIONS(109),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(99),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(103),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
  },
  [4] = {
    [sym_export_statement] = STATE(23),
    [sym__declaration] = STATE(23),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(23),
    [sym_lexical_declaration] = STATE(23),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(584),
    [sym_assignment_pattern] = STATE(908),
    [sym_array] = STATE(583),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(23),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(23),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(23),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_spread_element] = STATE(908),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(581),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [sym_method_definition] = STATE(908),
    [sym_pair] = STATE(908),
    [sym__property_name] = STATE(903),
    [sym_computed_property_name] = STATE(903),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(618),
    [aux_sym_object_repeat1] = STATE(915),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(93),
    [anon_sym_RBRACE] = ACTIONS(111),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(99),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(103),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(105),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
  },
  [5] = {
    [sym_export_statement] = STATE(11),
    [sym__declaration] = STATE(11),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(11),
    [sym_lexical_declaration] = STATE(11),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(584),
    [sym_assignment_pattern] = STATE(902),
    [sym_array] = STATE(583),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(11),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(11),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(11),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_spread_element] = STATE(902),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(581),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [sym_method_definition] = STATE(902),
    [sym_pair] = STATE(902),
    [sym__property_name] = STATE(903),
    [sym_computed_property_name] = STATE(903),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(618),
    [aux_sym_object_repeat1] = STATE(891),
    [sym_identifier] = ACTIONS(113),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_STAR] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(93),
    [anon_sym_RBRACE] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(117),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(103),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(119),
    [anon_sym_get] = ACTIONS(121),
    [anon_sym_set] = ACTIONS(121),
  },
  [6] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [ts_builtin_sym_end] = ACTIONS(123),
    [sym_identifier] = ACTIONS(125),
    [anon_sym_export] = ACTIONS(128),
    [anon_sym_default] = ACTIONS(131),
    [anon_sym_LBRACE] = ACTIONS(133),
    [anon_sym_RBRACE] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(136),
    [anon_sym_var] = ACTIONS(139),
    [anon_sym_let] = ACTIONS(142),
    [anon_sym_const] = ACTIONS(142),
    [anon_sym_if] = ACTIONS(145),
    [anon_sym_switch] = ACTIONS(148),
    [anon_sym_for] = ACTIONS(151),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_await] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(160),
    [anon_sym_do] = ACTIONS(163),
    [anon_sym_try] = ACTIONS(166),
    [anon_sym_with] = ACTIONS(169),
    [anon_sym_break] = ACTIONS(172),
    [anon_sym_continue] = ACTIONS(175),
    [anon_sym_debugger] = ACTIONS(178),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_throw] = ACTIONS(184),
    [anon_sym_SEMI] = ACTIONS(187),
    [anon_sym_case] = ACTIONS(131),
    [anon_sym_yield] = ACTIONS(190),
    [anon_sym_LBRACK] = ACTIONS(193),
    [anon_sym_LT] = ACTIONS(196),
    [anon_sym_SLASH] = ACTIONS(199),
    [anon_sym_class] = ACTIONS(202),
    [anon_sym_async] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(208),
    [anon_sym_new] = ACTIONS(211),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_BANG] = ACTIONS(217),
    [anon_sym_TILDE] = ACTIONS(217),
    [anon_sym_typeof] = ACTIONS(220),
    [anon_sym_void] = ACTIONS(220),
    [anon_sym_delete] = ACTIONS(220),
    [anon_sym_PLUS_PLUS] = ACTIONS(223),
    [anon_sym_DASH_DASH] = ACTIONS(223),
    [anon_sym_DQUOTE] = ACTIONS(226),
    [anon_sym_SQUOTE] = ACTIONS(229),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(232),
    [sym_number] = ACTIONS(235),
    [sym_this] = ACTIONS(238),
    [sym_super] = ACTIONS(238),
    [sym_true] = ACTIONS(238),
    [sym_false] = ACTIONS(238),
    [sym_null] = ACTIONS(238),
    [sym_undefined] = ACTIONS(238),
    [anon_sym_AT] = ACTIONS(241),
    [anon_sym_static] = ACTIONS(244),
    [anon_sym_get] = ACTIONS(244),
    [anon_sym_set] = ACTIONS(244),
  },
  [7] = {
    [sym_export_statement] = STATE(9),
    [sym__declaration] = STATE(9),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(9),
    [sym_lexical_declaration] = STATE(9),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(9),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(9),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(9),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(247),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(249),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(247),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [8] = {
    [sym_export_statement] = STATE(10),
    [sym__declaration] = STATE(10),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(10),
    [sym_expression_statement] = STATE(10),
    [sym_variable_declaration] = STATE(10),
    [sym_lexical_declaration] = STATE(10),
    [sym_statement_block] = STATE(10),
    [sym_if_statement] = STATE(10),
    [sym_switch_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_for_in_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_do_statement] = STATE(10),
    [sym_try_statement] = STATE(10),
    [sym_with_statement] = STATE(10),
    [sym_break_statement] = STATE(10),
    [sym_continue_statement] = STATE(10),
    [sym_debugger_statement] = STATE(10),
    [sym_return_statement] = STATE(10),
    [sym_throw_statement] = STATE(10),
    [sym_empty_statement] = STATE(10),
    [sym_labeled_statement] = STATE(10),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(10),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(10),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(10),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(251),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(253),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(251),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [9] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(255),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(257),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(255),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [10] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(259),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(261),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(259),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [11] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [12] = {
    [sym_export_statement] = STATE(15),
    [sym__declaration] = STATE(15),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(15),
    [sym_lexical_declaration] = STATE(15),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(15),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(15),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(15),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [13] = {
    [sym_export_statement] = STATE(22),
    [sym__declaration] = STATE(22),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(22),
    [sym_lexical_declaration] = STATE(22),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(22),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(22),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(22),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [ts_builtin_sym_end] = ACTIONS(267),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [14] = {
    [sym_export_statement] = STATE(11),
    [sym__declaration] = STATE(11),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(11),
    [sym_lexical_declaration] = STATE(11),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(11),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(11),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(11),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(269),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [15] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(271),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [16] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(273),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [17] = {
    [sym_export_statement] = STATE(20),
    [sym__declaration] = STATE(20),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(20),
    [sym_lexical_declaration] = STATE(20),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(20),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(20),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(20),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(275),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [18] = {
    [sym_export_statement] = STATE(16),
    [sym__declaration] = STATE(16),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_variable_declaration] = STATE(16),
    [sym_lexical_declaration] = STATE(16),
    [sym_statement_block] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_try_statement] = STATE(16),
    [sym_with_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_debugger_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_throw_statement] = STATE(16),
    [sym_empty_statement] = STATE(16),
    [sym_labeled_statement] = STATE(16),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(16),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(16),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(16),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [19] = {
    [sym_export_statement] = STATE(23),
    [sym__declaration] = STATE(23),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(23),
    [sym_lexical_declaration] = STATE(23),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(23),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(23),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(23),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [20] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(279),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [21] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [ts_builtin_sym_end] = ACTIONS(267),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [22] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [ts_builtin_sym_end] = ACTIONS(281),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [23] = {
    [sym_export_statement] = STATE(6),
    [sym__declaration] = STATE(6),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(6),
    [sym_expression_statement] = STATE(6),
    [sym_variable_declaration] = STATE(6),
    [sym_lexical_declaration] = STATE(6),
    [sym_statement_block] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_switch_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_for_in_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_do_statement] = STATE(6),
    [sym_try_statement] = STATE(6),
    [sym_with_statement] = STATE(6),
    [sym_break_statement] = STATE(6),
    [sym_continue_statement] = STATE(6),
    [sym_debugger_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_throw_statement] = STATE(6),
    [sym_empty_statement] = STATE(6),
    [sym_labeled_statement] = STATE(6),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(6),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(6),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(6),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_program_repeat1] = STATE(6),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(283),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [24] = {
    [sym_export_statement] = STATE(227),
    [sym__declaration] = STATE(227),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(227),
    [sym_expression_statement] = STATE(227),
    [sym_variable_declaration] = STATE(227),
    [sym_lexical_declaration] = STATE(227),
    [sym_statement_block] = STATE(227),
    [sym_if_statement] = STATE(227),
    [sym_switch_statement] = STATE(227),
    [sym_for_statement] = STATE(227),
    [sym_for_in_statement] = STATE(227),
    [sym_while_statement] = STATE(227),
    [sym_do_statement] = STATE(227),
    [sym_try_statement] = STATE(227),
    [sym_with_statement] = STATE(227),
    [sym_break_statement] = STATE(227),
    [sym_continue_statement] = STATE(227),
    [sym_debugger_statement] = STATE(227),
    [sym_return_statement] = STATE(227),
    [sym_throw_statement] = STATE(227),
    [sym_empty_statement] = STATE(227),
    [sym_labeled_statement] = STATE(227),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(227),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(227),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(227),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [25] = {
    [sym_export_statement] = STATE(226),
    [sym__declaration] = STATE(226),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(226),
    [sym_expression_statement] = STATE(226),
    [sym_variable_declaration] = STATE(226),
    [sym_lexical_declaration] = STATE(226),
    [sym_statement_block] = STATE(226),
    [sym_if_statement] = STATE(226),
    [sym_switch_statement] = STATE(226),
    [sym_for_statement] = STATE(226),
    [sym_for_in_statement] = STATE(226),
    [sym_while_statement] = STATE(226),
    [sym_do_statement] = STATE(226),
    [sym_try_statement] = STATE(226),
    [sym_with_statement] = STATE(226),
    [sym_break_statement] = STATE(226),
    [sym_continue_statement] = STATE(226),
    [sym_debugger_statement] = STATE(226),
    [sym_return_statement] = STATE(226),
    [sym_throw_statement] = STATE(226),
    [sym_empty_statement] = STATE(226),
    [sym_labeled_statement] = STATE(226),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(226),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(226),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(226),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [26] = {
    [sym_export_statement] = STATE(230),
    [sym__declaration] = STATE(230),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(230),
    [sym_expression_statement] = STATE(230),
    [sym_variable_declaration] = STATE(230),
    [sym_lexical_declaration] = STATE(230),
    [sym_statement_block] = STATE(230),
    [sym_if_statement] = STATE(230),
    [sym_switch_statement] = STATE(230),
    [sym_for_statement] = STATE(230),
    [sym_for_in_statement] = STATE(230),
    [sym_while_statement] = STATE(230),
    [sym_do_statement] = STATE(230),
    [sym_try_statement] = STATE(230),
    [sym_with_statement] = STATE(230),
    [sym_break_statement] = STATE(230),
    [sym_continue_statement] = STATE(230),
    [sym_debugger_statement] = STATE(230),
    [sym_return_statement] = STATE(230),
    [sym_throw_statement] = STATE(230),
    [sym_empty_statement] = STATE(230),
    [sym_labeled_statement] = STATE(230),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(230),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(230),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(230),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [27] = {
    [sym_export_statement] = STATE(232),
    [sym__declaration] = STATE(232),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(232),
    [sym_expression_statement] = STATE(232),
    [sym_variable_declaration] = STATE(232),
    [sym_lexical_declaration] = STATE(232),
    [sym_statement_block] = STATE(232),
    [sym_if_statement] = STATE(232),
    [sym_switch_statement] = STATE(232),
    [sym_for_statement] = STATE(232),
    [sym_for_in_statement] = STATE(232),
    [sym_while_statement] = STATE(232),
    [sym_do_statement] = STATE(232),
    [sym_try_statement] = STATE(232),
    [sym_with_statement] = STATE(232),
    [sym_break_statement] = STATE(232),
    [sym_continue_statement] = STATE(232),
    [sym_debugger_statement] = STATE(232),
    [sym_return_statement] = STATE(232),
    [sym_throw_statement] = STATE(232),
    [sym_empty_statement] = STATE(232),
    [sym_labeled_statement] = STATE(232),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(232),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(232),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(232),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [28] = {
    [sym_export_statement] = STATE(227),
    [sym__declaration] = STATE(227),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(227),
    [sym_expression_statement] = STATE(227),
    [sym_variable_declaration] = STATE(227),
    [sym_lexical_declaration] = STATE(227),
    [sym_statement_block] = STATE(227),
    [sym_if_statement] = STATE(227),
    [sym_switch_statement] = STATE(227),
    [sym_for_statement] = STATE(227),
    [sym_for_in_statement] = STATE(227),
    [sym_while_statement] = STATE(227),
    [sym_do_statement] = STATE(227),
    [sym_try_statement] = STATE(227),
    [sym_with_statement] = STATE(227),
    [sym_break_statement] = STATE(227),
    [sym_continue_statement] = STATE(227),
    [sym_debugger_statement] = STATE(227),
    [sym_return_statement] = STATE(227),
    [sym_throw_statement] = STATE(227),
    [sym_empty_statement] = STATE(227),
    [sym_labeled_statement] = STATE(227),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(227),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(227),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(227),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [29] = {
    [sym_export_statement] = STATE(270),
    [sym__declaration] = STATE(270),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(270),
    [sym_expression_statement] = STATE(270),
    [sym_variable_declaration] = STATE(270),
    [sym_lexical_declaration] = STATE(270),
    [sym_statement_block] = STATE(270),
    [sym_if_statement] = STATE(270),
    [sym_switch_statement] = STATE(270),
    [sym_for_statement] = STATE(270),
    [sym_for_in_statement] = STATE(270),
    [sym_while_statement] = STATE(270),
    [sym_do_statement] = STATE(270),
    [sym_try_statement] = STATE(270),
    [sym_with_statement] = STATE(270),
    [sym_break_statement] = STATE(270),
    [sym_continue_statement] = STATE(270),
    [sym_debugger_statement] = STATE(270),
    [sym_return_statement] = STATE(270),
    [sym_throw_statement] = STATE(270),
    [sym_empty_statement] = STATE(270),
    [sym_labeled_statement] = STATE(270),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(270),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(270),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(270),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [30] = {
    [sym_export_statement] = STATE(242),
    [sym__declaration] = STATE(242),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(242),
    [sym_expression_statement] = STATE(242),
    [sym_variable_declaration] = STATE(242),
    [sym_lexical_declaration] = STATE(242),
    [sym_statement_block] = STATE(242),
    [sym_if_statement] = STATE(242),
    [sym_switch_statement] = STATE(242),
    [sym_for_statement] = STATE(242),
    [sym_for_in_statement] = STATE(242),
    [sym_while_statement] = STATE(242),
    [sym_do_statement] = STATE(242),
    [sym_try_statement] = STATE(242),
    [sym_with_statement] = STATE(242),
    [sym_break_statement] = STATE(242),
    [sym_continue_statement] = STATE(242),
    [sym_debugger_statement] = STATE(242),
    [sym_return_statement] = STATE(242),
    [sym_throw_statement] = STATE(242),
    [sym_empty_statement] = STATE(242),
    [sym_labeled_statement] = STATE(242),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(242),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(242),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(242),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [31] = {
    [sym_export_statement] = STATE(253),
    [sym__declaration] = STATE(253),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(253),
    [sym_expression_statement] = STATE(253),
    [sym_variable_declaration] = STATE(253),
    [sym_lexical_declaration] = STATE(253),
    [sym_statement_block] = STATE(253),
    [sym_if_statement] = STATE(253),
    [sym_switch_statement] = STATE(253),
    [sym_for_statement] = STATE(253),
    [sym_for_in_statement] = STATE(253),
    [sym_while_statement] = STATE(253),
    [sym_do_statement] = STATE(253),
    [sym_try_statement] = STATE(253),
    [sym_with_statement] = STATE(253),
    [sym_break_statement] = STATE(253),
    [sym_continue_statement] = STATE(253),
    [sym_debugger_statement] = STATE(253),
    [sym_return_statement] = STATE(253),
    [sym_throw_statement] = STATE(253),
    [sym_empty_statement] = STATE(253),
    [sym_labeled_statement] = STATE(253),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(253),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(253),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(253),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [32] = {
    [sym_export_statement] = STATE(235),
    [sym__declaration] = STATE(235),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(235),
    [sym_expression_statement] = STATE(235),
    [sym_variable_declaration] = STATE(235),
    [sym_lexical_declaration] = STATE(235),
    [sym_statement_block] = STATE(235),
    [sym_if_statement] = STATE(235),
    [sym_switch_statement] = STATE(235),
    [sym_for_statement] = STATE(235),
    [sym_for_in_statement] = STATE(235),
    [sym_while_statement] = STATE(235),
    [sym_do_statement] = STATE(235),
    [sym_try_statement] = STATE(235),
    [sym_with_statement] = STATE(235),
    [sym_break_statement] = STATE(235),
    [sym_continue_statement] = STATE(235),
    [sym_debugger_statement] = STATE(235),
    [sym_return_statement] = STATE(235),
    [sym_throw_statement] = STATE(235),
    [sym_empty_statement] = STATE(235),
    [sym_labeled_statement] = STATE(235),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(235),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(235),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(235),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [33] = {
    [sym_export_statement] = STATE(260),
    [sym__declaration] = STATE(260),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(260),
    [sym_expression_statement] = STATE(260),
    [sym_variable_declaration] = STATE(260),
    [sym_lexical_declaration] = STATE(260),
    [sym_statement_block] = STATE(260),
    [sym_if_statement] = STATE(260),
    [sym_switch_statement] = STATE(260),
    [sym_for_statement] = STATE(260),
    [sym_for_in_statement] = STATE(260),
    [sym_while_statement] = STATE(260),
    [sym_do_statement] = STATE(260),
    [sym_try_statement] = STATE(260),
    [sym_with_statement] = STATE(260),
    [sym_break_statement] = STATE(260),
    [sym_continue_statement] = STATE(260),
    [sym_debugger_statement] = STATE(260),
    [sym_return_statement] = STATE(260),
    [sym_throw_statement] = STATE(260),
    [sym_empty_statement] = STATE(260),
    [sym_labeled_statement] = STATE(260),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(260),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(260),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(260),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [34] = {
    [sym_export_statement] = STATE(253),
    [sym__declaration] = STATE(253),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(253),
    [sym_expression_statement] = STATE(253),
    [sym_variable_declaration] = STATE(253),
    [sym_lexical_declaration] = STATE(253),
    [sym_statement_block] = STATE(253),
    [sym_if_statement] = STATE(253),
    [sym_switch_statement] = STATE(253),
    [sym_for_statement] = STATE(253),
    [sym_for_in_statement] = STATE(253),
    [sym_while_statement] = STATE(253),
    [sym_do_statement] = STATE(253),
    [sym_try_statement] = STATE(253),
    [sym_with_statement] = STATE(253),
    [sym_break_statement] = STATE(253),
    [sym_continue_statement] = STATE(253),
    [sym_debugger_statement] = STATE(253),
    [sym_return_statement] = STATE(253),
    [sym_throw_statement] = STATE(253),
    [sym_empty_statement] = STATE(253),
    [sym_labeled_statement] = STATE(253),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(253),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(253),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(253),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [35] = {
    [sym_export_statement] = STATE(260),
    [sym__declaration] = STATE(260),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(260),
    [sym_expression_statement] = STATE(260),
    [sym_variable_declaration] = STATE(260),
    [sym_lexical_declaration] = STATE(260),
    [sym_statement_block] = STATE(260),
    [sym_if_statement] = STATE(260),
    [sym_switch_statement] = STATE(260),
    [sym_for_statement] = STATE(260),
    [sym_for_in_statement] = STATE(260),
    [sym_while_statement] = STATE(260),
    [sym_do_statement] = STATE(260),
    [sym_try_statement] = STATE(260),
    [sym_with_statement] = STATE(260),
    [sym_break_statement] = STATE(260),
    [sym_continue_statement] = STATE(260),
    [sym_debugger_statement] = STATE(260),
    [sym_return_statement] = STATE(260),
    [sym_throw_statement] = STATE(260),
    [sym_empty_statement] = STATE(260),
    [sym_labeled_statement] = STATE(260),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(260),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(260),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(260),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [36] = {
    [sym_export_statement] = STATE(1011),
    [sym__declaration] = STATE(1011),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(1011),
    [sym_expression_statement] = STATE(1011),
    [sym_variable_declaration] = STATE(1011),
    [sym_lexical_declaration] = STATE(1011),
    [sym_statement_block] = STATE(1011),
    [sym_if_statement] = STATE(1011),
    [sym_switch_statement] = STATE(1011),
    [sym_for_statement] = STATE(1011),
    [sym_for_in_statement] = STATE(1011),
    [sym_while_statement] = STATE(1011),
    [sym_do_statement] = STATE(1011),
    [sym_try_statement] = STATE(1011),
    [sym_with_statement] = STATE(1011),
    [sym_break_statement] = STATE(1011),
    [sym_continue_statement] = STATE(1011),
    [sym_debugger_statement] = STATE(1011),
    [sym_return_statement] = STATE(1011),
    [sym_throw_statement] = STATE(1011),
    [sym_empty_statement] = STATE(1011),
    [sym_labeled_statement] = STATE(1011),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(1011),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(1011),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(1011),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [37] = {
    [sym_export_statement] = STATE(1153),
    [sym__declaration] = STATE(1153),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(1153),
    [sym_expression_statement] = STATE(1153),
    [sym_variable_declaration] = STATE(1153),
    [sym_lexical_declaration] = STATE(1153),
    [sym_statement_block] = STATE(1153),
    [sym_if_statement] = STATE(1153),
    [sym_switch_statement] = STATE(1153),
    [sym_for_statement] = STATE(1153),
    [sym_for_in_statement] = STATE(1153),
    [sym_while_statement] = STATE(1153),
    [sym_do_statement] = STATE(1153),
    [sym_try_statement] = STATE(1153),
    [sym_with_statement] = STATE(1153),
    [sym_break_statement] = STATE(1153),
    [sym_continue_statement] = STATE(1153),
    [sym_debugger_statement] = STATE(1153),
    [sym_return_statement] = STATE(1153),
    [sym_throw_statement] = STATE(1153),
    [sym_empty_statement] = STATE(1153),
    [sym_labeled_statement] = STATE(1153),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(1153),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(1153),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(1153),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [38] = {
    [sym_export_statement] = STATE(232),
    [sym__declaration] = STATE(232),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(232),
    [sym_expression_statement] = STATE(232),
    [sym_variable_declaration] = STATE(232),
    [sym_lexical_declaration] = STATE(232),
    [sym_statement_block] = STATE(232),
    [sym_if_statement] = STATE(232),
    [sym_switch_statement] = STATE(232),
    [sym_for_statement] = STATE(232),
    [sym_for_in_statement] = STATE(232),
    [sym_while_statement] = STATE(232),
    [sym_do_statement] = STATE(232),
    [sym_try_statement] = STATE(232),
    [sym_with_statement] = STATE(232),
    [sym_break_statement] = STATE(232),
    [sym_continue_statement] = STATE(232),
    [sym_debugger_statement] = STATE(232),
    [sym_return_statement] = STATE(232),
    [sym_throw_statement] = STATE(232),
    [sym_empty_statement] = STATE(232),
    [sym_labeled_statement] = STATE(232),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(232),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(232),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(232),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [39] = {
    [sym_export_statement] = STATE(226),
    [sym__declaration] = STATE(226),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(226),
    [sym_expression_statement] = STATE(226),
    [sym_variable_declaration] = STATE(226),
    [sym_lexical_declaration] = STATE(226),
    [sym_statement_block] = STATE(226),
    [sym_if_statement] = STATE(226),
    [sym_switch_statement] = STATE(226),
    [sym_for_statement] = STATE(226),
    [sym_for_in_statement] = STATE(226),
    [sym_while_statement] = STATE(226),
    [sym_do_statement] = STATE(226),
    [sym_try_statement] = STATE(226),
    [sym_with_statement] = STATE(226),
    [sym_break_statement] = STATE(226),
    [sym_continue_statement] = STATE(226),
    [sym_debugger_statement] = STATE(226),
    [sym_return_statement] = STATE(226),
    [sym_throw_statement] = STATE(226),
    [sym_empty_statement] = STATE(226),
    [sym_labeled_statement] = STATE(226),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(226),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(226),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(226),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [40] = {
    [sym_export_statement] = STATE(230),
    [sym__declaration] = STATE(230),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(230),
    [sym_expression_statement] = STATE(230),
    [sym_variable_declaration] = STATE(230),
    [sym_lexical_declaration] = STATE(230),
    [sym_statement_block] = STATE(230),
    [sym_if_statement] = STATE(230),
    [sym_switch_statement] = STATE(230),
    [sym_for_statement] = STATE(230),
    [sym_for_in_statement] = STATE(230),
    [sym_while_statement] = STATE(230),
    [sym_do_statement] = STATE(230),
    [sym_try_statement] = STATE(230),
    [sym_with_statement] = STATE(230),
    [sym_break_statement] = STATE(230),
    [sym_continue_statement] = STATE(230),
    [sym_debugger_statement] = STATE(230),
    [sym_return_statement] = STATE(230),
    [sym_throw_statement] = STATE(230),
    [sym_empty_statement] = STATE(230),
    [sym_labeled_statement] = STATE(230),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(230),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(230),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(230),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [41] = {
    [sym_export_statement] = STATE(242),
    [sym__declaration] = STATE(242),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(242),
    [sym_expression_statement] = STATE(242),
    [sym_variable_declaration] = STATE(242),
    [sym_lexical_declaration] = STATE(242),
    [sym_statement_block] = STATE(242),
    [sym_if_statement] = STATE(242),
    [sym_switch_statement] = STATE(242),
    [sym_for_statement] = STATE(242),
    [sym_for_in_statement] = STATE(242),
    [sym_while_statement] = STATE(242),
    [sym_do_statement] = STATE(242),
    [sym_try_statement] = STATE(242),
    [sym_with_statement] = STATE(242),
    [sym_break_statement] = STATE(242),
    [sym_continue_statement] = STATE(242),
    [sym_debugger_statement] = STATE(242),
    [sym_return_statement] = STATE(242),
    [sym_throw_statement] = STATE(242),
    [sym_empty_statement] = STATE(242),
    [sym_labeled_statement] = STATE(242),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(242),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(242),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(242),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(745),
    [sym_identifier] = ACTIONS(285),
    [anon_sym_export] = ACTIONS(287),
    [anon_sym_LBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(293),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(295),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(297),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(299),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(303),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_get] = ACTIONS(305),
    [anon_sym_set] = ACTIONS(305),
  },
  [42] = {
    [sym_export_statement] = STATE(235),
    [sym__declaration] = STATE(235),
    [sym_import] = STATE(580),
    [sym_import_statement] = STATE(235),
    [sym_expression_statement] = STATE(235),
    [sym_variable_declaration] = STATE(235),
    [sym_lexical_declaration] = STATE(235),
    [sym_statement_block] = STATE(235),
    [sym_if_statement] = STATE(235),
    [sym_switch_statement] = STATE(235),
    [sym_for_statement] = STATE(235),
    [sym_for_in_statement] = STATE(235),
    [sym_while_statement] = STATE(235),
    [sym_do_statement] = STATE(235),
    [sym_try_statement] = STATE(235),
    [sym_with_statement] = STATE(235),
    [sym_break_statement] = STATE(235),
    [sym_continue_statement] = STATE(235),
    [sym_debugger_statement] = STATE(235),
    [sym_return_statement] = STATE(235),
    [sym_throw_statement] = STATE(235),
    [sym_empty_statement] = STATE(235),
    [sym_labeled_statement] = STATE(235),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_class_declaration] = STATE(235),
    [sym_function] = STATE(580),
    [sym_function_declaration] = STATE(235),
    [sym_generator_function] = STATE(580),
    [sym_generator_function_declaration] = STATE(235),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(737),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [43] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(365),
    [sym_yield_expression] = STATE(365),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(365),
    [sym_jsx_fragment] = STATE(365),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(365),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(365),
    [sym_await_expression] = STATE(365),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(365),
    [sym_augmented_assignment_expression] = STATE(365),
    [sym_ternary_expression] = STATE(365),
    [sym_binary_expression] = STATE(365),
    [sym_unary_expression] = STATE(365),
    [sym_update_expression] = STATE(365),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_STAR] = ACTIONS(309),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(313),
    [anon_sym_RBRACE] = ACTIONS(313),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(313),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_in] = ACTIONS(321),
    [anon_sym_COLON] = ACTIONS(313),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_RBRACK] = ACTIONS(313),
    [anon_sym_LT] = ACTIONS(327),
    [anon_sym_GT] = ACTIONS(321),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_DOT] = ACTIONS(321),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_QMARK_DOT] = ACTIONS(313),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_QMARK] = ACTIONS(321),
    [anon_sym_AMP_AMP] = ACTIONS(313),
    [anon_sym_PIPE_PIPE] = ACTIONS(313),
    [anon_sym_GT_GT] = ACTIONS(321),
    [anon_sym_GT_GT_GT] = ACTIONS(313),
    [anon_sym_LT_LT] = ACTIONS(313),
    [anon_sym_AMP] = ACTIONS(321),
    [anon_sym_CARET] = ACTIONS(313),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_PERCENT] = ACTIONS(313),
    [anon_sym_STAR_STAR] = ACTIONS(313),
    [anon_sym_LT_EQ] = ACTIONS(313),
    [anon_sym_EQ_EQ] = ACTIONS(321),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(313),
    [anon_sym_BANG_EQ] = ACTIONS(321),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(313),
    [anon_sym_GT_EQ] = ACTIONS(313),
    [anon_sym_QMARK_QMARK] = ACTIONS(313),
    [anon_sym_instanceof] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(341),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [44] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(455),
    [sym_yield_expression] = STATE(455),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(455),
    [sym_jsx_fragment] = STATE(455),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(455),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(455),
    [sym_await_expression] = STATE(455),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(455),
    [sym_augmented_assignment_expression] = STATE(455),
    [sym_ternary_expression] = STATE(455),
    [sym_binary_expression] = STATE(455),
    [sym_unary_expression] = STATE(455),
    [sym_update_expression] = STATE(455),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_STAR] = ACTIONS(363),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_COMMA] = ACTIONS(313),
    [anon_sym_RBRACE] = ACTIONS(313),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_in] = ACTIONS(321),
    [anon_sym_SEMI] = ACTIONS(313),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(321),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(321),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_QMARK_DOT] = ACTIONS(313),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_QMARK] = ACTIONS(321),
    [anon_sym_AMP_AMP] = ACTIONS(313),
    [anon_sym_PIPE_PIPE] = ACTIONS(313),
    [anon_sym_GT_GT] = ACTIONS(321),
    [anon_sym_GT_GT_GT] = ACTIONS(313),
    [anon_sym_LT_LT] = ACTIONS(313),
    [anon_sym_AMP] = ACTIONS(321),
    [anon_sym_CARET] = ACTIONS(313),
    [anon_sym_PIPE] = ACTIONS(321),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(313),
    [anon_sym_STAR_STAR] = ACTIONS(313),
    [anon_sym_LT_EQ] = ACTIONS(313),
    [anon_sym_EQ_EQ] = ACTIONS(321),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(313),
    [anon_sym_BANG_EQ] = ACTIONS(321),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(313),
    [anon_sym_GT_EQ] = ACTIONS(313),
    [anon_sym_QMARK_QMARK] = ACTIONS(313),
    [anon_sym_instanceof] = ACTIONS(321),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
    [sym__automatic_semicolon] = ACTIONS(313),
  },
  [45] = {
    [ts_builtin_sym_end] = ACTIONS(381),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_export] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_default] = ACTIONS(383),
    [anon_sym_LBRACE] = ACTIONS(381),
    [anon_sym_COMMA] = ACTIONS(387),
    [anon_sym_RBRACE] = ACTIONS(381),
    [anon_sym_import] = ACTIONS(383),
    [anon_sym_var] = ACTIONS(383),
    [anon_sym_let] = ACTIONS(383),
    [anon_sym_const] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(383),
    [anon_sym_else] = ACTIONS(383),
    [anon_sym_switch] = ACTIONS(383),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_in] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(383),
    [anon_sym_try] = ACTIONS(383),
    [anon_sym_with] = ACTIONS(383),
    [anon_sym_break] = ACTIONS(383),
    [anon_sym_continue] = ACTIONS(383),
    [anon_sym_debugger] = ACTIONS(383),
    [anon_sym_return] = ACTIONS(383),
    [anon_sym_throw] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(381),
    [anon_sym_case] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(383),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(381),
    [anon_sym_LT] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_DOT] = ACTIONS(385),
    [anon_sym_class] = ACTIONS(383),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_QMARK_DOT] = ACTIONS(387),
    [anon_sym_new] = ACTIONS(383),
    [anon_sym_QMARK] = ACTIONS(385),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_GT_GT] = ACTIONS(385),
    [anon_sym_GT_GT_GT] = ACTIONS(387),
    [anon_sym_LT_LT] = ACTIONS(387),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_CARET] = ACTIONS(387),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(387),
    [anon_sym_STAR_STAR] = ACTIONS(387),
    [anon_sym_LT_EQ] = ACTIONS(387),
    [anon_sym_EQ_EQ] = ACTIONS(385),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(387),
    [anon_sym_BANG_EQ] = ACTIONS(385),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(387),
    [anon_sym_GT_EQ] = ACTIONS(387),
    [anon_sym_QMARK_QMARK] = ACTIONS(387),
    [anon_sym_instanceof] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(381),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(381),
    [anon_sym_DASH_DASH] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(381),
    [sym_number] = ACTIONS(381),
    [sym_this] = ACTIONS(383),
    [sym_super] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_undefined] = ACTIONS(383),
    [anon_sym_AT] = ACTIONS(381),
    [anon_sym_static] = ACTIONS(383),
    [anon_sym_get] = ACTIONS(383),
    [anon_sym_set] = ACTIONS(383),
    [sym__automatic_semicolon] = ACTIONS(389),
  },
  [46] = {
    [ts_builtin_sym_end] = ACTIONS(381),
    [sym_identifier] = ACTIONS(383),
    [anon_sym_export] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(383),
    [anon_sym_default] = ACTIONS(383),
    [anon_sym_LBRACE] = ACTIONS(381),
    [anon_sym_COMMA] = ACTIONS(381),
    [anon_sym_RBRACE] = ACTIONS(381),
    [anon_sym_import] = ACTIONS(383),
    [anon_sym_var] = ACTIONS(383),
    [anon_sym_let] = ACTIONS(383),
    [anon_sym_const] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(383),
    [anon_sym_else] = ACTIONS(383),
    [anon_sym_switch] = ACTIONS(383),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_in] = ACTIONS(383),
    [anon_sym_while] = ACTIONS(383),
    [anon_sym_do] = ACTIONS(383),
    [anon_sym_try] = ACTIONS(383),
    [anon_sym_with] = ACTIONS(383),
    [anon_sym_break] = ACTIONS(383),
    [anon_sym_continue] = ACTIONS(383),
    [anon_sym_debugger] = ACTIONS(383),
    [anon_sym_return] = ACTIONS(383),
    [anon_sym_throw] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(381),
    [anon_sym_case] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(381),
    [anon_sym_LT] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(383),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_DOT] = ACTIONS(383),
    [anon_sym_class] = ACTIONS(383),
    [anon_sym_async] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(383),
    [anon_sym_QMARK_DOT] = ACTIONS(381),
    [anon_sym_new] = ACTIONS(383),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(381),
    [anon_sym_GT_GT] = ACTIONS(383),
    [anon_sym_GT_GT_GT] = ACTIONS(381),
    [anon_sym_LT_LT] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(383),
    [anon_sym_CARET] = ACTIONS(381),
    [anon_sym_PIPE] = ACTIONS(383),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(383),
    [anon_sym_PERCENT] = ACTIONS(381),
    [anon_sym_STAR_STAR] = ACTIONS(381),
    [anon_sym_LT_EQ] = ACTIONS(381),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(381),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(381),
    [anon_sym_GT_EQ] = ACTIONS(381),
    [anon_sym_QMARK_QMARK] = ACTIONS(381),
    [anon_sym_instanceof] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(381),
    [anon_sym_typeof] = ACTIONS(383),
    [anon_sym_void] = ACTIONS(383),
    [anon_sym_delete] = ACTIONS(383),
    [anon_sym_PLUS_PLUS] = ACTIONS(381),
    [anon_sym_DASH_DASH] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(381),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(381),
    [sym_number] = ACTIONS(381),
    [sym_this] = ACTIONS(383),
    [sym_super] = ACTIONS(383),
    [sym_true] = ACTIONS(383),
    [sym_false] = ACTIONS(383),
    [sym_null] = ACTIONS(383),
    [sym_undefined] = ACTIONS(383),
    [anon_sym_AT] = ACTIONS(381),
    [anon_sym_static] = ACTIONS(383),
    [anon_sym_get] = ACTIONS(383),
    [anon_sym_set] = ACTIONS(383),
    [sym__automatic_semicolon] = ACTIONS(391),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(393),
    [sym_identifier] = ACTIONS(395),
    [anon_sym_export] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(397),
    [anon_sym_default] = ACTIONS(395),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_COMMA] = ACTIONS(399),
    [anon_sym_RBRACE] = ACTIONS(393),
    [anon_sym_import] = ACTIONS(395),
    [anon_sym_var] = ACTIONS(395),
    [anon_sym_let] = ACTIONS(395),
    [anon_sym_const] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(395),
    [anon_sym_else] = ACTIONS(395),
    [anon_sym_switch] = ACTIONS(395),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(393),
    [anon_sym_await] = ACTIONS(395),
    [anon_sym_in] = ACTIONS(397),
    [anon_sym_while] = ACTIONS(395),
    [anon_sym_do] = ACTIONS(395),
    [anon_sym_try] = ACTIONS(395),
    [anon_sym_with] = ACTIONS(395),
    [anon_sym_break] = ACTIONS(395),
    [anon_sym_continue] = ACTIONS(395),
    [anon_sym_debugger] = ACTIONS(395),
    [anon_sym_return] = ACTIONS(395),
    [anon_sym_throw] = ACTIONS(395),
    [anon_sym_SEMI] = ACTIONS(393),
    [anon_sym_case] = ACTIONS(395),
    [anon_sym_yield] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(393),
    [anon_sym_LT] = ACTIONS(395),
    [anon_sym_GT] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(395),
    [anon_sym_DOT] = ACTIONS(397),
    [anon_sym_class] = ACTIONS(395),
    [anon_sym_async] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_QMARK_DOT] = ACTIONS(399),
    [anon_sym_new] = ACTIONS(395),
    [anon_sym_QMARK] = ACTIONS(397),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_GT_GT] = ACTIONS(397),
    [anon_sym_GT_GT_GT] = ACTIONS(399),
    [anon_sym_LT_LT] = ACTIONS(399),
    [anon_sym_AMP] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(399),
    [anon_sym_PIPE] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(395),
    [anon_sym_DASH] = ACTIONS(395),
    [anon_sym_PERCENT] = ACTIONS(399),
    [anon_sym_STAR_STAR] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(399),
    [anon_sym_EQ_EQ] = ACTIONS(397),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(399),
    [anon_sym_BANG_EQ] = ACTIONS(397),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(399),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_QMARK_QMARK] = ACTIONS(399),
    [anon_sym_instanceof] = ACTIONS(397),
    [anon_sym_BANG] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_typeof] = ACTIONS(395),
    [anon_sym_void] = ACTIONS(395),
    [anon_sym_delete] = ACTIONS(395),
    [anon_sym_PLUS_PLUS] = ACTIONS(393),
    [anon_sym_DASH_DASH] = ACTIONS(393),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(393),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(393),
    [sym_number] = ACTIONS(393),
    [sym_this] = ACTIONS(395),
    [sym_super] = ACTIONS(395),
    [sym_true] = ACTIONS(395),
    [sym_false] = ACTIONS(395),
    [sym_null] = ACTIONS(395),
    [sym_undefined] = ACTIONS(395),
    [anon_sym_AT] = ACTIONS(393),
    [anon_sym_static] = ACTIONS(395),
    [anon_sym_get] = ACTIONS(395),
    [anon_sym_set] = ACTIONS(395),
    [sym__automatic_semicolon] = ACTIONS(401),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(403),
    [sym_identifier] = ACTIONS(405),
    [anon_sym_export] = ACTIONS(405),
    [anon_sym_STAR] = ACTIONS(407),
    [anon_sym_default] = ACTIONS(405),
    [anon_sym_LBRACE] = ACTIONS(403),
    [anon_sym_COMMA] = ACTIONS(409),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_import] = ACTIONS(405),
    [anon_sym_var] = ACTIONS(405),
    [anon_sym_let] = ACTIONS(405),
    [anon_sym_const] = ACTIONS(405),
    [anon_sym_if] = ACTIONS(405),
    [anon_sym_else] = ACTIONS(405),
    [anon_sym_switch] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(405),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_await] = ACTIONS(405),
    [anon_sym_in] = ACTIONS(407),
    [anon_sym_while] = ACTIONS(405),
    [anon_sym_do] = ACTIONS(405),
    [anon_sym_try] = ACTIONS(405),
    [anon_sym_with] = ACTIONS(405),
    [anon_sym_break] = ACTIONS(405),
    [anon_sym_continue] = ACTIONS(405),
    [anon_sym_debugger] = ACTIONS(405),
    [anon_sym_return] = ACTIONS(405),
    [anon_sym_throw] = ACTIONS(405),
    [anon_sym_SEMI] = ACTIONS(403),
    [anon_sym_case] = ACTIONS(405),
    [anon_sym_yield] = ACTIONS(405),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(405),
    [anon_sym_GT] = ACTIONS(407),
    [anon_sym_SLASH] = ACTIONS(405),
    [anon_sym_DOT] = ACTIONS(407),
    [anon_sym_class] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(405),
    [anon_sym_function] = ACTIONS(405),
    [anon_sym_QMARK_DOT] = ACTIONS(409),
    [anon_sym_new] = ACTIONS(405),
    [anon_sym_QMARK] = ACTIONS(407),
    [anon_sym_AMP_AMP] = ACTIONS(409),
    [anon_sym_PIPE_PIPE] = ACTIONS(409),
    [anon_sym_GT_GT] = ACTIONS(407),
    [anon_sym_GT_GT_GT] = ACTIONS(409),
    [anon_sym_LT_LT] = ACTIONS(409),
    [anon_sym_AMP] = ACTIONS(407),
    [anon_sym_CARET] = ACTIONS(409),
    [anon_sym_PIPE] = ACTIONS(407),
    [anon_sym_PLUS] = ACTIONS(405),
    [anon_sym_DASH] = ACTIONS(405),
    [anon_sym_PERCENT] = ACTIONS(409),
    [anon_sym_STAR_STAR] = ACTIONS(409),
    [anon_sym_LT_EQ] = ACTIONS(409),
    [anon_sym_EQ_EQ] = ACTIONS(407),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(409),
    [anon_sym_BANG_EQ] = ACTIONS(407),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(409),
    [anon_sym_GT_EQ] = ACTIONS(409),
    [anon_sym_QMARK_QMARK] = ACTIONS(409),
    [anon_sym_instanceof] = ACTIONS(407),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_typeof] = ACTIONS(405),
    [anon_sym_void] = ACTIONS(405),
    [anon_sym_delete] = ACTIONS(405),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(403),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [sym_number] = ACTIONS(403),
    [sym_this] = ACTIONS(405),
    [sym_super] = ACTIONS(405),
    [sym_true] = ACTIONS(405),
    [sym_false] = ACTIONS(405),
    [sym_null] = ACTIONS(405),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_static] = ACTIONS(405),
    [anon_sym_get] = ACTIONS(405),
    [anon_sym_set] = ACTIONS(405),
    [sym__automatic_semicolon] = ACTIONS(411),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(413),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(415),
    [anon_sym_STAR] = ACTIONS(417),
    [anon_sym_default] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(413),
    [anon_sym_COMMA] = ACTIONS(419),
    [anon_sym_RBRACE] = ACTIONS(413),
    [anon_sym_import] = ACTIONS(415),
    [anon_sym_var] = ACTIONS(415),
    [anon_sym_let] = ACTIONS(415),
    [anon_sym_const] = ACTIONS(415),
    [anon_sym_if] = ACTIONS(415),
    [anon_sym_else] = ACTIONS(415),
    [anon_sym_switch] = ACTIONS(415),
    [anon_sym_for] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(413),
    [anon_sym_await] = ACTIONS(415),
    [anon_sym_in] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(415),
    [anon_sym_do] = ACTIONS(415),
    [anon_sym_try] = ACTIONS(415),
    [anon_sym_with] = ACTIONS(415),
    [anon_sym_break] = ACTIONS(415),
    [anon_sym_continue] = ACTIONS(415),
    [anon_sym_debugger] = ACTIONS(415),
    [anon_sym_return] = ACTIONS(415),
    [anon_sym_throw] = ACTIONS(415),
    [anon_sym_SEMI] = ACTIONS(413),
    [anon_sym_case] = ACTIONS(415),
    [anon_sym_yield] = ACTIONS(415),
    [anon_sym_LBRACK] = ACTIONS(413),
    [anon_sym_LT] = ACTIONS(415),
    [anon_sym_GT] = ACTIONS(417),
    [anon_sym_SLASH] = ACTIONS(415),
    [anon_sym_DOT] = ACTIONS(417),
    [anon_sym_class] = ACTIONS(415),
    [anon_sym_async] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(415),
    [anon_sym_QMARK_DOT] = ACTIONS(419),
    [anon_sym_new] = ACTIONS(415),
    [anon_sym_QMARK] = ACTIONS(417),
    [anon_sym_AMP_AMP] = ACTIONS(419),
    [anon_sym_PIPE_PIPE] = ACTIONS(419),
    [anon_sym_GT_GT] = ACTIONS(417),
    [anon_sym_GT_GT_GT] = ACTIONS(419),
    [anon_sym_LT_LT] = ACTIONS(419),
    [anon_sym_AMP] = ACTIONS(417),
    [anon_sym_CARET] = ACTIONS(419),
    [anon_sym_PIPE] = ACTIONS(417),
    [anon_sym_PLUS] = ACTIONS(415),
    [anon_sym_DASH] = ACTIONS(415),
    [anon_sym_PERCENT] = ACTIONS(419),
    [anon_sym_STAR_STAR] = ACTIONS(419),
    [anon_sym_LT_EQ] = ACTIONS(419),
    [anon_sym_EQ_EQ] = ACTIONS(417),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(419),
    [anon_sym_BANG_EQ] = ACTIONS(417),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(419),
    [anon_sym_GT_EQ] = ACTIONS(419),
    [anon_sym_QMARK_QMARK] = ACTIONS(419),
    [anon_sym_instanceof] = ACTIONS(417),
    [anon_sym_BANG] = ACTIONS(415),
    [anon_sym_TILDE] = ACTIONS(413),
    [anon_sym_typeof] = ACTIONS(415),
    [anon_sym_void] = ACTIONS(415),
    [anon_sym_delete] = ACTIONS(415),
    [anon_sym_PLUS_PLUS] = ACTIONS(413),
    [anon_sym_DASH_DASH] = ACTIONS(413),
    [anon_sym_DQUOTE] = ACTIONS(413),
    [anon_sym_SQUOTE] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(413),
    [sym_number] = ACTIONS(413),
    [sym_this] = ACTIONS(415),
    [sym_super] = ACTIONS(415),
    [sym_true] = ACTIONS(415),
    [sym_false] = ACTIONS(415),
    [sym_null] = ACTIONS(415),
    [sym_undefined] = ACTIONS(415),
    [anon_sym_AT] = ACTIONS(413),
    [anon_sym_static] = ACTIONS(415),
    [anon_sym_get] = ACTIONS(415),
    [anon_sym_set] = ACTIONS(415),
    [sym__automatic_semicolon] = ACTIONS(421),
  },
  [50] = {
    [ts_builtin_sym_end] = ACTIONS(423),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_export] = ACTIONS(425),
    [anon_sym_STAR] = ACTIONS(427),
    [anon_sym_default] = ACTIONS(425),
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(429),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_import] = ACTIONS(425),
    [anon_sym_var] = ACTIONS(425),
    [anon_sym_let] = ACTIONS(425),
    [anon_sym_const] = ACTIONS(425),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_else] = ACTIONS(425),
    [anon_sym_switch] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(425),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_await] = ACTIONS(425),
    [anon_sym_in] = ACTIONS(427),
    [anon_sym_while] = ACTIONS(425),
    [anon_sym_do] = ACTIONS(425),
    [anon_sym_try] = ACTIONS(425),
    [anon_sym_with] = ACTIONS(425),
    [anon_sym_break] = ACTIONS(425),
    [anon_sym_continue] = ACTIONS(425),
    [anon_sym_debugger] = ACTIONS(425),
    [anon_sym_return] = ACTIONS(425),
    [anon_sym_throw] = ACTIONS(425),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_case] = ACTIONS(425),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(425),
    [anon_sym_GT] = ACTIONS(427),
    [anon_sym_SLASH] = ACTIONS(425),
    [anon_sym_DOT] = ACTIONS(427),
    [anon_sym_class] = ACTIONS(425),
    [anon_sym_async] = ACTIONS(425),
    [anon_sym_function] = ACTIONS(425),
    [anon_sym_QMARK_DOT] = ACTIONS(429),
    [anon_sym_new] = ACTIONS(425),
    [anon_sym_QMARK] = ACTIONS(427),
    [anon_sym_AMP_AMP] = ACTIONS(429),
    [anon_sym_PIPE_PIPE] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(427),
    [anon_sym_GT_GT_GT] = ACTIONS(429),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_AMP] = ACTIONS(427),
    [anon_sym_CARET] = ACTIONS(429),
    [anon_sym_PIPE] = ACTIONS(427),
    [anon_sym_PLUS] = ACTIONS(425),
    [anon_sym_DASH] = ACTIONS(425),
    [anon_sym_PERCENT] = ACTIONS(429),
    [anon_sym_STAR_STAR] = ACTIONS(429),
    [anon_sym_LT_EQ] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(429),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(429),
    [anon_sym_GT_EQ] = ACTIONS(429),
    [anon_sym_QMARK_QMARK] = ACTIONS(429),
    [anon_sym_instanceof] = ACTIONS(427),
    [anon_sym_BANG] = ACTIONS(425),
    [anon_sym_TILDE] = ACTIONS(423),
    [anon_sym_typeof] = ACTIONS(425),
    [anon_sym_void] = ACTIONS(425),
    [anon_sym_delete] = ACTIONS(425),
    [anon_sym_PLUS_PLUS] = ACTIONS(423),
    [anon_sym_DASH_DASH] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(423),
    [sym_number] = ACTIONS(423),
    [sym_this] = ACTIONS(425),
    [sym_super] = ACTIONS(425),
    [sym_true] = ACTIONS(425),
    [sym_false] = ACTIONS(425),
    [sym_null] = ACTIONS(425),
    [sym_undefined] = ACTIONS(425),
    [anon_sym_AT] = ACTIONS(423),
    [anon_sym_static] = ACTIONS(425),
    [anon_sym_get] = ACTIONS(425),
    [anon_sym_set] = ACTIONS(425),
    [sym__automatic_semicolon] = ACTIONS(431),
  },
  [51] = {
    [ts_builtin_sym_end] = ACTIONS(433),
    [sym_identifier] = ACTIONS(435),
    [anon_sym_export] = ACTIONS(435),
    [anon_sym_STAR] = ACTIONS(437),
    [anon_sym_default] = ACTIONS(435),
    [anon_sym_LBRACE] = ACTIONS(433),
    [anon_sym_COMMA] = ACTIONS(439),
    [anon_sym_RBRACE] = ACTIONS(433),
    [anon_sym_import] = ACTIONS(435),
    [anon_sym_var] = ACTIONS(435),
    [anon_sym_let] = ACTIONS(435),
    [anon_sym_const] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(435),
    [anon_sym_else] = ACTIONS(435),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(433),
    [anon_sym_await] = ACTIONS(435),
    [anon_sym_in] = ACTIONS(437),
    [anon_sym_while] = ACTIONS(435),
    [anon_sym_do] = ACTIONS(435),
    [anon_sym_try] = ACTIONS(435),
    [anon_sym_with] = ACTIONS(435),
    [anon_sym_break] = ACTIONS(435),
    [anon_sym_continue] = ACTIONS(435),
    [anon_sym_debugger] = ACTIONS(435),
    [anon_sym_return] = ACTIONS(435),
    [anon_sym_throw] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(433),
    [anon_sym_case] = ACTIONS(435),
    [anon_sym_yield] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(433),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_SLASH] = ACTIONS(435),
    [anon_sym_DOT] = ACTIONS(437),
    [anon_sym_class] = ACTIONS(435),
    [anon_sym_async] = ACTIONS(435),
    [anon_sym_function] = ACTIONS(435),
    [anon_sym_QMARK_DOT] = ACTIONS(439),
    [anon_sym_new] = ACTIONS(435),
    [anon_sym_QMARK] = ACTIONS(437),
    [anon_sym_AMP_AMP] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_GT_GT] = ACTIONS(437),
    [anon_sym_GT_GT_GT] = ACTIONS(439),
    [anon_sym_LT_LT] = ACTIONS(439),
    [anon_sym_AMP] = ACTIONS(437),
    [anon_sym_CARET] = ACTIONS(439),
    [anon_sym_PIPE] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_PERCENT] = ACTIONS(439),
    [anon_sym_STAR_STAR] = ACTIONS(439),
    [anon_sym_LT_EQ] = ACTIONS(439),
    [anon_sym_EQ_EQ] = ACTIONS(437),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(439),
    [anon_sym_BANG_EQ] = ACTIONS(437),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(439),
    [anon_sym_GT_EQ] = ACTIONS(439),
    [anon_sym_QMARK_QMARK] = ACTIONS(439),
    [anon_sym_instanceof] = ACTIONS(437),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(433),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(433),
    [anon_sym_DASH_DASH] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [anon_sym_SQUOTE] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [sym_number] = ACTIONS(433),
    [sym_this] = ACTIONS(435),
    [sym_super] = ACTIONS(435),
    [sym_true] = ACTIONS(435),
    [sym_false] = ACTIONS(435),
    [sym_null] = ACTIONS(435),
    [sym_undefined] = ACTIONS(435),
    [anon_sym_AT] = ACTIONS(433),
    [anon_sym_static] = ACTIONS(435),
    [anon_sym_get] = ACTIONS(435),
    [anon_sym_set] = ACTIONS(435),
    [sym__automatic_semicolon] = ACTIONS(441),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(443),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_default] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(443),
    [anon_sym_COMMA] = ACTIONS(443),
    [anon_sym_RBRACE] = ACTIONS(443),
    [anon_sym_import] = ACTIONS(445),
    [anon_sym_var] = ACTIONS(445),
    [anon_sym_let] = ACTIONS(445),
    [anon_sym_const] = ACTIONS(445),
    [anon_sym_if] = ACTIONS(445),
    [anon_sym_else] = ACTIONS(445),
    [anon_sym_switch] = ACTIONS(445),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_await] = ACTIONS(445),
    [anon_sym_in] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(445),
    [anon_sym_do] = ACTIONS(445),
    [anon_sym_try] = ACTIONS(445),
    [anon_sym_with] = ACTIONS(445),
    [anon_sym_break] = ACTIONS(445),
    [anon_sym_continue] = ACTIONS(445),
    [anon_sym_debugger] = ACTIONS(445),
    [anon_sym_return] = ACTIONS(445),
    [anon_sym_throw] = ACTIONS(445),
    [anon_sym_SEMI] = ACTIONS(443),
    [anon_sym_case] = ACTIONS(445),
    [anon_sym_yield] = ACTIONS(445),
    [anon_sym_LBRACK] = ACTIONS(443),
    [anon_sym_LT] = ACTIONS(445),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(445),
    [anon_sym_DOT] = ACTIONS(445),
    [anon_sym_class] = ACTIONS(445),
    [anon_sym_async] = ACTIONS(445),
    [anon_sym_function] = ACTIONS(445),
    [anon_sym_QMARK_DOT] = ACTIONS(443),
    [anon_sym_new] = ACTIONS(445),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_GT_GT_GT] = ACTIONS(443),
    [anon_sym_LT_LT] = ACTIONS(443),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(443),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [anon_sym_PERCENT] = ACTIONS(443),
    [anon_sym_STAR_STAR] = ACTIONS(443),
    [anon_sym_LT_EQ] = ACTIONS(443),
    [anon_sym_EQ_EQ] = ACTIONS(445),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(443),
    [anon_sym_BANG_EQ] = ACTIONS(445),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(443),
    [anon_sym_GT_EQ] = ACTIONS(443),
    [anon_sym_QMARK_QMARK] = ACTIONS(443),
    [anon_sym_instanceof] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_TILDE] = ACTIONS(443),
    [anon_sym_typeof] = ACTIONS(445),
    [anon_sym_void] = ACTIONS(445),
    [anon_sym_delete] = ACTIONS(445),
    [anon_sym_PLUS_PLUS] = ACTIONS(443),
    [anon_sym_DASH_DASH] = ACTIONS(443),
    [anon_sym_DQUOTE] = ACTIONS(443),
    [anon_sym_SQUOTE] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(443),
    [sym_number] = ACTIONS(443),
    [sym_this] = ACTIONS(445),
    [sym_super] = ACTIONS(445),
    [sym_true] = ACTIONS(445),
    [sym_false] = ACTIONS(445),
    [sym_null] = ACTIONS(445),
    [sym_undefined] = ACTIONS(445),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym__automatic_semicolon] = ACTIONS(443),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(447),
    [sym_identifier] = ACTIONS(449),
    [anon_sym_export] = ACTIONS(449),
    [anon_sym_STAR] = ACTIONS(451),
    [anon_sym_default] = ACTIONS(449),
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_COMMA] = ACTIONS(453),
    [anon_sym_RBRACE] = ACTIONS(447),
    [anon_sym_import] = ACTIONS(449),
    [anon_sym_var] = ACTIONS(449),
    [anon_sym_let] = ACTIONS(449),
    [anon_sym_const] = ACTIONS(449),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_else] = ACTIONS(449),
    [anon_sym_switch] = ACTIONS(449),
    [anon_sym_for] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(447),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_in] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(449),
    [anon_sym_do] = ACTIONS(449),
    [anon_sym_try] = ACTIONS(449),
    [anon_sym_with] = ACTIONS(449),
    [anon_sym_break] = ACTIONS(449),
    [anon_sym_continue] = ACTIONS(449),
    [anon_sym_debugger] = ACTIONS(449),
    [anon_sym_return] = ACTIONS(449),
    [anon_sym_throw] = ACTIONS(449),
    [anon_sym_SEMI] = ACTIONS(447),
    [anon_sym_case] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(449),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_LT] = ACTIONS(449),
    [anon_sym_GT] = ACTIONS(451),
    [anon_sym_SLASH] = ACTIONS(449),
    [anon_sym_DOT] = ACTIONS(451),
    [anon_sym_class] = ACTIONS(449),
    [anon_sym_async] = ACTIONS(449),
    [anon_sym_function] = ACTIONS(449),
    [anon_sym_QMARK_DOT] = ACTIONS(453),
    [anon_sym_new] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_AMP_AMP] = ACTIONS(453),
    [anon_sym_PIPE_PIPE] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(451),
    [anon_sym_GT_GT_GT] = ACTIONS(453),
    [anon_sym_LT_LT] = ACTIONS(453),
    [anon_sym_AMP] = ACTIONS(451),
    [anon_sym_CARET] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(449),
    [anon_sym_DASH] = ACTIONS(449),
    [anon_sym_PERCENT] = ACTIONS(453),
    [anon_sym_STAR_STAR] = ACTIONS(453),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(453),
    [anon_sym_BANG_EQ] = ACTIONS(451),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(453),
    [anon_sym_QMARK_QMARK] = ACTIONS(453),
    [anon_sym_instanceof] = ACTIONS(451),
    [anon_sym_BANG] = ACTIONS(449),
    [anon_sym_TILDE] = ACTIONS(447),
    [anon_sym_typeof] = ACTIONS(449),
    [anon_sym_void] = ACTIONS(449),
    [anon_sym_delete] = ACTIONS(449),
    [anon_sym_PLUS_PLUS] = ACTIONS(447),
    [anon_sym_DASH_DASH] = ACTIONS(447),
    [anon_sym_DQUOTE] = ACTIONS(447),
    [anon_sym_SQUOTE] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(447),
    [sym_number] = ACTIONS(447),
    [sym_this] = ACTIONS(449),
    [sym_super] = ACTIONS(449),
    [sym_true] = ACTIONS(449),
    [sym_false] = ACTIONS(449),
    [sym_null] = ACTIONS(449),
    [sym_undefined] = ACTIONS(449),
    [anon_sym_AT] = ACTIONS(447),
    [anon_sym_static] = ACTIONS(449),
    [anon_sym_get] = ACTIONS(449),
    [anon_sym_set] = ACTIONS(449),
    [sym__automatic_semicolon] = ACTIONS(455),
  },
  [54] = {
    [ts_builtin_sym_end] = ACTIONS(457),
    [sym_identifier] = ACTIONS(459),
    [anon_sym_export] = ACTIONS(459),
    [anon_sym_STAR] = ACTIONS(461),
    [anon_sym_default] = ACTIONS(459),
    [anon_sym_LBRACE] = ACTIONS(457),
    [anon_sym_COMMA] = ACTIONS(463),
    [anon_sym_RBRACE] = ACTIONS(457),
    [anon_sym_import] = ACTIONS(459),
    [anon_sym_var] = ACTIONS(459),
    [anon_sym_let] = ACTIONS(459),
    [anon_sym_const] = ACTIONS(459),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_else] = ACTIONS(459),
    [anon_sym_switch] = ACTIONS(459),
    [anon_sym_for] = ACTIONS(459),
    [anon_sym_LPAREN] = ACTIONS(457),
    [anon_sym_await] = ACTIONS(459),
    [anon_sym_in] = ACTIONS(461),
    [anon_sym_while] = ACTIONS(459),
    [anon_sym_do] = ACTIONS(459),
    [anon_sym_try] = ACTIONS(459),
    [anon_sym_with] = ACTIONS(459),
    [anon_sym_break] = ACTIONS(459),
    [anon_sym_continue] = ACTIONS(459),
    [anon_sym_debugger] = ACTIONS(459),
    [anon_sym_return] = ACTIONS(459),
    [anon_sym_throw] = ACTIONS(459),
    [anon_sym_SEMI] = ACTIONS(457),
    [anon_sym_case] = ACTIONS(459),
    [anon_sym_yield] = ACTIONS(459),
    [anon_sym_LBRACK] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(459),
    [anon_sym_GT] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(459),
    [anon_sym_DOT] = ACTIONS(461),
    [anon_sym_class] = ACTIONS(459),
    [anon_sym_async] = ACTIONS(459),
    [anon_sym_function] = ACTIONS(459),
    [anon_sym_QMARK_DOT] = ACTIONS(463),
    [anon_sym_new] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(463),
    [anon_sym_GT_GT] = ACTIONS(461),
    [anon_sym_GT_GT_GT] = ACTIONS(463),
    [anon_sym_LT_LT] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(461),
    [anon_sym_CARET] = ACTIONS(463),
    [anon_sym_PIPE] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(459),
    [anon_sym_DASH] = ACTIONS(459),
    [anon_sym_PERCENT] = ACTIONS(463),
    [anon_sym_STAR_STAR] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(463),
    [anon_sym_EQ_EQ] = ACTIONS(461),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(461),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(463),
    [anon_sym_GT_EQ] = ACTIONS(463),
    [anon_sym_QMARK_QMARK] = ACTIONS(463),
    [anon_sym_instanceof] = ACTIONS(461),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_typeof] = ACTIONS(459),
    [anon_sym_void] = ACTIONS(459),
    [anon_sym_delete] = ACTIONS(459),
    [anon_sym_PLUS_PLUS] = ACTIONS(457),
    [anon_sym_DASH_DASH] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(457),
    [sym_number] = ACTIONS(457),
    [sym_this] = ACTIONS(459),
    [sym_super] = ACTIONS(459),
    [sym_true] = ACTIONS(459),
    [sym_false] = ACTIONS(459),
    [sym_null] = ACTIONS(459),
    [sym_undefined] = ACTIONS(459),
    [anon_sym_AT] = ACTIONS(457),
    [anon_sym_static] = ACTIONS(459),
    [anon_sym_get] = ACTIONS(459),
    [anon_sym_set] = ACTIONS(459),
    [sym__automatic_semicolon] = ACTIONS(465),
  },
  [55] = {
    [ts_builtin_sym_end] = ACTIONS(467),
    [sym_identifier] = ACTIONS(469),
    [anon_sym_export] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(469),
    [anon_sym_default] = ACTIONS(469),
    [anon_sym_LBRACE] = ACTIONS(467),
    [anon_sym_COMMA] = ACTIONS(467),
    [anon_sym_RBRACE] = ACTIONS(467),
    [anon_sym_import] = ACTIONS(469),
    [anon_sym_var] = ACTIONS(469),
    [anon_sym_let] = ACTIONS(469),
    [anon_sym_const] = ACTIONS(469),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_else] = ACTIONS(469),
    [anon_sym_switch] = ACTIONS(469),
    [anon_sym_for] = ACTIONS(469),
    [anon_sym_LPAREN] = ACTIONS(467),
    [anon_sym_await] = ACTIONS(469),
    [anon_sym_in] = ACTIONS(469),
    [anon_sym_while] = ACTIONS(469),
    [anon_sym_do] = ACTIONS(469),
    [anon_sym_try] = ACTIONS(469),
    [anon_sym_with] = ACTIONS(469),
    [anon_sym_break] = ACTIONS(469),
    [anon_sym_continue] = ACTIONS(469),
    [anon_sym_debugger] = ACTIONS(469),
    [anon_sym_return] = ACTIONS(469),
    [anon_sym_throw] = ACTIONS(469),
    [anon_sym_SEMI] = ACTIONS(467),
    [anon_sym_case] = ACTIONS(469),
    [anon_sym_yield] = ACTIONS(469),
    [anon_sym_LBRACK] = ACTIONS(467),
    [anon_sym_LT] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(469),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_DOT] = ACTIONS(469),
    [anon_sym_class] = ACTIONS(469),
    [anon_sym_async] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(469),
    [anon_sym_QMARK_DOT] = ACTIONS(467),
    [anon_sym_new] = ACTIONS(469),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(467),
    [anon_sym_GT_GT] = ACTIONS(469),
    [anon_sym_GT_GT_GT] = ACTIONS(467),
    [anon_sym_LT_LT] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(469),
    [anon_sym_CARET] = ACTIONS(467),
    [anon_sym_PIPE] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(469),
    [anon_sym_PERCENT] = ACTIONS(467),
    [anon_sym_STAR_STAR] = ACTIONS(467),
    [anon_sym_LT_EQ] = ACTIONS(467),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(467),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(467),
    [anon_sym_GT_EQ] = ACTIONS(467),
    [anon_sym_QMARK_QMARK] = ACTIONS(467),
    [anon_sym_instanceof] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(467),
    [anon_sym_typeof] = ACTIONS(469),
    [anon_sym_void] = ACTIONS(469),
    [anon_sym_delete] = ACTIONS(469),
    [anon_sym_PLUS_PLUS] = ACTIONS(467),
    [anon_sym_DASH_DASH] = ACTIONS(467),
    [anon_sym_DQUOTE] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(467),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(467),
    [sym_number] = ACTIONS(467),
    [sym_this] = ACTIONS(469),
    [sym_super] = ACTIONS(469),
    [sym_true] = ACTIONS(469),
    [sym_false] = ACTIONS(469),
    [sym_null] = ACTIONS(469),
    [sym_undefined] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(469),
    [anon_sym_get] = ACTIONS(469),
    [anon_sym_set] = ACTIONS(469),
    [sym__automatic_semicolon] = ACTIONS(467),
  },
  [56] = {
    [ts_builtin_sym_end] = ACTIONS(471),
    [sym_identifier] = ACTIONS(473),
    [anon_sym_export] = ACTIONS(473),
    [anon_sym_STAR] = ACTIONS(475),
    [anon_sym_default] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_COMMA] = ACTIONS(477),
    [anon_sym_RBRACE] = ACTIONS(471),
    [anon_sym_import] = ACTIONS(473),
    [anon_sym_var] = ACTIONS(473),
    [anon_sym_let] = ACTIONS(473),
    [anon_sym_const] = ACTIONS(473),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_else] = ACTIONS(473),
    [anon_sym_switch] = ACTIONS(473),
    [anon_sym_for] = ACTIONS(473),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_await] = ACTIONS(473),
    [anon_sym_in] = ACTIONS(475),
    [anon_sym_while] = ACTIONS(473),
    [anon_sym_do] = ACTIONS(473),
    [anon_sym_try] = ACTIONS(473),
    [anon_sym_with] = ACTIONS(473),
    [anon_sym_break] = ACTIONS(473),
    [anon_sym_continue] = ACTIONS(473),
    [anon_sym_debugger] = ACTIONS(473),
    [anon_sym_return] = ACTIONS(473),
    [anon_sym_throw] = ACTIONS(473),
    [anon_sym_SEMI] = ACTIONS(471),
    [anon_sym_case] = ACTIONS(473),
    [anon_sym_yield] = ACTIONS(473),
    [anon_sym_LBRACK] = ACTIONS(471),
    [anon_sym_LT] = ACTIONS(473),
    [anon_sym_GT] = ACTIONS(475),
    [anon_sym_SLASH] = ACTIONS(473),
    [anon_sym_DOT] = ACTIONS(475),
    [anon_sym_class] = ACTIONS(473),
    [anon_sym_async] = ACTIONS(473),
    [anon_sym_function] = ACTIONS(473),
    [anon_sym_QMARK_DOT] = ACTIONS(477),
    [anon_sym_new] = ACTIONS(473),
    [anon_sym_QMARK] = ACTIONS(475),
    [anon_sym_AMP_AMP] = ACTIONS(477),
    [anon_sym_PIPE_PIPE] = ACTIONS(477),
    [anon_sym_GT_GT] = ACTIONS(475),
    [anon_sym_GT_GT_GT] = ACTIONS(477),
    [anon_sym_LT_LT] = ACTIONS(477),
    [anon_sym_AMP] = ACTIONS(475),
    [anon_sym_CARET] = ACTIONS(477),
    [anon_sym_PIPE] = ACTIONS(475),
    [anon_sym_PLUS] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(473),
    [anon_sym_PERCENT] = ACTIONS(477),
    [anon_sym_STAR_STAR] = ACTIONS(477),
    [anon_sym_LT_EQ] = ACTIONS(477),
    [anon_sym_EQ_EQ] = ACTIONS(475),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(477),
    [anon_sym_BANG_EQ] = ACTIONS(475),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(477),
    [anon_sym_GT_EQ] = ACTIONS(477),
    [anon_sym_QMARK_QMARK] = ACTIONS(477),
    [anon_sym_instanceof] = ACTIONS(475),
    [anon_sym_BANG] = ACTIONS(473),
    [anon_sym_TILDE] = ACTIONS(471),
    [anon_sym_typeof] = ACTIONS(473),
    [anon_sym_void] = ACTIONS(473),
    [anon_sym_delete] = ACTIONS(473),
    [anon_sym_PLUS_PLUS] = ACTIONS(471),
    [anon_sym_DASH_DASH] = ACTIONS(471),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_SQUOTE] = ACTIONS(471),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(471),
    [sym_number] = ACTIONS(471),
    [sym_this] = ACTIONS(473),
    [sym_super] = ACTIONS(473),
    [sym_true] = ACTIONS(473),
    [sym_false] = ACTIONS(473),
    [sym_null] = ACTIONS(473),
    [sym_undefined] = ACTIONS(473),
    [anon_sym_AT] = ACTIONS(471),
    [anon_sym_static] = ACTIONS(473),
    [anon_sym_get] = ACTIONS(473),
    [anon_sym_set] = ACTIONS(473),
    [sym__automatic_semicolon] = ACTIONS(479),
  },
  [57] = {
    [ts_builtin_sym_end] = ACTIONS(481),
    [sym_identifier] = ACTIONS(483),
    [anon_sym_export] = ACTIONS(483),
    [anon_sym_STAR] = ACTIONS(483),
    [anon_sym_default] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(481),
    [anon_sym_COMMA] = ACTIONS(481),
    [anon_sym_RBRACE] = ACTIONS(481),
    [anon_sym_import] = ACTIONS(483),
    [anon_sym_var] = ACTIONS(483),
    [anon_sym_let] = ACTIONS(483),
    [anon_sym_const] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(483),
    [anon_sym_else] = ACTIONS(483),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_for] = ACTIONS(483),
    [anon_sym_LPAREN] = ACTIONS(481),
    [anon_sym_await] = ACTIONS(483),
    [anon_sym_in] = ACTIONS(483),
    [anon_sym_while] = ACTIONS(483),
    [anon_sym_do] = ACTIONS(483),
    [anon_sym_try] = ACTIONS(483),
    [anon_sym_with] = ACTIONS(483),
    [anon_sym_break] = ACTIONS(483),
    [anon_sym_continue] = ACTIONS(483),
    [anon_sym_debugger] = ACTIONS(483),
    [anon_sym_return] = ACTIONS(483),
    [anon_sym_throw] = ACTIONS(483),
    [anon_sym_SEMI] = ACTIONS(481),
    [anon_sym_case] = ACTIONS(483),
    [anon_sym_yield] = ACTIONS(483),
    [anon_sym_LBRACK] = ACTIONS(481),
    [anon_sym_LT] = ACTIONS(483),
    [anon_sym_GT] = ACTIONS(483),
    [anon_sym_SLASH] = ACTIONS(483),
    [anon_sym_DOT] = ACTIONS(483),
    [anon_sym_class] = ACTIONS(483),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(483),
    [anon_sym_QMARK_DOT] = ACTIONS(481),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_QMARK] = ACTIONS(483),
    [anon_sym_AMP_AMP] = ACTIONS(481),
    [anon_sym_PIPE_PIPE] = ACTIONS(481),
    [anon_sym_GT_GT] = ACTIONS(483),
    [anon_sym_GT_GT_GT] = ACTIONS(481),
    [anon_sym_LT_LT] = ACTIONS(481),
    [anon_sym_AMP] = ACTIONS(483),
    [anon_sym_CARET] = ACTIONS(481),
    [anon_sym_PIPE] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(483),
    [anon_sym_DASH] = ACTIONS(483),
    [anon_sym_PERCENT] = ACTIONS(481),
    [anon_sym_STAR_STAR] = ACTIONS(481),
    [anon_sym_LT_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ] = ACTIONS(483),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(481),
    [anon_sym_GT_EQ] = ACTIONS(481),
    [anon_sym_QMARK_QMARK] = ACTIONS(481),
    [anon_sym_instanceof] = ACTIONS(483),
    [anon_sym_BANG] = ACTIONS(483),
    [anon_sym_TILDE] = ACTIONS(481),
    [anon_sym_typeof] = ACTIONS(483),
    [anon_sym_void] = ACTIONS(483),
    [anon_sym_delete] = ACTIONS(483),
    [anon_sym_PLUS_PLUS] = ACTIONS(481),
    [anon_sym_DASH_DASH] = ACTIONS(481),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [anon_sym_SQUOTE] = ACTIONS(481),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(481),
    [sym_number] = ACTIONS(481),
    [sym_this] = ACTIONS(483),
    [sym_super] = ACTIONS(483),
    [sym_true] = ACTIONS(483),
    [sym_false] = ACTIONS(483),
    [sym_null] = ACTIONS(483),
    [sym_undefined] = ACTIONS(483),
    [anon_sym_AT] = ACTIONS(481),
    [anon_sym_static] = ACTIONS(483),
    [anon_sym_get] = ACTIONS(483),
    [anon_sym_set] = ACTIONS(483),
    [sym__automatic_semicolon] = ACTIONS(481),
  },
  [58] = {
    [ts_builtin_sym_end] = ACTIONS(481),
    [sym_identifier] = ACTIONS(483),
    [anon_sym_export] = ACTIONS(483),
    [anon_sym_STAR] = ACTIONS(483),
    [anon_sym_default] = ACTIONS(483),
    [anon_sym_LBRACE] = ACTIONS(481),
    [anon_sym_COMMA] = ACTIONS(481),
    [anon_sym_RBRACE] = ACTIONS(481),
    [anon_sym_import] = ACTIONS(483),
    [anon_sym_var] = ACTIONS(483),
    [anon_sym_let] = ACTIONS(483),
    [anon_sym_const] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(483),
    [anon_sym_else] = ACTIONS(483),
    [anon_sym_switch] = ACTIONS(483),
    [anon_sym_for] = ACTIONS(483),
    [anon_sym_LPAREN] = ACTIONS(481),
    [anon_sym_await] = ACTIONS(483),
    [anon_sym_in] = ACTIONS(483),
    [anon_sym_while] = ACTIONS(483),
    [anon_sym_do] = ACTIONS(483),
    [anon_sym_try] = ACTIONS(483),
    [anon_sym_with] = ACTIONS(483),
    [anon_sym_break] = ACTIONS(483),
    [anon_sym_continue] = ACTIONS(483),
    [anon_sym_debugger] = ACTIONS(483),
    [anon_sym_return] = ACTIONS(483),
    [anon_sym_throw] = ACTIONS(483),
    [anon_sym_SEMI] = ACTIONS(481),
    [anon_sym_case] = ACTIONS(483),
    [anon_sym_yield] = ACTIONS(483),
    [anon_sym_LBRACK] = ACTIONS(481),
    [anon_sym_LT] = ACTIONS(483),
    [anon_sym_GT] = ACTIONS(483),
    [anon_sym_SLASH] = ACTIONS(483),
    [anon_sym_DOT] = ACTIONS(483),
    [anon_sym_class] = ACTIONS(483),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(483),
    [anon_sym_QMARK_DOT] = ACTIONS(481),
    [anon_sym_new] = ACTIONS(483),
    [anon_sym_QMARK] = ACTIONS(483),
    [anon_sym_AMP_AMP] = ACTIONS(481),
    [anon_sym_PIPE_PIPE] = ACTIONS(481),
    [anon_sym_GT_GT] = ACTIONS(483),
    [anon_sym_GT_GT_GT] = ACTIONS(481),
    [anon_sym_LT_LT] = ACTIONS(481),
    [anon_sym_AMP] = ACTIONS(483),
    [anon_sym_CARET] = ACTIONS(481),
    [anon_sym_PIPE] = ACTIONS(483),
    [anon_sym_PLUS] = ACTIONS(483),
    [anon_sym_DASH] = ACTIONS(483),
    [anon_sym_PERCENT] = ACTIONS(481),
    [anon_sym_STAR_STAR] = ACTIONS(481),
    [anon_sym_LT_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ] = ACTIONS(483),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ] = ACTIONS(483),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(481),
    [anon_sym_GT_EQ] = ACTIONS(481),
    [anon_sym_QMARK_QMARK] = ACTIONS(481),
    [anon_sym_instanceof] = ACTIONS(483),
    [anon_sym_BANG] = ACTIONS(483),
    [anon_sym_TILDE] = ACTIONS(481),
    [anon_sym_typeof] = ACTIONS(483),
    [anon_sym_void] = ACTIONS(483),
    [anon_sym_delete] = ACTIONS(483),
    [anon_sym_PLUS_PLUS] = ACTIONS(481),
    [anon_sym_DASH_DASH] = ACTIONS(481),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [anon_sym_SQUOTE] = ACTIONS(481),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(481),
    [sym_number] = ACTIONS(481),
    [sym_this] = ACTIONS(483),
    [sym_super] = ACTIONS(483),
    [sym_true] = ACTIONS(483),
    [sym_false] = ACTIONS(483),
    [sym_null] = ACTIONS(483),
    [sym_undefined] = ACTIONS(483),
    [anon_sym_AT] = ACTIONS(481),
    [anon_sym_static] = ACTIONS(483),
    [anon_sym_get] = ACTIONS(483),
    [anon_sym_set] = ACTIONS(483),
    [sym__automatic_semicolon] = ACTIONS(485),
  },
  [59] = {
    [ts_builtin_sym_end] = ACTIONS(487),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_export] = ACTIONS(489),
    [anon_sym_STAR] = ACTIONS(489),
    [anon_sym_default] = ACTIONS(489),
    [anon_sym_LBRACE] = ACTIONS(487),
    [anon_sym_COMMA] = ACTIONS(487),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_import] = ACTIONS(489),
    [anon_sym_var] = ACTIONS(489),
    [anon_sym_let] = ACTIONS(489),
    [anon_sym_const] = ACTIONS(489),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_else] = ACTIONS(489),
    [anon_sym_switch] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_LPAREN] = ACTIONS(487),
    [anon_sym_await] = ACTIONS(489),
    [anon_sym_in] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(489),
    [anon_sym_try] = ACTIONS(489),
    [anon_sym_with] = ACTIONS(489),
    [anon_sym_break] = ACTIONS(489),
    [anon_sym_continue] = ACTIONS(489),
    [anon_sym_debugger] = ACTIONS(489),
    [anon_sym_return] = ACTIONS(489),
    [anon_sym_throw] = ACTIONS(489),
    [anon_sym_SEMI] = ACTIONS(487),
    [anon_sym_case] = ACTIONS(489),
    [anon_sym_yield] = ACTIONS(489),
    [anon_sym_LBRACK] = ACTIONS(487),
    [anon_sym_LT] = ACTIONS(489),
    [anon_sym_GT] = ACTIONS(489),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_DOT] = ACTIONS(489),
    [anon_sym_class] = ACTIONS(489),
    [anon_sym_async] = ACTIONS(489),
    [anon_sym_function] = ACTIONS(489),
    [anon_sym_QMARK_DOT] = ACTIONS(487),
    [anon_sym_new] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_AMP_AMP] = ACTIONS(487),
    [anon_sym_PIPE_PIPE] = ACTIONS(487),
    [anon_sym_GT_GT] = ACTIONS(489),
    [anon_sym_GT_GT_GT] = ACTIONS(487),
    [anon_sym_LT_LT] = ACTIONS(487),
    [anon_sym_AMP] = ACTIONS(489),
    [anon_sym_CARET] = ACTIONS(487),
    [anon_sym_PIPE] = ACTIONS(489),
    [anon_sym_PLUS] = ACTIONS(489),
    [anon_sym_DASH] = ACTIONS(489),
    [anon_sym_PERCENT] = ACTIONS(487),
    [anon_sym_STAR_STAR] = ACTIONS(487),
    [anon_sym_LT_EQ] = ACTIONS(487),
    [anon_sym_EQ_EQ] = ACTIONS(489),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(487),
    [anon_sym_BANG_EQ] = ACTIONS(489),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(487),
    [anon_sym_GT_EQ] = ACTIONS(487),
    [anon_sym_QMARK_QMARK] = ACTIONS(487),
    [anon_sym_instanceof] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(487),
    [anon_sym_typeof] = ACTIONS(489),
    [anon_sym_void] = ACTIONS(489),
    [anon_sym_delete] = ACTIONS(489),
    [anon_sym_PLUS_PLUS] = ACTIONS(487),
    [anon_sym_DASH_DASH] = ACTIONS(487),
    [anon_sym_DQUOTE] = ACTIONS(487),
    [anon_sym_SQUOTE] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(487),
    [sym_number] = ACTIONS(487),
    [sym_this] = ACTIONS(489),
    [sym_super] = ACTIONS(489),
    [sym_true] = ACTIONS(489),
    [sym_false] = ACTIONS(489),
    [sym_null] = ACTIONS(489),
    [sym_undefined] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(487),
    [anon_sym_static] = ACTIONS(489),
    [anon_sym_get] = ACTIONS(489),
    [anon_sym_set] = ACTIONS(489),
    [sym__automatic_semicolon] = ACTIONS(487),
  },
  [60] = {
    [sym_import] = STATE(580),
    [sym_expression_statement] = STATE(71),
    [sym_variable_declaration] = STATE(71),
    [sym_lexical_declaration] = STATE(71),
    [sym_empty_statement] = STATE(71),
    [sym_parenthesized_expression] = STATE(318),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(503),
    [sym_array] = STATE(504),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(318),
    [sym_subscript_expression] = STATE(318),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_var] = ACTIONS(493),
    [anon_sym_let] = ACTIONS(495),
    [anon_sym_const] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(497),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(499),
    [anon_sym_get] = ACTIONS(499),
    [anon_sym_set] = ACTIONS(499),
  },
  [61] = {
    [sym_import] = STATE(580),
    [sym_expression_statement] = STATE(74),
    [sym_variable_declaration] = STATE(74),
    [sym_lexical_declaration] = STATE(74),
    [sym_empty_statement] = STATE(74),
    [sym_parenthesized_expression] = STATE(318),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(503),
    [sym_array] = STATE(504),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(318),
    [sym_subscript_expression] = STATE(318),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_var] = ACTIONS(493),
    [anon_sym_let] = ACTIONS(495),
    [anon_sym_const] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(497),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(499),
    [anon_sym_get] = ACTIONS(499),
    [anon_sym_set] = ACTIONS(499),
  },
  [62] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(585),
    [sym_yield_expression] = STATE(585),
    [sym_object] = STATE(533),
    [sym_assignment_pattern] = STATE(882),
    [sym_array] = STATE(526),
    [sym_jsx_element] = STATE(585),
    [sym_jsx_fragment] = STATE(585),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(585),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(585),
    [sym_await_expression] = STATE(585),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(585),
    [sym_augmented_assignment_expression] = STATE(585),
    [sym_ternary_expression] = STATE(585),
    [sym_binary_expression] = STATE(585),
    [sym_unary_expression] = STATE(585),
    [sym_update_expression] = STATE(585),
    [sym_sequence_expression] = STATE(1092),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [sym_rest_parameter] = STATE(882),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(501),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(507),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(511),
    [anon_sym_get] = ACTIONS(511),
    [anon_sym_set] = ACTIONS(511),
  },
  [63] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(501),
    [sym_yield_expression] = STATE(501),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(501),
    [sym_jsx_fragment] = STATE(501),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(501),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(501),
    [sym_await_expression] = STATE(501),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(501),
    [sym_augmented_assignment_expression] = STATE(501),
    [sym_spread_element] = STATE(905),
    [sym_ternary_expression] = STATE(501),
    [sym_binary_expression] = STATE(501),
    [sym_unary_expression] = STATE(501),
    [sym_update_expression] = STATE(501),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(513),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(513),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_RBRACK] = ACTIONS(513),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [64] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(493),
    [sym_yield_expression] = STATE(493),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(493),
    [sym_jsx_fragment] = STATE(493),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(493),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(493),
    [sym_await_expression] = STATE(493),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(493),
    [sym_augmented_assignment_expression] = STATE(493),
    [sym_spread_element] = STATE(864),
    [sym_ternary_expression] = STATE(493),
    [sym_binary_expression] = STATE(493),
    [sym_unary_expression] = STATE(493),
    [sym_update_expression] = STATE(493),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [aux_sym_array_repeat1] = STATE(863),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(515),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_RBRACK] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [65] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(535),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(533),
    [sym_assignment_pattern] = STATE(882),
    [sym_array] = STATE(526),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_fragment] = STATE(535),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(535),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(535),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1150),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [sym_rest_parameter] = STATE(882),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(501),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(503),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(507),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(511),
    [anon_sym_get] = ACTIONS(511),
    [anon_sym_set] = ACTIONS(511),
  },
  [66] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(474),
    [sym_yield_expression] = STATE(474),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(474),
    [sym_jsx_fragment] = STATE(474),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(474),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(474),
    [sym_await_expression] = STATE(474),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(474),
    [sym_augmented_assignment_expression] = STATE(474),
    [sym_spread_element] = STATE(832),
    [sym_ternary_expression] = STATE(474),
    [sym_binary_expression] = STATE(474),
    [sym_unary_expression] = STATE(474),
    [sym_update_expression] = STATE(474),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [aux_sym_array_repeat1] = STATE(865),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(515),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(519),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [67] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(484),
    [sym_yield_expression] = STATE(484),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(484),
    [sym_jsx_fragment] = STATE(484),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(484),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(484),
    [sym_await_expression] = STATE(484),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(484),
    [sym_augmented_assignment_expression] = STATE(484),
    [sym_spread_element] = STATE(849),
    [sym_ternary_expression] = STATE(484),
    [sym_binary_expression] = STATE(484),
    [sym_unary_expression] = STATE(484),
    [sym_update_expression] = STATE(484),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [aux_sym_array_repeat1] = STATE(841),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(515),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(521),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [68] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(492),
    [sym_yield_expression] = STATE(492),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(492),
    [sym_jsx_fragment] = STATE(492),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(492),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(492),
    [sym_await_expression] = STATE(492),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(492),
    [sym_augmented_assignment_expression] = STATE(492),
    [sym_spread_element] = STATE(864),
    [sym_ternary_expression] = STATE(492),
    [sym_binary_expression] = STATE(492),
    [sym_unary_expression] = STATE(492),
    [sym_update_expression] = STATE(492),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [aux_sym_array_repeat1] = STATE(863),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(515),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_RBRACK] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [69] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(473),
    [sym_yield_expression] = STATE(473),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(473),
    [sym_jsx_fragment] = STATE(473),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(473),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(473),
    [sym_await_expression] = STATE(473),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(473),
    [sym_augmented_assignment_expression] = STATE(473),
    [sym_spread_element] = STATE(890),
    [sym_ternary_expression] = STATE(473),
    [sym_binary_expression] = STATE(473),
    [sym_unary_expression] = STATE(473),
    [sym_update_expression] = STATE(473),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [aux_sym_array_repeat1] = STATE(889),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(515),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_RBRACK] = ACTIONS(523),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [70] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(472),
    [sym_yield_expression] = STATE(472),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(472),
    [sym_jsx_fragment] = STATE(472),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(472),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(472),
    [sym_await_expression] = STATE(472),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(472),
    [sym_augmented_assignment_expression] = STATE(472),
    [sym_spread_element] = STATE(890),
    [sym_ternary_expression] = STATE(472),
    [sym_binary_expression] = STATE(472),
    [sym_unary_expression] = STATE(472),
    [sym_update_expression] = STATE(472),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [aux_sym_array_repeat1] = STATE(889),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_COMMA] = ACTIONS(515),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_RBRACK] = ACTIONS(523),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [71] = {
    [sym_import] = STATE(580),
    [sym_expression_statement] = STATE(77),
    [sym_empty_statement] = STATE(77),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [72] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(561),
    [sym_yield_expression] = STATE(561),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(561),
    [sym_jsx_fragment] = STATE(561),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(561),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(561),
    [sym_await_expression] = STATE(561),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(561),
    [sym_augmented_assignment_expression] = STATE(561),
    [sym_spread_element] = STATE(1089),
    [sym_ternary_expression] = STATE(561),
    [sym_binary_expression] = STATE(561),
    [sym_unary_expression] = STATE(561),
    [sym_update_expression] = STATE(561),
    [sym_sequence_expression] = STATE(1089),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_RBRACE] = ACTIONS(525),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [73] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(530),
    [sym_yield_expression] = STATE(530),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(530),
    [sym_jsx_fragment] = STATE(530),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(530),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(530),
    [sym_await_expression] = STATE(530),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(530),
    [sym_augmented_assignment_expression] = STATE(530),
    [sym_spread_element] = STATE(1107),
    [sym_ternary_expression] = STATE(530),
    [sym_binary_expression] = STATE(530),
    [sym_unary_expression] = STATE(530),
    [sym_update_expression] = STATE(530),
    [sym_sequence_expression] = STATE(1107),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(101),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [74] = {
    [sym_import] = STATE(580),
    [sym_expression_statement] = STATE(78),
    [sym_empty_statement] = STATE(78),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(478),
    [sym_yield_expression] = STATE(478),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(478),
    [sym_jsx_fragment] = STATE(478),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(478),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(478),
    [sym_await_expression] = STATE(478),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(478),
    [sym_augmented_assignment_expression] = STATE(478),
    [sym_ternary_expression] = STATE(478),
    [sym_binary_expression] = STATE(478),
    [sym_unary_expression] = STATE(478),
    [sym_update_expression] = STATE(478),
    [sym_sequence_expression] = STATE(1027),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [75] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(499),
    [sym_yield_expression] = STATE(499),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(499),
    [sym_jsx_fragment] = STATE(499),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(499),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(499),
    [sym_await_expression] = STATE(499),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(499),
    [sym_augmented_assignment_expression] = STATE(499),
    [sym_ternary_expression] = STATE(499),
    [sym_binary_expression] = STATE(499),
    [sym_unary_expression] = STATE(499),
    [sym_update_expression] = STATE(499),
    [sym_sequence_expression] = STATE(996),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(529),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
    [sym__automatic_semicolon] = ACTIONS(529),
  },
  [76] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(327),
    [sym__expression] = STATE(596),
    [sym_yield_expression] = STATE(596),
    [sym_object] = STATE(595),
    [sym_array] = STATE(594),
    [sym_jsx_element] = STATE(596),
    [sym_jsx_fragment] = STATE(596),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(596),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(596),
    [sym_await_expression] = STATE(596),
    [sym_member_expression] = STATE(327),
    [sym_subscript_expression] = STATE(327),
    [sym_assignment_expression] = STATE(596),
    [sym_augmented_assignment_expression] = STATE(596),
    [sym_ternary_expression] = STATE(596),
    [sym_binary_expression] = STATE(596),
    [sym_unary_expression] = STATE(596),
    [sym_update_expression] = STATE(596),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(531),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_var] = ACTIONS(533),
    [anon_sym_let] = ACTIONS(533),
    [anon_sym_const] = ACTIONS(533),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(535),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(537),
    [anon_sym_get] = ACTIONS(537),
    [anon_sym_set] = ACTIONS(537),
  },
  [77] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(534),
    [sym_yield_expression] = STATE(534),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(534),
    [sym_jsx_fragment] = STATE(534),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(534),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(534),
    [sym_await_expression] = STATE(534),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(534),
    [sym_augmented_assignment_expression] = STATE(534),
    [sym_ternary_expression] = STATE(534),
    [sym_binary_expression] = STATE(534),
    [sym_unary_expression] = STATE(534),
    [sym_update_expression] = STATE(534),
    [sym_sequence_expression] = STATE(1121),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(539),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [78] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(528),
    [sym_yield_expression] = STATE(528),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(528),
    [sym_jsx_fragment] = STATE(528),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(528),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(528),
    [sym_await_expression] = STATE(528),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(528),
    [sym_augmented_assignment_expression] = STATE(528),
    [sym_ternary_expression] = STATE(528),
    [sym_binary_expression] = STATE(528),
    [sym_unary_expression] = STATE(528),
    [sym_update_expression] = STATE(528),
    [sym_sequence_expression] = STATE(1108),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_RPAREN] = ACTIONS(541),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [79] = {
    [sym_import] = STATE(467),
    [sym_variable_declarator] = STATE(814),
    [sym_parenthesized_expression] = STATE(326),
    [sym__expression] = STATE(596),
    [sym_yield_expression] = STATE(596),
    [sym_object] = STATE(466),
    [sym_array] = STATE(440),
    [sym_jsx_element] = STATE(596),
    [sym_jsx_fragment] = STATE(596),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(596),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(596),
    [sym_await_expression] = STATE(596),
    [sym_member_expression] = STATE(326),
    [sym_subscript_expression] = STATE(326),
    [sym_assignment_expression] = STATE(596),
    [sym_augmented_assignment_expression] = STATE(596),
    [sym_ternary_expression] = STATE(596),
    [sym_binary_expression] = STATE(596),
    [sym_unary_expression] = STATE(596),
    [sym_update_expression] = STATE(596),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(545),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(547),
    [anon_sym_get] = ACTIONS(547),
    [anon_sym_set] = ACTIONS(547),
  },
  [80] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(535),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_fragment] = STATE(535),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(535),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(535),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1150),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [81] = {
    [sym_import] = STATE(370),
    [sym_parenthesized_expression] = STATE(280),
    [sym__expression] = STATE(596),
    [sym_yield_expression] = STATE(596),
    [sym_object] = STATE(349),
    [sym_array] = STATE(346),
    [sym_jsx_element] = STATE(596),
    [sym_jsx_fragment] = STATE(596),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(596),
    [sym_class] = STATE(370),
    [sym_function] = STATE(370),
    [sym_generator_function] = STATE(370),
    [sym_arrow_function] = STATE(370),
    [sym_call_expression] = STATE(370),
    [sym_new_expression] = STATE(596),
    [sym_await_expression] = STATE(596),
    [sym_member_expression] = STATE(280),
    [sym_subscript_expression] = STATE(280),
    [sym_assignment_expression] = STATE(596),
    [sym_augmented_assignment_expression] = STATE(596),
    [sym_ternary_expression] = STATE(596),
    [sym_binary_expression] = STATE(596),
    [sym_unary_expression] = STATE(596),
    [sym_update_expression] = STATE(596),
    [sym_string] = STATE(370),
    [sym_template_string] = STATE(370),
    [sym_regex] = STATE(370),
    [sym_meta_property] = STATE(370),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_DOT] = ACTIONS(551),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(553),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(555),
    [sym_this] = ACTIONS(557),
    [sym_super] = ACTIONS(557),
    [sym_true] = ACTIONS(557),
    [sym_false] = ACTIONS(557),
    [sym_null] = ACTIONS(557),
    [sym_undefined] = ACTIONS(557),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(559),
    [anon_sym_get] = ACTIONS(559),
    [anon_sym_set] = ACTIONS(559),
  },
  [82] = {
    [sym_import] = STATE(370),
    [sym_parenthesized_expression] = STATE(280),
    [sym__expression] = STATE(596),
    [sym_yield_expression] = STATE(596),
    [sym_object] = STATE(349),
    [sym_array] = STATE(346),
    [sym_jsx_element] = STATE(596),
    [sym_jsx_fragment] = STATE(596),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(596),
    [sym_class] = STATE(370),
    [sym_function] = STATE(370),
    [sym_generator_function] = STATE(370),
    [sym_arrow_function] = STATE(370),
    [sym_call_expression] = STATE(370),
    [sym_new_expression] = STATE(596),
    [sym_await_expression] = STATE(596),
    [sym_member_expression] = STATE(280),
    [sym_subscript_expression] = STATE(280),
    [sym_assignment_expression] = STATE(596),
    [sym_augmented_assignment_expression] = STATE(596),
    [sym_ternary_expression] = STATE(596),
    [sym_binary_expression] = STATE(596),
    [sym_unary_expression] = STATE(596),
    [sym_update_expression] = STATE(596),
    [sym_string] = STATE(370),
    [sym_template_string] = STATE(370),
    [sym_regex] = STATE(370),
    [sym_meta_property] = STATE(370),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_DOT] = ACTIONS(561),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(553),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(555),
    [sym_this] = ACTIONS(557),
    [sym_super] = ACTIONS(557),
    [sym_true] = ACTIONS(557),
    [sym_false] = ACTIONS(557),
    [sym_null] = ACTIONS(557),
    [sym_undefined] = ACTIONS(557),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(559),
    [anon_sym_get] = ACTIONS(559),
    [anon_sym_set] = ACTIONS(559),
  },
  [83] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(577),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(577),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1137),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [84] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(564),
    [sym_yield_expression] = STATE(564),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(564),
    [sym_jsx_fragment] = STATE(564),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(564),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(564),
    [sym_await_expression] = STATE(564),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(564),
    [sym_augmented_assignment_expression] = STATE(564),
    [sym_ternary_expression] = STATE(564),
    [sym_binary_expression] = STATE(564),
    [sym_unary_expression] = STATE(564),
    [sym_update_expression] = STATE(564),
    [sym_sequence_expression] = STATE(1087),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [85] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(579),
    [sym_yield_expression] = STATE(579),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(579),
    [sym_jsx_fragment] = STATE(579),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(579),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(579),
    [sym_await_expression] = STATE(579),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(579),
    [sym_augmented_assignment_expression] = STATE(579),
    [sym_ternary_expression] = STATE(579),
    [sym_binary_expression] = STATE(579),
    [sym_unary_expression] = STATE(579),
    [sym_update_expression] = STATE(579),
    [sym_sequence_expression] = STATE(1136),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [86] = {
    [sym_import] = STATE(480),
    [sym_parenthesized_expression] = STATE(301),
    [sym__expression] = STATE(597),
    [sym_yield_expression] = STATE(597),
    [sym_object] = STATE(401),
    [sym_array] = STATE(396),
    [sym_jsx_element] = STATE(597),
    [sym_jsx_fragment] = STATE(597),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(597),
    [sym_class] = STATE(480),
    [sym_function] = STATE(480),
    [sym_generator_function] = STATE(480),
    [sym_arrow_function] = STATE(480),
    [sym_call_expression] = STATE(480),
    [sym_new_expression] = STATE(597),
    [sym_await_expression] = STATE(597),
    [sym_member_expression] = STATE(301),
    [sym_subscript_expression] = STATE(301),
    [sym_assignment_expression] = STATE(597),
    [sym_augmented_assignment_expression] = STATE(597),
    [sym_ternary_expression] = STATE(597),
    [sym_binary_expression] = STATE(597),
    [sym_unary_expression] = STATE(597),
    [sym_update_expression] = STATE(597),
    [sym_string] = STATE(480),
    [sym_template_string] = STATE(480),
    [sym_regex] = STATE(480),
    [sym_meta_property] = STATE(480),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(563),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(561),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(565),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(569),
    [sym_this] = ACTIONS(571),
    [sym_super] = ACTIONS(571),
    [sym_true] = ACTIONS(571),
    [sym_false] = ACTIONS(571),
    [sym_null] = ACTIONS(571),
    [sym_undefined] = ACTIONS(571),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(573),
    [anon_sym_get] = ACTIONS(573),
    [anon_sym_set] = ACTIONS(573),
  },
  [87] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(547),
    [sym_yield_expression] = STATE(547),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(547),
    [sym_jsx_fragment] = STATE(547),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(547),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(547),
    [sym_await_expression] = STATE(547),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(547),
    [sym_augmented_assignment_expression] = STATE(547),
    [sym_ternary_expression] = STATE(547),
    [sym_binary_expression] = STATE(547),
    [sym_unary_expression] = STATE(547),
    [sym_update_expression] = STATE(547),
    [sym_sequence_expression] = STATE(1105),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [88] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(543),
    [sym_yield_expression] = STATE(543),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(543),
    [sym_jsx_fragment] = STATE(543),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(543),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(543),
    [sym_await_expression] = STATE(543),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(543),
    [sym_augmented_assignment_expression] = STATE(543),
    [sym_ternary_expression] = STATE(543),
    [sym_binary_expression] = STATE(543),
    [sym_unary_expression] = STATE(543),
    [sym_update_expression] = STATE(543),
    [sym_sequence_expression] = STATE(1106),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [89] = {
    [sym_import] = STATE(467),
    [sym_statement_block] = STATE(385),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(353),
    [sym_yield_expression] = STATE(353),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(353),
    [sym_jsx_fragment] = STATE(353),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(353),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(353),
    [sym_await_expression] = STATE(353),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(353),
    [sym_augmented_assignment_expression] = STATE(353),
    [sym_ternary_expression] = STATE(353),
    [sym_binary_expression] = STATE(353),
    [sym_unary_expression] = STATE(353),
    [sym_update_expression] = STATE(353),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [90] = {
    [sym_import] = STATE(467),
    [sym_variable_declarator] = STATE(810),
    [sym_parenthesized_expression] = STATE(326),
    [sym__expression] = STATE(596),
    [sym_yield_expression] = STATE(596),
    [sym_object] = STATE(466),
    [sym_array] = STATE(440),
    [sym_jsx_element] = STATE(596),
    [sym_jsx_fragment] = STATE(596),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(596),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(596),
    [sym_await_expression] = STATE(596),
    [sym_member_expression] = STATE(326),
    [sym_subscript_expression] = STATE(326),
    [sym_assignment_expression] = STATE(596),
    [sym_augmented_assignment_expression] = STATE(596),
    [sym_ternary_expression] = STATE(596),
    [sym_binary_expression] = STATE(596),
    [sym_unary_expression] = STATE(596),
    [sym_update_expression] = STATE(596),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(545),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(547),
    [anon_sym_get] = ACTIONS(547),
    [anon_sym_set] = ACTIONS(547),
  },
  [91] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(562),
    [sym_yield_expression] = STATE(562),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(562),
    [sym_jsx_fragment] = STATE(562),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(562),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(562),
    [sym_await_expression] = STATE(562),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(562),
    [sym_augmented_assignment_expression] = STATE(562),
    [sym_ternary_expression] = STATE(562),
    [sym_binary_expression] = STATE(562),
    [sym_unary_expression] = STATE(562),
    [sym_update_expression] = STATE(562),
    [sym_sequence_expression] = STATE(1099),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [92] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(509),
    [sym_yield_expression] = STATE(509),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(509),
    [sym_jsx_fragment] = STATE(509),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(509),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(509),
    [sym_await_expression] = STATE(509),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(509),
    [sym_augmented_assignment_expression] = STATE(509),
    [sym_ternary_expression] = STATE(509),
    [sym_binary_expression] = STATE(509),
    [sym_unary_expression] = STATE(509),
    [sym_update_expression] = STATE(509),
    [sym_sequence_expression] = STATE(1132),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [93] = {
    [sym_import] = STATE(580),
    [sym_statement_block] = STATE(553),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(425),
    [sym_yield_expression] = STATE(425),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(425),
    [sym_jsx_fragment] = STATE(425),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(425),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(425),
    [sym_await_expression] = STATE(425),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(425),
    [sym_augmented_assignment_expression] = STATE(425),
    [sym_ternary_expression] = STATE(425),
    [sym_binary_expression] = STATE(425),
    [sym_unary_expression] = STATE(425),
    [sym_update_expression] = STATE(425),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(577),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [94] = {
    [sym_import] = STATE(467),
    [sym_statement_block] = STATE(386),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(350),
    [sym_yield_expression] = STATE(350),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(350),
    [sym_jsx_fragment] = STATE(350),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(350),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(350),
    [sym_await_expression] = STATE(350),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(350),
    [sym_augmented_assignment_expression] = STATE(350),
    [sym_ternary_expression] = STATE(350),
    [sym_binary_expression] = STATE(350),
    [sym_unary_expression] = STATE(350),
    [sym_update_expression] = STATE(350),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [95] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(497),
    [sym_yield_expression] = STATE(497),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(497),
    [sym_jsx_fragment] = STATE(497),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(497),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(497),
    [sym_await_expression] = STATE(497),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(497),
    [sym_augmented_assignment_expression] = STATE(497),
    [sym_ternary_expression] = STATE(497),
    [sym_binary_expression] = STATE(497),
    [sym_unary_expression] = STATE(497),
    [sym_update_expression] = STATE(497),
    [sym_sequence_expression] = STATE(998),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [96] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(371),
    [sym_yield_expression] = STATE(371),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(371),
    [sym_jsx_fragment] = STATE(371),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(371),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(371),
    [sym_await_expression] = STATE(371),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(371),
    [sym_augmented_assignment_expression] = STATE(371),
    [sym_ternary_expression] = STATE(371),
    [sym_binary_expression] = STATE(371),
    [sym_unary_expression] = STATE(371),
    [sym_update_expression] = STATE(371),
    [sym_sequence_expression] = STATE(816),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [97] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(574),
    [sym_yield_expression] = STATE(574),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(574),
    [sym_jsx_fragment] = STATE(574),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(574),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(574),
    [sym_await_expression] = STATE(574),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(574),
    [sym_augmented_assignment_expression] = STATE(574),
    [sym_ternary_expression] = STATE(574),
    [sym_binary_expression] = STATE(574),
    [sym_unary_expression] = STATE(574),
    [sym_update_expression] = STATE(574),
    [sym_sequence_expression] = STATE(1138),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [98] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(570),
    [sym_yield_expression] = STATE(570),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(570),
    [sym_jsx_fragment] = STATE(570),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(570),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(570),
    [sym_await_expression] = STATE(570),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(570),
    [sym_augmented_assignment_expression] = STATE(570),
    [sym_ternary_expression] = STATE(570),
    [sym_binary_expression] = STATE(570),
    [sym_unary_expression] = STATE(570),
    [sym_update_expression] = STATE(570),
    [sym_sequence_expression] = STATE(1133),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [99] = {
    [sym_import] = STATE(467),
    [sym_statement_block] = STATE(438),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(352),
    [sym_yield_expression] = STATE(352),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(352),
    [sym_jsx_fragment] = STATE(352),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(352),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(352),
    [sym_await_expression] = STATE(352),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(352),
    [sym_augmented_assignment_expression] = STATE(352),
    [sym_ternary_expression] = STATE(352),
    [sym_binary_expression] = STATE(352),
    [sym_unary_expression] = STATE(352),
    [sym_update_expression] = STATE(352),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [100] = {
    [sym_string] = STATE(1045),
    [sym_formal_parameters] = STATE(1167),
    [sym__property_name] = STATE(1045),
    [sym_computed_property_name] = STATE(1045),
    [aux_sym_object_repeat1] = STATE(875),
    [sym_identifier] = ACTIONS(579),
    [anon_sym_STAR] = ACTIONS(581),
    [anon_sym_COMMA] = ACTIONS(584),
    [anon_sym_RBRACE] = ACTIONS(586),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_in] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_COLON] = ACTIONS(594),
    [anon_sym_EQ] = ACTIONS(597),
    [anon_sym_LBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(592),
    [anon_sym_DOT] = ACTIONS(601),
    [anon_sym_async] = ACTIONS(603),
    [anon_sym_function] = ACTIONS(605),
    [anon_sym_EQ_GT] = ACTIONS(607),
    [anon_sym_QMARK_DOT] = ACTIONS(609),
    [anon_sym_PLUS_EQ] = ACTIONS(611),
    [anon_sym_DASH_EQ] = ACTIONS(611),
    [anon_sym_STAR_EQ] = ACTIONS(611),
    [anon_sym_SLASH_EQ] = ACTIONS(611),
    [anon_sym_PERCENT_EQ] = ACTIONS(611),
    [anon_sym_CARET_EQ] = ACTIONS(611),
    [anon_sym_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_LT_LT_EQ] = ACTIONS(611),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(611),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(611),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(611),
    [anon_sym_QMARK] = ACTIONS(592),
    [anon_sym_AMP_AMP] = ACTIONS(592),
    [anon_sym_PIPE_PIPE] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(592),
    [anon_sym_GT_GT_GT] = ACTIONS(592),
    [anon_sym_LT_LT] = ACTIONS(592),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(592),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_PERCENT] = ACTIONS(592),
    [anon_sym_STAR_STAR] = ACTIONS(592),
    [anon_sym_LT_EQ] = ACTIONS(584),
    [anon_sym_EQ_EQ] = ACTIONS(592),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(584),
    [anon_sym_BANG_EQ] = ACTIONS(592),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(584),
    [anon_sym_GT_EQ] = ACTIONS(584),
    [anon_sym_QMARK_QMARK] = ACTIONS(592),
    [anon_sym_instanceof] = ACTIONS(592),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(584),
    [sym_number] = ACTIONS(613),
    [anon_sym_static] = ACTIONS(603),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [sym__automatic_semicolon] = ACTIONS(584),
  },
  [101] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(521),
    [sym_yield_expression] = STATE(521),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(521),
    [sym_jsx_fragment] = STATE(521),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(521),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(521),
    [sym_await_expression] = STATE(521),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(521),
    [sym_augmented_assignment_expression] = STATE(521),
    [sym_ternary_expression] = STATE(521),
    [sym_binary_expression] = STATE(521),
    [sym_unary_expression] = STATE(521),
    [sym_update_expression] = STATE(521),
    [sym_sequence_expression] = STATE(1113),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [102] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(522),
    [sym_yield_expression] = STATE(522),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(522),
    [sym_jsx_fragment] = STATE(522),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(522),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(522),
    [sym_await_expression] = STATE(522),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(522),
    [sym_augmented_assignment_expression] = STATE(522),
    [sym_ternary_expression] = STATE(522),
    [sym_binary_expression] = STATE(522),
    [sym_unary_expression] = STATE(522),
    [sym_update_expression] = STATE(522),
    [sym_sequence_expression] = STATE(1112),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [103] = {
    [sym_import] = STATE(467),
    [sym_statement_block] = STATE(451),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(337),
    [sym_yield_expression] = STATE(337),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(337),
    [sym_jsx_fragment] = STATE(337),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(337),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(337),
    [sym_await_expression] = STATE(337),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(337),
    [sym_augmented_assignment_expression] = STATE(337),
    [sym_ternary_expression] = STATE(337),
    [sym_binary_expression] = STATE(337),
    [sym_unary_expression] = STATE(337),
    [sym_update_expression] = STATE(337),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [104] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(525),
    [sym_yield_expression] = STATE(525),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(525),
    [sym_jsx_fragment] = STATE(525),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(525),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(525),
    [sym_await_expression] = STATE(525),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(525),
    [sym_augmented_assignment_expression] = STATE(525),
    [sym_ternary_expression] = STATE(525),
    [sym_binary_expression] = STATE(525),
    [sym_unary_expression] = STATE(525),
    [sym_update_expression] = STATE(525),
    [sym_sequence_expression] = STATE(1109),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [105] = {
    [sym_import] = STATE(580),
    [sym_statement_block] = STATE(545),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(429),
    [sym_yield_expression] = STATE(429),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(429),
    [sym_jsx_fragment] = STATE(429),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(429),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(429),
    [sym_await_expression] = STATE(429),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(429),
    [sym_augmented_assignment_expression] = STATE(429),
    [sym_ternary_expression] = STATE(429),
    [sym_binary_expression] = STATE(429),
    [sym_unary_expression] = STATE(429),
    [sym_update_expression] = STATE(429),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(577),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [106] = {
    [sym_import] = STATE(467),
    [sym_statement_block] = STATE(457),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(335),
    [sym_yield_expression] = STATE(335),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(335),
    [sym_jsx_fragment] = STATE(335),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(335),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(335),
    [sym_await_expression] = STATE(335),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(335),
    [sym_augmented_assignment_expression] = STATE(335),
    [sym_ternary_expression] = STATE(335),
    [sym_binary_expression] = STATE(335),
    [sym_unary_expression] = STATE(335),
    [sym_update_expression] = STATE(335),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [107] = {
    [sym_import] = STATE(467),
    [sym_statement_block] = STATE(465),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(351),
    [sym_yield_expression] = STATE(351),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(351),
    [sym_jsx_fragment] = STATE(351),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(351),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(351),
    [sym_await_expression] = STATE(351),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(351),
    [sym_augmented_assignment_expression] = STATE(351),
    [sym_ternary_expression] = STATE(351),
    [sym_binary_expression] = STATE(351),
    [sym_unary_expression] = STATE(351),
    [sym_update_expression] = STATE(351),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [108] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(572),
    [sym_yield_expression] = STATE(572),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(572),
    [sym_jsx_fragment] = STATE(572),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(572),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(572),
    [sym_await_expression] = STATE(572),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(572),
    [sym_augmented_assignment_expression] = STATE(572),
    [sym_ternary_expression] = STATE(572),
    [sym_binary_expression] = STATE(572),
    [sym_unary_expression] = STATE(572),
    [sym_update_expression] = STATE(572),
    [sym_sequence_expression] = STATE(1139),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [109] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(523),
    [sym_yield_expression] = STATE(523),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(523),
    [sym_jsx_fragment] = STATE(523),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(523),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(523),
    [sym_await_expression] = STATE(523),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(523),
    [sym_augmented_assignment_expression] = STATE(523),
    [sym_ternary_expression] = STATE(523),
    [sym_binary_expression] = STATE(523),
    [sym_unary_expression] = STATE(523),
    [sym_update_expression] = STATE(523),
    [sym_sequence_expression] = STATE(1111),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [110] = {
    [sym_import] = STATE(580),
    [sym_statement_block] = STATE(546),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(426),
    [sym_yield_expression] = STATE(426),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(426),
    [sym_jsx_fragment] = STATE(426),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(426),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(426),
    [sym_await_expression] = STATE(426),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(426),
    [sym_augmented_assignment_expression] = STATE(426),
    [sym_ternary_expression] = STATE(426),
    [sym_binary_expression] = STATE(426),
    [sym_unary_expression] = STATE(426),
    [sym_update_expression] = STATE(426),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(577),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [111] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(475),
    [sym_yield_expression] = STATE(475),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(475),
    [sym_jsx_fragment] = STATE(475),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(475),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(475),
    [sym_await_expression] = STATE(475),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(475),
    [sym_augmented_assignment_expression] = STATE(475),
    [sym_ternary_expression] = STATE(475),
    [sym_binary_expression] = STATE(475),
    [sym_unary_expression] = STATE(475),
    [sym_update_expression] = STATE(475),
    [sym_sequence_expression] = STATE(1038),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [112] = {
    [sym_import] = STATE(580),
    [sym_statement_block] = STATE(506),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(402),
    [sym_yield_expression] = STATE(402),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(402),
    [sym_jsx_fragment] = STATE(402),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(402),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(402),
    [sym_await_expression] = STATE(402),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(402),
    [sym_augmented_assignment_expression] = STATE(402),
    [sym_ternary_expression] = STATE(402),
    [sym_binary_expression] = STATE(402),
    [sym_unary_expression] = STATE(402),
    [sym_update_expression] = STATE(402),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(577),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [113] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(549),
    [sym_yield_expression] = STATE(549),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(549),
    [sym_jsx_fragment] = STATE(549),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(549),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(549),
    [sym_await_expression] = STATE(549),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(549),
    [sym_augmented_assignment_expression] = STATE(549),
    [sym_ternary_expression] = STATE(549),
    [sym_binary_expression] = STATE(549),
    [sym_unary_expression] = STATE(549),
    [sym_update_expression] = STATE(549),
    [sym_sequence_expression] = STATE(1103),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [114] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(529),
    [sym_yield_expression] = STATE(529),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(529),
    [sym_jsx_fragment] = STATE(529),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(529),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(529),
    [sym_await_expression] = STATE(529),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(529),
    [sym_augmented_assignment_expression] = STATE(529),
    [sym_ternary_expression] = STATE(529),
    [sym_binary_expression] = STATE(529),
    [sym_unary_expression] = STATE(529),
    [sym_update_expression] = STATE(529),
    [sym_sequence_expression] = STATE(1104),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [115] = {
    [sym_import] = STATE(580),
    [sym_statement_block] = STATE(512),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(381),
    [sym_yield_expression] = STATE(381),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(381),
    [sym_jsx_fragment] = STATE(381),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(381),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(381),
    [sym_await_expression] = STATE(381),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(381),
    [sym_augmented_assignment_expression] = STATE(381),
    [sym_ternary_expression] = STATE(381),
    [sym_binary_expression] = STATE(381),
    [sym_unary_expression] = STATE(381),
    [sym_update_expression] = STATE(381),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(577),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [116] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(551),
    [sym_yield_expression] = STATE(551),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(551),
    [sym_jsx_fragment] = STATE(551),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(551),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(551),
    [sym_await_expression] = STATE(551),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(551),
    [sym_augmented_assignment_expression] = STATE(551),
    [sym_ternary_expression] = STATE(551),
    [sym_binary_expression] = STATE(551),
    [sym_unary_expression] = STATE(551),
    [sym_update_expression] = STATE(551),
    [sym_sequence_expression] = STATE(1091),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [117] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(554),
    [sym_yield_expression] = STATE(554),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(554),
    [sym_jsx_fragment] = STATE(554),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(554),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(554),
    [sym_await_expression] = STATE(554),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(554),
    [sym_augmented_assignment_expression] = STATE(554),
    [sym_ternary_expression] = STATE(554),
    [sym_binary_expression] = STATE(554),
    [sym_unary_expression] = STATE(554),
    [sym_update_expression] = STATE(554),
    [sym_sequence_expression] = STATE(1133),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [118] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(565),
    [sym_yield_expression] = STATE(565),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(565),
    [sym_jsx_fragment] = STATE(565),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(565),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(565),
    [sym_await_expression] = STATE(565),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(565),
    [sym_augmented_assignment_expression] = STATE(565),
    [sym_ternary_expression] = STATE(565),
    [sym_binary_expression] = STATE(565),
    [sym_unary_expression] = STATE(565),
    [sym_update_expression] = STATE(565),
    [sym_sequence_expression] = STATE(1097),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [119] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(566),
    [sym_yield_expression] = STATE(566),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(566),
    [sym_jsx_fragment] = STATE(566),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(566),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(566),
    [sym_await_expression] = STATE(566),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(566),
    [sym_augmented_assignment_expression] = STATE(566),
    [sym_ternary_expression] = STATE(566),
    [sym_binary_expression] = STATE(566),
    [sym_unary_expression] = STATE(566),
    [sym_update_expression] = STATE(566),
    [sym_sequence_expression] = STATE(1096),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [120] = {
    [sym_string] = STATE(1045),
    [sym_formal_parameters] = STATE(1167),
    [sym__property_name] = STATE(1045),
    [sym_computed_property_name] = STATE(1045),
    [aux_sym_object_repeat1] = STATE(869),
    [sym_identifier] = ACTIONS(579),
    [anon_sym_STAR] = ACTIONS(581),
    [anon_sym_COMMA] = ACTIONS(584),
    [anon_sym_RBRACE] = ACTIONS(617),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_in] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_COLON] = ACTIONS(594),
    [anon_sym_EQ] = ACTIONS(597),
    [anon_sym_LBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(592),
    [anon_sym_DOT] = ACTIONS(601),
    [anon_sym_async] = ACTIONS(603),
    [anon_sym_function] = ACTIONS(605),
    [anon_sym_EQ_GT] = ACTIONS(607),
    [anon_sym_QMARK_DOT] = ACTIONS(609),
    [anon_sym_PLUS_EQ] = ACTIONS(611),
    [anon_sym_DASH_EQ] = ACTIONS(611),
    [anon_sym_STAR_EQ] = ACTIONS(611),
    [anon_sym_SLASH_EQ] = ACTIONS(611),
    [anon_sym_PERCENT_EQ] = ACTIONS(611),
    [anon_sym_CARET_EQ] = ACTIONS(611),
    [anon_sym_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_LT_LT_EQ] = ACTIONS(611),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(611),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(611),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(611),
    [anon_sym_QMARK] = ACTIONS(592),
    [anon_sym_AMP_AMP] = ACTIONS(592),
    [anon_sym_PIPE_PIPE] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(592),
    [anon_sym_GT_GT_GT] = ACTIONS(592),
    [anon_sym_LT_LT] = ACTIONS(592),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(592),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_PERCENT] = ACTIONS(592),
    [anon_sym_STAR_STAR] = ACTIONS(592),
    [anon_sym_LT_EQ] = ACTIONS(584),
    [anon_sym_EQ_EQ] = ACTIONS(592),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(584),
    [anon_sym_BANG_EQ] = ACTIONS(592),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(584),
    [anon_sym_GT_EQ] = ACTIONS(584),
    [anon_sym_QMARK_QMARK] = ACTIONS(592),
    [anon_sym_instanceof] = ACTIONS(592),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(584),
    [sym_number] = ACTIONS(613),
    [anon_sym_static] = ACTIONS(603),
    [anon_sym_get] = ACTIONS(615),
    [anon_sym_set] = ACTIONS(615),
    [sym__automatic_semicolon] = ACTIONS(584),
  },
  [121] = {
    [sym_import] = STATE(580),
    [sym_statement_block] = STATE(555),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(378),
    [sym_yield_expression] = STATE(378),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(378),
    [sym_jsx_fragment] = STATE(378),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(378),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(378),
    [sym_await_expression] = STATE(378),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(378),
    [sym_augmented_assignment_expression] = STATE(378),
    [sym_ternary_expression] = STATE(378),
    [sym_binary_expression] = STATE(378),
    [sym_unary_expression] = STATE(378),
    [sym_update_expression] = STATE(378),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(577),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [122] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(520),
    [sym_yield_expression] = STATE(520),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(520),
    [sym_jsx_fragment] = STATE(520),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(520),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(520),
    [sym_await_expression] = STATE(520),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(520),
    [sym_augmented_assignment_expression] = STATE(520),
    [sym_ternary_expression] = STATE(520),
    [sym_binary_expression] = STATE(520),
    [sym_unary_expression] = STATE(520),
    [sym_update_expression] = STATE(520),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [123] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(415),
    [sym_yield_expression] = STATE(415),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(415),
    [sym_jsx_fragment] = STATE(415),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(415),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(415),
    [sym_await_expression] = STATE(415),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(415),
    [sym_augmented_assignment_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_update_expression] = STATE(415),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [124] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(495),
    [sym_yield_expression] = STATE(495),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(495),
    [sym_jsx_fragment] = STATE(495),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(495),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(495),
    [sym_await_expression] = STATE(495),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(495),
    [sym_augmented_assignment_expression] = STATE(495),
    [sym_ternary_expression] = STATE(495),
    [sym_binary_expression] = STATE(495),
    [sym_unary_expression] = STATE(495),
    [sym_update_expression] = STATE(495),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [125] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(344),
    [sym_yield_expression] = STATE(344),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(344),
    [sym_jsx_fragment] = STATE(344),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(344),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(344),
    [sym_await_expression] = STATE(344),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(344),
    [sym_augmented_assignment_expression] = STATE(344),
    [sym_ternary_expression] = STATE(344),
    [sym_binary_expression] = STATE(344),
    [sym_unary_expression] = STATE(344),
    [sym_update_expression] = STATE(344),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [126] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(367),
    [sym_yield_expression] = STATE(367),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(367),
    [sym_jsx_fragment] = STATE(367),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(367),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(367),
    [sym_await_expression] = STATE(367),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(367),
    [sym_augmented_assignment_expression] = STATE(367),
    [sym_ternary_expression] = STATE(367),
    [sym_binary_expression] = STATE(367),
    [sym_unary_expression] = STATE(367),
    [sym_update_expression] = STATE(367),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [127] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(366),
    [sym_yield_expression] = STATE(366),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(366),
    [sym_jsx_fragment] = STATE(366),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(366),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(366),
    [sym_await_expression] = STATE(366),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(366),
    [sym_augmented_assignment_expression] = STATE(366),
    [sym_ternary_expression] = STATE(366),
    [sym_binary_expression] = STATE(366),
    [sym_unary_expression] = STATE(366),
    [sym_update_expression] = STATE(366),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [128] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(384),
    [sym_yield_expression] = STATE(384),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(384),
    [sym_jsx_fragment] = STATE(384),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(384),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(384),
    [sym_await_expression] = STATE(384),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(384),
    [sym_augmented_assignment_expression] = STATE(384),
    [sym_ternary_expression] = STATE(384),
    [sym_binary_expression] = STATE(384),
    [sym_unary_expression] = STATE(384),
    [sym_update_expression] = STATE(384),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [129] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(363),
    [sym_yield_expression] = STATE(363),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(363),
    [sym_jsx_fragment] = STATE(363),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(363),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(363),
    [sym_await_expression] = STATE(363),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(363),
    [sym_augmented_assignment_expression] = STATE(363),
    [sym_ternary_expression] = STATE(363),
    [sym_binary_expression] = STATE(363),
    [sym_unary_expression] = STATE(363),
    [sym_update_expression] = STATE(363),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [130] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(362),
    [sym_yield_expression] = STATE(362),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(362),
    [sym_jsx_fragment] = STATE(362),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(362),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(362),
    [sym_await_expression] = STATE(362),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(362),
    [sym_augmented_assignment_expression] = STATE(362),
    [sym_ternary_expression] = STATE(362),
    [sym_binary_expression] = STATE(362),
    [sym_unary_expression] = STATE(362),
    [sym_update_expression] = STATE(362),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [131] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(444),
    [sym_yield_expression] = STATE(444),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(444),
    [sym_jsx_fragment] = STATE(444),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(444),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(444),
    [sym_await_expression] = STATE(444),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(444),
    [sym_augmented_assignment_expression] = STATE(444),
    [sym_ternary_expression] = STATE(444),
    [sym_binary_expression] = STATE(444),
    [sym_unary_expression] = STATE(444),
    [sym_update_expression] = STATE(444),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [132] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(588),
    [sym_yield_expression] = STATE(588),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(588),
    [sym_jsx_fragment] = STATE(588),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(588),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(588),
    [sym_await_expression] = STATE(588),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(588),
    [sym_augmented_assignment_expression] = STATE(588),
    [sym_ternary_expression] = STATE(588),
    [sym_binary_expression] = STATE(588),
    [sym_unary_expression] = STATE(588),
    [sym_update_expression] = STATE(588),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [133] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(343),
    [sym_yield_expression] = STATE(343),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(343),
    [sym_jsx_fragment] = STATE(343),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(343),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(343),
    [sym_await_expression] = STATE(343),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(343),
    [sym_augmented_assignment_expression] = STATE(343),
    [sym_ternary_expression] = STATE(343),
    [sym_binary_expression] = STATE(343),
    [sym_unary_expression] = STATE(343),
    [sym_update_expression] = STATE(343),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [134] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(479),
    [sym_yield_expression] = STATE(479),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(479),
    [sym_jsx_fragment] = STATE(479),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(479),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(479),
    [sym_await_expression] = STATE(479),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(479),
    [sym_augmented_assignment_expression] = STATE(479),
    [sym_ternary_expression] = STATE(479),
    [sym_binary_expression] = STATE(479),
    [sym_unary_expression] = STATE(479),
    [sym_update_expression] = STATE(479),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [135] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(482),
    [sym_yield_expression] = STATE(482),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(482),
    [sym_jsx_fragment] = STATE(482),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(482),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(482),
    [sym_await_expression] = STATE(482),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(482),
    [sym_augmented_assignment_expression] = STATE(482),
    [sym_ternary_expression] = STATE(482),
    [sym_binary_expression] = STATE(482),
    [sym_unary_expression] = STATE(482),
    [sym_update_expression] = STATE(482),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [136] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(483),
    [sym_yield_expression] = STATE(483),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(483),
    [sym_jsx_fragment] = STATE(483),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(483),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(483),
    [sym_await_expression] = STATE(483),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(483),
    [sym_augmented_assignment_expression] = STATE(483),
    [sym_ternary_expression] = STATE(483),
    [sym_binary_expression] = STATE(483),
    [sym_unary_expression] = STATE(483),
    [sym_update_expression] = STATE(483),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [137] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(361),
    [sym_yield_expression] = STATE(361),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(361),
    [sym_jsx_fragment] = STATE(361),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(361),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(361),
    [sym_await_expression] = STATE(361),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(361),
    [sym_augmented_assignment_expression] = STATE(361),
    [sym_ternary_expression] = STATE(361),
    [sym_binary_expression] = STATE(361),
    [sym_unary_expression] = STATE(361),
    [sym_update_expression] = STATE(361),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [138] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(326),
    [sym__expression] = STATE(596),
    [sym_yield_expression] = STATE(596),
    [sym_object] = STATE(598),
    [sym_array] = STATE(593),
    [sym_jsx_element] = STATE(596),
    [sym_jsx_fragment] = STATE(596),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(596),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(596),
    [sym_await_expression] = STATE(596),
    [sym_member_expression] = STATE(326),
    [sym_subscript_expression] = STATE(326),
    [sym_assignment_expression] = STATE(596),
    [sym_augmented_assignment_expression] = STATE(596),
    [sym_ternary_expression] = STATE(596),
    [sym_binary_expression] = STATE(596),
    [sym_unary_expression] = STATE(596),
    [sym_update_expression] = STATE(596),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(619),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(545),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(547),
    [anon_sym_get] = ACTIONS(547),
    [anon_sym_set] = ACTIONS(547),
  },
  [139] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(359),
    [sym_yield_expression] = STATE(359),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(359),
    [sym_jsx_fragment] = STATE(359),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(359),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(359),
    [sym_await_expression] = STATE(359),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(359),
    [sym_augmented_assignment_expression] = STATE(359),
    [sym_ternary_expression] = STATE(359),
    [sym_binary_expression] = STATE(359),
    [sym_unary_expression] = STATE(359),
    [sym_update_expression] = STATE(359),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [140] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(589),
    [sym_yield_expression] = STATE(589),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(589),
    [sym_jsx_fragment] = STATE(589),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(589),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(589),
    [sym_await_expression] = STATE(589),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(589),
    [sym_augmented_assignment_expression] = STATE(589),
    [sym_ternary_expression] = STATE(589),
    [sym_binary_expression] = STATE(589),
    [sym_unary_expression] = STATE(589),
    [sym_update_expression] = STATE(589),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [141] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(576),
    [sym_yield_expression] = STATE(576),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(576),
    [sym_jsx_fragment] = STATE(576),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(576),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(576),
    [sym_await_expression] = STATE(576),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(576),
    [sym_augmented_assignment_expression] = STATE(576),
    [sym_ternary_expression] = STATE(576),
    [sym_binary_expression] = STATE(576),
    [sym_unary_expression] = STATE(576),
    [sym_update_expression] = STATE(576),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [142] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(464),
    [sym_yield_expression] = STATE(464),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(464),
    [sym_jsx_fragment] = STATE(464),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(464),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(464),
    [sym_await_expression] = STATE(464),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(464),
    [sym_augmented_assignment_expression] = STATE(464),
    [sym_ternary_expression] = STATE(464),
    [sym_binary_expression] = STATE(464),
    [sym_unary_expression] = STATE(464),
    [sym_update_expression] = STATE(464),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [143] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(358),
    [sym_yield_expression] = STATE(358),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(358),
    [sym_jsx_fragment] = STATE(358),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(358),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(358),
    [sym_await_expression] = STATE(358),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(358),
    [sym_augmented_assignment_expression] = STATE(358),
    [sym_ternary_expression] = STATE(358),
    [sym_binary_expression] = STATE(358),
    [sym_unary_expression] = STATE(358),
    [sym_update_expression] = STATE(358),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [144] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(462),
    [sym_yield_expression] = STATE(462),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(462),
    [sym_jsx_fragment] = STATE(462),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(462),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(462),
    [sym_await_expression] = STATE(462),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(462),
    [sym_augmented_assignment_expression] = STATE(462),
    [sym_ternary_expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_update_expression] = STATE(462),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [145] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(592),
    [sym_yield_expression] = STATE(592),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(592),
    [sym_jsx_fragment] = STATE(592),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(592),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(592),
    [sym_await_expression] = STATE(592),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(592),
    [sym_augmented_assignment_expression] = STATE(592),
    [sym_ternary_expression] = STATE(592),
    [sym_binary_expression] = STATE(592),
    [sym_unary_expression] = STATE(592),
    [sym_update_expression] = STATE(592),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [146] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(357),
    [sym_yield_expression] = STATE(357),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(357),
    [sym_jsx_fragment] = STATE(357),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(357),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(357),
    [sym_await_expression] = STATE(357),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(357),
    [sym_augmented_assignment_expression] = STATE(357),
    [sym_ternary_expression] = STATE(357),
    [sym_binary_expression] = STATE(357),
    [sym_unary_expression] = STATE(357),
    [sym_update_expression] = STATE(357),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [147] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(459),
    [sym_yield_expression] = STATE(459),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(459),
    [sym_jsx_fragment] = STATE(459),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(459),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(459),
    [sym_await_expression] = STATE(459),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(459),
    [sym_augmented_assignment_expression] = STATE(459),
    [sym_ternary_expression] = STATE(459),
    [sym_binary_expression] = STATE(459),
    [sym_unary_expression] = STATE(459),
    [sym_update_expression] = STATE(459),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [148] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(356),
    [sym_yield_expression] = STATE(356),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(356),
    [sym_jsx_fragment] = STATE(356),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(356),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(356),
    [sym_await_expression] = STATE(356),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(356),
    [sym_augmented_assignment_expression] = STATE(356),
    [sym_ternary_expression] = STATE(356),
    [sym_binary_expression] = STATE(356),
    [sym_unary_expression] = STATE(356),
    [sym_update_expression] = STATE(356),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [149] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(354),
    [sym_yield_expression] = STATE(354),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(354),
    [sym_jsx_fragment] = STATE(354),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(354),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(354),
    [sym_await_expression] = STATE(354),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(354),
    [sym_augmented_assignment_expression] = STATE(354),
    [sym_ternary_expression] = STATE(354),
    [sym_binary_expression] = STATE(354),
    [sym_unary_expression] = STATE(354),
    [sym_update_expression] = STATE(354),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [150] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(360),
    [sym_yield_expression] = STATE(360),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(360),
    [sym_jsx_fragment] = STATE(360),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(360),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(360),
    [sym_await_expression] = STATE(360),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(360),
    [sym_augmented_assignment_expression] = STATE(360),
    [sym_ternary_expression] = STATE(360),
    [sym_binary_expression] = STATE(360),
    [sym_unary_expression] = STATE(360),
    [sym_update_expression] = STATE(360),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [151] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(404),
    [sym_yield_expression] = STATE(404),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(404),
    [sym_jsx_fragment] = STATE(404),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(404),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(404),
    [sym_await_expression] = STATE(404),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(404),
    [sym_augmented_assignment_expression] = STATE(404),
    [sym_ternary_expression] = STATE(404),
    [sym_binary_expression] = STATE(404),
    [sym_unary_expression] = STATE(404),
    [sym_update_expression] = STATE(404),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [152] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(456),
    [sym_yield_expression] = STATE(456),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(456),
    [sym_jsx_fragment] = STATE(456),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(456),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(456),
    [sym_await_expression] = STATE(456),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(456),
    [sym_augmented_assignment_expression] = STATE(456),
    [sym_ternary_expression] = STATE(456),
    [sym_binary_expression] = STATE(456),
    [sym_unary_expression] = STATE(456),
    [sym_update_expression] = STATE(456),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [153] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(331),
    [sym_yield_expression] = STATE(331),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(331),
    [sym_jsx_fragment] = STATE(331),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(331),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(331),
    [sym_await_expression] = STATE(331),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(331),
    [sym_augmented_assignment_expression] = STATE(331),
    [sym_ternary_expression] = STATE(331),
    [sym_binary_expression] = STATE(331),
    [sym_unary_expression] = STATE(331),
    [sym_update_expression] = STATE(331),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [154] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(340),
    [sym_yield_expression] = STATE(340),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(340),
    [sym_jsx_fragment] = STATE(340),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(340),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(340),
    [sym_await_expression] = STATE(340),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(340),
    [sym_augmented_assignment_expression] = STATE(340),
    [sym_ternary_expression] = STATE(340),
    [sym_binary_expression] = STATE(340),
    [sym_unary_expression] = STATE(340),
    [sym_update_expression] = STATE(340),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [155] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(395),
    [sym_yield_expression] = STATE(395),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(395),
    [sym_jsx_fragment] = STATE(395),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(395),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(395),
    [sym_await_expression] = STATE(395),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(395),
    [sym_augmented_assignment_expression] = STATE(395),
    [sym_ternary_expression] = STATE(395),
    [sym_binary_expression] = STATE(395),
    [sym_unary_expression] = STATE(395),
    [sym_update_expression] = STATE(395),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [156] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(568),
    [sym_yield_expression] = STATE(568),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(568),
    [sym_jsx_fragment] = STATE(568),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(568),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(568),
    [sym_await_expression] = STATE(568),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(568),
    [sym_augmented_assignment_expression] = STATE(568),
    [sym_ternary_expression] = STATE(568),
    [sym_binary_expression] = STATE(568),
    [sym_unary_expression] = STATE(568),
    [sym_update_expression] = STATE(568),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [157] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(575),
    [sym_yield_expression] = STATE(575),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(575),
    [sym_jsx_fragment] = STATE(575),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(575),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(575),
    [sym_await_expression] = STATE(575),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(575),
    [sym_augmented_assignment_expression] = STATE(575),
    [sym_ternary_expression] = STATE(575),
    [sym_binary_expression] = STATE(575),
    [sym_unary_expression] = STATE(575),
    [sym_update_expression] = STATE(575),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [158] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(383),
    [sym_yield_expression] = STATE(383),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(383),
    [sym_jsx_fragment] = STATE(383),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(383),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(383),
    [sym_await_expression] = STATE(383),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(383),
    [sym_augmented_assignment_expression] = STATE(383),
    [sym_ternary_expression] = STATE(383),
    [sym_binary_expression] = STATE(383),
    [sym_unary_expression] = STATE(383),
    [sym_update_expression] = STATE(383),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [159] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(563),
    [sym_yield_expression] = STATE(563),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(563),
    [sym_jsx_fragment] = STATE(563),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(563),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(563),
    [sym_await_expression] = STATE(563),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(563),
    [sym_augmented_assignment_expression] = STATE(563),
    [sym_ternary_expression] = STATE(563),
    [sym_binary_expression] = STATE(563),
    [sym_unary_expression] = STATE(563),
    [sym_update_expression] = STATE(563),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [160] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(394),
    [sym_yield_expression] = STATE(394),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(394),
    [sym_jsx_fragment] = STATE(394),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(394),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(394),
    [sym_await_expression] = STATE(394),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(394),
    [sym_augmented_assignment_expression] = STATE(394),
    [sym_ternary_expression] = STATE(394),
    [sym_binary_expression] = STATE(394),
    [sym_unary_expression] = STATE(394),
    [sym_update_expression] = STATE(394),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [161] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(380),
    [sym_yield_expression] = STATE(380),
    [sym_object] = STATE(587),
    [sym_array] = STATE(586),
    [sym_jsx_element] = STATE(380),
    [sym_jsx_fragment] = STATE(380),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(380),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(380),
    [sym_await_expression] = STATE(380),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(380),
    [sym_augmented_assignment_expression] = STATE(380),
    [sym_ternary_expression] = STATE(380),
    [sym_binary_expression] = STATE(380),
    [sym_unary_expression] = STATE(380),
    [sym_update_expression] = STATE(380),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(621),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [162] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(424),
    [sym_yield_expression] = STATE(424),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(424),
    [sym_jsx_fragment] = STATE(424),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(424),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(424),
    [sym_await_expression] = STATE(424),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(424),
    [sym_augmented_assignment_expression] = STATE(424),
    [sym_ternary_expression] = STATE(424),
    [sym_binary_expression] = STATE(424),
    [sym_unary_expression] = STATE(424),
    [sym_update_expression] = STATE(424),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [163] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(393),
    [sym_yield_expression] = STATE(393),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(393),
    [sym_jsx_fragment] = STATE(393),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(393),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(393),
    [sym_await_expression] = STATE(393),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(393),
    [sym_augmented_assignment_expression] = STATE(393),
    [sym_ternary_expression] = STATE(393),
    [sym_binary_expression] = STATE(393),
    [sym_unary_expression] = STATE(393),
    [sym_update_expression] = STATE(393),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [164] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(524),
    [sym_yield_expression] = STATE(524),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(524),
    [sym_jsx_fragment] = STATE(524),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(524),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(524),
    [sym_await_expression] = STATE(524),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(524),
    [sym_augmented_assignment_expression] = STATE(524),
    [sym_ternary_expression] = STATE(524),
    [sym_binary_expression] = STATE(524),
    [sym_unary_expression] = STATE(524),
    [sym_update_expression] = STATE(524),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [165] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(368),
    [sym_yield_expression] = STATE(368),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(368),
    [sym_jsx_fragment] = STATE(368),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(368),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(368),
    [sym_await_expression] = STATE(368),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(368),
    [sym_augmented_assignment_expression] = STATE(368),
    [sym_ternary_expression] = STATE(368),
    [sym_binary_expression] = STATE(368),
    [sym_unary_expression] = STATE(368),
    [sym_update_expression] = STATE(368),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [166] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(342),
    [sym_yield_expression] = STATE(342),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(342),
    [sym_jsx_fragment] = STATE(342),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(342),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(342),
    [sym_await_expression] = STATE(342),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(342),
    [sym_augmented_assignment_expression] = STATE(342),
    [sym_ternary_expression] = STATE(342),
    [sym_binary_expression] = STATE(342),
    [sym_unary_expression] = STATE(342),
    [sym_update_expression] = STATE(342),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [167] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(345),
    [sym_yield_expression] = STATE(345),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(345),
    [sym_jsx_fragment] = STATE(345),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(345),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(345),
    [sym_await_expression] = STATE(345),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(345),
    [sym_augmented_assignment_expression] = STATE(345),
    [sym_ternary_expression] = STATE(345),
    [sym_binary_expression] = STATE(345),
    [sym_unary_expression] = STATE(345),
    [sym_update_expression] = STATE(345),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [168] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(338),
    [sym_yield_expression] = STATE(338),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(338),
    [sym_jsx_fragment] = STATE(338),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(338),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(338),
    [sym_await_expression] = STATE(338),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(338),
    [sym_augmented_assignment_expression] = STATE(338),
    [sym_ternary_expression] = STATE(338),
    [sym_binary_expression] = STATE(338),
    [sym_unary_expression] = STATE(338),
    [sym_update_expression] = STATE(338),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [169] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(392),
    [sym_yield_expression] = STATE(392),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(392),
    [sym_jsx_fragment] = STATE(392),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(392),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(392),
    [sym_await_expression] = STATE(392),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(392),
    [sym_augmented_assignment_expression] = STATE(392),
    [sym_ternary_expression] = STATE(392),
    [sym_binary_expression] = STATE(392),
    [sym_unary_expression] = STATE(392),
    [sym_update_expression] = STATE(392),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [170] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(590),
    [sym_yield_expression] = STATE(590),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(590),
    [sym_jsx_fragment] = STATE(590),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(590),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(590),
    [sym_await_expression] = STATE(590),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(590),
    [sym_augmented_assignment_expression] = STATE(590),
    [sym_ternary_expression] = STATE(590),
    [sym_binary_expression] = STATE(590),
    [sym_unary_expression] = STATE(590),
    [sym_update_expression] = STATE(590),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [171] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(485),
    [sym_yield_expression] = STATE(485),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(485),
    [sym_jsx_fragment] = STATE(485),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(485),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(485),
    [sym_await_expression] = STATE(485),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(485),
    [sym_augmented_assignment_expression] = STATE(485),
    [sym_ternary_expression] = STATE(485),
    [sym_binary_expression] = STATE(485),
    [sym_unary_expression] = STATE(485),
    [sym_update_expression] = STATE(485),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [172] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(486),
    [sym_yield_expression] = STATE(486),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(486),
    [sym_jsx_fragment] = STATE(486),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(486),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(486),
    [sym_await_expression] = STATE(486),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(486),
    [sym_augmented_assignment_expression] = STATE(486),
    [sym_ternary_expression] = STATE(486),
    [sym_binary_expression] = STATE(486),
    [sym_unary_expression] = STATE(486),
    [sym_update_expression] = STATE(486),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [173] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(421),
    [sym_yield_expression] = STATE(421),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(421),
    [sym_jsx_fragment] = STATE(421),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(421),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(421),
    [sym_await_expression] = STATE(421),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(421),
    [sym_augmented_assignment_expression] = STATE(421),
    [sym_ternary_expression] = STATE(421),
    [sym_binary_expression] = STATE(421),
    [sym_unary_expression] = STATE(421),
    [sym_update_expression] = STATE(421),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [174] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(487),
    [sym_yield_expression] = STATE(487),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(487),
    [sym_jsx_fragment] = STATE(487),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(487),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(487),
    [sym_await_expression] = STATE(487),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(487),
    [sym_augmented_assignment_expression] = STATE(487),
    [sym_ternary_expression] = STATE(487),
    [sym_binary_expression] = STATE(487),
    [sym_unary_expression] = STATE(487),
    [sym_update_expression] = STATE(487),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [175] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(510),
    [sym_yield_expression] = STATE(510),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(510),
    [sym_jsx_fragment] = STATE(510),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(510),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(510),
    [sym_await_expression] = STATE(510),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(510),
    [sym_augmented_assignment_expression] = STATE(510),
    [sym_ternary_expression] = STATE(510),
    [sym_binary_expression] = STATE(510),
    [sym_unary_expression] = STATE(510),
    [sym_update_expression] = STATE(510),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [176] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(420),
    [sym_yield_expression] = STATE(420),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(420),
    [sym_jsx_fragment] = STATE(420),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(420),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(420),
    [sym_await_expression] = STATE(420),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(420),
    [sym_augmented_assignment_expression] = STATE(420),
    [sym_ternary_expression] = STATE(420),
    [sym_binary_expression] = STATE(420),
    [sym_unary_expression] = STATE(420),
    [sym_update_expression] = STATE(420),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [177] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(364),
    [sym_yield_expression] = STATE(364),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(364),
    [sym_jsx_fragment] = STATE(364),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(364),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(364),
    [sym_await_expression] = STATE(364),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(364),
    [sym_augmented_assignment_expression] = STATE(364),
    [sym_ternary_expression] = STATE(364),
    [sym_binary_expression] = STATE(364),
    [sym_unary_expression] = STATE(364),
    [sym_update_expression] = STATE(364),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [178] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(419),
    [sym_yield_expression] = STATE(419),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(419),
    [sym_jsx_fragment] = STATE(419),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(419),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(419),
    [sym_await_expression] = STATE(419),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(419),
    [sym_augmented_assignment_expression] = STATE(419),
    [sym_ternary_expression] = STATE(419),
    [sym_binary_expression] = STATE(419),
    [sym_unary_expression] = STATE(419),
    [sym_update_expression] = STATE(419),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [179] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(418),
    [sym_yield_expression] = STATE(418),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(418),
    [sym_jsx_fragment] = STATE(418),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(418),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(418),
    [sym_await_expression] = STATE(418),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(418),
    [sym_augmented_assignment_expression] = STATE(418),
    [sym_ternary_expression] = STATE(418),
    [sym_binary_expression] = STATE(418),
    [sym_unary_expression] = STATE(418),
    [sym_update_expression] = STATE(418),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [180] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(380),
    [sym_yield_expression] = STATE(380),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(380),
    [sym_jsx_fragment] = STATE(380),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(380),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(380),
    [sym_await_expression] = STATE(380),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(380),
    [sym_augmented_assignment_expression] = STATE(380),
    [sym_ternary_expression] = STATE(380),
    [sym_binary_expression] = STATE(380),
    [sym_unary_expression] = STATE(380),
    [sym_update_expression] = STATE(380),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [181] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(417),
    [sym_yield_expression] = STATE(417),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(417),
    [sym_jsx_fragment] = STATE(417),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(417),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(417),
    [sym_await_expression] = STATE(417),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(417),
    [sym_augmented_assignment_expression] = STATE(417),
    [sym_ternary_expression] = STATE(417),
    [sym_binary_expression] = STATE(417),
    [sym_unary_expression] = STATE(417),
    [sym_update_expression] = STATE(417),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [182] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(416),
    [sym_yield_expression] = STATE(416),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(416),
    [sym_jsx_fragment] = STATE(416),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(416),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(416),
    [sym_await_expression] = STATE(416),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(416),
    [sym_augmented_assignment_expression] = STATE(416),
    [sym_ternary_expression] = STATE(416),
    [sym_binary_expression] = STATE(416),
    [sym_unary_expression] = STATE(416),
    [sym_update_expression] = STATE(416),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [183] = {
    [sym_import] = STATE(467),
    [sym_parenthesized_expression] = STATE(287),
    [sym__expression] = STATE(591),
    [sym_yield_expression] = STATE(591),
    [sym_object] = STATE(369),
    [sym_array] = STATE(372),
    [sym_jsx_element] = STATE(591),
    [sym_jsx_fragment] = STATE(591),
    [sym_jsx_opening_element] = STATE(682),
    [sym_jsx_self_closing_element] = STATE(591),
    [sym_class] = STATE(467),
    [sym_function] = STATE(467),
    [sym_generator_function] = STATE(467),
    [sym_arrow_function] = STATE(467),
    [sym_call_expression] = STATE(467),
    [sym_new_expression] = STATE(591),
    [sym_await_expression] = STATE(591),
    [sym_member_expression] = STATE(287),
    [sym_subscript_expression] = STATE(287),
    [sym_assignment_expression] = STATE(591),
    [sym_augmented_assignment_expression] = STATE(591),
    [sym_ternary_expression] = STATE(591),
    [sym_binary_expression] = STATE(591),
    [sym_unary_expression] = STATE(591),
    [sym_update_expression] = STATE(591),
    [sym_string] = STATE(467),
    [sym_template_string] = STATE(467),
    [sym_regex] = STATE(467),
    [sym_meta_property] = STATE(467),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1135),
    [aux_sym_export_statement_repeat1] = STATE(769),
    [sym_identifier] = ACTIONS(307),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_import] = ACTIONS(315),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_await] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(323),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(505),
    [anon_sym_SLASH] = ACTIONS(329),
    [anon_sym_class] = ACTIONS(331),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(335),
    [anon_sym_new] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_BANG] = ACTIONS(343),
    [anon_sym_TILDE] = ACTIONS(343),
    [anon_sym_typeof] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(345),
    [anon_sym_delete] = ACTIONS(345),
    [anon_sym_PLUS_PLUS] = ACTIONS(347),
    [anon_sym_DASH_DASH] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [sym_number] = ACTIONS(355),
    [sym_this] = ACTIONS(357),
    [sym_super] = ACTIONS(357),
    [sym_true] = ACTIONS(357),
    [sym_false] = ACTIONS(357),
    [sym_null] = ACTIONS(357),
    [sym_undefined] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(359),
    [anon_sym_get] = ACTIONS(359),
    [anon_sym_set] = ACTIONS(359),
  },
  [184] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(413),
    [sym_yield_expression] = STATE(413),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(413),
    [sym_jsx_fragment] = STATE(413),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(413),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(413),
    [sym_await_expression] = STATE(413),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(413),
    [sym_augmented_assignment_expression] = STATE(413),
    [sym_ternary_expression] = STATE(413),
    [sym_binary_expression] = STATE(413),
    [sym_unary_expression] = STATE(413),
    [sym_update_expression] = STATE(413),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [185] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(406),
    [sym_yield_expression] = STATE(406),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(406),
    [sym_jsx_fragment] = STATE(406),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(406),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(406),
    [sym_await_expression] = STATE(406),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [186] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(400),
    [sym_yield_expression] = STATE(400),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(400),
    [sym_jsx_fragment] = STATE(400),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(400),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(400),
    [sym_await_expression] = STATE(400),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(400),
    [sym_augmented_assignment_expression] = STATE(400),
    [sym_ternary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_update_expression] = STATE(400),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [187] = {
    [sym_import] = STATE(580),
    [sym_parenthesized_expression] = STATE(317),
    [sym__expression] = STATE(403),
    [sym_yield_expression] = STATE(403),
    [sym_object] = STATE(477),
    [sym_array] = STATE(476),
    [sym_jsx_element] = STATE(403),
    [sym_jsx_fragment] = STATE(403),
    [sym_jsx_opening_element] = STATE(684),
    [sym_jsx_self_closing_element] = STATE(403),
    [sym_class] = STATE(580),
    [sym_function] = STATE(580),
    [sym_generator_function] = STATE(580),
    [sym_arrow_function] = STATE(580),
    [sym_call_expression] = STATE(580),
    [sym_new_expression] = STATE(403),
    [sym_await_expression] = STATE(403),
    [sym_member_expression] = STATE(317),
    [sym_subscript_expression] = STATE(317),
    [sym_assignment_expression] = STATE(403),
    [sym_augmented_assignment_expression] = STATE(403),
    [sym_ternary_expression] = STATE(403),
    [sym_binary_expression] = STATE(403),
    [sym_unary_expression] = STATE(403),
    [sym_update_expression] = STATE(403),
    [sym_string] = STATE(580),
    [sym_template_string] = STATE(580),
    [sym_regex] = STATE(580),
    [sym_meta_property] = STATE(580),
    [sym_decorator] = STATE(643),
    [sym_formal_parameters] = STATE(1115),
    [aux_sym_export_statement_repeat1] = STATE(828),
    [sym_identifier] = ACTIONS(361),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_import] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(371),
    [anon_sym_async] = ACTIONS(373),
    [anon_sym_function] = ACTIONS(375),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(71),
    [anon_sym_void] = ACTIONS(71),
    [anon_sym_delete] = ACTIONS(71),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(379),
    [anon_sym_get] = ACTIONS(379),
    [anon_sym_set] = ACTIONS(379),
  },
  [188] = {
    [sym_string] = STATE(1045),
    [sym__property_name] = STATE(1045),
    [sym_computed_property_name] = STATE(1045),
    [aux_sym_object_repeat1] = STATE(869),
    [sym_identifier] = ACTIONS(623),
    [anon_sym_STAR] = ACTIONS(592),
    [anon_sym_COMMA] = ACTIONS(584),
    [anon_sym_RBRACE] = ACTIONS(617),
    [anon_sym_LPAREN] = ACTIONS(625),
    [anon_sym_in] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_COLON] = ACTIONS(594),
    [anon_sym_EQ] = ACTIONS(597),
    [anon_sym_LBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(592),
    [anon_sym_DOT] = ACTIONS(601),
    [anon_sym_async] = ACTIONS(623),
    [anon_sym_EQ_GT] = ACTIONS(607),
    [anon_sym_QMARK_DOT] = ACTIONS(609),
    [anon_sym_PLUS_EQ] = ACTIONS(611),
    [anon_sym_DASH_EQ] = ACTIONS(611),
    [anon_sym_STAR_EQ] = ACTIONS(611),
    [anon_sym_SLASH_EQ] = ACTIONS(611),
    [anon_sym_PERCENT_EQ] = ACTIONS(611),
    [anon_sym_CARET_EQ] = ACTIONS(611),
    [anon_sym_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_LT_LT_EQ] = ACTIONS(611),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(611),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(611),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(611),
    [anon_sym_QMARK] = ACTIONS(592),
    [anon_sym_AMP_AMP] = ACTIONS(592),
    [anon_sym_PIPE_PIPE] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(592),
    [anon_sym_GT_GT_GT] = ACTIONS(592),
    [anon_sym_LT_LT] = ACTIONS(592),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(592),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_PERCENT] = ACTIONS(592),
    [anon_sym_STAR_STAR] = ACTIONS(592),
    [anon_sym_LT_EQ] = ACTIONS(584),
    [anon_sym_EQ_EQ] = ACTIONS(592),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(584),
    [anon_sym_BANG_EQ] = ACTIONS(592),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(584),
    [anon_sym_GT_EQ] = ACTIONS(584),
    [anon_sym_QMARK_QMARK] = ACTIONS(592),
    [anon_sym_instanceof] = ACTIONS(592),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(584),
    [sym_number] = ACTIONS(613),
    [anon_sym_static] = ACTIONS(623),
    [anon_sym_get] = ACTIONS(623),
    [anon_sym_set] = ACTIONS(623),
    [sym__automatic_semicolon] = ACTIONS(584),
  },
  [189] = {
    [sym_string] = STATE(1045),
    [sym__property_name] = STATE(1045),
    [sym_computed_property_name] = STATE(1045),
    [aux_sym_object_repeat1] = STATE(869),
    [sym_identifier] = ACTIONS(623),
    [anon_sym_STAR] = ACTIONS(581),
    [anon_sym_COMMA] = ACTIONS(584),
    [anon_sym_RBRACE] = ACTIONS(617),
    [anon_sym_LPAREN] = ACTIONS(625),
    [anon_sym_in] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_COLON] = ACTIONS(594),
    [anon_sym_EQ] = ACTIONS(597),
    [anon_sym_LBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(592),
    [anon_sym_DOT] = ACTIONS(601),
    [anon_sym_async] = ACTIONS(628),
    [anon_sym_EQ_GT] = ACTIONS(607),
    [anon_sym_QMARK_DOT] = ACTIONS(609),
    [anon_sym_PLUS_EQ] = ACTIONS(611),
    [anon_sym_DASH_EQ] = ACTIONS(611),
    [anon_sym_STAR_EQ] = ACTIONS(611),
    [anon_sym_SLASH_EQ] = ACTIONS(611),
    [anon_sym_PERCENT_EQ] = ACTIONS(611),
    [anon_sym_CARET_EQ] = ACTIONS(611),
    [anon_sym_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_LT_LT_EQ] = ACTIONS(611),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(611),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(611),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(611),
    [anon_sym_QMARK] = ACTIONS(592),
    [anon_sym_AMP_AMP] = ACTIONS(592),
    [anon_sym_PIPE_PIPE] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(592),
    [anon_sym_GT_GT_GT] = ACTIONS(592),
    [anon_sym_LT_LT] = ACTIONS(592),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(592),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_PERCENT] = ACTIONS(592),
    [anon_sym_STAR_STAR] = ACTIONS(592),
    [anon_sym_LT_EQ] = ACTIONS(584),
    [anon_sym_EQ_EQ] = ACTIONS(592),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(584),
    [anon_sym_BANG_EQ] = ACTIONS(592),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(584),
    [anon_sym_GT_EQ] = ACTIONS(584),
    [anon_sym_QMARK_QMARK] = ACTIONS(592),
    [anon_sym_instanceof] = ACTIONS(592),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(584),
    [sym_number] = ACTIONS(613),
    [anon_sym_static] = ACTIONS(623),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
    [sym__automatic_semicolon] = ACTIONS(584),
  },
  [190] = {
    [sym_string] = STATE(1045),
    [sym__property_name] = STATE(1045),
    [sym_computed_property_name] = STATE(1045),
    [aux_sym_object_repeat1] = STATE(875),
    [sym_identifier] = ACTIONS(623),
    [anon_sym_STAR] = ACTIONS(581),
    [anon_sym_COMMA] = ACTIONS(584),
    [anon_sym_RBRACE] = ACTIONS(586),
    [anon_sym_LPAREN] = ACTIONS(625),
    [anon_sym_in] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_COLON] = ACTIONS(594),
    [anon_sym_EQ] = ACTIONS(597),
    [anon_sym_LBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(592),
    [anon_sym_DOT] = ACTIONS(601),
    [anon_sym_async] = ACTIONS(628),
    [anon_sym_EQ_GT] = ACTIONS(607),
    [anon_sym_QMARK_DOT] = ACTIONS(609),
    [anon_sym_PLUS_EQ] = ACTIONS(611),
    [anon_sym_DASH_EQ] = ACTIONS(611),
    [anon_sym_STAR_EQ] = ACTIONS(611),
    [anon_sym_SLASH_EQ] = ACTIONS(611),
    [anon_sym_PERCENT_EQ] = ACTIONS(611),
    [anon_sym_CARET_EQ] = ACTIONS(611),
    [anon_sym_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_LT_LT_EQ] = ACTIONS(611),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(611),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(611),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(611),
    [anon_sym_QMARK] = ACTIONS(592),
    [anon_sym_AMP_AMP] = ACTIONS(592),
    [anon_sym_PIPE_PIPE] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(592),
    [anon_sym_GT_GT_GT] = ACTIONS(592),
    [anon_sym_LT_LT] = ACTIONS(592),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(592),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_PERCENT] = ACTIONS(592),
    [anon_sym_STAR_STAR] = ACTIONS(592),
    [anon_sym_LT_EQ] = ACTIONS(584),
    [anon_sym_EQ_EQ] = ACTIONS(592),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(584),
    [anon_sym_BANG_EQ] = ACTIONS(592),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(584),
    [anon_sym_GT_EQ] = ACTIONS(584),
    [anon_sym_QMARK_QMARK] = ACTIONS(592),
    [anon_sym_instanceof] = ACTIONS(592),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(584),
    [sym_number] = ACTIONS(613),
    [anon_sym_static] = ACTIONS(623),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
    [sym__automatic_semicolon] = ACTIONS(584),
  },
  [191] = {
    [sym_string] = STATE(1045),
    [sym__property_name] = STATE(1045),
    [sym_computed_property_name] = STATE(1045),
    [aux_sym_object_repeat1] = STATE(875),
    [sym_identifier] = ACTIONS(623),
    [anon_sym_STAR] = ACTIONS(592),
    [anon_sym_COMMA] = ACTIONS(584),
    [anon_sym_RBRACE] = ACTIONS(586),
    [anon_sym_LPAREN] = ACTIONS(625),
    [anon_sym_in] = ACTIONS(592),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_COLON] = ACTIONS(594),
    [anon_sym_EQ] = ACTIONS(597),
    [anon_sym_LBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(592),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(592),
    [anon_sym_DOT] = ACTIONS(601),
    [anon_sym_async] = ACTIONS(623),
    [anon_sym_EQ_GT] = ACTIONS(607),
    [anon_sym_QMARK_DOT] = ACTIONS(609),
    [anon_sym_PLUS_EQ] = ACTIONS(611),
    [anon_sym_DASH_EQ] = ACTIONS(611),
    [anon_sym_STAR_EQ] = ACTIONS(611),
    [anon_sym_SLASH_EQ] = ACTIONS(611),
    [anon_sym_PERCENT_EQ] = ACTIONS(611),
    [anon_sym_CARET_EQ] = ACTIONS(611),
    [anon_sym_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(611),
    [anon_sym_LT_LT_EQ] = ACTIONS(611),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(611),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(611),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(611),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(611),
    [anon_sym_QMARK] = ACTIONS(592),
    [anon_sym_AMP_AMP] = ACTIONS(592),
    [anon_sym_PIPE_PIPE] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(592),
    [anon_sym_GT_GT_GT] = ACTIONS(592),
    [anon_sym_LT_LT] = ACTIONS(592),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(592),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(592),
    [anon_sym_DASH] = ACTIONS(592),
    [anon_sym_PERCENT] = ACTIONS(592),
    [anon_sym_STAR_STAR] = ACTIONS(592),
    [anon_sym_LT_EQ] = ACTIONS(584),
    [anon_sym_EQ_EQ] = ACTIONS(592),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(584),
    [anon_sym_BANG_EQ] = ACTIONS(592),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(584),
    [anon_sym_GT_EQ] = ACTIONS(584),
    [anon_sym_QMARK_QMARK] = ACTIONS(592),
    [anon_sym_instanceof] = ACTIONS(592),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(584),
    [sym_number] = ACTIONS(613),
    [anon_sym_static] = ACTIONS(623),
    [anon_sym_get] = ACTIONS(623),
    [anon_sym_set] = ACTIONS(623),
    [sym__automatic_semicolon] = ACTIONS(584),
  },
  [192] = {
    [sym_arguments] = STATE(412),
    [sym_formal_parameters] = STATE(1124),
    [sym_identifier] = ACTIONS(632),
    [anon_sym_STAR] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(636),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_RPAREN] = ACTIONS(636),
    [anon_sym_in] = ACTIONS(634),
    [anon_sym_COLON] = ACTIONS(636),
    [anon_sym_EQ] = ACTIONS(638),
    [anon_sym_LBRACK] = ACTIONS(640),
    [anon_sym_RBRACK] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_SLASH] = ACTIONS(634),
    [anon_sym_DOT] = ACTIONS(642),
    [anon_sym_async] = ACTIONS(644),
    [anon_sym_function] = ACTIONS(646),
    [anon_sym_EQ_GT] = ACTIONS(648),
    [anon_sym_QMARK_DOT] = ACTIONS(650),
    [anon_sym_PLUS_EQ] = ACTIONS(652),
    [anon_sym_DASH_EQ] = ACTIONS(652),
    [anon_sym_STAR_EQ] = ACTIONS(652),
    [anon_sym_SLASH_EQ] = ACTIONS(652),
    [anon_sym_PERCENT_EQ] = ACTIONS(652),
    [anon_sym_CARET_EQ] = ACTIONS(652),
    [anon_sym_AMP_EQ] = ACTIONS(652),
    [anon_sym_PIPE_EQ] = ACTIONS(652),
    [anon_sym_GT_GT_EQ] = ACTIONS(652),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(652),
    [anon_sym_LT_LT_EQ] = ACTIONS(652),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(652),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(652),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(652),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(652),
    [anon_sym_QMARK] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(634),
    [anon_sym_PIPE_PIPE] = ACTIONS(634),
    [anon_sym_GT_GT] = ACTIONS(634),
    [anon_sym_GT_GT_GT] = ACTIONS(634),
    [anon_sym_LT_LT] = ACTIONS(634),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_CARET] = ACTIONS(634),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_PLUS] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_PERCENT] = ACTIONS(634),
    [anon_sym_STAR_STAR] = ACTIONS(634),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(634),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(634),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [anon_sym_QMARK_QMARK] = ACTIONS(634),
    [anon_sym_instanceof] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(636),
    [anon_sym_DASH_DASH] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(636),
    [anon_sym_static] = ACTIONS(644),
    [anon_sym_get] = ACTIONS(644),
    [anon_sym_set] = ACTIONS(644),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(638), 1,
      anon_sym_EQ,
    ACTIONS(640), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(646), 1,
      anon_sym_function,
    ACTIONS(648), 1,
      anon_sym_EQ_GT,
    ACTIONS(650), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    STATE(1124), 1,
      sym_formal_parameters,
    ACTIONS(644), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(584), 13,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [93] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 1,
      sym__automatic_semicolon,
    ACTIONS(381), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(383), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [166] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 1,
      sym__automatic_semicolon,
    ACTIONS(481), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(483), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [239] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(638), 1,
      anon_sym_EQ,
    ACTIONS(659), 1,
      sym_identifier,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(667), 1,
      anon_sym_function,
    STATE(519), 1,
      sym_arguments,
    STATE(1167), 1,
      sym_formal_parameters,
    ACTIONS(665), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(636), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(634), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(483), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [401] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 18,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(489), 44,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_catch,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [471] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_catch,
    ACTIONS(675), 1,
      anon_sym_finally,
    STATE(205), 1,
      sym_catch_clause,
    STATE(234), 1,
      sym_finally_clause,
    ACTIONS(669), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(671), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [549] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    ACTIONS(659), 1,
      sym_identifier,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(677), 1,
      anon_sym_COLON,
    ACTIONS(679), 1,
      anon_sym_EQ,
    ACTIONS(681), 1,
      anon_sym_function,
    STATE(1167), 1,
      sym_formal_parameters,
    ACTIONS(665), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(584), 10,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(611), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [642] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    ACTIONS(659), 1,
      sym_identifier,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(667), 1,
      anon_sym_function,
    ACTIONS(679), 1,
      anon_sym_EQ,
    ACTIONS(683), 1,
      anon_sym_in,
    ACTIONS(686), 1,
      anon_sym_of,
    STATE(1167), 1,
      sym_formal_parameters,
    ACTIONS(665), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(584), 10,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(611), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [737] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    ACTIONS(659), 1,
      sym_identifier,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(667), 1,
      anon_sym_function,
    ACTIONS(679), 1,
      anon_sym_EQ,
    STATE(1167), 1,
      sym_formal_parameters,
    ACTIONS(665), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(584), 11,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(611), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [828] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_function,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    ACTIONS(659), 1,
      sym_identifier,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(679), 1,
      anon_sym_EQ,
    ACTIONS(688), 1,
      anon_sym_COLON,
    STATE(1167), 1,
      sym_formal_parameters,
    ACTIONS(665), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(584), 10,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(611), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [921] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(640), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(646), 1,
      anon_sym_function,
    ACTIONS(648), 1,
      anon_sym_EQ_GT,
    ACTIONS(650), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    ACTIONS(690), 1,
      anon_sym_COMMA,
    ACTIONS(693), 1,
      anon_sym_RPAREN,
    ACTIONS(696), 1,
      anon_sym_EQ,
    STATE(886), 1,
      aux_sym_formal_parameters_repeat1,
    STATE(1124), 1,
      sym_formal_parameters,
    ACTIONS(644), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(584), 7,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [1017] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(675), 1,
      anon_sym_finally,
    STATE(248), 1,
      sym_finally_clause,
    ACTIONS(698), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(700), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(704), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(469), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(706), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(708), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1290] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(710), 1,
      sym__automatic_semicolon,
    ACTIONS(381), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(383), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(483), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1426] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(443), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(445), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1493] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 1,
      sym__automatic_semicolon,
    ACTIONS(457), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(459), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1562] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 1,
      sym__automatic_semicolon,
    ACTIONS(393), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(395), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1631] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 1,
      sym__automatic_semicolon,
    ACTIONS(471), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(473), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 17,
      sym__automatic_semicolon,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(489), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(714), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1834] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(718), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1901] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 1,
      sym__automatic_semicolon,
    ACTIONS(403), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(405), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [1970] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 1,
      sym__automatic_semicolon,
    ACTIONS(433), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(435), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2039] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      sym__automatic_semicolon,
    ACTIONS(447), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(449), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2108] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(720), 17,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(722), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2175] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(431), 1,
      sym__automatic_semicolon,
    ACTIONS(423), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(425), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2244] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 1,
      sym__automatic_semicolon,
    ACTIONS(413), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(415), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2313] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      sym__automatic_semicolon,
    ACTIONS(481), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(483), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2382] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(728), 43,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_finally,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2449] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(732), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2515] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(736), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2581] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(740), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2647] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(744), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2713] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(748), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2779] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(638), 1,
      anon_sym_EQ,
    ACTIONS(640), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(646), 1,
      anon_sym_function,
    ACTIONS(648), 1,
      anon_sym_EQ_GT,
    ACTIONS(650), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    ACTIONS(683), 1,
      anon_sym_in,
    ACTIONS(686), 1,
      anon_sym_of,
    STATE(1124), 1,
      sym_formal_parameters,
    ACTIONS(644), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(584), 7,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [2871] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(752), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [2937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(756), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3003] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(760), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3069] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(764), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(768), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3201] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(770), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(772), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3267] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(776), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(780), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(782), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(784), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3465] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(788), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3531] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(792), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3597] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(796), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3663] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(800), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(804), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3795] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(808), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3861] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(812), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3927] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(816), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [3993] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(820), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(824), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4125] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(828), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(832), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(836), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4323] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(840), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(844), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(848), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(852), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(856), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(860), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4719] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(864), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(868), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [4851] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 1,
      sym_identifier,
    ACTIONS(638), 1,
      anon_sym_EQ,
    ACTIONS(640), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(646), 1,
      anon_sym_function,
    ACTIONS(648), 1,
      anon_sym_EQ_GT,
    ACTIONS(650), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(654), 1,
      anon_sym_LPAREN,
    ACTIONS(870), 1,
      anon_sym_in,
    ACTIONS(873), 1,
      anon_sym_of,
    STATE(1124), 1,
      sym_formal_parameters,
    ACTIONS(644), 4,
      anon_sym_async,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(584), 7,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 21,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [4943] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(877), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5009] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(881), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5075] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(885), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5141] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(889), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5207] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(891), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(893), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5273] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(895), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(897), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(901), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5405] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(907), 1,
      anon_sym_else,
    ACTIONS(903), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(905), 41,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(911), 42,
      anon_sym_export,
      anon_sym_default,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_case,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [5539] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(925), 1,
      anon_sym_EQ_GT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    STATE(411), 1,
      sym_arguments,
    ACTIONS(915), 14,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(913), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5620] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      anon_sym_EQ,
    ACTIONS(640), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(648), 1,
      anon_sym_EQ_GT,
    ACTIONS(650), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    STATE(412), 1,
      sym_arguments,
    ACTIONS(636), 14,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(634), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(931), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(933), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [5765] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 1,
      anon_sym_COLON,
    ACTIONS(617), 1,
      anon_sym_RBRACE,
    ACTIONS(939), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_EQ,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(948), 1,
      anon_sym_EQ_GT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    STATE(869), 1,
      aux_sym_object_repeat1,
    ACTIONS(937), 11,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(952), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [5849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(956), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [5913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(958), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(960), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [5977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(964), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(968), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6105] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    STATE(411), 1,
      sym_arguments,
    ACTIONS(915), 14,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(913), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6183] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(972), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6247] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(586), 1,
      anon_sym_RBRACE,
    ACTIONS(594), 1,
      anon_sym_COLON,
    ACTIONS(939), 1,
      anon_sym_LPAREN,
    ACTIONS(942), 1,
      anon_sym_EQ,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(948), 1,
      anon_sym_EQ_GT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    STATE(875), 1,
      aux_sym_object_repeat1,
    ACTIONS(937), 11,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(952), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6331] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(976), 34,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6395] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(925), 1,
      anon_sym_EQ_GT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(937), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6471] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      anon_sym_EQ,
    ACTIONS(640), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(648), 1,
      anon_sym_EQ_GT,
    ACTIONS(650), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(584), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6547] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(925), 1,
      anon_sym_EQ_GT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(980), 1,
      anon_sym_in,
    ACTIONS(983), 1,
      anon_sym_of,
    ACTIONS(985), 1,
      anon_sym_EQ,
    STATE(881), 1,
      sym__initializer,
    ACTIONS(978), 3,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_SEMI,
    ACTIONS(937), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6630] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(937), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6703] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(948), 1,
      anon_sym_EQ_GT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(987), 1,
      anon_sym_LPAREN,
    STATE(542), 1,
      sym_arguments,
    ACTIONS(915), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(913), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6782] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(638), 1,
      anon_sym_EQ,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(987), 1,
      anon_sym_LPAREN,
    STATE(519), 1,
      sym_arguments,
    ACTIONS(636), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(634), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6861] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(679), 1,
      anon_sym_EQ,
    ACTIONS(584), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(611), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [6935] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(931), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(933), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [6997] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(679), 1,
      anon_sym_EQ,
    ACTIONS(683), 1,
      anon_sym_in,
    ACTIONS(989), 1,
      anon_sym_of,
    ACTIONS(584), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(611), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7075] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(958), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(960), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7137] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      anon_sym_COLON,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(948), 1,
      anon_sym_EQ_GT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(991), 1,
      anon_sym_EQ,
    ACTIONS(937), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(952), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7213] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(956), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7275] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(962), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(964), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7337] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(966), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(968), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7399] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(948), 1,
      anon_sym_EQ_GT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(991), 1,
      anon_sym_EQ,
    ACTIONS(937), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(952), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(974), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(976), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7535] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(948), 1,
      anon_sym_EQ_GT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(991), 1,
      anon_sym_EQ,
    ACTIONS(993), 1,
      anon_sym_in,
    ACTIONS(996), 1,
      anon_sym_of,
    ACTIONS(937), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(952), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7613] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(987), 1,
      anon_sym_LPAREN,
    STATE(542), 1,
      sym_arguments,
    ACTIONS(915), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(913), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7689] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_COLON,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(948), 1,
      anon_sym_EQ_GT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(991), 1,
      anon_sym_EQ,
    ACTIONS(937), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(952), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7765] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(679), 1,
      anon_sym_EQ,
    ACTIONS(688), 1,
      anon_sym_COLON,
    ACTIONS(584), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(611), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7841] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(607), 1,
      anon_sym_EQ_GT,
    ACTIONS(609), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(661), 1,
      anon_sym_LBRACK,
    ACTIONS(663), 1,
      anon_sym_DOT,
    ACTIONS(677), 1,
      anon_sym_COLON,
    ACTIONS(679), 1,
      anon_sym_EQ,
    ACTIONS(584), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(611), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [7917] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(970), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(972), 32,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_of,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [7979] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(998), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8040] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1002), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(933), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(931), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8162] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1006), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1010), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8284] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1014), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8345] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1018), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8406] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(648), 1,
      anon_sym_EQ_GT,
    ACTIONS(650), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(690), 1,
      anon_sym_COMMA,
    ACTIONS(693), 1,
      anon_sym_RPAREN,
    ACTIONS(696), 1,
      anon_sym_EQ,
    STATE(886), 1,
      aux_sym_formal_parameters_repeat1,
    ACTIONS(584), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1022), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8546] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(925), 1,
      anon_sym_EQ_GT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1026), 1,
      anon_sym_COMMA,
    ACTIONS(1029), 1,
      anon_sym_RPAREN,
    ACTIONS(1032), 1,
      anon_sym_EQ,
    STATE(895), 1,
      aux_sym_formal_parameters_repeat1,
    ACTIONS(937), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8625] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 14,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
    ACTIONS(1034), 39,
      anon_sym_export,
      anon_sym_import,
      anon_sym_var,
      anon_sym_let,
      anon_sym_const,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_await,
      anon_sym_while,
      anon_sym_do,
      anon_sym_try,
      anon_sym_with,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_debugger,
      anon_sym_return,
      anon_sym_throw,
      anon_sym_yield,
      anon_sym_SLASH,
      anon_sym_class,
      anon_sym_async,
      anon_sym_function,
      anon_sym_new,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_typeof,
      anon_sym_void,
      anon_sym_delete,
      sym_identifier,
      sym_this,
      sym_super,
      sym_true,
      sym_false,
      sym_null,
      sym_undefined,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
  [8686] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(991), 1,
      anon_sym_EQ,
    ACTIONS(937), 13,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(952), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8757] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(944), 1,
      anon_sym_LBRACK,
    ACTIONS(946), 1,
      anon_sym_DOT,
    ACTIONS(950), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(991), 1,
      anon_sym_EQ,
    ACTIONS(993), 1,
      anon_sym_in,
    ACTIONS(996), 1,
      anon_sym_of,
    ACTIONS(937), 12,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(952), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8832] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(954), 22,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
    ACTIONS(956), 30,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [8892] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(925), 1,
      anon_sym_EQ_GT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1038), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(937), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 21,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [8966] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      anon_sym_EQ,
    ACTIONS(640), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(648), 1,
      anon_sym_EQ_GT,
    ACTIONS(650), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(683), 1,
      anon_sym_in,
    ACTIONS(989), 1,
      anon_sym_of,
    ACTIONS(584), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [9041] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(925), 1,
      anon_sym_EQ_GT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(980), 1,
      anon_sym_in,
    ACTIONS(983), 1,
      anon_sym_of,
    ACTIONS(937), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [9116] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 1,
      anon_sym_EQ,
    ACTIONS(640), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_DOT,
    ACTIONS(648), 1,
      anon_sym_EQ_GT,
    ACTIONS(650), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(870), 1,
      anon_sym_in,
    ACTIONS(1041), 1,
      anon_sym_of,
    ACTIONS(584), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(652), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(592), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [9191] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(925), 1,
      anon_sym_EQ_GT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(993), 1,
      anon_sym_in,
    ACTIONS(996), 1,
      anon_sym_of,
    ACTIONS(937), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [9266] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1043), 22,
      anon_sym_export,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_class,
      anon_sym_async,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1045), 28,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
  [9324] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(980), 1,
      anon_sym_in,
    ACTIONS(983), 1,
      anon_sym_of,
    ACTIONS(937), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [9396] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_EQ,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(993), 1,
      anon_sym_in,
    ACTIONS(996), 1,
      anon_sym_of,
    ACTIONS(937), 9,
      anon_sym_LPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
    ACTIONS(929), 15,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_AMP_AMP_EQ,
      anon_sym_PIPE_PIPE_EQ,
      anon_sym_QMARK_QMARK_EQ,
    ACTIONS(935), 20,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK_QMARK,
  [9468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 22,
      anon_sym_export,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_class,
      anon_sym_async,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1049), 28,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
  [9526] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 22,
      anon_sym_export,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
      anon_sym_class,
      anon_sym_async,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
      sym_identifier,
      anon_sym_static,
      anon_sym_get,
      anon_sym_set,
    ACTIONS(1053), 28,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      sym_number,
      anon_sym_AT,
  [9584] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(1055), 1,
      sym_identifier,
    ACTIONS(1057), 1,
      anon_sym_STAR,
    ACTIONS(1059), 1,
      anon_sym_LBRACE,
    STATE(929), 1,
      sym_import_clause,
    STATE(1007), 1,
      sym_string,
    STATE(1142), 2,
      sym_namespace_import,
      sym_named_imports,
    ACTIONS(1063), 13,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_instanceof,
    ACTIONS(1061), 22,
      sym__automatic_semicolon,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9652] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1067), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9737] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1095), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1097), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9786] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1101), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9835] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1105), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [9884] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1107), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [9969] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(387), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10018] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1109), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10103] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1111), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1113), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [10166] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1117), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10215] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1119), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1121), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1123), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10349] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1111), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1113), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [10412] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1125), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10497] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1127), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10582] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1111), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1113), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [10645] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1129), 1,
      anon_sym_EQ,
    STATE(411), 1,
      sym_arguments,
    ACTIONS(913), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(915), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10706] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1133), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10755] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 14,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1137), 27,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_of,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10804] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1139), 1,
      anon_sym_EQ,
    STATE(411), 1,
      sym_arguments,
    ACTIONS(913), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(915), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [10865] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1141), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [10950] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1143), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11035] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1145), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11120] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1147), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11205] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1149), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11290] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 1,
      anon_sym_EQ,
    ACTIONS(1151), 1,
      sym__automatic_semicolon,
    ACTIONS(383), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(381), 26,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_QMARK_DOT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BQUOTE,
  [11343] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1153), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11428] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1157), 1,
      anon_sym_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1155), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_QMARK_QMARK,
  [11511] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1157), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1155), 19,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11574] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1157), 10,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_QMARK,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1155), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11643] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1159), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11728] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    ACTIONS(1157), 2,
      anon_sym_QMARK,
      anon_sym_PIPE,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1155), 9,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_QMARK_QMARK,
  [11807] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1157), 3,
      anon_sym_QMARK,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1155), 10,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_QMARK_QMARK,
  [11882] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1157), 8,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_QMARK,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1155), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [11953] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1161), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [12038] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1163), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [12123] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1157), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1155), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
  [12188] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1073), 1,
      anon_sym_QMARK,
    ACTIONS(1075), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1081), 1,
      anon_sym_AMP,
    ACTIONS(1083), 1,
      anon_sym_PIPE,
    ACTIONS(1087), 1,
      anon_sym_STAR_STAR,
    ACTIONS(1091), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(1077), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(1085), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1093), 2,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1065), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_GT_GT,
    ACTIONS(1079), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(1069), 5,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1089), 5,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_instanceof,
    ACTIONS(1165), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [12273] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 1,
      anon_sym_BQUOTE,
    ACTIONS(917), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(1071), 1,
      anon_sym_QMARK_DOT,
    STATE(379), 2,
      sym_template_string,
      sym_arguments,
    ACTIONS(1167), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1169), 21,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK_QMARK,
      anon_sym_instanceof,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [12334] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(923), 1,
      anon_sym_DOT,
    ACTIONS(927), 1,
      anon_sym_QMARK_DOT,
    ACTIONS(1139), 1,
      anon_sym_EQ,
    ACTIONS(935), 13,
      anon_sym_STAR,
      anon_sym_in,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_QMARK,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(937), 23,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
  