use std::process::Command;

macro_rules! cli_test {
    ($name:ident, $args:expr, $expected_out:expr) => {
        #[test]
        fn $name() {
            let mut split = $args.split(" ");
            let command = split.next().unwrap();
            let mut rest: Vec<&str> = split.collect();

            let mut args = vec!["run", "--bin", command, "--"];
            args.append(&mut rest);

            println!("args: cargo {:?}", args);
            let output = Command::new("cargo").args(&args).output().unwrap();
            assert!(output.status.success());
            assert_eq!(String::from_utf8_lossy(&output.stdout), $expected_out);
        }
    };
}

cli_test!(
    task_add_help,
    "task add --help",
    "Usage: task-add [options] [<title>...]

Add or import tasks into the list.

Options:
   -h, --help                            Print this usage information
   -p <priority>, --priority <priority>  Create the task with the indicated
                                         priority, this can be an integer or
                                         float [default: 1]
   -b <body>, --body <body>              The body or \"description\" of the task
   -c <context>, --context <context>     The context in which to create the task [default: default]
   -t, --top                             Make this task the top priority

Import Options:
   -f <file>, --from-file <file>  Import tasks from the indicated JSON file

If an import option is provided all other options are ignored.
"
);
