// Copyright 2018 Mathew Robinson <chasinglogic@gmail.com>. All rights reserved. Use of this source code is
// governed by the Apache-2.0 license that can be found in the LICENSE file.

use tabwriter::TabWriter;
use taskforge::task::Task;

use std::io;
use std::io::Write;

const DATE_FORMAT: &str = "%Y-%m-%d %I:%M %p";

pub fn print_table(rows: &[Task]) {
    let mut tw = TabWriter::new(io::stdout()).padding(1);

    write!(
        &mut tw,
        "| ID\t| Created Date\t| Completed Date\t| Priority\t| Title\t| Context\t|"
    );

    write!(
        &mut tw,
        "\n| --\t| ------------\t| --------------\t| --------\t| -----\t| -------\t|",
    );

    for task in rows.iter() {
        write!(
            &mut tw,
            "\n| {}\t| {}\t| {}\t| {}\t| {}\t| {}\t|",
            task.id,
            task.created_date.format(DATE_FORMAT),
            task.completed_date
                .map(|dt| format!("{}", dt.format(DATE_FORMAT)))
                .unwrap_or_else(|| "None".to_string()),
            task.priority,
            task.title,
            task.context,
        );
    }

    writeln!(&mut tw);
    tw.flush().expect("Unable to print to stdout");
}
