// Copyright 2018 Mathew Robinson <chasinglogic@gmail.com>. All rights reserved. Use of this source code is
// governed by the Apache-2.0 license that can be found in the LICENSE file.


use std::path::PathBuf;
use std::process::exit;
use taskforge::list::SQLiteList;

#[derive(Deserialize, Clone)]
pub struct SqliteConfig {
    pub filename: PathBuf,
    pub create_tables: Option<bool>,
}

impl SqliteConfig {
    pub fn list(mut self) -> Box<SQLiteList> {
        if !self.filename.exists() {
            self.create_tables = Some(true);
        }

        let mut list = SQLiteList::new(&self.filename);
        if self.create_tables.is_some() && self.create_tables.unwrap() {
            if let Err(e) = list.create_tables() {
                println!("Unable to create tables in SQLite: {}", e);
                exit(1);
            }
        }

        Box::new(list)
    }
}
