// Copyright 2018 Mathew Robinson <chasinglogic@gmail.com>. All rights reserved. Use of this source code is
// governed by the Apache-2.0 license that can be found in the LICENSE file.


use configs::sqlite::SqliteConfig;
use std::fs;
use std::path::PathBuf;
use std::process::exit;
use taskforge::list::List;

#[derive(Deserialize, Clone)]
pub enum Lists {
    SQLite(SqliteConfig),
}

#[derive(Deserialize)]
pub struct Config {
    list: Lists,
}

pub fn data_dir() -> PathBuf {
    let mut app_data_dir = dirs::data_dir().unwrap_or_else(|| PathBuf::from(""));
    app_data_dir.push("taskforge.d");

    if !app_data_dir.exists() {
        if let Err(e) = fs::create_dir_all(app_data_dir.clone()) {
            println!(
                "Unable to create app data directory {}: {}",
                app_data_dir.to_str().unwrap(),
                e
            );
            exit(1);
        }
    }

    app_data_dir
}

pub fn config_dir() -> PathBuf {
    let mut app_config_dir = dirs::config_dir().unwrap_or_else(|| PathBuf::from(""));
    app_config_dir.push("taskforge.d");

    if !app_config_dir.exists() {
        if let Err(e) = fs::create_dir_all(app_config_dir.clone()) {
            println!(
                "Unable to create app config directory {}: {}",
                app_config_dir.to_str().unwrap(),
                e
            );
            exit(1);
        }
    }

    app_config_dir
}

fn default_sqlite_file() -> PathBuf {
    let mut sqlite_file = data_dir();
    sqlite_file.push("tasks.sqlite");
    sqlite_file
}

impl Config {
    pub fn load() -> Config {
        let mut config_file = config_dir();
        config_file.push("config.toml");

        // TODO: Add config file loading here.
        // if !config_file.exists() {
        Config::default()
        // }
    }

    pub fn default() -> Config {
        Config {
            list: Lists::SQLite(SqliteConfig {
                filename: default_sqlite_file(),
                create_tables: None,
            }),
        }
    }

    pub fn list(&self) -> Box<List> {
        match self.list.clone() {
            Lists::SQLite(s) => s.list(),
        }
    }
}
