var N = null;var searchIndex = {};
searchIndex["sysctl"]={"doc":"A simplified interface to the `sysctl` system call.","items":[[3,"CtlFlags","sysctl","",N,N],[3,"CtlInfo","","A structure representing control metadata",N,N],[12,"ctl_type","","The control type.",0,N],[12,"fmt","","A string which specifies the format of the OID in a symbolic way.",0,N],[3,"Ctl","","This struct represents a system control.",N,N],[12,"oid","","",1,N],[3,"CtlIter","","An iterator over Sysctl entries.",N,N],[4,"CtlType","","An Enum that represents a sysctl's type information.",N,N],[13,"Node","","",2,N],[13,"Int","","",2,N],[13,"String","","",2,N],[13,"S64","","",2,N],[13,"Struct","","",2,N],[13,"Uint","","",2,N],[13,"Long","","",2,N],[13,"Ulong","","",2,N],[13,"U64","","",2,N],[13,"U8","","",2,N],[13,"U16","","",2,N],[13,"S8","","",2,N],[13,"S16","","",2,N],[13,"S32","","",2,N],[13,"U32","","",2,N],[13,"None","","",2,N],[4,"CtlValue","","An Enum that holds all values returned by sysctl calls. Extract inner value with `if let` or `match`.",N,N],[13,"None","","",3,N],[13,"Node","","",3,N],[13,"Int","","",3,N],[13,"String","","",3,N],[13,"S64","","",3,N],[13,"Struct","","",3,N],[13,"Uint","","",3,N],[13,"Long","","",3,N],[13,"Ulong","","",3,N],[13,"U64","","",3,N],[13,"U8","","",3,N],[13,"U16","","",3,N],[13,"S8","","",3,N],[13,"S16","","",3,N],[13,"S32","","",3,N],[13,"U32","","",3,N],[4,"SysctlError","","",N,N],[13,"NotFound","","",4,N],[13,"ExtractionError","","",4,N],[13,"IoError","","",4,N],[13,"Utf8Error","","",4,N],[13,"NoReadAccess","","",4,N],[13,"NoWriteAccess","","",4,N],[13,"ShortRead","","",4,N],[12,"read","sysctl::SysctlError","",4,N],[12,"reported","","",4,N],[13,"InvalidCStr","sysctl","",4,N],[5,"value","","Takes the name of the OID as argument and returns a result containing the sysctl value if success, or a SysctlError on failure",N,[[["str"]],["result",["ctlvalue","sysctlerror"]]]],[5,"value_oid","","Takes an OID as argument and returns a result containing the sysctl value if success, or a SysctlError on failure",N,[[["vec"]],["result",["ctlvalue","sysctlerror"]]]],[5,"value_as","","A generic function that takes a string as argument and returns a result containing the sysctl value if success, or a SysctlError on failure.",N,[[["str"]],["result",["box","sysctlerror"]]]],[5,"value_oid_as","","A generic function that takes an OID as argument and returns a result containing the sysctl value if success, or a SysctlError on failure",N,[[["vec"]],["result",["box","sysctlerror"]]]],[5,"set_value","","Sets the value of a sysctl. Fetches and returns the new value if successful, or a SysctlError on failure",N,[[["str"],["ctlvalue"]],["result",["ctlvalue","sysctlerror"]]]],[5,"set_oid_value","","",N,[[["vec"],["ctlvalue"]],["result",["ctlvalue","sysctlerror"]]]],[5,"next_oid","","Get the next OID.",N,[[["vec"]],["result",["option","sysctlerror"]]]],[17,"CTL_MAXNAME","","",N,N],[17,"CTLTYPE","","",N,N],[17,"CTLTYPE_NODE","","",N,N],[17,"CTLTYPE_INT","","",N,N],[17,"CTLTYPE_STRING","","",N,N],[17,"CTLTYPE_S64","","",N,N],[17,"CTLTYPE_OPAQUE","","",N,N],[17,"CTLTYPE_STRUCT","","",N,N],[17,"CTLTYPE_UINT","","",N,N],[17,"CTLTYPE_LONG","","",N,N],[17,"CTLTYPE_ULONG","","",N,N],[17,"CTLTYPE_U64","","",N,N],[17,"CTLTYPE_U8","","",N,N],[17,"CTLTYPE_U16","","",N,N],[17,"CTLTYPE_S8","","",N,N],[17,"CTLTYPE_S16","","",N,N],[17,"CTLTYPE_S32","","",N,N],[17,"CTLTYPE_U32","","",N,N],[17,"CTLFLAG_RD","","",N,N],[17,"CTLFLAG_WR","","",N,N],[17,"CTLFLAG_RW","","",N,N],[17,"CTLFLAG_DORMANT","","",N,N],[17,"CTLFLAG_ANYBODY","","",N,N],[17,"CTLFLAG_SECURE","","",N,N],[17,"CTLFLAG_PRISON","","",N,N],[17,"CTLFLAG_DYN","","",N,N],[17,"CTLFLAG_SKIP","","",N,N],[17,"CTLFLAG_TUN","","",N,N],[17,"CTLFLAG_RDTUN","","",N,N],[17,"CTLFLAG_RWTUN","","",N,N],[17,"CTLFLAG_MPSAFE","","",N,N],[17,"CTLFLAG_VNET","","",N,N],[17,"CTLFLAG_DYING","","",N,N],[17,"CTLFLAG_CAPRD","","",N,N],[17,"CTLFLAG_CAPWR","","",N,N],[17,"CTLFLAG_STATS","","",N,N],[17,"CTLFLAG_NOFETCH","","",N,N],[17,"CTLFLAG_CAPRW","","",N,N],[17,"CTLFLAG_SECURE1","","",N,N],[17,"CTLFLAG_SECURE2","","",N,N],[17,"CTLFLAG_SECURE3","","",N,N],[17,"CTLMASK_SECURE","","",N,N],[17,"CTLSHIFT_SECURE","","",N,N],[18,"RD","","Allow reads of variable",5,N],[18,"WR","","Allow writes to the variable",5,N],[18,"RW","","",5,N],[18,"DORMANT","","This sysctl is not active yet",5,N],[18,"ANYBODY","","All users can set this var",5,N],[18,"SECURE","","Permit set only if securelevel<=0",5,N],[18,"PRISON","","Prisoned roots can fiddle",5,N],[18,"DYN","","Dynamic oid - can be freed",5,N],[18,"SKIP","","Skip this sysctl when listing",5,N],[18,"SECURE_MASK","","Secure level",5,N],[18,"TUN","","Default value is loaded from getenv()",5,N],[18,"RDTUN","","Readable tunable",5,N],[18,"RWTUN","","Readable and writeable tunable",5,N],[18,"MPSAFE","","Handler is MP safe",5,N],[18,"VNET","","Prisons with vnet can fiddle",5,N],[18,"DYING","","Oid is being removed",5,N],[18,"CAPRD","","Can be read in capability mode",5,N],[18,"CAPWR","","Can be written in capability mode",5,N],[18,"STATS","","Statistics; not a tuneable",5,N],[18,"NOFETCH","","Don't fetch tunable from getenv()",5,N],[18,"CAPRW","","Can be read and written in capability mode",5,N],[11,"empty","","Returns an empty set of flags.",5,[[],["ctlflags"]]],[11,"all","","Returns the set containing all flags.",5,[[],["ctlflags"]]],[11,"bits","","Returns the raw value of the flags currently stored.",5,[[["self"]],["c_uint"]]],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",5,[[["c_uint"]],["option",["ctlflags"]]]],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",5,[[["c_uint"]],["ctlflags"]]],[11,"is_empty","","Returns `true` if no flags are currently stored.",5,[[["self"]],["bool"]]],[11,"is_all","","Returns `true` if all flags are currently set.",5,[[["self"]],["bool"]]],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",5,[[["self"],["ctlflags"]],["bool"]]],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",5,[[["self"],["ctlflags"]],["bool"]]],[11,"insert","","Inserts the specified flags in-place.",5,[[["self"],["ctlflags"]]]],[11,"remove","","Removes the specified flags in-place.",5,[[["self"],["ctlflags"]]]],[11,"toggle","","Toggles the specified flags in-place.",5,[[["self"],["ctlflags"]]]],[11,"set","","Inserts or removes the specified flags depending on the passed value.",5,[[["self"],["ctlflags"],["bool"]]]],[11,"flags","","Return the flags for this sysctl.",0,[[["self"]],["ctlflags"]]],[11,"struct_type","","If the sysctl is a structure, return the structure type string.",0,[[["self"]],["option",["string"]]]],[11,"new","","Construct a Ctl from the name.",1,[[["str"]],["result",["sysctlerror"]]]],[11,"name","","Returns a result containing the sysctl name on success, or a SysctlError on failure.",1,[[["self"]],["result",["string","sysctlerror"]]]],[11,"value_type","","Returns a result containing the sysctl value type on success, or a Sysctl Error on failure.",1,[[["self"]],["result",["ctltype","sysctlerror"]]]],[11,"value","","Returns a result containing the sysctl value on success, or a SysctlError on failure.",1,[[["self"]],["result",["ctlvalue","sysctlerror"]]]],[11,"value_as","","A generic method that takes returns a result containing the sysctl value if success, or a SysctlError on failure.",1,[[["self"]],["result",["box","sysctlerror"]]]],[11,"set_value","","Sets the value of a sysctl. Fetches and returns the new value if successful, or returns a SysctlError on failure. # Example ```ignore extern crate sysctl; use sysctl::Ctl;",1,[[["self"],["ctlvalue"]],["result",["ctlvalue","sysctlerror"]]]],[11,"flags","","Get the flags for a sysctl.",1,[[["self"]],["result",["ctlflags","sysctlerror"]]]],[11,"info","","Returns a Result containing the control metadata for a sysctl.",1,[[["self"]],["result",["ctlinfo","sysctlerror"]]]],[11,"root","","Return an iterator over the complete sysctl tree.",6,[[],["self"]]],[11,"below","","Return an iterator over all sysctl entries below the given node.",6,[[["ctl"]],["self"]]],[11,"to_owned","","",5,[[["self"]],["t"]]],[11,"clone_into","","",5,N],[11,"from","","",5,[[["t"]],["t"]]],[11,"into","","",5,[[["self"]],["u"]]],[11,"try_from","","",5,[[["u"]],["result"]]],[11,"borrow","","",5,[[["self"]],["t"]]],[11,"borrow_mut","","",5,[[["self"]],["t"]]],[11,"try_into","","",5,[[["self"]],["result"]]],[11,"get_type_id","","",5,[[["self"]],["typeid"]]],[11,"from","","",0,[[["t"]],["t"]]],[11,"into","","",0,[[["self"]],["u"]]],[11,"try_from","","",0,[[["u"]],["result"]]],[11,"borrow","","",0,[[["self"]],["t"]]],[11,"borrow_mut","","",0,[[["self"]],["t"]]],[11,"try_into","","",0,[[["self"]],["result"]]],[11,"get_type_id","","",0,[[["self"]],["typeid"]]],[11,"to_owned","","",1,[[["self"]],["t"]]],[11,"clone_into","","",1,N],[11,"from","","",1,[[["t"]],["t"]]],[11,"into_iter","","",1,[[["self"]],["i"]]],[11,"into","","",1,[[["self"]],["u"]]],[11,"try_from","","",1,[[["u"]],["result"]]],[11,"borrow","","",1,[[["self"]],["t"]]],[11,"borrow_mut","","",1,[[["self"]],["t"]]],[11,"try_into","","",1,[[["self"]],["result"]]],[11,"get_type_id","","",1,[[["self"]],["typeid"]]],[11,"from","","",6,[[["t"]],["t"]]],[11,"into_iter","","",6,[[["self"]],["i"]]],[11,"into","","",6,[[["self"]],["u"]]],[11,"try_from","","",6,[[["u"]],["result"]]],[11,"borrow","","",6,[[["self"]],["t"]]],[11,"borrow_mut","","",6,[[["self"]],["t"]]],[11,"try_into","","",6,[[["self"]],["result"]]],[11,"get_type_id","","",6,[[["self"]],["typeid"]]],[11,"to_owned","","",2,[[["self"]],["t"]]],[11,"clone_into","","",2,N],[11,"from","","",2,[[["t"]],["t"]]],[11,"into","","",2,[[["self"]],["u"]]],[11,"try_from","","",2,[[["u"]],["result"]]],[11,"borrow","","",2,[[["self"]],["t"]]],[11,"borrow_mut","","",2,[[["self"]],["t"]]],[11,"try_into","","",2,[[["self"]],["result"]]],[11,"get_type_id","","",2,[[["self"]],["typeid"]]],[11,"from","","",3,[[["t"]],["t"]]],[11,"into","","",3,[[["self"]],["u"]]],[11,"try_from","","",3,[[["u"]],["result"]]],[11,"borrow","","",3,[[["self"]],["t"]]],[11,"borrow_mut","","",3,[[["self"]],["t"]]],[11,"try_into","","",3,[[["self"]],["result"]]],[11,"get_type_id","","",3,[[["self"]],["typeid"]]],[11,"to_string","","",4,[[["self"]],["string"]]],[11,"from","","",4,[[["t"]],["t"]]],[11,"into","","",4,[[["self"]],["u"]]],[11,"try_from","","",4,[[["u"]],["result"]]],[11,"borrow","","",4,[[["self"]],["t"]]],[11,"borrow_mut","","",4,[[["self"]],["t"]]],[11,"try_into","","",4,[[["self"]],["result"]]],[11,"get_type_id","","",4,[[["self"]],["typeid"]]],[11,"eq","","",5,[[["self"],["ctlflags"]],["bool"]]],[11,"ne","","",5,[[["self"],["ctlflags"]],["bool"]]],[11,"eq","","",2,[[["self"],["ctltype"]],["bool"]]],[11,"eq","","",3,[[["self"],["ctlvalue"]],["bool"]]],[11,"ne","","",3,[[["self"],["ctlvalue"]],["bool"]]],[11,"eq","","",0,[[["self"],["ctlinfo"]],["bool"]]],[11,"ne","","",0,[[["self"],["ctlinfo"]],["bool"]]],[11,"eq","","",1,[[["self"],["ctl"]],["bool"]]],[11,"ne","","",1,[[["self"],["ctl"]],["bool"]]],[11,"from","","",2,[[["u32"]],["self"]]],[11,"from","","",2,[[["ctlvalue"]],["self"]]],[11,"into_iter","","",1,N],[11,"clone","","",5,[[["self"]],["ctlflags"]]],[11,"clone","","",2,[[["self"]],["ctltype"]]],[11,"clone","","",1,[[["self"]],["ctl"]]],[11,"cmp","","",5,[[["self"],["ctlflags"]],["ordering"]]],[11,"extend","","",5,[[["self"],["t"]]]],[11,"next","","",6,[[["self"]],["option"]]],[11,"partial_cmp","","",5,[[["self"],["ctlflags"]],["option",["ordering"]]]],[11,"lt","","",5,[[["self"],["ctlflags"]],["bool"]]],[11,"le","","",5,[[["self"],["ctlflags"]],["bool"]]],[11,"gt","","",5,[[["self"],["ctlflags"]],["bool"]]],[11,"ge","","",5,[[["self"],["ctlflags"]],["bool"]]],[11,"partial_cmp","","",3,[[["self"],["ctlvalue"]],["option",["ordering"]]]],[11,"lt","","",3,[[["self"],["ctlvalue"]],["bool"]]],[11,"le","","",3,[[["self"],["ctlvalue"]],["bool"]]],[11,"gt","","",3,[[["self"],["ctlvalue"]],["bool"]]],[11,"ge","","",3,[[["self"],["ctlvalue"]],["bool"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",2,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",3,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",0,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",1,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",4,[[["self"],["formatter"]],["result"]]],[11,"from_str","","",1,[[["str"]],["result"]]],[11,"sub","","Returns the set difference of the two sets of flags.",5,[[["self"],["ctlflags"]],["ctlflags"]]],[11,"sub_assign","","Disables all flags enabled in the set.",5,[[["self"],["ctlflags"]]]],[11,"not","","Returns the complement of this set of flags.",5,[[["self"]],["ctlflags"]]],[11,"bitand","","Returns the intersection between the two sets of flags.",5,[[["self"],["ctlflags"]],["ctlflags"]]],[11,"bitor","","Returns the union of the two sets of flags.",5,[[["self"],["ctlflags"]],["ctlflags"]]],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",5,[[["self"],["ctlflags"]],["ctlflags"]]],[11,"bitand_assign","","Disables all flags disabled in the set.",5,[[["self"],["ctlflags"]]]],[11,"bitor_assign","","Adds the set of flags.",5,[[["self"],["ctlflags"]]]],[11,"bitxor_assign","","Toggles the set of flags.",5,[[["self"],["ctlflags"]]]],[11,"hash","","",5,N],[11,"from_iter","","",5,[[["t"]],["ctlflags"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"fmt","","",5,[[["self"],["formatter"]],["result"]]],[11,"cause","","",4,[[["self"]],["option",["fail"]]]],[11,"backtrace","","",4,[[["self"]],["option",["backtrace"]]]]],"paths":[[3,"CtlInfo"],[3,"Ctl"],[4,"CtlType"],[4,"CtlValue"],[4,"SysctlError"],[3,"CtlFlags"],[3,"CtlIter"]]};
initSearch(searchIndex);
