var searchIndex = {};
searchIndex["sysctl"] = {"doc":"A simplified interface to the `sysctl` system call.","items":[[3,"CtlFlags","sysctl","",null,null],[3,"CtlInfo","","A structure representing control metadata",null,null],[12,"ctl_type","","The control type.",0,null],[12,"fmt","","A string which specifies the format of the OID in a symbolic way.",0,null],[3,"Temperature","","A custom type for temperature sysctls.",null,null],[3,"Ctl","","This struct represents a system control.",null,null],[12,"oid","","",1,null],[3,"CtlIter","","An iterator over Sysctl entries.",null,null],[4,"CtlType","","An Enum that represents a sysctl's type information.",null,null],[13,"Node","","",2,null],[13,"Int","","",2,null],[13,"String","","",2,null],[13,"S64","","",2,null],[13,"Struct","","",2,null],[13,"Uint","","",2,null],[13,"Long","","",2,null],[13,"Ulong","","",2,null],[13,"U64","","",2,null],[13,"U8","","",2,null],[13,"U16","","",2,null],[13,"S8","","",2,null],[13,"S16","","",2,null],[13,"S32","","",2,null],[13,"U32","","",2,null],[13,"None","","",2,null],[13,"Temperature","","",2,null],[4,"CtlValue","","An Enum that holds all values returned by sysctl calls. Extract inner value with `if let` or `match`.",null,null],[13,"None","","",3,null],[13,"Node","","",3,null],[13,"Int","","",3,null],[13,"String","","",3,null],[13,"S64","","",3,null],[13,"Struct","","",3,null],[13,"Uint","","",3,null],[13,"Long","","",3,null],[13,"Ulong","","",3,null],[13,"U64","","",3,null],[13,"U8","","",3,null],[13,"U16","","",3,null],[13,"S8","","",3,null],[13,"S16","","",3,null],[13,"S32","","",3,null],[13,"U32","","",3,null],[13,"Temperature","","",3,null],[4,"SysctlError","","",null,null],[13,"NotFound","","",4,null],[13,"UnknownType","","",4,null],[13,"ExtractionError","","",4,null],[13,"IoError","","",4,null],[13,"Utf8Error","","",4,null],[13,"NoReadAccess","","",4,null],[13,"NoWriteAccess","","",4,null],[13,"ShortRead","","",4,null],[12,"read","sysctl::SysctlError","",4,null],[12,"reported","","",4,null],[13,"InvalidCStr","sysctl","",4,null],[5,"value","","Takes the name of the OID as argument and returns a result containing the sysctl value if success, or a SysctlError on failure",null,{"i":[{"n":"str"}],"o":{"g":["ctlvalue","sysctlerror"],"n":"result"}}],[5,"value_oid","","Takes an OID as argument and returns a result containing the sysctl value if success, or a SysctlError on failure",null,{"i":[{"n":"vec"}],"o":{"g":["ctlvalue","sysctlerror"],"n":"result"}}],[5,"value_as","","A generic function that takes a string as argument and returns a result containing the sysctl value if success, or a SysctlError on failure.",null,{"i":[{"n":"str"}],"o":{"g":["box","sysctlerror"],"n":"result"}}],[5,"value_oid_as","","A generic function that takes an OID as argument and returns a result containing the sysctl value if success, or a SysctlError on failure",null,{"i":[{"n":"vec"}],"o":{"g":["box","sysctlerror"],"n":"result"}}],[5,"set_value","","Sets the value of a sysctl. Fetches and returns the new value if successful, or a SysctlError on failure",null,{"i":[{"n":"str"},{"n":"ctlvalue"}],"o":{"g":["ctlvalue","sysctlerror"],"n":"result"}}],[5,"set_oid_value","","",null,{"i":[{"n":"vec"},{"n":"ctlvalue"}],"o":{"g":["ctlvalue","sysctlerror"],"n":"result"}}],[5,"description","","Returns a result containing the sysctl description if success, or a SysctlError on failure.",null,{"i":[{"n":"str"}],"o":{"g":["string","sysctlerror"],"n":"result"}}],[5,"next_oid","","Get the next OID.",null,{"i":[{"n":"vec"}],"o":{"g":["option","sysctlerror"],"n":"result"}}],[17,"CTL_MAXNAME","","",null,null],[17,"CTLTYPE","","",null,null],[17,"CTLTYPE_NODE","","",null,null],[17,"CTLTYPE_INT","","",null,null],[17,"CTLTYPE_STRING","","",null,null],[17,"CTLTYPE_S64","","",null,null],[17,"CTLTYPE_OPAQUE","","",null,null],[17,"CTLTYPE_STRUCT","","",null,null],[17,"CTLTYPE_UINT","","",null,null],[17,"CTLTYPE_LONG","","",null,null],[17,"CTLTYPE_ULONG","","",null,null],[17,"CTLTYPE_U64","","",null,null],[17,"CTLTYPE_U8","","",null,null],[17,"CTLTYPE_U16","","",null,null],[17,"CTLTYPE_S8","","",null,null],[17,"CTLTYPE_S16","","",null,null],[17,"CTLTYPE_S32","","",null,null],[17,"CTLTYPE_U32","","",null,null],[17,"CTLFLAG_RD","","",null,null],[17,"CTLFLAG_WR","","",null,null],[17,"CTLFLAG_RW","","",null,null],[17,"CTLFLAG_DORMANT","","",null,null],[17,"CTLFLAG_ANYBODY","","",null,null],[17,"CTLFLAG_SECURE","","",null,null],[17,"CTLFLAG_PRISON","","",null,null],[17,"CTLFLAG_DYN","","",null,null],[17,"CTLFLAG_SKIP","","",null,null],[17,"CTLFLAG_TUN","","",null,null],[17,"CTLFLAG_RDTUN","","",null,null],[17,"CTLFLAG_RWTUN","","",null,null],[17,"CTLFLAG_MPSAFE","","",null,null],[17,"CTLFLAG_VNET","","",null,null],[17,"CTLFLAG_DYING","","",null,null],[17,"CTLFLAG_CAPRD","","",null,null],[17,"CTLFLAG_CAPWR","","",null,null],[17,"CTLFLAG_STATS","","",null,null],[17,"CTLFLAG_NOFETCH","","",null,null],[17,"CTLFLAG_CAPRW","","",null,null],[17,"CTLFLAG_SECURE1","","",null,null],[17,"CTLFLAG_SECURE2","","",null,null],[17,"CTLFLAG_SECURE3","","",null,null],[17,"CTLMASK_SECURE","","",null,null],[17,"CTLSHIFT_SECURE","","",null,null],[11,"eq","","",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"bool"}}],[11,"ne","","",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"bool"}}],[11,"clone","","",5,{"i":[{"n":"self"}],"o":{"n":"ctlflags"}}],[11,"partial_cmp","","",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"bool"}}],[11,"le","","",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"bool"}}],[11,"gt","","",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"bool"}}],[11,"ge","","",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"bool"}}],[11,"cmp","","",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"ordering"}}],[11,"hash","","",5,null],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",5,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[18,"RD","","Allow reads of variable",5,null],[18,"WR","","Allow writes to the variable",5,null],[18,"RW","","",5,null],[18,"DORMANT","","This sysctl is not active yet",5,null],[18,"ANYBODY","","All users can set this var",5,null],[18,"SECURE","","Permit set only if securelevel<=0",5,null],[18,"PRISON","","Prisoned roots can fiddle",5,null],[18,"DYN","","Dynamic oid - can be freed",5,null],[18,"SKIP","","Skip this sysctl when listing",5,null],[18,"SECURE_MASK","","Secure level",5,null],[18,"TUN","","Default value is loaded from getenv()",5,null],[18,"RDTUN","","Readable tunable",5,null],[18,"RWTUN","","Readable and writeable tunable",5,null],[18,"MPSAFE","","Handler is MP safe",5,null],[18,"VNET","","Prisons with vnet can fiddle",5,null],[18,"DYING","","Oid is being removed",5,null],[18,"CAPRD","","Can be read in capability mode",5,null],[18,"CAPWR","","Can be written in capability mode",5,null],[18,"STATS","","Statistics; not a tuneable",5,null],[18,"NOFETCH","","Don't fetch tunable from getenv()",5,null],[18,"CAPRW","","Can be read and written in capability mode",5,null],[11,"empty","","Returns an empty set of flags.",5,{"o":{"n":"ctlflags"}}],[11,"all","","Returns the set containing all flags.",5,{"o":{"n":"ctlflags"}}],[11,"bits","","Returns the raw value of the flags currently stored.",5,{"i":[{"n":"self"}],"o":{"n":"c_uint"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",5,{"i":[{"n":"c_uint"}],"o":{"g":["ctlflags"],"n":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",5,{"i":[{"n":"c_uint"}],"o":{"n":"ctlflags"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",5,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",5,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",5,{"i":[{"n":"self"},{"n":"ctlflags"}]}],[11,"remove","","Removes the specified flags in-place.",5,{"i":[{"n":"self"},{"n":"ctlflags"}]}],[11,"toggle","","Toggles the specified flags in-place.",5,{"i":[{"n":"self"},{"n":"ctlflags"}]}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",5,{"i":[{"n":"self"},{"n":"ctlflags"},{"n":"bool"}]}],[11,"bitor","","Returns the union of the two sets of flags.",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"ctlflags"}}],[11,"bitor_assign","","Adds the set of flags.",5,{"i":[{"n":"self"},{"n":"ctlflags"}]}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"ctlflags"}}],[11,"bitxor_assign","","Toggles the set of flags.",5,{"i":[{"n":"self"},{"n":"ctlflags"}]}],[11,"bitand","","Returns the intersection between the two sets of flags.",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"ctlflags"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",5,{"i":[{"n":"self"},{"n":"ctlflags"}]}],[11,"sub","","Returns the set difference of the two sets of flags.",5,{"i":[{"n":"self"},{"n":"ctlflags"}],"o":{"n":"ctlflags"}}],[11,"sub_assign","","Disables all flags enabled in the set.",5,{"i":[{"n":"self"},{"n":"ctlflags"}]}],[11,"not","","Returns the complement of this set of flags.",5,{"i":[{"n":"self"}],"o":{"n":"ctlflags"}}],[11,"extend","","",5,{"i":[{"n":"self"},{"n":"t"}]}],[11,"from_iter","","",5,{"i":[{"n":"t"}],"o":{"n":"ctlflags"}}],[11,"fmt","","",2,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",2,{"i":[{"n":"self"}],"o":{"n":"ctltype"}}],[11,"eq","","",2,{"i":[{"n":"self"},{"n":"ctltype"}],"o":{"n":"bool"}}],[11,"from","","",2,{"i":[{"n":"u32"}],"o":{"n":"self"}}],[11,"from","","",2,{"i":[{"n":"ctlvalue"}],"o":{"n":"self"}}],[11,"fmt","","",3,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",3,{"i":[{"n":"self"},{"n":"ctlvalue"}],"o":{"n":"bool"}}],[11,"ne","","",3,{"i":[{"n":"self"},{"n":"ctlvalue"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",3,{"i":[{"n":"self"},{"n":"ctlvalue"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",3,{"i":[{"n":"self"},{"n":"ctlvalue"}],"o":{"n":"bool"}}],[11,"le","","",3,{"i":[{"n":"self"},{"n":"ctlvalue"}],"o":{"n":"bool"}}],[11,"gt","","",3,{"i":[{"n":"self"},{"n":"ctlvalue"}],"o":{"n":"bool"}}],[11,"ge","","",3,{"i":[{"n":"self"},{"n":"ctlvalue"}],"o":{"n":"bool"}}],[11,"fmt","","",0,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"eq","","",0,{"i":[{"n":"self"},{"n":"ctlinfo"}],"o":{"n":"bool"}}],[11,"ne","","",0,{"i":[{"n":"self"},{"n":"ctlinfo"}],"o":{"n":"bool"}}],[11,"flags","","Return the flags for this sysctl.",0,{"i":[{"n":"self"}],"o":{"n":"ctlflags"}}],[11,"is_temperature","","Is this sysctl a temperature?",0,{"i":[{"n":"self"}],"o":{"n":"bool"}}],[11,"struct_type","","If the sysctl is a structure, return the structure type string.",0,{"i":[{"n":"self"}],"o":{"g":["string"],"n":"option"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"cause","","",4,{"i":[{"n":"self"}],"o":{"g":["fail"],"n":"option"}}],[11,"backtrace","","",4,{"i":[{"n":"self"}],"o":{"g":["backtrace"],"n":"option"}}],[11,"fmt","","",4,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"fmt","","",6,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",6,{"i":[{"n":"self"}],"o":{"n":"temperature"}}],[11,"eq","","",6,{"i":[{"n":"self"},{"n":"temperature"}],"o":{"n":"bool"}}],[11,"ne","","",6,{"i":[{"n":"self"},{"n":"temperature"}],"o":{"n":"bool"}}],[11,"partial_cmp","","",6,{"i":[{"n":"self"},{"n":"temperature"}],"o":{"g":["ordering"],"n":"option"}}],[11,"lt","","",6,{"i":[{"n":"self"},{"n":"temperature"}],"o":{"n":"bool"}}],[11,"le","","",6,{"i":[{"n":"self"},{"n":"temperature"}],"o":{"n":"bool"}}],[11,"gt","","",6,{"i":[{"n":"self"},{"n":"temperature"}],"o":{"n":"bool"}}],[11,"ge","","",6,{"i":[{"n":"self"},{"n":"temperature"}],"o":{"n":"bool"}}],[11,"kelvin","","",6,{"i":[{"n":"self"}],"o":{"n":"f32"}}],[11,"celsius","","",6,{"i":[{"n":"self"}],"o":{"n":"f32"}}],[11,"fahrenheit","","",6,{"i":[{"n":"self"}],"o":{"n":"f32"}}],[11,"fmt","","",1,{"i":[{"n":"self"},{"n":"formatter"}],"o":{"n":"result"}}],[11,"clone","","",1,{"i":[{"n":"self"}],"o":{"n":"ctl"}}],[11,"eq","","",1,{"i":[{"n":"self"},{"n":"ctl"}],"o":{"n":"bool"}}],[11,"ne","","",1,{"i":[{"n":"self"},{"n":"ctl"}],"o":{"n":"bool"}}],[11,"from_str","","",1,{"i":[{"n":"str"}],"o":{"n":"result"}}],[11,"new","","Construct a Ctl from the name.",1,{"i":[{"n":"str"}],"o":{"g":["sysctlerror"],"n":"result"}}],[11,"name","","Returns a result containing the sysctl name on success, or a SysctlError on failure.",1,{"i":[{"n":"self"}],"o":{"g":["string","sysctlerror"],"n":"result"}}],[11,"value_type","","Returns a result containing the sysctl value type on success, or a Sysctl Error on failure.",1,{"i":[{"n":"self"}],"o":{"g":["ctltype","sysctlerror"],"n":"result"}}],[11,"description","","Returns a result containing the sysctl description if success, or an Error on failure.",1,{"i":[{"n":"self"}],"o":{"g":["string","sysctlerror"],"n":"result"}}],[11,"value","","Returns a result containing the sysctl value on success, or a SysctlError on failure.",1,{"i":[{"n":"self"}],"o":{"g":["ctlvalue","sysctlerror"],"n":"result"}}],[11,"value_as","","A generic method that takes returns a result containing the sysctl value if success, or a SysctlError on failure.",1,{"i":[{"n":"self"}],"o":{"g":["box","sysctlerror"],"n":"result"}}],[11,"set_value","","Sets the value of a sysctl. Fetches and returns the new value if successful, or returns a SysctlError on failure. # Example ``` extern crate sysctl; use sysctl::Ctl; # extern crate libc;",1,{"i":[{"n":"self"},{"n":"ctlvalue"}],"o":{"g":["ctlvalue","sysctlerror"],"n":"result"}}],[11,"flags","","Get the flags for a sysctl.",1,{"i":[{"n":"self"}],"o":{"g":["ctlflags","sysctlerror"],"n":"result"}}],[11,"info","","Returns a Result containing the control metadata for a sysctl.",1,{"i":[{"n":"self"}],"o":{"g":["ctlinfo","sysctlerror"],"n":"result"}}],[11,"root","","Return an iterator over the complete sysctl tree.",7,{"o":{"n":"self"}}],[11,"below","","Return an iterator over all sysctl entries below the given node.",7,{"i":[{"n":"ctl"}],"o":{"n":"self"}}],[11,"next","","",7,{"i":[{"n":"self"}],"o":{"n":"option"}}],[11,"into_iter","","",1,null]],"paths":[[3,"CtlInfo"],[3,"Ctl"],[4,"CtlType"],[4,"CtlValue"],[4,"SysctlError"],[3,"CtlFlags"],[3,"Temperature"],[3,"CtlIter"]]};
initSearch(searchIndex);
