var searchIndex = {};
searchIndex["sysctl"] = {"doc":"A simplified interface to the `sysctl` system call.","items":[[3,"CtlFlags","sysctl","",null,null],[3,"Ctl","","This struct represents a system control.",null,null],[3,"CtlIter","","An iterator over Sysctl entries.",null,null],[4,"CtlType","","An Enum that represents a sysctl's type information.",null,null],[13,"Node","","",0,null],[13,"Int","","",0,null],[13,"String","","",0,null],[13,"S64","","",0,null],[13,"Struct","","",0,null],[13,"Uint","","",0,null],[13,"Long","","",0,null],[13,"Ulong","","",0,null],[13,"U64","","",0,null],[13,"U8","","",0,null],[13,"U16","","",0,null],[13,"S8","","",0,null],[13,"S16","","",0,null],[13,"S32","","",0,null],[13,"U32","","",0,null],[13,"None","","",0,null],[4,"CtlValue","","An Enum that holds all values returned by sysctl calls. Extract inner value with `if let` or `match`.",null,null],[13,"None","","",1,null],[13,"Node","","",1,null],[13,"Int","","",1,null],[13,"String","","",1,null],[13,"S64","","",1,null],[13,"Struct","","",1,null],[13,"Uint","","",1,null],[13,"Long","","",1,null],[13,"Ulong","","",1,null],[13,"U64","","",1,null],[13,"U8","","",1,null],[13,"U16","","",1,null],[13,"S8","","",1,null],[13,"S16","","",1,null],[13,"S32","","",1,null],[13,"U32","","",1,null],[4,"SysctlError","","",null,null],[13,"ExtractionError","","",2,null],[13,"IoError","","",2,null],[13,"Utf8Error","","",2,null],[13,"NoReadAccess","","",2,null],[13,"NoWriteAccess","","",2,null],[13,"ShortRead","","",2,null],[12,"read","sysctl::SysctlError","",2,null],[12,"reported","","",2,null],[5,"value","sysctl","Takes the name of the OID as argument and returns a result containing the sysctl value if success, or a SysctlError on failure",null,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[5,"value_oid","","Takes an OID as argument and returns a result containing the sysctl value if success, or a SysctlError on failure",null,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[5,"value_as","","A generic function that takes a string as argument and returns a result containing the sysctl value if success, or a SysctlError on failure.",null,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[5,"value_oid_as","","A generic function that takes an OID as argument and returns a result containing the sysctl value if success, or a SysctlError on failure",null,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[5,"set_value","","Sets the value of a sysctl. Fetches and returns the new value if successful, or a SysctlError on failure",null,{"inputs":[{"name":"str"},{"name":"ctlvalue"}],"output":{"name":"result"}}],[5,"set_oid_value","","",null,{"inputs":[{"name":"vec"},{"name":"ctlvalue"}],"output":{"name":"result"}}],[5,"next_oid","","Get the next OID.",null,{"inputs":[{"name":"vec"}],"output":{"name":"result"}}],[17,"CTL_MAXNAME","","",null,null],[17,"CTLTYPE","","",null,null],[17,"CTLTYPE_NODE","","",null,null],[17,"CTLTYPE_INT","","",null,null],[17,"CTLTYPE_STRING","","",null,null],[17,"CTLTYPE_S64","","",null,null],[17,"CTLTYPE_OPAQUE","","",null,null],[17,"CTLTYPE_STRUCT","","",null,null],[17,"CTLTYPE_UINT","","",null,null],[17,"CTLTYPE_LONG","","",null,null],[17,"CTLTYPE_ULONG","","",null,null],[17,"CTLTYPE_U64","","",null,null],[17,"CTLTYPE_U8","","",null,null],[17,"CTLTYPE_U16","","",null,null],[17,"CTLTYPE_S8","","",null,null],[17,"CTLTYPE_S16","","",null,null],[17,"CTLTYPE_S32","","",null,null],[17,"CTLTYPE_U32","","",null,null],[17,"CTLFLAG_RD","","",null,null],[17,"CTLFLAG_WR","","",null,null],[17,"CTLFLAG_RW","","",null,null],[17,"CTLFLAG_DORMANT","","",null,null],[17,"CTLFLAG_ANYBODY","","",null,null],[17,"CTLFLAG_SECURE","","",null,null],[17,"CTLFLAG_PRISON","","",null,null],[17,"CTLFLAG_DYN","","",null,null],[17,"CTLFLAG_SKIP","","",null,null],[17,"CTLFLAG_TUN","","",null,null],[17,"CTLFLAG_RDTUN","","",null,null],[17,"CTLFLAG_RWTUN","","",null,null],[17,"CTLFLAG_MPSAFE","","",null,null],[17,"CTLFLAG_VNET","","",null,null],[17,"CTLFLAG_DYING","","",null,null],[17,"CTLFLAG_CAPRD","","",null,null],[17,"CTLFLAG_CAPWR","","",null,null],[17,"CTLFLAG_STATS","","",null,null],[17,"CTLFLAG_NOFETCH","","",null,null],[17,"CTLFLAG_CAPRW","","",null,null],[17,"CTLFLAG_SECURE1","","",null,null],[17,"CTLFLAG_SECURE2","","",null,null],[17,"CTLFLAG_SECURE3","","",null,null],[17,"CTLMASK_SECURE","","",null,null],[17,"CTLSHIFT_SECURE","","",null,null],[11,"eq","","",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"bool"}}],[11,"ne","","",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"bool"}}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"ctlflags"}}],[11,"partial_cmp","","",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"option"}}],[11,"lt","","",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"bool"}}],[11,"le","","",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"bool"}}],[11,"gt","","",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"bool"}}],[11,"ge","","",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"bool"}}],[11,"cmp","","",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"ordering"}}],[11,"hash","","",3,null],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[18,"RD","","Allow reads of variable",3,null],[18,"WR","","Allow writes to the variable",3,null],[18,"RW","","",3,null],[18,"DORMANT","","This sysctl is not active yet",3,null],[18,"ANYBODY","","All users can set this var",3,null],[18,"SECURE","","Permit set only if securelevel<=0",3,null],[18,"PRISON","","Prisoned roots can fiddle",3,null],[18,"DYN","","Dynamic oid - can be freed",3,null],[18,"SKIP","","Skip this sysctl when listing",3,null],[18,"SECURE_MASK","","Secure level",3,null],[18,"TUN","","Default value is loaded from getenv()",3,null],[18,"RDTUN","","Readable tunable",3,null],[18,"RWTUN","","Readable and writeable tunable",3,null],[18,"MPSAFE","","Handler is MP safe",3,null],[18,"VNET","","Prisons with vnet can fiddle",3,null],[18,"DYING","","Oid is being removed",3,null],[18,"CAPRD","","Can be read in capability mode",3,null],[18,"CAPWR","","Can be written in capability mode",3,null],[18,"STATS","","Statistics; not a tuneable",3,null],[18,"NOFETCH","","Don't fetch tunable from getenv()",3,null],[18,"CAPRW","","Can be read and written in capability mode",3,null],[11,"empty","","Returns an empty set of flags.",3,{"inputs":[],"output":{"name":"ctlflags"}}],[11,"all","","Returns the set containing all flags.",3,{"inputs":[],"output":{"name":"ctlflags"}}],[11,"bits","","Returns the raw value of the flags currently stored.",3,{"inputs":[{"name":"self"}],"output":{"name":"c_uint"}}],[11,"from_bits","","Convert from underlying bit representation, unless that representation contains bits that do not correspond to a flag.",3,{"inputs":[{"name":"c_uint"}],"output":{"name":"option"}}],[11,"from_bits_truncate","","Convert from underlying bit representation, dropping any bits that do not correspond to flags.",3,{"inputs":[{"name":"c_uint"}],"output":{"name":"ctlflags"}}],[11,"is_empty","","Returns `true` if no flags are currently stored.",3,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"is_all","","Returns `true` if all flags are currently set.",3,{"inputs":[{"name":"self"}],"output":{"name":"bool"}}],[11,"intersects","","Returns `true` if there are flags common to both `self` and `other`.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"bool"}}],[11,"contains","","Returns `true` all of the flags in `other` are contained within `self`.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"bool"}}],[11,"insert","","Inserts the specified flags in-place.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":null}],[11,"remove","","Removes the specified flags in-place.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":null}],[11,"toggle","","Toggles the specified flags in-place.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":null}],[11,"set","","Inserts or removes the specified flags depending on the passed value.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"},{"name":"bool"}],"output":null}],[11,"bitor","","Returns the union of the two sets of flags.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"ctlflags"}}],[11,"bitor_assign","","Adds the set of flags.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":null}],[11,"bitxor","","Returns the left flags, but with all the right flags toggled.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"ctlflags"}}],[11,"bitxor_assign","","Toggles the set of flags.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":null}],[11,"bitand","","Returns the intersection between the two sets of flags.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"ctlflags"}}],[11,"bitand_assign","","Disables all flags disabled in the set.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":null}],[11,"sub","","Returns the set difference of the two sets of flags.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":{"name":"ctlflags"}}],[11,"sub_assign","","Disables all flags enabled in the set.",3,{"inputs":[{"name":"self"},{"name":"ctlflags"}],"output":null}],[11,"not","","Returns the complement of this set of flags.",3,{"inputs":[{"name":"self"}],"output":{"name":"ctlflags"}}],[11,"extend","","",3,{"inputs":[{"name":"self"},{"name":"t"}],"output":null}],[11,"from_iter","","",3,{"inputs":[{"name":"t"}],"output":{"name":"ctlflags"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"ctltype"}}],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"ctltype"}],"output":{"name":"bool"}}],[11,"from","","",0,{"inputs":[{"name":"u32"}],"output":{"name":"self"}}],[11,"from","","",0,{"inputs":[{"name":"ctlvalue"}],"output":{"name":"self"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",1,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"ne","","",1,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",1,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"option"}}],[11,"lt","","",1,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"le","","",1,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"gt","","",1,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"ge","","",1,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"cause","","",2,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"backtrace","","",2,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"fmt","","",2,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"ctl"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"ctl"}],"output":{"name":"bool"}}],[11,"ne","","",4,{"inputs":[{"name":"self"},{"name":"ctl"}],"output":{"name":"bool"}}],[11,"from_str","","",4,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"new","","Construct a Ctl from the name.",4,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[11,"name","","Returns a result containing the sysctl name on success, or a SysctlError on failure.",4,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"value_type","","Returns a result containing the sysctl value type on success, or a Sysctl Error on failure.",4,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"value","","Returns a result containing the sysctl value on success, or a SysctlError on failure.",4,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"value_as","","A generic method that takes returns a result containing the sysctl value if success, or a SysctlError on failure.",4,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"set_value","","Sets the value of a sysctl. Fetches and returns the new value if successful, or returns a SysctlError on failure. # Example ```ignore extern crate sysctl; use sysctl::Ctl;",4,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"result"}}],[11,"flags","","Get the flags for a sysctl.",4,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"root","","Return an iterator over the complete sysctl tree.",5,{"inputs":[],"output":{"name":"self"}}],[11,"below","","Return an iterator over all sysctl entries below the given node.",5,{"inputs":[{"name":"ctl"}],"output":{"name":"self"}}],[11,"next","","",5,{"inputs":[{"name":"self"}],"output":{"name":"option"}}],[11,"into_iter","","",4,null]],"paths":[[4,"CtlType"],[4,"CtlValue"],[4,"SysctlError"],[3,"CtlFlags"],[3,"Ctl"],[3,"CtlIter"]]};
initSearch(searchIndex);
