var searchIndex = {};
searchIndex["byteorder"] = {"doc":"This crate provides convenience methods for encoding and decoding numbers in either big-endian or little-endian order.","items":[[4,"BigEndian","byteorder","Defines big-endian serialization.",null,null],[4,"LittleEndian","","Defines little-endian serialization.",null,null],[6,"NetworkEndian","","Defines network byte order serialization.",null,null],[6,"NativeEndian","","Defines system native-endian serialization.",null,null],[8,"ReadBytesExt","","Extends `Read` with methods for reading numbers. (For `std::io`.)",null,null],[11,"read_u8","","Reads an unsigned 8 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_i8","","Reads a signed 8 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_u16","","Reads an unsigned 16 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_i16","","Reads a signed 16 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_u32","","Reads an unsigned 32 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_i32","","Reads a signed 32 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_u64","","Reads an unsigned 64 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_i64","","Reads a signed 64 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_uint","","Reads an unsigned n-bytes integer from the underlying reader.",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"read_int","","Reads a signed n-bytes integer from the underlying reader.",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"read_f32","","Reads a IEEE754 single-precision (4 bytes) floating point number from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_f64","","Reads a IEEE754 double-precision (8 bytes) floating point number from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[8,"WriteBytesExt","","Extends `Write` with methods for writing numbers. (For `std::io`.)",null,null],[11,"write_u8","","Writes an unsigned 8 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"result"}}],[11,"write_i8","","Writes a signed 8 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"result"}}],[11,"write_u16","","Writes an unsigned 16 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"result"}}],[11,"write_i16","","Writes a signed 16 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"result"}}],[11,"write_u32","","Writes an unsigned 32 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"write_i32","","Writes a signed 32 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"result"}}],[11,"write_u64","","Writes an unsigned 64 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"result"}}],[11,"write_i64","","Writes a signed 64 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"result"}}],[11,"write_uint","","Writes an unsigned n-bytes integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"usize"}],"output":{"name":"result"}}],[11,"write_int","","Writes a signed n-bytes integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"usize"}],"output":{"name":"result"}}],[11,"write_f32","","Writes a IEEE754 single-precision (4 bytes) floating point number to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"result"}}],[11,"write_f64","","Writes a IEEE754 double-precision (8 bytes) floating point number to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"result"}}],[8,"ByteOrder","","ByteOrder describes types that can serialize integers as bytes.",null,null],[10,"read_u16","","Reads an unsigned 16 bit integer from `buf`.",2,null],[10,"read_u32","","Reads an unsigned 32 bit integer from `buf`.",2,null],[10,"read_u64","","Reads an unsigned 64 bit integer from `buf`.",2,null],[10,"read_uint","","Reads an unsigned n-bytes integer from `buf`.",2,null],[10,"write_u16","","Writes an unsigned 16 bit integer `n` to `buf`.",2,null],[10,"write_u32","","Writes an unsigned 32 bit integer `n` to `buf`.",2,null],[10,"write_u64","","Writes an unsigned 64 bit integer `n` to `buf`.",2,null],[10,"write_uint","","Writes an unsigned integer `n` to `buf` using only `nbytes`.",2,null],[11,"read_i16","","Reads a signed 16 bit integer from `buf`.",2,null],[11,"read_i32","","Reads a signed 32 bit integer from `buf`.",2,null],[11,"read_i64","","Reads a signed 64 bit integer from `buf`.",2,null],[11,"read_int","","Reads a signed n-bytes integer from `buf`.",2,null],[11,"read_f32","","Reads a IEEE754 single-precision (4 bytes) floating point number.",2,null],[11,"read_f64","","Reads a IEEE754 double-precision (8 bytes) floating point number.",2,null],[11,"write_i16","","Writes a signed 16 bit integer `n` to `buf`.",2,null],[11,"write_i32","","Writes a signed 32 bit integer `n` to `buf`.",2,null],[11,"write_i64","","Writes a signed 64 bit integer `n` to `buf`.",2,null],[11,"write_int","","Writes a signed integer `n` to `buf` using only `nbytes`.",2,null],[11,"write_f32","","Writes a IEEE754 single-precision (4 bytes) floating point number.",2,null],[11,"write_f64","","Writes a IEEE754 double-precision (8 bytes) floating point number.",2,null],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"bigendian"}}],[11,"fmt","","",3,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",3,null],[11,"cmp","","",3,{"inputs":[{"name":"self"},{"name":"bigendian"}],"output":{"name":"ordering"}}],[11,"eq","","",3,{"inputs":[{"name":"self"},{"name":"bigendian"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",3,{"inputs":[{"name":"self"},{"name":"bigendian"}],"output":{"name":"option"}}],[11,"default","","",3,{"inputs":[],"output":{"name":"bigendian"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"littleendian"}}],[11,"fmt","","",4,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"hash","","",4,null],[11,"cmp","","",4,{"inputs":[{"name":"self"},{"name":"littleendian"}],"output":{"name":"ordering"}}],[11,"eq","","",4,{"inputs":[{"name":"self"},{"name":"littleendian"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",4,{"inputs":[{"name":"self"},{"name":"littleendian"}],"output":{"name":"option"}}],[11,"default","","",4,{"inputs":[],"output":{"name":"littleendian"}}],[11,"read_u16","","",3,null],[11,"read_u32","","",3,null],[11,"read_u64","","",3,null],[11,"read_uint","","",3,null],[11,"write_u16","","",3,null],[11,"write_u32","","",3,null],[11,"write_u64","","",3,null],[11,"write_uint","","",3,null],[11,"read_u16","","",4,null],[11,"read_u32","","",4,null],[11,"read_u64","","",4,null],[11,"read_uint","","",4,null],[11,"write_u16","","",4,null],[11,"write_u32","","",4,null],[11,"write_u64","","",4,null],[11,"write_uint","","",4,null],[11,"read_u8","","Reads an unsigned 8 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_i8","","Reads a signed 8 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_u16","","Reads an unsigned 16 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_i16","","Reads a signed 16 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_u32","","Reads an unsigned 32 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_i32","","Reads a signed 32 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_u64","","Reads an unsigned 64 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_i64","","Reads a signed 64 bit integer from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_uint","","Reads an unsigned n-bytes integer from the underlying reader.",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"read_int","","Reads a signed n-bytes integer from the underlying reader.",0,{"inputs":[{"name":"self"},{"name":"usize"}],"output":{"name":"result"}}],[11,"read_f32","","Reads a IEEE754 single-precision (4 bytes) floating point number from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"read_f64","","Reads a IEEE754 double-precision (8 bytes) floating point number from the underlying reader.",0,{"inputs":[{"name":"self"}],"output":{"name":"result"}}],[11,"write_u8","","Writes an unsigned 8 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u8"}],"output":{"name":"result"}}],[11,"write_i8","","Writes a signed 8 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i8"}],"output":{"name":"result"}}],[11,"write_u16","","Writes an unsigned 16 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u16"}],"output":{"name":"result"}}],[11,"write_i16","","Writes a signed 16 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i16"}],"output":{"name":"result"}}],[11,"write_u32","","Writes an unsigned 32 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u32"}],"output":{"name":"result"}}],[11,"write_i32","","Writes a signed 32 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i32"}],"output":{"name":"result"}}],[11,"write_u64","","Writes an unsigned 64 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u64"}],"output":{"name":"result"}}],[11,"write_i64","","Writes a signed 64 bit integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i64"}],"output":{"name":"result"}}],[11,"write_uint","","Writes an unsigned n-bytes integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"u64"},{"name":"usize"}],"output":{"name":"result"}}],[11,"write_int","","Writes a signed n-bytes integer to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"i64"},{"name":"usize"}],"output":{"name":"result"}}],[11,"write_f32","","Writes a IEEE754 single-precision (4 bytes) floating point number to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"f32"}],"output":{"name":"result"}}],[11,"write_f64","","Writes a IEEE754 double-precision (8 bytes) floating point number to the underlying writer.",1,{"inputs":[{"name":"self"},{"name":"f64"}],"output":{"name":"result"}}]],"paths":[[8,"ReadBytesExt"],[8,"WriteBytesExt"],[8,"ByteOrder"],[4,"BigEndian"],[4,"LittleEndian"]]};
searchIndex["errno"] = {"doc":"Cross-platform interface to the `errno` variable.","items":[[3,"Errno","errno","Wraps a platform-specific error code.",null,null],[12,"0","","",0,null],[5,"errno","","Returns the platform-specific value of `errno`.",null,{"inputs":[],"output":{"name":"errno"}}],[5,"set_errno","","Sets the platform-specific value of `errno`.",null,{"inputs":[{"name":"errno"}],"output":null}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"errno"}}],[11,"cmp","","",0,{"inputs":[{"name":"self"},{"name":"errno"}],"output":{"name":"ordering"}}],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"errno"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"errno"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",0,{"inputs":[{"name":"self"},{"name":"errno"}],"output":{"name":"option"}}],[11,"lt","","",0,{"inputs":[{"name":"self"},{"name":"errno"}],"output":{"name":"bool"}}],[11,"le","","",0,{"inputs":[{"name":"self"},{"name":"errno"}],"output":{"name":"bool"}}],[11,"gt","","",0,{"inputs":[{"name":"self"},{"name":"errno"}],"output":{"name":"bool"}}],[11,"ge","","",0,{"inputs":[{"name":"self"},{"name":"errno"}],"output":{"name":"bool"}}],[11,"hash","","",0,null],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}]],"paths":[[3,"Errno"]]};
searchIndex["libc"] = {"doc":"Crate docs","items":[[3,"group","libc","",null,null],[12,"gr_name","","",0,null],[12,"gr_passwd","","",0,null],[12,"gr_gid","","",0,null],[12,"gr_mem","","",0,null],[3,"utimbuf","","",null,null],[12,"actime","","",1,null],[12,"modtime","","",1,null],[3,"timeval","","",null,null],[12,"tv_sec","","",2,null],[12,"tv_usec","","",2,null],[3,"timespec","","",null,null],[12,"tv_sec","","",3,null],[12,"tv_nsec","","",3,null],[3,"rlimit","","",null,null],[12,"rlim_cur","","",4,null],[12,"rlim_max","","",4,null],[3,"rusage","","",null,null],[12,"ru_utime","","",5,null],[12,"ru_stime","","",5,null],[12,"ru_maxrss","","",5,null],[12,"ru_ixrss","","",5,null],[12,"ru_idrss","","",5,null],[12,"ru_isrss","","",5,null],[12,"ru_minflt","","",5,null],[12,"ru_majflt","","",5,null],[12,"ru_nswap","","",5,null],[12,"ru_inblock","","",5,null],[12,"ru_oublock","","",5,null],[12,"ru_msgsnd","","",5,null],[12,"ru_msgrcv","","",5,null],[12,"ru_nsignals","","",5,null],[12,"ru_nvcsw","","",5,null],[12,"ru_nivcsw","","",5,null],[3,"in_addr","","",null,null],[12,"s_addr","","",6,null],[3,"in6_addr","","",null,null],[12,"s6_addr","","",7,null],[3,"ip_mreq","","",null,null],[12,"imr_multiaddr","","",8,null],[12,"imr_interface","","",8,null],[3,"ipv6_mreq","","",null,null],[12,"ipv6mr_multiaddr","","",9,null],[12,"ipv6mr_interface","","",9,null],[3,"hostent","","",null,null],[12,"h_name","","",10,null],[12,"h_aliases","","",10,null],[12,"h_addrtype","","",10,null],[12,"h_length","","",10,null],[12,"h_addr_list","","",10,null],[3,"iovec","","",null,null],[12,"iov_base","","",11,null],[12,"iov_len","","",11,null],[3,"pollfd","","",null,null],[12,"fd","","",12,null],[12,"events","","",12,null],[12,"revents","","",12,null],[3,"winsize","","",null,null],[12,"ws_row","","",13,null],[12,"ws_col","","",13,null],[12,"ws_xpixel","","",13,null],[12,"ws_ypixel","","",13,null],[3,"linger","","",null,null],[12,"l_onoff","","",14,null],[12,"l_linger","","",14,null],[3,"sigval","","",null,null],[12,"sival_ptr","","",15,null],[3,"sockaddr","","",null,null],[12,"sa_len","","",16,null],[12,"sa_family","","",16,null],[12,"sa_data","","",16,null],[3,"sockaddr_in6","","",null,null],[12,"sin6_len","","",17,null],[12,"sin6_family","","",17,null],[12,"sin6_port","","",17,null],[12,"sin6_flowinfo","","",17,null],[12,"sin6_addr","","",17,null],[12,"sin6_scope_id","","",17,null],[3,"sockaddr_un","","",null,null],[12,"sun_len","","",18,null],[12,"sun_family","","",18,null],[12,"sun_path","","",18,null],[3,"passwd","","",null,null],[12,"pw_name","","",19,null],[12,"pw_passwd","","",19,null],[12,"pw_uid","","",19,null],[12,"pw_gid","","",19,null],[12,"pw_change","","",19,null],[12,"pw_class","","",19,null],[12,"pw_gecos","","",19,null],[12,"pw_dir","","",19,null],[12,"pw_shell","","",19,null],[12,"pw_expire","","",19,null],[12,"pw_fields","","",19,null],[3,"ifaddrs","","",null,null],[12,"ifa_next","","",20,null],[12,"ifa_name","","",20,null],[12,"ifa_flags","","",20,null],[12,"ifa_addr","","",20,null],[12,"ifa_netmask","","",20,null],[12,"ifa_dstaddr","","",20,null],[12,"ifa_data","","",20,null],[3,"fd_set","","",null,null],[3,"tm","","",null,null],[12,"tm_sec","","",21,null],[12,"tm_min","","",21,null],[12,"tm_hour","","",21,null],[12,"tm_mday","","",21,null],[12,"tm_mon","","",21,null],[12,"tm_year","","",21,null],[12,"tm_wday","","",21,null],[12,"tm_yday","","",21,null],[12,"tm_isdst","","",21,null],[12,"tm_gmtoff","","",21,null],[12,"tm_zone","","",21,null],[3,"utsname","","",null,null],[12,"sysname","","",22,null],[12,"nodename","","",22,null],[12,"release","","",22,null],[12,"version","","",22,null],[12,"machine","","",22,null],[3,"msghdr","","",null,null],[12,"msg_name","","",23,null],[12,"msg_namelen","","",23,null],[12,"msg_iov","","",23,null],[12,"msg_iovlen","","",23,null],[12,"msg_control","","",23,null],[12,"msg_controllen","","",23,null],[12,"msg_flags","","",23,null],[3,"cmsghdr","","",null,null],[12,"cmsg_len","","",24,null],[12,"cmsg_level","","",24,null],[12,"cmsg_type","","",24,null],[3,"fsid_t","","",null,null],[3,"if_nameindex","","",null,null],[12,"if_index","","",25,null],[12,"if_name","","",25,null],[3,"glob_t","","",null,null],[12,"gl_pathc","","",26,null],[12,"gl_matchc","","",26,null],[12,"gl_offs","","",26,null],[12,"gl_flags","","",26,null],[12,"gl_pathv","","",26,null],[3,"kevent","","",null,null],[12,"ident","","",27,null],[12,"filter","","",27,null],[12,"flags","","",27,null],[12,"fflags","","",27,null],[12,"data","","",27,null],[12,"udata","","",27,null],[3,"sockaddr_storage","","",null,null],[12,"ss_len","","",28,null],[12,"ss_family","","",28,null],[3,"addrinfo","","",null,null],[12,"ai_flags","","",29,null],[12,"ai_family","","",29,null],[12,"ai_socktype","","",29,null],[12,"ai_protocol","","",29,null],[12,"ai_addrlen","","",29,null],[12,"ai_canonname","","",29,null],[12,"ai_addr","","",29,null],[12,"ai_next","","",29,null],[3,"sigset_t","","",null,null],[3,"siginfo_t","","",null,null],[12,"si_signo","","",30,null],[12,"si_errno","","",30,null],[12,"si_code","","",30,null],[12,"si_pid","","",30,null],[12,"si_uid","","",30,null],[12,"si_status","","",30,null],[12,"si_addr","","",30,null],[3,"sigaction","","",null,null],[12,"sa_sigaction","","",31,null],[12,"sa_flags","","",31,null],[12,"sa_mask","","",31,null],[3,"stack_t","","",null,null],[12,"ss_sp","","",32,null],[12,"ss_size","","",32,null],[12,"ss_flags","","",32,null],[3,"sched_param","","",null,null],[12,"sched_priority","","",33,null],[3,"Dl_info","","",null,null],[12,"dli_fname","","",34,null],[12,"dli_fbase","","",34,null],[12,"dli_sname","","",34,null],[12,"dli_saddr","","",34,null],[3,"sockaddr_in","","",null,null],[12,"sin_len","","",35,null],[12,"sin_family","","",35,null],[12,"sin_port","","",35,null],[12,"sin_addr","","",35,null],[12,"sin_zero","","",35,null],[3,"termios","","",null,null],[12,"c_iflag","","",36,null],[12,"c_oflag","","",36,null],[12,"c_cflag","","",36,null],[12,"c_lflag","","",36,null],[12,"c_cc","","",36,null],[12,"c_ispeed","","",36,null],[12,"c_ospeed","","",36,null],[3,"flock","","",null,null],[12,"l_start","","",37,null],[12,"l_len","","",37,null],[12,"l_pid","","",37,null],[12,"l_type","","",37,null],[12,"l_whence","","",37,null],[12,"l_sysid","","",37,null],[3,"sf_hdtr","","",null,null],[12,"headers","","",38,null],[12,"hdr_cnt","","",38,null],[12,"trailers","","",38,null],[12,"trl_cnt","","",38,null],[3,"lconv","","",null,null],[12,"decimal_point","","",39,null],[12,"thousands_sep","","",39,null],[12,"grouping","","",39,null],[12,"int_curr_symbol","","",39,null],[12,"currency_symbol","","",39,null],[12,"mon_decimal_point","","",39,null],[12,"mon_thousands_sep","","",39,null],[12,"mon_grouping","","",39,null],[12,"positive_sign","","",39,null],[12,"negative_sign","","",39,null],[12,"int_frac_digits","","",39,null],[12,"frac_digits","","",39,null],[12,"p_cs_precedes","","",39,null],[12,"p_sep_by_space","","",39,null],[12,"n_cs_precedes","","",39,null],[12,"n_sep_by_space","","",39,null],[12,"p_sign_posn","","",39,null],[12,"n_sign_posn","","",39,null],[12,"int_p_cs_precedes","","",39,null],[12,"int_n_cs_precedes","","",39,null],[12,"int_p_sep_by_space","","",39,null],[12,"int_n_sep_by_space","","",39,null],[12,"int_p_sign_posn","","",39,null],[12,"int_n_sign_posn","","",39,null],[3,"utmpx","","",null,null],[12,"ut_type","","",40,null],[12,"ut_tv","","",40,null],[12,"ut_id","","",40,null],[12,"ut_pid","","",40,null],[12,"ut_user","","",40,null],[12,"ut_line","","",40,null],[12,"ut_host","","",40,null],[12,"__ut_spare","","",40,null],[3,"aiocb","","",null,null],[12,"aio_fildes","","",41,null],[12,"aio_offset","","",41,null],[12,"aio_buf","","",41,null],[12,"aio_nbytes","","",41,null],[12,"aio_lio_opcode","","",41,null],[12,"aio_reqprio","","",41,null],[12,"aio_sigevent","","",41,null],[3,"dirent","","",null,null],[12,"d_fileno","","",42,null],[12,"d_reclen","","",42,null],[12,"d_type","","",42,null],[12,"d_namlen","","",42,null],[12,"d_name","","",42,null],[3,"jail","","",null,null],[12,"version","","",43,null],[12,"path","","",43,null],[12,"hostname","","",43,null],[12,"jailname","","",43,null],[12,"ip4s","","",43,null],[12,"ip6s","","",43,null],[12,"ip4","","",43,null],[12,"ip6","","",43,null],[3,"sigevent","","",null,null],[12,"sigev_notify","","",44,null],[12,"sigev_signo","","",44,null],[12,"sigev_value","","",44,null],[12,"sigev_notify_thread_id","","",44,null],[3,"statvfs","","",null,null],[12,"f_bavail","","",45,null],[12,"f_bfree","","",45,null],[12,"f_blocks","","",45,null],[12,"f_favail","","",45,null],[12,"f_ffree","","",45,null],[12,"f_files","","",45,null],[12,"f_bsize","","",45,null],[12,"f_flag","","",45,null],[12,"f_frsize","","",45,null],[12,"f_fsid","","",45,null],[12,"f_namemax","","",45,null],[3,"_sem","","",null,null],[3,"ipc_perm","","",null,null],[12,"cuid","","",46,null],[12,"cgid","","",46,null],[12,"uid","","",46,null],[12,"gid","","",46,null],[12,"mode","","",46,null],[12,"seq","","",46,null],[12,"key","","",46,null],[3,"msqid_ds","","",null,null],[12,"msg_perm","","",47,null],[12,"msg_cbytes","","",47,null],[12,"msg_qnum","","",47,null],[12,"msg_qbytes","","",47,null],[12,"msg_lspid","","",47,null],[12,"msg_lrpid","","",47,null],[12,"msg_stime","","",47,null],[12,"msg_rtime","","",47,null],[12,"msg_ctime","","",47,null],[3,"shmid_ds","","",null,null],[12,"shm_perm","","",48,null],[12,"shm_segsz","","",48,null],[12,"shm_lpid","","",48,null],[12,"shm_cpid","","",48,null],[12,"shm_nattch","","",48,null],[12,"shm_atime","","",48,null],[12,"shm_dtime","","",48,null],[12,"shm_ctime","","",48,null],[3,"stat","","",null,null],[12,"st_dev","","",49,null],[12,"st_ino","","",49,null],[12,"st_mode","","",49,null],[12,"st_nlink","","",49,null],[12,"st_uid","","",49,null],[12,"st_gid","","",49,null],[12,"st_rdev","","",49,null],[12,"st_atime","","",49,null],[12,"st_atime_nsec","","",49,null],[12,"st_mtime","","",49,null],[12,"st_mtime_nsec","","",49,null],[12,"st_ctime","","",49,null],[12,"st_ctime_nsec","","",49,null],[12,"st_size","","",49,null],[12,"st_blocks","","",49,null],[12,"st_blksize","","",49,null],[12,"st_flags","","",49,null],[12,"st_gen","","",49,null],[12,"st_lspare","","",49,null],[12,"st_birthtime","","",49,null],[12,"st_birthtime_nsec","","",49,null],[4,"c_void","","",null,null],[4,"FILE","","",null,null],[4,"fpos_t","","",null,null],[4,"DIR","","",null,null],[4,"locale_t","","",null,null],[4,"timezone","","",null,null],[5,"FD_CLR","","",null,null],[5,"FD_ISSET","","",null,null],[5,"FD_SET","","",null,null],[5,"FD_ZERO","","",null,null],[5,"WTERMSIG","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"c_int"}}],[5,"WIFEXITED","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"WEXITSTATUS","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"c_int"}}],[5,"WCOREDUMP","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"WIFCONTINUED","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"WSTOPSIG","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"c_int"}}],[5,"WIFSIGNALED","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"WIFSTOPPED","","",null,{"inputs":[{"name":"c_int"}],"output":{"name":"bool"}}],[5,"isalnum","","",null,null],[5,"isalpha","","",null,null],[5,"iscntrl","","",null,null],[5,"isdigit","","",null,null],[5,"isgraph","","",null,null],[5,"islower","","",null,null],[5,"isprint","","",null,null],[5,"ispunct","","",null,null],[5,"isspace","","",null,null],[5,"isupper","","",null,null],[5,"isxdigit","","",null,null],[5,"tolower","","",null,null],[5,"toupper","","",null,null],[5,"fopen","","",null,null],[5,"freopen","","",null,null],[5,"fflush","","",null,null],[5,"fclose","","",null,null],[5,"remove","","",null,null],[5,"rename","","",null,null],[5,"tmpfile","","",null,null],[5,"setvbuf","","",null,null],[5,"setbuf","","",null,null],[5,"getchar","","",null,null],[5,"putchar","","",null,null],[5,"fgetc","","",null,null],[5,"fgets","","",null,null],[5,"fputc","","",null,null],[5,"fputs","","",null,null],[5,"puts","","",null,null],[5,"ungetc","","",null,null],[5,"fread","","",null,null],[5,"fwrite","","",null,null],[5,"fseek","","",null,null],[5,"ftell","","",null,null],[5,"rewind","","",null,null],[5,"fgetpos","","",null,null],[5,"fsetpos","","",null,null],[5,"feof","","",null,null],[5,"ferror","","",null,null],[5,"perror","","",null,null],[5,"atoi","","",null,null],[5,"strtod","","",null,null],[5,"strtol","","",null,null],[5,"strtoul","","",null,null],[5,"calloc","","",null,null],[5,"malloc","","",null,null],[5,"realloc","","",null,null],[5,"free","","",null,null],[5,"abort","","",null,null],[5,"exit","","",null,null],[5,"_exit","","",null,null],[5,"atexit","","",null,null],[5,"system","","",null,null],[5,"getenv","","",null,null],[5,"strcpy","","",null,null],[5,"strncpy","","",null,null],[5,"strcat","","",null,null],[5,"strncat","","",null,null],[5,"strcmp","","",null,null],[5,"strncmp","","",null,null],[5,"strcoll","","",null,null],[5,"strchr","","",null,null],[5,"strrchr","","",null,null],[5,"strspn","","",null,null],[5,"strcspn","","",null,null],[5,"strdup","","",null,null],[5,"strpbrk","","",null,null],[5,"strstr","","",null,null],[5,"strlen","","",null,null],[5,"strnlen","","",null,null],[5,"strerror","","",null,null],[5,"strtok","","",null,null],[5,"strxfrm","","",null,null],[5,"wcslen","","",null,null],[5,"wcstombs","","",null,null],[5,"memchr","","",null,null],[5,"memcmp","","",null,null],[5,"memcpy","","",null,null],[5,"memmove","","",null,null],[5,"memset","","",null,null],[5,"abs","","",null,null],[5,"atof","","",null,null],[5,"labs","","",null,null],[5,"rand","","",null,null],[5,"srand","","",null,null],[5,"getgrnam","","",null,null],[5,"getgrgid","","",null,null],[5,"endpwent","","",null,null],[5,"getpwnam","","",null,null],[5,"getpwuid","","",null,null],[5,"fprintf","","",null,null],[5,"printf","","",null,null],[5,"snprintf","","",null,null],[5,"sprintf","","",null,null],[5,"fscanf","","",null,null],[5,"scanf","","",null,null],[5,"sscanf","","",null,null],[5,"getchar_unlocked","","",null,null],[5,"putchar_unlocked","","",null,null],[5,"socket","","",null,null],[5,"connect","","",null,null],[5,"listen","","",null,null],[5,"accept","","",null,null],[5,"getpeername","","",null,null],[5,"getsockname","","",null,null],[5,"setsockopt","","",null,null],[5,"socketpair","","",null,null],[5,"sendto","","",null,null],[5,"shutdown","","",null,null],[5,"chmod","","",null,null],[5,"fchmod","","",null,null],[5,"fstat","","",null,null],[5,"mkdir","","",null,null],[5,"stat","","",null,null],[5,"popen","","",null,null],[5,"pclose","","",null,null],[5,"fdopen","","",null,null],[5,"fileno","","",null,null],[5,"open","","",null,null],[5,"creat","","",null,null],[5,"fcntl","","",null,null],[5,"opendir","","",null,null],[5,"readdir","","",null,null],[5,"readdir_r","","",null,null],[5,"closedir","","",null,null],[5,"rewinddir","","",null,null],[5,"openat","","",null,null],[5,"faccessat","","",null,null],[5,"fchmodat","","",null,null],[5,"fchown","","",null,null],[5,"fchownat","","",null,null],[5,"fstatat","","",null,null],[5,"linkat","","",null,null],[5,"mkdirat","","",null,null],[5,"readlinkat","","",null,null],[5,"renameat","","",null,null],[5,"symlinkat","","",null,null],[5,"unlinkat","","",null,null],[5,"access","","",null,null],[5,"alarm","","",null,null],[5,"chdir","","",null,null],[5,"fchdir","","",null,null],[5,"chown","","",null,null],[5,"lchown","","",null,null],[5,"close","","",null,null],[5,"dup","","",null,null],[5,"dup2","","",null,null],[5,"execl","","",null,null],[5,"execle","","",null,null],[5,"execlp","","",null,null],[5,"execv","","",null,null],[5,"execve","","",null,null],[5,"execvp","","",null,null],[5,"fork","","",null,null],[5,"fpathconf","","",null,null],[5,"getcwd","","",null,null],[5,"getegid","","",null,null],[5,"geteuid","","",null,null],[5,"getgid","","",null,null],[5,"getgroups","","",null,null],[5,"getlogin","","",null,null],[5,"getopt","","",null,null],[5,"getpgid","","",null,null],[5,"getpgrp","","",null,null],[5,"getpid","","",null,null],[5,"getppid","","",null,null],[5,"getuid","","",null,null],[5,"isatty","","",null,null],[5,"link","","",null,null],[5,"lseek","","",null,null],[5,"pathconf","","",null,null],[5,"pause","","",null,null],[5,"pipe","","",null,null],[5,"posix_memalign","","",null,null],[5,"read","","",null,null],[5,"rmdir","","",null,null],[5,"setgid","","",null,null],[5,"setpgid","","",null,null],[5,"setsid","","",null,null],[5,"setuid","","",null,null],[5,"sleep","","",null,null],[5,"nanosleep","","",null,null],[5,"tcgetpgrp","","",null,null],[5,"tcsetpgrp","","",null,null],[5,"ttyname","","",null,null],[5,"unlink","","",null,null],[5,"wait","","",null,null],[5,"waitpid","","",null,null],[5,"write","","",null,null],[5,"pread","","",null,null],[5,"pwrite","","",null,null],[5,"umask","","",null,null],[5,"utime","","",null,null],[5,"kill","","",null,null],[5,"mlock","","",null,null],[5,"munlock","","",null,null],[5,"mlockall","","",null,null],[5,"munlockall","","",null,null],[5,"mmap","","",null,null],[5,"munmap","","",null,null],[5,"if_nametoindex","","",null,null],[5,"if_indextoname","","",null,null],[5,"lstat","","",null,null],[5,"fsync","","",null,null],[5,"setenv","","",null,null],[5,"unsetenv","","",null,null],[5,"symlink","","",null,null],[5,"ftruncate","","",null,null],[5,"signal","","",null,null],[5,"getrlimit","","",null,null],[5,"setrlimit","","",null,null],[5,"getrusage","","",null,null],[5,"getdtablesize","","",null,null],[5,"realpath","","",null,null],[5,"flock","","",null,null],[5,"gettimeofday","","",null,null],[5,"pthread_self","","",null,null],[5,"pthread_create","","",null,null],[5,"pthread_join","","",null,null],[5,"pthread_atfork","","",null,null],[5,"pthread_exit","","",null,null],[5,"pthread_attr_init","","",null,null],[5,"pthread_attr_destroy","","",null,null],[5,"pthread_attr_setstacksize","","",null,null],[5,"pthread_attr_setdetachstate","","",null,null],[5,"pthread_detach","","",null,null],[5,"sched_yield","","",null,null],[5,"pthread_key_create","","",null,null],[5,"pthread_key_delete","","",null,null],[5,"pthread_getspecific","","",null,null],[5,"pthread_setspecific","","",null,null],[5,"pthread_mutex_init","","",null,null],[5,"pthread_mutex_destroy","","",null,null],[5,"pthread_mutex_lock","","",null,null],[5,"pthread_mutex_trylock","","",null,null],[5,"pthread_mutex_unlock","","",null,null],[5,"pthread_mutexattr_init","","",null,null],[5,"pthread_mutexattr_destroy","","",null,null],[5,"pthread_mutexattr_settype","","",null,null],[5,"pthread_cond_init","","",null,null],[5,"pthread_cond_wait","","",null,null],[5,"pthread_cond_timedwait","","",null,null],[5,"pthread_cond_signal","","",null,null],[5,"pthread_cond_broadcast","","",null,null],[5,"pthread_cond_destroy","","",null,null],[5,"pthread_condattr_init","","",null,null],[5,"pthread_condattr_destroy","","",null,null],[5,"pthread_rwlock_destroy","","",null,null],[5,"pthread_rwlock_rdlock","","",null,null],[5,"pthread_rwlock_tryrdlock","","",null,null],[5,"pthread_rwlock_wrlock","","",null,null],[5,"pthread_rwlock_trywrlock","","",null,null],[5,"pthread_rwlock_unlock","","",null,null],[5,"pthread_sigmask","","",null,null],[5,"pthread_kill","","",null,null],[5,"strerror_r","","",null,null],[5,"getsockopt","","",null,null],[5,"raise","","",null,null],[5,"sigaction","","",null,null],[5,"sigaltstack","","",null,null],[5,"sigwait","","",null,null],[5,"utimes","","",null,null],[5,"dlopen","","",null,null],[5,"dlerror","","",null,null],[5,"dlsym","","",null,null],[5,"dlclose","","",null,null],[5,"dladdr","","",null,null],[5,"getaddrinfo","","",null,null],[5,"freeaddrinfo","","",null,null],[5,"gai_strerror","","",null,null],[5,"gmtime_r","","",null,null],[5,"localtime_r","","",null,null],[5,"mktime","","",null,null],[5,"time","","",null,null],[5,"localtime","","",null,null],[5,"mknod","","",null,null],[5,"uname","","",null,null],[5,"daemon","","",null,null],[5,"gethostname","","",null,null],[5,"chroot","","",null,null],[5,"usleep","","",null,null],[5,"send","","",null,null],[5,"recv","","",null,null],[5,"putenv","","",null,null],[5,"poll","","",null,null],[5,"select","","",null,null],[5,"setlocale","","",null,null],[5,"localeconv","","",null,null],[5,"sem_destroy","","",null,null],[5,"sem_open","","",null,null],[5,"sem_close","","",null,null],[5,"sem_unlink","","",null,null],[5,"sem_wait","","",null,null],[5,"sem_trywait","","",null,null],[5,"sem_post","","",null,null],[5,"sem_init","","",null,null],[5,"statvfs","","",null,null],[5,"fstatvfs","","",null,null],[5,"readlink","","",null,null],[5,"sigemptyset","","",null,null],[5,"sigaddset","","",null,null],[5,"sigfillset","","",null,null],[5,"sigdelset","","",null,null],[5,"sigismember","","",null,null],[5,"sigprocmask","","",null,null],[5,"timegm","","",null,null],[5,"getsid","","",null,null],[5,"sysconf","","",null,null],[5,"mkfifo","","",null,null],[5,"pselect","","",null,null],[5,"fseeko","","",null,null],[5,"ftello","","",null,null],[5,"tcdrain","","",null,null],[5,"cfgetispeed","","",null,null],[5,"cfgetospeed","","",null,null],[5,"cfmakeraw","","",null,null],[5,"cfsetispeed","","",null,null],[5,"cfsetospeed","","",null,null],[5,"cfsetspeed","","",null,null],[5,"tcgetattr","","",null,null],[5,"tcsetattr","","",null,null],[5,"tcflow","","",null,null],[5,"tcflush","","",null,null],[5,"tcsendbreak","","",null,null],[5,"mkstemp","","",null,null],[5,"mkdtemp","","",null,null],[5,"tmpnam","","",null,null],[5,"openlog","","",null,null],[5,"closelog","","",null,null],[5,"setlogmask","","",null,null],[5,"syslog","","",null,null],[5,"nice","","",null,null],[5,"grantpt","","",null,null],[5,"posix_openpt","","",null,null],[5,"ptsname","","",null,null],[5,"unlockpt","","",null,null],[5,"getifaddrs","","",null,null],[5,"freeifaddrs","","",null,null],[5,"setgroups","","",null,null],[5,"ioctl","","",null,null],[5,"kqueue","","",null,null],[5,"unmount","","",null,null],[5,"syscall","","",null,null],[5,"getpwnam_r","","",null,null],[5,"getpwuid_r","","",null,null],[5,"getpwent","","",null,null],[5,"setpwent","","",null,null],[5,"getprogname","","",null,null],[5,"setprogname","","",null,null],[5,"getloadavg","","",null,null],[5,"if_nameindex","","",null,null],[5,"if_freenameindex","","",null,null],[5,"getpeereid","","",null,null],[5,"glob","","",null,null],[5,"globfree","","",null,null],[5,"posix_madvise","","",null,null],[5,"shm_unlink","","",null,null],[5,"seekdir","","",null,null],[5,"telldir","","",null,null],[5,"madvise","","",null,null],[5,"msync","","",null,null],[5,"recvfrom","","",null,null],[5,"mkstemps","","",null,null],[5,"futimes","","",null,null],[5,"nl_langinfo","","",null,null],[5,"bind","","",null,null],[5,"writev","","",null,null],[5,"readv","","",null,null],[5,"sendmsg","","",null,null],[5,"recvmsg","","",null,null],[5,"lutimes","","",null,null],[5,"endutxent","","",null,null],[5,"getutxent","","",null,null],[5,"getutxid","","",null,null],[5,"getutxline","","",null,null],[5,"pututxline","","",null,null],[5,"setutxent","","",null,null],[5,"aio_read","","",null,null],[5,"aio_write","","",null,null],[5,"aio_fsync","","",null,null],[5,"aio_error","","",null,null],[5,"aio_return","","",null,null],[5,"aio_suspend","","",null,null],[5,"aio_cancel","","",null,null],[5,"lio_listio","","",null,null],[5,"getnameinfo","","",null,null],[5,"kevent","","",null,null],[5,"mincore","","",null,null],[5,"sysctlnametomib","","",null,null],[5,"shm_open","","",null,null],[5,"sysctl","","",null,null],[5,"sysctlbyname","","",null,null],[5,"sched_setscheduler","","",null,null],[5,"sched_getscheduler","","",null,null],[5,"memrchr","","",null,null],[5,"sendfile","","",null,null],[5,"sigtimedwait","","",null,null],[5,"sigwaitinfo","","",null,null],[5,"openpty","","",null,null],[5,"forkpty","","",null,null],[5,"nl_langinfo_l","","",null,null],[5,"duplocale","","",null,null],[5,"newlocale","","",null,null],[5,"uselocale","","",null,null],[5,"querylocale","","",null,null],[5,"accept4","","",null,null],[5,"pthread_set_name_np","","",null,null],[5,"pthread_attr_get_np","","",null,null],[5,"pthread_attr_getguardsize","","",null,null],[5,"pthread_attr_getstack","","",null,null],[5,"pthread_condattr_setpshared","","",null,null],[5,"pthread_condattr_getpshared","","",null,null],[5,"pthread_mutexattr_setpshared","","",null,null],[5,"pthread_mutexattr_getpshared","","",null,null],[5,"getpriority","","",null,null],[5,"setpriority","","",null,null],[5,"fdopendir","","",null,null],[5,"mknodat","","",null,null],[5,"mkfifoat","","",null,null],[5,"pthread_condattr_getclock","","",null,null],[5,"pthread_condattr_setclock","","",null,null],[5,"sethostname","","",null,null],[5,"sem_timedwait","","",null,null],[5,"pthread_mutex_timedlock","","",null,null],[5,"pipe2","","",null,null],[5,"ppoll","","",null,null],[5,"__error","","",null,null],[5,"mprotect","","",null,null],[5,"clock_getres","","",null,null],[5,"clock_gettime","","",null,null],[5,"clock_settime","","",null,null],[5,"jail","","",null,null],[5,"jail_attach","","",null,null],[5,"jail_remove","","",null,null],[5,"jail_get","","",null,null],[5,"jail_set","","",null,null],[5,"posix_fallocate","","",null,null],[5,"posix_fadvise","","",null,null],[5,"mkostemp","","",null,null],[5,"mkostemps","","",null,null],[5,"getutxuser","","",null,null],[5,"setutxdb","","",null,null],[5,"aio_waitcomplete","","",null,null],[5,"freelocale","","",null,null],[5,"waitid","","",null,null],[5,"ftok","","",null,null],[5,"shmget","","",null,null],[5,"shmat","","",null,null],[5,"shmdt","","",null,null],[5,"shmctl","","",null,null],[5,"msgctl","","",null,null],[5,"msgget","","",null,null],[5,"msgrcv","","",null,null],[5,"msgsnd","","",null,null],[11,"clone","","",49,{"inputs":[{"name":"self"}],"output":{"name":"stat"}}],[11,"clone","","",40,{"inputs":[{"name":"self"}],"output":{"name":"utmpx"}}],[11,"clone","","",41,{"inputs":[{"name":"self"}],"output":{"name":"aiocb"}}],[11,"clone","","",42,{"inputs":[{"name":"self"}],"output":{"name":"dirent"}}],[11,"clone","","",43,{"inputs":[{"name":"self"}],"output":{"name":"jail"}}],[11,"clone","","",44,{"inputs":[{"name":"self"}],"output":{"name":"sigevent"}}],[11,"clone","","",45,{"inputs":[{"name":"self"}],"output":{"name":"statvfs"}}],[11,"clone","","",50,{"inputs":[{"name":"self"}],"output":{"name":"_sem"}}],[11,"clone","","",46,{"inputs":[{"name":"self"}],"output":{"name":"ipc_perm"}}],[11,"clone","","",47,{"inputs":[{"name":"self"}],"output":{"name":"msqid_ds"}}],[11,"clone","","",48,{"inputs":[{"name":"self"}],"output":{"name":"shmid_ds"}}],[11,"clone","","",26,{"inputs":[{"name":"self"}],"output":{"name":"glob_t"}}],[11,"clone","","",27,{"inputs":[{"name":"self"}],"output":{"name":"kevent"}}],[11,"clone","","",28,{"inputs":[{"name":"self"}],"output":{"name":"sockaddr_storage"}}],[11,"clone","","",29,{"inputs":[{"name":"self"}],"output":{"name":"addrinfo"}}],[11,"clone","","",51,{"inputs":[{"name":"self"}],"output":{"name":"sigset_t"}}],[11,"clone","","",30,{"inputs":[{"name":"self"}],"output":{"name":"siginfo_t"}}],[11,"clone","","",31,{"inputs":[{"name":"self"}],"output":{"name":"sigaction"}}],[11,"clone","","",32,{"inputs":[{"name":"self"}],"output":{"name":"stack_t"}}],[11,"clone","","",33,{"inputs":[{"name":"self"}],"output":{"name":"sched_param"}}],[11,"clone","","",34,{"inputs":[{"name":"self"}],"output":{"name":"dl_info"}}],[11,"clone","","",35,{"inputs":[{"name":"self"}],"output":{"name":"sockaddr_in"}}],[11,"clone","","",36,{"inputs":[{"name":"self"}],"output":{"name":"termios"}}],[11,"clone","","",37,{"inputs":[{"name":"self"}],"output":{"name":"flock"}}],[11,"clone","","",38,{"inputs":[{"name":"self"}],"output":{"name":"sf_hdtr"}}],[11,"clone","","",39,{"inputs":[{"name":"self"}],"output":{"name":"lconv"}}],[11,"clone","","",16,{"inputs":[{"name":"self"}],"output":{"name":"sockaddr"}}],[11,"clone","","",17,{"inputs":[{"name":"self"}],"output":{"name":"sockaddr_in6"}}],[11,"clone","","",18,{"inputs":[{"name":"self"}],"output":{"name":"sockaddr_un"}}],[11,"clone","","",19,{"inputs":[{"name":"self"}],"output":{"name":"passwd"}}],[11,"clone","","",20,{"inputs":[{"name":"self"}],"output":{"name":"ifaddrs"}}],[11,"clone","","",52,{"inputs":[{"name":"self"}],"output":{"name":"fd_set"}}],[11,"clone","","",21,{"inputs":[{"name":"self"}],"output":{"name":"tm"}}],[11,"clone","","",22,{"inputs":[{"name":"self"}],"output":{"name":"utsname"}}],[11,"clone","","",23,{"inputs":[{"name":"self"}],"output":{"name":"msghdr"}}],[11,"clone","","",24,{"inputs":[{"name":"self"}],"output":{"name":"cmsghdr"}}],[11,"clone","","",53,{"inputs":[{"name":"self"}],"output":{"name":"fsid_t"}}],[11,"clone","","",25,{"inputs":[{"name":"self"}],"output":{"name":"if_nameindex"}}],[11,"clone","","",0,{"inputs":[{"name":"self"}],"output":{"name":"group"}}],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"utimbuf"}}],[11,"clone","","",2,{"inputs":[{"name":"self"}],"output":{"name":"timeval"}}],[11,"clone","","",3,{"inputs":[{"name":"self"}],"output":{"name":"timespec"}}],[11,"clone","","",4,{"inputs":[{"name":"self"}],"output":{"name":"rlimit"}}],[11,"clone","","",5,{"inputs":[{"name":"self"}],"output":{"name":"rusage"}}],[11,"clone","","",6,{"inputs":[{"name":"self"}],"output":{"name":"in_addr"}}],[11,"clone","","",7,{"inputs":[{"name":"self"}],"output":{"name":"in6_addr"}}],[11,"clone","","",8,{"inputs":[{"name":"self"}],"output":{"name":"ip_mreq"}}],[11,"clone","","",9,{"inputs":[{"name":"self"}],"output":{"name":"ipv6_mreq"}}],[11,"clone","","",10,{"inputs":[{"name":"self"}],"output":{"name":"hostent"}}],[11,"clone","","",11,{"inputs":[{"name":"self"}],"output":{"name":"iovec"}}],[11,"clone","","",12,{"inputs":[{"name":"self"}],"output":{"name":"pollfd"}}],[11,"clone","","",13,{"inputs":[{"name":"self"}],"output":{"name":"winsize"}}],[11,"clone","","",14,{"inputs":[{"name":"self"}],"output":{"name":"linger"}}],[11,"clone","","",15,{"inputs":[{"name":"self"}],"output":{"name":"sigval"}}],[6,"int8_t","","",null,null],[6,"int16_t","","",null,null],[6,"int32_t","","",null,null],[6,"int64_t","","",null,null],[6,"uint8_t","","",null,null],[6,"uint16_t","","",null,null],[6,"uint32_t","","",null,null],[6,"uint64_t","","",null,null],[6,"c_schar","","",null,null],[6,"c_uchar","","",null,null],[6,"c_short","","",null,null],[6,"c_ushort","","",null,null],[6,"c_int","","",null,null],[6,"c_uint","","",null,null],[6,"c_float","","",null,null],[6,"c_double","","",null,null],[6,"c_longlong","","",null,null],[6,"c_ulonglong","","",null,null],[6,"intmax_t","","",null,null],[6,"uintmax_t","","",null,null],[6,"size_t","","",null,null],[6,"ptrdiff_t","","",null,null],[6,"intptr_t","","",null,null],[6,"uintptr_t","","",null,null],[6,"ssize_t","","",null,null],[6,"pid_t","","",null,null],[6,"uid_t","","",null,null],[6,"gid_t","","",null,null],[6,"in_addr_t","","",null,null],[6,"in_port_t","","",null,null],[6,"sighandler_t","","",null,null],[6,"cc_t","","",null,null],[6,"c_char","","",null,null],[6,"wchar_t","","",null,null],[6,"off_t","","",null,null],[6,"useconds_t","","",null,null],[6,"blkcnt_t","","",null,null],[6,"socklen_t","","",null,null],[6,"sa_family_t","","",null,null],[6,"pthread_t","","",null,null],[6,"nfds_t","","",null,null],[6,"dev_t","","",null,null],[6,"mode_t","","",null,null],[6,"pthread_attr_t","","",null,null],[6,"rlim_t","","",null,null],[6,"pthread_mutex_t","","",null,null],[6,"pthread_mutexattr_t","","",null,null],[6,"pthread_cond_t","","",null,null],[6,"pthread_condattr_t","","",null,null],[6,"pthread_rwlock_t","","",null,null],[6,"pthread_key_t","","",null,null],[6,"tcflag_t","","",null,null],[6,"speed_t","","",null,null],[6,"nl_item","","",null,null],[6,"id_t","","",null,null],[6,"fflags_t","","",null,null],[6,"clock_t","","",null,null],[6,"ino_t","","",null,null],[6,"lwpid_t","","",null,null],[6,"nlink_t","","",null,null],[6,"blksize_t","","",null,null],[6,"clockid_t","","",null,null],[6,"sem_t","","",null,null],[6,"fsblkcnt_t","","",null,null],[6,"fsfilcnt_t","","",null,null],[6,"idtype_t","","",null,null],[6,"key_t","","",null,null],[6,"msglen_t","","",null,null],[6,"msgqnum_t","","",null,null],[6,"c_long","","",null,null],[6,"c_ulong","","",null,null],[6,"time_t","","",null,null],[6,"suseconds_t","","",null,null],[17,"SIG_DFL","","",null,null],[17,"SIG_IGN","","",null,null],[17,"SIG_ERR","","",null,null],[17,"DT_FIFO","","",null,null],[17,"DT_CHR","","",null,null],[17,"DT_DIR","","",null,null],[17,"DT_BLK","","",null,null],[17,"DT_REG","","",null,null],[17,"DT_LNK","","",null,null],[17,"DT_SOCK","","",null,null],[17,"FD_CLOEXEC","","",null,null],[17,"USRQUOTA","","",null,null],[17,"GRPQUOTA","","",null,null],[17,"SIGIOT","","",null,null],[17,"S_ISUID","","",null,null],[17,"S_ISGID","","",null,null],[17,"S_ISVTX","","",null,null],[17,"POLLIN","","",null,null],[17,"POLLPRI","","",null,null],[17,"POLLOUT","","",null,null],[17,"POLLERR","","",null,null],[17,"POLLHUP","","",null,null],[17,"POLLNVAL","","",null,null],[17,"IF_NAMESIZE","","",null,null],[17,"RTLD_LAZY","","",null,null],[17,"LOG_EMERG","","",null,null],[17,"LOG_ALERT","","",null,null],[17,"LOG_CRIT","","",null,null],[17,"LOG_ERR","","",null,null],[17,"LOG_WARNING","","",null,null],[17,"LOG_NOTICE","","",null,null],[17,"LOG_INFO","","",null,null],[17,"LOG_DEBUG","","",null,null],[17,"LOG_KERN","","",null,null],[17,"LOG_USER","","",null,null],[17,"LOG_MAIL","","",null,null],[17,"LOG_DAEMON","","",null,null],[17,"LOG_AUTH","","",null,null],[17,"LOG_SYSLOG","","",null,null],[17,"LOG_LPR","","",null,null],[17,"LOG_NEWS","","",null,null],[17,"LOG_UUCP","","",null,null],[17,"LOG_LOCAL0","","",null,null],[17,"LOG_LOCAL1","","",null,null],[17,"LOG_LOCAL2","","",null,null],[17,"LOG_LOCAL3","","",null,null],[17,"LOG_LOCAL4","","",null,null],[17,"LOG_LOCAL5","","",null,null],[17,"LOG_LOCAL6","","",null,null],[17,"LOG_LOCAL7","","",null,null],[17,"LOG_PID","","",null,null],[17,"LOG_CONS","","",null,null],[17,"LOG_ODELAY","","",null,null],[17,"LOG_NDELAY","","",null,null],[17,"LOG_NOWAIT","","",null,null],[17,"LOG_PRIMASK","","",null,null],[17,"LOG_FACMASK","","",null,null],[17,"PRIO_PROCESS","","",null,null],[17,"PRIO_PGRP","","",null,null],[17,"PRIO_USER","","",null,null],[17,"PRIO_MIN","","",null,null],[17,"PRIO_MAX","","",null,null],[17,"LC_ALL","","",null,null],[17,"LC_COLLATE","","",null,null],[17,"LC_CTYPE","","",null,null],[17,"LC_MONETARY","","",null,null],[17,"LC_NUMERIC","","",null,null],[17,"LC_TIME","","",null,null],[17,"LC_MESSAGES","","",null,null],[17,"FIOCLEX","","",null,null],[17,"FIONBIO","","",null,null],[17,"PATH_MAX","","",null,null],[17,"SA_ONSTACK","","",null,null],[17,"SA_SIGINFO","","",null,null],[17,"SA_RESTART","","",null,null],[17,"SA_RESETHAND","","",null,null],[17,"SA_NOCLDSTOP","","",null,null],[17,"SA_NODEFER","","",null,null],[17,"SA_NOCLDWAIT","","",null,null],[17,"SS_ONSTACK","","",null,null],[17,"SS_DISABLE","","",null,null],[17,"SIGCHLD","","",null,null],[17,"SIGBUS","","",null,null],[17,"SIGUSR1","","",null,null],[17,"SIGUSR2","","",null,null],[17,"SIGCONT","","",null,null],[17,"SIGSTOP","","",null,null],[17,"SIGTSTP","","",null,null],[17,"SIGURG","","",null,null],[17,"SIGIO","","",null,null],[17,"SIGSYS","","",null,null],[17,"SIGTTIN","","",null,null],[17,"SIGTTOU","","",null,null],[17,"SIGXCPU","","",null,null],[17,"SIGXFSZ","","",null,null],[17,"SIGVTALRM","","",null,null],[17,"SIGPROF","","",null,null],[17,"SIGWINCH","","",null,null],[17,"SIGINFO","","",null,null],[17,"SIG_SETMASK","","",null,null],[17,"SIG_BLOCK","","",null,null],[17,"SIG_UNBLOCK","","",null,null],[17,"IPV6_MULTICAST_LOOP","","",null,null],[17,"IPV6_V6ONLY","","",null,null],[17,"ST_RDONLY","","",null,null],[17,"NCCS","","",null,null],[17,"O_ASYNC","","",null,null],[17,"O_FSYNC","","",null,null],[17,"O_NDELAY","","",null,null],[17,"O_NOFOLLOW","","",null,null],[17,"F_GETOWN","","",null,null],[17,"F_SETOWN","","",null,null],[17,"MNT_FORCE","","",null,null],[17,"Q_SYNC","","",null,null],[17,"Q_QUOTAON","","",null,null],[17,"Q_QUOTAOFF","","",null,null],[17,"TCIOFF","","",null,null],[17,"TCION","","",null,null],[17,"TCOOFF","","",null,null],[17,"TCOON","","",null,null],[17,"TCIFLUSH","","",null,null],[17,"TCOFLUSH","","",null,null],[17,"TCIOFLUSH","","",null,null],[17,"TCSANOW","","",null,null],[17,"TCSADRAIN","","",null,null],[17,"TCSAFLUSH","","",null,null],[17,"VEOF","","",null,null],[17,"VEOL","","",null,null],[17,"VEOL2","","",null,null],[17,"VERASE","","",null,null],[17,"VWERASE","","",null,null],[17,"VKILL","","",null,null],[17,"VREPRINT","","",null,null],[17,"VINTR","","",null,null],[17,"VQUIT","","",null,null],[17,"VSUSP","","",null,null],[17,"VSTART","","",null,null],[17,"VSTOP","","",null,null],[17,"VLNEXT","","",null,null],[17,"VDISCARD","","",null,null],[17,"VMIN","","",null,null],[17,"VTIME","","",null,null],[17,"IGNBRK","","",null,null],[17,"BRKINT","","",null,null],[17,"IGNPAR","","",null,null],[17,"PARMRK","","",null,null],[17,"INPCK","","",null,null],[17,"ISTRIP","","",null,null],[17,"INLCR","","",null,null],[17,"IGNCR","","",null,null],[17,"ICRNL","","",null,null],[17,"IXON","","",null,null],[17,"IXOFF","","",null,null],[17,"IXANY","","",null,null],[17,"IMAXBEL","","",null,null],[17,"OPOST","","",null,null],[17,"ONLCR","","",null,null],[17,"OXTABS","","",null,null],[17,"ONOEOT","","",null,null],[17,"CSIZE","","",null,null],[17,"CS5","","",null,null],[17,"CS6","","",null,null],[17,"CS7","","",null,null],[17,"CS8","","",null,null],[17,"CSTOPB","","",null,null],[17,"CREAD","","",null,null],[17,"PARENB","","",null,null],[17,"PARODD","","",null,null],[17,"HUPCL","","",null,null],[17,"CLOCAL","","",null,null],[17,"ECHOKE","","",null,null],[17,"ECHOE","","",null,null],[17,"ECHOK","","",null,null],[17,"ECHO","","",null,null],[17,"ECHONL","","",null,null],[17,"ECHOPRT","","",null,null],[17,"ECHOCTL","","",null,null],[17,"ISIG","","",null,null],[17,"ICANON","","",null,null],[17,"IEXTEN","","",null,null],[17,"EXTPROC","","",null,null],[17,"TOSTOP","","",null,null],[17,"FLUSHO","","",null,null],[17,"PENDIN","","",null,null],[17,"NOFLSH","","",null,null],[17,"WNOHANG","","",null,null],[17,"WUNTRACED","","",null,null],[17,"RTLD_NOW","","",null,null],[17,"RTLD_DEFAULT","","",null,null],[17,"LOG_CRON","","",null,null],[17,"LOG_AUTHPRIV","","",null,null],[17,"LOG_FTP","","",null,null],[17,"LOG_PERROR","","",null,null],[17,"PIPE_BUF","","",null,null],[17,"AIO_LISTIO_MAX","","",null,null],[17,"AIO_CANCELED","","",null,null],[17,"AIO_NOTCANCELED","","",null,null],[17,"AIO_ALLDONE","","",null,null],[17,"LIO_NOP","","",null,null],[17,"LIO_WRITE","","",null,null],[17,"LIO_READ","","",null,null],[17,"LIO_WAIT","","",null,null],[17,"LIO_NOWAIT","","",null,null],[17,"SIGEV_NONE","","",null,null],[17,"SIGEV_SIGNAL","","",null,null],[17,"SIGEV_THREAD","","",null,null],[17,"SIGEV_KEVENT","","",null,null],[17,"CODESET","","",null,null],[17,"D_T_FMT","","",null,null],[17,"D_FMT","","",null,null],[17,"T_FMT","","",null,null],[17,"T_FMT_AMPM","","",null,null],[17,"AM_STR","","",null,null],[17,"PM_STR","","",null,null],[17,"DAY_1","","",null,null],[17,"DAY_2","","",null,null],[17,"DAY_3","","",null,null],[17,"DAY_4","","",null,null],[17,"DAY_5","","",null,null],[17,"DAY_6","","",null,null],[17,"DAY_7","","",null,null],[17,"ABDAY_1","","",null,null],[17,"ABDAY_2","","",null,null],[17,"ABDAY_3","","",null,null],[17,"ABDAY_4","","",null,null],[17,"ABDAY_5","","",null,null],[17,"ABDAY_6","","",null,null],[17,"ABDAY_7","","",null,null],[17,"MON_1","","",null,null],[17,"MON_2","","",null,null],[17,"MON_3","","",null,null],[17,"MON_4","","",null,null],[17,"MON_5","","",null,null],[17,"MON_6","","",null,null],[17,"MON_7","","",null,null],[17,"MON_8","","",null,null],[17,"MON_9","","",null,null],[17,"MON_10","","",null,null],[17,"MON_11","","",null,null],[17,"MON_12","","",null,null],[17,"ABMON_1","","",null,null],[17,"ABMON_2","","",null,null],[17,"ABMON_3","","",null,null],[17,"ABMON_4","","",null,null],[17,"ABMON_5","","",null,null],[17,"ABMON_6","","",null,null],[17,"ABMON_7","","",null,null],[17,"ABMON_8","","",null,null],[17,"ABMON_9","","",null,null],[17,"ABMON_10","","",null,null],[17,"ABMON_11","","",null,null],[17,"ABMON_12","","",null,null],[17,"ERA","","",null,null],[17,"ERA_D_FMT","","",null,null],[17,"ERA_D_T_FMT","","",null,null],[17,"ERA_T_FMT","","",null,null],[17,"ALT_DIGITS","","",null,null],[17,"RADIXCHAR","","",null,null],[17,"THOUSEP","","",null,null],[17,"YESEXPR","","",null,null],[17,"NOEXPR","","",null,null],[17,"YESSTR","","",null,null],[17,"NOSTR","","",null,null],[17,"CRNCYSTR","","",null,null],[17,"D_MD_ORDER","","",null,null],[17,"ALTMON_1","","",null,null],[17,"ALTMON_2","","",null,null],[17,"ALTMON_3","","",null,null],[17,"ALTMON_4","","",null,null],[17,"ALTMON_5","","",null,null],[17,"ALTMON_6","","",null,null],[17,"ALTMON_7","","",null,null],[17,"ALTMON_8","","",null,null],[17,"ALTMON_9","","",null,null],[17,"ALTMON_10","","",null,null],[17,"ALTMON_11","","",null,null],[17,"ALTMON_12","","",null,null],[17,"EXIT_FAILURE","","",null,null],[17,"EXIT_SUCCESS","","",null,null],[17,"EOF","","",null,null],[17,"SEEK_SET","","",null,null],[17,"SEEK_CUR","","",null,null],[17,"SEEK_END","","",null,null],[17,"_IOFBF","","",null,null],[17,"_IONBF","","",null,null],[17,"_IOLBF","","",null,null],[17,"BUFSIZ","","",null,null],[17,"FOPEN_MAX","","",null,null],[17,"FILENAME_MAX","","",null,null],[17,"L_tmpnam","","",null,null],[17,"TMP_MAX","","",null,null],[17,"O_RDONLY","","",null,null],[17,"O_WRONLY","","",null,null],[17,"O_RDWR","","",null,null],[17,"O_ACCMODE","","",null,null],[17,"O_APPEND","","",null,null],[17,"O_CREAT","","",null,null],[17,"O_EXCL","","",null,null],[17,"O_NOCTTY","","",null,null],[17,"O_TRUNC","","",null,null],[17,"S_IFIFO","","",null,null],[17,"S_IFCHR","","",null,null],[17,"S_IFBLK","","",null,null],[17,"S_IFDIR","","",null,null],[17,"S_IFREG","","",null,null],[17,"S_IFLNK","","",null,null],[17,"S_IFSOCK","","",null,null],[17,"S_IFMT","","",null,null],[17,"S_IEXEC","","",null,null],[17,"S_IWRITE","","",null,null],[17,"S_IREAD","","",null,null],[17,"S_IRWXU","","",null,null],[17,"S_IXUSR","","",null,null],[17,"S_IWUSR","","",null,null],[17,"S_IRUSR","","",null,null],[17,"S_IRWXG","","",null,null],[17,"S_IXGRP","","",null,null],[17,"S_IWGRP","","",null,null],[17,"S_IRGRP","","",null,null],[17,"S_IRWXO","","",null,null],[17,"S_IXOTH","","",null,null],[17,"S_IWOTH","","",null,null],[17,"S_IROTH","","",null,null],[17,"F_OK","","",null,null],[17,"R_OK","","",null,null],[17,"W_OK","","",null,null],[17,"X_OK","","",null,null],[17,"STDIN_FILENO","","",null,null],[17,"STDOUT_FILENO","","",null,null],[17,"STDERR_FILENO","","",null,null],[17,"F_LOCK","","",null,null],[17,"F_TEST","","",null,null],[17,"F_TLOCK","","",null,null],[17,"F_ULOCK","","",null,null],[17,"F_DUPFD_CLOEXEC","","",null,null],[17,"SIGHUP","","",null,null],[17,"SIGINT","","",null,null],[17,"SIGQUIT","","",null,null],[17,"SIGILL","","",null,null],[17,"SIGABRT","","",null,null],[17,"SIGEMT","","",null,null],[17,"SIGFPE","","",null,null],[17,"SIGKILL","","",null,null],[17,"SIGSEGV","","",null,null],[17,"SIGPIPE","","",null,null],[17,"SIGALRM","","",null,null],[17,"SIGTERM","","",null,null],[17,"PROT_NONE","","",null,null],[17,"PROT_READ","","",null,null],[17,"PROT_WRITE","","",null,null],[17,"PROT_EXEC","","",null,null],[17,"MAP_FILE","","",null,null],[17,"MAP_SHARED","","",null,null],[17,"MAP_PRIVATE","","",null,null],[17,"MAP_FIXED","","",null,null],[17,"MAP_ANON","","",null,null],[17,"MAP_FAILED","","",null,null],[17,"MCL_CURRENT","","",null,null],[17,"MCL_FUTURE","","",null,null],[17,"MS_SYNC","","",null,null],[17,"MS_ASYNC","","",null,null],[17,"MS_INVALIDATE","","",null,null],[17,"EPERM","","",null,null],[17,"ENOENT","","",null,null],[17,"ESRCH","","",null,null],[17,"EINTR","","",null,null],[17,"EIO","","",null,null],[17,"ENXIO","","",null,null],[17,"E2BIG","","",null,null],[17,"ENOEXEC","","",null,null],[17,"EBADF","","",null,null],[17,"ECHILD","","",null,null],[17,"EDEADLK","","",null,null],[17,"ENOMEM","","",null,null],[17,"EACCES","","",null,null],[17,"EFAULT","","",null,null],[17,"ENOTBLK","","",null,null],[17,"EBUSY","","",null,null],[17,"EEXIST","","",null,null],[17,"EXDEV","","",null,null],[17,"ENODEV","","",null,null],[17,"ENOTDIR","","",null,null],[17,"EISDIR","","",null,null],[17,"EINVAL","","",null,null],[17,"ENFILE","","",null,null],[17,"EMFILE","","",null,null],[17,"ENOTTY","","",null,null],[17,"ETXTBSY","","",null,null],[17,"EFBIG","","",null,null],[17,"ENOSPC","","",null,null],[17,"ESPIPE","","",null,null],[17,"EROFS","","",null,null],[17,"EMLINK","","",null,null],[17,"EPIPE","","",null,null],[17,"EDOM","","",null,null],[17,"ERANGE","","",null,null],[17,"EAGAIN","","",null,null],[17,"EWOULDBLOCK","","",null,null],[17,"EINPROGRESS","","",null,null],[17,"EALREADY","","",null,null],[17,"ENOTSOCK","","",null,null],[17,"EDESTADDRREQ","","",null,null],[17,"EMSGSIZE","","",null,null],[17,"EPROTOTYPE","","",null,null],[17,"ENOPROTOOPT","","",null,null],[17,"EPROTONOSUPPORT","","",null,null],[17,"ESOCKTNOSUPPORT","","",null,null],[17,"EOPNOTSUPP","","",null,null],[17,"ENOTSUP","","",null,null],[17,"EPFNOSUPPORT","","",null,null],[17,"EAFNOSUPPORT","","",null,null],[17,"EADDRINUSE","","",null,null],[17,"EADDRNOTAVAIL","","",null,null],[17,"ENETDOWN","","",null,null],[17,"ENETUNREACH","","",null,null],[17,"ENETRESET","","",null,null],[17,"ECONNABORTED","","",null,null],[17,"ECONNRESET","","",null,null],[17,"ENOBUFS","","",null,null],[17,"EISCONN","","",null,null],[17,"ENOTCONN","","",null,null],[17,"ESHUTDOWN","","",null,null],[17,"ETOOMANYREFS","","",null,null],[17,"ETIMEDOUT","","",null,null],[17,"ECONNREFUSED","","",null,null],[17,"ELOOP","","",null,null],[17,"ENAMETOOLONG","","",null,null],[17,"EHOSTDOWN","","",null,null],[17,"EHOSTUNREACH","","",null,null],[17,"ENOTEMPTY","","",null,null],[17,"EPROCLIM","","",null,null],[17,"EUSERS","","",null,null],[17,"EDQUOT","","",null,null],[17,"ESTALE","","",null,null],[17,"EREMOTE","","",null,null],[17,"EBADRPC","","",null,null],[17,"ERPCMISMATCH","","",null,null],[17,"EPROGUNAVAIL","","",null,null],[17,"EPROGMISMATCH","","",null,null],[17,"EPROCUNAVAIL","","",null,null],[17,"ENOLCK","","",null,null],[17,"ENOSYS","","",null,null],[17,"EFTYPE","","",null,null],[17,"EAUTH","","",null,null],[17,"ENEEDAUTH","","",null,null],[17,"EIDRM","","",null,null],[17,"ENOMSG","","",null,null],[17,"EOVERFLOW","","",null,null],[17,"ECANCELED","","",null,null],[17,"EILSEQ","","",null,null],[17,"ENOATTR","","",null,null],[17,"EDOOFUS","","",null,null],[17,"EBADMSG","","",null,null],[17,"EMULTIHOP","","",null,null],[17,"ENOLINK","","",null,null],[17,"EPROTO","","",null,null],[17,"EAI_SYSTEM","","",null,null],[17,"F_DUPFD","","",null,null],[17,"F_GETFD","","",null,null],[17,"F_SETFD","","",null,null],[17,"F_GETFL","","",null,null],[17,"F_SETFL","","",null,null],[17,"AT_EACCESS","","",null,null],[17,"AT_SYMLINK_NOFOLLOW","","",null,null],[17,"AT_SYMLINK_FOLLOW","","",null,null],[17,"AT_REMOVEDIR","","",null,null],[17,"SIGTRAP","","",null,null],[17,"GLOB_APPEND","","",null,null],[17,"GLOB_DOOFFS","","",null,null],[17,"GLOB_ERR","","",null,null],[17,"GLOB_MARK","","",null,null],[17,"GLOB_NOCHECK","","",null,null],[17,"GLOB_NOSORT","","",null,null],[17,"GLOB_NOESCAPE","","",null,null],[17,"GLOB_NOSPACE","","",null,null],[17,"GLOB_ABORTED","","",null,null],[17,"GLOB_NOMATCH","","",null,null],[17,"POSIX_MADV_NORMAL","","",null,null],[17,"POSIX_MADV_RANDOM","","",null,null],[17,"POSIX_MADV_SEQUENTIAL","","",null,null],[17,"POSIX_MADV_WILLNEED","","",null,null],[17,"POSIX_MADV_DONTNEED","","",null,null],[17,"_SC_IOV_MAX","","",null,null],[17,"_SC_GETGR_R_SIZE_MAX","","",null,null],[17,"_SC_GETPW_R_SIZE_MAX","","",null,null],[17,"_SC_LOGIN_NAME_MAX","","",null,null],[17,"_SC_MQ_PRIO_MAX","","",null,null],[17,"_SC_NPROCESSORS_ONLN","","",null,null],[17,"_SC_THREAD_ATTR_STACKADDR","","",null,null],[17,"_SC_THREAD_ATTR_STACKSIZE","","",null,null],[17,"_SC_THREAD_DESTRUCTOR_ITERATIONS","","",null,null],[17,"_SC_THREAD_KEYS_MAX","","",null,null],[17,"_SC_THREAD_PRIO_INHERIT","","",null,null],[17,"_SC_THREAD_PRIO_PROTECT","","",null,null],[17,"_SC_THREAD_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_THREAD_PROCESS_SHARED","","",null,null],[17,"_SC_THREAD_SAFE_FUNCTIONS","","",null,null],[17,"_SC_THREAD_STACK_MIN","","",null,null],[17,"_SC_THREAD_THREADS_MAX","","",null,null],[17,"_SC_THREADS","","",null,null],[17,"_SC_TTY_NAME_MAX","","",null,null],[17,"_SC_ATEXIT_MAX","","",null,null],[17,"_SC_XOPEN_CRYPT","","",null,null],[17,"_SC_XOPEN_ENH_I18N","","",null,null],[17,"_SC_XOPEN_LEGACY","","",null,null],[17,"_SC_XOPEN_REALTIME","","",null,null],[17,"_SC_XOPEN_REALTIME_THREADS","","",null,null],[17,"_SC_XOPEN_SHM","","",null,null],[17,"_SC_XOPEN_UNIX","","",null,null],[17,"_SC_XOPEN_VERSION","","",null,null],[17,"_SC_XOPEN_XCU_VERSION","","",null,null],[17,"PTHREAD_CREATE_JOINABLE","","",null,null],[17,"PTHREAD_CREATE_DETACHED","","",null,null],[17,"RLIMIT_CPU","","",null,null],[17,"RLIMIT_FSIZE","","",null,null],[17,"RLIMIT_DATA","","",null,null],[17,"RLIMIT_STACK","","",null,null],[17,"RLIMIT_CORE","","",null,null],[17,"RLIMIT_RSS","","",null,null],[17,"RLIMIT_MEMLOCK","","",null,null],[17,"RLIMIT_NPROC","","",null,null],[17,"RLIMIT_NOFILE","","",null,null],[17,"RLIMIT_SBSIZE","","",null,null],[17,"RLIMIT_VMEM","","",null,null],[17,"RLIMIT_AS","","",null,null],[17,"RLIM_INFINITY","","",null,null],[17,"RUSAGE_SELF","","",null,null],[17,"RUSAGE_CHILDREN","","",null,null],[17,"MADV_NORMAL","","",null,null],[17,"MADV_RANDOM","","",null,null],[17,"MADV_SEQUENTIAL","","",null,null],[17,"MADV_WILLNEED","","",null,null],[17,"MADV_DONTNEED","","",null,null],[17,"MADV_FREE","","",null,null],[17,"MADV_NOSYNC","","",null,null],[17,"MADV_AUTOSYNC","","",null,null],[17,"MADV_NOCORE","","",null,null],[17,"MADV_CORE","","",null,null],[17,"MINCORE_INCORE","","",null,null],[17,"MINCORE_REFERENCED","","",null,null],[17,"MINCORE_MODIFIED","","",null,null],[17,"MINCORE_REFERENCED_OTHER","","",null,null],[17,"MINCORE_MODIFIED_OTHER","","",null,null],[17,"MINCORE_SUPER","","",null,null],[17,"AF_UNSPEC","","",null,null],[17,"AF_LOCAL","","",null,null],[17,"AF_UNIX","","",null,null],[17,"AF_INET","","",null,null],[17,"AF_IMPLINK","","",null,null],[17,"AF_PUP","","",null,null],[17,"AF_CHAOS","","",null,null],[17,"AF_NETBIOS","","",null,null],[17,"AF_ISO","","",null,null],[17,"AF_OSI","","",null,null],[17,"AF_ECMA","","",null,null],[17,"AF_DATAKIT","","",null,null],[17,"AF_CCITT","","",null,null],[17,"AF_SNA","","",null,null],[17,"AF_DECnet","","",null,null],[17,"AF_DLI","","",null,null],[17,"AF_LAT","","",null,null],[17,"AF_HYLINK","","",null,null],[17,"AF_APPLETALK","","",null,null],[17,"AF_ROUTE","","",null,null],[17,"AF_LINK","","",null,null],[17,"pseudo_AF_XTP","","",null,null],[17,"AF_COIP","","",null,null],[17,"AF_CNT","","",null,null],[17,"pseudo_AF_RTIP","","",null,null],[17,"AF_IPX","","",null,null],[17,"AF_SIP","","",null,null],[17,"pseudo_AF_PIP","","",null,null],[17,"AF_ISDN","","",null,null],[17,"AF_E164","","",null,null],[17,"pseudo_AF_KEY","","",null,null],[17,"AF_INET6","","",null,null],[17,"AF_NATM","","",null,null],[17,"AF_ATM","","",null,null],[17,"pseudo_AF_HDRCMPLT","","",null,null],[17,"AF_NETGRAPH","","",null,null],[17,"PF_UNSPEC","","",null,null],[17,"PF_LOCAL","","",null,null],[17,"PF_UNIX","","",null,null],[17,"PF_INET","","",null,null],[17,"PF_IMPLINK","","",null,null],[17,"PF_PUP","","",null,null],[17,"PF_CHAOS","","",null,null],[17,"PF_NETBIOS","","",null,null],[17,"PF_ISO","","",null,null],[17,"PF_OSI","","",null,null],[17,"PF_ECMA","","",null,null],[17,"PF_DATAKIT","","",null,null],[17,"PF_CCITT","","",null,null],[17,"PF_SNA","","",null,null],[17,"PF_DECnet","","",null,null],[17,"PF_DLI","","",null,null],[17,"PF_LAT","","",null,null],[17,"PF_HYLINK","","",null,null],[17,"PF_APPLETALK","","",null,null],[17,"PF_ROUTE","","",null,null],[17,"PF_LINK","","",null,null],[17,"PF_XTP","","",null,null],[17,"PF_COIP","","",null,null],[17,"PF_CNT","","",null,null],[17,"PF_SIP","","",null,null],[17,"PF_IPX","","",null,null],[17,"PF_RTIP","","",null,null],[17,"PF_PIP","","",null,null],[17,"PF_ISDN","","",null,null],[17,"PF_KEY","","",null,null],[17,"PF_INET6","","",null,null],[17,"PF_NATM","","",null,null],[17,"PF_ATM","","",null,null],[17,"PF_NETGRAPH","","",null,null],[17,"SOMAXCONN","","",null,null],[17,"MSG_OOB","","",null,null],[17,"MSG_PEEK","","",null,null],[17,"MSG_DONTROUTE","","",null,null],[17,"MSG_EOR","","",null,null],[17,"MSG_TRUNC","","",null,null],[17,"MSG_CTRUNC","","",null,null],[17,"MSG_WAITALL","","",null,null],[17,"MSG_DONTWAIT","","",null,null],[17,"MSG_EOF","","",null,null],[17,"SOCK_STREAM","","",null,null],[17,"SOCK_DGRAM","","",null,null],[17,"SOCK_RAW","","",null,null],[17,"SOCK_RDM","","",null,null],[17,"SOCK_SEQPACKET","","",null,null],[17,"SOCK_CLOEXEC","","",null,null],[17,"SOCK_NONBLOCK","","",null,null],[17,"SOCK_MAXADDRLEN","","",null,null],[17,"IPPROTO_ICMP","","",null,null],[17,"IPPROTO_ICMPV6","","",null,null],[17,"IPPROTO_TCP","","",null,null],[17,"IPPROTO_IP","","",null,null],[17,"IPPROTO_IPV6","","",null,null],[17,"IP_MULTICAST_TTL","","",null,null],[17,"IP_MULTICAST_LOOP","","",null,null],[17,"IP_TTL","","",null,null],[17,"IP_HDRINCL","","",null,null],[17,"IP_ADD_MEMBERSHIP","","",null,null],[17,"IP_DROP_MEMBERSHIP","","",null,null],[17,"IPV6_JOIN_GROUP","","",null,null],[17,"IPV6_LEAVE_GROUP","","",null,null],[17,"TCP_NODELAY","","",null,null],[17,"TCP_KEEPIDLE","","",null,null],[17,"SOL_SOCKET","","",null,null],[17,"SO_DEBUG","","",null,null],[17,"SO_ACCEPTCONN","","",null,null],[17,"SO_REUSEADDR","","",null,null],[17,"SO_KEEPALIVE","","",null,null],[17,"SO_DONTROUTE","","",null,null],[17,"SO_BROADCAST","","",null,null],[17,"SO_USELOOPBACK","","",null,null],[17,"SO_LINGER","","",null,null],[17,"SO_OOBINLINE","","",null,null],[17,"SO_REUSEPORT","","",null,null],[17,"SO_TIMESTAMP","","",null,null],[17,"SO_NOSIGPIPE","","",null,null],[17,"SO_ACCEPTFILTER","","",null,null],[17,"SO_SNDBUF","","",null,null],[17,"SO_RCVBUF","","",null,null],[17,"SO_SNDLOWAT","","",null,null],[17,"SO_RCVLOWAT","","",null,null],[17,"SO_SNDTIMEO","","",null,null],[17,"SO_RCVTIMEO","","",null,null],[17,"SO_ERROR","","",null,null],[17,"SO_TYPE","","",null,null],[17,"IFF_LOOPBACK","","",null,null],[17,"SHUT_RD","","",null,null],[17,"SHUT_WR","","",null,null],[17,"SHUT_RDWR","","",null,null],[17,"LOCK_SH","","",null,null],[17,"LOCK_EX","","",null,null],[17,"LOCK_NB","","",null,null],[17,"LOCK_UN","","",null,null],[17,"O_SYNC","","",null,null],[17,"O_NONBLOCK","","",null,null],[17,"MAP_COPY","","",null,null],[17,"MAP_RENAME","","",null,null],[17,"MAP_NORESERVE","","",null,null],[17,"MAP_HASSEMAPHORE","","",null,null],[17,"MAP_STACK","","",null,null],[17,"MAP_NOSYNC","","",null,null],[17,"MAP_NOCORE","","",null,null],[17,"IPPROTO_RAW","","",null,null],[17,"_SC_ARG_MAX","","",null,null],[17,"_SC_CHILD_MAX","","",null,null],[17,"_SC_CLK_TCK","","",null,null],[17,"_SC_NGROUPS_MAX","","",null,null],[17,"_SC_OPEN_MAX","","",null,null],[17,"_SC_JOB_CONTROL","","",null,null],[17,"_SC_SAVED_IDS","","",null,null],[17,"_SC_VERSION","","",null,null],[17,"_SC_BC_BASE_MAX","","",null,null],[17,"_SC_BC_DIM_MAX","","",null,null],[17,"_SC_BC_SCALE_MAX","","",null,null],[17,"_SC_BC_STRING_MAX","","",null,null],[17,"_SC_COLL_WEIGHTS_MAX","","",null,null],[17,"_SC_EXPR_NEST_MAX","","",null,null],[17,"_SC_LINE_MAX","","",null,null],[17,"_SC_RE_DUP_MAX","","",null,null],[17,"_SC_2_VERSION","","",null,null],[17,"_SC_2_C_BIND","","",null,null],[17,"_SC_2_C_DEV","","",null,null],[17,"_SC_2_CHAR_TERM","","",null,null],[17,"_SC_2_FORT_DEV","","",null,null],[17,"_SC_2_FORT_RUN","","",null,null],[17,"_SC_2_LOCALEDEF","","",null,null],[17,"_SC_2_SW_DEV","","",null,null],[17,"_SC_2_UPE","","",null,null],[17,"_SC_STREAM_MAX","","",null,null],[17,"_SC_TZNAME_MAX","","",null,null],[17,"_SC_ASYNCHRONOUS_IO","","",null,null],[17,"_SC_MAPPED_FILES","","",null,null],[17,"_SC_MEMLOCK","","",null,null],[17,"_SC_MEMLOCK_RANGE","","",null,null],[17,"_SC_MEMORY_PROTECTION","","",null,null],[17,"_SC_MESSAGE_PASSING","","",null,null],[17,"_SC_PRIORITIZED_IO","","",null,null],[17,"_SC_PRIORITY_SCHEDULING","","",null,null],[17,"_SC_REALTIME_SIGNALS","","",null,null],[17,"_SC_SEMAPHORES","","",null,null],[17,"_SC_FSYNC","","",null,null],[17,"_SC_SHARED_MEMORY_OBJECTS","","",null,null],[17,"_SC_SYNCHRONIZED_IO","","",null,null],[17,"_SC_TIMERS","","",null,null],[17,"_SC_AIO_LISTIO_MAX","","",null,null],[17,"_SC_AIO_MAX","","",null,null],[17,"_SC_AIO_PRIO_DELTA_MAX","","",null,null],[17,"_SC_DELAYTIMER_MAX","","",null,null],[17,"_SC_MQ_OPEN_MAX","","",null,null],[17,"_SC_PAGESIZE","","",null,null],[17,"_SC_PAGE_SIZE","","",null,null],[17,"_SC_RTSIG_MAX","","",null,null],[17,"_SC_SEM_NSEMS_MAX","","",null,null],[17,"_SC_SEM_VALUE_MAX","","",null,null],[17,"_SC_SIGQUEUE_MAX","","",null,null],[17,"_SC_TIMER_MAX","","",null,null],[17,"_SC_HOST_NAME_MAX","","",null,null],[17,"PTHREAD_MUTEX_INITIALIZER","","",null,null],[17,"PTHREAD_COND_INITIALIZER","","",null,null],[17,"PTHREAD_RWLOCK_INITIALIZER","","",null,null],[17,"PTHREAD_MUTEX_ERRORCHECK","","",null,null],[17,"PTHREAD_MUTEX_RECURSIVE","","",null,null],[17,"PTHREAD_MUTEX_NORMAL","","",null,null],[17,"PTHREAD_MUTEX_DEFAULT","","",null,null],[17,"SCHED_FIFO","","",null,null],[17,"SCHED_OTHER","","",null,null],[17,"SCHED_RR","","",null,null],[17,"FD_SETSIZE","","",null,null],[17,"ST_NOSUID","","",null,null],[17,"NI_MAXHOST","","",null,null],[17,"RTLD_LOCAL","","",null,null],[17,"RTLD_NODELETE","","",null,null],[17,"RTLD_NOLOAD","","",null,null],[17,"RTLD_GLOBAL","","",null,null],[17,"LOG_NTP","","",null,null],[17,"LOG_SECURITY","","",null,null],[17,"LOG_CONSOLE","","",null,null],[17,"LOG_NFACILITIES","","",null,null],[17,"TIOCEXCL","","",null,null],[17,"TIOCNXCL","","",null,null],[17,"TIOCFLUSH","","",null,null],[17,"TIOCGETA","","",null,null],[17,"TIOCSETA","","",null,null],[17,"TIOCSETAW","","",null,null],[17,"TIOCSETAF","","",null,null],[17,"TIOCGETD","","",null,null],[17,"TIOCSETD","","",null,null],[17,"TIOCGDRAINWAIT","","",null,null],[17,"TIOCSDRAINWAIT","","",null,null],[17,"TIOCTIMESTAMP","","",null,null],[17,"TIOCMGDTRWAIT","","",null,null],[17,"TIOCMSDTRWAIT","","",null,null],[17,"TIOCDRAIN","","",null,null],[17,"TIOCEXT","","",null,null],[17,"TIOCSCTTY","","",null,null],[17,"TIOCCONS","","",null,null],[17,"TIOCGSID","","",null,null],[17,"TIOCSTAT","","",null,null],[17,"TIOCUCNTL","","",null,null],[17,"TIOCSWINSZ","","",null,null],[17,"TIOCGWINSZ","","",null,null],[17,"TIOCMGET","","",null,null],[17,"TIOCM_LE","","",null,null],[17,"TIOCM_DTR","","",null,null],[17,"TIOCM_RTS","","",null,null],[17,"TIOCM_ST","","",null,null],[17,"TIOCM_SR","","",null,null],[17,"TIOCM_CTS","","",null,null],[17,"TIOCM_RI","","",null,null],[17,"TIOCM_DSR","","",null,null],[17,"TIOCM_CD","","",null,null],[17,"TIOCM_CAR","","",null,null],[17,"TIOCM_RNG","","",null,null],[17,"TIOCMBIC","","",null,null],[17,"TIOCMBIS","","",null,null],[17,"TIOCMSET","","",null,null],[17,"TIOCSTART","","",null,null],[17,"TIOCSTOP","","",null,null],[17,"TIOCPKT","","",null,null],[17,"TIOCPKT_DATA","","",null,null],[17,"TIOCPKT_FLUSHREAD","","",null,null],[17,"TIOCPKT_FLUSHWRITE","","",null,null],[17,"TIOCPKT_STOP","","",null,null],[17,"TIOCPKT_START","","",null,null],[17,"TIOCPKT_NOSTOP","","",null,null],[17,"TIOCPKT_DOSTOP","","",null,null],[17,"TIOCPKT_IOCTL","","",null,null],[17,"TIOCNOTTY","","",null,null],[17,"TIOCSTI","","",null,null],[17,"TIOCOUTQ","","",null,null],[17,"TIOCSPGRP","","",null,null],[17,"TIOCGPGRP","","",null,null],[17,"TIOCCDTR","","",null,null],[17,"TIOCSDTR","","",null,null],[17,"TIOCCBRK","","",null,null],[17,"TIOCSBRK","","",null,null],[17,"TTYDISC","","",null,null],[17,"SLIPDISC","","",null,null],[17,"PPPDISC","","",null,null],[17,"NETGRAPHDISC","","",null,null],[17,"B0","","",null,null],[17,"B50","","",null,null],[17,"B75","","",null,null],[17,"B110","","",null,null],[17,"B134","","",null,null],[17,"B150","","",null,null],[17,"B200","","",null,null],[17,"B300","","",null,null],[17,"B600","","",null,null],[17,"B1200","","",null,null],[17,"B1800","","",null,null],[17,"B2400","","",null,null],[17,"B4800","","",null,null],[17,"B9600","","",null,null],[17,"B19200","","",null,null],[17,"B38400","","",null,null],[17,"B7200","","",null,null],[17,"B14400","","",null,null],[17,"B28800","","",null,null],[17,"B57600","","",null,null],[17,"B76800","","",null,null],[17,"B115200","","",null,null],[17,"B230400","","",null,null],[17,"EXTA","","",null,null],[17,"EXTB","","",null,null],[17,"SEM_FAILED","","",null,null],[17,"CRTSCTS","","",null,null],[17,"SIGEV_THREAD_ID","","",null,null],[17,"RAND_MAX","","",null,null],[17,"PTHREAD_STACK_MIN","","",null,null],[17,"PTHREAD_MUTEX_ADAPTIVE_NP","","",null,null],[17,"SIGSTKSZ","","",null,null],[17,"SF_NODISKIO","","",null,null],[17,"SF_MNOWAIT","","",null,null],[17,"SF_SYNC","","",null,null],[17,"O_CLOEXEC","","",null,null],[17,"F_GETLK","","",null,null],[17,"F_SETLK","","",null,null],[17,"F_SETLKW","","",null,null],[17,"ELAST","","",null,null],[17,"RLIMIT_NPTS","","",null,null],[17,"RLIMIT_SWAP","","",null,null],[17,"RLIM_NLIMITS","","",null,null],[17,"Q_GETQUOTA","","",null,null],[17,"Q_SETQUOTA","","",null,null],[17,"POSIX_FADV_NORMAL","","",null,null],[17,"POSIX_FADV_RANDOM","","",null,null],[17,"POSIX_FADV_SEQUENTIAL","","",null,null],[17,"POSIX_FADV_WILLNEED","","",null,null],[17,"POSIX_FADV_DONTNEED","","",null,null],[17,"POSIX_FADV_NOREUSE","","",null,null],[17,"EVFILT_READ","","",null,null],[17,"EVFILT_WRITE","","",null,null],[17,"EVFILT_AIO","","",null,null],[17,"EVFILT_VNODE","","",null,null],[17,"EVFILT_PROC","","",null,null],[17,"EVFILT_SIGNAL","","",null,null],[17,"EVFILT_TIMER","","",null,null],[17,"EVFILT_FS","","",null,null],[17,"EVFILT_LIO","","",null,null],[17,"EVFILT_USER","","",null,null],[17,"EV_ADD","","",null,null],[17,"EV_DELETE","","",null,null],[17,"EV_ENABLE","","",null,null],[17,"EV_DISABLE","","",null,null],[17,"EV_ONESHOT","","",null,null],[17,"EV_CLEAR","","",null,null],[17,"EV_RECEIPT","","",null,null],[17,"EV_DISPATCH","","",null,null],[17,"EV_DROP","","",null,null],[17,"EV_FLAG1","","",null,null],[17,"EV_ERROR","","",null,null],[17,"EV_EOF","","",null,null],[17,"EV_SYSFLAGS","","",null,null],[17,"NOTE_TRIGGER","","",null,null],[17,"NOTE_FFNOP","","",null,null],[17,"NOTE_FFAND","","",null,null],[17,"NOTE_FFOR","","",null,null],[17,"NOTE_FFCOPY","","",null,null],[17,"NOTE_FFCTRLMASK","","",null,null],[17,"NOTE_FFLAGSMASK","","",null,null],[17,"NOTE_LOWAT","","",null,null],[17,"NOTE_DELETE","","",null,null],[17,"NOTE_WRITE","","",null,null],[17,"NOTE_EXTEND","","",null,null],[17,"NOTE_ATTRIB","","",null,null],[17,"NOTE_LINK","","",null,null],[17,"NOTE_RENAME","","",null,null],[17,"NOTE_REVOKE","","",null,null],[17,"NOTE_EXIT","","",null,null],[17,"NOTE_FORK","","",null,null],[17,"NOTE_EXEC","","",null,null],[17,"NOTE_PDATAMASK","","",null,null],[17,"NOTE_PCTRLMASK","","",null,null],[17,"NOTE_TRACK","","",null,null],[17,"NOTE_TRACKERR","","",null,null],[17,"NOTE_CHILD","","",null,null],[17,"NOTE_SECONDS","","",null,null],[17,"NOTE_MSECONDS","","",null,null],[17,"NOTE_USECONDS","","",null,null],[17,"NOTE_NSECONDS","","",null,null],[17,"MADV_PROTECT","","",null,null],[17,"RUSAGE_THREAD","","",null,null],[17,"CLOCK_REALTIME","","",null,null],[17,"CLOCK_VIRTUAL","","",null,null],[17,"CLOCK_PROF","","",null,null],[17,"CLOCK_MONOTONIC","","",null,null],[17,"CLOCK_UPTIME","","",null,null],[17,"CLOCK_UPTIME_PRECISE","","",null,null],[17,"CLOCK_UPTIME_FAST","","",null,null],[17,"CLOCK_REALTIME_PRECISE","","",null,null],[17,"CLOCK_REALTIME_FAST","","",null,null],[17,"CLOCK_MONOTONIC_PRECISE","","",null,null],[17,"CLOCK_MONOTONIC_FAST","","",null,null],[17,"CLOCK_SECOND","","",null,null],[17,"CLOCK_THREAD_CPUTIME_ID","","",null,null],[17,"CLOCK_PROCESS_CPUTIME_ID","","",null,null],[17,"CTL_UNSPEC","","",null,null],[17,"CTL_KERN","","",null,null],[17,"CTL_VM","","",null,null],[17,"CTL_VFS","","",null,null],[17,"CTL_NET","","",null,null],[17,"CTL_DEBUG","","",null,null],[17,"CTL_HW","","",null,null],[17,"CTL_MACHDEP","","",null,null],[17,"CTL_USER","","",null,null],[17,"CTL_P1003_1B","","",null,null],[17,"KERN_OSTYPE","","",null,null],[17,"KERN_OSRELEASE","","",null,null],[17,"KERN_OSREV","","",null,null],[17,"KERN_VERSION","","",null,null],[17,"KERN_MAXVNODES","","",null,null],[17,"KERN_MAXPROC","","",null,null],[17,"KERN_MAXFILES","","",null,null],[17,"KERN_ARGMAX","","",null,null],[17,"KERN_SECURELVL","","",null,null],[17,"KERN_HOSTNAME","","",null,null],[17,"KERN_HOSTID","","",null,null],[17,"KERN_CLOCKRATE","","",null,null],[17,"KERN_VNODE","","",null,null],[17,"KERN_PROC","","",null,null],[17,"KERN_FILE","","",null,null],[17,"KERN_PROF","","",null,null],[17,"KERN_POSIX1","","",null,null],[17,"KERN_NGROUPS","","",null,null],[17,"KERN_JOB_CONTROL","","",null,null],[17,"KERN_SAVED_IDS","","",null,null],[17,"KERN_BOOTTIME","","",null,null],[17,"KERN_NISDOMAINNAME","","",null,null],[17,"KERN_UPDATEINTERVAL","","",null,null],[17,"KERN_OSRELDATE","","",null,null],[17,"KERN_NTP_PLL","","",null,null],[17,"KERN_BOOTFILE","","",null,null],[17,"KERN_MAXFILESPERPROC","","",null,null],[17,"KERN_MAXPROCPERUID","","",null,null],[17,"KERN_DUMPDEV","","",null,null],[17,"KERN_IPC","","",null,null],[17,"KERN_DUMMY","","",null,null],[17,"KERN_PS_STRINGS","","",null,null],[17,"KERN_USRSTACK","","",null,null],[17,"KERN_LOGSIGEXIT","","",null,null],[17,"KERN_IOV_MAX","","",null,null],[17,"KERN_HOSTUUID","","",null,null],[17,"KERN_ARND","","",null,null],[17,"KERN_PROC_ALL","","",null,null],[17,"KERN_PROC_PID","","",null,null],[17,"KERN_PROC_PGRP","","",null,null],[17,"KERN_PROC_SESSION","","",null,null],[17,"KERN_PROC_TTY","","",null,null],[17,"KERN_PROC_UID","","",null,null],[17,"KERN_PROC_RUID","","",null,null],[17,"KERN_PROC_ARGS","","",null,null],[17,"KERN_PROC_PROC","","",null,null],[17,"KERN_PROC_SV_NAME","","",null,null],[17,"KERN_PROC_RGID","","",null,null],[17,"KERN_PROC_GID","","",null,null],[17,"KERN_PROC_PATHNAME","","",null,null],[17,"KERN_PROC_OVMMAP","","",null,null],[17,"KERN_PROC_OFILEDESC","","",null,null],[17,"KERN_PROC_KSTACK","","",null,null],[17,"KERN_PROC_INC_THREAD","","",null,null],[17,"KERN_PROC_VMMAP","","",null,null],[17,"KERN_PROC_FILEDESC","","",null,null],[17,"KERN_PROC_GROUPS","","",null,null],[17,"KERN_PROC_ENV","","",null,null],[17,"KERN_PROC_AUXV","","",null,null],[17,"KERN_PROC_RLIMIT","","",null,null],[17,"KERN_PROC_PS_STRINGS","","",null,null],[17,"KERN_PROC_UMASK","","",null,null],[17,"KERN_PROC_OSREL","","",null,null],[17,"KERN_PROC_SIGTRAMP","","",null,null],[17,"KIPC_MAXSOCKBUF","","",null,null],[17,"KIPC_SOCKBUF_WASTE","","",null,null],[17,"KIPC_SOMAXCONN","","",null,null],[17,"KIPC_MAX_LINKHDR","","",null,null],[17,"KIPC_MAX_PROTOHDR","","",null,null],[17,"KIPC_MAX_HDR","","",null,null],[17,"KIPC_MAX_DATALEN","","",null,null],[17,"HW_MACHINE","","",null,null],[17,"HW_MODEL","","",null,null],[17,"HW_NCPU","","",null,null],[17,"HW_BYTEORDER","","",null,null],[17,"HW_PHYSMEM","","",null,null],[17,"HW_USERMEM","","",null,null],[17,"HW_PAGESIZE","","",null,null],[17,"HW_DISKNAMES","","",null,null],[17,"HW_DISKSTATS","","",null,null],[17,"HW_FLOATINGPT","","",null,null],[17,"HW_MACHINE_ARCH","","",null,null],[17,"HW_REALMEM","","",null,null],[17,"USER_CS_PATH","","",null,null],[17,"USER_BC_BASE_MAX","","",null,null],[17,"USER_BC_DIM_MAX","","",null,null],[17,"USER_BC_SCALE_MAX","","",null,null],[17,"USER_BC_STRING_MAX","","",null,null],[17,"USER_COLL_WEIGHTS_MAX","","",null,null],[17,"USER_EXPR_NEST_MAX","","",null,null],[17,"USER_LINE_MAX","","",null,null],[17,"USER_RE_DUP_MAX","","",null,null],[17,"USER_POSIX2_VERSION","","",null,null],[17,"USER_POSIX2_C_BIND","","",null,null],[17,"USER_POSIX2_C_DEV","","",null,null],[17,"USER_POSIX2_CHAR_TERM","","",null,null],[17,"USER_POSIX2_FORT_DEV","","",null,null],[17,"USER_POSIX2_FORT_RUN","","",null,null],[17,"USER_POSIX2_LOCALEDEF","","",null,null],[17,"USER_POSIX2_SW_DEV","","",null,null],[17,"USER_POSIX2_UPE","","",null,null],[17,"USER_STREAM_MAX","","",null,null],[17,"USER_TZNAME_MAX","","",null,null],[17,"CTL_P1003_1B_ASYNCHRONOUS_IO","","",null,null],[17,"CTL_P1003_1B_MAPPED_FILES","","",null,null],[17,"CTL_P1003_1B_MEMLOCK","","",null,null],[17,"CTL_P1003_1B_MEMLOCK_RANGE","","",null,null],[17,"CTL_P1003_1B_MEMORY_PROTECTION","","",null,null],[17,"CTL_P1003_1B_MESSAGE_PASSING","","",null,null],[17,"CTL_P1003_1B_PRIORITIZED_IO","","",null,null],[17,"CTL_P1003_1B_PRIORITY_SCHEDULING","","",null,null],[17,"CTL_P1003_1B_REALTIME_SIGNALS","","",null,null],[17,"CTL_P1003_1B_SEMAPHORES","","",null,null],[17,"CTL_P1003_1B_FSYNC","","",null,null],[17,"CTL_P1003_1B_SHARED_MEMORY_OBJECTS","","",null,null],[17,"CTL_P1003_1B_SYNCHRONIZED_IO","","",null,null],[17,"CTL_P1003_1B_TIMERS","","",null,null],[17,"CTL_P1003_1B_AIO_LISTIO_MAX","","",null,null],[17,"CTL_P1003_1B_AIO_MAX","","",null,null],[17,"CTL_P1003_1B_AIO_PRIO_DELTA_MAX","","",null,null],[17,"CTL_P1003_1B_DELAYTIMER_MAX","","",null,null],[17,"CTL_P1003_1B_MQ_OPEN_MAX","","",null,null],[17,"CTL_P1003_1B_PAGESIZE","","",null,null],[17,"CTL_P1003_1B_RTSIG_MAX","","",null,null],[17,"CTL_P1003_1B_SEM_NSEMS_MAX","","",null,null],[17,"CTL_P1003_1B_SEM_VALUE_MAX","","",null,null],[17,"CTL_P1003_1B_SIGQUEUE_MAX","","",null,null],[17,"CTL_P1003_1B_TIMER_MAX","","",null,null],[17,"TIOCGPTN","","",null,null],[17,"TIOCPTMASTER","","",null,null],[17,"TIOCSIG","","",null,null],[17,"TIOCM_DCD","","",null,null],[17,"H4DISC","","",null,null],[17,"JAIL_API_VERSION","","",null,null],[17,"JAIL_CREATE","","",null,null],[17,"JAIL_UPDATE","","",null,null],[17,"JAIL_ATTACH","","",null,null],[17,"JAIL_DYING","","",null,null],[17,"JAIL_SET_MASK","","",null,null],[17,"JAIL_GET_MASK","","",null,null],[17,"JAIL_SYS_DISABLE","","",null,null],[17,"JAIL_SYS_NEW","","",null,null],[17,"JAIL_SYS_INHERIT","","",null,null],[17,"SO_BINTIME","","",null,null],[17,"SO_NO_OFFLOAD","","",null,null],[17,"SO_NO_DDP","","",null,null],[17,"SO_LABEL","","",null,null],[17,"SO_PEERLABEL","","",null,null],[17,"SO_LISTENQLIMIT","","",null,null],[17,"SO_LISTENQLEN","","",null,null],[17,"SO_LISTENINCQLEN","","",null,null],[17,"SO_SETFIB","","",null,null],[17,"SO_USER_COOKIE","","",null,null],[17,"SO_PROTOCOL","","",null,null],[17,"SO_PROTOTYPE","","",null,null],[17,"SO_VENDOR","","",null,null],[17,"AF_SLOW","","",null,null],[17,"AF_SCLUSTER","","",null,null],[17,"AF_ARP","","",null,null],[17,"AF_BLUETOOTH","","",null,null],[17,"AF_IEEE80211","","",null,null],[17,"AF_INET_SDP","","",null,null],[17,"AF_INET6_SDP","","",null,null],[17,"IPPROTO_DIVERT","","",null,null],[17,"PF_SLOW","","",null,null],[17,"PF_SCLUSTER","","",null,null],[17,"PF_ARP","","",null,null],[17,"PF_BLUETOOTH","","",null,null],[17,"PF_IEEE80211","","",null,null],[17,"PF_INET_SDP","","",null,null],[17,"PF_INET6_SDP","","",null,null],[17,"NET_RT_DUMP","","",null,null],[17,"NET_RT_FLAGS","","",null,null],[17,"NET_RT_IFLIST","","",null,null],[17,"NET_RT_IFMALIST","","",null,null],[17,"NET_RT_IFLISTL","","",null,null],[17,"IPC_PRIVATE","","",null,null],[17,"IPC_CREAT","","",null,null],[17,"IPC_EXCL","","",null,null],[17,"IPC_NOWAIT","","",null,null],[17,"IPC_RMID","","",null,null],[17,"IPC_SET","","",null,null],[17,"IPC_STAT","","",null,null],[17,"IPC_INFO","","",null,null],[17,"IPC_R","","",null,null],[17,"IPC_W","","",null,null],[17,"IPC_M","","",null,null],[17,"MSG_NOERROR","","",null,null],[17,"SHM_RDONLY","","",null,null],[17,"SHM_RND","","",null,null],[17,"SHM_R","","",null,null],[17,"SHM_W","","",null,null],[17,"SHM_LOCK","","",null,null],[17,"SHM_UNLOCK","","",null,null],[17,"SHM_STAT","","",null,null],[17,"SHM_INFO","","",null,null],[17,"MSG_NOTIFICATION","","",null,null],[17,"MSG_NBIO","","",null,null],[17,"MSG_COMPAT","","",null,null],[17,"MSG_CMSG_CLOEXEC","","",null,null],[17,"MSG_NOSIGNAL","","",null,null],[17,"EMPTY","","",null,null],[17,"BOOT_TIME","","",null,null],[17,"OLD_TIME","","",null,null],[17,"NEW_TIME","","",null,null],[17,"USER_PROCESS","","",null,null],[17,"INIT_PROCESS","","",null,null],[17,"LOGIN_PROCESS","","",null,null],[17,"DEAD_PROCESS","","",null,null],[17,"SHUTDOWN_TIME","","",null,null],[17,"LC_COLLATE_MASK","","",null,null],[17,"LC_CTYPE_MASK","","",null,null],[17,"LC_MESSAGES_MASK","","",null,null],[17,"LC_MONETARY_MASK","","",null,null],[17,"LC_NUMERIC_MASK","","",null,null],[17,"LC_TIME_MASK","","",null,null],[17,"LC_ALL_MASK","","",null,null],[17,"WSTOPPED","","",null,null],[17,"WCONTINUED","","",null,null],[17,"WNOWAIT","","",null,null],[17,"WEXITED","","",null,null],[17,"WTRAPPED","","",null,null],[17,"P_PID","","",null,null],[17,"P_PGID","","",null,null],[17,"P_ALL","","",null,null],[17,"B460800","","",null,null],[17,"B921600","","",null,null]],"paths":[[3,"group"],[3,"utimbuf"],[3,"timeval"],[3,"timespec"],[3,"rlimit"],[3,"rusage"],[3,"in_addr"],[3,"in6_addr"],[3,"ip_mreq"],[3,"ipv6_mreq"],[3,"hostent"],[3,"iovec"],[3,"pollfd"],[3,"winsize"],[3,"linger"],[3,"sigval"],[3,"sockaddr"],[3,"sockaddr_in6"],[3,"sockaddr_un"],[3,"passwd"],[3,"ifaddrs"],[3,"tm"],[3,"utsname"],[3,"msghdr"],[3,"cmsghdr"],[3,"if_nameindex"],[3,"glob_t"],[3,"kevent"],[3,"sockaddr_storage"],[3,"addrinfo"],[3,"siginfo_t"],[3,"sigaction"],[3,"stack_t"],[3,"sched_param"],[3,"Dl_info"],[3,"sockaddr_in"],[3,"termios"],[3,"flock"],[3,"sf_hdtr"],[3,"lconv"],[3,"utmpx"],[3,"aiocb"],[3,"dirent"],[3,"jail"],[3,"sigevent"],[3,"statvfs"],[3,"ipc_perm"],[3,"msqid_ds"],[3,"shmid_ds"],[3,"stat"],[3,"_sem"],[3,"sigset_t"],[3,"fd_set"],[3,"fsid_t"]]};
searchIndex["sysctl"] = {"doc":"A simplified Rust interface to the `sysctl` system call.","items":[[3,"Temperature","sysctl","A custom type for temperature sysctls.",null,null],[4,"CtlValue","","An Enum that holds all values returned by sysctl calls. Extract inner value with `if let` or `match`.",null,null],[13,"Node","","",0,null],[13,"Int","","",0,null],[13,"String","","",0,null],[13,"S64","","",0,null],[13,"Struct","","",0,null],[13,"Uint","","",0,null],[13,"Long","","",0,null],[13,"Ulong","","",0,null],[13,"U64","","",0,null],[13,"U8","","",0,null],[13,"U16","","",0,null],[13,"S8","","",0,null],[13,"S16","","",0,null],[13,"S32","","",0,null],[13,"U32","","",0,null],[13,"Temperature","","",0,null],[5,"value","","Returns a result containing the sysctl value if success, the errno caused by sysctl() as string if failure.",null,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[5,"value_as","","Returns a result containing the sysctl value if success, the errno caused by sysctl() as string if failure.",null,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[5,"set_value","","Sets the value of a sysctl. Fetches and returns the new value if successful, errno string if failure.",null,{"inputs":[{"name":"str"},{"name":"ctlvalue"}],"output":{"name":"result"}}],[5,"description","","Returns a result containing the sysctl description if success, the errno caused by sysctl() as string if failure.",null,{"inputs":[{"name":"str"}],"output":{"name":"result"}}],[17,"CTL_MAXNAME","","",null,null],[17,"CTLTYPE","","",null,null],[17,"CTLTYPE_NODE","","",null,null],[17,"CTLTYPE_INT","","",null,null],[17,"CTLTYPE_STRING","","",null,null],[17,"CTLTYPE_S64","","",null,null],[17,"CTLTYPE_OPAQUE","","",null,null],[17,"CTLTYPE_STRUCT","","",null,null],[17,"CTLTYPE_UINT","","",null,null],[17,"CTLTYPE_LONG","","",null,null],[17,"CTLTYPE_ULONG","","",null,null],[17,"CTLTYPE_U64","","",null,null],[17,"CTLTYPE_U8","","",null,null],[17,"CTLTYPE_U16","","",null,null],[17,"CTLTYPE_S8","","",null,null],[17,"CTLTYPE_S16","","",null,null],[17,"CTLTYPE_S32","","",null,null],[17,"CTLTYPE_U32","","",null,null],[17,"CTLFLAG_RD","","",null,null],[17,"CTLFLAG_WR","","",null,null],[17,"CTLFLAG_RW","","",null,null],[17,"CTLFLAG_ANYBODY","","",null,null],[17,"CTLFLAG_SECURE","","",null,null],[17,"CTLFLAG_PRISON","","",null,null],[17,"CTLFLAG_DYN","","",null,null],[17,"CTLFLAG_SKIP","","",null,null],[17,"CTLFLAG_TUN","","",null,null],[17,"CTLFLAG_RDTUN","","",null,null],[17,"CTLFLAG_RWTUN","","",null,null],[17,"CTLFLAG_MPSAFE","","",null,null],[17,"CTLFLAG_VNET","","",null,null],[17,"CTLFLAG_DYING","","",null,null],[17,"CTLFLAG_CAPRD","","",null,null],[17,"CTLFLAG_CAPWR","","",null,null],[17,"CTLFLAG_STATS","","",null,null],[17,"CTLFLAG_NOFETCH","","",null,null],[17,"CTLFLAG_CAPRW","","",null,null],[17,"CTLFLAG_SECURE1","","",null,null],[17,"CTLFLAG_SECURE2","","",null,null],[17,"CTLFLAG_SECURE3","","",null,null],[17,"CTLMASK_SECURE","","",null,null],[17,"CTLSHIFT_SECURE","","",null,null],[11,"fmt","","",0,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"eq","","",0,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"ne","","",0,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",0,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"option"}}],[11,"lt","","",0,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"le","","",0,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"gt","","",0,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"ge","","",0,{"inputs":[{"name":"self"},{"name":"ctlvalue"}],"output":{"name":"bool"}}],[11,"fmt","","",1,{"inputs":[{"name":"self"},{"name":"formatter"}],"output":{"name":"result"}}],[11,"clone","","",1,{"inputs":[{"name":"self"}],"output":{"name":"temperature"}}],[11,"eq","","",1,{"inputs":[{"name":"self"},{"name":"temperature"}],"output":{"name":"bool"}}],[11,"ne","","",1,{"inputs":[{"name":"self"},{"name":"temperature"}],"output":{"name":"bool"}}],[11,"partial_cmp","","",1,{"inputs":[{"name":"self"},{"name":"temperature"}],"output":{"name":"option"}}],[11,"lt","","",1,{"inputs":[{"name":"self"},{"name":"temperature"}],"output":{"name":"bool"}}],[11,"le","","",1,{"inputs":[{"name":"self"},{"name":"temperature"}],"output":{"name":"bool"}}],[11,"gt","","",1,{"inputs":[{"name":"self"},{"name":"temperature"}],"output":{"name":"bool"}}],[11,"ge","","",1,{"inputs":[{"name":"self"},{"name":"temperature"}],"output":{"name":"bool"}}],[11,"kelvin","","",1,{"inputs":[{"name":"self"}],"output":{"name":"f32"}}],[11,"celsius","","",1,{"inputs":[{"name":"self"}],"output":{"name":"f32"}}],[11,"fahrenheit","","",1,{"inputs":[{"name":"self"}],"output":{"name":"f32"}}]],"paths":[[4,"CtlValue"],[3,"Temperature"]]};
initSearch(searchIndex);
