//! A collection of utilities for writing concurrent code.

#![crate_name = "syncbox"]
#![deny(warnings)]

#[macro_use]
extern crate log;
extern crate time;

pub use self::array_queue::ArrayQueue;
pub use self::delay_queue::{DelayQueue, Delayed, Delay};
pub use self::linked_queue::LinkedQueue;
pub use self::thread_pool::{ThreadPool, ScheduledThreadPool};
pub use self::queue::{Queue, SyncQueue};
pub use self::run::{Run, Task, TaskBox};

pub mod atomic;
mod array_queue;
mod delay_queue;
mod linked_queue;
mod thread_pool;
mod queue;
mod run;
