/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */

use std::rc::Rc;
use std::borrow::Borrow;
use std::borrow::Cow;
use std::collections::HashMap;

use hyper;
use serde_json;
use futures;
use futures::{Future, Stream};

use hyper::header::UserAgent;

use super::{Error, configuration};

pub struct TagApiControllerApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> TagApiControllerApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> TagApiControllerApiClient<C> {
        TagApiControllerApiClient {
            configuration: configuration,
        }
    }
}

pub trait TagApiControllerApi {
    fn get_tag_names_using_get(&self, app_ids: &str, from: i64, to: i64, metrics: bool, logs: bool, events: bool, rum: bool) -> Box<Future<Item = ::models::TagNamesResponse, Error = Error<serde_json::Value>>>;
    fn get_using_get(&self, app_ids: &str, tag: Vec<String>, from: i64, to: i64, metrics: bool, logs: bool, events: bool, rum: bool) -> Box<Future<Item = ::std::collections::HashMap<String, ::models::Dimension>, Error = Error<serde_json::Value>>>;
    fn get_using_get3(&self, app_ids: &str, tag: Vec<String>, from: i64, to: i64, metrics: bool, logs: bool, events: bool, rum: bool) -> Box<Future<Item = ::std::collections::HashMap<String, ::models::Dimension>, Error = Error<serde_json::Value>>>;
}


impl<C: hyper::client::Connect>TagApiControllerApi for TagApiControllerApiClient<C> {
    fn get_tag_names_using_get(&self, app_ids: &str, from: i64, to: i64, metrics: bool, logs: bool, events: bool, rum: bool) -> Box<Future<Item = ::models::TagNamesResponse, Error = Error<serde_json::Value>>> {
        let configuration: &configuration::Configuration<C> = self.configuration.borrow();

        let mut auth_headers = HashMap::<String, String>::new();
        let mut auth_query = HashMap::<String, String>::new();
        if let Some(ref apikey) = configuration.api_key {
            let key = apikey.key.clone();
            let val = match apikey.prefix {
                Some(ref prefix) => format!("{} {}", prefix, key),
                None => key,
            };
            auth_headers.insert("Authorization".to_owned(), val);
        };
        let method = hyper::Method::Get;

        let query_string = {
            let mut query = ::url::form_urlencoded::Serializer::new(String::new());
            query.append_pair("from", &from.to_string());
            query.append_pair("to", &to.to_string());
            query.append_pair("metrics", &metrics.to_string());
            query.append_pair("logs", &logs.to_string());
            query.append_pair("events", &events.to_string());
            query.append_pair("rum", &rum.to_string());
            for (key, val) in &auth_query {
                query.append_pair(key, val);
            }
            query.finish()
        };
        let uri_str = format!("{}/spm-reports/api/v3/apps/{appIds}/tagNames?{}", configuration.base_path, query_string, appIds=app_ids);

        // TODO(farcaller): handle error
        // if let Err(e) = uri {
        //     return Box::new(futures::future::err(e));
        // }
        let mut uri: hyper::Uri = uri_str.parse().unwrap();

        let mut req = hyper::Request::new(method, uri);

        if let Some(ref user_agent) = configuration.user_agent {
            req.headers_mut().set(UserAgent::new(Cow::Owned(user_agent.clone())));
        }


        for (key, val) in auth_headers {
            req.headers_mut().set_raw(key, val);
        }


        // send request
        Box::new(
        configuration.client.request(req)
            .map_err(|e| Error::from(e))
            .and_then(|resp| {
                let status = resp.status();
                resp.body().concat2()
                    .and_then(move |body| Ok((status, body)))
                    .map_err(|e| Error::from(e))
            })
            .and_then(|(status, body)| {
                if status.is_success() {
                    Ok(body)
                } else {
                    Err(Error::from((status, &*body)))
                }
            })
            .and_then(|body| {
                let parsed: Result<::models::TagNamesResponse, _> = serde_json::from_slice(&body);
                parsed.map_err(|e| Error::from(e))
            })
        )
    }

    fn get_using_get(&self, app_ids: &str, tag: Vec<String>, from: i64, to: i64, metrics: bool, logs: bool, events: bool, rum: bool) -> Box<Future<Item = ::std::collections::HashMap<String, ::models::Dimension>, Error = Error<serde_json::Value>>> {
        let configuration: &configuration::Configuration<C> = self.configuration.borrow();

        let mut auth_headers = HashMap::<String, String>::new();
        let mut auth_query = HashMap::<String, String>::new();
        if let Some(ref apikey) = configuration.api_key {
            let key = apikey.key.clone();
            let val = match apikey.prefix {
                Some(ref prefix) => format!("{} {}", prefix, key),
                None => key,
            };
            auth_headers.insert("Authorization".to_owned(), val);
        };
        let method = hyper::Method::Get;

        let query_string = {
            let mut query = ::url::form_urlencoded::Serializer::new(String::new());
            query.append_pair("from", &from.to_string());
            query.append_pair("to", &to.to_string());
            query.append_pair("tag", &tag.join(",").to_string());
            query.append_pair("metrics", &metrics.to_string());
            query.append_pair("logs", &logs.to_string());
            query.append_pair("events", &events.to_string());
            query.append_pair("rum", &rum.to_string());
            for (key, val) in &auth_query {
                query.append_pair(key, val);
            }
            query.finish()
        };
        let uri_str = format!("{}/spm-reports/api/v3/apps/{appIds}/metrics/filters?{}", configuration.base_path, query_string, appIds=app_ids);

        // TODO(farcaller): handle error
        // if let Err(e) = uri {
        //     return Box::new(futures::future::err(e));
        // }
        let mut uri: hyper::Uri = uri_str.parse().unwrap();

        let mut req = hyper::Request::new(method, uri);

        if let Some(ref user_agent) = configuration.user_agent {
            req.headers_mut().set(UserAgent::new(Cow::Owned(user_agent.clone())));
        }


        for (key, val) in auth_headers {
            req.headers_mut().set_raw(key, val);
        }


        // send request
        Box::new(
        configuration.client.request(req)
            .map_err(|e| Error::from(e))
            .and_then(|resp| {
                let status = resp.status();
                resp.body().concat2()
                    .and_then(move |body| Ok((status, body)))
                    .map_err(|e| Error::from(e))
            })
            .and_then(|(status, body)| {
                if status.is_success() {
                    Ok(body)
                } else {
                    Err(Error::from((status, &*body)))
                }
            })
            .and_then(|body| {
                let parsed: Result<::std::collections::HashMap<String, ::models::Dimension>, _> = serde_json::from_slice(&body);
                parsed.map_err(|e| Error::from(e))
            })
        )
    }

    fn get_using_get3(&self, app_ids: &str, tag: Vec<String>, from: i64, to: i64, metrics: bool, logs: bool, events: bool, rum: bool) -> Box<Future<Item = ::std::collections::HashMap<String, ::models::Dimension>, Error = Error<serde_json::Value>>> {
        let configuration: &configuration::Configuration<C> = self.configuration.borrow();

        let mut auth_headers = HashMap::<String, String>::new();
        let mut auth_query = HashMap::<String, String>::new();
        if let Some(ref apikey) = configuration.api_key {
            let key = apikey.key.clone();
            let val = match apikey.prefix {
                Some(ref prefix) => format!("{} {}", prefix, key),
                None => key,
            };
            auth_headers.insert("Authorization".to_owned(), val);
        };
        let method = hyper::Method::Get;

        let query_string = {
            let mut query = ::url::form_urlencoded::Serializer::new(String::new());
            query.append_pair("from", &from.to_string());
            query.append_pair("to", &to.to_string());
            query.append_pair("tag", &tag.join(",").to_string());
            query.append_pair("metrics", &metrics.to_string());
            query.append_pair("logs", &logs.to_string());
            query.append_pair("events", &events.to_string());
            query.append_pair("rum", &rum.to_string());
            for (key, val) in &auth_query {
                query.append_pair(key, val);
            }
            query.finish()
        };
        let uri_str = format!("{}/spm-reports/api/v3/apps/{appIds}/tags?{}", configuration.base_path, query_string, appIds=app_ids);

        // TODO(farcaller): handle error
        // if let Err(e) = uri {
        //     return Box::new(futures::future::err(e));
        // }
        let mut uri: hyper::Uri = uri_str.parse().unwrap();

        let mut req = hyper::Request::new(method, uri);

        if let Some(ref user_agent) = configuration.user_agent {
            req.headers_mut().set(UserAgent::new(Cow::Owned(user_agent.clone())));
        }


        for (key, val) in auth_headers {
            req.headers_mut().set_raw(key, val);
        }


        // send request
        Box::new(
        configuration.client.request(req)
            .map_err(|e| Error::from(e))
            .and_then(|resp| {
                let status = resp.status();
                resp.body().concat2()
                    .and_then(move |body| Ok((status, body)))
                    .map_err(|e| Error::from(e))
            })
            .and_then(|(status, body)| {
                if status.is_success() {
                    Ok(body)
                } else {
                    Err(Error::from((status, &*body)))
                }
            })
            .and_then(|body| {
                let parsed: Result<::std::collections::HashMap<String, ::models::Dimension>, _> = serde_json::from_slice(&body);
                parsed.map_err(|e| Error::from(e))
            })
        )
    }

}
