/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct UserPermissions {
  #[serde(rename = "canDelete")]
  can_delete: Option<bool>,
  #[serde(rename = "canEdit")]
  can_edit: Option<bool>,
  #[serde(rename = "canView")]
  can_view: Option<bool>
}

impl UserPermissions {
  pub fn new() -> UserPermissions {
    UserPermissions {
      can_delete: None,
      can_edit: None,
      can_view: None
    }
  }

  pub fn set_can_delete(&mut self, can_delete: bool) {
    self.can_delete = Some(can_delete);
  }

  pub fn with_can_delete(mut self, can_delete: bool) -> UserPermissions {
    self.can_delete = Some(can_delete);
    self
  }

  pub fn can_delete(&self) -> Option<&bool> {
    self.can_delete.as_ref()
  }

  pub fn reset_can_delete(&mut self) {
    self.can_delete = None;
  }

  pub fn set_can_edit(&mut self, can_edit: bool) {
    self.can_edit = Some(can_edit);
  }

  pub fn with_can_edit(mut self, can_edit: bool) -> UserPermissions {
    self.can_edit = Some(can_edit);
    self
  }

  pub fn can_edit(&self) -> Option<&bool> {
    self.can_edit.as_ref()
  }

  pub fn reset_can_edit(&mut self) {
    self.can_edit = None;
  }

  pub fn set_can_view(&mut self, can_view: bool) {
    self.can_view = Some(can_view);
  }

  pub fn with_can_view(mut self, can_view: bool) -> UserPermissions {
    self.can_view = Some(can_view);
    self
  }

  pub fn can_view(&self) -> Option<&bool> {
    self.can_view.as_ref()
  }

  pub fn reset_can_view(&mut self) {
    self.can_view = None;
  }

}



