/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct Subscription {
  #[serde(rename = "addresses")]
  addresses: Option<String>,
  #[serde(rename = "createdBy")]
  created_by: Option<String>,
  #[serde(rename = "dashboardId")]
  dashboard_id: Option<i64>,
  #[serde(rename = "dashboardName")]
  dashboard_name: Option<String>,
  #[serde(rename = "enabled")]
  enabled: Option<bool>,
  #[serde(rename = "filters")]
  filters: Option<String>,
  #[serde(rename = "frequency")]
  frequency: Option<String>,
  #[serde(rename = "id")]
  id: Option<i64>,
  #[serde(rename = "nextSendDate")]
  next_send_date: Option<String>,
  #[serde(rename = "subject")]
  subject: Option<String>,
  #[serde(rename = "systemId")]
  system_id: Option<i64>,
  #[serde(rename = "systemName")]
  system_name: Option<String>,
  #[serde(rename = "text")]
  text: Option<String>,
  #[serde(rename = "timeRange")]
  time_range: Option<String>,
  #[serde(rename = "userPermissions")]
  user_permissions: Option<::models::UserPermissions>
}

impl Subscription {
  pub fn new() -> Subscription {
    Subscription {
      addresses: None,
      created_by: None,
      dashboard_id: None,
      dashboard_name: None,
      enabled: None,
      filters: None,
      frequency: None,
      id: None,
      next_send_date: None,
      subject: None,
      system_id: None,
      system_name: None,
      text: None,
      time_range: None,
      user_permissions: None
    }
  }

  pub fn set_addresses(&mut self, addresses: String) {
    self.addresses = Some(addresses);
  }

  pub fn with_addresses(mut self, addresses: String) -> Subscription {
    self.addresses = Some(addresses);
    self
  }

  pub fn addresses(&self) -> Option<&String> {
    self.addresses.as_ref()
  }

  pub fn reset_addresses(&mut self) {
    self.addresses = None;
  }

  pub fn set_created_by(&mut self, created_by: String) {
    self.created_by = Some(created_by);
  }

  pub fn with_created_by(mut self, created_by: String) -> Subscription {
    self.created_by = Some(created_by);
    self
  }

  pub fn created_by(&self) -> Option<&String> {
    self.created_by.as_ref()
  }

  pub fn reset_created_by(&mut self) {
    self.created_by = None;
  }

  pub fn set_dashboard_id(&mut self, dashboard_id: i64) {
    self.dashboard_id = Some(dashboard_id);
  }

  pub fn with_dashboard_id(mut self, dashboard_id: i64) -> Subscription {
    self.dashboard_id = Some(dashboard_id);
    self
  }

  pub fn dashboard_id(&self) -> Option<&i64> {
    self.dashboard_id.as_ref()
  }

  pub fn reset_dashboard_id(&mut self) {
    self.dashboard_id = None;
  }

  pub fn set_dashboard_name(&mut self, dashboard_name: String) {
    self.dashboard_name = Some(dashboard_name);
  }

  pub fn with_dashboard_name(mut self, dashboard_name: String) -> Subscription {
    self.dashboard_name = Some(dashboard_name);
    self
  }

  pub fn dashboard_name(&self) -> Option<&String> {
    self.dashboard_name.as_ref()
  }

  pub fn reset_dashboard_name(&mut self) {
    self.dashboard_name = None;
  }

  pub fn set_enabled(&mut self, enabled: bool) {
    self.enabled = Some(enabled);
  }

  pub fn with_enabled(mut self, enabled: bool) -> Subscription {
    self.enabled = Some(enabled);
    self
  }

  pub fn enabled(&self) -> Option<&bool> {
    self.enabled.as_ref()
  }

  pub fn reset_enabled(&mut self) {
    self.enabled = None;
  }

  pub fn set_filters(&mut self, filters: String) {
    self.filters = Some(filters);
  }

  pub fn with_filters(mut self, filters: String) -> Subscription {
    self.filters = Some(filters);
    self
  }

  pub fn filters(&self) -> Option<&String> {
    self.filters.as_ref()
  }

  pub fn reset_filters(&mut self) {
    self.filters = None;
  }

  pub fn set_frequency(&mut self, frequency: String) {
    self.frequency = Some(frequency);
  }

  pub fn with_frequency(mut self, frequency: String) -> Subscription {
    self.frequency = Some(frequency);
    self
  }

  pub fn frequency(&self) -> Option<&String> {
    self.frequency.as_ref()
  }

  pub fn reset_frequency(&mut self) {
    self.frequency = None;
  }

  pub fn set_id(&mut self, id: i64) {
    self.id = Some(id);
  }

  pub fn with_id(mut self, id: i64) -> Subscription {
    self.id = Some(id);
    self
  }

  pub fn id(&self) -> Option<&i64> {
    self.id.as_ref()
  }

  pub fn reset_id(&mut self) {
    self.id = None;
  }

  pub fn set_next_send_date(&mut self, next_send_date: String) {
    self.next_send_date = Some(next_send_date);
  }

  pub fn with_next_send_date(mut self, next_send_date: String) -> Subscription {
    self.next_send_date = Some(next_send_date);
    self
  }

  pub fn next_send_date(&self) -> Option<&String> {
    self.next_send_date.as_ref()
  }

  pub fn reset_next_send_date(&mut self) {
    self.next_send_date = None;
  }

  pub fn set_subject(&mut self, subject: String) {
    self.subject = Some(subject);
  }

  pub fn with_subject(mut self, subject: String) -> Subscription {
    self.subject = Some(subject);
    self
  }

  pub fn subject(&self) -> Option<&String> {
    self.subject.as_ref()
  }

  pub fn reset_subject(&mut self) {
    self.subject = None;
  }

  pub fn set_system_id(&mut self, system_id: i64) {
    self.system_id = Some(system_id);
  }

  pub fn with_system_id(mut self, system_id: i64) -> Subscription {
    self.system_id = Some(system_id);
    self
  }

  pub fn system_id(&self) -> Option<&i64> {
    self.system_id.as_ref()
  }

  pub fn reset_system_id(&mut self) {
    self.system_id = None;
  }

  pub fn set_system_name(&mut self, system_name: String) {
    self.system_name = Some(system_name);
  }

  pub fn with_system_name(mut self, system_name: String) -> Subscription {
    self.system_name = Some(system_name);
    self
  }

  pub fn system_name(&self) -> Option<&String> {
    self.system_name.as_ref()
  }

  pub fn reset_system_name(&mut self) {
    self.system_name = None;
  }

  pub fn set_text(&mut self, text: String) {
    self.text = Some(text);
  }

  pub fn with_text(mut self, text: String) -> Subscription {
    self.text = Some(text);
    self
  }

  pub fn text(&self) -> Option<&String> {
    self.text.as_ref()
  }

  pub fn reset_text(&mut self) {
    self.text = None;
  }

  pub fn set_time_range(&mut self, time_range: String) {
    self.time_range = Some(time_range);
  }

  pub fn with_time_range(mut self, time_range: String) -> Subscription {
    self.time_range = Some(time_range);
    self
  }

  pub fn time_range(&self) -> Option<&String> {
    self.time_range.as_ref()
  }

  pub fn reset_time_range(&mut self) {
    self.time_range = None;
  }

  pub fn set_user_permissions(&mut self, user_permissions: ::models::UserPermissions) {
    self.user_permissions = Some(user_permissions);
  }

  pub fn with_user_permissions(mut self, user_permissions: ::models::UserPermissions) -> Subscription {
    self.user_permissions = Some(user_permissions);
    self
  }

  pub fn user_permissions(&self) -> Option<&::models::UserPermissions> {
    self.user_permissions.as_ref()
  }

  pub fn reset_user_permissions(&mut self) {
    self.user_permissions = None;
  }

}



