/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct Plan {
  #[serde(rename = "appType")]
  app_type: Option<String>,
  #[serde(rename = "custom")]
  custom: Option<bool>,
  #[serde(rename = "dataRetentionHours")]
  data_retention_hours: Option<f32>,
  #[serde(rename = "defaultTrialPlan")]
  default_trial_plan: Option<bool>,
  #[serde(rename = "free")]
  free: Option<bool>,
  #[serde(rename = "freeTrialDays")]
  free_trial_days: Option<i64>,
  #[serde(rename = "id")]
  id: Option<i64>,
  #[serde(rename = "maxAlerts")]
  max_alerts: Option<i64>,
  #[serde(rename = "maxDailyEvents")]
  max_daily_events: Option<i64>,
  #[serde(rename = "name")]
  name: Option<String>,
  #[serde(rename = "planScheme")]
  plan_scheme: Option<String>,
  #[serde(rename = "sematextService")]
  sematext_service: Option<String>,
  #[serde(rename = "trialPlan")]
  trial_plan: Option<bool>
}

impl Plan {
  pub fn new() -> Plan {
    Plan {
      app_type: None,
      custom: None,
      data_retention_hours: None,
      default_trial_plan: None,
      free: None,
      free_trial_days: None,
      id: None,
      max_alerts: None,
      max_daily_events: None,
      name: None,
      plan_scheme: None,
      sematext_service: None,
      trial_plan: None
    }
  }

  pub fn set_app_type(&mut self, app_type: String) {
    self.app_type = Some(app_type);
  }

  pub fn with_app_type(mut self, app_type: String) -> Plan {
    self.app_type = Some(app_type);
    self
  }

  pub fn app_type(&self) -> Option<&String> {
    self.app_type.as_ref()
  }

  pub fn reset_app_type(&mut self) {
    self.app_type = None;
  }

  pub fn set_custom(&mut self, custom: bool) {
    self.custom = Some(custom);
  }

  pub fn with_custom(mut self, custom: bool) -> Plan {
    self.custom = Some(custom);
    self
  }

  pub fn custom(&self) -> Option<&bool> {
    self.custom.as_ref()
  }

  pub fn reset_custom(&mut self) {
    self.custom = None;
  }

  pub fn set_data_retention_hours(&mut self, data_retention_hours: f32) {
    self.data_retention_hours = Some(data_retention_hours);
  }

  pub fn with_data_retention_hours(mut self, data_retention_hours: f32) -> Plan {
    self.data_retention_hours = Some(data_retention_hours);
    self
  }

  pub fn data_retention_hours(&self) -> Option<&f32> {
    self.data_retention_hours.as_ref()
  }

  pub fn reset_data_retention_hours(&mut self) {
    self.data_retention_hours = None;
  }

  pub fn set_default_trial_plan(&mut self, default_trial_plan: bool) {
    self.default_trial_plan = Some(default_trial_plan);
  }

  pub fn with_default_trial_plan(mut self, default_trial_plan: bool) -> Plan {
    self.default_trial_plan = Some(default_trial_plan);
    self
  }

  pub fn default_trial_plan(&self) -> Option<&bool> {
    self.default_trial_plan.as_ref()
  }

  pub fn reset_default_trial_plan(&mut self) {
    self.default_trial_plan = None;
  }

  pub fn set_free(&mut self, free: bool) {
    self.free = Some(free);
  }

  pub fn with_free(mut self, free: bool) -> Plan {
    self.free = Some(free);
    self
  }

  pub fn free(&self) -> Option<&bool> {
    self.free.as_ref()
  }

  pub fn reset_free(&mut self) {
    self.free = None;
  }

  pub fn set_free_trial_days(&mut self, free_trial_days: i64) {
    self.free_trial_days = Some(free_trial_days);
  }

  pub fn with_free_trial_days(mut self, free_trial_days: i64) -> Plan {
    self.free_trial_days = Some(free_trial_days);
    self
  }

  pub fn free_trial_days(&self) -> Option<&i64> {
    self.free_trial_days.as_ref()
  }

  pub fn reset_free_trial_days(&mut self) {
    self.free_trial_days = None;
  }

  pub fn set_id(&mut self, id: i64) {
    self.id = Some(id);
  }

  pub fn with_id(mut self, id: i64) -> Plan {
    self.id = Some(id);
    self
  }

  pub fn id(&self) -> Option<&i64> {
    self.id.as_ref()
  }

  pub fn reset_id(&mut self) {
    self.id = None;
  }

  pub fn set_max_alerts(&mut self, max_alerts: i64) {
    self.max_alerts = Some(max_alerts);
  }

  pub fn with_max_alerts(mut self, max_alerts: i64) -> Plan {
    self.max_alerts = Some(max_alerts);
    self
  }

  pub fn max_alerts(&self) -> Option<&i64> {
    self.max_alerts.as_ref()
  }

  pub fn reset_max_alerts(&mut self) {
    self.max_alerts = None;
  }

  pub fn set_max_daily_events(&mut self, max_daily_events: i64) {
    self.max_daily_events = Some(max_daily_events);
  }

  pub fn with_max_daily_events(mut self, max_daily_events: i64) -> Plan {
    self.max_daily_events = Some(max_daily_events);
    self
  }

  pub fn max_daily_events(&self) -> Option<&i64> {
    self.max_daily_events.as_ref()
  }

  pub fn reset_max_daily_events(&mut self) {
    self.max_daily_events = None;
  }

  pub fn set_name(&mut self, name: String) {
    self.name = Some(name);
  }

  pub fn with_name(mut self, name: String) -> Plan {
    self.name = Some(name);
    self
  }

  pub fn name(&self) -> Option<&String> {
    self.name.as_ref()
  }

  pub fn reset_name(&mut self) {
    self.name = None;
  }

  pub fn set_plan_scheme(&mut self, plan_scheme: String) {
    self.plan_scheme = Some(plan_scheme);
  }

  pub fn with_plan_scheme(mut self, plan_scheme: String) -> Plan {
    self.plan_scheme = Some(plan_scheme);
    self
  }

  pub fn plan_scheme(&self) -> Option<&String> {
    self.plan_scheme.as_ref()
  }

  pub fn reset_plan_scheme(&mut self) {
    self.plan_scheme = None;
  }

  pub fn set_sematext_service(&mut self, sematext_service: String) {
    self.sematext_service = Some(sematext_service);
  }

  pub fn with_sematext_service(mut self, sematext_service: String) -> Plan {
    self.sematext_service = Some(sematext_service);
    self
  }

  pub fn sematext_service(&self) -> Option<&String> {
    self.sematext_service.as_ref()
  }

  pub fn reset_sematext_service(&mut self) {
    self.sematext_service = None;
  }

  pub fn set_trial_plan(&mut self, trial_plan: bool) {
    self.trial_plan = Some(trial_plan);
  }

  pub fn with_trial_plan(mut self, trial_plan: bool) -> Plan {
    self.trial_plan = Some(trial_plan);
    self
  }

  pub fn trial_plan(&self) -> Option<&bool> {
    self.trial_plan.as_ref()
  }

  pub fn reset_trial_plan(&mut self) {
    self.trial_plan = None;
  }

}



