/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct Invoice {
  #[serde(rename = "allCharges")]
  all_charges: Option<Vec<::models::ChargesDetailsResponseDto>>,
  #[serde(rename = "invoiceDate")]
  invoice_date: Option<String>,
  #[serde(rename = "invoiceId")]
  invoice_id: Option<String>,
  #[serde(rename = "period")]
  period: Option<String>,
  #[serde(rename = "service")]
  service: Option<String>,
  #[serde(rename = "totalAmount")]
  total_amount: Option<f32>
}

impl Invoice {
  pub fn new() -> Invoice {
    Invoice {
      all_charges: None,
      invoice_date: None,
      invoice_id: None,
      period: None,
      service: None,
      total_amount: None
    }
  }

  pub fn set_all_charges(&mut self, all_charges: Vec<::models::ChargesDetailsResponseDto>) {
    self.all_charges = Some(all_charges);
  }

  pub fn with_all_charges(mut self, all_charges: Vec<::models::ChargesDetailsResponseDto>) -> Invoice {
    self.all_charges = Some(all_charges);
    self
  }

  pub fn all_charges(&self) -> Option<&Vec<::models::ChargesDetailsResponseDto>> {
    self.all_charges.as_ref()
  }

  pub fn reset_all_charges(&mut self) {
    self.all_charges = None;
  }

  pub fn set_invoice_date(&mut self, invoice_date: String) {
    self.invoice_date = Some(invoice_date);
  }

  pub fn with_invoice_date(mut self, invoice_date: String) -> Invoice {
    self.invoice_date = Some(invoice_date);
    self
  }

  pub fn invoice_date(&self) -> Option<&String> {
    self.invoice_date.as_ref()
  }

  pub fn reset_invoice_date(&mut self) {
    self.invoice_date = None;
  }

  pub fn set_invoice_id(&mut self, invoice_id: String) {
    self.invoice_id = Some(invoice_id);
  }

  pub fn with_invoice_id(mut self, invoice_id: String) -> Invoice {
    self.invoice_id = Some(invoice_id);
    self
  }

  pub fn invoice_id(&self) -> Option<&String> {
    self.invoice_id.as_ref()
  }

  pub fn reset_invoice_id(&mut self) {
    self.invoice_id = None;
  }

  pub fn set_period(&mut self, period: String) {
    self.period = Some(period);
  }

  pub fn with_period(mut self, period: String) -> Invoice {
    self.period = Some(period);
    self
  }

  pub fn period(&self) -> Option<&String> {
    self.period.as_ref()
  }

  pub fn reset_period(&mut self) {
    self.period = None;
  }

  pub fn set_service(&mut self, service: String) {
    self.service = Some(service);
  }

  pub fn with_service(mut self, service: String) -> Invoice {
    self.service = Some(service);
    self
  }

  pub fn service(&self) -> Option<&String> {
    self.service.as_ref()
  }

  pub fn reset_service(&mut self) {
    self.service = None;
  }

  pub fn set_total_amount(&mut self, total_amount: f32) {
    self.total_amount = Some(total_amount);
  }

  pub fn with_total_amount(mut self, total_amount: f32) -> Invoice {
    self.total_amount = Some(total_amount);
    self
  }

  pub fn total_amount(&self) -> Option<&f32> {
    self.total_amount.as_ref()
  }

  pub fn reset_total_amount(&mut self) {
    self.total_amount = None;
  }

}



