/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct AppMetadata {
  #[serde(rename = "awsCloudWatchAccessKey")]
  aws_cloud_watch_access_key: Option<String>,
  #[serde(rename = "awsCloudWatchSecretKey")]
  aws_cloud_watch_secret_key: Option<String>,
  #[serde(rename = "awsFetchFrequency")]
  aws_fetch_frequency: Option<String>,
  #[serde(rename = "awsRegion")]
  aws_region: Option<String>,
  /// Comma separated list of AWS types monitored by created app
  #[serde(rename = "subTypes")]
  sub_types: Option<Vec<String>>
}

impl AppMetadata {
  pub fn new() -> AppMetadata {
    AppMetadata {
      aws_cloud_watch_access_key: None,
      aws_cloud_watch_secret_key: None,
      aws_fetch_frequency: None,
      aws_region: None,
      sub_types: None
    }
  }

  pub fn set_aws_cloud_watch_access_key(&mut self, aws_cloud_watch_access_key: String) {
    self.aws_cloud_watch_access_key = Some(aws_cloud_watch_access_key);
  }

  pub fn with_aws_cloud_watch_access_key(mut self, aws_cloud_watch_access_key: String) -> AppMetadata {
    self.aws_cloud_watch_access_key = Some(aws_cloud_watch_access_key);
    self
  }

  pub fn aws_cloud_watch_access_key(&self) -> Option<&String> {
    self.aws_cloud_watch_access_key.as_ref()
  }

  pub fn reset_aws_cloud_watch_access_key(&mut self) {
    self.aws_cloud_watch_access_key = None;
  }

  pub fn set_aws_cloud_watch_secret_key(&mut self, aws_cloud_watch_secret_key: String) {
    self.aws_cloud_watch_secret_key = Some(aws_cloud_watch_secret_key);
  }

  pub fn with_aws_cloud_watch_secret_key(mut self, aws_cloud_watch_secret_key: String) -> AppMetadata {
    self.aws_cloud_watch_secret_key = Some(aws_cloud_watch_secret_key);
    self
  }

  pub fn aws_cloud_watch_secret_key(&self) -> Option<&String> {
    self.aws_cloud_watch_secret_key.as_ref()
  }

  pub fn reset_aws_cloud_watch_secret_key(&mut self) {
    self.aws_cloud_watch_secret_key = None;
  }

  pub fn set_aws_fetch_frequency(&mut self, aws_fetch_frequency: String) {
    self.aws_fetch_frequency = Some(aws_fetch_frequency);
  }

  pub fn with_aws_fetch_frequency(mut self, aws_fetch_frequency: String) -> AppMetadata {
    self.aws_fetch_frequency = Some(aws_fetch_frequency);
    self
  }

  pub fn aws_fetch_frequency(&self) -> Option<&String> {
    self.aws_fetch_frequency.as_ref()
  }

  pub fn reset_aws_fetch_frequency(&mut self) {
    self.aws_fetch_frequency = None;
  }

  pub fn set_aws_region(&mut self, aws_region: String) {
    self.aws_region = Some(aws_region);
  }

  pub fn with_aws_region(mut self, aws_region: String) -> AppMetadata {
    self.aws_region = Some(aws_region);
    self
  }

  pub fn aws_region(&self) -> Option<&String> {
    self.aws_region.as_ref()
  }

  pub fn reset_aws_region(&mut self) {
    self.aws_region = None;
  }

  pub fn set_sub_types(&mut self, sub_types: Vec<String>) {
    self.sub_types = Some(sub_types);
  }

  pub fn with_sub_types(mut self, sub_types: Vec<String>) -> AppMetadata {
    self.sub_types = Some(sub_types);
    self
  }

  pub fn sub_types(&self) -> Option<&Vec<String>> {
    self.sub_types.as_ref()
  }

  pub fn reset_sub_types(&mut self) {
    self.sub_types = None;
  }

}



