/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Invitation {
    #[serde(rename = "app", skip_serializing_if = "Option::is_none")]
    pub app: Option<crate::models::App>,
    /// For invite request, only apps.id needs to be set.
    #[serde(rename = "apps", skip_serializing_if = "Option::is_none")]
    pub apps: Option<Vec<crate::models::App>>,
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    #[serde(rename = "inviteDate", skip_serializing_if = "Option::is_none")]
    pub invite_date: Option<String>,
    #[serde(rename = "inviteStatus", skip_serializing_if = "Option::is_none")]
    pub invite_status: Option<InviteStatus>,
    #[serde(rename = "inviteeEmail", skip_serializing_if = "Option::is_none")]
    pub invitee_email: Option<String>,
    #[serde(rename = "inviteeRole", skip_serializing_if = "Option::is_none")]
    pub invitee_role: Option<InviteeRole>,
    #[serde(rename = "inviteeStatus", skip_serializing_if = "Option::is_none")]
    pub invitee_status: Option<InviteeStatus>,
    #[serde(rename = "inviterEmail", skip_serializing_if = "Option::is_none")]
    pub inviter_email: Option<String>,
    #[serde(rename = "uuid", skip_serializing_if = "Option::is_none")]
    pub uuid: Option<String>,
}

impl Invitation {
    pub fn new() -> Invitation {
        Invitation {
            app: None,
            apps: None,
            id: None,
            invite_date: None,
            invite_status: None,
            invitee_email: None,
            invitee_role: None,
            invitee_status: None,
            inviter_email: None,
            uuid: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum InviteStatus {
    #[serde(rename = "PENDING")]
    PENDING,
    #[serde(rename = "ACCEPTED")]
    ACCEPTED,
    #[serde(rename = "CANCELLED")]
    CANCELLED,
    #[serde(rename = "DECLINED")]
    DECLINED,
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum InviteeRole {
    #[serde(rename = "SUPER_USER")]
    SUPERUSER,
    #[serde(rename = "OWNER")]
    OWNER,
    #[serde(rename = "ADMIN")]
    ADMIN,
    #[serde(rename = "USER")]
    USER,
    #[serde(rename = "DEMO")]
    DEMO,
    #[serde(rename = "ANONYMOUS")]
    ANONYMOUS,
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum InviteeStatus {
    #[serde(rename = "INACTIVE")]
    INACTIVE,
    #[serde(rename = "ACTIVE")]
    ACTIVE,
}

