/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CloudWatchSettings {
    #[serde(rename = "accessKey", skip_serializing_if = "Option::is_none")]
    pub access_key: Option<String>,
    #[serde(rename = "fetchFrequency", skip_serializing_if = "Option::is_none")]
    pub fetch_frequency: Option<FetchFrequency>,
    #[serde(rename = "region", skip_serializing_if = "Option::is_none")]
    pub region: Option<Region>,
    #[serde(rename = "secretKey", skip_serializing_if = "Option::is_none")]
    pub secret_key: Option<String>,
}

impl CloudWatchSettings {
    pub fn new() -> CloudWatchSettings {
        CloudWatchSettings {
            access_key: None,
            fetch_frequency: None,
            region: None,
            secret_key: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum FetchFrequency {
    #[serde(rename = "MINUTE")]
    MINUTE,
    #[serde(rename = "FIVE_MINUTES")]
    FIVEMINUTES,
    #[serde(rename = "FIFTEEN_MINUTES")]
    FIFTEENMINUTES,
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Region {
    #[serde(rename = "US_EAST_1")]
    USEAST1,
    #[serde(rename = "US_WEST_1")]
    USWEST1,
    #[serde(rename = "EU_WEST_1")]
    EUWEST1,
    #[serde(rename = "US_WEST_2")]
    USWEST2,
    #[serde(rename = "AP_SOUTHEAST_1")]
    APSOUTHEAST1,
    #[serde(rename = "AP_SOUTHEAST_2")]
    APSOUTHEAST2,
    #[serde(rename = "AP_NORTHEAST_1")]
    APNORTHEAST1,
    #[serde(rename = "SA_EAST_1")]
    SAEAST1,
    #[serde(rename = "GovCloud")]
    GovCloud,
    #[serde(rename = "CN_NORTH_1")]
    CNNORTH1,
    #[serde(rename = "US_EAST_2")]
    USEAST2,
    #[serde(rename = "AP_SOUTH_1")]
    APSOUTH1,
    #[serde(rename = "AP_NORTHEAST_2")]
    APNORTHEAST2,
    #[serde(rename = "CA_CENTRAL_1")]
    CACENTRAL1,
    #[serde(rename = "EU_CENTRAL_1")]
    EUCENTRAL1,
    #[serde(rename = "EU_WEST_2")]
    EUWEST2,
}

