/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AppMetadata {
    #[serde(rename = "awsCloudWatchAccessKey", skip_serializing_if = "Option::is_none")]
    pub aws_cloud_watch_access_key: Option<String>,
    #[serde(rename = "awsCloudWatchSecretKey", skip_serializing_if = "Option::is_none")]
    pub aws_cloud_watch_secret_key: Option<String>,
    #[serde(rename = "awsFetchFrequency", skip_serializing_if = "Option::is_none")]
    pub aws_fetch_frequency: Option<AwsFetchFrequency>,
    #[serde(rename = "awsRegion", skip_serializing_if = "Option::is_none")]
    pub aws_region: Option<AwsRegion>,
    /// Comma separated list of AWS types monitored by created app
    #[serde(rename = "subTypes", skip_serializing_if = "Option::is_none")]
    pub sub_types: Option<SubTypes>,
}

impl AppMetadata {
    pub fn new() -> AppMetadata {
        AppMetadata {
            aws_cloud_watch_access_key: None,
            aws_cloud_watch_secret_key: None,
            aws_fetch_frequency: None,
            aws_region: None,
            sub_types: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum AwsFetchFrequency {
    #[serde(rename = "MINUTE")]
    MINUTE,
    #[serde(rename = "FIVE_MINUTES")]
    FIVEMINUTES,
    #[serde(rename = "FIFTEEN_MINUTES")]
    FIFTEENMINUTES,
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum AwsRegion {
    #[serde(rename = "US_EAST_1")]
    USEAST1,
    #[serde(rename = "US_WEST_1")]
    USWEST1,
    #[serde(rename = "EU_WEST_1")]
    EUWEST1,
    #[serde(rename = "US_WEST_2")]
    USWEST2,
    #[serde(rename = "AP_SOUTHEAST_1")]
    APSOUTHEAST1,
    #[serde(rename = "AP_SOUTHEAST_2")]
    APSOUTHEAST2,
    #[serde(rename = "AP_NORTHEAST_1")]
    APNORTHEAST1,
    #[serde(rename = "SA_EAST_1")]
    SAEAST1,
    #[serde(rename = "GovCloud")]
    GovCloud,
    #[serde(rename = "CN_NORTH_1")]
    CNNORTH1,
    #[serde(rename = "US_EAST_2")]
    USEAST2,
    #[serde(rename = "AP_SOUTH_1")]
    APSOUTH1,
    #[serde(rename = "AP_NORTHEAST_2")]
    APNORTHEAST2,
    #[serde(rename = "CA_CENTRAL_1")]
    CACENTRAL1,
    #[serde(rename = "EU_CENTRAL_1")]
    EUCENTRAL1,
    #[serde(rename = "EU_WEST_2")]
    EUWEST2,
}
/// Comma separated list of AWS types monitored by created app
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum SubTypes {
    #[serde(rename = "aws_ec2")]
    Ec2,
    #[serde(rename = "aws_elb")]
    Elb,
    #[serde(rename = "aws_ebs")]
    Ebs,
}

