/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use serde_json;
use futures::Future;

use super::{Error, configuration};
use super::request as __internal_request;

pub struct TagApiControllerApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> TagApiControllerApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> TagApiControllerApiClient<C> {
        TagApiControllerApiClient {
            configuration,
        }
    }
}

pub trait TagApiControllerApi {
    fn get_tag_names_using_get(&self, app_ids: &str, from: Option<i64>, to: Option<i64>, metrics: Option<bool>, logs: Option<bool>, events: Option<bool>, rum: Option<bool>) -> Box<dyn Future<Item = serde_json::Value, Error = Error<serde_json::Value>>>;
    fn get_using_get2(&self, app_ids: &str, tag: Vec<String>, from: Option<i64>, to: Option<i64>, metrics: Option<bool>, logs: Option<bool>, events: Option<bool>, rum: Option<bool>) -> Box<dyn Future<Item = serde_json::Value, Error = Error<serde_json::Value>>>;
    fn get_using_get3(&self, app_ids: &str, tag: Vec<String>, from: Option<i64>, to: Option<i64>, metrics: Option<bool>, logs: Option<bool>, events: Option<bool>, rum: Option<bool>) -> Box<dyn Future<Item = serde_json::Value, Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect>TagApiControllerApi for TagApiControllerApiClient<C> {
    fn get_tag_names_using_get(&self, app_ids: &str, from: Option<i64>, to: Option<i64>, metrics: Option<bool>, logs: Option<bool>, events: Option<bool>, rum: Option<bool>) -> Box<dyn Future<Item = serde_json::Value, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/spm-reports/api/v3/apps/{appIds}/tagNames".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        if let Some(ref s) = from {
            req = req.with_query_param("from".to_string(), s.to_string());
        }
        if let Some(ref s) = to {
            req = req.with_query_param("to".to_string(), s.to_string());
        }
        if let Some(ref s) = metrics {
            req = req.with_query_param("metrics".to_string(), s.to_string());
        }
        if let Some(ref s) = logs {
            req = req.with_query_param("logs".to_string(), s.to_string());
        }
        if let Some(ref s) = events {
            req = req.with_query_param("events".to_string(), s.to_string());
        }
        if let Some(ref s) = rum {
            req = req.with_query_param("rum".to_string(), s.to_string());
        }
        req = req.with_path_param("appIds".to_string(), app_ids.to_string());

        req.execute(self.configuration.borrow())
    }

    fn get_using_get2(&self, app_ids: &str, tag: Vec<String>, from: Option<i64>, to: Option<i64>, metrics: Option<bool>, logs: Option<bool>, events: Option<bool>, rum: Option<bool>) -> Box<dyn Future<Item = serde_json::Value, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/spm-reports/api/v3/apps/{appIds}/metrics/filters".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        if let Some(ref s) = from {
            req = req.with_query_param("from".to_string(), s.to_string());
        }
        if let Some(ref s) = to {
            req = req.with_query_param("to".to_string(), s.to_string());
        }
        req = req.with_query_param("tag".to_string(), tag.join(",").to_string());
        if let Some(ref s) = metrics {
            req = req.with_query_param("metrics".to_string(), s.to_string());
        }
        if let Some(ref s) = logs {
            req = req.with_query_param("logs".to_string(), s.to_string());
        }
        if let Some(ref s) = events {
            req = req.with_query_param("events".to_string(), s.to_string());
        }
        if let Some(ref s) = rum {
            req = req.with_query_param("rum".to_string(), s.to_string());
        }
        req = req.with_path_param("appIds".to_string(), app_ids.to_string());

        req.execute(self.configuration.borrow())
    }

    fn get_using_get3(&self, app_ids: &str, tag: Vec<String>, from: Option<i64>, to: Option<i64>, metrics: Option<bool>, logs: Option<bool>, events: Option<bool>, rum: Option<bool>) -> Box<dyn Future<Item = serde_json::Value, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/spm-reports/api/v3/apps/{appIds}/tags".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        if let Some(ref s) = from {
            req = req.with_query_param("from".to_string(), s.to_string());
        }
        if let Some(ref s) = to {
            req = req.with_query_param("to".to_string(), s.to_string());
        }
        req = req.with_query_param("tag".to_string(), tag.join(",").to_string());
        if let Some(ref s) = metrics {
            req = req.with_query_param("metrics".to_string(), s.to_string());
        }
        if let Some(ref s) = logs {
            req = req.with_query_param("logs".to_string(), s.to_string());
        }
        if let Some(ref s) = events {
            req = req.with_query_param("events".to_string(), s.to_string());
        }
        if let Some(ref s) = rum {
            req = req.with_query_param("rum".to_string(), s.to_string());
        }
        req = req.with_path_param("appIds".to_string(), app_ids.to_string());

        req.execute(self.configuration.borrow())
    }

}
