/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 *
 * Generated by: https://openapi-generator.tech
 */

use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;
use std::rc::Rc;

use futures::Future;
use hyper;
use serde_json;

use super::request as __internal_request;
use super::{configuration, Error};

pub struct SubscriptionsApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> SubscriptionsApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> SubscriptionsApiClient<C> {
        SubscriptionsApiClient { configuration }
    }
}

pub trait SubscriptionsApi {
    fn create_for_app_using_post(
        &self,
        app_id: i64,
        subscription: crate::models::SubscriptionDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn create_for_dash_using_post1(
        &self,
        dash_id: i64,
        subscription: crate::models::SubscriptionDashboardDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn delete_using_delete2(
        &self,
        updateable_subscription_id: i64,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn list_using_get2(
        &self,
        app_id: i64,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn list_using_get5(
        &self,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn send_app_report_using_post1(
        &self,
        app_id: i64,
        email_dto: crate::models::ReportInfo,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn send_dash_report_using_post1(
        &self,
        dash_id: i64,
        email_dto: crate::models::ReportInfo,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn toggle_enabled_using_put1(
        &self,
        updateable_subscription_id: i64,
        dto: crate::models::UpdateSubscriptionDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn update_for_app_using_put1(
        &self,
        app_id: i64,
        subscription: crate::models::SubscriptionDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn update_for_dash_using_put(
        &self,
        dash_id: i64,
        subscription: crate::models::SubscriptionDashboardDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect> SubscriptionsApi for SubscriptionsApiClient<C> {
    fn create_for_app_using_post(
        &self,
        app_id: i64,
        subscription: crate::models::SubscriptionDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Post,
            "/users-web/api/v3/apps/{appId}/subscription".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("appId".to_string(), app_id.to_string());
        req = req.with_body_param(subscription);

        req.execute(self.configuration.borrow())
    }

    fn create_for_dash_using_post1(
        &self,
        dash_id: i64,
        subscription: crate::models::SubscriptionDashboardDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Post,
            "/users-web/api/v3/dashboards/{dashId}/subscription".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("dashId".to_string(), dash_id.to_string());
        req = req.with_body_param(subscription);

        req.execute(self.configuration.borrow())
    }

    fn delete_using_delete2(
        &self,
        updateable_subscription_id: i64,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Delete,
            "/users-web/api/v3/subscriptions/{updateableSubscriptionId}".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param(
            "updateableSubscriptionId".to_string(),
            updateable_subscription_id.to_string(),
        );

        req.execute(self.configuration.borrow())
    }

    fn list_using_get2(
        &self,
        app_id: i64,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Get,
            "/users-web/api/v3/apps/{appId}/subscriptions".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("appId".to_string(), app_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn list_using_get5(
        &self,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let req = __internal_request::Request::new(
            hyper::Method::Get,
            "/users-web/api/v3/subscriptions".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));

        req.execute(self.configuration.borrow())
    }

    fn send_app_report_using_post1(
        &self,
        app_id: i64,
        email_dto: crate::models::ReportInfo,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Post,
            "/users-web/api/v3/apps/{appId}/report/send".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("appId".to_string(), app_id.to_string());
        req = req.with_body_param(email_dto);

        req.execute(self.configuration.borrow())
    }

    fn send_dash_report_using_post1(
        &self,
        dash_id: i64,
        email_dto: crate::models::ReportInfo,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Post,
            "/users-web/api/v3/dashboards/{dashId}/report/send".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("dashId".to_string(), dash_id.to_string());
        req = req.with_body_param(email_dto);

        req.execute(self.configuration.borrow())
    }

    fn toggle_enabled_using_put1(
        &self,
        updateable_subscription_id: i64,
        dto: crate::models::UpdateSubscriptionDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Put,
            "/users-web/api/v3/subscriptions/{updateableSubscriptionId}".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param(
            "updateableSubscriptionId".to_string(),
            updateable_subscription_id.to_string(),
        );
        req = req.with_body_param(dto);

        req.execute(self.configuration.borrow())
    }

    fn update_for_app_using_put1(
        &self,
        app_id: i64,
        subscription: crate::models::SubscriptionDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Put,
            "/users-web/api/v3/apps/{appId}/subscription".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("appId".to_string(), app_id.to_string());
        req = req.with_body_param(subscription);

        req.execute(self.configuration.borrow())
    }

    fn update_for_dash_using_put(
        &self,
        dash_id: i64,
        subscription: crate::models::SubscriptionDashboardDto,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Put,
            "/users-web/api/v3/dashboards/{dashId}/subscription".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("dashId".to_string(), dash_id.to_string());
        req = req.with_body_param(subscription);

        req.execute(self.configuration.borrow())
    }
}
