/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use serde_json;
use futures::Future;

use super::{Error, configuration};
use super::request as __internal_request;

pub struct SavedQueriesApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> SavedQueriesApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> SavedQueriesApiClient<C> {
        SavedQueriesApiClient {
            configuration,
        }
    }
}

pub trait SavedQueriesApi {
    fn delete_saved_query_using_delete(&self, updateable_query_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn get_saved_queries_for_app_using_get(&self, app_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn save_query_using_post(&self, saved_query_dto: crate::models::SavedQuery) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn save_query_using_put(&self, updateable_query_id: i64, saved_query_dto: crate::models::SavedQuery) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect>SavedQueriesApi for SavedQueriesApiClient<C> {
    fn delete_saved_query_using_delete(&self, updateable_query_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Delete, "/users-web/api/v3/savedQueries/{updateableQueryId}".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("updateableQueryId".to_string(), updateable_query_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn get_saved_queries_for_app_using_get(&self, app_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/users-web/api/v3/apps/{appId}/savedQueries".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("appId".to_string(), app_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn save_query_using_post(&self, saved_query_dto: crate::models::SavedQuery) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Post, "/users-web/api/v3/savedQueries".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_body_param(saved_query_dto);

        req.execute(self.configuration.borrow())
    }

    fn save_query_using_put(&self, updateable_query_id: i64, saved_query_dto: crate::models::SavedQuery) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Put, "/users-web/api/v3/savedQueries/{updateableQueryId}".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("updateableQueryId".to_string(), updateable_query_id.to_string());
        req = req.with_body_param(saved_query_dto);

        req.execute(self.configuration.borrow())
    }

}
