/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 *
 * Generated by: https://openapi-generator.tech
 */

use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;
use std::rc::Rc;

use futures::Future;
use hyper;
use serde_json;

use super::request as __internal_request;
use super::{configuration, Error};

pub struct AppsApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> AppsApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> AppsApiClient<C> {
        AppsApiClient { configuration }
    }
}

pub trait AppsApi {
    fn delete_using_delete(
        &self,
        any_state_app_id: i64,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn get_app_types_using_get1(
        &self,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn get_using_get(
        &self,
        any_state_app_id: i64,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn invite_app_guests_using_post(
        &self,
        invitation: crate::models::Invitation,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn list_apps_users_using_get(
        &self,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn list_using_get1(
        &self,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn update_description_using_put(
        &self,
        any_state_app_id: i64,
        update_details: Option<crate::models::AppDescription>,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn update_using_put3(
        &self,
        any_state_app_id: i64,
        dto: crate::models::UpdateAppInfo,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect> AppsApi for AppsApiClient<C> {
    fn delete_using_delete(
        &self,
        any_state_app_id: i64,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Delete,
            "/users-web/api/v3/apps/{anyStateAppId}".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("anyStateAppId".to_string(), any_state_app_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn get_app_types_using_get1(
        &self,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let req = __internal_request::Request::new(
            hyper::Method::Get,
            "/users-web/api/v3/apps/types".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));

        req.execute(self.configuration.borrow())
    }

    fn get_using_get(
        &self,
        any_state_app_id: i64,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Get,
            "/users-web/api/v3/apps/{anyStateAppId}".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("anyStateAppId".to_string(), any_state_app_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn invite_app_guests_using_post(
        &self,
        invitation: crate::models::Invitation,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Post,
            "/users-web/api/v3/apps/guests".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_body_param(invitation);

        req.execute(self.configuration.borrow())
    }

    fn list_apps_users_using_get(
        &self,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let req = __internal_request::Request::new(
            hyper::Method::Get,
            "/users-web/api/v3/apps/users".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));

        req.execute(self.configuration.borrow())
    }

    fn list_using_get1(
        &self,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let req = __internal_request::Request::new(
            hyper::Method::Get,
            "/users-web/api/v3/apps".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));

        req.execute(self.configuration.borrow())
    }

    fn update_description_using_put(
        &self,
        any_state_app_id: i64,
        update_details: Option<crate::models::AppDescription>,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Put,
            "/users-web/api/v3/apps/{anyStateAppId}/description".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("anyStateAppId".to_string(), any_state_app_id.to_string());
        req = req.with_body_param(update_details);

        req.execute(self.configuration.borrow())
    }

    fn update_using_put3(
        &self,
        any_state_app_id: i64,
        dto: crate::models::UpdateAppInfo,
    ) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>
    {
        let mut req = __internal_request::Request::new(
            hyper::Method::Put,
            "/users-web/api/v3/apps/{anyStateAppId}".to_string(),
        )
        .with_auth(__internal_request::Auth::ApiKey(
            __internal_request::ApiKey {
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            },
        ));
        req = req.with_path_param("anyStateAppId".to_string(), any_state_app_id.to_string());
        req = req.with_body_param(dto);

        req.execute(self.configuration.borrow())
    }
}
