/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use serde_json;
use futures::Future;

use super::{Error, configuration};
use super::request as __internal_request;

pub struct AlertsApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> AlertsApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> AlertsApiClient<C> {
        AlertsApiClient {
            configuration,
        }
    }
}

pub trait AlertsApi {
    fn create_alert_using_post1(&self, dto: crate::models::AlertRule) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn delete_alert_rule_using_delete1(&self, updateable_alert_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn disable_alert_rule_using_put(&self, updateable_alert_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn enable_alert_rule_using_put1(&self, updateable_alert_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn get_alert_rules_for_app_using_get1(&self, app_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect>AlertsApi for AlertsApiClient<C> {
    fn create_alert_using_post1(&self, dto: crate::models::AlertRule) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Post, "/users-web/api/v3/alerts".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_body_param(dto);

        req.execute(self.configuration.borrow())
    }

    fn delete_alert_rule_using_delete1(&self, updateable_alert_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Delete, "/users-web/api/v3/alerts/{updateableAlertId}".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("updateableAlertId".to_string(), updateable_alert_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn disable_alert_rule_using_put(&self, updateable_alert_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Put, "/users-web/api/v3/alerts/{updateableAlertId}/disable".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("updateableAlertId".to_string(), updateable_alert_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn enable_alert_rule_using_put1(&self, updateable_alert_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Put, "/users-web/api/v3/alerts/{updateableAlertId}/enable".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("updateableAlertId".to_string(), updateable_alert_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn get_alert_rules_for_app_using_get1(&self, app_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/users-web/api/v3/apps/{appId}/alerts".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("appId".to_string(), app_id.to_string());

        req.execute(self.configuration.borrow())
    }

}
