/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UserRole {
    #[serde(rename = "role", skip_serializing_if = "Option::is_none")]
    pub role: Option<Role>,
    #[serde(rename = "roleStatus", skip_serializing_if = "Option::is_none")]
    pub role_status: Option<RoleStatus>,
    #[serde(rename = "userEmail", skip_serializing_if = "Option::is_none")]
    pub user_email: Option<String>,
}

impl UserRole {
    pub fn new() -> UserRole {
        UserRole {
            role: None,
            role_status: None,
            user_email: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Role {
    #[serde(rename = "SUPER_USER")]
    SUPERUSER,
    #[serde(rename = "OWNER")]
    OWNER,
    #[serde(rename = "ADMIN")]
    ADMIN,
    #[serde(rename = "USER")]
    USER,
    #[serde(rename = "DEMO")]
    DEMO,
    #[serde(rename = "ANONYMOUS")]
    ANONYMOUS,
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum RoleStatus {
    #[serde(rename = "INACTIVE")]
    INACTIVE,
    #[serde(rename = "ACTIVE")]
    ACTIVE,
}

