/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SubscriptionDto {
    #[serde(rename = "addresses", skip_serializing_if = "Option::is_none")]
    pub addresses: Option<String>,
    #[serde(rename = "enable", skip_serializing_if = "Option::is_none")]
    pub enable: Option<bool>,
    #[serde(rename = "filters", skip_serializing_if = "Option::is_none")]
    pub filters: Option<String>,
    #[serde(rename = "frequency", skip_serializing_if = "Option::is_none")]
    pub frequency: Option<Frequency>,
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    #[serde(rename = "reportName", skip_serializing_if = "Option::is_none")]
    pub report_name: Option<String>,
    #[serde(rename = "sendTime", skip_serializing_if = "Option::is_none")]
    pub send_time: Option<String>,
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(rename = "systemId", skip_serializing_if = "Option::is_none")]
    pub system_id: Option<i64>,
    #[serde(rename = "text", skip_serializing_if = "Option::is_none")]
    pub text: Option<String>,
    #[serde(rename = "timeRange", skip_serializing_if = "Option::is_none")]
    pub time_range: Option<TimeRange>,
    #[serde(rename = "userPermissions", skip_serializing_if = "Option::is_none")]
    pub user_permissions: Option<crate::models::UserPermissions>,
}

impl SubscriptionDto {
    pub fn new() -> SubscriptionDto {
        SubscriptionDto {
            addresses: None,
            enable: None,
            filters: None,
            frequency: None,
            id: None,
            report_name: None,
            send_time: None,
            subject: None,
            system_id: None,
            text: None,
            time_range: None,
            user_permissions: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Frequency {
    #[serde(rename = "EVERY_FIVE_MINUTES")]
    EVERYFIVEMINUTES,
    #[serde(rename = "DAILY")]
    DAILY,
    #[serde(rename = "WEEKLY")]
    WEEKLY,
    #[serde(rename = "MONTHLY")]
    MONTHLY,
    #[serde(rename = "QUARTERLY")]
    QUARTERLY,
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum TimeRange {
    #[serde(rename = "ONE_DAY")]
    ONEDAY,
    #[serde(rename = "ONE_WEEK")]
    ONEWEEK,
    #[serde(rename = "ONE_MONTH")]
    ONEMONTH,
    #[serde(rename = "TWO_MONTH")]
    TWOMONTH,
    #[serde(rename = "SIX_MONTH")]
    SIXMONTH,
    #[serde(rename = "ONE_YEAR")]
    ONEYEAR,
}

