/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Plan {
    #[serde(rename = "appType", skip_serializing_if = "Option::is_none")]
    pub app_type: Option<String>,
    #[serde(rename = "custom", skip_serializing_if = "Option::is_none")]
    pub custom: Option<bool>,
    #[serde(rename = "dataRetentionHours", skip_serializing_if = "Option::is_none")]
    pub data_retention_hours: Option<f32>,
    #[serde(rename = "defaultTrialPlan", skip_serializing_if = "Option::is_none")]
    pub default_trial_plan: Option<bool>,
    #[serde(rename = "free", skip_serializing_if = "Option::is_none")]
    pub free: Option<bool>,
    #[serde(rename = "freeTrialDays", skip_serializing_if = "Option::is_none")]
    pub free_trial_days: Option<i64>,
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    #[serde(rename = "maxAlerts", skip_serializing_if = "Option::is_none")]
    pub max_alerts: Option<i64>,
    #[serde(rename = "maxDailyEvents", skip_serializing_if = "Option::is_none")]
    pub max_daily_events: Option<i64>,
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "planScheme", skip_serializing_if = "Option::is_none")]
    pub plan_scheme: Option<PlanScheme>,
    #[serde(rename = "sematextService", skip_serializing_if = "Option::is_none")]
    pub sematext_service: Option<SematextService>,
    #[serde(rename = "trialPlan", skip_serializing_if = "Option::is_none")]
    pub trial_plan: Option<bool>,
}

impl Plan {
    pub fn new() -> Plan {
        Plan {
            app_type: None,
            custom: None,
            data_retention_hours: None,
            default_trial_plan: None,
            free: None,
            free_trial_days: None,
            id: None,
            max_alerts: None,
            max_daily_events: None,
            name: None,
            plan_scheme: None,
            sematext_service: None,
            trial_plan: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum PlanScheme {
    #[serde(rename = "SPM_1_0")]
    SPM10,
    #[serde(rename = "SPM_2_0")]
    SPM20,
    #[serde(rename = "SA_1_0")]
    SA10,
    #[serde(rename = "SEARCHENE_1_0")]
    SEARCHENE10,
    #[serde(rename = "LOGSENE_1_0")]
    LOGSENE10,
    #[serde(rename = "LOGSENE_2_0")]
    LOGSENE20,
    #[serde(rename = "RUM_1_0")]
    RUM10,
    #[serde(rename = "RUM_1_1")]
    RUM11,
    #[serde(rename = "RUM_EA")]
    RUMEA,
    #[serde(rename = "SYNTHETICS_EA")]
    SYNTHETICSEA,
    #[serde(rename = "SYNTHETICS_1_0")]
    SYNTHETICS10,
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum SematextService {
    #[serde(rename = "LOGSENE")]
    LOGSENE,
    #[serde(rename = "SPM")]
    SPM,
    #[serde(rename = "RUM")]
    RUM,
    #[serde(rename = "SYNTHETICS")]
    SYNTHETICS,
}

