/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct NotificationIntegration {
    #[serde(rename = "applicability", skip_serializing_if = "Option::is_none")]
    pub applicability: Option<Applicability>,
    #[serde(rename = "createDate", skip_serializing_if = "Option::is_none")]
    pub create_date: Option<String>,
    #[serde(rename = "createdByOwner", skip_serializing_if = "Option::is_none")]
    pub created_by_owner: Option<bool>,
    #[serde(rename = "creatorId", skip_serializing_if = "Option::is_none")]
    pub creator_id: Option<i64>,
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    #[serde(rename = "integrationType", skip_serializing_if = "Option::is_none")]
    pub integration_type: Option<IntegrationType>,
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "params", skip_serializing_if = "Option::is_none")]
    pub params: Option<::std::collections::HashMap<String, String>>,
    #[serde(rename = "state", skip_serializing_if = "Option::is_none")]
    pub state: Option<State>,
    #[serde(rename = "userId", skip_serializing_if = "Option::is_none")]
    pub user_id: Option<i64>,
}

impl NotificationIntegration {
    pub fn new() -> NotificationIntegration {
        NotificationIntegration {
            applicability: None,
            create_date: None,
            created_by_owner: None,
            creator_id: None,
            id: None,
            integration_type: None,
            name: None,
            params: None,
            state: None,
            user_id: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Applicability {
    #[serde(rename = "NONE")]
    NONE,
    #[serde(rename = "USE_ALWAYS")]
    USEALWAYS,
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum IntegrationType {
    #[serde(rename = "PAGER_DUTY")]
    PAGERDUTY,
    #[serde(rename = "NAGIOS")]
    NAGIOS,
    #[serde(rename = "WEB_HOOKS")]
    WEBHOOKS,
    #[serde(rename = "WEB_HOOKS_TEMPLATE")]
    WEBHOOKSTEMPLATE,
    #[serde(rename = "HIP_CHAT")]
    HIPCHAT,
    #[serde(rename = "EMAIL_LIST")]
    EMAILLIST,
    #[serde(rename = "TEMPORARY_EMAIL_LIST")]
    TEMPORARYEMAILLIST,
}
/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum State {
    #[serde(rename = "ACTIVE")]
    ACTIVE,
    #[serde(rename = "DISABLED")]
    DISABLED,
    #[serde(rename = "DELETED")]
    DELETED,
}

