/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */

/// GenericApiResponse : Generic wrapper class for all API responses



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct GenericApiResponse {
    /// Contains actual data when response is successful. Key and Value is specific to each endpoint
    #[serde(rename = "data", skip_serializing_if = "Option::is_none")]
    pub data: Option<serde_json::Value>,
    #[serde(rename = "errors", skip_serializing_if = "Option::is_none")]
    pub errors: Option<Vec<crate::models::Error>>,
    #[serde(rename = "message", skip_serializing_if = "Option::is_none")]
    pub message: Option<String>,
    #[serde(rename = "success", skip_serializing_if = "Option::is_none")]
    pub success: Option<bool>,
}

impl GenericApiResponse {
    /// Generic wrapper class for all API responses
    pub fn new() -> GenericApiResponse {
        GenericApiResponse {
            data: None,
            errors: None,
            message: None,
            success: None,
        }
    }
}


