/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AlertRule {
    #[serde(rename = "accountEmail", skip_serializing_if = "Option::is_none")]
    pub account_email: Option<String>,
    #[serde(rename = "allowedAppTypes", skip_serializing_if = "Option::is_none")]
    pub allowed_app_types: Option<Vec<i64>>,
    #[serde(rename = "analyzingTime", skip_serializing_if = "Option::is_none")]
    pub analyzing_time: Option<String>,
    #[serde(rename = "appDisplayState", skip_serializing_if = "Option::is_none")]
    pub app_display_state: Option<String>,
    #[serde(rename = "appId", skip_serializing_if = "Option::is_none")]
    pub app_id: Option<i64>,
    #[serde(rename = "appName", skip_serializing_if = "Option::is_none")]
    pub app_name: Option<String>,
    #[serde(rename = "appState", skip_serializing_if = "Option::is_none")]
    pub app_state: Option<String>,
    #[serde(rename = "appToken", skip_serializing_if = "Option::is_none")]
    pub app_token: Option<String>,
    #[serde(rename = "appType", skip_serializing_if = "Option::is_none")]
    pub app_type: Option<String>,
    #[serde(rename = "backToNormalNeeded", skip_serializing_if = "Option::is_none")]
    pub back_to_normal_needed: Option<bool>,
    #[serde(rename = "chartKey", skip_serializing_if = "Option::is_none")]
    pub chart_key: Option<String>,
    #[serde(rename = "color", skip_serializing_if = "Option::is_none")]
    pub color: Option<String>,
    #[serde(rename = "creatorEmail", skip_serializing_if = "Option::is_none")]
    pub creator_email: Option<String>,
    #[serde(rename = "defaultAggType", skip_serializing_if = "Option::is_none")]
    pub default_agg_type: Option<String>,
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "disallowedAppTypes", skip_serializing_if = "Option::is_none")]
    pub disallowed_app_types: Option<Vec<i64>>,
    #[serde(rename = "enabled", skip_serializing_if = "Option::is_none")]
    pub enabled: Option<bool>,
    #[serde(rename = "estimateOperation", skip_serializing_if = "Option::is_none")]
    pub estimate_operation: Option<EstimateOperation>,
    #[serde(rename = "estimateValue", skip_serializing_if = "Option::is_none")]
    pub estimate_value: Option<f64>,
    #[serde(rename = "filterValues", skip_serializing_if = "Option::is_none")]
    pub filter_values: Option<String>,
    #[serde(rename = "filterValuesObj", skip_serializing_if = "Option::is_none")]
    pub filter_values_obj: Option<Vec<crate::models::FilterValue>>,
    #[serde(rename = "ignoreRegularEventsEnabled", skip_serializing_if = "Option::is_none")]
    pub ignore_regular_events_enabled: Option<bool>,
    #[serde(rename = "integrations", skip_serializing_if = "Option::is_none")]
    pub integrations: Option<String>,
    #[serde(rename = "lastDataReceivedDate", skip_serializing_if = "Option::is_none")]
    pub last_data_received_date: Option<i64>,
    #[serde(rename = "lastSent", skip_serializing_if = "Option::is_none")]
    pub last_sent: Option<i64>,
    #[serde(rename = "lastTriggered", skip_serializing_if = "Option::is_none")]
    pub last_triggered: Option<i64>,
    #[serde(rename = "metadata", skip_serializing_if = "Option::is_none")]
    pub metadata: Option<serde_json::Value>,
    #[serde(rename = "metricKey", skip_serializing_if = "Option::is_none")]
    pub metric_key: Option<String>,
    #[serde(rename = "metricLabel", skip_serializing_if = "Option::is_none")]
    pub metric_label: Option<String>,
    #[serde(rename = "minDelayBetweenNotificationsInMinutes", skip_serializing_if = "Option::is_none")]
    pub min_delay_between_notifications_in_minutes: Option<String>,
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "notificationEmails", skip_serializing_if = "Option::is_none")]
    pub notification_emails: Option<Vec<String>>,
    #[serde(rename = "notificationIntegrations", skip_serializing_if = "Option::is_none")]
    pub notification_integrations: Option<Vec<crate::models::NotificationIntegration>>,
    #[serde(rename = "notificationsEnabled", skip_serializing_if = "Option::is_none")]
    pub notifications_enabled: Option<bool>,
    #[serde(rename = "query", skip_serializing_if = "Option::is_none")]
    pub query: Option<String>,
    #[serde(rename = "reportName", skip_serializing_if = "Option::is_none")]
    pub report_name: Option<String>,
    #[serde(rename = "ruleKey", skip_serializing_if = "Option::is_none")]
    pub rule_key: Option<i64>,
    #[serde(rename = "ruleType", skip_serializing_if = "Option::is_none")]
    pub rule_type: Option<String>,
    #[serde(rename = "runbook", skip_serializing_if = "Option::is_none")]
    pub runbook: Option<String>,
    #[serde(rename = "savedQueryId", skip_serializing_if = "Option::is_none")]
    pub saved_query_id: Option<i64>,
    #[serde(rename = "schedule", skip_serializing_if = "Option::is_none")]
    pub schedule: Option<Vec<crate::models::AlertRuleScheduleWeekdayDto>>,
    #[serde(rename = "sematextService", skip_serializing_if = "Option::is_none")]
    pub sematext_service: Option<String>,
    #[serde(rename = "sendToEmail", skip_serializing_if = "Option::is_none")]
    pub send_to_email: Option<String>,
    #[serde(rename = "timezone", skip_serializing_if = "Option::is_none")]
    pub timezone: Option<String>,
    #[serde(rename = "useOnlyAlertRuleIntegrations", skip_serializing_if = "Option::is_none")]
    pub use_only_alert_rule_integrations: Option<bool>,
    #[serde(rename = "userPermissions", skip_serializing_if = "Option::is_none")]
    pub user_permissions: Option<crate::models::UserPermissions>,
    #[serde(rename = "valueColumnName", skip_serializing_if = "Option::is_none")]
    pub value_column_name: Option<String>,
    #[serde(rename = "valueName", skip_serializing_if = "Option::is_none")]
    pub value_name: Option<String>,
}

impl AlertRule {
    pub fn new() -> AlertRule {
        AlertRule {
            account_email: None,
            allowed_app_types: None,
            analyzing_time: None,
            app_display_state: None,
            app_id: None,
            app_name: None,
            app_state: None,
            app_token: None,
            app_type: None,
            back_to_normal_needed: None,
            chart_key: None,
            color: None,
            creator_email: None,
            default_agg_type: None,
            description: None,
            disallowed_app_types: None,
            enabled: None,
            estimate_operation: None,
            estimate_value: None,
            filter_values: None,
            filter_values_obj: None,
            ignore_regular_events_enabled: None,
            integrations: None,
            last_data_received_date: None,
            last_sent: None,
            last_triggered: None,
            metadata: None,
            metric_key: None,
            metric_label: None,
            min_delay_between_notifications_in_minutes: None,
            name: None,
            notification_emails: None,
            notification_integrations: None,
            notifications_enabled: None,
            query: None,
            report_name: None,
            rule_key: None,
            rule_type: None,
            runbook: None,
            saved_query_id: None,
            schedule: None,
            sematext_service: None,
            send_to_email: None,
            timezone: None,
            use_only_alert_rule_integrations: None,
            user_permissions: None,
            value_column_name: None,
            value_name: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum EstimateOperation {
    #[serde(rename = "LESS")]
    LESS,
    #[serde(rename = "MORE")]
    MORE,
    #[serde(rename = "EQUAL")]
    EQUAL,
    #[serde(rename = "UN_EQUAL")]
    UNEQUAL,
    #[serde(rename = "LESS_OR_EQUAL")]
    LESSOREQUAL,
    #[serde(rename = "MORE_OR_EQUAL")]
    MOREOREQUAL,
}

