/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use serde_json;
use futures::Future;

use super::{Error, configuration};
use super::request as __internal_request;

pub struct TokensApiControllerApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> TokensApiControllerApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> TokensApiControllerApiClient<C> {
        TokensApiControllerApiClient {
            configuration,
        }
    }
}

pub trait TokensApiControllerApi {
    fn create_app_token(&self, app_id: i64, dto: crate::models::CreateTokenDto) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn delete_app_token1(&self, app_id: i64, token_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn get_app_tokens1(&self, app_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn regenerate_app_token(&self, app_id: i64, token_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn update_app_token1(&self, app_id: i64, token_id: i64, dto: crate::models::UpdateTokenDto) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect>TokensApiControllerApi for TokensApiControllerApiClient<C> {
    fn create_app_token(&self, app_id: i64, dto: crate::models::CreateTokenDto) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Post, "/users-web/api/v3/apps/{appId}/tokens".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("appId".to_string(), app_id.to_string());
        req = req.with_body_param(dto);

        req.execute(self.configuration.borrow())
    }

    fn delete_app_token1(&self, app_id: i64, token_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Delete, "/users-web/api/v3/apps/{appId}/tokens/{tokenId}".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("appId".to_string(), app_id.to_string());
        req = req.with_path_param("tokenId".to_string(), token_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn get_app_tokens1(&self, app_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/users-web/api/v3/apps/{appId}/tokens".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("appId".to_string(), app_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn regenerate_app_token(&self, app_id: i64, token_id: i64) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Post, "/users-web/api/v3/apps/{appId}/tokens/{tokenId}/regenerate".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("appId".to_string(), app_id.to_string());
        req = req.with_path_param("tokenId".to_string(), token_id.to_string());

        req.execute(self.configuration.borrow())
    }

    fn update_app_token1(&self, app_id: i64, token_id: i64, dto: crate::models::UpdateTokenDto) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Put, "/users-web/api/v3/apps/{appId}/tokens/{tokenId}".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("appId".to_string(), app_id.to_string());
        req = req.with_path_param("tokenId".to_string(), token_id.to_string());
        req = req.with_body_param(dto);

        req.execute(self.configuration.borrow())
    }

}
