/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use serde_json;
use futures::Future;

use super::{Error, configuration};
use super::request as __internal_request;

pub struct ResetPasswordApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> ResetPasswordApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> ResetPasswordApiClient<C> {
        ResetPasswordApiClient {
            configuration,
        }
    }
}

pub trait ResetPasswordApi {
    fn reset_password_using_post1(&self, dto: crate::models::UserInfo) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect>ResetPasswordApi for ResetPasswordApiClient<C> {
    fn reset_password_using_post1(&self, dto: crate::models::UserInfo) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Post, "/users-web/api/v3/account/password/reset".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_body_param(dto);

        req.execute(self.configuration.borrow())
    }

}
