/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use serde_json;
use futures::Future;

use super::{Error, configuration};
use super::request as __internal_request;

pub struct MonitoringAppApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> MonitoringAppApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> MonitoringAppApiClient<C> {
        MonitoringAppApiClient {
            configuration,
        }
    }
}

pub trait MonitoringAppApi {
    fn create_spm_application(&self, application_details: crate::models::CreateAppInfo) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect>MonitoringAppApi for MonitoringAppApiClient<C> {
    fn create_spm_application(&self, application_details: crate::models::CreateAppInfo) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Post, "/spm-reports/api/v3/apps".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_body_param(application_details);

        req.execute(self.configuration.borrow())
    }

}
