/*
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * The version of the OpenAPI document: v3
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use serde_json;
use futures::Future;

use super::{Error, configuration};
use super::request as __internal_request;

pub struct BillingApiClient<C: hyper::client::Connect> {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::Connect> BillingApiClient<C> {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> BillingApiClient<C> {
        BillingApiClient {
            configuration,
        }
    }
}

pub trait BillingApi {
    fn get_detailed_invoice_using_get1(&self, service: &str, year: i32, month: i32) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn list_available_plans_using_get1(&self, integration_id: Option<i64>, app_type: Option<&str>) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
    fn update_plan_using_put(&self, app_id: i64, dto: crate::models::BillingInfo) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>>;
}

impl<C: hyper::client::Connect>BillingApi for BillingApiClient<C> {
    fn get_detailed_invoice_using_get1(&self, service: &str, year: i32, month: i32) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/users-web/api/v3/billing/invoice/{service}/{year}/{month}".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("service".to_string(), service.to_string());
        req = req.with_path_param("year".to_string(), year.to_string());
        req = req.with_path_param("month".to_string(), month.to_string());

        req.execute(self.configuration.borrow())
    }

    fn list_available_plans_using_get1(&self, integration_id: Option<i64>, app_type: Option<&str>) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Get, "/users-web/api/v3/billing/availablePlans".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        if let Some(ref s) = integration_id {
            req = req.with_query_param("integrationId".to_string(), s.to_string());
        }
        if let Some(ref s) = app_type {
            req = req.with_query_param("appType".to_string(), s.to_string());
        }

        req.execute(self.configuration.borrow())
    }

    fn update_plan_using_put(&self, app_id: i64, dto: crate::models::BillingInfo) -> Box<dyn Future<Item = crate::models::GenericApiResponse, Error = Error<serde_json::Value>>> {
        let mut req = __internal_request::Request::new(hyper::Method::Put, "/users-web/api/v3/billing/info/{appId}".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "Authorization".to_owned(),
            }))
        ;
        req = req.with_path_param("appId".to_string(), app_id.to_string());
        req = req.with_body_param(dto);

        req.execute(self.configuration.borrow())
    }

}
