/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct FilterValue {
  #[serde(rename = "aggType")]
  agg_type: Option<String>,
  #[serde(rename = "filterName")]
  filter_name: Option<String>,
  #[serde(rename = "key")]
  key: Option<String>,
  #[serde(rename = "label")]
  label: Option<String>,
  #[serde(rename = "name")]
  name: Option<String>,
  #[serde(rename = "values")]
  values: Option<Vec<String>>
}

impl FilterValue {
  pub fn new() -> FilterValue {
    FilterValue {
      agg_type: None,
      filter_name: None,
      key: None,
      label: None,
      name: None,
      values: None
    }
  }

  pub fn set_agg_type(&mut self, agg_type: String) {
    self.agg_type = Some(agg_type);
  }

  pub fn with_agg_type(mut self, agg_type: String) -> FilterValue {
    self.agg_type = Some(agg_type);
    self
  }

  pub fn agg_type(&self) -> Option<&String> {
    self.agg_type.as_ref()
  }

  pub fn reset_agg_type(&mut self) {
    self.agg_type = None;
  }

  pub fn set_filter_name(&mut self, filter_name: String) {
    self.filter_name = Some(filter_name);
  }

  pub fn with_filter_name(mut self, filter_name: String) -> FilterValue {
    self.filter_name = Some(filter_name);
    self
  }

  pub fn filter_name(&self) -> Option<&String> {
    self.filter_name.as_ref()
  }

  pub fn reset_filter_name(&mut self) {
    self.filter_name = None;
  }

  pub fn set_key(&mut self, key: String) {
    self.key = Some(key);
  }

  pub fn with_key(mut self, key: String) -> FilterValue {
    self.key = Some(key);
    self
  }

  pub fn key(&self) -> Option<&String> {
    self.key.as_ref()
  }

  pub fn reset_key(&mut self) {
    self.key = None;
  }

  pub fn set_label(&mut self, label: String) {
    self.label = Some(label);
  }

  pub fn with_label(mut self, label: String) -> FilterValue {
    self.label = Some(label);
    self
  }

  pub fn label(&self) -> Option<&String> {
    self.label.as_ref()
  }

  pub fn reset_label(&mut self) {
    self.label = None;
  }

  pub fn set_name(&mut self, name: String) {
    self.name = Some(name);
  }

  pub fn with_name(mut self, name: String) -> FilterValue {
    self.name = Some(name);
    self
  }

  pub fn name(&self) -> Option<&String> {
    self.name.as_ref()
  }

  pub fn reset_name(&mut self) {
    self.name = None;
  }

  pub fn set_values(&mut self, values: Vec<String>) {
    self.values = Some(values);
  }

  pub fn with_values(mut self, values: Vec<String>) -> FilterValue {
    self.values = Some(values);
    self
  }

  pub fn values(&self) -> Option<&Vec<String>> {
    self.values.as_ref()
  }

  pub fn reset_values(&mut self) {
    self.values = None;
  }

}



