/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct DataSeriesRequest {
  #[serde(rename = "defaultInterval")]
  default_interval: Option<i64>,
  /// End time of interval. Can be expressed as timestamp in milliseconds or UTC date in yyyy-MM-dd HH:mm:ss format
  #[serde(rename = "end")]
  end: Option<String>,
  /// Map of allowed filter values and aggregation strategy. List of available filter values can be fetched using metric filters endpoint and default aggregation strategy depends on metric
  #[serde(rename = "filters")]
  filters: Option<::std::collections::HashMap<String, ::models::DataSeriesFilter>>,
  /// Data points interval granularity between two data points.Default value is \"AUTO\" - calculated based on selected time span. Not required while getting filters.
  #[serde(rename = "granularity")]
  granularity: Option<String>,
  #[serde(rename = "interval")]
  interval: Option<String>,
  /// Metric name or metric group prefix
  #[serde(rename = "metric")]
  metric: String,
  /// Start time of interval. Can be expressed as timestamp in milliseconds or UTC date in yyyy-MM-dd HH:mm:ss format
  #[serde(rename = "start")]
  start: Option<String>
}

impl DataSeriesRequest {
  pub fn new(metric: String) -> DataSeriesRequest {
    DataSeriesRequest {
      default_interval: None,
      end: None,
      filters: None,
      granularity: None,
      interval: None,
      metric: metric,
      start: None
    }
  }

  pub fn set_default_interval(&mut self, default_interval: i64) {
    self.default_interval = Some(default_interval);
  }

  pub fn with_default_interval(mut self, default_interval: i64) -> DataSeriesRequest {
    self.default_interval = Some(default_interval);
    self
  }

  pub fn default_interval(&self) -> Option<&i64> {
    self.default_interval.as_ref()
  }

  pub fn reset_default_interval(&mut self) {
    self.default_interval = None;
  }

  pub fn set_end(&mut self, end: String) {
    self.end = Some(end);
  }

  pub fn with_end(mut self, end: String) -> DataSeriesRequest {
    self.end = Some(end);
    self
  }

  pub fn end(&self) -> Option<&String> {
    self.end.as_ref()
  }

  pub fn reset_end(&mut self) {
    self.end = None;
  }

  pub fn set_filters(&mut self, filters: ::std::collections::HashMap<String, ::models::DataSeriesFilter>) {
    self.filters = Some(filters);
  }

  pub fn with_filters(mut self, filters: ::std::collections::HashMap<String, ::models::DataSeriesFilter>) -> DataSeriesRequest {
    self.filters = Some(filters);
    self
  }

  pub fn filters(&self) -> Option<&::std::collections::HashMap<String, ::models::DataSeriesFilter>> {
    self.filters.as_ref()
  }

  pub fn reset_filters(&mut self) {
    self.filters = None;
  }

  pub fn set_granularity(&mut self, granularity: String) {
    self.granularity = Some(granularity);
  }

  pub fn with_granularity(mut self, granularity: String) -> DataSeriesRequest {
    self.granularity = Some(granularity);
    self
  }

  pub fn granularity(&self) -> Option<&String> {
    self.granularity.as_ref()
  }

  pub fn reset_granularity(&mut self) {
    self.granularity = None;
  }

  pub fn set_interval(&mut self, interval: String) {
    self.interval = Some(interval);
  }

  pub fn with_interval(mut self, interval: String) -> DataSeriesRequest {
    self.interval = Some(interval);
    self
  }

  pub fn interval(&self) -> Option<&String> {
    self.interval.as_ref()
  }

  pub fn reset_interval(&mut self) {
    self.interval = None;
  }

  pub fn set_metric(&mut self, metric: String) {
    self.metric = metric;
  }

  pub fn with_metric(mut self, metric: String) -> DataSeriesRequest {
    self.metric = metric;
    self
  }

  pub fn metric(&self) -> &String {
    &self.metric
  }


  pub fn set_start(&mut self, start: String) {
    self.start = Some(start);
  }

  pub fn with_start(mut self, start: String) -> DataSeriesRequest {
    self.start = Some(start);
    self
  }

  pub fn start(&self) -> Option<&String> {
    self.start.as_ref()
  }

  pub fn reset_start(&mut self) {
    self.start = None;
  }

}



