/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct SavedQuery {
  #[serde(rename = "alertRule")]
  alert_rule: Option<::models::AlertRule>,
  #[serde(rename = "allowModification")]
  allow_modification: Option<bool>,
  #[serde(rename = "applicationId")]
  application_id: Option<String>,
  #[serde(rename = "applicationName")]
  application_name: Option<String>,
  #[serde(rename = "applicationToken")]
  application_token: Option<String>,
  #[serde(rename = "creatorEmail")]
  creator_email: Option<String>,
  #[serde(rename = "id")]
  id: Option<String>,
  #[serde(rename = "labelColor")]
  label_color: Option<String>,
  #[serde(rename = "logseneAlertType")]
  logsene_alert_type: Option<Value>,
  #[serde(rename = "ownerEmail")]
  owner_email: Option<String>,
  #[serde(rename = "queryName")]
  query_name: Option<String>,
  #[serde(rename = "queryString")]
  query_string: Option<String>,
  #[serde(rename = "userPermissions")]
  user_permissions: Option<::models::UserPermissions>
}

impl SavedQuery {
  pub fn new() -> SavedQuery {
    SavedQuery {
      alert_rule: None,
      allow_modification: None,
      application_id: None,
      application_name: None,
      application_token: None,
      creator_email: None,
      id: None,
      label_color: None,
      logsene_alert_type: None,
      owner_email: None,
      query_name: None,
      query_string: None,
      user_permissions: None
    }
  }

  pub fn set_alert_rule(&mut self, alert_rule: ::models::AlertRule) {
    self.alert_rule = Some(alert_rule);
  }

  pub fn with_alert_rule(mut self, alert_rule: ::models::AlertRule) -> SavedQuery {
    self.alert_rule = Some(alert_rule);
    self
  }

  pub fn alert_rule(&self) -> Option<&::models::AlertRule> {
    self.alert_rule.as_ref()
  }

  pub fn reset_alert_rule(&mut self) {
    self.alert_rule = None;
  }

  pub fn set_allow_modification(&mut self, allow_modification: bool) {
    self.allow_modification = Some(allow_modification);
  }

  pub fn with_allow_modification(mut self, allow_modification: bool) -> SavedQuery {
    self.allow_modification = Some(allow_modification);
    self
  }

  pub fn allow_modification(&self) -> Option<&bool> {
    self.allow_modification.as_ref()
  }

  pub fn reset_allow_modification(&mut self) {
    self.allow_modification = None;
  }

  pub fn set_application_id(&mut self, application_id: String) {
    self.application_id = Some(application_id);
  }

  pub fn with_application_id(mut self, application_id: String) -> SavedQuery {
    self.application_id = Some(application_id);
    self
  }

  pub fn application_id(&self) -> Option<&String> {
    self.application_id.as_ref()
  }

  pub fn reset_application_id(&mut self) {
    self.application_id = None;
  }

  pub fn set_application_name(&mut self, application_name: String) {
    self.application_name = Some(application_name);
  }

  pub fn with_application_name(mut self, application_name: String) -> SavedQuery {
    self.application_name = Some(application_name);
    self
  }

  pub fn application_name(&self) -> Option<&String> {
    self.application_name.as_ref()
  }

  pub fn reset_application_name(&mut self) {
    self.application_name = None;
  }

  pub fn set_application_token(&mut self, application_token: String) {
    self.application_token = Some(application_token);
  }

  pub fn with_application_token(mut self, application_token: String) -> SavedQuery {
    self.application_token = Some(application_token);
    self
  }

  pub fn application_token(&self) -> Option<&String> {
    self.application_token.as_ref()
  }

  pub fn reset_application_token(&mut self) {
    self.application_token = None;
  }

  pub fn set_creator_email(&mut self, creator_email: String) {
    self.creator_email = Some(creator_email);
  }

  pub fn with_creator_email(mut self, creator_email: String) -> SavedQuery {
    self.creator_email = Some(creator_email);
    self
  }

  pub fn creator_email(&self) -> Option<&String> {
    self.creator_email.as_ref()
  }

  pub fn reset_creator_email(&mut self) {
    self.creator_email = None;
  }

  pub fn set_id(&mut self, id: String) {
    self.id = Some(id);
  }

  pub fn with_id(mut self, id: String) -> SavedQuery {
    self.id = Some(id);
    self
  }

  pub fn id(&self) -> Option<&String> {
    self.id.as_ref()
  }

  pub fn reset_id(&mut self) {
    self.id = None;
  }

  pub fn set_label_color(&mut self, label_color: String) {
    self.label_color = Some(label_color);
  }

  pub fn with_label_color(mut self, label_color: String) -> SavedQuery {
    self.label_color = Some(label_color);
    self
  }

  pub fn label_color(&self) -> Option<&String> {
    self.label_color.as_ref()
  }

  pub fn reset_label_color(&mut self) {
    self.label_color = None;
  }

  pub fn set_logsene_alert_type(&mut self, logsene_alert_type: Value) {
    self.logsene_alert_type = Some(logsene_alert_type);
  }

  pub fn with_logsene_alert_type(mut self, logsene_alert_type: Value) -> SavedQuery {
    self.logsene_alert_type = Some(logsene_alert_type);
    self
  }

  pub fn logsene_alert_type(&self) -> Option<&Value> {
    self.logsene_alert_type.as_ref()
  }

  pub fn reset_logsene_alert_type(&mut self) {
    self.logsene_alert_type = None;
  }

  pub fn set_owner_email(&mut self, owner_email: String) {
    self.owner_email = Some(owner_email);
  }

  pub fn with_owner_email(mut self, owner_email: String) -> SavedQuery {
    self.owner_email = Some(owner_email);
    self
  }

  pub fn owner_email(&self) -> Option<&String> {
    self.owner_email.as_ref()
  }

  pub fn reset_owner_email(&mut self) {
    self.owner_email = None;
  }

  pub fn set_query_name(&mut self, query_name: String) {
    self.query_name = Some(query_name);
  }

  pub fn with_query_name(mut self, query_name: String) -> SavedQuery {
    self.query_name = Some(query_name);
    self
  }

  pub fn query_name(&self) -> Option<&String> {
    self.query_name.as_ref()
  }

  pub fn reset_query_name(&mut self) {
    self.query_name = None;
  }

  pub fn set_query_string(&mut self, query_string: String) {
    self.query_string = Some(query_string);
  }

  pub fn with_query_string(mut self, query_string: String) -> SavedQuery {
    self.query_string = Some(query_string);
    self
  }

  pub fn query_string(&self) -> Option<&String> {
    self.query_string.as_ref()
  }

  pub fn reset_query_string(&mut self) {
    self.query_string = None;
  }

  pub fn set_user_permissions(&mut self, user_permissions: ::models::UserPermissions) {
    self.user_permissions = Some(user_permissions);
  }

  pub fn with_user_permissions(mut self, user_permissions: ::models::UserPermissions) -> SavedQuery {
    self.user_permissions = Some(user_permissions);
    self
  }

  pub fn user_permissions(&self) -> Option<&::models::UserPermissions> {
    self.user_permissions.as_ref()
  }

  pub fn reset_user_permissions(&mut self) {
    self.user_permissions = None;
  }

}



