/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct ReportInfo {
  /// Comma separated list of email addresses
  #[serde(rename = "addresses")]
  addresses: Option<String>,
  #[serde(rename = "appId")]
  app_id: Option<i64>,
  #[serde(rename = "endDate")]
  end_date: Option<String>,
  #[serde(rename = "filters")]
  filters: Option<String>,
  #[serde(rename = "reportName")]
  report_name: Option<String>,
  #[serde(rename = "startDate")]
  start_date: Option<String>,
  #[serde(rename = "subject")]
  subject: Option<String>,
  #[serde(rename = "text")]
  text: Option<String>
}

impl ReportInfo {
  pub fn new() -> ReportInfo {
    ReportInfo {
      addresses: None,
      app_id: None,
      end_date: None,
      filters: None,
      report_name: None,
      start_date: None,
      subject: None,
      text: None
    }
  }

  pub fn set_addresses(&mut self, addresses: String) {
    self.addresses = Some(addresses);
  }

  pub fn with_addresses(mut self, addresses: String) -> ReportInfo {
    self.addresses = Some(addresses);
    self
  }

  pub fn addresses(&self) -> Option<&String> {
    self.addresses.as_ref()
  }

  pub fn reset_addresses(&mut self) {
    self.addresses = None;
  }

  pub fn set_app_id(&mut self, app_id: i64) {
    self.app_id = Some(app_id);
  }

  pub fn with_app_id(mut self, app_id: i64) -> ReportInfo {
    self.app_id = Some(app_id);
    self
  }

  pub fn app_id(&self) -> Option<&i64> {
    self.app_id.as_ref()
  }

  pub fn reset_app_id(&mut self) {
    self.app_id = None;
  }

  pub fn set_end_date(&mut self, end_date: String) {
    self.end_date = Some(end_date);
  }

  pub fn with_end_date(mut self, end_date: String) -> ReportInfo {
    self.end_date = Some(end_date);
    self
  }

  pub fn end_date(&self) -> Option<&String> {
    self.end_date.as_ref()
  }

  pub fn reset_end_date(&mut self) {
    self.end_date = None;
  }

  pub fn set_filters(&mut self, filters: String) {
    self.filters = Some(filters);
  }

  pub fn with_filters(mut self, filters: String) -> ReportInfo {
    self.filters = Some(filters);
    self
  }

  pub fn filters(&self) -> Option<&String> {
    self.filters.as_ref()
  }

  pub fn reset_filters(&mut self) {
    self.filters = None;
  }

  pub fn set_report_name(&mut self, report_name: String) {
    self.report_name = Some(report_name);
  }

  pub fn with_report_name(mut self, report_name: String) -> ReportInfo {
    self.report_name = Some(report_name);
    self
  }

  pub fn report_name(&self) -> Option<&String> {
    self.report_name.as_ref()
  }

  pub fn reset_report_name(&mut self) {
    self.report_name = None;
  }

  pub fn set_start_date(&mut self, start_date: String) {
    self.start_date = Some(start_date);
  }

  pub fn with_start_date(mut self, start_date: String) -> ReportInfo {
    self.start_date = Some(start_date);
    self
  }

  pub fn start_date(&self) -> Option<&String> {
    self.start_date.as_ref()
  }

  pub fn reset_start_date(&mut self) {
    self.start_date = None;
  }

  pub fn set_subject(&mut self, subject: String) {
    self.subject = Some(subject);
  }

  pub fn with_subject(mut self, subject: String) -> ReportInfo {
    self.subject = Some(subject);
    self
  }

  pub fn subject(&self) -> Option<&String> {
    self.subject.as_ref()
  }

  pub fn reset_subject(&mut self) {
    self.subject = None;
  }

  pub fn set_text(&mut self, text: String) {
    self.text = Some(text);
  }

  pub fn with_text(mut self, text: String) -> ReportInfo {
    self.text = Some(text);
    self
  }

  pub fn text(&self) -> Option<&String> {
    self.text.as_ref()
  }

  pub fn reset_text(&mut self) {
    self.text = None;
  }

}



