/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct DataSeriesFilter {
  #[serde(rename = "aggregation")]
  aggregation: Option<String>,
  #[serde(rename = "multiValue")]
  multi_value: Option<bool>,
  #[serde(rename = "values")]
  values: Option<Vec<String>>
}

impl DataSeriesFilter {
  pub fn new() -> DataSeriesFilter {
    DataSeriesFilter {
      aggregation: None,
      multi_value: None,
      values: None
    }
  }

  pub fn set_aggregation(&mut self, aggregation: String) {
    self.aggregation = Some(aggregation);
  }

  pub fn with_aggregation(mut self, aggregation: String) -> DataSeriesFilter {
    self.aggregation = Some(aggregation);
    self
  }

  pub fn aggregation(&self) -> Option<&String> {
    self.aggregation.as_ref()
  }

  pub fn reset_aggregation(&mut self) {
    self.aggregation = None;
  }

  pub fn set_multi_value(&mut self, multi_value: bool) {
    self.multi_value = Some(multi_value);
  }

  pub fn with_multi_value(mut self, multi_value: bool) -> DataSeriesFilter {
    self.multi_value = Some(multi_value);
    self
  }

  pub fn multi_value(&self) -> Option<&bool> {
    self.multi_value.as_ref()
  }

  pub fn reset_multi_value(&mut self) {
    self.multi_value = None;
  }

  pub fn set_values(&mut self, values: Vec<String>) {
    self.values = Some(values);
  }

  pub fn with_values(mut self, values: Vec<String>) -> DataSeriesFilter {
    self.values = Some(values);
    self
  }

  pub fn values(&self) -> Option<&Vec<String>> {
    self.values.as_ref()
  }

  pub fn reset_values(&mut self) {
    self.values = None;
  }

}



