/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct CloudWatchSettings {
  #[serde(rename = "accessKey")]
  access_key: Option<String>,
  #[serde(rename = "fetchFrequency")]
  fetch_frequency: Option<String>,
  #[serde(rename = "region")]
  region: Option<String>,
  #[serde(rename = "secretKey")]
  secret_key: Option<String>
}

impl CloudWatchSettings {
  pub fn new() -> CloudWatchSettings {
    CloudWatchSettings {
      access_key: None,
      fetch_frequency: None,
      region: None,
      secret_key: None
    }
  }

  pub fn set_access_key(&mut self, access_key: String) {
    self.access_key = Some(access_key);
  }

  pub fn with_access_key(mut self, access_key: String) -> CloudWatchSettings {
    self.access_key = Some(access_key);
    self
  }

  pub fn access_key(&self) -> Option<&String> {
    self.access_key.as_ref()
  }

  pub fn reset_access_key(&mut self) {
    self.access_key = None;
  }

  pub fn set_fetch_frequency(&mut self, fetch_frequency: String) {
    self.fetch_frequency = Some(fetch_frequency);
  }

  pub fn with_fetch_frequency(mut self, fetch_frequency: String) -> CloudWatchSettings {
    self.fetch_frequency = Some(fetch_frequency);
    self
  }

  pub fn fetch_frequency(&self) -> Option<&String> {
    self.fetch_frequency.as_ref()
  }

  pub fn reset_fetch_frequency(&mut self) {
    self.fetch_frequency = None;
  }

  pub fn set_region(&mut self, region: String) {
    self.region = Some(region);
  }

  pub fn with_region(mut self, region: String) -> CloudWatchSettings {
    self.region = Some(region);
    self
  }

  pub fn region(&self) -> Option<&String> {
    self.region.as_ref()
  }

  pub fn reset_region(&mut self) {
    self.region = None;
  }

  pub fn set_secret_key(&mut self, secret_key: String) {
    self.secret_key = Some(secret_key);
  }

  pub fn with_secret_key(mut self, secret_key: String) -> CloudWatchSettings {
    self.secret_key = Some(secret_key);
    self
  }

  pub fn secret_key(&self) -> Option<&String> {
    self.secret_key.as_ref()
  }

  pub fn reset_secret_key(&mut self) {
    self.secret_key = None;
  }

}



